/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import no.geosoft.cc.graphics.GInteraction;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;

public class ZoomInteraction
implements GInteraction,
ActionListener {
    private static final double ZOOM_FACTOR = 0.9;
    private final GScene scene_;
    private final GObject interaction_;
    private final GSegment rubberBand_;
    private int[] x_;
    private int[] y_;
    private int x0_;
    private int y0_;
    private Timer timer_;
    private double zoomFactor_;

    public ZoomInteraction(GScene scene, GStyle style) {
        this.scene_ = scene;
        this.interaction_ = new GObject("Interaction");
        if (style == null) {
            style = new GStyle();
            style.setLineWidth(1);
            style.setForegroundColor(new Color(0, 0, 0));
            style.setBackgroundColor(null);
        }
        this.interaction_.setStyle(style);
        this.rubberBand_ = new GSegment();
        this.interaction_.addSegment(this.rubberBand_);
        this.x_ = new int[5];
        this.y_ = new int[5];
    }

    public ZoomInteraction(GScene scene) {
        this(scene, null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.scene_.zoom(this.x0_, this.y0_, this.zoomFactor_);
    }

    @Override
    public void event(GScene scene, int eventType, int x, int y) {
        switch (eventType) {
            case 3: {
                this.x0_ = x;
                this.y0_ = y;
                this.zoomFactor_ = 0.9;
                this.scene_.add(this.interaction_);
                this.timer_ = new Timer(90, this);
                this.timer_.setInitialDelay(500);
                this.timer_.start();
                break;
            }
            case 5: {
                this.interaction_.remove();
                this.rubberBand_.setGeometry((int[])null);
                this.timer_.stop();
                this.timer_.removeActionListener(this);
                int dx = Math.abs(x - this.x0_);
                int dy = Math.abs(x - this.x0_);
                if (dx < 3 || dy < 3) {
                    this.scene_.zoom(x, y, this.zoomFactor_);
                    break;
                }
                this.scene_.zoom(this.x0_, this.y0_, x, y);
                break;
            }
            case 9: {
                this.scene_.unzoom();
                break;
            }
            case 4: {
                this.timer_.stop();
                this.timer_.removeActionListener(this);
                this.x_[0] = this.x0_;
                this.x_[1] = x;
                this.x_[2] = x;
                this.x_[3] = this.x0_;
                this.x_[4] = this.x0_;
                this.y_[0] = this.y0_;
                this.y_[1] = this.y0_;
                this.y_[2] = y;
                this.y_[3] = y;
                this.y_[4] = this.y0_;
                this.rubberBand_.setGeometry(this.x_, this.y_);
                this.scene_.refresh();
                break;
            }
            case 11: {
                this.x0_ = x;
                this.y0_ = y;
                this.zoomFactor_ = 1.1111111111111112;
                this.timer_ = new Timer(90, this);
                this.timer_.setInitialDelay(500);
                this.timer_.start();
                break;
            }
            case 13: {
                this.timer_.stop();
                this.timer_.removeActionListener(this);
                this.scene_.zoom(x, y, this.zoomFactor_);
            }
        }
    }
}

