/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import no.geosoft.cc.geometry.Matrix4x4;
import no.geosoft.cc.graphics.GViewport;
import no.geosoft.cc.graphics.GWorldExtent;

public class GTransformer {
    private final Matrix4x4 world2DeviceMatrix_ = new Matrix4x4();
    private final Matrix4x4 device2WorldMatrix_ = new Matrix4x4();

    GTransformer(GViewport viewport, GWorldExtent worldExtent) {
        this.update(viewport, worldExtent);
    }

    void update(GViewport viewport, GWorldExtent worldExtent) {
        double[] w0 = worldExtent.get(0);
        double[] w1 = worldExtent.get(1);
        double[] w2 = worldExtent.get(2);
        int x0 = viewport.getX0();
        int y0 = viewport.getY0();
        int width = (int)Math.round(viewport.getWidth());
        int height = (int)Math.round(viewport.getHeight());
        this.world2DeviceMatrix_.setWorld2DeviceTransform(w0, w1, w2, x0, y0, width, height);
        this.device2WorldMatrix_.set(this.world2DeviceMatrix_);
        this.device2WorldMatrix_.invert();
    }

    public int[] worldToDevice(double wx, double wy, double wz) {
        double[] world = new double[]{wx, wy, wz};
        return this.worldToDevice(world);
    }

    public int[] worldToDevice(double wx, double wy) {
        double[] world = new double[]{wx, wy, 0.0};
        return this.worldToDevice(world);
    }

    public int[] worldToDevice(double[] world) {
        double[] result = new double[3];
        result = this.world2DeviceMatrix_.transformPoint(world);
        int[] device = new int[]{(int)Math.round(result[0]), (int)Math.round(result[1])};
        return device;
    }

    public double[] deviceToWorld(int x, int y) {
        int[] device = new int[]{x, y};
        return this.deviceToWorld(device);
    }

    public double[] deviceToWorld(int[] device) {
        double[] d = new double[]{device[0], device[1], 1.0};
        return this.device2WorldMatrix_.transformPoint(d);
    }
}

