/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import no.geosoft.cc.geometry.Box;
import no.geosoft.cc.geometry.Rect;
import no.geosoft.cc.geometry.Region;
import no.geosoft.cc.graphics.GCanvas;
import no.geosoft.cc.graphics.GComponent;
import no.geosoft.cc.graphics.GImage;
import no.geosoft.cc.graphics.GPositional;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GStyleListener;
import no.geosoft.cc.graphics.GText;
import no.geosoft.cc.graphics.GTransformer;
import no.geosoft.cc.graphics.GWindow;

public class GObject
implements GStyleListener {
    private static final int FORWARD = -2;
    private static final int BACKWARD = -3;
    public static final int DATA_VISIBLE = 1;
    public static final int ANNOTATION_VISIBLE = 2;
    public static final int SYMBOLS_VISIBLE = 4;
    public static final int WIDGETS_VISIBLE = 8;
    public static final int VISIBLE = 15;
    public static final int DATA_INVISIBLE = 16;
    public static final int ANNOTATION_INVISIBLE = 32;
    public static final int SYMBOLS_INVISIBLE = 64;
    public static final int WIDGETS_INVISIBLE = 128;
    public static final int INVISIBLE = 240;
    private String name_;
    private Region region_;
    private boolean isRegionValid_;
    private GObject parent_;
    private int visibilityMask_;
    private List children_;
    private GStyle style_;
    private GStyle actualStyle_;
    private List segments_;
    private boolean isDrawn_;
    private Object userData_;

    public GObject(String name) {
        this.name_ = name;
        this.parent_ = null;
        this.region_ = new Region();
        this.children_ = new ArrayList();
        this.isRegionValid_ = true;
        this.segments_ = null;
        this.visibilityMask_ = 15;
        this.isDrawn_ = false;
        this.style_ = null;
        this.actualStyle_ = new GStyle();
    }

    public GObject() {
        this(null);
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public GScene getScene() {
        return this.parent_ != null ? this.getParent().getScene() : null;
    }

    public GTransformer getTransformer() {
        GScene scene = this.getScene();
        return scene != null ? scene.getTransformer() : null;
    }

    public GWindow getWindow() {
        GScene scene = this.getScene();
        return scene != null ? scene.getWindow() : null;
    }

    Region getRegion() {
        return this.region_;
    }

    public List getSegments() {
        return this.segments_;
    }

    public GSegment getSegment() {
        return this.segments_ != null && this.segments_.size() > 0 ? (GSegment)this.segments_.get(0) : null;
    }

    public int getVisibility() {
        return this.visibilityMask_;
    }

    public void setUserData(Object userData) {
        this.userData_ = userData;
    }

    public Object getUserData() {
        return this.userData_;
    }

    public GObject find(Object userData) {
        if (this.userData_ == userData) {
            return this;
        }
        for (GObject child : this.children_) {
            GObject found = child.find(userData);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public GSegment findSegment(Object userData) {
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                if (!userData.equals(segment.getUserData())) continue;
                return segment;
            }
        }
        if (this.children_ != null) {
            for (GObject child : this.children_) {
                GSegment segment = child.findSegment(userData);
                if (segment == null) continue;
                return segment;
            }
        }
        return null;
    }

    void computeRegion(int visibilityMask) {
        if ((visibilityMask &= this.visibilityMask_) == 0) {
            return;
        }
        for (GObject child : this.children_) {
            child.computeRegion(visibilityMask);
        }
        if (this instanceof GScene) {
            this.isRegionValid_ = true;
            return;
        }
        if (!this.isRegionValid_) {
            this.region_.clear();
            for (GObject child : this.children_) {
                this.region_.union(child.region_);
            }
            if (this.segments_ != null) {
                for (GSegment segment : this.segments_) {
                    GImage vertextImage;
                    Collection components;
                    Collection images;
                    List texts;
                    if (segment.isVisible()) {
                        this.region_.union(segment.getRectangle());
                    }
                    if ((texts = segment.getTexts()) != null) {
                        for (GPositional text : texts) {
                            this.region_.union(text.getRectangle());
                        }
                    }
                    if ((images = segment.getImages()) != null) {
                        for (GPositional image : images) {
                            this.region_.union(image.getRectangle());
                        }
                    }
                    if ((components = segment.getComponents()) != null) {
                        for (GPositional component : components) {
                            this.region_.union(component.getRectangle());
                        }
                    }
                    if ((vertextImage = segment.getVertexImage()) == null || segment.getNPoints() <= 0) continue;
                    Rect imageRectangle = vertextImage.getRectangle();
                    int[] x = segment.getX();
                    int[] y = segment.getY();
                    for (int j = 0; j < x.length; ++j) {
                        Rect rectangle = new Rect(imageRectangle);
                        rectangle.x += x[j];
                        rectangle.y += y[j];
                        this.region_.union(rectangle);
                    }
                }
            }
            if (this.region_.getNRectangles() > 100) {
                this.region_.collapse();
            }
            this.isRegionValid_ = true;
            if (this.parent_ != null && !(this.parent_ instanceof GScene)) {
                this.parent_.isRegionValid_ = false;
            }
        }
    }

    void flagRegionValid(boolean isValid) {
        this.isRegionValid_ = isValid;
    }

    public void add(GObject child, int position) {
        if (child.parent_ != null) {
            child.parent_.remove(child);
        }
        if (position > this.children_.size()) {
            position = this.children_.size();
        }
        if (position < 0) {
            position = 0;
        }
        this.children_.add(position, child);
        child.parent_ = this;
        child.updateStyle();
        GScene scene = this.getScene();
        if (scene != null) {
            scene.setAnnotationValid(false);
        }
        this.isRegionValid_ = false;
    }

    public void add(GObject child) {
        this.add(child, this.front());
    }

    public void toFront() {
        if (this.parent_ != null) {
            this.parent_.reposition(this, this.parent_.front());
        }
    }

    public void toBack() {
        if (this.parent_ != null) {
            this.parent_.reposition(this, this.parent_.back());
        }
    }

    public void reposition(GObject child, int position) {
        if (position == -2) {
            position = this.getPositionOfChild(child) + 1;
        } else if (position == -3) {
            position = this.getPositionOfChild(child) - 1;
        }
        this.children_.remove(child);
        this.add(child, position);
        this.updateDamage();
    }

    public int behind(GObject child) {
        return this.getPositionOfChild(child);
    }

    public int inFrontOf(GObject child) {
        return this.getPositionOfChild(child) + 1;
    }

    public int front() {
        return this.getNChildren();
    }

    public int back() {
        return 0;
    }

    public int forward() {
        return -2;
    }

    public int backward() {
        return -3;
    }

    private int getPositionOfChild(GObject child) {
        return this.children_.indexOf(child);
    }

    public List getChildren() {
        return this.children_;
    }

    public int getNChildren() {
        return this.children_.size();
    }

    public GObject find(String name) {
        if (this.name_ == null && name == null || this.name_ != null && this.name_.equals(name)) {
            return this;
        }
        for (GObject child : this.children_) {
            GObject foundObject = child.find(name);
            if (foundObject == null) continue;
            return foundObject;
        }
        return null;
    }

    public List findSegments(int x0, int y0, int x1, int y1) {
        ArrayList segments = new ArrayList();
        this.findSegments(x0, y0, x1, y1, segments);
        return segments;
    }

    public List findSegmentsInside(int x0, int y0, int x1, int y1) {
        ArrayList segments = new ArrayList();
        this.findSegmentsInside(x0, y0, x1, y1, segments);
        return segments;
    }

    public GSegment findSegment(int x0, int y0, int x1, int y1) {
        List segments = this.findSegments(x0, y0, x1, y1);
        return segments.size() == 0 ? null : (GSegment)segments.get(segments.size() - 1);
    }

    public GSegment findSegmentInside(int x0, int y0, int x1, int y1) {
        List segments = this.findSegmentsInside(x0, y0, x1, y1);
        return segments.size() == 0 ? null : (GSegment)segments.get(segments.size() - 1);
    }

    public GSegment findSegment(int x, int y) {
        List segments = this.findSegments(x, y);
        return segments.size() == 0 ? null : (GSegment)segments.get(segments.size() - 1);
    }

    public List findSegments(int x, int y) {
        ArrayList segments = new ArrayList();
        this.findSegments(x, y, segments);
        return segments;
    }

    private void findSegments(int x0, int y0, int x1, int y1, List segments) {
        if (!this.region_.isIntersecting(new Rect(x0, y0, x1 - x0 + 1, y1 - y0 + 1))) {
            return;
        }
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                if (!segment.isIntersectingRectangle(x0, y0, x1, y1)) continue;
                segments.add(segment);
            }
        }
        for (GObject child : this.children_) {
            child.findSegments(x0, y0, x1, y1, segments);
        }
    }

    private void findSegments(int x, int y, List segments) {
        if (!this.region_.isInside(x, y)) {
            return;
        }
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                if (!segment.isIntersectingPoint(x, y)) continue;
                segments.add(segment);
            }
        }
        for (GObject child : this.children_) {
            child.findSegments(x, y, segments);
        }
    }

    private void findSegmentsInside(int x0, int y0, int x1, int y1, List segments) {
        if (!this.region_.isIntersecting(new Rect(x0, y0, x1 - x0 + 1, y1 - y0 + 1))) {
            return;
        }
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                if (!segment.isInsideRectangle(x0, y0, x1, y1)) continue;
                segments.add(segment);
            }
        }
        for (GObject child : this.children_) {
            child.findSegmentsInside(x0, y0, x1, y1, segments);
        }
    }

    public GObject find(int x0, int y0, int x1, int y1) {
        List objects = this.findAll(x0, y0, x1, y1);
        return objects.size() == 0 ? null : (GObject)objects.get(objects.size() - 1);
    }

    public GObject findInside(int x0, int y0, int x1, int y1) {
        List objects = this.findAllInside(x0, y0, x1, y1);
        return objects.size() == 0 ? null : (GObject)objects.get(objects.size() - 1);
    }

    public GObject find(int x, int y) {
        return this.find(x - 1, y - 1, x + 1, y + 1);
    }

    public List findAll(int x0, int y0, int x1, int y1) {
        ArrayList objects = new ArrayList();
        this.findAll(x0, y0, x1, y1, objects);
        return objects;
    }

    public List findAllInside(int x0, int y0, int x1, int y1) {
        ArrayList objects = new ArrayList();
        this.findAllInside(x0, y0, x1, y1, objects);
        return objects;
    }

    public List findAll(int x, int y) {
        return this.findAll(x - 1, y - 1, x + 1, y + 1);
    }

    private void findAll(int x0, int y0, int x1, int y1, List objects) {
        if (!this.region_.isIntersecting(new Rect(x0, y0, x1 - x0 + 1, y1 - y0 + 1))) {
            return;
        }
        for (GObject child : this.children_) {
            child.findAll(x0, y0, x1, y1, objects);
        }
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                if (!segment.isIntersectingRectangle(x0, y0, x1, y1)) continue;
                objects.add(this);
                break;
            }
        }
    }

    private void findAllInside(int x0, int y0, int x1, int y1, List objects) {
        Box box = new Box(x0, y0, x1, y1);
        if (!this.region_.isIntersecting(new Rect(box))) {
            return;
        }
        for (GObject child : this.children_) {
            child.findAllInside(x0, y0, x1, y1, objects);
        }
        if (this.region_.isInsideOf(new Rect(box))) {
            objects.add(this);
        }
    }

    public void remove() {
        if (this.parent_ != null) {
            this.parent_.remove(this);
        }
    }

    public void remove(GObject child) {
        child.updateDamage();
        this.children_.remove(child);
        child.parent_ = null;
        GScene scene = this.getScene();
        if (scene != null) {
            scene.setAnnotationValid(false);
        }
        this.isRegionValid_ = false;
    }

    public void removeAll() {
        ArrayList children = new ArrayList(this.children_);
        for (GObject child : children) {
            this.remove(child);
        }
    }

    private int getPosition() {
        if (this.parent_ == null) {
            return -1;
        }
        return this.parent_.children_.indexOf(this);
    }

    public GObject getChild(int position) {
        if (position < 0 || position > this.children_.size() - 1) {
            return null;
        }
        return (GObject)this.children_.get(position);
    }

    public boolean isInFront() {
        return this.parent_ == null ? false : this.getPosition() == this.parent_.getNChildren() - 1;
    }

    public boolean isInBack() {
        return this.parent_ == null ? false : this.getPosition() == 0;
    }

    public GObject getObjectInFront() {
        if (this.parent_ == null) {
            return null;
        }
        if (this.isInFront()) {
            return null;
        }
        int position = this.getPosition();
        return this.parent_.getChild(position + 1);
    }

    public GObject getObjectBehind() {
        if (this.parent_ == null) {
            return null;
        }
        if (this.isInBack()) {
            return null;
        }
        int position = this.getPosition();
        return this.parent_.getChild(position - 1);
    }

    public void addSegment(GSegment segment) {
        if (this.segments_ == null) {
            this.segments_ = new ArrayList();
        }
        if (this.segments_.contains(segment)) {
            return;
        }
        this.segments_.add(segment);
        segment.setOwner(this);
        segment.updateStyle();
    }

    public GSegment getSegment(int segmentNo) {
        int nSegments = this.getNSegments();
        return segmentNo < 0 || segmentNo >= nSegments ? null : (GSegment)this.segments_.get(segmentNo);
    }

    public int getNSegments() {
        return this.segments_ != null ? this.segments_.size() : 0;
    }

    public void removeSegment(GSegment segment) {
        GScene scene;
        if (segment.getOwner() != this) {
            return;
        }
        Region region = segment.getRegion();
        GWindow window = this.getWindow();
        if (window != null) {
            window.updateDamageArea(region);
        }
        if (segment.getTexts() != null && (scene = this.getScene()) != null) {
            scene.setAnnotationValid(false);
        }
        this.segments_.remove(segment);
        segment.setOwner(null);
        if (this.segments_.size() == 0) {
            this.segments_ = null;
        }
        this.isRegionValid_ = false;
    }

    public void removeSegment(int segmentNo) {
        GSegment segment = this.getSegment(segmentNo);
        if (segment != null) {
            this.removeSegment(segment);
        }
    }

    public void removeSegments() {
        while (this.segments_ != null) {
            this.removeSegment(0);
        }
    }

    public void removeSegments(int from, int to) {
        if (this.segments_ == null || from >= this.segments_.size()) {
            return;
        }
        if (from < 0) {
            from = 0;
        }
        if (to >= this.segments_.size() || to == -1) {
            to = this.segments_.size() - 1;
        }
        if (to < 0) {
            to = 0;
        }
        int nSegments = from - to + 1;
        for (int i = 0; i < nSegments; ++i) {
            this.removeSegment(from);
        }
        this.isRegionValid_ = false;
    }

    public void removeSegments(int from) {
        this.removeSegments(from, -1);
    }

    void refreshData(int visibilityMask) {
        if (((visibilityMask &= this.visibilityMask_) & 1) == 0) {
            return;
        }
        if (!this.region_.isIntersecting(this.getWindow().getDamageRegion())) {
            return;
        }
        if (this.segments_ != null) {
            GCanvas canvas = (GCanvas)this.getWindow().getCanvas();
            for (GSegment segment : this.segments_) {
                Collection images;
                if (!segment.isVisible()) continue;
                canvas.render(segment.getX(), segment.getY(), segment.getActualStyle());
                GImage vertexImage = segment.getVertexImage();
                if (vertexImage != null) {
                    canvas.render(segment.getX(), segment.getY(), vertexImage);
                }
                if ((images = segment.getImages()) == null) continue;
                for (GImage image : images) {
                    if (image == null || !image.isVisible()) continue;
                    canvas.render(image);
                }
            }
        }
        for (GObject child : this.children_) {
            child.refreshData(visibilityMask);
        }
    }

    void refreshAnnotation(int visibilityMask) {
        if (((visibilityMask &= this.visibilityMask_) & 2) == 0) {
            return;
        }
        if (!this.region_.isIntersecting(this.getWindow().getDamageRegion())) {
            return;
        }
        if (this.segments_ != null) {
            GCanvas canvas = (GCanvas)this.getWindow().getCanvas();
            for (GSegment segment : this.segments_) {
                List texts;
                if (!segment.isVisible() || (texts = segment.getTexts()) == null) continue;
                for (GText text : texts) {
                    if (text == null || !text.isVisible()) continue;
                    canvas.render(text, text.getActualStyle());
                }
            }
        }
        for (GObject child : this.children_) {
            child.refreshAnnotation(visibilityMask);
        }
    }

    void refreshComponents(int visibilityMask) {
        if (((visibilityMask &= this.visibilityMask_) & 8) == 0) {
            return;
        }
        if (!this.region_.isIntersecting(this.getWindow().getDamageRegion())) {
            return;
        }
        if (this.segments_ != null) {
            GCanvas canvas = (GCanvas)this.getWindow().getCanvas();
            for (GSegment segment : this.segments_) {
                Collection components;
                if (!segment.isVisible() || (components = segment.getComponents()) == null) continue;
                for (GComponent component : components) {
                    canvas.render(component);
                }
            }
        }
        for (GObject child : this.children_) {
            child.refreshComponents(visibilityMask);
        }
    }

    protected void redraw(int visibilityMask) {
        this.isDrawn_ = false;
        if ((visibilityMask &= this.visibilityMask_) == 0) {
            return;
        }
        if (this instanceof GScene) {
            GScene scene = (GScene)this;
            scene.setAnnotationValid(false);
        }
        for (GObject child : this.children_) {
            child.redraw(visibilityMask);
        }
        this.draw();
        this.computeImagePositions();
        this.isDrawn_ = true;
    }

    public void redraw() {
        this.redraw(this.getVisibility());
    }

    public void setStyle(GStyle style) {
        if (this.style_ != null) {
            this.style_.removeListener(this);
        }
        this.style_ = style;
        if (this.style_ != null) {
            this.style_.addListener(this);
        }
        this.updateStyle();
    }

    public GStyle getStyle() {
        return this.style_;
    }

    GStyle getActualStyle() {
        return this.actualStyle_;
    }

    private void updateStyle() {
        this.actualStyle_ = new GStyle();
        if (this.parent_ != null) {
            this.actualStyle_.update(this.parent_.getActualStyle());
        }
        if (this.style_ != null) {
            this.actualStyle_.update(this.style_);
        }
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                segment.updateStyle();
            }
        }
        for (GObject child : this.children_) {
            child.updateStyle();
        }
    }

    public void setVisibility(int visibilityMask) {
        int oldVisibilityMask = this.visibilityMask_;
        if ((visibilityMask & 1) != 0) {
            this.visibilityMask_ |= 1;
        }
        if ((visibilityMask & 2) != 0) {
            this.visibilityMask_ |= 2;
        }
        if ((visibilityMask & 4) != 0) {
            this.visibilityMask_ |= 4;
        }
        if ((visibilityMask & 8) != 0) {
            this.visibilityMask_ |= 8;
        }
        if ((visibilityMask & 0x10) != 0) {
            this.visibilityMask_ &= 0xFFFFFFFE;
        }
        if ((visibilityMask & 0x20) != 0) {
            this.visibilityMask_ &= 0xFFFFFFFD;
        }
        if ((visibilityMask & 0x40) != 0) {
            this.visibilityMask_ &= 0xFFFFFFFB;
        }
        if ((visibilityMask & 0x80) != 0) {
            this.visibilityMask_ &= 0xFFFFFFF7;
        }
        if (oldVisibilityMask == this.visibilityMask_) {
            return;
        }
        if (this.visibilityMask_ != 0 && !this.isDrawn_) {
            this.redraw(this.visibilityMask_);
        }
        if ((oldVisibilityMask & 4) != (this.visibilityMask_ & 4)) {
            this.changeSymbolVisibility();
        }
        if ((oldVisibilityMask & 8) != (this.visibilityMask_ & 8)) {
            this.changeWidgetVisibility();
        }
        if ((oldVisibilityMask & 2) != (this.visibilityMask_ & 2)) {
            GScene scene = this.getScene();
            if (scene != null) {
                scene.setAnnotationValid(false);
            }
            if (this.children_.size() > 0 || this.getNSegments() > 0) {
                this.updateDamage();
            }
        }
        if ((oldVisibilityMask & 1) != (this.visibilityMask_ & 1)) {
            if ((visibilityMask & 1) != 0) {
                this.getWindow().computeRegion();
            }
            this.updateDamage();
        }
    }

    private void changeSymbolVisibility() {
    }

    private void changeWidgetVisibility() {
    }

    void computeTextPositions() {
        GScene scene = this.getScene();
        if (scene == null) {
            return;
        }
        if ((this.visibilityMask_ & 2) == 0) {
            return;
        }
        for (GObject child : this.children_) {
            child.computeTextPositions();
        }
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                List texts = segment.getTexts();
                scene.computePositions(texts);
            }
        }
    }

    void computeComponentPositions() {
        GScene scene = this.getScene();
        if (scene == null) {
            return;
        }
        if ((this.visibilityMask_ & 8) == 0) {
            return;
        }
        for (GObject child : this.children_) {
            child.computeComponentPositions();
        }
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                Collection components = segment.getComponents();
                scene.computePositions(components);
            }
        }
    }

    void computeImagePositions() {
        GScene scene = this.getScene();
        if (scene == null) {
            return;
        }
        if (this.segments_ != null) {
            for (GSegment segment : this.segments_) {
                Collection images = segment.getImages();
                scene.computePositions(images);
                GImage vertexImage = segment.getVertexImage();
                if (vertexImage == null) continue;
                scene.computeVertexPositions(vertexImage);
            }
        }
        for (GObject child : this.children_) {
            child.computeImagePositions();
        }
    }

    private void updateDamage() {
        GWindow window = this.getWindow();
        if (window != null) {
            window.updateDamageArea(this.region_);
        }
    }

    public GObject getParent() {
        return this.parent_;
    }

    public void refresh() {
        GWindow window = this.getWindow();
        if (window != null) {
            window.refresh();
        }
    }

    public void draw() {
    }

    @Override
    public void styleChanged(GStyle style) {
        this.updateStyle();
        this.updateDamage();
    }

    public String toString() {
        return "GObject: " + this.name_;
    }
}

