/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import no.geosoft.cc.graphics.GPositional;
import no.geosoft.cc.graphics.GWindow;

public class GImage
extends GPositional {
    public static final int SYMBOL_SQUARE1 = 1;
    public static final int SYMBOL_SQUARE2 = 2;
    public static final int SYMBOL_SQUARE3 = 3;
    public static final int SYMBOL_SQUARE4 = 4;
    public static final int SYMBOL_CIRCLE1 = 5;
    public static final int SYMBOL_CIRCLE2 = 6;
    public static final int SYMBOL_CIRCLE3 = 7;
    public static final int SYMBOL_CIRCLE4 = 8;
    private static final int DEFAULT_POSITION_HINT = 262400;
    private Image image_;
    private int[] imageData_;
    private File file_;

    public GImage(int symbolType, int positionHint) {
        super(positionHint, true);
        int height;
        int width;
        this.initialize();
        switch (symbolType) {
            case 1: {
                width = 5;
                height = 5;
                break;
            }
            case 2: {
                width = 7;
                height = 7;
                break;
            }
            case 3: {
                width = 9;
                height = 9;
                break;
            }
            case 4: {
                width = 11;
                height = 11;
                break;
            }
            default: {
                return;
            }
        }
        int[] data = new int[width * height];
        switch (symbolType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                for (int i = 0; i < data.length; ++i) {
                    data[i] = 1;
                }
                break;
            }
        }
        this.setImage(width, height, data);
    }

    public GImage(int symbolType) {
        this(symbolType, 262400);
    }

    public GImage(int width, int height, int[] data, int positionHint) {
        super(positionHint, true);
        this.initialize();
        this.setImage(width, height, data);
    }

    public GImage(int width, int height, int[] data) {
        this(width, height, data, 262400);
    }

    private GWindow getWindow() {
        return this.getSegment().getOwner().getWindow();
    }

    public GImage(Image image, int positionHint) {
        super(positionHint, true);
        this.initialize();
        this.image_ = image;
    }

    public GImage(Image image) {
        this(image, 262400);
    }

    public GImage(File file, int positionHint) {
        super(positionHint, true);
        this.initialize();
        this.file_ = file;
    }

    public GImage(File file) {
        this(file, 262400);
    }

    private void initialize() {
        this.imageData_ = null;
        this.image_ = null;
    }

    private void setImage(int width, int height, int[] data) {
        this.rectangle_.width = width;
        this.rectangle_.height = height;
        int size = width * height;
        this.imageData_ = new int[size];
        for (int i = 0; i < size; ++i) {
            this.imageData_[i] = data != null && data.length > i ? data[i] : 0;
        }
        this.imageData_ = data;
    }

    @Override
    void computeSize() {
        if (this.image_ != null && this.rectangle_.width == 0 && this.rectangle_.height == 0) {
            this.rectangle_.width = this.image_.getWidth(this.getWindow().getCanvas());
            this.rectangle_.height = this.image_.getHeight(this.getWindow().getCanvas());
        } else if (this.image_ == null && this.file_ != null) {
            try {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.file_.getPath()));
                BufferedImage image = ImageIO.read(stream);
                this.rectangle_.height = image.getHeight();
                this.rectangle_.width = image.getWidth();
                this.image_ = image;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.image_ = null;
                this.file_ = null;
                this.rectangle_.height = 0;
                this.rectangle_.width = 0;
            }
        }
    }

    Image getImage() {
        if (this.image_ == null && this.imageData_ != null) {
            int width = this.rectangle_.width;
            int height = this.rectangle_.height;
            int backgroundColor = this.actualStyle_.getBackgroundColor().getRGB();
            int foregroundColor = this.actualStyle_.getForegroundColor().getRGB();
            BufferedImage image = new BufferedImage(width, height, 2);
            int pointNo = 0;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    image.setRGB(i, j, this.imageData_[pointNo] == 0 ? backgroundColor : foregroundColor);
                    ++pointNo;
                }
            }
            this.image_ = image;
        }
        return this.image_;
    }
}

