/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.geometry;

import no.geosoft.cc.geometry.Box;

public class Rect {
    public int x;
    public int y;
    public int height;
    public int width;

    public Rect(int x, int y, int width, int height) {
        this.set(x, y, width, height);
    }

    public Rect() {
        this(0, 0, 0, 0);
    }

    public Rect(Rect rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rect(Box box) {
        this(box.x1, box.y1, box.x2 - box.x1, box.y2 - box.y1);
    }

    public void copy(Rect rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public Object clone() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    public boolean equals(Object object) {
        Rect rectangle = (Rect)object;
        return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public void expand(int dx, int dy) {
        this.x -= dx;
        this.y -= dy;
        this.width += dx + dx;
        this.height += dy + dy;
    }

    public void set(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void set(int[] xArray, int[] yArray) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < xArray.length; ++i) {
            if (xArray[i] < minX) {
                minX = xArray[i];
            }
            if (xArray[i] > maxX) {
                maxX = xArray[i];
            }
            if (yArray[i] < minY) {
                minY = yArray[i];
            }
            if (yArray[i] <= maxY) continue;
            maxY = yArray[i];
        }
        this.x = minX;
        this.y = minY;
        this.width = maxX - minX + 1;
        this.height = maxY - minY + 1;
    }

    public int getCenterX() {
        return this.x + (int)Math.floor((double)this.width / 2.0);
    }

    public int getCenterY() {
        return this.y + (int)Math.floor((double)this.height / 2.0);
    }

    public String toString() {
        return new String("Rectangle: x= " + this.x + " y=" + this.y + " width=" + this.width + " height=" + this.height);
    }
}

