/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.geometry;

public final class Geometry {
    private static boolean isBetween(int a, int b, int c) {
        return b > a ? c >= a && c <= b : c >= b && c <= a;
    }

    private static boolean isBetween(double a, double b, double c) {
        return b > a ? c >= a && c <= b : c >= b && c <= a;
    }

    private static boolean equals(double a, double b, double limit) {
        return Math.abs(a - b) < limit;
    }

    private static boolean equals(double a, double b) {
        return Geometry.equals(a, b, 1.0E-5);
    }

    private static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    private static double max(double a, double b, double c, double d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static boolean isPointInsideRectangle(int x0, int y0, int x1, int y1, int x, int y) {
        return x >= x0 && x < x1 && y >= y0 && y < y1;
    }

    public static boolean isPointInsidePolygon(double[] x, double[] y, double pointX, double pointY) {
        boolean isInside = false;
        int nPoints = x.length;
        int j = 0;
        for (int i = 0; i < nPoints; ++i) {
            if (++j == nPoints) {
                j = 0;
            }
            if (!(y[i] < pointY && y[j] >= pointY) && (!(y[j] < pointY) || !(y[i] >= pointY)) || !(x[i] + (pointY - y[i]) / (y[j] - y[i]) * (x[j] - x[i]) < pointX)) continue;
            isInside = !isInside;
        }
        return isInside;
    }

    public static boolean isPointInsidePolygon(int[] x, int[] y, int pointX, int pointY) {
        boolean isInside = false;
        int nPoints = x.length;
        int j = 0;
        for (int i = 0; i < nPoints; ++i) {
            if (++j == nPoints) {
                j = 0;
            }
            if ((y[i] >= pointY || y[j] < pointY) && (y[j] >= pointY || y[i] < pointY) || !((double)x[i] + (double)(pointY - y[i]) / (double)(y[j] - y[i]) * (double)(x[j] - x[i]) < (double)pointX)) continue;
            isInside = !isInside;
        }
        return isInside;
    }

    public static double[] computePointOnLine(double[] p0, double[] p1, double fractionFromP0) {
        double[] p = new double[]{p0[0] + fractionFromP0 * (p1[0] - p0[0]), p0[1] + fractionFromP0 * (p1[1] - p0[1]), p0[2] + fractionFromP0 * (p1[2] - p0[2])};
        return p;
    }

    public static double[] computePointOnLine(double x0, double y0, double x1, double y1, double fractionFrom0) {
        double[] p0 = new double[]{x0, y0, 0.0};
        double[] p1 = new double[]{x1, y1, 0.0};
        double[] p = Geometry.computePointOnLine(p0, p1, fractionFrom0);
        double[] r = new double[]{p[0], p[1]};
        return r;
    }

    public static void extendLine(double[] p0, double[] p1, double toLength, double anchor) {
        double[] p = Geometry.computePointOnLine(p0, p1, anchor);
        double length0 = toLength * anchor;
        double length1 = toLength * (1.0 - anchor);
        Geometry.extendLine(p, p0, length0);
        Geometry.extendLine(p, p1, length1);
    }

    public static void extendLine(double[] p0, double[] p1, double toLength) {
        double oldLength = Geometry.length(p0, p1);
        double lengthFraction = oldLength != 0.0 ? toLength / oldLength : 0.0;
        p1[0] = p0[0] + (p1[0] - p0[0]) * lengthFraction;
        p1[1] = p0[1] + (p1[1] - p0[1]) * lengthFraction;
        p1[2] = p0[2] + (p1[2] - p0[2]) * lengthFraction;
    }

    public static double length(double[] v) {
        return Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static double length(double[] p0, double[] p1) {
        double[] v = Geometry.createVector(p0, p1);
        return Geometry.length(v);
    }

    public static double length(int x0, int y0, int x1, int y1) {
        return Geometry.length((double)x0, (double)y0, (double)x1, (double)y1);
    }

    public static double length(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double length(int[] x, int[] y, boolean isClosed) {
        double length = 0.0;
        int nPoints = x.length;
        for (int i = 0; i < nPoints - 1; ++i) {
            length += Geometry.length(x[i], y[i], x[i + 1], y[i + 1]);
        }
        if (isClosed && nPoints > 1) {
            length += Geometry.length(x[nPoints - 1], y[nPoints - 1], x[0], y[0]);
        }
        return length;
    }

    public static double distance(int x0, int y0, int x1, int y1, int x, int y) {
        double length = Geometry.length(x0, y0, x1, y1);
        if (length == 0.0) {
            return Geometry.length(x0, y0, x, y);
        }
        double u = (double)((x - x0) * (x1 - x0) + (y - y0) * (y1 - y0)) / (length * length);
        double xp = (double)x0 + u * (double)(x1 - x0);
        double yp = (double)y0 + u * (double)(y1 - y0);
        length = Geometry.length(xp, yp, (double)x, (double)y);
        return length;
    }

    public static double computeAngle(double[] p0, double[] p1, double[] p2) {
        double length2;
        double[] v0 = Geometry.createVector(p0, p1);
        double[] v1 = Geometry.createVector(p0, p2);
        double dotProduct = Geometry.computeDotProduct(v0, v1);
        double length1 = Geometry.length(v0);
        double denominator = length1 * (length2 = Geometry.length(v1));
        double product = denominator != 0.0 ? dotProduct / denominator : 0.0;
        double angle = Math.acos(product);
        return angle;
    }

    public static double computeDotProduct(double[] v0, double[] v1) {
        return v0[0] * v1[0] + v0[1] * v1[1] + v0[2] * v1[2];
    }

    public static double[] computeCrossProduct(double[] v0, double[] v1) {
        double[] crossProduct = new double[]{v0[1] * v1[2] - v0[2] * v1[1], v0[2] * v1[0] - v0[0] * v1[2], v0[0] * v1[1] - v0[1] * v1[0]};
        return crossProduct;
    }

    public static double[] createVector(double[] p0, double[] p1) {
        double[] v = new double[]{p1[0] - p0[0], p1[1] - p0[1], p1[2] - p0[2]};
        return v;
    }

    private static int sameSide(double x0, double y0, double x1, double y1, double px0, double py0, double px1, double py1) {
        int sameSide = 0;
        double dx = x1 - x0;
        double dy = y1 - y0;
        double dx1 = px0 - x0;
        double dy1 = py0 - y0;
        double dx2 = px1 - x1;
        double dy2 = py1 - y1;
        double c1 = dx * dy1 - dy * dx1;
        double c2 = dx * dy2 - dy * dx2;
        if (c1 != 0.0 && c2 != 0.0) {
            sameSide = c1 < 0.0 != c2 < 0.0 ? -1 : 1;
        } else if (dx == 0.0 && dx1 == 0.0 && dx2 == 0.0) {
            sameSide = !Geometry.isBetween(y0, y1, py0) && !Geometry.isBetween(y0, y1, py1) ? 1 : 0;
        } else if (dy == 0.0 && dy1 == 0.0 && dy2 == 0.0) {
            sameSide = !Geometry.isBetween(x0, x1, px0) && !Geometry.isBetween(x0, x1, px1) ? 1 : 0;
        }
        return sameSide;
    }

    private static int sameSide(int x0, int y0, int x1, int y1, int px0, int py0, int px1, int py1) {
        return Geometry.sameSide((double)x0, (double)y0, (double)x1, (double)y1, (double)px0, (double)py0, (double)px1, (double)py1);
    }

    public static boolean isLineIntersectingLine(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3) {
        int s1 = Geometry.sameSide(x0, y0, x1, y1, x2, y2, x3, y3);
        int s2 = Geometry.sameSide(x2, y2, x3, y3, x0, y0, x1, y1);
        return s1 <= 0 && s2 <= 0;
    }

    public static boolean isLineIntersectingRectangle(int lx0, int ly0, int lx1, int ly1, int x0, int y0, int x1, int y1) {
        if (Geometry.isPointInsideRectangle(x0, y0, x1, y1, lx0, ly0) || Geometry.isPointInsideRectangle(x0, y0, x1, y1, lx1, ly1)) {
            return true;
        }
        if (Geometry.isLineIntersectingLine(lx0, ly0, lx1, ly1, x0, y0, x1, y0)) {
            return true;
        }
        if (Geometry.isLineIntersectingLine(lx0, ly0, lx1, ly1, x0, y0, x0, y1)) {
            return true;
        }
        return Geometry.isLineIntersectingLine(lx0, ly0, lx1, ly1, x0, y1, x1, y1);
    }

    public static boolean isPolylineIntersectingRectangle(int[] x, int[] y, int x0, int y0, int x1, int y1) {
        if (x.length == 0) {
            return false;
        }
        if (Geometry.isPointInsideRectangle(x[0], y[0], x0, y0, x1, y1)) {
            return true;
        }
        if (x.length == 1) {
            return false;
        }
        for (int i = 1; i < x.length; ++i) {
            if (x[i - 1] == x[i] && y[i - 1] == y[i] || !Geometry.isLineIntersectingRectangle(x[i - 1], y[i - 1], x[i], y[i], x0, y0, x1, y1)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPolygonIntersectingRectangle(int[] x, int[] y, int x0, int y0, int x1, int y1) {
        int n = x.length;
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            return Geometry.isPointInsideRectangle(x0, y0, x1, y1, x[0], y[0]);
        }
        if (Geometry.isPolylineIntersectingRectangle(x, y, x0, y0, x1, y1)) {
            return true;
        }
        if (Geometry.isLineIntersectingRectangle(x[n - 2], y[n - 2], x[n - 1], y[n - 1], x0, y0, x1, y1)) {
            return true;
        }
        return Geometry.isPointInsidePolygon(x, y, x0, y0) || Geometry.isPointInsideRectangle(x0, y0, x1, y1, x[0], y[0]);
    }

    public static double computePolygonArea(double[] x, double[] y) {
        int n = x.length;
        double area = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            area += x[i] * y[i + 1] - x[i + 1] * y[i];
        }
        area += x[n - 1] * y[0] - x[0] * y[n - 1];
        return area *= 0.5;
    }

    public static double computePolygonArea(double[] xy) {
        int n = xy.length;
        double area = 0.0;
        for (int i = 0; i < n - 2; i += 2) {
            area += xy[i] * xy[i + 3] - xy[i + 2] * xy[i + 1];
        }
        area += xy[xy.length - 2] * xy[1] - xy[0] * xy[xy.length - 1];
        return area *= 0.5;
    }

    public static double[] computePolygonCentroid(double[] x, double[] y) {
        double cx = 0.0;
        double cy = 0.0;
        int n = x.length;
        for (int i = 0; i < n - 1; ++i) {
            double a = x[i] * y[i + 1] - x[i + 1] * y[i];
            cx += (x[i] + x[i + 1]) * a;
            cy += (y[i] + y[i + 1]) * a;
        }
        double a = x[n - 1] * y[0] - x[0] * y[n - 1];
        cx += (x[n - 1] + x[0]) * a;
        cy += (y[n - 1] + y[0]) * a;
        double area = Geometry.computePolygonArea(x, y);
        return new double[]{cx /= 6.0 * area, cy /= 6.0 * area};
    }

    public static void findPolygonExtent(double[] x, double[] y, double[] z, double[] xExtent, double[] yExtent, double[] zExtent) {
        double xMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMin = Double.MAX_VALUE;
        double yMax = -1.7976931348623157E308;
        double zMin = Double.MAX_VALUE;
        double zMax = -1.7976931348623157E308;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] < xMin) {
                xMin = x[i];
            }
            if (x[i] > xMax) {
                xMax = x[i];
            }
            if (y[i] < yMin) {
                yMin = y[i];
            }
            if (y[i] > yMax) {
                yMax = y[i];
            }
            if (z == null) continue;
            if (z[i] < zMin) {
                zMin = z[i];
            }
            if (!(z[i] > zMax)) continue;
            zMax = z[i];
        }
        xExtent[0] = xMin;
        xExtent[1] = xMax;
        yExtent[0] = yMin;
        yExtent[1] = yMax;
        if (z != null) {
            zExtent[0] = zMin;
            zExtent[1] = zMax;
        }
    }

    public static void findPolygonExtent(int[] x, int[] y, int[] xExtent, int[] yExtent) {
        int xMin = Integer.MAX_VALUE;
        int xMax = -2147483647;
        int yMin = Integer.MAX_VALUE;
        int yMax = -2147483647;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] < xMin) {
                xMin = x[i];
            }
            if (x[i] > xMax) {
                xMax = x[i];
            }
            if (y[i] < yMin) {
                yMin = y[i];
            }
            if (y[i] <= yMax) continue;
            yMax = y[i];
        }
        xExtent[0] = xMin;
        xExtent[1] = xMax;
        yExtent[0] = yMin;
        yExtent[1] = yMax;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int findLineSegmentIntersection(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double[] intersection) {
        double distanceFrom1;
        double y;
        double x;
        double LIMIT = 1.0E-5;
        double INFINITY = 1.0E10;
        double a0 = Geometry.equals(x0, x1, 1.0E-5) ? 1.0E10 : (y0 - y1) / (x0 - x1);
        double a1 = Geometry.equals(x2, x3, 1.0E-5) ? 1.0E10 : (y2 - y3) / (x2 - x3);
        double b0 = y0 - a0 * x0;
        double b1 = y2 - a1 * x2;
        if (Geometry.equals(a0, a1)) {
            double x4;
            double y4;
            if (!Geometry.equals(b0, b1)) {
                return -1;
            }
            if (Geometry.equals(x0, x1)) {
                if (!(Math.min(y0, y1) < Math.max(y2, y3))) {
                    if (!(Math.max(y0, y1) > Math.min(y2, y3))) return -1;
                }
                double twoMiddle = y0 + y1 + y2 + y3 - Geometry.min(y0, y1, y2, y3) - Geometry.max(y0, y1, y2, y3);
                y4 = twoMiddle / 2.0;
                x4 = (y4 - b0) / a0;
            } else {
                if (!(Math.min(x0, x1) < Math.max(x2, x3))) {
                    if (!(Math.max(x0, x1) > Math.min(x2, x3))) return -1;
                }
                double twoMiddle = x0 + x1 + x2 + x3 - Geometry.min(x0, x1, x2, x3) - Geometry.max(x0, x1, x2, x3);
                x4 = twoMiddle / 2.0;
                y4 = a0 * x4 + b0;
            }
            intersection[0] = x4;
            intersection[1] = y4;
            return -2;
        }
        if (Geometry.equals(a0, 1.0E10)) {
            x = x0;
            y = a1 * x + b1;
        } else if (Geometry.equals(a1, 1.0E10)) {
            x = x2;
            y = a0 * x + b0;
        } else {
            x = -(b0 - b1) / (a0 - a1);
            y = a0 * x + b0;
        }
        intersection[0] = x;
        intersection[1] = y;
        if (Geometry.equals(x0, x1)) {
            distanceFrom1 = y0 < y1 ? (y < y0 ? Geometry.length(x, y, x0, y0) : (y > y1 ? Geometry.length(x, y, x1, y1) : 0.0)) : (y < y1 ? Geometry.length(x, y, x1, y1) : (y > y0 ? Geometry.length(x, y, x0, y0) : 0.0));
        } else if (x0 < x1) {
            distanceFrom1 = x < x0 ? Geometry.length(x, y, x0, y0) : (x > x1 ? Geometry.length(x, y, x1, y1) : 0.0);
        } else {
            double d = x < x1 ? Geometry.length(x, y, x1, y1) : (distanceFrom1 = x > x0 ? Geometry.length(x, y, x0, y0) : 0.0);
        }
        double distanceFrom2 = Geometry.equals(x2, x3) ? (y2 < y3 ? (y < y2 ? Geometry.length(x, y, x2, y2) : (y > y3 ? Geometry.length(x, y, x3, y3) : 0.0)) : (y < y3 ? Geometry.length(x, y, x3, y3) : (y > y2 ? Geometry.length(x, y, x2, y2) : 0.0))) : (x2 < x3 ? (x < x2 ? Geometry.length(x, y, x2, y2) : (x > x3 ? Geometry.length(x, y, x3, y3) : 0.0)) : (x < x3 ? Geometry.length(x, y, x3, y3) : (x > x2 ? Geometry.length(x, y, x2, y2) : 0.0)));
        if (!Geometry.equals(distanceFrom1, 0.0)) return 0;
        if (!Geometry.equals(distanceFrom2, 0.0)) return 0;
        return 1;
    }

    public static double[] findLinePolygonIntersections(double[] x, double[] y, double x0, double y0, double x1, double y1) {
        int nPoints = x.length;
        int nIntersections = 0;
        double[] intersections = new double[24];
        double[] intersection = new double[2];
        for (int i = 0; i < nPoints; ++i) {
            int next = i == nPoints - 1 ? 0 : i + 1;
            double x2 = x[i];
            double y2 = y[i];
            double x3 = x[next];
            double y3 = y[next];
            boolean isIntersecting = false;
            if (Geometry.equals(x2, x3) && Geometry.equals(y2, y3)) continue;
            int type = Geometry.findLineSegmentIntersection(x0, y0, x1, y1, x2, y2, x3, y3, intersection);
            if (type == -2) {
                int p2;
                int p1 = i == 0 ? nPoints - 1 : i - 1;
                int side = Geometry.sameSide(x0, y0, x1, y1, x[p1], y[p1], x[p2 = next == nPoints - 1 ? 0 : next + 1], y[p2]);
                if (side < 0) {
                    isIntersecting = true;
                }
            } else if (type == 1) {
                isIntersecting = true;
            }
            if (!isIntersecting) continue;
            if (nIntersections << 1 == intersections.length) {
                double[] newArray = new double[nIntersections << 2];
                System.arraycopy(intersections, 0, newArray, 0, intersections.length);
                intersections = newArray;
            }
            intersections[nIntersections << 1] = intersection[0];
            intersections[nIntersections << 2] = intersection[1];
            ++nIntersections;
        }
        if (nIntersections == 0) {
            return null;
        }
        double[] finalArray = new double[nIntersections << 2];
        System.arraycopy(intersections, 0, finalArray, 0, finalArray.length);
        return finalArray;
    }

    public static int[] createEllipse(int[] x, int[] y) {
        int x0 = (x[0] + x[2]) / 2;
        int y0 = (y[0] + y[2]) / 2;
        double[] p0 = new double[]{x0, y0, 0.0};
        double[] p1 = new double[]{x[0], y[0], 0.0};
        double[] p2 = new double[]{x[1], y[1], 0.0};
        double axisAngle = Geometry.computeAngle(p0, p1, p2);
        double dx = Geometry.length(x0, y0, x[1], y[1]);
        double dy = Geometry.length(x0, y0, x[0], y[0]) * Math.sin(axisAngle);
        int[] ellipse = Geometry.createEllipse(x0, y0, (int)Math.round(dx), (int)Math.round(dy));
        int nPoints = ellipse.length / 2;
        if (!(Geometry.equals(axisAngle, 1.5707963267948966, 0.1) || Geometry.equals(axisAngle, Math.PI, 0.1) || Geometry.equals(axisAngle, 0.0, 0.1))) {
            double xShear = 1.0 / Math.tan(axisAngle);
            for (int i = 0; i < nPoints; ++i) {
                int n = i * 2 + 0;
                ellipse[n] = (int)((long)ellipse[n] + Math.round((double)(ellipse[i * 2 + 1] - y0) * xShear));
            }
        }
        int ddx = x[1] - x0;
        int ddy = y0 - y[1];
        double angle = ddx == 0 && ddy == 0 ? 0.0 : (ddx == 0 ? 1.5707963267948966 : Math.atan((double)ddy / (double)ddx));
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        for (int i = 0; i < nPoints; ++i) {
            int xr = (int)Math.round((double)x0 + (double)(ellipse[i * 2 + 0] - x0) * cosAngle - (double)(ellipse[i * 2 + 1] - y0) * sinAngle);
            int yr = (int)Math.round((double)y0 - (double)(ellipse[i * 2 + 1] - y0) * cosAngle - (double)(ellipse[i * 2 + 0] - x0) * sinAngle);
            ellipse[i * 2 + 0] = xr;
            ellipse[i * 2 + 1] = yr;
        }
        return ellipse;
    }

    public static int[] createEllipse(int x0, int y0, int dx, int dy) {
        int nPoints;
        int n = nPoints = (dx = Math.abs(dx)) > (dy = Math.abs(dy)) ? dx : dy;
        if ((nPoints /= 2) < 1) {
            nPoints = 1;
        }
        int[] ellipse = new int[nPoints * 8 + 2];
        int dxdy = dx * dy;
        int dx2 = dx * dx;
        int dy2 = dy * dy;
        ellipse[nPoints * 0 + 0] = x0 + dx;
        ellipse[nPoints * 0 + 1] = y0;
        ellipse[nPoints * 8 + 0] = x0 + dx;
        ellipse[nPoints * 8 + 1] = y0;
        ellipse[nPoints * 2 + 0] = x0;
        ellipse[nPoints * 2 + 1] = y0 - dy;
        ellipse[nPoints * 4 + 0] = x0 - dx;
        ellipse[nPoints * 4 + 1] = y0;
        ellipse[nPoints * 6 + 0] = x0;
        ellipse[nPoints * 6 + 1] = y0 + dy;
        double angleStep = nPoints > 0 ? 1.5707963267948966 / (double)nPoints : 0.0;
        double a = 0.0;
        for (int i = 1; i < nPoints; ++i) {
            double t = Math.tan(a += angleStep);
            double x = (double)dxdy / Math.sqrt(t * t * (double)dx2 + (double)dy2);
            double y = x * t;
            int xi = (int)(x + 0.5);
            int yi = (int)(y + 0.5);
            ellipse[(nPoints * 0 + i) * 2 + 0] = x0 + xi;
            ellipse[(nPoints * 2 - i) * 2 + 0] = x0 - xi;
            ellipse[(nPoints * 2 + i) * 2 + 0] = x0 - xi;
            ellipse[(nPoints * 4 - i) * 2 + 0] = x0 + xi;
            ellipse[(nPoints * 0 + i) * 2 + 1] = y0 - yi;
            ellipse[(nPoints * 2 - i) * 2 + 1] = y0 - yi;
            ellipse[(nPoints * 2 + i) * 2 + 1] = y0 + yi;
            ellipse[(nPoints * 4 - i) * 2 + 1] = y0 + yi;
        }
        return ellipse;
    }

    public static double[] createEllipse(double x0, double y0, double dx, double dy) {
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        int nPoints = 45;
        double[] ellipse = new double[nPoints * 8 + 2];
        double dxdy = dx * dy;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        ellipse[nPoints * 0 + 0] = x0 + dx;
        ellipse[nPoints * 0 + 1] = y0;
        ellipse[nPoints * 8 + 0] = x0 + dx;
        ellipse[nPoints * 8 + 1] = y0;
        ellipse[nPoints * 2 + 0] = x0;
        ellipse[nPoints * 2 + 1] = y0 - dy;
        ellipse[nPoints * 4 + 0] = x0 - dx;
        ellipse[nPoints * 4 + 1] = y0;
        ellipse[nPoints * 6 + 0] = x0;
        ellipse[nPoints * 6 + 1] = y0 + dy;
        double angleStep = nPoints > 0 ? 1.5707963267948966 / (double)nPoints : 0.0;
        double a = 0.0;
        for (int i = 1; i < nPoints; ++i) {
            double t = Math.tan(a += angleStep);
            double x = dxdy / Math.sqrt(t * t * dx2 + dy2);
            double y = x * t + 0.5;
            ellipse[(nPoints * 0 + i) * 2 + 0] = x0 + x;
            ellipse[(nPoints * 2 - i) * 2 + 0] = x0 - x;
            ellipse[(nPoints * 2 + i) * 2 + 0] = x0 - x;
            ellipse[(nPoints * 4 - i) * 2 + 0] = x0 + x;
            ellipse[(nPoints * 0 + i) * 2 + 1] = y0 - y;
            ellipse[(nPoints * 2 - i) * 2 + 1] = y0 - y;
            ellipse[(nPoints * 2 + i) * 2 + 1] = y0 + y;
            ellipse[(nPoints * 4 - i) * 2 + 1] = y0 + y;
        }
        return ellipse;
    }

    public static int[] createCircle(int x0, int y0, int radius) {
        return Geometry.createEllipse(x0, y0, radius, radius);
    }

    public static double[] createCircle(double x0, double y0, double radius) {
        return Geometry.createEllipse(x0, y0, radius, radius);
    }

    public static int[] createSector(int x0, int y0, int dx, int dy, double angle0, double angle1) {
        double angleSpan = Math.abs(angle1 - angle0);
        double arcDistance = (double)Math.max(dx, dy) * angleSpan;
        int nPoints = (int)Math.round(arcDistance / 15.0);
        double angleStep = angleSpan / (double)(nPoints - 1);
        int[] xy = new int[nPoints * 2 + 4];
        int index = 0;
        for (int i = 0; i < nPoints; ++i) {
            double angle = angle0 + angleStep * (double)i;
            double x = (double)dx * Math.cos(angle);
            double y = (double)dy * Math.sin(angle);
            xy[index + 0] = x0 + (int)Math.round(x);
            xy[index + 1] = y0 - (int)Math.round(y);
            index += 2;
        }
        xy[nPoints * 2 + 0] = x0;
        xy[nPoints * 2 + 1] = y0;
        xy[nPoints * 2 + 2] = xy[0];
        xy[nPoints * 2 + 3] = xy[1];
        return xy;
    }

    public static int[] createSector(int x0, int y0, int radius, double angle0, double angle1) {
        return Geometry.createSector(x0, y0, radius, radius, angle0, angle1);
    }

    public static int[] createArrow(int[] x, int[] y, double length, double angle, double inset) {
        double v;
        int[] arrow = new int[10];
        int x0 = x[x.length - 1];
        int y0 = y[y.length - 1];
        arrow[2] = x0;
        arrow[3] = y0;
        int[] pos1 = new int[2];
        Geometry.findPolygonPosition(x, y, length, pos1);
        double dx = x0 - pos1[0];
        double dy = y0 - pos1[1];
        double d = v = dx == 0.0 ? 1.5707963267948966 : Math.atan(Math.abs(dy / dx));
        v = dx > 0.0 && dy <= 0.0 ? Math.PI + v : (dx > 0.0 && dy >= 0.0 ? Math.PI - v : (dx <= 0.0 && dy < 0.0 ? -v : (dx <= 0.0 && dy > 0.0 ? v : 0.0)));
        double v0 = v + angle;
        double v1 = v - angle;
        double edgeLength = length / Math.cos(angle);
        arrow[0] = x0 + (int)Math.round(edgeLength * Math.cos(v0));
        arrow[1] = y0 - (int)Math.round(edgeLength * Math.sin(v0));
        arrow[4] = x0 + (int)Math.round(edgeLength * Math.cos(v1));
        arrow[5] = y0 - (int)Math.round(edgeLength * Math.sin(v1));
        double c1 = inset * length;
        arrow[6] = x0 + (int)Math.round(c1 * Math.cos(v));
        arrow[7] = y0 - (int)Math.round(c1 * Math.sin(v));
        arrow[8] = arrow[0];
        arrow[9] = arrow[1];
        return arrow;
    }

    public static int[] createArrow(int x0, int y0, int x1, int y1, double length, double angle, double inset) {
        int[] x = new int[]{x0, x1};
        int[] y = new int[]{y0, y1};
        return Geometry.createArrow(x, y, length, angle, inset);
    }

    public static int[] createRectangle(int x0, int y0, int width, int height) {
        return new int[]{x0, y0, x0 + (width - 1), y0, x0 + (width - 1), y0 + (height - 1), x0, y0 + (height - 1), x0, y0};
    }

    public static double[] createRectangle(double x0, double y0, double width, double height) {
        return new double[]{x0, y0, x0 + width, y0, x0 + width, y0 + height, x0, y0 + height, x0, y0};
    }

    public static int[] createStar(int x0, int y0, int innerRadius, int outerRadius, int nArms) {
        int nPoints = nArms * 2 + 1;
        int[] xy = new int[nPoints * 2];
        double angleStep = Math.PI * 2 / (double)nArms / 2.0;
        for (int i = 0; i < nArms * 2; ++i) {
            double angle = (double)i * angleStep;
            double radius = i % 2 == 0 ? (double)innerRadius : (double)outerRadius;
            double x = (double)x0 + radius * Math.cos(angle);
            double y = (double)y0 + radius * Math.sin(angle);
            xy[i * 2 + 0] = (int)Math.round(x);
            xy[i * 2 + 1] = (int)Math.round(y);
        }
        xy[nPoints * 2 - 2] = xy[0];
        xy[nPoints * 2 - 1] = xy[1];
        return xy;
    }

    public static double[] createStar(double x0, double y0, double innerRadius, double outerRadius, int nArms) {
        int nPoints = nArms * 2 + 1;
        double[] xy = new double[nPoints * 2];
        double angleStep = Math.PI * 2 / (double)nArms / 2.0;
        for (int i = 0; i < nArms * 2; ++i) {
            double angle = (double)i * angleStep;
            double radius = i % 2 == 0 ? innerRadius : outerRadius;
            xy[i * 2 + 0] = x0 + radius * Math.cos(angle);
            xy[i * 2 + 1] = y0 + radius * Math.sin(angle);
        }
        xy[nPoints * 2 - 2] = xy[0];
        xy[nPoints * 2 - 1] = xy[1];
        return xy;
    }

    public static boolean findPolygonPosition(int[] x, int[] y, double length, int[] position) {
        if (length < 0.0) {
            return false;
        }
        double accumulatedLength = 0.0;
        for (int i = 1; i < x.length; ++i) {
            double legLength = Geometry.length(x[i - 1], y[i - 1], x[i], y[i]);
            if (legLength + accumulatedLength >= length) {
                double part = length - accumulatedLength;
                double fraction = part / legLength;
                position[0] = (int)Math.round((double)x[i - 1] + fraction * (double)(x[i] - x[i - 1]));
                position[1] = (int)Math.round((double)y[i - 1] + fraction * (double)(y[i] - y[i - 1]));
                return true;
            }
            accumulatedLength += legLength;
        }
        return false;
    }
}

