/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.geometry;

import no.geosoft.cc.geometry.Rect;

public class Box
implements Cloneable {
    public int x1;
    public int x2;
    public int y1;
    public int y2;

    public Box() {
        this.set(0, 0, 0, 0);
    }

    public Box(Box box) {
        this.set(box.x1, box.y1, box.x2, box.y2);
    }

    public Box(int x1, int y1, int x2, int y2) {
        this.set(x1, y1, x2, y2);
    }

    public Box(Rect rectangle) {
        this.x1 = rectangle.x;
        this.y1 = rectangle.y;
        this.x2 = rectangle.x + rectangle.width;
        this.y2 = rectangle.y + rectangle.height;
    }

    public void copy(Box box) {
        this.set(box.x1, box.y1, box.x2, box.y2);
    }

    public Object clone() {
        return new Box(this.x1, this.y1, this.x2, this.y2);
    }

    public void set(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public boolean isInside(int x, int y) {
        return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2;
    }

    public boolean isInsideOf(Box box) {
        return this.x1 >= box.x1 && this.y1 >= box.y1 && this.x2 <= box.x2 && this.y2 <= box.y2;
    }

    public boolean isOverlapping(Box box) {
        return this.x2 > box.x1 && this.y2 > box.y1 && this.x1 < box.x2 && this.y1 < box.y2;
    }

    public boolean isOverlapping(Rect rectangle) {
        return this.x2 > rectangle.x && this.x1 < rectangle.x + rectangle.width && this.y2 > rectangle.y && this.y1 < rectangle.y + rectangle.height;
    }

    public void offset(int dx, int dy) {
        this.x1 += dx;
        this.y1 += dy;
        this.x2 += dx;
        this.y2 += dy;
    }

    public String toString() {
        return "Box: y1=" + this.y1 + " y2=" + this.y2 + " x1=" + this.x1 + " x2=" + this.x2;
    }
}

