/*
 * Decompiled with CFR 0.152.
 */
package i2m.wifi;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Dialog.IPAddressDialog;
import i2m.Language;
import i2m.MainFrame;
import i2m.wifi.DispositivoChrome;
import i2m.wifi.FileDati;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WifiDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private JButton cercaB;
    private JButton connettiB;
    private JButton connettiIpB;
    private JButton connettiHotB;
    private JButton listaB;
    private JButton scaricaB;
    private JButton cancellaB;
    private JButton cancellaTuttiB;
    private JButton esciB1;
    private JButton esciB2;
    private JButton testB;
    private JButton scaricaApriB;
    private JButton settaggiB;
    private DefaultListModel elencoChormeLM;
    private DefaultListModel elencoFileLM;
    private JLabel dispositivoConnesso;
    private JList listChrome;
    private JList listFile;
    Vector<String> nomiReti;
    Vector<String> indirizziReti;
    private JTabbedPane tabPrincipale;
    Socket s = null;
    BufferedReader in = null;
    PrintWriter out = null;
    private boolean connesso = false;
    Vector<FileDati> elencoFileDati;
    Vector<DispositivoChrome> elencoChrome;
    private int percentualeDownload = 0;
    private Thread downloadMonitorThread;
    private Thread downloadThread;
    private Thread receiveThread;
    private Thread verificaThread;
    private Thread gestoreDownloadThread;
    private File f;
    private int indiceFile = -1;
    private int indiceChrome = -1;
    private boolean downloadAnnullato = false;
    private boolean ricercaInCorso = true;
    private boolean eseguiVerifica = true;
    private JLabel labelConnessione;
    private String indirizzoConnesso = null;
    private long tempoPrecedente = 0L;
    private long tempoTest = 0L;
    private JProgressBar progress;
    private boolean testInCorso = false;
    private String indirizzoTest = "";
    private JComboBox schedeRete;
    boolean apri = false;
    MainFrame padre;
    String directoryDownload;

    public WifiDialog(MainFrame owner) {
        super(owner, Language.string(Language.string("Download Chrome - WiFi") + " [y]"), false);
        this.addWindowListener(this);
        this.padre = owner;
        this.nomiReti = new Vector();
        this.indirizziReti = new Vector();
        this.elencoFileDati = new Vector();
        this.elencoChrome = new Vector();
        this.elencoChormeLM = new DefaultListModel();
        this.elencoChormeLM.clear();
        this.elencoFileLM = new DefaultListModel();
        this.elencoFileLM.clear();
        JPanel pannelloPrincipale1 = new JPanel(new BorderLayout());
        JPanel pannelloPrincipale2 = new JPanel(new BorderLayout());
        JPanel pannelloConnessione = new JPanel(new BorderLayout());
        JPanel pannelloBarra = new JPanel(new BorderLayout());
        JPanel pannelloCentrale = new JPanel(new BorderLayout());
        this.labelConnessione = new JLabel(" Connected: ----");
        this.schedeRete = new JComboBox();
        JPanel pannelloRete = new JPanel();
        pannelloRete.add(new JLabel(Language.string("Schede Reti:")));
        pannelloRete.add(this.schedeRete);
        pannelloRete.add(new JLabel("  "));
        pannelloRete.add(this.labelConnessione);
        this.tabPrincipale = new JTabbedPane();
        this.tabPrincipale.addChangeListener(this);
        this.tabPrincipale.addTab(Language.string("Dispositivi"), pannelloPrincipale1);
        this.tabPrincipale.addTab(Language.string("Dati"), pannelloPrincipale2);
        this.setContentPane(this.tabPrincipale);
        this.cercaB = new JButton(Language.string("Aggiorna dispositivi"));
        this.cercaB.addActionListener(this);
        this.connettiB = new JButton(Language.string("Connetti"));
        this.connettiB.addActionListener(this);
        this.connettiHotB = new JButton(Language.string("Connetti HotSpot"));
        this.connettiHotB.addActionListener(this);
        this.connettiIpB = new JButton(Language.string("Connetti manualmente"));
        this.connettiIpB.addActionListener(this);
        this.settaggiB = new JButton(Language.string("Settings Chrome"));
        this.settaggiB.addActionListener(this);
        this.settaggiB.setEnabled(false);
        this.testB = new JButton(Language.string("Test rete"));
        this.testB.addActionListener(this);
        this.esciB1 = new JButton(Language.string("Esci"));
        this.esciB1.addActionListener(this);
        this.listaB = new JButton(Language.string("Aggiorna"));
        this.listaB.addActionListener(this);
        this.scaricaB = new JButton(Language.string("Download"));
        this.scaricaB.addActionListener(this);
        this.scaricaApriB = new JButton(Language.string("Download e apri"));
        this.scaricaApriB.addActionListener(this);
        this.cancellaB = new JButton(Language.string("Cancella"));
        this.cancellaB.addActionListener(this);
        this.cancellaTuttiB = new JButton(Language.string("Cancella tutti"));
        this.cancellaTuttiB.addActionListener(this);
        this.esciB2 = new JButton(Language.string("Esci"));
        this.esciB2.addActionListener(this);
        this.progress = new JProgressBar();
        this.progress.setValue(0);
        this.progress.setStringPainted(true);
        this.progress.setSize(new Dimension(50, 500));
        JPanel pannelloTesto = new JPanel();
        this.dispositivoConnesso = new JLabel(Language.string("            Circuito               Data                Dimensione             Ora            ID"));
        pannelloTesto.add(this.dispositivoConnesso);
        JPanel pannelloBottoni1 = new JPanel();
        JPanel pannelloBottoni2 = new JPanel();
        pannelloBottoni1.add(this.cercaB);
        pannelloBottoni1.add(this.connettiIpB);
        pannelloBottoni1.add(this.connettiHotB);
        pannelloBottoni1.add(this.connettiB);
        pannelloBottoni1.add(this.settaggiB);
        pannelloBottoni1.add(this.esciB1);
        pannelloBottoni2.add(this.listaB);
        pannelloBottoni2.add(this.scaricaB);
        pannelloBottoni2.add(this.scaricaApriB);
        pannelloBottoni2.add(this.cancellaB);
        pannelloBottoni2.add(this.cancellaTuttiB);
        pannelloBottoni2.add(this.esciB2);
        pannelloBottoni1.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloBottoni2.setBorder(BorderFactory.createEtchedBorder(0));
        this.listChrome = new JList(this.elencoChormeLM);
        this.listChrome.setSelectionMode(0);
        this.listChrome.setLayoutOrientation(0);
        this.listChrome.setFont(new Font("Courier", 0, 13));
        this.listChrome.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.listChrome);
        listScroller.setPreferredSize(new Dimension(150, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        this.listFile = new JList(this.elencoFileLM);
        this.listFile.setSelectionMode(2);
        this.listFile.setLayoutOrientation(0);
        this.listFile.setFont(new Font("Courier", 0, 13));
        this.listFile.addListSelectionListener(this);
        JScrollPane listScroller2 = new JScrollPane(this.listFile);
        listScroller2.setPreferredSize(new Dimension(150, 100));
        listScroller2.setVerticalScrollBarPolicy(22);
        pannelloConnessione.add((Component)pannelloRete, "Center");
        pannelloConnessione.add(Box.createRigidArea(new Dimension(5, 5)), "South");
        pannelloConnessione.add(Box.createRigidArea(new Dimension(5, 5)), "North");
        pannelloBarra.add((Component)this.progress, "Center");
        pannelloBarra.add((Component)new JLabel(Language.string("Memoria occupata:")), "North");
        pannelloBarra.add(Box.createRigidArea(new Dimension(3, 3)), "South");
        pannelloCentrale.add((Component)listScroller2, "Center");
        pannelloCentrale.add((Component)pannelloBarra, "South");
        pannelloPrincipale1.add((Component)pannelloConnessione, "North");
        pannelloPrincipale1.add((Component)listScroller, "Center");
        pannelloPrincipale1.add((Component)pannelloBottoni1, "South");
        pannelloPrincipale2.add((Component)this.dispositivoConnesso, "North");
        pannelloPrincipale2.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale2.add((Component)pannelloBottoni2, "South");
        this.elencaReti();
        this.receiveThread = new Thread(){

            @Override
            public void run() {
                WifiDialog.this.riceviIndirizzi();
            }
        };
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
        this.verificaThread = new Thread(){

            @Override
            public void run() {
                WifiDialog.this.verificaTempoIndirizzi();
            }
        };
        this.verificaThread.setDaemon(true);
        this.verificaThread.start();
        this.pack();
        this.setSize(new Dimension(850, 350));
        this.setFocusableWindowState(true);
    }

    private void elencaReti() {
        this.schedeRete.removeAllItems();
        this.nomiReti.removeAllElements();
        this.indirizziReti.removeAllElements();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                this.displayInterfaceInformation(netint);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (this.schedeRete.getItemCount() != 0) {
            this.schedeRete.setSelectedIndex(0);
        }
    }

    private void displayInterfaceInformation(NetworkInterface netint) throws SocketException {
        if (netint.isLoopback() || !netint.isUp()) {
            return;
        }
        System.out.printf("Display name: %s\n", netint.getDisplayName());
        System.out.printf("Name: %s\n", netint.getName());
        Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
            if (inetAddress instanceof Inet6Address) continue;
            this.nomiReti.addElement(netint.getDisplayName());
            this.indirizziReti.addElement(inetAddress.getHostAddress());
            String elemento = " " + netint.getDisplayName() + "  (" + inetAddress.getHostAddress() + ") ";
            this.schedeRete.addItem(elemento);
            System.out.printf("InetAddress: %s\n", inetAddress.getHostAddress());
        }
        System.out.printf("\n", new Object[0]);
    }

    private boolean testNet() {
        DatagramSocket ms = null;
        try {
            this.testInCorso = true;
            this.tempoTest = System.currentTimeMillis();
            InetAddress group = InetAddress.getByName("230.0.0.1");
            ms = new DatagramSocket(4445);
            ms.setSoTimeout(5000);
            this.indirizzoTest = InetAddress.getLocalHost().getHostAddress();
            System.out.println("indirizzo test=" + this.indirizzoTest);
            String messaggio = "Test";
            byte[] msg = messaggio.getBytes();
            DatagramPacket snd = new DatagramPacket(msg, msg.length, group, 4446);
            ms.send(snd);
            ms.close();
            return true;
        }
        catch (Exception ex) {
            if (ms != null) {
                ms.close();
            }
            this.testInCorso = false;
            ex.printStackTrace();
            return false;
        }
    }

    private synchronized void eliminaDispositivo(DispositivoChrome dispositivo) {
        this.elencoChrome.remove(dispositivo);
        this.elencoChormeLM.removeElement(dispositivo.getStringaTabella());
    }

    private synchronized void aggiungiDispositivo(DispositivoChrome dispositivo) {
        this.elencoChrome.addElement(dispositivo);
        this.elencoChormeLM.addElement(dispositivo.getStringaTabella());
    }

    private synchronized void rimuoviTuttiDispositivi() {
        this.elencoChormeLM.clear();
        this.elencoChrome.removeAllElements();
    }

    private synchronized boolean dispositivoesiste(DispositivoChrome dispositivo, long tempoAttuale) {
        for (int i = 0; i < this.elencoChrome.size(); ++i) {
            if (!this.elencoChrome.get(i).getIndirizzo().equals(dispositivo.getIndirizzo())) continue;
            this.elencoChrome.get(i).setTempo(tempoAttuale);
            return true;
        }
        return false;
    }

    private synchronized String getAddress(int index) {
        return this.elencoChrome.get(index).getIndirizzo();
    }

    private synchronized String getStringaConnessione(int index) {
        return this.elencoChrome.get(index).getStringaConnessione();
    }

    public void inviaFrase(String stringa) {
        String s = stringa + "\n";
        this.out.println(s);
    }

    public boolean richiediConfermaRicezione() {
        this.out.println("SettaggiInviati\n");
        this.requestFocus();
        try {
            String line;
            while ((line = this.in.readLine()) != null && !line.equals("SettaggiRicevuti") && !line.equals("ConnessoUsb")) {
                System.out.println("Conferma:" + line);
            }
            if (line == null) {
                return false;
            }
            if (line.equals("ConnessoUsb")) {
                JOptionPane.showMessageDialog(this, Language.string("Sistema gi\u00e0 connesso via USB, impossibile procedere"), "ERROR", 0);
                this.chiudiConnessione();
                return false;
            }
        }
        catch (IOException e1) {
            this.chiudiConnessione();
            return false;
        }
        return true;
    }

    public void abilitaTasti(boolean abilita) {
        this.cercaB.setEnabled(abilita);
        this.connettiB.setEnabled(abilita);
        this.connettiIpB.setEnabled(abilita);
        this.connettiHotB.setEnabled(abilita);
        this.listaB.setEnabled(abilita);
        this.scaricaB.setEnabled(abilita);
        this.cancellaB.setEnabled(abilita);
        this.cancellaTuttiB.setEnabled(abilita);
        this.esciB1.setEnabled(abilita);
        this.esciB2.setEnabled(abilita);
        this.testB.setEnabled(abilita);
        this.scaricaApriB.setEnabled(abilita);
        this.settaggiB.setEnabled(abilita);
    }

    public Vector<String> riceviSettaggi() {
        String s = "RiceviSettaggi\n";
        this.requestFocus();
        Vector<String> settaggiRicevuti = new Vector<String>();
        this.out.println(s);
        try {
            String line;
            while ((line = this.in.readLine()) != null && !line.equals("FineSettaggi") && !line.equals("ConnessoUsb")) {
                System.out.println("linea file:" + line);
                settaggiRicevuti.add(line);
            }
            if (line == null) {
                JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                this.chiudiConnessione();
                return settaggiRicevuti;
            }
            if (line.equals("ConnessoUsb")) {
                JOptionPane.showMessageDialog(this, Language.string("Sistema gi\u00e0 connesso via USB, impossibile procedere"), "ERROR", 0);
                this.chiudiConnessione();
                return settaggiRicevuti;
            }
        }
        catch (IOException e1) {
            this.chiudiConnessione();
            return settaggiRicevuti;
        }
        return settaggiRicevuti;
    }

    private void cancellaFile(int[] index, boolean tutti) {
        if (tutti) {
            while (this.elencoFileLM.size() != 0) {
                String s = String.format("CancellaFile,%d,\n", 0);
                this.out.println(s);
                try {
                    String line;
                    while ((line = this.in.readLine()) != null && !line.equals("FileCancellato") && !line.equals("ConnessoUsb")) {
                        System.out.println("linea file:" + line);
                    }
                    if (line == null) {
                        JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                        this.chiudiConnessione();
                        return;
                    }
                    if (line.equals("ConnessoUsb")) {
                        JOptionPane.showMessageDialog(this, Language.string("Sistema gi\u00e0 connesso via USB, impossibile procedere"), "ERROR", 0);
                        this.chiudiConnessione();
                        return;
                    }
                    this.aggiornaListaFile();
                }
                catch (IOException e1) {
                    this.chiudiConnessione();
                    return;
                }
            }
            JOptionPane.showMessageDialog(this, Language.string("Files cancellati"), "INFO", 1);
        } else {
            int i;
            if (index.length == 0) {
                return;
            }
            String[] elencoFile = new String[index.length];
            for (i = 0; i < index.length; ++i) {
                elencoFile[i] = this.elencoFileDati.get(index[i]).getNome();
            }
            block7: for (i = 0; i < elencoFile.length; ++i) {
                for (int j = 0; j < this.elencoFileDati.size(); ++j) {
                    if (!this.elencoFileDati.get(j).getNome().equals(elencoFile[i])) continue;
                    String s = String.format("CancellaFile,%d,\n", j);
                    this.out.println(s);
                    try {
                        String line;
                        while ((line = this.in.readLine()) != null && !line.equals("FileCancellato") && !line.equals("ConnessoUsb")) {
                            System.out.println("Cancella Wifi:linea file:" + line);
                        }
                        if (line == null) {
                            JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                            this.chiudiConnessione();
                            return;
                        }
                        if (line.equals("ConnessoUsb")) {
                            JOptionPane.showMessageDialog(this, Language.string("Sistema gi\u00e0 connesso via USB, impossibile procedere"), "ERROR", 0);
                            this.chiudiConnessione();
                            return;
                        }
                        this.aggiornaListaFile();
                    }
                    catch (IOException e1) {
                        this.chiudiConnessione();
                    }
                    continue block7;
                }
            }
            JOptionPane.showMessageDialog(this, Language.string("Fili cancellati"), "INFO", 1);
        }
    }

    private void verificaTempoIndirizzi() {
        while (this.eseguiVerifica) {
            long tempoAttuale = System.currentTimeMillis();
            for (int i = 0; i < this.elencoChrome.size(); ++i) {
                if (this.testInCorso && this.elencoChrome.get(i).getIndirizzo().equals(this.indirizzoTest)) {
                    this.testInCorso = false;
                    JOptionPane.showMessageDialog(this, Language.string("Test superato"), "Test", 1);
                }
                if (this.elencoChrome.get(i).getTempo() >= tempoAttuale - 10000L) continue;
                if (this.elencoChrome.get(i).getIndirizzo().equals(this.indirizzoConnesso)) {
                    this.chiudiConnessione();
                }
                this.eliminaDispositivo(this.elencoChrome.get(i));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.testInCorso || tempoAttuale <= this.tempoTest + 6000L) continue;
            this.testInCorso = false;
            JOptionPane.showMessageDialog(this, Language.string("Messaggi non ricevuti"), "Error", 0);
        }
    }

    public boolean isConnesso() {
        return this.connesso;
    }

    private void riceviIndirizzi() {
        while (this.ricercaInCorso) {
            try {
                InetAddress group = InetAddress.getByName("230.0.0.1");
                int port = 4446;
                InetSocketAddress addr = new InetSocketAddress(group, port);
                MulticastSocket ms = new MulticastSocket(port);
                ms.setSoTimeout(5000);
                if (this.schedeRete.getSelectedIndex() != -1) {
                    NetworkInterface nif = NetworkInterface.getByName(this.nomiReti.get(this.schedeRete.getSelectedIndex()));
                    ms.joinGroup(addr, nif);
                } else {
                    ms.joinGroup(group);
                }
                byte[] buf = new byte[100];
                while (this.ricercaInCorso) {
                    DatagramPacket recv = new DatagramPacket(buf, buf.length);
                    ms.receive(recv);
                    DispositivoChrome disp = new DispositivoChrome(new String(buf), recv.getAddress().getHostAddress());
                    disp.setTempo(System.currentTimeMillis());
                    this.tempoPrecedente = System.currentTimeMillis();
                    if (this.dispositivoesiste(disp, System.currentTimeMillis())) continue;
                    this.aggiungiDispositivo(disp);
                }
                ms.leaveGroup(group);
                ms.close();
                System.out.println("Chiudo ricezione multicast");
            }
            catch (SocketTimeoutException ex) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException port) {
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void chiudiConnessione() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.progress.setValue(0);
            this.labelConnessione.setText(" Connected: ----");
            this.indirizzoConnesso = null;
            this.elencoFileLM.clear();
            this.s.close();
            this.out.println("Disconnetti\n");
            this.out.close();
            this.in.close();
            this.tabPrincipale.setSelectedIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connesso = false;
        this.settaggiB.setEnabled(false);
        this.connettiB.setText(Language.string("Connetti"));
        this.connettiIpB.setText(Language.string("Connetti manualmente"));
        this.connettiHotB.setText(Language.string("Connetti Chrome HotSpot"));
    }

    private void apriConnessione(boolean manuale, String indirizzo) {
        try {
            System.out.println("Apro Socket");
            this.connettiB.setText(Language.string("Disconnetti"));
            this.connettiHotB.setText(Language.string("---"));
            this.connettiIpB.setText(Language.string("---"));
            if (!manuale) {
                this.labelConnessione.setText(this.getStringaConnessione(this.indiceChrome));
            } else {
                this.labelConnessione.setText(" Connected: " + indirizzo);
            }
            this.s = new Socket();
            if (!manuale) {
                this.s.connect(new InetSocketAddress(this.getAddress(this.indiceChrome), 3333), 15000);
                this.indirizzoConnesso = this.getAddress(this.indiceChrome);
                System.out.println("DEBUG: indirizzo connessione:" + this.indirizzoConnesso + "--");
            } else {
                this.s.connect(new InetSocketAddress(indirizzo, 3333), 15000);
                this.indirizzoConnesso = indirizzo;
            }
            System.out.println("DEBUG: indirizzo connessione:" + this.indirizzoConnesso + "-fine-");
            System.out.println("connesso");
            this.connesso = true;
            this.settaggiB.setEnabled(true);
            this.out = new PrintWriter(this.s.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
            this.tabPrincipale.setSelectedIndex(1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Language.string("Impossibile stabilire connessione"), "ERROR", 0);
            this.chiudiConnessione();
        }
    }

    private File controllaFile(String directory, String nome) {
        File f = new File(directory, nome);
        if (!f.isAbsolute()) {
            f = new File(f.getAbsolutePath());
        }
        if (!f.exists() && f.getParentFile().exists() && f.getParentFile().isDirectory() && f.getParentFile().canWrite()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (f.exists() && !f.canWrite()) {
            JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
            return null;
        }
        return f;
    }

    private void downloadFile(boolean apriFile) {
        FileDialog fd = new FileDialog((Dialog)this, Language.string("Salva sessioni"), 1);
        fd.setFile(this.elencoFileDati.get(this.listFile.getSelectedIndex()).getNome());
        String s = DanasPreferences.getPrefDirectory("downloadedfiledirectory");
        fd.setDirectory(s);
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return;
        }
        this.directoryDownload = fd.getDirectory();
        this.apri = apriFile;
        DanasPreferences.setPrefDirectory("downloadedfiledirectory", fd.getDirectory().toString());
        this.gestoreDownloadThread = new Thread(){

            @Override
            public void run() {
                WifiDialog.this.abilitaTasti(false);
                int[] elencoIndici = WifiDialog.this.listFile.getSelectedIndices();
                for (int i = 0; i < elencoIndici.length; ++i) {
                    WifiDialog.this.indiceFile = elencoIndici[i];
                    WifiDialog.this.f = WifiDialog.this.controllaFile(WifiDialog.this.directoryDownload, WifiDialog.this.elencoFileDati.get(WifiDialog.this.indiceFile).getNome());
                    if (WifiDialog.this.f == null) continue;
                    System.out.println("DEBUG: scarico su:" + WifiDialog.this.f.getAbsolutePath());
                    WifiDialog.this.percentualeDownload = 0;
                    WifiDialog.this.downloadMonitorThread = new Thread(){

                        @Override
                        public void run() {
                            WifiDialog.this.monitorDownload(WifiDialog.this.elencoFileDati.get(WifiDialog.this.indiceFile).getNome());
                        }
                    };
                    WifiDialog.this.downloadMonitorThread.setDaemon(true);
                    WifiDialog.this.downloadMonitorThread.start();
                    WifiDialog.this.downloadThread = new Thread(){

                        @Override
                        public void run() {
                            WifiDialog.this.eseguiDownload(WifiDialog.this.f, WifiDialog.this.indiceFile, WifiDialog.this.apri);
                        }
                    };
                    WifiDialog.this.downloadThread.setDaemon(true);
                    WifiDialog.this.downloadThread.start();
                    try {
                        WifiDialog.this.downloadThread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (WifiDialog.this.downloadAnnullato) break;
                }
                if (!WifiDialog.this.downloadAnnullato) {
                    JOptionPane.showMessageDialog(null, Language.string("File scaricati correttamente"), Language.string("INFO"), 1);
                }
                WifiDialog.this.abilitaTasti(true);
            }
        };
        this.gestoreDownloadThread.setDaemon(true);
        this.gestoreDownloadThread.start();
    }

    private void eseguiDownload(File fileDownload, int indice, boolean apriFile) {
        int dimensioneFile = this.elencoFileDati.get(indice).getDimensione();
        int dimensioneScaricata = 0;
        this.downloadAnnullato = false;
        String s = String.format("DownloadFile,%d,\n", indice);
        this.out.println(s);
        System.out.println("DEBUG: invio=" + s + " file download=" + fileDownload.getAbsolutePath());
        try {
            String line;
            FileOutputStream fos = new FileOutputStream(fileDownload);
            PrintStream ps = new PrintStream(fos);
            while (!((line = this.in.readLine()) == null || line.equals("FineDownloadFile") || this.downloadAnnullato || line.equals("ConnessoUsb"))) {
                ps.println(line);
                this.percentualeDownload = (int)((float)(dimensioneScaricata += line.length()) / (float)dimensioneFile / 10.0f);
            }
            ps.close();
            fos.close();
            if (line == null) {
                this.chiudiConnessione();
                if (!this.downloadAnnullato) {
                    JOptionPane.showMessageDialog(this, Language.string("Errore connessione"), "ERROR", 0);
                }
                this.downloadAnnullato = true;
            }
            if (line.equals("ConnessoUsb")) {
                JOptionPane.showMessageDialog(this, Language.string("Sistema gi\u00e0 connesso via USB, impossibile procedere"), "ERROR", 0);
                this.chiudiConnessione();
                this.downloadAnnullato = true;
                return;
            }
            this.downloadThread = null;
            this.percentualeDownload = 100;
            if (!this.downloadAnnullato && apriFile) {
                File[] fileDaAprire = new File[]{fileDownload};
                DanasDataStructure.getInstance().getMainFrame().apriFile(fileDaAprire);
            }
        }
        catch (Exception e1) {
            this.chiudiConnessione();
            if (!this.downloadAnnullato) {
                JOptionPane.showMessageDialog(this, Language.string("Errore connessione download"), "ERROR", 0);
            }
            this.downloadAnnullato = true;
        }
        this.percentualeDownload = 100;
    }

    private void monitorDownload(String nomeFile) {
        this.setEnabled(false);
        ProgressMonitor mon = new ProgressMonitor(this, Language.string("Download in corso: ") + nomeFile, "", 0, 100);
        while (!mon.isCanceled() && this.percentualeDownload < 99) {
            mon.setProgress(this.percentualeDownload);
            mon.setNote(Language.string("Completato: ") + this.percentualeDownload + "%");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (mon.isCanceled()) {
            System.out.println("Premuto annulla monitor download");
            this.downloadAnnullato = true;
            this.chiudiConnessione();
            JOptionPane.showMessageDialog(this, Language.string("Download annullato"), "Allarmi", 1);
        } else {
            mon.setProgress(100);
        }
        this.setEnabled(true);
        this.requestFocus();
        this.downloadMonitorThread = null;
    }

    private void aggiornaListaFile() {
        this.elencoFileLM.clear();
        this.elencoFileDati.removeAllElements();
        if (this.out == null) {
            return;
        }
        this.out.println("ListaFile\n");
        int occupazione = 0;
        try {
            String line;
            while ((line = this.in.readLine()) != null && !line.equals("FineLista") && !line.equals("ConnessoUsb")) {
                FileDati dato = new FileDati(line);
                occupazione += dato.getDimensione();
                System.out.println("linea file:" + line);
                this.elencoFileDati.addElement(dato);
                this.elencoFileLM.addElement(dato.getStringaTabella());
            }
            int percentuale = (int)((double)occupazione / 819200.0 * 100.0);
            this.progress.setValue(percentuale);
            if (line == null) {
                this.chiudiConnessione();
            }
            if (line.equals("ConnessoUsb")) {
                JOptionPane.showMessageDialog(this, Language.string("Sistema gi\u00e0 connesso via USB, impossibile procedere"), "ERROR", 0);
                this.chiudiConnessione();
                return;
            }
        }
        catch (IOException e1) {
            this.chiudiConnessione();
        }
    }

    public Vector<String> scaricaCircuiti() {
        this.out.println("Traguardi\n");
        Vector<String> circuitiRicevuti = new Vector<String>();
        try {
            String line;
            while ((line = this.in.readLine()) != null && !line.equals("FineTraguardi") && !line.equals("ConnessoUsb")) {
                circuitiRicevuti.add(line);
                System.out.println("linea file:" + line);
            }
            if (line == null) {
                this.chiudiConnessione();
            }
            if (line.equals("ConnessoUsb")) {
                JOptionPane.showMessageDialog(this, Language.string("Sistema gi\u00e0 connesso via USB, impossibile procedere"), "ERROR", 0);
                this.chiudiConnessione();
                return circuitiRicevuti;
            }
        }
        catch (IOException e1) {
            this.chiudiConnessione();
            return circuitiRicevuti;
        }
        return circuitiRicevuti;
    }

    public boolean inviacircuiti(Vector<String> elenco) {
        try {
            this.out.println("CircuitiInizio\n");
            for (int i = 0; i < elenco.size(); ++i) {
                this.out.println("Circuito:" + elenco.get(i) + "\n");
                System.out.println("circuito out:" + elenco.get(i));
            }
            this.out.println("CircuitiFine\n");
        }
        catch (Exception e1) {
            this.chiudiConnessione();
            return false;
        }
        return true;
    }

    public void chiudiDialog() {
        this.ricercaInCorso = false;
        this.chiudiConnessione();
        DanasPreferences.setPosizioneWifiX(this.getLocationOnScreen().x);
        DanasPreferences.setPosizioneWifiY(this.getLocationOnScreen().y);
        DanasPreferences.setLarghezzaWifi(this.getWidth());
        DanasPreferences.setAltezzaWifi(this.getHeight());
        DanasDataStructure.getInstance().getMainFrame().setWifiChiusa();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int resultSovrascrivo;
        if (e.getSource().equals(this.esciB1)) {
            this.chiudiDialog();
        }
        if (e.getSource().equals(this.esciB2)) {
            this.chiudiDialog();
        }
        if (e.getSource().equals(this.cercaB)) {
            this.requestFocus();
            this.rimuoviTuttiDispositivi();
        }
        if (e.getSource().equals(this.cancellaB)) {
            if (this.listFile.getSelectedIndex() == -1) {
                return;
            }
            this.requestFocus();
            resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Cancellare i file selezionati?"), Language.string("ATTENZIONE"), 0);
            if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                return;
            }
            this.cancellaFile(this.listFile.getSelectedIndices(), false);
        }
        if (e.getSource().equals(this.cancellaTuttiB)) {
            if (this.elencoFileLM.isEmpty()) {
                return;
            }
            this.requestFocus();
            resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Cancellare tutti i file?"), Language.string("ATTENZIONE"), 0);
            if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                return;
            }
            this.cancellaFile(this.listFile.getSelectedIndices(), true);
        }
        if (e.getSource().equals(this.listaB)) {
            this.requestFocus();
            this.aggiornaListaFile();
        }
        if (e.getSource().equals(this.settaggiB)) {
            this.requestFocus();
            this.padre.doSettingChrome();
        }
        if (e.getSource().equals(this.connettiB)) {
            this.requestFocus();
            if (!this.connesso) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.listChrome.getSelectedIndex() == -1) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                this.indiceChrome = this.listChrome.getSelectedIndex();
                this.apriConnessione(false, null);
                if (this.connesso) {
                    this.aggiornaListaFile();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.chiudiConnessione();
            }
        }
        if (e.getSource().equals(this.connettiHotB)) {
            this.requestFocus();
            if (!this.connesso) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.apriConnessione(true, "10.10.0.1");
                if (this.connesso) {
                    this.aggiornaListaFile();
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
        if (e.getSource().equals(this.connettiIpB)) {
            this.requestFocus();
            if (!this.connesso) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                IPAddressDialog ipDiag = new IPAddressDialog(null);
                ipDiag.setLocationRelativeTo(this);
                ipDiag.setVisible(true);
                String ip = ipDiag.getIp();
                if (ip != null) {
                    this.apriConnessione(true, ip);
                    if (this.connesso) {
                        this.aggiornaListaFile();
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (e.getSource().equals(this.scaricaB)) {
            if (this.listFile.getSelectedIndex() == -1) {
                return;
            }
            this.requestFocus();
            this.downloadFile(false);
        }
        if (e.getSource().equals(this.scaricaApriB)) {
            if (this.listFile.getSelectedIndex() == -1) {
                return;
            }
            this.requestFocus();
            if (this.listFile.getSelectedIndices().length > 1) {
                JOptionPane.showMessageDialog(this, Language.string("Non \u00e8 possibile fare il download e apri di pi\u00f9 file"), "INFO", 1);
                return;
            }
            this.downloadFile(true);
        }
        if (e.getSource().equals(this.testB)) {
            this.requestFocus();
            try {
                JOptionPane.showMessageDialog(this, Language.string("Connettersi alla rete prima di aprire Danas (LocalHost: ") + InetAddress.getLocalHost().getHostAddress() + ")", "ATTENTION", 1);
            }
            catch (HeadlessException e1) {
                e1.printStackTrace();
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
            }
            boolean res = this.testNet();
            if (!res) {
                JOptionPane.showMessageDialog(this, Language.string("Controllare la connessione e che la rete ammetta messaggi Broadcast/UDP"), "ERROR", 0);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        WifiDialog t = new WifiDialog(null);
        t.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.chiudiDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

