/*
 * Decompiled with CFR 0.152.
 */
package i2m.video;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Language;
import i2m.MainFrame;
import i2m.SincronizzatoreMappaGraficoVideo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlayerFX
extends JDialog
implements ChangeListener,
WindowListener,
ComponentListener {
    JPanel contentPane;
    boolean inRidimensionamento = false;
    boolean readyToPlay = false;
    boolean videoCompare = false;
    private File f = null;
    private String nomeFile = null;
    private JLabel timeLabel;
    private JSlider positionSlider;
    private JButton pauseButton;
    boolean videoAdattato = false;
    boolean videoChiuso = true;
    boolean setPositionValue;
    float ratio = 1.3333334f;
    private int larghezza;
    private MainFrame padre;
    private long posizione = 0L;
    boolean playerCreato = false;
    boolean playerAttivo = false;
    boolean videoNuovo = false;
    DanasDataStructure dati;
    JFXPanel fxPanel;
    JPanel sfondo;
    private SincronizzatoreMappaGraficoVideo multiSincro = null;
    JPanel controlsPanel;
    MediaView mediaView;
    MediaPlayer player;
    Media media;
    VBox root;

    public PlayerFX(boolean oldCompatibility, MainFrame owner) {
        super((Frame)owner, "Video");
        this.padre = owner;
        this.inRidimensionamento = true;
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.fxPanel = new JFXPanel();
        this.createControls();
        this.sfondo = new JPanel();
        this.sfondo.setBackground(Color.BLACK);
        this.contentPane.add((Component)this.sfondo, "Center");
        this.contentPane.add((Component)this.controlsPanel, "South");
        this.setContentPane(this.contentPane);
        this.dati = DanasDataStructure.getInstance();
        this.setSize(300, 200);
        this.addComponentListener(this);
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                PlayerFX.this.initFX(PlayerFX.this.fxPanel);
            }
        });
        this.attendiCreazione();
        this.registerListeners();
    }

    private void initFX(JFXPanel fxPanel) {
        Scene scene = this.createScene();
        fxPanel.setScene(scene);
        this.fineCreazione();
    }

    private Scene createScene() {
        this.mediaView = new MediaView(this.player);
        this.mediaView.setSmooth(true);
        DropShadow dropshadow = new DropShadow();
        dropshadow.setOffsetY(5.0);
        dropshadow.setOffsetX(5.0);
        dropshadow.setColor(javafx.scene.paint.Color.WHITE);
        this.mediaView.setEffect(dropshadow);
        this.root = new VBox(this.mediaView);
        this.mediaView.fitWidthProperty().bind(this.root.widthProperty());
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(new UpdateRunnable(), 0L, 500L, TimeUnit.MILLISECONDS);
        return new Scene(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attendiCreazione() {
        PlayerFX playerFX = this;
        synchronized (playerFX) {
            while (!this.playerCreato) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fineCreazione() {
        PlayerFX playerFX = this;
        synchronized (playerFX) {
            this.playerCreato = true;
            this.notifyAll();
        }
    }

    private void createControls() {
        this.timeLabel = new JLabel("hh:mm:ss ");
        this.positionSlider = new JSlider();
        this.positionSlider.setMinimum(0);
        this.positionSlider.setMaximum(100);
        this.positionSlider.setValue(0);
        this.positionSlider.setToolTipText("Position");
        this.pauseButton = new JButton("Play");
        this.pauseButton.setToolTipText("Play/pause");
        JPanel positionPanel = new JPanel();
        positionPanel.setLayout(new GridLayout(1, 1));
        positionPanel.add(this.positionSlider);
        this.controlsPanel = new JPanel();
        this.controlsPanel.setLayout(new BorderLayout(8, 0));
        this.controlsPanel.add((Component)this.timeLabel, "East");
        this.controlsPanel.add((Component)positionPanel, "Center");
        this.controlsPanel.add((Component)this.pauseButton, "West");
    }

    public void setPlayerOptions() {
        this.player.setAutoPlay(false);
        this.player.setOnEndOfMedia(new Runnable(){

            @Override
            public void run() {
                PlayerFX.this.pauseButton.setText("Play");
                PlayerFX.this.player.stop();
                Duration durationD = PlayerFX.this.player.getTotalDuration();
                PlayerFX.this.player.seek(durationD);
            }
        });
        this.player.setOnReady(new Runnable(){

            @Override
            public void run() {
                if (!PlayerFX.this.videoAdattato) {
                    PlayerFX.this.leggiAspectRatio();
                    PlayerFX.this.adattaAspectRatio();
                }
                PlayerFX.this.videoNuovo = true;
                PlayerFX.this.player.play();
            }
        });
        this.player.setOnPlaying(new Runnable(){

            @Override
            public void run() {
                if (PlayerFX.this.videoNuovo) {
                    PlayerFX.this.videoNuovo = false;
                    PlayerFX.this.player.pause();
                }
            }
        });
    }

    public void setRatio() {
        this.ratio = (float)this.getWidth() / ((float)this.getHeight() - 45.0f);
    }

    public void adattaDimesnioniVideo() {
        Dimension d = new Dimension(this.media.getWidth(), this.media.getHeight());
        if (d != null) {
            this.ratio = (float)d.width / (float)d.height;
            this.larghezza = d.width;
            if (!this.padre.isZoomVideoActivated()) {
                this.setSize(d.width, d.height + 45);
            } else {
                this.setSize(d.width / 2, d.height / 2 + 45);
            }
            this.inRidimensionamento = true;
            if (this.isVisible()) {
                DanasPreferences.setVideoWidth(this.getSize().getWidth());
                DanasPreferences.setVideoHeight(this.getSize().getHeight());
            }
        }
    }

    public void leggiAspectRatio() {
        Dimension d = new Dimension(this.media.getWidth(), this.media.getHeight());
        if (d != null) {
            this.ratio = (float)d.width / (float)d.height;
        }
    }

    public void inizializzaVideo() {
        if (this.player == null) {
            return;
        }
        this.player.stop();
    }

    public void adattaAspectRatio() {
        if (this.getWidth() != this.larghezza) {
            int w = this.getWidth();
            int h = 45 + (int)((float)w / this.ratio);
            this.setSize(w, h);
        } else {
            int h = this.getHeight() - 45;
            int w = (int)((float)h * this.ratio);
            this.setSize(w, h + 45);
        }
        if (this.isVisible()) {
            DanasPreferences.setVideoWidth(this.getSize().getWidth());
            DanasPreferences.setVideoHeight(this.getSize().getHeight());
        }
    }

    public void aggiungiSincronizzazione(SincronizzatoreMappaGraficoVideo sincro) {
        this.multiSincro = sincro;
        this.multiSincro.addChangeListener(this);
    }

    public void rimuoviSincronizzatore(SincronizzatoreMappaGraficoVideo sincro) {
        sincro.removeChangeListener(this);
        this.multiSincro = null;
    }

    public void apriVideo(File file) {
        this.f = new File(file.getAbsolutePath());
        System.out.println("Video nuovo:" + this.f.getName() + " Video attuale:" + this.nomeFile);
        if (this.f.getName().endsWith("mkv") && !this.f.getName().equalsIgnoreCase(this.nomeFile)) {
            JOptionPane.showMessageDialog(this.padre, Language.string("Convertire il video in m4v con VLC per ottenere la sincronizzazione corretta con il cursore."), "Info", 1);
        }
        this.nomeFile = this.f.getName();
        this.f.setReadable(true);
        if (this.f.exists()) {
            try {
                this.videoChiuso = false;
                this.videoAdattato = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!this.f.exists()) {
            JOptionPane.showMessageDialog(null, "Errore, il file video selezionato non esiste!", "Attenzione!", 0);
        }
        this.chiudi();
        if (!this.playerAttivo) {
            this.contentPane.remove(this.sfondo);
            this.contentPane.add((Component)this.fxPanel, "Center");
            this.playerAttivo = true;
        }
        String mediaStringUrl = this.f.toURI().toString();
        try {
            this.media = new Media(mediaStringUrl);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Language.string("Formato non supportao o file non accessibile"), Language.string("Attenzione"), 2);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlayerFX.this.player = new MediaPlayer(PlayerFX.this.media);
                PlayerFX.this.setPlayerOptions();
                PlayerFX.this.mediaView.setMediaPlayer(PlayerFX.this.player);
            }
        });
        System.out.println("DEBUG:fine Apri file video");
    }

    public void abilitaMultiSincro(boolean abilita) {
        if (this.multiSincro != null) {
            this.multiSincro.setAggionrnaMappaGrafico(abilita);
        }
    }

    public void playVideoCompare() {
        this.padre.playVideoCompare();
    }

    public void playVideo() {
        if (this.player == null) {
            return;
        }
        this.abilitaMultiSincro(false);
        this.player.play();
    }

    public void setMute() {
        if (this.player == null) {
            return;
        }
        this.player.setMute(true);
    }

    public void pausa() {
        if (this.player == null) {
            return;
        }
        this.player.pause();
    }

    public void stopVideo() {
        this.abilitaMultiSincro(true);
        if (this.player == null) {
            return;
        }
        this.player.pause();
        if (this.multiSincro != null) {
            try {
                this.multiSincro.setPosizioneCursore(this.getCurrentMills() / 10L);
                this.multiSincro.setAggiornaPosizioneCursore(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setCompare() {
        this.setTitle(Language.string("Video Confronto Giri"));
        this.videoCompare = true;
        this.positionSlider.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.setResizable(false);
    }

    public void pauseVideoCompare() {
        this.padre.pauseVideoCompare();
    }

    public void setNuovoVideo() {
        this.videoAdattato = false;
    }

    public void pausaVideo() {
        if (this.player == null) {
            return;
        }
        this.player.pause();
        this.abilitaMultiSincro(true);
    }

    public long getVideoLength() {
        if (this.player == null) {
            return 0L;
        }
        Duration durationD = this.player.getTotalDuration();
        return (long)durationD.toMillis() / 10L;
    }

    public long getPosition() {
        long cents = this.getCurrentMills() / 10L;
        return cents;
    }

    private void updateTime(long millis) {
        String s = String.format("%02d:%02d:%02d ", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis)), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        this.timeLabel.setText(s);
    }

    public void setPosition(float pos) {
        if (this.player == null) {
            return;
        }
        Duration durationD = this.player.getTotalDuration();
        float duration = (float)durationD.toMillis();
        if (pos < duration / 10.0f) {
            this.player.seek(Duration.millis(pos * duration));
        } else {
            this.pausaVideo();
            JOptionPane.showMessageDialog(this, "Tempo inserito superiore alla durata del video!", "Attenzione!", 2);
        }
    }

    private void updatePosition(int value) {
        this.setPositionValue = true;
        this.positionSlider.setValue(value);
        this.setPositionValue = false;
    }

    public void chiudi() {
        if (this.player != null) {
            this.player.dispose();
        }
    }

    public void setZoom(String s) {
        Dimension d = new Dimension(this.media.getWidth(), this.media.getHeight());
        if (d.height == 0 || d.width == 0) {
            return;
        }
        if (d == null) {
            return;
        }
        if (s.compareTo("1:1") == 0) {
            this.setSize(d.width, d.height + 55);
        } else {
            this.setSize(d.width / 2, d.height / 2 + 55);
        }
        this.inRidimensionamento = true;
    }

    public void apriVideo() {
        Boolean annulla = false;
        this.pausaVideo();
        try {
            FileDialog fd = new FileDialog((Dialog)this, "Apri Video mp4", 0);
            fd.setFile("*.mp4");
            fd.setVisible(true);
            if (fd.getFile() == null) {
                annulla = true;
            }
            if (!annulla.booleanValue()) {
                this.f = new File(fd.getDirectory(), fd.getFile());
                if (this.f.exists()) {
                    if (this.isVisible()) {
                        DanasPreferences.setVideoWidth(this.getSize().getWidth());
                        DanasPreferences.setVideoHeight(this.getSize().getHeight());
                    }
                    this.pausa();
                    this.apriVideo(this.f);
                } else if (!this.f.exists()) {
                    JOptionPane.showMessageDialog(null, "Errore, il file video selezionato non esiste!", "Attenzione!", 0);
                }
            }
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
        }
    }

    public void updateMultiSincro() {
        if (this.videoCompare) {
            return;
        }
        if (this.player == null) {
            return;
        }
        if (this.multiSincro != null) {
            if (this.player.getStatus() == MediaPlayer.Status.PLAYING) {
                this.multiSincro.setAggionrnaMappaGrafico(false);
                try {
                    double offset = this.multiSincro.getOffsetVideo();
                    this.multiSincro.setPosizioneCursore((double)(this.getCurrentMills() / 10L) - offset);
                    this.multiSincro.setAggiornaPosizioneCursore(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.multiSincro.setAggionrnaMappaGrafico(true);
            }
        }
    }

    public void settaMultiSincro() {
        if (this.videoCompare) {
            return;
        }
        if (this.player == null) {
            return;
        }
        if (this.player.getStatus() == MediaPlayer.Status.PLAYING) {
            return;
        }
        if (this.multiSincro == null) {
            return;
        }
        if (this.getCurrentMills() / 10L == this.posizione) {
            return;
        }
        this.posizione = this.getCurrentMills() / 10L;
        this.multiSincro.setPosizioneCursore((double)this.posizione - this.multiSincro.getOffsetVideo());
        this.multiSincro.setAggiornaPosizioneCursore(true);
    }

    private void registerListeners() {
        this.positionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!PlayerFX.this.positionSlider.getValueIsAdjusting() && !PlayerFX.this.setPositionValue) {
                    float positionValue = (float)PlayerFX.this.positionSlider.getValue() / 100.0f;
                    PlayerFX.this.setPosition(positionValue);
                    PlayerFX.this.settaMultiSincro();
                }
            }
        });
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PlayerFX.this.player == null) {
                    return;
                }
                if (PlayerFX.this.player.getStatus() != MediaPlayer.Status.PLAYING) {
                    if (PlayerFX.this.player.getStatus() != MediaPlayer.Status.READY && PlayerFX.this.player.getStatus() != MediaPlayer.Status.PAUSED && PlayerFX.this.player.getStatus() != MediaPlayer.Status.STOPPED) {
                        System.out.println("No ready,paused,stopped");
                        return;
                    }
                    PlayerFX.this.pauseButton.setText("Pause");
                    PlayerFX.this.player.play();
                    PlayerFX.this.playVideoCompare();
                } else {
                    PlayerFX.this.pauseButton.setText("Play");
                    PlayerFX.this.player.pause();
                    PlayerFX.this.pauseVideoCompare();
                }
            }
        });
    }

    public long getCurrentMills() {
        Duration timeD = this.player.getCurrentTime();
        return (long)timeD.toMillis();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.videoCompare) {
            return;
        }
        if (this.inRidimensionamento) {
            this.inRidimensionamento = false;
            return;
        }
        this.adattaAspectRatio();
        this.padre.ridimensionaVideoCompare();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (!this.isVisible()) {
            return;
        }
        DanasPreferences.setVideoPositionX(this.getLocationOnScreen().x);
        DanasPreferences.setVideoPositionY(this.getLocationOnScreen().y);
        this.padre.riposizionaVideoCompare();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.multiSincro)) {
            if (!this.multiSincro.getAggiornaVideo()) {
                return;
            }
            if (this.player == null) {
                return;
            }
            if (this.player.getStatus() == MediaPlayer.Status.PLAYING) {
                return;
            }
            double letturaMultisincro = this.multiSincro.getPosizioneCursore();
            if (!this.videoCompare) {
                letturaMultisincro += this.multiSincro.getOffsetVideo();
            } else {
                double offset = 0.0;
                if (this.dati.getVideoCompareLap() != null) {
                    offset = this.dati.getVideoCompareLap().getStart() - this.dati.getVideoCompareLap().getSession().getStartTelemetryTime() - this.dati.getVideoCompareLap().getOffsetTempo();
                } else if (!this.videoChiuso) {
                    this.pausa();
                }
                letturaMultisincro = letturaMultisincro + offset + (double)DanasPreferences.getRitardoVideoCompare();
            }
            if (letturaMultisincro < 0.0 || letturaMultisincro > (double)this.getVideoLength()) {
                return;
            }
            this.posizione = this.getPosition();
            if (this.videoChiuso) {
                return;
            }
            this.player.seek(Duration.millis(letturaMultisincro * 10.0));
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlayerFX d = new PlayerFX(false, null);
            }
        });
    }

    private final class UpdateRunnable
    implements Runnable {
        private UpdateRunnable() {
        }

        @Override
        public void run() {
            if (PlayerFX.this.player == null) {
                return;
            }
            if (!PlayerFX.this.isVisible()) {
                return;
            }
            Duration timeD = PlayerFX.this.player.getCurrentTime();
            Duration durationD = PlayerFX.this.player.getTotalDuration();
            double time = timeD.toMillis();
            double duration = durationD.toMillis();
            int position = duration > 0.0 ? (int)Math.round(100.0 * time / duration) : 0;
            PlayerFX.this.updateTime((long)time);
            PlayerFX.this.updatePosition(position);
            PlayerFX.this.updateMultiSincro();
        }
    }
}

