/*
 * Decompiled with CFR 0.152.
 */
package i2m.traguardi;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Language;
import i2m.mappa.Mappa2D;
import i2m.traguardi.Circuit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SceltaCircuitoDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton openB;
    JButton esciB;
    DefaultListModel elencoCircuitiLM;
    JList list;
    Circuit circuitoSelezionato;
    Mappa2D mappa;

    public SceltaCircuitoDialog(Frame owner, Mappa2D map) {
        super(owner, Language.string("Scelta circuito"), true);
        this.mappa = map;
        this.elencoCircuitiLM = new DefaultListModel();
        this.elencoCircuitiLM.clear();
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.openB = new JButton(Language.string("Apri"));
        this.openB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.openB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        this.list = new JList(this.elencoCircuitiLM);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(150, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        pannelloPrincipale.add((Component)listScroller, "Center");
        this.list.setSelectionMode(0);
        try {
            File f = new File("./defaultCircuits.cir");
            System.out.println(f.toString());
            this.caricaDaFile(f);
            this.sort(this.elencoCircuitiLM);
        }
        catch (NullPointerException ex) {
            JOptionPane.showMessageDialog(this, Language.string("File dei circuiti corrotto o inesistente!"), Language.string("ATTENZIONE"), 0);
        }
        if (this.elencoCircuitiLM.size() > 0) {
            this.list.setSelectedIndex(0);
        } else {
            this.openB.setEnabled(false);
        }
        this.pack();
        this.setResizable(false);
        this.setSize(new Dimension(230, 230));
    }

    public void ricaricaCircuiti() {
        this.elencoCircuitiLM.clear();
        try {
            File f = new File("./defaultCircuits.cir");
            System.out.println(f.toString());
            this.caricaDaFile(f);
            this.sort(this.elencoCircuitiLM);
        }
        catch (NullPointerException ex) {
            JOptionPane.showMessageDialog(this, Language.string("File dei circuiti corrotto o inesistente!"), Language.string("ATTENZIONE"), 0);
        }
        if (this.elencoCircuitiLM.size() > 0) {
            this.list.setSelectedIndex(0);
        } else {
            this.openB.setEnabled(false);
        }
    }

    public void caricaDaFile(File f) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    Circuit c = new Circuit(line);
                    this.elencoCircuitiLM.addElement(c);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ((Circuit)this.elencoCircuitiLM.elementAt(this.elencoCircuitiLM.size() - 1)).aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Circuit trovaCircuito(double latitudine, double longitudine) {
        Vector<Circuit> elencoCircuiti = new Vector<Circuit>();
        try {
            String line;
            File f = new File("./defaultCircuits.cir");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    Circuit c = new Circuit(line);
                    elencoCircuiti.addElement(c);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ((Circuit)elencoCircuiti.elementAt(elencoCircuiti.size() - 1)).aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            System.out.println("Errore nel caricamento dei circuiti");
            ex.printStackTrace();
            return null;
        }
        for (int i = 0; i < elencoCircuiti.size(); ++i) {
            double latitudineTraguardo = 0.0;
            double longitudineTraguardo = 0.0;
            latitudineTraguardo = ((Circuit)elencoCircuiti.get(i)).getAttraversamento(0).getLatitudineDecimale();
            longitudineTraguardo = ((Circuit)elencoCircuiti.get(i)).getAttraversamento(0).getLongitudineDecimale();
            if (!(Math.abs(latitudine - latitudineTraguardo) < 7000.0) || !(Math.abs(longitudine - longitudineTraguardo) < 7000.0)) continue;
            return (Circuit)elencoCircuiti.get(i);
        }
        return null;
    }

    public static Vector<Circuit> trovaElencoCircuiti(double latitudine, double longitudine) {
        Vector<Circuit> elencoCircuiti = new Vector<Circuit>();
        Vector<Circuit> elencoCircuitiTrovati = new Vector<Circuit>();
        try {
            String line;
            File f = new File("./defaultCircuits.cir");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    Circuit c = new Circuit(line);
                    elencoCircuiti.addElement(c);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ((Circuit)elencoCircuiti.elementAt(elencoCircuiti.size() - 1)).aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            System.out.println("Errore nel caricamento dei circuiti");
            ex.printStackTrace();
            return null;
        }
        for (int i = 0; i < elencoCircuiti.size(); ++i) {
            double latitudineTraguardo = 0.0;
            double longitudineTraguardo = 0.0;
            latitudineTraguardo = ((Circuit)elencoCircuiti.get(i)).getAttraversamento(0).getLatitudineDecimale();
            longitudineTraguardo = ((Circuit)elencoCircuiti.get(i)).getAttraversamento(0).getLongitudineDecimale();
            if (!(Math.abs(latitudine - latitudineTraguardo) < 7000.0) || !(Math.abs(longitudine - longitudineTraguardo) < 7000.0)) continue;
            elencoCircuitiTrovati.addElement((Circuit)elencoCircuiti.get(i));
        }
        return elencoCircuitiTrovati;
    }

    public static int numeroCircuitiVicini(double latitudine, double longitudine) {
        int numeroCircuiti = 0;
        Vector<Circuit> elencoCircuiti = new Vector<Circuit>();
        try {
            String line;
            File f = new File("./defaultCircuits.cir");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    Circuit c = new Circuit(line);
                    elencoCircuiti.addElement(c);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ((Circuit)elencoCircuiti.elementAt(elencoCircuiti.size() - 1)).aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            System.out.println("Errore nel caricamento dei circuiti");
            ex.printStackTrace();
            return 0;
        }
        for (int i = 0; i < elencoCircuiti.size(); ++i) {
            double latitudineTraguardo = 0.0;
            double longitudineTraguardo = 0.0;
            latitudineTraguardo = ((Circuit)elencoCircuiti.get(i)).getAttraversamento(0).getLatitudineDecimale();
            longitudineTraguardo = ((Circuit)elencoCircuiti.get(i)).getAttraversamento(0).getLongitudineDecimale();
            if (!(Math.abs(latitudine - latitudineTraguardo) < 7000.0) || !(Math.abs(longitudine - longitudineTraguardo) < 7000.0)) continue;
            ++numeroCircuiti;
        }
        return numeroCircuiti;
    }

    public static int numeroPrimoCircuitoVicino(double latitudine, double longitudine) {
        int numeroCircuito = -1;
        Vector<Circuit> elencoCircuiti = new Vector<Circuit>();
        try {
            String line;
            File f = new File("./defaultCircuits.cir");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    Circuit c = new Circuit(line);
                    elencoCircuiti.addElement(c);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ((Circuit)elencoCircuiti.elementAt(elencoCircuiti.size() - 1)).aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            System.out.println("Errore nel caricamento dei circuiti");
            ex.printStackTrace();
            return -1;
        }
        for (int i = 0; i < elencoCircuiti.size(); ++i) {
            double latitudineTraguardo = 0.0;
            double longitudineTraguardo = 0.0;
            latitudineTraguardo = ((Circuit)elencoCircuiti.get(i)).getAttraversamento(0).getLatitudineDecimale();
            longitudineTraguardo = ((Circuit)elencoCircuiti.get(i)).getAttraversamento(0).getLongitudineDecimale();
            if (!(Math.abs(latitudine - latitudineTraguardo) < 7000.0) || !(Math.abs(longitudine - longitudineTraguardo) < 7000.0)) continue;
            return i;
        }
        return -1;
    }

    void sort(DefaultListModel<Object> dlm) {
        Object[] dlma = dlm.toArray();
        Arrays.sort(dlma);
        dlm.clear();
        for (Object x : dlma) {
            dlm.addElement(x);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source.equals(this.esciB)) {
            this.dispose();
        }
        if (source.equals(this.openB)) {
            this.circuitoSelezionato = (Circuit)this.list.getSelectedValue();
            this.mappa.importaTraguardi(this.circuitoSelezionato);
            DanasDataStructure.getInstance().ricalcolaValoriGiri();
            System.out.println("DEBUG: tempo minimo scelta circuito:" + this.circuitoSelezionato.getTempoMinimo());
            this.dispose();
        }
    }
}

