/*
 * Decompiled with CFR 0.152.
 */
package i2m.traguardi;

import i2m.traguardi.Attraversamento;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;

public class Circuit
implements Comparable<Circuit> {
    private String nome;
    private float latitudine;
    private float longitudine;
    private String emisfero;
    private String verso;
    private int direzione;
    private int usaDirezione;
    private DefaultListModel attraversamentiLM;
    private int sensibilita;
    private double tempoMinimo = 0.0;

    public Circuit(String nomeCircuito, float latitudineTraguardo, String emisferoTraguardo, float longitudineTraguardo, String versoTraguardo, int direzioneTraguardo, int direzioneValida) {
        Attraversamento att = new Attraversamento(nomeCircuito, latitudineTraguardo, emisferoTraguardo, longitudineTraguardo, versoTraguardo, direzioneTraguardo, direzioneValida, 0);
        this.attraversamentiLM = new DefaultListModel();
        this.attraversamentiLM.addElement(att);
    }

    public Circuit(String line) {
        this.estraiInfo(line);
        Attraversamento att = new Attraversamento(this.nome, this.latitudine, this.emisfero, this.longitudine, this.verso, this.direzione, this.usaDirezione, this.sensibilita);
        this.attraversamentiLM = new DefaultListModel();
        this.attraversamentiLM.addElement(att);
    }

    public void copiaCircuito(Circuit origine) {
        this.attraversamentiLM.clear();
        for (int i = 0; i < origine.numeroAttraversamenti(); ++i) {
            Attraversamento at = new Attraversamento();
            at.copia(origine.getAttraversamento(i));
            this.attraversamentiLM.addElement(at);
        }
        this.tempoMinimo = origine.getTempoMinimo();
    }

    public double getTempoMinimo() {
        return this.tempoMinimo;
    }

    public void setTempoMinimo(double tempo) {
        this.tempoMinimo = tempo;
    }

    public boolean isCircuitValid() {
        return this.latitudine != 0.0f || this.longitudine != 0.0f;
    }

    private void estraiInfo(String line) {
        boolean eccezione = false;
        StringTokenizer st = new StringTokenizer(line, ",");
        st.nextElement();
        st.nextElement();
        this.nome = st.nextToken();
        try {
            this.latitudine = Float.valueOf(st.nextToken()).floatValue();
        }
        catch (Exception e) {
            this.latitudine = 0.0f;
        }
        this.emisfero = st.nextElement().toString();
        try {
            this.longitudine = Float.valueOf(st.nextToken()).floatValue();
        }
        catch (Exception e) {
            this.longitudine = 0.0f;
        }
        this.verso = st.nextElement().toString();
        try {
            this.direzione = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            this.direzione = 0;
            eccezione = true;
        }
        try {
            this.usaDirezione = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            this.usaDirezione = 1;
        }
        if (eccezione) {
            this.usaDirezione = 0;
        }
        try {
            this.sensibilita = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            this.sensibilita = 0;
        }
        if (line.startsWith("t,") && st.hasMoreTokens()) {
            try {
                this.tempoMinimo = Integer.parseInt(st.nextToken());
            }
            catch (Exception e) {
                this.tempoMinimo = 0.0;
            }
        }
    }

    public void aggiungiSplit(int numero, float latitudineTraguardo, String emisferoTraguardo, float longitudineTraguardo, String versoTraguardo, int direzioneTraguardo, int direzioneValida, int sensibilita) {
        String nomeSplit = "SPLIT" + Integer.valueOf(numero).toString();
        Attraversamento att = new Attraversamento(nomeSplit, latitudineTraguardo, emisferoTraguardo, longitudineTraguardo, versoTraguardo, direzioneTraguardo, direzioneValida, sensibilita);
        this.attraversamentiLM.addElement(att);
    }

    public void aggiungiSplit(String line) {
        this.estraiInfo(line);
        Attraversamento att = new Attraversamento(this.nome, this.latitudine, this.emisfero, this.longitudine, this.verso, this.direzione, this.usaDirezione, this.sensibilita);
        this.attraversamentiLM.addElement(att);
    }

    public boolean versoValido(String line) {
        this.estraiInfo(line);
        return this.usaDirezione == 1;
    }

    public Attraversamento getAttraversamento(int index) {
        if (index >= this.attraversamentiLM.size()) {
            return null;
        }
        return (Attraversamento)this.attraversamentiLM.elementAt(index);
    }

    public void rimuoviSplit(int index) {
        if (index != 0 && index < this.attraversamentiLM.size()) {
            this.attraversamentiLM.remove(index);
        }
    }

    public boolean ugualeMini(Circuit c, boolean ancheSplit) {
        if (this.numeroAttraversamenti() > 0 && !this.getAttraversamento(0).uguale(c.getAttraversamento(0))) {
            return false;
        }
        if (!ancheSplit) {
            return true;
        }
        if (this.numeroAttraversamenti() > 1 && !this.getAttraversamento(1).uguale(c.getAttraversamento(1))) {
            return false;
        }
        return this.numeroAttraversamenti() <= 2 || this.getAttraversamento(2).uguale(c.getAttraversamento(2));
    }

    public boolean ugualeChrome(Circuit c) {
        if (this.numeroAttraversamenti() > 0 && !this.getAttraversamento(0).uguale(c.getAttraversamento(0))) {
            return false;
        }
        if (this.numeroAttraversamenti() != c.numeroAttraversamenti()) {
            return false;
        }
        if (this.numeroAttraversamenti() > 1 && !this.getAttraversamento(1).uguale(c.getAttraversamento(1))) {
            return false;
        }
        if (this.numeroAttraversamenti() > 2 && !this.getAttraversamento(2).uguale(c.getAttraversamento(2))) {
            return false;
        }
        return this.numeroAttraversamenti() <= 3 || this.getAttraversamento(3).uguale(c.getAttraversamento(3));
    }

    public void riordinaNomiSplit() {
        Integer i = this.numeroAttraversamenti();
        if (i > 1) {
            Integer j = 1;
            while (j < i) {
                String nomeSplit = "SPLIT" + j.toString();
                System.out.println("riordina:" + nomeSplit);
                ((Attraversamento)this.attraversamentiLM.elementAt(j)).setNome(nomeSplit);
                Integer n = j;
                Integer n2 = j = Integer.valueOf(j + 1);
            }
        }
    }

    public void setNome(String s) {
        ((Attraversamento)this.attraversamentiLM.elementAt(0)).setNome(s);
    }

    public String getNome() {
        return ((Attraversamento)this.attraversamentiLM.elementAt(0)).getNome();
    }

    public int numeroAttraversamenti() {
        return this.attraversamentiLM.size();
    }

    public String toString() {
        return this.attraversamentiLM.elementAt(0).toString();
    }

    public String getChromeString() {
        String tempi = "59:59.000;59:59.000;0;59:59.000;59:59.000;59:59.000;59:59.000;59:59.000;59:59.000;";
        String tempi4 = "59:59.000;59:59.000;";
        String nullo = "0000.0000,S;00000.0000,E;000;";
        switch (this.attraversamentiLM.size()) {
            case 1: {
                return ((Attraversamento)this.attraversamentiLM.elementAt(0)).getNome() + ";" + ((Attraversamento)this.attraversamentiLM.elementAt(0)).getChromeString() + nullo + nullo + tempi + nullo + tempi4;
            }
            case 2: {
                return ((Attraversamento)this.attraversamentiLM.elementAt(0)).getNome() + ";" + ((Attraversamento)this.attraversamentiLM.elementAt(0)).getChromeString() + ((Attraversamento)this.attraversamentiLM.elementAt(1)).getChromeString() + nullo + tempi + nullo + tempi4;
            }
            case 3: {
                return ((Attraversamento)this.attraversamentiLM.elementAt(0)).getNome() + ";" + ((Attraversamento)this.attraversamentiLM.elementAt(0)).getChromeString() + ((Attraversamento)this.attraversamentiLM.elementAt(1)).getChromeString() + ((Attraversamento)this.attraversamentiLM.elementAt(2)).getChromeString() + tempi + nullo + tempi4;
            }
            case 4: {
                return ((Attraversamento)this.attraversamentiLM.elementAt(0)).getNome() + ";" + ((Attraversamento)this.attraversamentiLM.elementAt(0)).getChromeString() + ((Attraversamento)this.attraversamentiLM.elementAt(1)).getChromeString() + ((Attraversamento)this.attraversamentiLM.elementAt(2)).getChromeString() + tempi + ((Attraversamento)this.attraversamentiLM.elementAt(3)).getChromeString() + tempi4;
            }
        }
        return "";
    }

    public String getMinilapString(int numeroCircuito, int numeroSplit) {
        if (numeroSplit == 0) {
            return "t," + String.format("%02d,", numeroCircuito + 1) + ((Attraversamento)this.attraversamentiLM.elementAt(0)).getMinilapString() + "," + String.format("%.0f,", this.tempoMinimo);
        }
        return "s," + String.format("%02d,", numeroSplit) + ((Attraversamento)this.attraversamentiLM.elementAt(numeroSplit)).getMinilapString();
    }

    @Override
    public int compareTo(Circuit o) {
        return this.getAttraversamento(0).getNome().compareToIgnoreCase(o.getAttraversamento(0).getNome());
    }
}

