/*
 * Decompiled with CFR 0.152.
 */
package i2m.traguardi;

import java.util.Locale;

public class Attraversamento {
    private String nome;
    private double latitudine;
    private double longitudine;
    private String emisfero;
    private String verso;
    private int direzione;
    private int usaDirezione;
    private int sensibilita;

    public Attraversamento() {
    }

    public Attraversamento(String nomeAttraversamento, double latitudineAttraversamento, String emisferoAttraversamento, double longitudineAttraversamento, String versoAttraversamento, int direzioneAttraversamento, int direzioneValida, int sensibilitaRelativa) {
        this.usaDirezione = 1;
        this.nome = nomeAttraversamento;
        this.latitudine = latitudineAttraversamento;
        this.emisfero = emisferoAttraversamento;
        this.longitudine = longitudineAttraversamento;
        this.verso = versoAttraversamento;
        this.direzione = direzioneAttraversamento;
        this.usaDirezione = direzioneValida;
        this.sensibilita = sensibilitaRelativa;
    }

    public void copia(Attraversamento origine) {
        this.nome = origine.getNome();
        this.latitudine = origine.getLatitudine();
        this.longitudine = origine.getLongitudine();
        this.emisfero = origine.getEmisfero();
        this.verso = origine.getVerso();
        this.direzione = origine.getDirezione();
        this.usaDirezione = origine.isDirezioneValida() ? 1 : 0;
        this.sensibilita = origine.getSensibilita();
    }

    public String getStringaPulita(String origine) {
        if (origine == null) {
            origine = "Error";
        }
        String finale = origine;
        while (finale.endsWith(" ")) {
            finale = finale.substring(0, finale.length() - 1);
        }
        while (finale.startsWith(" ")) {
            finale = finale.substring(1, finale.length());
        }
        if (finale.length() == 0) {
            finale = "Error";
        }
        return finale;
    }

    public String getNome() {
        return this.getStringaPulita(this.nome);
    }

    public void setNome(String nomeAttraversamento) {
        this.nome = nomeAttraversamento;
    }

    public void setDirezione(int direzioneAttraversamento) {
        this.direzione = direzioneAttraversamento;
    }

    public int getDirezione() {
        return this.direzione;
    }

    public void setSensibilita(int sensibilitaRelativa) {
        this.sensibilita = sensibilitaRelativa;
    }

    public int getSensibilita() {
        return this.sensibilita;
    }

    public boolean isDirezioneValida() {
        return this.usaDirezione == 1;
    }

    public void setDirezioneValida(boolean valida) {
        this.usaDirezione = valida ? 1 : 0;
    }

    public void setLatitudine(double latitudineAttraversamento) {
        this.latitudine = latitudineAttraversamento;
    }

    public Double getLatitudine() {
        return this.latitudine;
    }

    public void setLongitudine(double longitudineAttraversamento) {
        this.longitudine = longitudineAttraversamento;
    }

    public Double getLongitudine() {
        return this.longitudine;
    }

    public double getLatitudineDecimale() {
        String s = String.format("%09.4f", this.latitudine);
        double res = Double.valueOf(s.substring(0, 2)) * 600000.0 + Double.valueOf(s.substring(2, 4)) * 10000.0 + Double.valueOf(s.substring(5));
        if (this.emisfero.startsWith("N")) {
            return res;
        }
        return -res;
    }

    public double getLongitudineDecimale() {
        String s = String.format("%010.4f", this.longitudine);
        double res = Double.valueOf(s.substring(0, 3)) * 600000.0 + Double.valueOf(s.substring(3, 5)) * 10000.0 + Double.valueOf(s.substring(6));
        if (this.verso.startsWith("E")) {
            return res;
        }
        return -res;
    }

    public boolean uguale(Attraversamento a) {
        if (a == null) {
            return false;
        }
        if (!this.emisfero.equals(a.getEmisfero())) {
            return false;
        }
        if (!this.verso.equals(a.getVerso())) {
            return false;
        }
        if (this.latitudine != a.getLatitudine()) {
            return false;
        }
        if (this.longitudine != a.getLongitudine()) {
            return false;
        }
        return this.direzione == a.getDirezione();
    }

    public String getEmisfero() {
        return this.emisfero;
    }

    public void setEmisfero(String emisferoAttraversamento) {
        this.emisfero = emisferoAttraversamento;
    }

    public void setVerso(String versoAttraversamento) {
        this.verso = versoAttraversamento;
    }

    public String getVerso() {
        return this.verso;
    }

    public String toString() {
        return this.nome;
    }

    public String getMinilapString() {
        String line = "        ";
        this.nome = this.nome.concat(line);
        this.nome = this.nome.substring(0, 8);
        line = String.format(Locale.US, "%8s,%09.4f," + this.emisfero + ",%010.04f," + this.verso + ",%03d,%1d," + this.sensibilita + ",", this.nome, this.latitudine, this.longitudine, this.direzione, this.usaDirezione);
        return line;
    }

    public String getChromeString() {
        String line = "        ";
        line = String.format(Locale.US, "%09.4f," + this.emisfero + ";%010.04f," + this.verso + ";%03d;", this.latitudine, this.longitudine, this.direzione);
        return line;
    }
}

