/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.Language;
import i2m.onLine.SerialConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SensoriDialogDasyPro
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton esciButton;
    private JButton nextButton;
    JRadioButton bottoneAnalog1;
    JRadioButton bottoneAnalog2;
    JRadioButton bottoneAnalog3;
    JRadioButton bottoneAnalog4;
    JRadioButton bottoneAnalog5;
    JRadioButton bottoneAnalog6;
    JRadioButton bottoneAnalog7;
    JRadioButton bottoneAnalog8;
    JComboBox sensoriCB;
    boolean analog1Settato = false;
    boolean analog2Settato = false;
    boolean analog3Settato = false;
    boolean analog4Settato = false;
    boolean analog5Settato = false;
    boolean analog6Settato = false;
    boolean analog7Settato = false;
    boolean analog8Settato = false;
    float minAnalog1 = 0.0f;
    float maxAnalog1 = 1023.0f;
    float minAnalog2 = 0.0f;
    float maxAnalog2 = 1023.0f;
    float minAnalog3 = 0.0f;
    float maxAnalog3 = 1023.0f;
    float minAnalog4 = 0.0f;
    float maxAnalog4 = 1023.0f;
    float minAnalog5 = 0.0f;
    float maxAnalog5 = 1023.0f;
    float minAnalog6 = 0.0f;
    float maxAnalog6 = 1023.0f;
    float minAnalog7 = 0.0f;
    float maxAnalog7 = 1023.0f;
    float minAnalog8 = 0.0f;
    float maxAnalog8 = 1023.0f;
    SerialConnection conn = null;

    public SensoriDialogDasyPro(JDialog owner, SerialConnection connessione) {
        super(owner, Language.string("Setting sensori"), true);
        this.conn = connessione;
        JPanel pannelloBottoni = new JPanel();
        this.esciButton = new JButton(Language.string("Esci"));
        this.esciButton.addActionListener(this);
        this.nextButton = new JButton(Language.string("Avanti"));
        this.nextButton.addActionListener(this);
        pannelloBottoni.add(this.esciButton);
        pannelloBottoni.add(this.nextButton);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel sceltaSensorePanel = new JPanel();
        String[] listaSensori = new String[]{Language.string("Potenziometro 50mm"), Language.string("Potenziometro 75mm"), Language.string("Potenziometro 100mm"), Language.string("Potenziometro 150mm"), Language.string("Temperatura gomme I2M"), Language.string("Pressione 50Bar"), "TPS", Language.string("Adattatore PT100"), Language.string("Adattatore Termocoppia"), Language.string("Zero canale"), Language.string("Pressione 100Bar")};
        this.sensoriCB = new JComboBox<String>(listaSensori);
        this.sensoriCB.setMaximumSize(new Dimension(90, 20));
        sceltaSensorePanel.add(this.sensoriCB);
        JPanel pannelloSotto = new JPanel(new BorderLayout());
        pannelloSotto.add((Component)sceltaSensorePanel, "North");
        pannelloSotto.add((Component)pannelloBottoni, "South");
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloMessaggio = new JPanel();
        pannelloMessaggio.setLayout(new BoxLayout(pannelloMessaggio, 1));
        JLabel messageLabel = new JLabel(Language.string("Scegliere l'ingresso e selezionare il sensore voluto "));
        messageLabel.setAlignmentX(0.5f);
        pannelloMessaggio.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloMessaggio.add(messageLabel);
        pannelloMessaggio.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloPrincipale.add((Component)pannelloMessaggio, "North");
        JPanel pannelloCentrale = new JPanel();
        pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
        JPanel pannelloScelte = new JPanel();
        pannelloScelte.setLayout(new BoxLayout(pannelloScelte, 1));
        this.bottoneAnalog1 = new JRadioButton("Analog1");
        this.bottoneAnalog2 = new JRadioButton("Analog2");
        this.bottoneAnalog3 = new JRadioButton("Analog3");
        this.bottoneAnalog4 = new JRadioButton("Analog4");
        this.bottoneAnalog5 = new JRadioButton("Analog5");
        this.bottoneAnalog6 = new JRadioButton("Analog6");
        this.bottoneAnalog7 = new JRadioButton("Analog7");
        this.bottoneAnalog8 = new JRadioButton("Analog8");
        pannelloScelte.add(this.bottoneAnalog1);
        pannelloScelte.add(this.bottoneAnalog2);
        pannelloScelte.add(this.bottoneAnalog3);
        pannelloScelte.add(this.bottoneAnalog4);
        pannelloScelte.add(this.bottoneAnalog5);
        pannelloScelte.add(this.bottoneAnalog6);
        pannelloScelte.add(this.bottoneAnalog7);
        pannelloScelte.add(this.bottoneAnalog8);
        this.bottoneAnalog1.setSelected(true);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(30, 0)));
        pannelloCentrale.add(pannelloScelte);
        ButtonGroup group = new ButtonGroup();
        group.add(this.bottoneAnalog1);
        group.add(this.bottoneAnalog2);
        group.add(this.bottoneAnalog3);
        group.add(this.bottoneAnalog4);
        group.add(this.bottoneAnalog5);
        group.add(this.bottoneAnalog6);
        group.add(this.bottoneAnalog7);
        group.add(this.bottoneAnalog8);
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)pannelloSotto, "South");
        this.setContentPane(pannelloPrincipale);
        this.setSize(new Dimension(320, 350));
        this.setResizable(false);
        owner.setVisible(true);
    }

    public boolean isAnalogSet(int index) {
        switch (index) {
            case 1: {
                return this.analog1Settato;
            }
            case 2: {
                return this.analog2Settato;
            }
            case 3: {
                return this.analog3Settato;
            }
            case 4: {
                return this.analog4Settato;
            }
            case 5: {
                return this.analog5Settato;
            }
            case 6: {
                return this.analog6Settato;
            }
            case 7: {
                return this.analog7Settato;
            }
            case 8: {
                return this.analog8Settato;
            }
        }
        return false;
    }

    public int getAnalogSet() {
        if (this.analog1Settato) {
            return 0;
        }
        if (this.analog2Settato) {
            return 1;
        }
        if (this.analog3Settato) {
            return 2;
        }
        if (this.analog4Settato) {
            return 3;
        }
        if (this.analog5Settato) {
            return 4;
        }
        if (this.analog6Settato) {
            return 5;
        }
        if (this.analog7Settato) {
            return 6;
        }
        if (this.analog8Settato) {
            return 7;
        }
        return -1;
    }

    private void clearSettati() {
        this.analog1Settato = false;
        this.analog2Settato = false;
        this.analog3Settato = false;
        this.analog4Settato = false;
        this.analog5Settato = false;
        this.analog6Settato = false;
        this.analog7Settato = false;
        this.analog8Settato = false;
    }

    public boolean isSet() {
        return this.analog1Settato || this.analog2Settato || this.analog3Settato || this.analog4Settato || this.analog5Settato || this.analog6Settato || this.analog7Settato || this.analog8Settato;
    }

    public void setMinAnalog(int index, float min) {
        switch (index) {
            case 1: {
                this.minAnalog1 = min;
            }
            case 2: {
                this.minAnalog2 = min;
            }
            case 3: {
                this.minAnalog3 = min;
            }
            case 4: {
                this.minAnalog4 = min;
            }
            case 5: {
                this.minAnalog5 = min;
            }
            case 6: {
                this.minAnalog6 = min;
            }
            case 7: {
                this.minAnalog7 = min;
            }
            case 8: {
                this.minAnalog8 = min;
            }
        }
        System.out.println("DEBUG, min" + index + "=" + min);
    }

    public void setMaxAnalog(int index, float max) {
        switch (index) {
            case 1: {
                this.maxAnalog1 = max;
            }
            case 2: {
                this.maxAnalog2 = max;
            }
            case 3: {
                this.maxAnalog3 = max;
            }
            case 4: {
                this.maxAnalog4 = max;
            }
            case 5: {
                this.maxAnalog5 = max;
            }
            case 6: {
                this.maxAnalog6 = max;
            }
            case 7: {
                this.maxAnalog7 = max;
            }
            case 8: {
                this.maxAnalog8 = max;
            }
        }
        System.out.println("DEBUG, max" + index + "=" + max);
    }

    public float getMinAnalog(int index) {
        switch (index) {
            case 1: {
                return this.minAnalog1;
            }
            case 2: {
                return this.minAnalog2;
            }
            case 3: {
                return this.minAnalog3;
            }
            case 4: {
                return this.minAnalog4;
            }
            case 5: {
                return this.minAnalog5;
            }
            case 6: {
                return this.minAnalog6;
            }
            case 7: {
                return this.minAnalog7;
            }
            case 8: {
                return this.minAnalog8;
            }
        }
        return 0.0f;
    }

    public float getMaxAnalog(int index) {
        switch (index) {
            case 1: {
                return this.maxAnalog1;
            }
            case 2: {
                return this.maxAnalog2;
            }
            case 3: {
                return this.maxAnalog3;
            }
            case 4: {
                return this.maxAnalog4;
            }
            case 5: {
                return this.maxAnalog5;
            }
            case 6: {
                return this.maxAnalog6;
            }
            case 7: {
                return this.maxAnalog7;
            }
            case 8: {
                return this.maxAnalog8;
            }
        }
        return 1023.0f;
    }

    public String acquisisciLinea() throws Exception {
        this.conn.write("$ONLINERAW\r");
        String letta = this.conn.readLine();
        System.out.println("DEBUG letta onlineraw=" + letta);
        return letta;
    }

    public int leggiAnalog(String stringa, int index) throws Exception {
        int i;
        int[] rawAnalog = new int[8];
        String token = null;
        String stringTempDataLine = stringa;
        for (i = 0; i < 8; ++i) {
            rawAnalog[i] = 0;
        }
        if (stringTempDataLine.startsWith("$ON_RAW")) {
            StringTokenizer st = new StringTokenizer(stringTempDataLine, ",");
            st.nextToken();
            for (i = 0; i < 8; ++i) {
                if (!st.hasMoreTokens()) continue;
                token = st.nextToken();
                rawAnalog[i] = Integer.valueOf(token);
            }
        }
        System.out.println("DEBUG: letto:" + rawAnalog[index - 1]);
        return rawAnalog[index - 1];
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int index = 1;
        if (this.bottoneAnalog1.isSelected()) {
            index = 1;
        }
        if (this.bottoneAnalog2.isSelected()) {
            index = 2;
        }
        if (this.bottoneAnalog3.isSelected()) {
            index = 3;
        }
        if (this.bottoneAnalog4.isSelected()) {
            index = 4;
        }
        if (this.bottoneAnalog5.isSelected()) {
            index = 5;
        }
        if (this.bottoneAnalog6.isSelected()) {
            index = 6;
        }
        if (this.bottoneAnalog7.isSelected()) {
            index = 7;
        }
        if (this.bottoneAnalog8.isSelected()) {
            index = 8;
        }
        if (evt.getSource() == this.esciButton) {
            this.dispose();
        }
        if (evt.getSource() == this.nextButton) {
            float zero;
            float massimo;
            float minimo;
            this.clearSettati();
            if (this.sensoriCB.getSelectedIndex() == 0 || this.sensoriCB.getSelectedIndex() == 1 || this.sensoriCB.getSelectedIndex() == 2 || this.sensoriCB.getSelectedIndex() == 3) {
                float lunghezza = 150.0f;
                if (this.sensoriCB.getSelectedIndex() == 0) {
                    lunghezza = 50.0f;
                }
                if (this.sensoriCB.getSelectedIndex() == 1) {
                    lunghezza = 75.0f;
                }
                if (this.sensoriCB.getSelectedIndex() == 2) {
                    lunghezza = 100.0f;
                }
                if (this.sensoriCB.getSelectedIndex() == 3) {
                    lunghezza = 150.0f;
                }
                JOptionPane.showMessageDialog(this, Language.string("Premere OK per fissare lo zero"), Language.string("Setting"), 1);
                float minimo2 = 0.0f;
                float massimo2 = 1023.0f;
                float zero2 = 0.0f;
                try {
                    zero2 = this.leggiAnalog(this.acquisisciLinea(), index);
                    minimo2 = -(zero2 * lunghezza / 1023.0f);
                    massimo2 = lunghezza - zero2 * lunghezza / 1023.0f;
                    if (this.bottoneAnalog1.isSelected()) {
                        this.analog1Settato = true;
                        this.minAnalog1 = minimo2;
                        this.maxAnalog1 = massimo2;
                    }
                    if (this.bottoneAnalog2.isSelected()) {
                        this.analog2Settato = true;
                        this.minAnalog2 = minimo2;
                        this.maxAnalog2 = massimo2;
                    }
                    if (this.bottoneAnalog3.isSelected()) {
                        this.analog3Settato = true;
                        this.minAnalog3 = minimo2;
                        this.maxAnalog3 = massimo2;
                    }
                    if (this.bottoneAnalog4.isSelected()) {
                        this.analog4Settato = true;
                        this.minAnalog4 = minimo2;
                        this.maxAnalog4 = massimo2;
                    }
                    if (this.bottoneAnalog5.isSelected()) {
                        this.analog5Settato = true;
                        this.minAnalog5 = minimo2;
                        this.maxAnalog5 = massimo2;
                    }
                    if (this.bottoneAnalog6.isSelected()) {
                        this.analog6Settato = true;
                        this.minAnalog6 = minimo2;
                        this.maxAnalog6 = massimo2;
                    }
                    if (this.bottoneAnalog7.isSelected()) {
                        this.analog7Settato = true;
                        this.minAnalog7 = minimo2;
                        this.maxAnalog7 = massimo2;
                    }
                    if (this.bottoneAnalog8.isSelected()) {
                        this.analog8Settato = true;
                        this.minAnalog8 = minimo2;
                        this.maxAnalog8 = massimo2;
                    }
                    JOptionPane.showMessageDialog(this, Language.string("potenziometro lineare configurato"), Language.string("Setting"), 1);
                    this.dispose();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                }
            }
            if (this.sensoriCB.getSelectedIndex() == 9) {
                minimo = 0.0f;
                massimo = 1023.0f;
                zero = 0.0f;
                if (this.bottoneAnalog1.isSelected()) {
                    minimo = this.minAnalog1;
                    massimo = this.maxAnalog1;
                }
                if (this.bottoneAnalog2.isSelected()) {
                    minimo = this.minAnalog2;
                    massimo = this.maxAnalog2;
                    System.out.println("DEBUG:  minimo2=" + this.minAnalog2 + " massimo2=" + this.maxAnalog2);
                }
                if (this.bottoneAnalog3.isSelected()) {
                    minimo = this.minAnalog3;
                    massimo = this.maxAnalog3;
                }
                if (this.bottoneAnalog4.isSelected()) {
                    minimo = this.minAnalog4;
                    massimo = this.maxAnalog4;
                }
                if (this.bottoneAnalog5.isSelected()) {
                    minimo = this.minAnalog5;
                    massimo = this.maxAnalog5;
                }
                if (this.bottoneAnalog6.isSelected()) {
                    minimo = this.minAnalog6;
                    massimo = this.maxAnalog6;
                }
                if (this.bottoneAnalog7.isSelected()) {
                    minimo = this.minAnalog7;
                    massimo = this.maxAnalog7;
                }
                if (this.bottoneAnalog8.isSelected()) {
                    minimo = this.minAnalog8;
                    massimo = this.maxAnalog8;
                }
                float corsa = massimo - minimo;
                try {
                    zero = this.leggiAnalog(this.acquisisciLinea(), index);
                    System.out.println("DEBUG: zero==" + zero + " minimo=" + minimo + " massimo=" + massimo);
                    if (corsa > 0.0f) {
                        minimo = -zero / 1023.0f * corsa;
                        massimo = corsa + minimo;
                    } else {
                        float delta = -(1023.0f - zero) / 1023.0f * corsa;
                        massimo = (minimo -= delta) + corsa;
                        System.out.println("DEBUG: corsa negativa delta=" + delta + " minimo=" + minimo + " massimo=" + massimo);
                    }
                    if (this.bottoneAnalog1.isSelected()) {
                        this.analog1Settato = true;
                        this.minAnalog1 = minimo;
                        this.maxAnalog1 = massimo;
                    }
                    if (this.bottoneAnalog2.isSelected()) {
                        this.analog2Settato = true;
                        this.minAnalog2 = minimo;
                        this.maxAnalog2 = massimo;
                    }
                    if (this.bottoneAnalog3.isSelected()) {
                        this.analog3Settato = true;
                        this.minAnalog3 = minimo;
                        this.maxAnalog3 = massimo;
                    }
                    if (this.bottoneAnalog4.isSelected()) {
                        this.analog4Settato = true;
                        this.minAnalog4 = minimo;
                        this.maxAnalog4 = massimo;
                    }
                    if (this.bottoneAnalog5.isSelected()) {
                        this.analog5Settato = true;
                        this.minAnalog5 = minimo;
                        this.maxAnalog5 = massimo;
                    }
                    if (this.bottoneAnalog6.isSelected()) {
                        this.analog6Settato = true;
                        this.minAnalog6 = minimo;
                        this.maxAnalog6 = massimo;
                    }
                    if (this.bottoneAnalog7.isSelected()) {
                        this.analog7Settato = true;
                        this.minAnalog7 = minimo;
                        this.maxAnalog7 = massimo;
                    }
                    if (this.bottoneAnalog8.isSelected()) {
                        this.analog8Settato = true;
                        this.minAnalog8 = minimo;
                        this.maxAnalog8 = massimo;
                    }
                    JOptionPane.showMessageDialog(this, Language.string("Zero configurato"), Language.string("Setting"), 1);
                    this.dispose();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                }
            }
            if (this.sensoriCB.getSelectedIndex() == 4) {
                JOptionPane.showMessageDialog(this, Language.string("Sensore di Temperatura configurato"), Language.string("Setting"), 1);
                if (this.bottoneAnalog1.isSelected()) {
                    this.analog1Settato = true;
                    this.minAnalog1 = -37.5f;
                    this.maxAnalog1 = 262.5f;
                }
                if (this.bottoneAnalog2.isSelected()) {
                    this.analog2Settato = true;
                    this.minAnalog2 = -37.5f;
                    this.maxAnalog2 = 262.5f;
                }
                if (this.bottoneAnalog3.isSelected()) {
                    this.analog3Settato = true;
                    this.minAnalog3 = -37.5f;
                    this.maxAnalog3 = 262.5f;
                }
                if (this.bottoneAnalog4.isSelected()) {
                    this.analog4Settato = true;
                    this.minAnalog4 = -37.5f;
                    this.maxAnalog4 = 262.5f;
                }
                if (this.bottoneAnalog5.isSelected()) {
                    this.analog5Settato = true;
                    this.minAnalog5 = -37.5f;
                    this.maxAnalog5 = 262.5f;
                }
                if (this.bottoneAnalog6.isSelected()) {
                    this.analog6Settato = true;
                    this.minAnalog6 = -37.5f;
                    this.maxAnalog6 = 262.5f;
                }
                if (this.bottoneAnalog7.isSelected()) {
                    this.analog7Settato = true;
                    this.minAnalog7 = -37.5f;
                    this.maxAnalog7 = 262.5f;
                }
                if (this.bottoneAnalog8.isSelected()) {
                    this.analog8Settato = true;
                    this.minAnalog8 = -37.5f;
                    this.maxAnalog8 = 262.5f;
                }
                this.dispose();
            }
            if (this.sensoriCB.getSelectedIndex() == 5) {
                JOptionPane.showMessageDialog(this, Language.string("Sensore di pressione configurato"), Language.string("Setting"), 1);
                if (this.bottoneAnalog1.isSelected()) {
                    this.analog1Settato = true;
                    this.minAnalog1 = 0.0f;
                    this.maxAnalog1 = 50.0f;
                }
                if (this.bottoneAnalog2.isSelected()) {
                    this.analog2Settato = true;
                    this.minAnalog2 = 0.0f;
                    this.maxAnalog2 = 50.0f;
                }
                if (this.bottoneAnalog3.isSelected()) {
                    this.analog3Settato = true;
                    this.minAnalog3 = 0.0f;
                    this.maxAnalog3 = 50.0f;
                }
                if (this.bottoneAnalog4.isSelected()) {
                    this.analog4Settato = true;
                    this.minAnalog4 = 0.0f;
                    this.maxAnalog4 = 50.0f;
                }
                if (this.bottoneAnalog5.isSelected()) {
                    this.analog5Settato = true;
                    this.minAnalog5 = 0.0f;
                    this.maxAnalog5 = 50.0f;
                }
                if (this.bottoneAnalog7.isSelected()) {
                    this.analog7Settato = true;
                    this.minAnalog7 = 0.0f;
                    this.maxAnalog7 = 50.0f;
                }
                if (this.bottoneAnalog8.isSelected()) {
                    this.analog8Settato = true;
                    this.minAnalog8 = 0.0f;
                    this.maxAnalog8 = 50.0f;
                }
                this.dispose();
            }
            if (this.sensoriCB.getSelectedIndex() == 10) {
                JOptionPane.showMessageDialog(this, Language.string("Premere OK per fissare lo zero"), Language.string("Setting"), 1);
                minimo = -12.5f;
                massimo = 112.5f;
                zero = 0.0f;
                try {
                    zero = this.leggiAnalog(this.acquisisciLinea(), index);
                    minimo = -(zero * 125.0f / 1023.0f);
                    massimo = 125.0f - zero * 125.0f / 1023.0f;
                    if (this.bottoneAnalog1.isSelected()) {
                        this.analog1Settato = true;
                        this.minAnalog1 = minimo;
                        this.maxAnalog1 = massimo;
                    }
                    if (this.bottoneAnalog2.isSelected()) {
                        this.analog2Settato = true;
                        this.minAnalog2 = minimo;
                        this.maxAnalog2 = massimo;
                    }
                    if (this.bottoneAnalog3.isSelected()) {
                        this.analog3Settato = true;
                        this.minAnalog3 = minimo;
                        this.maxAnalog3 = massimo;
                    }
                    if (this.bottoneAnalog4.isSelected()) {
                        this.analog4Settato = true;
                        this.minAnalog4 = minimo;
                        this.maxAnalog4 = massimo;
                    }
                    if (this.bottoneAnalog5.isSelected()) {
                        this.analog5Settato = true;
                        this.minAnalog5 = minimo;
                        this.maxAnalog5 = massimo;
                    }
                    if (this.bottoneAnalog6.isSelected()) {
                        this.analog6Settato = true;
                        this.minAnalog6 = minimo;
                        this.maxAnalog6 = massimo;
                    }
                    if (this.bottoneAnalog7.isSelected()) {
                        this.analog7Settato = true;
                        this.minAnalog7 = minimo;
                        this.maxAnalog7 = massimo;
                    }
                    if (this.bottoneAnalog8.isSelected()) {
                        this.analog8Settato = true;
                        this.minAnalog8 = minimo;
                        this.maxAnalog8 = massimo;
                    }
                    JOptionPane.showMessageDialog(this, Language.string("Sensore di pressione configurato"), Language.string("Setting"), 1);
                    this.dispose();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                }
            }
            if (this.sensoriCB.getSelectedIndex() == 6) {
                JOptionPane.showMessageDialog(this, Language.string("Chiudere completamente il gas e premere OK"), Language.string("Setting"), 1);
                float TPSmin = 0.0f;
                try {
                    TPSmin = this.leggiAnalog(this.acquisisciLinea(), index);
                    JOptionPane.showMessageDialog(this, Language.string("Aprire completamente il gas e premere OK"), Language.string("Setting"), 1);
                    float TPSmax = 0.0f;
                    TPSmax = this.leggiAnalog(this.acquisisciLinea(), index);
                    JOptionPane.showMessageDialog(this, Language.string("Sensore TPS configurato"), Language.string("Setting"), 1);
                    float minimo3 = 0.0f;
                    float massimo3 = 1023.0f;
                    if (TPSmin != TPSmax) {
                        minimo3 = -TPSmin * (102300.0f / (TPSmax - TPSmin)) / 1023.0f;
                        massimo3 = 102300.0f / (TPSmax - TPSmin) + minimo3;
                    }
                    System.out.println("TPS minimo=" + minimo3 + " massimo=" + massimo3);
                    if (this.bottoneAnalog1.isSelected()) {
                        this.analog1Settato = true;
                        this.minAnalog1 = minimo3;
                        this.maxAnalog1 = massimo3;
                    }
                    if (this.bottoneAnalog2.isSelected()) {
                        this.analog2Settato = true;
                        this.minAnalog2 = minimo3;
                        this.maxAnalog2 = massimo3;
                    }
                    if (this.bottoneAnalog3.isSelected()) {
                        this.analog3Settato = true;
                        this.minAnalog3 = minimo3;
                        this.maxAnalog3 = massimo3;
                    }
                    if (this.bottoneAnalog4.isSelected()) {
                        this.analog4Settato = true;
                        this.minAnalog4 = minimo3;
                        this.maxAnalog4 = massimo3;
                    }
                    if (this.bottoneAnalog5.isSelected()) {
                        this.analog5Settato = true;
                        this.minAnalog5 = minimo3;
                        this.maxAnalog5 = massimo3;
                    }
                    if (this.bottoneAnalog6.isSelected()) {
                        this.analog6Settato = true;
                        this.minAnalog6 = minimo3;
                        this.maxAnalog6 = massimo3;
                    }
                    if (this.bottoneAnalog7.isSelected()) {
                        this.analog7Settato = true;
                        this.minAnalog7 = minimo3;
                        this.maxAnalog7 = massimo3;
                    }
                    if (this.bottoneAnalog8.isSelected()) {
                        this.analog8Settato = true;
                        this.minAnalog8 = minimo3;
                        this.maxAnalog8 = massimo3;
                    }
                    this.dispose();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                }
            }
            if (this.sensoriCB.getSelectedIndex() == 7) {
                JOptionPane.showMessageDialog(this, Language.string("Adattatore PT100 configurato"), Language.string("Setting"), 1);
                if (this.bottoneAnalog1.isSelected()) {
                    this.analog1Settato = true;
                    this.minAnalog1 = 0.0f;
                    this.maxAnalog1 = 50.0f;
                }
                if (this.bottoneAnalog2.isSelected()) {
                    this.analog2Settato = true;
                    this.minAnalog2 = 0.0f;
                    this.maxAnalog2 = 50.0f;
                }
                if (this.bottoneAnalog3.isSelected()) {
                    this.analog3Settato = true;
                    this.minAnalog3 = 0.0f;
                    this.maxAnalog3 = 50.0f;
                }
                if (this.bottoneAnalog4.isSelected()) {
                    this.analog4Settato = true;
                    this.minAnalog4 = 0.0f;
                    this.maxAnalog4 = 50.0f;
                }
                if (this.bottoneAnalog5.isSelected()) {
                    this.analog5Settato = true;
                    this.minAnalog5 = 0.0f;
                    this.maxAnalog5 = 50.0f;
                }
                if (this.bottoneAnalog7.isSelected()) {
                    this.analog7Settato = true;
                    this.minAnalog7 = 0.0f;
                    this.maxAnalog7 = 50.0f;
                }
                if (this.bottoneAnalog8.isSelected()) {
                    this.analog8Settato = true;
                    this.minAnalog8 = 0.0f;
                    this.maxAnalog8 = 50.0f;
                }
                this.dispose();
            }
            if (this.sensoriCB.getSelectedIndex() == 8) {
                JOptionPane.showMessageDialog(this, Language.string("Adattatore Termocoppia configurto"), Language.string("Setting"), 1);
                if (this.bottoneAnalog1.isSelected()) {
                    this.analog1Settato = true;
                    this.minAnalog1 = 0.0f;
                    this.maxAnalog1 = 50.0f;
                }
                if (this.bottoneAnalog2.isSelected()) {
                    this.analog2Settato = true;
                    this.minAnalog2 = 0.0f;
                    this.maxAnalog2 = 50.0f;
                }
                if (this.bottoneAnalog3.isSelected()) {
                    this.analog3Settato = true;
                    this.minAnalog3 = 0.0f;
                    this.maxAnalog3 = 50.0f;
                }
                if (this.bottoneAnalog4.isSelected()) {
                    this.analog4Settato = true;
                    this.minAnalog4 = 0.0f;
                    this.maxAnalog4 = 50.0f;
                }
                if (this.bottoneAnalog5.isSelected()) {
                    this.analog5Settato = true;
                    this.minAnalog5 = 0.0f;
                    this.maxAnalog5 = 50.0f;
                }
                if (this.bottoneAnalog7.isSelected()) {
                    this.analog7Settato = true;
                    this.minAnalog7 = 0.0f;
                    this.maxAnalog7 = 50.0f;
                }
                if (this.bottoneAnalog8.isSelected()) {
                    this.analog8Settato = true;
                    this.minAnalog8 = 0.0f;
                    this.maxAnalog8 = 50.0f;
                }
                this.dispose();
            }
        }
    }

    public static void main(String[] args) {
        SensoriDialogDasyPro test = new SensoriDialogDasyPro(null, null);
        test.setVisible(true);
    }
}

