/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Scanner;

public class ResourceReader {
    public static int BUFFER_SIZ = 1024;
    private String fileName;
    private BufferedReader breader;

    public static void main(String[] args) {
        String fpath = args.length < 1 ? "res/firm.HEX" : args[0];
        ResourceReader rr = new ResourceReader(fpath);
        try {
            String line;
            int siz = rr.getFileSize();
            System.out.println(fpath + " size: " + siz + " bytes\n");
            System.out.println("Press <Enter> to start reading...");
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
            while ((line = rr.readLine()) != null) {
                System.out.println(line);
            }
            scanner.close();
            System.out.println("<<<< Stream end >>>>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ResourceReader(String file) {
        this.fileName = file;
        this.reset();
    }

    public void close() throws IOException {
        if (this.breader != null) {
            this.breader.close();
        }
    }

    public void reset() {
        if (this.breader != null) {
            try {
                this.breader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.breader = null;
            System.gc();
        }
        try {
            this.breader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(this.fileName)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.fileName + " is not a valid resouce file");
        }
    }

    public String readLine() throws IOException {
        if (this.breader != null) {
            return this.breader.readLine();
        }
        return null;
    }

    public int getFileSize() throws IOException {
        int rc;
        if (this.breader == null) {
            return 0;
        }
        char[] buff = new char[BUFFER_SIZ];
        int size = 0;
        while ((rc = this.breader.read(buff)) > 0) {
            size += rc;
        }
        this.reset();
        return size;
    }
}

