/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasParserTask;
import i2m.DataStructure.danasDataStructure.DanasSessionSettings;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.HwDasy6;
import i2m.Language;
import i2m.onLine.DeviceConnection;
import i2m.onLine.SensoriDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OnLineDialog
extends JDialog
implements WindowListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private Frame padre;
    private DeviceConnection conn;
    private DigitalPanel digitalPanel;
    private AnalogPanel analogPanel;
    private AllPanel allPan;
    private int pignone1Default = 1;
    private int corona1Default = 1;
    private int wheelCirc1Default = 1;
    private int pignone2Default = 1;
    private int corona2Default = 1;
    private int wheelCirc2Default = 1;
    private float gear1Default = 1.1f;
    private float gear2Default = 2.4f;
    private float gear3Default = 3.4f;
    private float gear4Default = 4.4f;
    private float gear5Default = 5.5f;
    private float gear6Default = 6.6f;
    private float analog1MinDefault = 0.0f;
    private float analog1MaxDefault = 1023.0f;
    private float analog2MinDefault = 0.0f;
    private float analog2MaxDefault = 1023.0f;
    private float analog5MinDefault = 0.0f;
    private float analog5MaxDefault = 1023.0f;
    private float analog6MinDefault = 0.0f;
    private float analog6MaxDefault = 1023.0f;
    private float analog7MinDefault = 0.0f;
    private float analog7MaxDefault = 1023.0f;
    private float analog8MinDefault = 0.0f;
    private float analog8MaxDefault = 1023.0f;
    private float frontMinDefault = 0.0f;
    private float frontMaxDefault = 1023.0f;
    private float rearMinDefault = 0.0f;
    private float rearMaxDefault = 1023.0f;
    private boolean analog1InvertDefault = false;
    private boolean analog2InvertDefault = false;
    private boolean frontInvertDefault = false;
    private boolean rearInvertDefault = false;
    private boolean continusMode = false;
    private Thread continuousModeThread;
    public final int ANALOG1_MIN = 0;
    public final int ANALOG1_MAX = 1;
    public final int ANALOG2_MIN = 2;
    public final int ANALOG2_MAX = 3;
    public final int FRONT_MIN = 4;
    public final int FRONT_MAX = 5;
    public final int REAR_MIN = 6;
    public final int REAR_MAX = 7;
    public final int ANALOG5_MIN = 8;
    public final int ANALOG5_MAX = 9;
    public final int ANALOG6_MIN = 10;
    public final int ANALOG6_MAX = 11;
    public final int INVERT1 = 12;
    public final int INVERT2 = 13;
    public final int INVERT_FRONT = 14;
    public final int INVERT_REAR = 15;
    public final int INVERT5 = 16;
    public final int INVERT6 = 17;
    public final int PIGNONE1 = 12;
    public final int CORONA1 = 13;
    public final int CIRCONFERENZA1 = 14;
    public final int PIGNONE2 = 15;
    public final int CORONA2 = 16;
    public final int CIRCONFERENZA2 = 17;
    public final int ANALOG7_MIN = 18;
    public final int ANALOG7_MAX = 19;
    public final int ANALOG8_MIN = 20;
    public final int ANALOG8_MAX = 21;
    public final int INVERT7 = 22;
    public final int INVERT8 = 23;
    private boolean dowloadedData = false;
    private boolean saveOnFile = false;
    private int tipoMotoCan = 0;
    private int tipoDispositivo = 2;
    private int tipoMotoGlobale = 8;
    Object[] data;
    Object[] dataIniziali;
    Object[] datiInterni;

    public OnLineDialog(Frame owner, String portName) throws IOException {
        super(owner, Language.string("Connessione On-line"), true);
        this.padre = owner;
        JTabbedPane tabbedPane = new JTabbedPane();
        this.digitalPanel = new DigitalPanel();
        this.analogPanel = new AnalogPanel();
        this.allPan = new AllPanel();
        tabbedPane.addTab(Language.string("Ingressi Digitali"), this.digitalPanel);
        tabbedPane.addTab(Language.string("Ingressi Analogici"), this.analogPanel);
        tabbedPane.addTab(Language.string("Tutti gli ingressi"), this.allPan);
        this.getContentPane().add(tabbedPane);
        this.setSize(740, 400);
        this.setResizable(false);
        this.addWindowListener(this);
        JOptionPane.showMessageDialog(this, Language.string("Verificare che il cavo sia collegato alla porta COM prescelta prima di proseguire"), Language.string("ATTENZIONE"), 1);
        this.conn = new DeviceConnection(portName);
        this.inizializzaDataDefault();
    }

    private void connect() {
        if (this.conn.isConnected()) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JDialog f1 = new JDialog((Dialog)OnLineDialog.this, Language.string("ATTENZIONE!"));
                URL ImgUrl = this.getClass().getResource("/pix/icon_warning.png");
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel("      "));
                panel.add(new JLabel(new ImageIcon(ImgUrl)));
                panel.add(new JLabel("      "));
                panel.add(new JLabel("<html>" + Language.string("Il sistema sta verificando le porte COM disponibili") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                panel.add(new JLabel("      "));
                JPanel pannelloCentrale = new JPanel();
                pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                f1.setContentPane(pannelloCentrale);
                pannelloCentrale.add(new JLabel("    "));
                pannelloCentrale.add(panel);
                pannelloCentrale.add(new JLabel("    "));
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                progressBar.setMaximumSize(new Dimension(330, 40));
                pannelloCentrale.add(progressBar);
                pannelloCentrale.add(new JLabel("    "));
                f1.pack();
                f1.setLocationRelativeTo(null);
                f1.setAlwaysOnTop(true);
                f1.setVisible(true);
                f1.setResizable(false);
                try {
                    OnLineDialog.this.tipoDispositivo = 2;
                    OnLineDialog.this.conn.connect(OnLineDialog.this.tipoDispositivo);
                    String imposLette = OnLineDialog.this.conn.leggiSettaggi6();
                    DanasDataStructure.impostazioni6 = new HwDasy6();
                    DanasDataStructure.impostazioni6.parseImposString6(imposLette);
                    OnLineDialog.this.tipoMotoCan = DanasDataStructure.impostazioni6.getSetting(17);
                    System.out.println("Tipo di moto letto=" + OnLineDialog.this.tipoMotoCan);
                    if (DanasDataStructure.impostazioni6.isDasyx()) {
                        String versione = OnLineDialog.this.conn.leggiVersione();
                        OnLineDialog.this.setTitle(Language.string("Connessione On-line    DasyX:") + versione);
                    }
                }
                catch (Exception e) {
                    f1.setVisible(false);
                    JOptionPane.showMessageDialog(OnLineDialog.this, Language.string("Errore di connessione col sistema remoto: impossibile creare la connessione"), Language.string("ATTENZIONE"), 0);
                    OnLineDialog.this.setEnabled(true);
                    OnLineDialog.this.padre.requestFocus();
                    OnLineDialog.this.requestFocus();
                    OnLineDialog.this.digitalPanel.setConnected(false);
                    OnLineDialog.this.analogPanel.setConnected(false);
                    OnLineDialog.this.allPan.setConnected(false);
                    return;
                }
                finally {
                    f1.setVisible(false);
                    OnLineDialog.this.setEnabled(true);
                    OnLineDialog.this.padre.requestFocus();
                    OnLineDialog.this.requestFocus();
                }
                OnLineDialog.this.inizializzaDataDefault();
                try {
                    String interni = OnLineDialog.this.conn.leggiInternalSettings();
                    if (!interni.startsWith("$SETTING")) {
                        for (int i = 0; i < 37; ++i) {
                            OnLineDialog.this.datiInterni[i] = OnLineDialog.this.dataIniziali[i];
                        }
                    } else {
                        OnLineDialog.this.estraiSettaggiInterni(interni);
                    }
                }
                catch (IOException ex) {
                    System.out.println("Dati interni Dasy X non letti:" + ex.getMessage());
                    for (int i = 0; i < 37; ++i) {
                        OnLineDialog.this.datiInterni[i] = OnLineDialog.this.dataIniziali[i];
                    }
                }
                OnLineDialog.this.digitalPanel.setConnected(true);
                OnLineDialog.this.analogPanel.setConnected(true);
                OnLineDialog.this.allPan.setConnected(true);
                OnLineDialog.this.requestFocus();
            }
        }.start();
    }

    private void disconnect() {
        if (!this.conn.isConnected()) {
            return;
        }
        if (this.continusMode) {
            this.continusMode = false;
            try {
                if (Thread.currentThread() != this.continuousModeThread) {
                    this.continuousModeThread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.digitalPanel.continuosMode(false);
            this.analogPanel.continuosMode(false);
            this.allPan.continuosMode(false);
        }
        try {
            this.conn.disconnect();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, Language.string("Errore di disconnessione col sistema remoto: impossibile chiudere la connessione"), Language.string("ATTENZIONE"), 0);
            this.requestFocus();
        }
        this.digitalPanel.setConnected(false);
        this.analogPanel.setConnected(false);
        this.allPan.setConnected(false);
    }

    public void scaricaContinuo() {
        String continuosString = null;
        while (this.continusMode) {
            try {
                continuosString = this.conn.readOnLineData();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                this.disconnect();
                break;
            }
            this.analogPanel.scriviLinea(continuosString);
            this.digitalPanel.scriviLinea(continuosString);
            this.allPan.scriviLinea(continuosString);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.digitalPanel.connectButton || evt.getSource() == this.analogPanel.connectButton || evt.getSource() == this.allPan.connectButton) {
            if (this.conn.isConnected()) {
                this.disconnect();
            } else {
                this.connect();
            }
        } else if (evt.getSource() == this.digitalPanel.continuousReadButton || evt.getSource() == this.analogPanel.continuousReadButton || evt.getSource() == this.allPan.continuousReadButton) {
            if (!this.continusMode) {
                this.continusMode = true;
                this.digitalPanel.continuosMode(true);
                this.analogPanel.continuosMode(true);
                this.allPan.continuosMode(true);
                this.continuousModeThread = new Thread(){

                    @Override
                    public void run() {
                        OnLineDialog.this.scaricaContinuo();
                    }
                };
                this.continuousModeThread.setDaemon(true);
                this.continuousModeThread.start();
            } else {
                this.continusMode = false;
                try {
                    if (Thread.currentThread() != this.continuousModeThread) {
                        this.continuousModeThread.join();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.digitalPanel.continuosMode(false);
                this.analogPanel.continuosMode(false);
                this.allPan.continuosMode(false);
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        if (this.conn.isConnected()) {
            this.disconnect();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public void inizializzaDataDefault() {
        this.datiInterni = new Object[]{2030, 15, 45, 2000, 1, 1, "ANALOG1", 0, 1023, "ANALOG2", 0, 1023, "ANALOG3", 0, 1023, "ANALOG4", 0, 1023, "ANALOG5", 0, 1023, "ANALOG6", 0, 1023, 1, 2, 3, 4, 5, 6, "ANALOG7", 0, 1023, "ANALOG8", 0, 1023, 8};
        this.data = new Object[]{2030, 15, 45, 2000, 1, 1, "ANALOG1", 0, 1023, "ANALOG2", 0, 1023, "ANALOG3", 0, 1023, "ANALOG4", 0, 1023, "ANALOG5", 0, 1023, "ANALOG6", 0, 1023, 1, 2, 3, 4, 5, 6, "ANALOG7", 0, 1023, "ANALOG8", 0, 1023, 8};
        File f = new File("./defaultSettings.dfs");
        this.apriSettaggi(f);
        this.dataIniziali = this.data;
        this.tipoMotoGlobale = (Integer)this.dataIniziali[36];
    }

    public void inizializzaDataDaFile(File f) {
        this.datiInterni = new Object[]{2030, 15, 45, 2000, 1, 1, "ANALOG1", 0, 1023, "ANALOG2", 0, 1023, "ANALOG3", 0, 1023, "ANALOG4", 0, 1023, "ANALOG5", 0, 1023, "ANALOG6", 0, 1023, 1, 2, 3, 4, 5, 6, "ANALOG7", 0, 1023, "ANALOG8", 0, 1023, 8};
        this.data = new Object[]{2030, 15, 45, 2000, 1, 1, "ANALOG1", 0, 1023, "ANALOG2", 0, 1023, "ANALOG3", 0, 1023, "ANALOG4", 0, 1023, "ANALOG5", 0, 1023, "ANALOG6", 0, 1023, 1, 2, 3, 4, 5, 6, "ANALOG7", 0, 1023, "ANALOG8", 0, 1023, 8};
        this.apriSettaggi(f);
        this.dataIniziali = this.data;
        this.tipoMotoGlobale = (Integer)this.dataIniziali[36];
    }

    private void apriSettaggi(File f) {
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        DanasSessionSettings settaggioAttuale = new DanasSessionSettings();
        try {
            FileInputStream fis = new FileInputStream(f);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                line.replace(" ", "");
                if (line.startsWith("$SETTAGGICANALI")) {
                    DanasParserTask.parseSettaggiCanali(line, settaggioAttuale);
                }
                if (line.startsWith("$SETTAGGIBASE")) {
                    DanasParserTask.parseSettaggiBase(line, settaggioAttuale);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.data[0] = settaggioAttuale.getCircumference(1);
        this.data[1] = settaggioAttuale.getPinion(1);
        this.data[2] = settaggioAttuale.getGearTeeth(1);
        this.data[3] = settaggioAttuale.getCircumference(2);
        this.data[4] = settaggioAttuale.getPinion(2);
        this.data[5] = settaggioAttuale.getGearTeeth(2);
        this.data[6] = settaggioAttuale.getNome(DanasDataStructureConstants.ValueType.ANALOG1);
        this.data[7] = Float.valueOf(settaggioAttuale.getMinimo(DanasDataStructureConstants.ValueType.ANALOG1));
        this.data[8] = Float.valueOf(settaggioAttuale.getMassimo(DanasDataStructureConstants.ValueType.ANALOG1));
        this.data[9] = settaggioAttuale.getNome(DanasDataStructureConstants.ValueType.ANALOG2);
        this.data[10] = Float.valueOf(settaggioAttuale.getMinimo(DanasDataStructureConstants.ValueType.ANALOG2));
        this.data[11] = Float.valueOf(settaggioAttuale.getMassimo(DanasDataStructureConstants.ValueType.ANALOG2));
        this.data[12] = settaggioAttuale.getNome(DanasDataStructureConstants.ValueType.ANALOG3);
        this.data[13] = Float.valueOf(settaggioAttuale.getMinimo(DanasDataStructureConstants.ValueType.ANALOG3));
        this.data[14] = Float.valueOf(settaggioAttuale.getMassimo(DanasDataStructureConstants.ValueType.ANALOG3));
        this.data[15] = settaggioAttuale.getNome(DanasDataStructureConstants.ValueType.ANALOG4);
        this.data[16] = Float.valueOf(settaggioAttuale.getMinimo(DanasDataStructureConstants.ValueType.ANALOG4));
        this.data[17] = Float.valueOf(settaggioAttuale.getMassimo(DanasDataStructureConstants.ValueType.ANALOG4));
        this.data[18] = settaggioAttuale.getNome(DanasDataStructureConstants.ValueType.ANALOG5);
        this.data[19] = Float.valueOf(settaggioAttuale.getMinimo(DanasDataStructureConstants.ValueType.ANALOG5));
        this.data[20] = Float.valueOf(settaggioAttuale.getMassimo(DanasDataStructureConstants.ValueType.ANALOG5));
        this.data[21] = settaggioAttuale.getNome(DanasDataStructureConstants.ValueType.ANALOG6);
        this.data[22] = Float.valueOf(settaggioAttuale.getMinimo(DanasDataStructureConstants.ValueType.ANALOG6));
        this.data[23] = Float.valueOf(settaggioAttuale.getMassimo(DanasDataStructureConstants.ValueType.ANALOG6));
        this.data[24] = Float.valueOf(settaggioAttuale.getGears()[0]);
        this.data[25] = Float.valueOf(settaggioAttuale.getGears()[1]);
        this.data[26] = Float.valueOf(settaggioAttuale.getGears()[2]);
        this.data[27] = Float.valueOf(settaggioAttuale.getGears()[3]);
        this.data[28] = Float.valueOf(settaggioAttuale.getGears()[4]);
        this.data[29] = Float.valueOf(settaggioAttuale.getGears()[5]);
        this.data[30] = settaggioAttuale.getNome(DanasDataStructureConstants.ValueType.ANALOG7);
        this.data[31] = Float.valueOf(settaggioAttuale.getMinimo(DanasDataStructureConstants.ValueType.ANALOG7));
        this.data[32] = Float.valueOf(settaggioAttuale.getMassimo(DanasDataStructureConstants.ValueType.ANALOG7));
        this.data[33] = settaggioAttuale.getNome(DanasDataStructureConstants.ValueType.ANALOG8);
        this.data[34] = Float.valueOf(settaggioAttuale.getMinimo(DanasDataStructureConstants.ValueType.ANALOG8));
        this.data[35] = Float.valueOf(settaggioAttuale.getMassimo(DanasDataStructureConstants.ValueType.ANALOG8));
        this.data[36] = settaggioAttuale.getTipoMoto();
    }

    public String createLineSettings() {
        float max;
        float min;
        String nome;
        int i;
        String line = "$SETTINGS,";
        for (i = 0; i < 6; ++i) {
            nome = String.valueOf(this.datiInterni[6 + i * 3]);
            min = ((Float)this.datiInterni[7 + i * 3]).floatValue();
            max = ((Float)this.datiInterni[8 + i * 3]).floatValue();
            line = line + nome + String.format(",%06.03f,%06.03f,", Float.valueOf(min), Float.valueOf(max));
        }
        for (i = 0; i < 2; ++i) {
            nome = String.valueOf(this.datiInterni[30 + i * 3]);
            min = ((Float)this.datiInterni[31 + i * 3]).floatValue();
            max = ((Float)this.datiInterni[32 + i * 3]).floatValue();
            line = line + nome + String.format(",%06.03f,%06.03f,", Float.valueOf(min), Float.valueOf(max));
        }
        for (i = 0; i < 2; ++i) {
            int circ = (Integer)this.datiInterni[i * 3];
            int pignone = (Integer)this.datiInterni[1 + i * 3];
            int corona = (Integer)this.datiInterni[2 + i * 3];
            line = line + circ + "," + pignone + "," + corona + ",";
        }
        for (i = 0; i < 6; ++i) {
            float gear = ((Float)this.datiInterni[24 + i]).floatValue();
            line = line + String.format("%04.03f,", Float.valueOf(gear));
        }
        line = line + (Integer)this.datiInterni[36] + ",";
        return line;
    }

    public void estraiSettaggiInterni(String line) {
        System.out.println("line=" + line);
        StringTokenizer st = new StringTokenizer(line, ",");
        try {
            int i;
            String t = st.nextToken();
            for (i = 0; i < 6; ++i) {
                t = st.nextToken();
                this.datiInterni[6 + i * 3] = t;
                t = st.nextToken();
                this.datiInterni[7 + i * 3] = Float.valueOf(Float.valueOf(t).floatValue());
                t = st.nextToken();
                this.datiInterni[8 + i * 3] = Float.valueOf(Float.valueOf(t).floatValue());
            }
            t = st.nextToken();
            this.datiInterni[30] = t;
            t = st.nextToken();
            this.datiInterni[31] = Float.valueOf(Float.valueOf(t).floatValue());
            t = st.nextToken();
            this.datiInterni[32] = Float.valueOf(Float.valueOf(t).floatValue());
            t = st.nextToken();
            this.datiInterni[33] = t;
            t = st.nextToken();
            this.datiInterni[34] = Float.valueOf(Float.valueOf(t).floatValue());
            t = st.nextToken();
            this.datiInterni[35] = Float.valueOf(Float.valueOf(t).floatValue());
            t = st.nextToken();
            this.datiInterni[0] = (int)Float.valueOf(t).floatValue();
            t = st.nextToken();
            this.datiInterni[1] = (int)Float.valueOf(t).floatValue();
            t = st.nextToken();
            this.datiInterni[2] = (int)Float.valueOf(t).floatValue();
            t = st.nextToken();
            this.datiInterni[3] = (int)Float.valueOf(t).floatValue();
            t = st.nextToken();
            this.datiInterni[4] = (int)Float.valueOf(t).floatValue();
            t = st.nextToken();
            this.datiInterni[5] = (int)Float.valueOf(t).floatValue();
            for (i = 1; i < 7; ++i) {
                t = st.nextToken();
                this.datiInterni[23 + i] = Float.valueOf(Float.valueOf(t).floatValue());
            }
            t = st.nextToken();
            this.datiInterni[36] = Integer.parseInt(t);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Errore Parsing file interno");
            JOptionPane.showMessageDialog(null, "Error parsing internal file!", "Error", 0);
        }
    }

    public static void main(String[] args) {
        try {
            OnLineDialog test = new OnLineDialog(null, null);
            test.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class AllPanel
    extends JPanel
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        private JButton readButton;
        private JButton continuousReadButton;
        private JButton connectButton;
        private JTextField analog1;
        private JTextField analog2;
        private JTextField analog3;
        private JTextField analog4;
        private JTextField analog5;
        private JTextField analog6;
        private JTextField analog7;
        private JTextField analog8;
        private JTextField multi1;
        private JTextField multi2;
        private JTextField multi3;
        private JTextField multi4;
        private JTextField multi5;
        private JTextField multi6;
        private JTextField multi7;
        private JTextField multi8;
        private JTextField multi9;
        private JTextField multi10;
        JLabel analog1Label;
        JLabel analog2Label;
        JLabel analog3Label;
        JLabel analog4Label;
        JLabel analog5Label;
        JLabel analog6Label;
        JLabel analog7Label;
        JLabel analog8Label;
        JLabel multi1Label;
        JLabel multi2Label;
        JLabel multi3Label;
        JLabel multi4Label;
        JLabel multi5Label;
        JLabel multi6Label;
        JLabel multi7Label;
        JLabel multi8Label;
        JLabel multi9Label;
        JLabel multi10Label;
        JLabel rpmLabel;
        JLabel vel1Label;
        JLabel vel2Label;
        private JTextField rpm;
        private JTextField vel1;
        private JTextField vel2;

        public AllPanel() {
            JPanel buttonPanel = new JPanel();
            this.readButton = new JButton(Language.string("Acquisisci"));
            this.readButton.addActionListener(this);
            this.continuousReadButton = new JButton(Language.string("Acquisisci continuo"));
            this.continuousReadButton.addActionListener(OnLineDialog.this);
            this.connectButton = new JButton(Language.string("Connetti"));
            this.connectButton.addActionListener(OnLineDialog.this);
            buttonPanel.add(this.readButton);
            buttonPanel.add(this.continuousReadButton);
            buttonPanel.add(this.connectButton);
            buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            JPanel line1Panel = new JPanel(new GridLayout(2, 6, 10, 0));
            JPanel line2Panel = new JPanel(new GridLayout(2, 6, 10, 0));
            JPanel line3Panel = new JPanel(new GridLayout(2, 6, 10, 0));
            JPanel line4Panel = new JPanel(new GridLayout(2, 6, 10, 0));
            JPanel settingsPanel = new JPanel(new GridLayout(4, 0, 0, 7));
            JPanel settingsPanelBorder = new JPanel(new BorderLayout());
            this.analog1 = new JTextField(5);
            this.analog1.setHorizontalAlignment(4);
            this.analog1.setEditable(false);
            this.analog2 = new JTextField(5);
            this.analog2.setHorizontalAlignment(4);
            this.analog2.setEditable(false);
            this.analog3 = new JTextField(5);
            this.analog3.setHorizontalAlignment(4);
            this.analog3.setEditable(false);
            this.analog4 = new JTextField(5);
            this.analog4.setHorizontalAlignment(4);
            this.analog4.setEditable(false);
            this.analog5 = new JTextField(5);
            this.analog5.setHorizontalAlignment(4);
            this.analog5.setEditable(false);
            this.analog6 = new JTextField(5);
            this.analog6.setHorizontalAlignment(4);
            this.analog6.setEditable(false);
            this.analog7 = new JTextField(5);
            this.analog7.setHorizontalAlignment(4);
            this.analog7.setEditable(false);
            this.analog8 = new JTextField(5);
            this.analog8.setHorizontalAlignment(4);
            this.analog8.setEditable(false);
            this.multi1 = new JTextField(5);
            this.multi1.setHorizontalAlignment(4);
            this.multi1.setEditable(false);
            this.multi2 = new JTextField(5);
            this.multi2.setHorizontalAlignment(4);
            this.multi2.setEditable(false);
            this.multi3 = new JTextField(5);
            this.multi3.setHorizontalAlignment(4);
            this.multi3.setEditable(false);
            this.multi4 = new JTextField(5);
            this.multi4.setHorizontalAlignment(4);
            this.multi4.setEditable(false);
            this.multi5 = new JTextField(5);
            this.multi5.setHorizontalAlignment(4);
            this.multi5.setEditable(false);
            this.multi6 = new JTextField(5);
            this.multi6.setHorizontalAlignment(4);
            this.multi6.setEditable(false);
            this.multi7 = new JTextField(5);
            this.multi7.setHorizontalAlignment(4);
            this.multi7.setEditable(false);
            this.multi8 = new JTextField(5);
            this.multi8.setHorizontalAlignment(4);
            this.multi8.setEditable(false);
            this.multi9 = new JTextField(5);
            this.multi9.setHorizontalAlignment(4);
            this.multi9.setEditable(false);
            this.multi10 = new JTextField(5);
            this.multi10.setHorizontalAlignment(4);
            this.multi10.setEditable(false);
            this.rpm = new JTextField(5);
            this.rpm.setHorizontalAlignment(4);
            this.rpm.setEditable(false);
            this.vel1 = new JTextField(5);
            this.vel1.setHorizontalAlignment(4);
            this.vel1.setEditable(false);
            this.vel2 = new JTextField(5);
            this.vel2.setHorizontalAlignment(4);
            this.vel2.setEditable(false);
            this.analog1Label = new JLabel(Language.string("Analog1:"));
            this.analog1Label.setHorizontalAlignment(0);
            this.analog2Label = new JLabel(Language.string("Analog2:"));
            this.analog2Label.setHorizontalAlignment(0);
            this.analog3Label = new JLabel(Language.string("Analog3:"));
            this.analog3Label.setHorizontalAlignment(0);
            this.analog4Label = new JLabel(Language.string("Analog4:"));
            this.analog4Label.setHorizontalAlignment(0);
            this.analog5Label = new JLabel(Language.string("Analog5:"));
            this.analog5Label.setHorizontalAlignment(0);
            this.analog6Label = new JLabel(Language.string("Analog6:"));
            this.analog6Label.setHorizontalAlignment(0);
            this.analog7Label = new JLabel(Language.string("Analog7:"));
            this.analog7Label.setHorizontalAlignment(0);
            this.analog8Label = new JLabel(Language.string("Analog8:"));
            this.analog8Label.setHorizontalAlignment(0);
            this.multi1Label = new JLabel(Language.string("multi1:"));
            this.multi1Label.setHorizontalAlignment(0);
            this.multi2Label = new JLabel(Language.string("multi2:"));
            this.multi2Label.setHorizontalAlignment(0);
            this.multi3Label = new JLabel(Language.string("multi3:"));
            this.multi3Label.setHorizontalAlignment(0);
            this.multi4Label = new JLabel(Language.string("multi4:"));
            this.multi4Label.setHorizontalAlignment(0);
            this.multi5Label = new JLabel(Language.string("multi5:"));
            this.multi5Label.setHorizontalAlignment(0);
            this.multi6Label = new JLabel(Language.string("multi6:"));
            this.multi6Label.setHorizontalAlignment(0);
            this.multi7Label = new JLabel(Language.string("multi7:"));
            this.multi7Label.setHorizontalAlignment(0);
            this.multi8Label = new JLabel(Language.string("multi8:"));
            this.multi8Label.setHorizontalAlignment(0);
            this.multi9Label = new JLabel(Language.string("multi9:"));
            this.multi9Label.setHorizontalAlignment(0);
            this.multi10Label = new JLabel(Language.string("multi10:"));
            this.multi10Label.setHorizontalAlignment(0);
            this.rpmLabel = new JLabel(Language.string("Rpm:"));
            this.rpmLabel.setHorizontalAlignment(0);
            this.vel1Label = new JLabel(Language.string("Vel1:"));
            this.vel1Label.setHorizontalAlignment(0);
            this.vel2Label = new JLabel(Language.string("Vel2:"));
            this.vel2Label.setHorizontalAlignment(0);
            line1Panel.add(this.analog1Label);
            line1Panel.add(this.analog2Label);
            line1Panel.add(this.analog3Label);
            line1Panel.add(this.analog4Label);
            line1Panel.add(new JLabel(""));
            line1Panel.add(this.rpmLabel);
            line1Panel.add(this.analog1);
            line1Panel.add(this.analog2);
            line1Panel.add(this.analog3);
            line1Panel.add(this.analog4);
            line1Panel.add(new JLabel(""));
            line1Panel.add(this.rpm);
            line2Panel.add(this.analog5Label);
            line2Panel.add(this.analog6Label);
            line2Panel.add(this.analog7Label);
            line2Panel.add(this.analog8Label);
            line2Panel.add(new JLabel(""));
            line2Panel.add(this.vel1Label);
            line2Panel.add(this.analog5);
            line2Panel.add(this.analog6);
            line2Panel.add(this.analog7);
            line2Panel.add(this.analog8);
            line2Panel.add(new JLabel(""));
            line2Panel.add(this.vel1);
            line3Panel.add(this.multi1Label);
            line3Panel.add(this.multi2Label);
            line3Panel.add(this.multi3Label);
            line3Panel.add(this.multi4Label);
            line3Panel.add(this.multi5Label);
            line3Panel.add(this.vel2Label);
            line3Panel.add(this.multi1);
            line3Panel.add(this.multi2);
            line3Panel.add(this.multi3);
            line3Panel.add(this.multi4);
            line3Panel.add(this.multi5);
            line3Panel.add(this.vel2);
            line4Panel.add(this.multi6Label);
            line4Panel.add(this.multi7Label);
            line4Panel.add(this.multi8Label);
            line4Panel.add(this.multi9Label);
            line4Panel.add(this.multi10Label);
            line4Panel.add(new JLabel(""));
            line4Panel.add(this.multi6);
            line4Panel.add(this.multi7);
            line4Panel.add(this.multi8);
            line4Panel.add(this.multi9);
            line4Panel.add(this.multi10);
            line4Panel.add(new JLabel(""));
            this.aggiornaNomi(true);
            settingsPanel.add(line1Panel);
            settingsPanel.add(line2Panel);
            settingsPanel.add(line3Panel);
            settingsPanel.add(line4Panel);
            settingsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 5));
            settingsPanelBorder.setBorder(BorderFactory.createTitledBorder(Language.string("Canali disponibili")));
            settingsPanelBorder.add((Component)settingsPanel, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)settingsPanelBorder, "Center");
            this.add((Component)buttonPanel, "South");
            this.setConnected(false);
        }

        public void aggiornaNomi(boolean inizializza) {
            if (inizializza) {
                OnLineDialog.this.inizializzaDataDefault();
            }
            this.analog1Label.setText(String.valueOf(OnLineDialog.this.datiInterni[6]));
            this.analog2Label.setText(String.valueOf(OnLineDialog.this.datiInterni[9]));
            this.analog3Label.setText(String.valueOf(OnLineDialog.this.datiInterni[12]));
            this.analog4Label.setText(String.valueOf(OnLineDialog.this.datiInterni[15]));
            this.analog5Label.setText(String.valueOf(OnLineDialog.this.datiInterni[18]));
            this.analog6Label.setText(String.valueOf(OnLineDialog.this.datiInterni[21]));
            this.analog7Label.setText(String.valueOf(OnLineDialog.this.datiInterni[30]));
            this.analog8Label.setText(String.valueOf(OnLineDialog.this.datiInterni[33]));
            this.multi1Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 0));
            this.multi2Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 1));
            this.multi3Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 2));
            this.multi4Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 3));
            this.multi5Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 4));
            this.multi6Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 5));
            this.multi7Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 6));
            this.multi8Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 7));
            this.multi9Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 8));
            this.multi10Label.setText(DanasDataStructure.getInstance().getNomeMulti(OnLineDialog.this.tipoMotoGlobale, 9));
        }

        public void usaDatiDefault() {
            this.aggiornaNomi(false);
        }

        public void setConnected(boolean connected) {
            if (connected) {
                this.aggiornaNomi(false);
                this.connectButton.setText(Language.string("Disconnetti"));
                this.readButton.setEnabled(true);
                this.continuousReadButton.setEnabled(true);
            } else {
                this.connectButton.setText(Language.string("Connetti"));
                this.readButton.setEnabled(false);
                this.continuousReadButton.setEnabled(false);
            }
        }

        public String acquisisciLinea() {
            try {
                return OnLineDialog.this.conn.readOnLineData();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                OnLineDialog.this.disconnect();
                return null;
            }
        }

        public void scriviLinea(String stringa) {
            int rawAnalog5 = 0;
            int rawAnalog6 = 0;
            int rawAnalog7 = 0;
            int rawAnalog8 = 0;
            int rawmulti1 = 0;
            int rawmulti2 = 0;
            int rawmulti3 = 0;
            int rawmulti4 = 0;
            int rawmulti5 = 0;
            int rawmulti6 = 0;
            int rawmulti7 = 0;
            int rawmulti8 = 0;
            int rawmulti9 = 0;
            int rawmulti10 = 0;
            int tipoMoto = 8;
            int rawHardwareDataSpeed1 = 65535;
            int rawHardwareDataSpeed2 = 65535;
            int rawHardwareDataRpm = 65535;
            try {
                String stringTempPartialData = null;
                String stringTempDataLine = stringa;
                if (stringTempDataLine.startsWith("$VALUE")) {
                    float analog8V;
                    float analog7V;
                    float analog6V;
                    float analog5V;
                    float rear;
                    float front;
                    float analog2V;
                    float analog1V;
                    StringTokenizer st = new StringTokenizer(stringTempDataLine, ",");
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    int rawFront = Integer.valueOf(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    int rawRear = Integer.valueOf(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    rawHardwareDataSpeed1 = Integer.parseInt(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    rawHardwareDataSpeed2 = Integer.parseInt(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    rawHardwareDataRpm = Integer.parseInt(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    int rawAnalog1 = Integer.valueOf(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    int rawAnalog2 = Integer.valueOf(stringTempPartialData);
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawAnalog5 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawAnalog6 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawAnalog7 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawAnalog8 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti1 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti2 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti3 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti4 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti5 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti6 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti7 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti8 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti9 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawmulti10 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        tipoMoto = this.getTipoModo(Integer.valueOf(stringTempPartialData));
                    }
                    rawHardwareDataSpeed1 = MeasuresUtil.convertiValoreSpeedCan(rawHardwareDataSpeed1, 1, OnLineDialog.this.tipoMotoCan);
                    rawHardwareDataSpeed2 = MeasuresUtil.convertiValoreSpeedCan(rawHardwareDataSpeed2, 2, OnLineDialog.this.tipoMotoCan);
                    rawHardwareDataRpm = MeasuresUtil.convertiValoreRpmCan(rawHardwareDataRpm, OnLineDialog.this.tipoMotoCan);
                    float speed1 = 1.0f / ((float)rawHardwareDataSpeed1 * 2.56E-5f) * 3.6f * (float)OnLineDialog.this.pignone1Default / (float)OnLineDialog.this.corona1Default * (float)OnLineDialog.this.wheelCirc1Default / 1000.0f;
                    float speed2 = 1.0f / ((float)rawHardwareDataSpeed2 * 2.56E-5f) * 3.6f * (float)OnLineDialog.this.pignone2Default / (float)OnLineDialog.this.corona2Default * (float)OnLineDialog.this.wheelCirc2Default / 1000.0f;
                    float rpmF = 1.0f / ((float)rawHardwareDataRpm * 1.6E-6f) * 60.0f;
                    if (rawHardwareDataSpeed1 != 65535) {
                        this.vel1.setText(Float.toString((float)Math.round(speed1 * 10.0f) / 10.0f));
                    } else {
                        this.vel1.setText("0");
                    }
                    if (rawHardwareDataSpeed2 != 65535) {
                        this.vel2.setText(Float.toString((float)Math.round(speed2 * 10.0f) / 10.0f));
                    } else {
                        this.vel2.setText("0");
                    }
                    if (rawHardwareDataRpm != 65535) {
                        this.rpm.setText(Float.toString((float)Math.round(rpmF * 10.0f) / 10.0f));
                    } else {
                        this.rpm.setText("0");
                    }
                    if (OnLineDialog.this.analog1MinDefault > OnLineDialog.this.analog1MaxDefault) {
                        rawAnalog1 = 1023 - rawAnalog1;
                        analog1V = Math.abs(OnLineDialog.this.analog1MaxDefault - OnLineDialog.this.analog1MinDefault) / 1023.0f * (float)rawAnalog1 + OnLineDialog.this.analog1MaxDefault;
                    } else {
                        analog1V = Math.abs(OnLineDialog.this.analog1MaxDefault - OnLineDialog.this.analog1MinDefault) / 1023.0f * (float)rawAnalog1 + OnLineDialog.this.analog1MinDefault;
                    }
                    if (OnLineDialog.this.analog2MinDefault > OnLineDialog.this.analog2MaxDefault) {
                        rawAnalog2 = 1023 - rawAnalog2;
                        analog2V = Math.abs(OnLineDialog.this.analog2MaxDefault - OnLineDialog.this.analog2MinDefault) / 1023.0f * (float)rawAnalog2 + OnLineDialog.this.analog2MaxDefault;
                    } else {
                        analog2V = Math.abs(OnLineDialog.this.analog2MaxDefault - OnLineDialog.this.analog2MinDefault) / 1023.0f * (float)rawAnalog2 + OnLineDialog.this.analog2MinDefault;
                    }
                    if (OnLineDialog.this.frontMinDefault > OnLineDialog.this.frontMaxDefault) {
                        rawFront = 1023 - rawFront;
                        front = Math.abs(OnLineDialog.this.frontMaxDefault - OnLineDialog.this.frontMinDefault) / 1023.0f * (float)rawFront + OnLineDialog.this.frontMaxDefault;
                    } else {
                        front = Math.abs(OnLineDialog.this.frontMaxDefault - OnLineDialog.this.frontMinDefault) / 1023.0f * (float)rawFront + OnLineDialog.this.frontMinDefault;
                    }
                    if (OnLineDialog.this.rearMinDefault > OnLineDialog.this.rearMaxDefault) {
                        rawRear = 1023 - rawRear;
                        rear = Math.abs(OnLineDialog.this.rearMaxDefault - OnLineDialog.this.rearMinDefault) / 1023.0f * (float)rawRear + OnLineDialog.this.rearMaxDefault;
                    } else {
                        rear = Math.abs(OnLineDialog.this.rearMaxDefault - OnLineDialog.this.rearMinDefault) / 1023.0f * (float)rawRear + OnLineDialog.this.rearMinDefault;
                    }
                    if (OnLineDialog.this.analog5MinDefault > OnLineDialog.this.analog5MaxDefault) {
                        rawAnalog5 = 1023 - rawAnalog5;
                        analog5V = Math.abs(OnLineDialog.this.analog5MaxDefault - OnLineDialog.this.analog5MinDefault) / 1023.0f * (float)rawAnalog5 + OnLineDialog.this.analog5MaxDefault;
                    } else {
                        analog5V = Math.abs(OnLineDialog.this.analog5MaxDefault - OnLineDialog.this.analog5MinDefault) / 1023.0f * (float)rawAnalog5 + OnLineDialog.this.analog5MinDefault;
                    }
                    if (OnLineDialog.this.analog6MinDefault > OnLineDialog.this.analog6MaxDefault) {
                        rawAnalog6 = 1023 - rawAnalog6;
                        analog6V = Math.abs(OnLineDialog.this.analog6MaxDefault - OnLineDialog.this.analog6MinDefault) / 1023.0f * (float)rawAnalog6 + OnLineDialog.this.analog6MaxDefault;
                    } else {
                        analog6V = Math.abs(OnLineDialog.this.analog6MaxDefault - OnLineDialog.this.analog6MinDefault) / 1023.0f * (float)rawAnalog6 + OnLineDialog.this.analog6MinDefault;
                    }
                    if (OnLineDialog.this.analog7MinDefault > OnLineDialog.this.analog7MaxDefault) {
                        rawAnalog7 = 1023 - rawAnalog7;
                        analog7V = Math.abs(OnLineDialog.this.analog7MaxDefault - OnLineDialog.this.analog7MinDefault) / 1023.0f * (float)rawAnalog7 + OnLineDialog.this.analog7MaxDefault;
                    } else {
                        analog7V = Math.abs(OnLineDialog.this.analog7MaxDefault - OnLineDialog.this.analog7MinDefault) / 1023.0f * (float)rawAnalog7 + OnLineDialog.this.analog7MinDefault;
                    }
                    if (OnLineDialog.this.analog8MinDefault > OnLineDialog.this.analog8MaxDefault) {
                        rawAnalog8 = 1023 - rawAnalog8;
                        analog8V = Math.abs(OnLineDialog.this.analog8MaxDefault - OnLineDialog.this.analog8MinDefault) / 1023.0f * (float)rawAnalog8 + OnLineDialog.this.analog8MaxDefault;
                    } else {
                        analog8V = Math.abs(OnLineDialog.this.analog8MaxDefault - OnLineDialog.this.analog8MinDefault) / 1023.0f * (float)rawAnalog8 + OnLineDialog.this.analog8MinDefault;
                    }
                    if (tipoMoto != OnLineDialog.this.tipoMotoGlobale) {
                        OnLineDialog.this.tipoMotoGlobale = tipoMoto;
                        this.aggiornaNomi(false);
                    }
                    this.analog1.setText(String.format("%.2f", Float.valueOf(analog1V)));
                    this.analog2.setText(String.format("%.2f", Float.valueOf(analog2V)));
                    this.analog3.setText(String.format("%.2f", Float.valueOf(front)));
                    this.analog4.setText(String.format("%.2f", Float.valueOf(rear)));
                    this.analog5.setText(String.format("%.2f", Float.valueOf(analog5V)));
                    this.analog6.setText(String.format("%.2f", Float.valueOf(analog6V)));
                    this.analog7.setText(String.format("%.2f", Float.valueOf(analog7V)));
                    this.analog8.setText(String.format("%.2f", Float.valueOf(analog8V)));
                    this.multi1.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(0, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti1)));
                    this.multi2.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(1, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti2)));
                    this.multi3.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(2, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti3)));
                    this.multi4.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(3, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti4)));
                    this.multi5.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(4, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti5)));
                    this.multi6.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(5, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti6)));
                    this.multi7.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(6, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti7)));
                    this.multi8.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(7, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti8)));
                    this.multi9.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(8, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti9)));
                    this.multi10.setText(String.format("%.2f", DanasDataStructure.getInstance().getValoreCanaleMulti(9, this.getTipoModo(OnLineDialog.this.tipoMotoCan), rawmulti10)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private int getTipoModo(int tipoCan) {
            switch (tipoCan) {
                case 1: {
                    return 14;
                }
                case 2: {
                    return 15;
                }
                case 3: {
                    return 16;
                }
                case 4: {
                    return 17;
                }
                case 5: {
                    return 18;
                }
                case 6: {
                    return 19;
                }
                case 7: {
                    return 20;
                }
                case 8: {
                    return 22;
                }
                case 10: {
                    return 29;
                }
                case 13: {
                    return 38;
                }
                case 14: {
                    return 39;
                }
                case 15: {
                    return 40;
                }
                case 16: {
                    return 43;
                }
                case 17: {
                    return 44;
                }
            }
            return 8;
        }

        public void continuosMode(boolean attiva) {
            if (attiva) {
                this.continuousReadButton.setText(Language.string("Stop Acquisizione"));
                this.readButton.setEnabled(false);
                this.connectButton.setEnabled(false);
            } else {
                this.continuousReadButton.setText(Language.string("Acquisisci continuo"));
                this.readButton.setEnabled(true);
                this.connectButton.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.readButton) {
                this.connectButton.setEnabled(false);
                this.scriviLinea(this.acquisisciLinea());
                this.connectButton.setEnabled(true);
            }
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (!OnLineDialog.this.conn.isConnected() || this.continuousReadButton.getText() != Language.string("Stop Acquisizione")) {
                // empty if block
            }
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }

    private class DigitalPanel
    extends JPanel
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        private JButton readButton;
        private JButton continuousReadButton;
        private JButton connectButton;
        private JButton applyButton;
        private JButton defaultButton;
        private JTextField impulseSpeed1TField;
        private JTextField impulseSpeed2TField;
        private JTextField impulseRpmTField;
        private JTextField pignone1TField;
        private JTextField pignone2TField;
        private JTextField corona1TField;
        private JTextField corona2TField;
        private JTextField wheelCirc1TField;
        private JTextField wheelCirc2TField;
        private JTextField rawSpeed1TField;
        private JTextField rawSpeed2TField;
        private JTextField rawRpmTField;
        private JTextField speed1TField;
        private JTextField speed2TField;
        private JTextField rpmTField;
        private JTextField gear1TField;
        private JTextField gear2TField;
        private JTextField gear3TField;
        private JTextField gear4TField;
        private JTextField gear5TField;
        private JTextField gear6TField;

        public DigitalPanel() {
            JPanel buttonPanel = new JPanel();
            this.readButton = new JButton(Language.string("Acquisisci"));
            this.readButton.addActionListener(this);
            this.defaultButton = new JButton(Language.string("Carica settaggi"));
            this.defaultButton.addActionListener(this);
            this.continuousReadButton = new JButton(Language.string("Acquisisci continuo"));
            this.continuousReadButton.addActionListener(OnLineDialog.this);
            this.connectButton = new JButton(Language.string("Connetti"));
            this.connectButton.addActionListener(OnLineDialog.this);
            this.applyButton = new JButton(Language.string("Applica"));
            this.applyButton.addActionListener(this);
            buttonPanel.add(this.continuousReadButton);
            buttonPanel.add(this.connectButton);
            buttonPanel.add(this.applyButton);
            buttonPanel.add(this.defaultButton);
            buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel datiFinalPanel = new JPanel(new GridLayout(0, 2));
            JPanel speed1Panel = new JPanel(new GridLayout(2, 5, 10, 0));
            JPanel speed2Panel = new JPanel(new GridLayout(2, 5, 10, 0));
            JPanel rpmPanel = new JPanel(new GridLayout(2, 5, 10, 0));
            JPanel gearPanel = new JPanel(new GridLayout(2, 5, 10, 0));
            JPanel gear2Panel = new JPanel(new GridLayout(2, 5, 10, 0));
            JPanel settingsPanel = new JPanel(new GridLayout(5, 0, 0, 7));
            JPanel rawPanel = new JPanel(new GridLayout(6, 0, 0, 7));
            JPanel finalPanel = new JPanel(new GridLayout(6, 0, 0, 7));
            JPanel rawPanelBorder = new JPanel(new BorderLayout());
            JPanel finalPanelBorder = new JPanel(new BorderLayout());
            JPanel settingsPanelBorder = new JPanel(new BorderLayout());
            this.impulseSpeed1TField = new JTextField(5);
            this.impulseSpeed2TField = new JTextField(5);
            this.impulseRpmTField = new JTextField(5);
            this.pignone1TField = new JTextField(5);
            this.pignone2TField = new JTextField(5);
            this.corona1TField = new JTextField(5);
            this.corona2TField = new JTextField(5);
            this.wheelCirc1TField = new JTextField(5);
            this.wheelCirc2TField = new JTextField(5);
            this.gear1TField = new JTextField(5);
            this.gear2TField = new JTextField(5);
            this.gear3TField = new JTextField(5);
            this.gear4TField = new JTextField(5);
            this.gear5TField = new JTextField(5);
            this.gear6TField = new JTextField(5);
            this.gear1TField.setHorizontalAlignment(4);
            this.gear2TField.setHorizontalAlignment(4);
            this.gear3TField.setHorizontalAlignment(4);
            this.gear4TField.setHorizontalAlignment(4);
            this.gear5TField.setHorizontalAlignment(4);
            this.gear6TField.setHorizontalAlignment(4);
            this.impulseSpeed1TField.setHorizontalAlignment(4);
            this.impulseSpeed2TField.setHorizontalAlignment(4);
            this.impulseRpmTField.setHorizontalAlignment(4);
            this.pignone1TField.setHorizontalAlignment(4);
            this.pignone2TField.setHorizontalAlignment(4);
            this.corona1TField.setHorizontalAlignment(4);
            this.corona2TField.setHorizontalAlignment(4);
            this.wheelCirc1TField.setHorizontalAlignment(4);
            this.wheelCirc2TField.setHorizontalAlignment(4);
            this.impulseSpeed1TField.addKeyListener(this);
            this.impulseSpeed2TField.addKeyListener(this);
            this.impulseRpmTField.addKeyListener(this);
            this.pignone1TField.addKeyListener(this);
            this.pignone2TField.addKeyListener(this);
            this.corona1TField.addKeyListener(this);
            this.corona2TField.addKeyListener(this);
            this.wheelCirc1TField.addKeyListener(this);
            this.wheelCirc2TField.addKeyListener(this);
            this.gear1TField.addKeyListener(this);
            this.gear2TField.addKeyListener(this);
            this.gear3TField.addKeyListener(this);
            this.gear4TField.addKeyListener(this);
            this.gear5TField.addKeyListener(this);
            this.gear6TField.addKeyListener(this);
            JLabel speed1Label = new JLabel(Language.string("Velocita' 1:"));
            Font font_etichetta = speed1Label.getFont().deriveFont(14.0f);
            speed1Label.setFont(font_etichetta);
            speed1Label.setHorizontalAlignment(0);
            JLabel speed2Label = new JLabel(Language.string("Velocita' 2:"));
            speed2Label.setHorizontalAlignment(0);
            speed2Label.setFont(font_etichetta);
            JLabel impulseSpeed1Label = new JLabel(Language.string("N. Impulsi"));
            impulseSpeed1Label.setHorizontalAlignment(0);
            JLabel impulseSpeed2Label = new JLabel(Language.string("N. Impulsi "));
            impulseSpeed2Label.setHorizontalAlignment(0);
            JLabel rpmLabel = new JLabel(Language.string("RPM:"));
            rpmLabel.setFont(font_etichetta);
            rpmLabel.setHorizontalAlignment(0);
            JLabel marciaLabel = new JLabel(Language.string("MARCE:"));
            marciaLabel.setFont(font_etichetta);
            marciaLabel.setHorizontalAlignment(0);
            JLabel marcia2Label = new JLabel(Language.string("MARCE:"));
            marcia2Label.setFont(font_etichetta);
            marcia2Label.setHorizontalAlignment(0);
            JLabel impulseRpmLabel = new JLabel(Language.string("N. Impulsi"));
            impulseRpmLabel.setHorizontalAlignment(0);
            JLabel pignone1Label = new JLabel(Language.string("Denti pignone"));
            impulseSpeed1Label.setHorizontalAlignment(0);
            JLabel corona1Label = new JLabel(Language.string("Denti corona"));
            impulseSpeed2Label.setHorizontalAlignment(0);
            JLabel wheelCirc1Label = new JLabel(Language.string("Circonf. [mm]"));
            impulseRpmLabel.setHorizontalAlignment(0);
            JLabel pignone2Label = new JLabel(Language.string("Denti pignone"));
            impulseSpeed1Label.setHorizontalAlignment(0);
            JLabel corona2Label = new JLabel(Language.string("Denti corona"));
            impulseSpeed2Label.setHorizontalAlignment(0);
            JLabel wheelCirc2Label = new JLabel(Language.string("Circonf. [mm]"));
            impulseRpmLabel.setHorizontalAlignment(0);
            JLabel gear1Label = new JLabel(Language.string("Marcia1"));
            gear1Label.setHorizontalAlignment(0);
            JLabel gear2Label = new JLabel(Language.string("Marcia2"));
            gear2Label.setHorizontalAlignment(0);
            JLabel gear3Label = new JLabel(Language.string("Marcia3"));
            gear3Label.setHorizontalAlignment(0);
            JLabel gear4Label = new JLabel(Language.string("Marcia4"));
            gear4Label.setHorizontalAlignment(0);
            JLabel gear5Label = new JLabel(Language.string("Marcia5"));
            gear5Label.setHorizontalAlignment(0);
            JLabel gear6Label = new JLabel(Language.string("Marcia6"));
            gear6Label.setHorizontalAlignment(0);
            speed1Panel.add(new JLabel("    "));
            speed1Panel.add(impulseSpeed1Label);
            speed1Panel.add(pignone1Label);
            speed1Panel.add(corona1Label);
            speed1Panel.add(wheelCirc1Label);
            speed1Panel.add(speed1Label);
            speed1Panel.add(this.impulseSpeed1TField);
            speed1Panel.add(this.pignone1TField);
            speed1Panel.add(this.corona1TField);
            speed1Panel.add(this.wheelCirc1TField);
            speed2Panel.add(new JLabel(""));
            speed2Panel.add(impulseSpeed2Label);
            speed2Panel.add(pignone2Label);
            speed2Panel.add(corona2Label);
            speed2Panel.add(wheelCirc2Label);
            speed2Panel.add(speed2Label);
            speed2Panel.add(this.impulseSpeed2TField);
            speed2Panel.add(this.pignone2TField);
            speed2Panel.add(this.corona2TField);
            speed2Panel.add(this.wheelCirc2TField);
            rpmPanel.add(new JLabel(""));
            rpmPanel.add(impulseRpmLabel);
            rpmPanel.add(new JLabel(""));
            rpmPanel.add(new JLabel(""));
            rpmPanel.add(new JLabel(""));
            rpmPanel.add(rpmLabel);
            rpmPanel.add(this.impulseRpmTField);
            rpmPanel.add(new JLabel(""));
            rpmPanel.add(new JLabel(""));
            rpmPanel.add(new JLabel(""));
            gearPanel.add(new JLabel(""));
            gearPanel.add(gear1Label);
            gearPanel.add(gear2Label);
            gearPanel.add(gear3Label);
            gearPanel.add(gear4Label);
            gearPanel.add(marciaLabel);
            gearPanel.add(this.gear1TField);
            gearPanel.add(this.gear2TField);
            gearPanel.add(this.gear3TField);
            gearPanel.add(this.gear4TField);
            gear2Panel.add(new JLabel(""));
            gear2Panel.add(gear5Label);
            gear2Panel.add(gear6Label);
            gear2Panel.add(new JLabel(""));
            gear2Panel.add(new JLabel(""));
            gear2Panel.add(marcia2Label);
            gear2Panel.add(this.gear5TField);
            gear2Panel.add(this.gear6TField);
            gear2Panel.add(new JLabel(""));
            gear2Panel.add(new JLabel(""));
            settingsPanel.add(speed1Panel);
            settingsPanel.add(speed2Panel);
            settingsPanel.add(rpmPanel);
            settingsPanel.add(gearPanel);
            settingsPanel.add(gear2Panel);
            settingsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 5));
            settingsPanelBorder.setBorder(BorderFactory.createTitledBorder(Language.string("Settaggi")));
            settingsPanelBorder.add((Component)settingsPanel, "Center");
            this.rawSpeed1TField = new JTextField(5);
            this.rawSpeed2TField = new JTextField(5);
            this.rawRpmTField = new JTextField(5);
            this.rawSpeed1TField.setEditable(false);
            this.rawSpeed2TField.setEditable(false);
            this.rawRpmTField.setEditable(false);
            this.rawSpeed1TField.setHorizontalAlignment(4);
            this.rawSpeed2TField.setHorizontalAlignment(4);
            this.rawRpmTField.setHorizontalAlignment(4);
            this.rawSpeed1TField.setText("0");
            this.rawSpeed2TField.setText("0");
            this.rawRpmTField.setText("0");
            JLabel rawSpeed1Label = new JLabel(Language.string("Vel1 imp./h"));
            rawSpeed1Label.setHorizontalAlignment(0);
            JLabel rawSpeed2Label = new JLabel(Language.string("Vel2 imp./h"));
            rawSpeed2Label.setHorizontalAlignment(0);
            JLabel rawRpmLabel = new JLabel(Language.string("imp/min"));
            rawRpmLabel.setHorizontalAlignment(0);
            rawPanel.add(rawSpeed1Label);
            rawPanel.add(this.rawSpeed1TField);
            rawPanel.add(rawSpeed2Label);
            rawPanel.add(this.rawSpeed2TField);
            rawPanel.add(rawRpmLabel);
            rawPanel.add(this.rawRpmTField);
            rawPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 1, 5));
            rawPanelBorder.setBorder(BorderFactory.createTitledBorder(Language.string("Dati grezzi")));
            rawPanelBorder.add((Component)rawPanel, "Center");
            this.speed1TField = new JTextField(5);
            this.speed2TField = new JTextField(5);
            this.rpmTField = new JTextField(5);
            this.speed1TField.setEditable(false);
            this.speed2TField.setEditable(false);
            this.rpmTField.setEditable(false);
            this.speed1TField.setHorizontalAlignment(4);
            this.speed2TField.setHorizontalAlignment(4);
            this.rpmTField.setHorizontalAlignment(4);
            this.speed1TField.setText("0");
            this.speed2TField.setText("0");
            this.rpmTField.setText("0");
            JLabel finalSpeed1Label = new JLabel(Language.string("Vel1 Km/h"));
            finalSpeed1Label.setHorizontalAlignment(0);
            JLabel finalSpeed2Label = new JLabel(Language.string("Vel2 Km/h"));
            finalSpeed2Label.setHorizontalAlignment(0);
            JLabel finalRpmLabel = new JLabel(Language.string("RPM"));
            finalRpmLabel.setHorizontalAlignment(0);
            finalPanel.add(finalSpeed1Label);
            finalPanel.add(this.speed1TField);
            finalPanel.add(finalSpeed2Label);
            finalPanel.add(this.speed2TField);
            finalPanel.add(finalRpmLabel);
            finalPanel.add(this.rpmTField);
            finalPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 1, 6));
            finalPanelBorder.setBorder(BorderFactory.createTitledBorder(Language.string("Dati elaborati")));
            finalPanelBorder.add((Component)finalPanel, "Center");
            datiFinalPanel.add(rawPanelBorder);
            datiFinalPanel.add(finalPanelBorder);
            mainPanel.add((Component)settingsPanelBorder, "Center");
            mainPanel.add((Component)datiFinalPanel, "After");
            this.setLayout(new BorderLayout());
            this.add((Component)mainPanel, "Center");
            this.add((Component)buttonPanel, "South");
            this.setConnected(false);
        }

        public void usaDatiDefault() {
            this.pignone1TField.setText(String.valueOf(OnLineDialog.this.datiInterni[1]));
            this.pignone2TField.setText(String.valueOf(OnLineDialog.this.datiInterni[4]));
            this.corona1TField.setText(String.valueOf(OnLineDialog.this.datiInterni[2]));
            this.corona2TField.setText(String.valueOf(OnLineDialog.this.datiInterni[5]));
            this.wheelCirc1TField.setText(String.valueOf(OnLineDialog.this.datiInterni[0]));
            this.wheelCirc2TField.setText(String.valueOf(OnLineDialog.this.datiInterni[3]));
            this.gear1TField.setText(String.valueOf(OnLineDialog.this.datiInterni[24]));
            this.gear2TField.setText(String.valueOf(OnLineDialog.this.datiInterni[25]));
            this.gear3TField.setText(String.valueOf(OnLineDialog.this.datiInterni[26]));
            this.gear4TField.setText(String.valueOf(OnLineDialog.this.datiInterni[27]));
            this.gear5TField.setText(String.valueOf(OnLineDialog.this.datiInterni[28]));
            this.gear6TField.setText(String.valueOf(OnLineDialog.this.datiInterni[29]));
            OnLineDialog.this.gear1Default = Float.parseFloat(this.gear1TField.getText());
            OnLineDialog.this.gear2Default = Float.parseFloat(this.gear2TField.getText());
            OnLineDialog.this.gear3Default = Float.parseFloat(this.gear3TField.getText());
            OnLineDialog.this.gear4Default = Float.parseFloat(this.gear4TField.getText());
            OnLineDialog.this.gear5Default = Float.parseFloat(this.gear5TField.getText());
            OnLineDialog.this.gear6Default = Float.parseFloat(this.gear6TField.getText());
            OnLineDialog.this.pignone1Default = Integer.parseInt(this.pignone1TField.getText());
            OnLineDialog.this.corona1Default = Integer.parseInt(this.corona1TField.getText());
            OnLineDialog.this.wheelCirc1Default = Integer.parseInt(this.wheelCirc1TField.getText());
            OnLineDialog.this.pignone2Default = Integer.parseInt(this.pignone2TField.getText());
            OnLineDialog.this.corona2Default = Integer.parseInt(this.corona2TField.getText());
            OnLineDialog.this.wheelCirc2Default = Integer.parseInt(this.wheelCirc2TField.getText());
        }

        public void setConnected(boolean connected) {
            if (connected) {
                this.connectButton.setText(Language.string("Disconnetti"));
                this.readButton.setEnabled(true);
                this.continuousReadButton.setEnabled(true);
                try {
                    this.impulseSpeed1TField.setText(Integer.toString(OnLineDialog.this.conn.getImpulseSpeed1()));
                    this.impulseSpeed2TField.setText(Integer.toString(OnLineDialog.this.conn.getImpulseSpeed2()));
                    this.impulseRpmTField.setText(Integer.toString(OnLineDialog.this.conn.getImpulseRpm()));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.impulseSpeed1TField.setEnabled(true);
                this.impulseSpeed2TField.setEnabled(true);
                this.impulseRpmTField.setEnabled(true);
                this.pignone1TField.setEnabled(true);
                this.pignone2TField.setEnabled(true);
                this.corona1TField.setEnabled(true);
                this.corona2TField.setEnabled(true);
                this.wheelCirc1TField.setEnabled(true);
                this.wheelCirc2TField.setEnabled(true);
                this.gear1TField.setEnabled(true);
                this.gear2TField.setEnabled(true);
                this.gear3TField.setEnabled(true);
                this.gear4TField.setEnabled(true);
                this.gear5TField.setEnabled(true);
                this.gear6TField.setEnabled(true);
                this.pignone1TField.setText(String.valueOf(OnLineDialog.this.datiInterni[1]));
                this.pignone2TField.setText(String.valueOf(OnLineDialog.this.datiInterni[4]));
                this.corona1TField.setText(String.valueOf(OnLineDialog.this.datiInterni[2]));
                this.corona2TField.setText(String.valueOf(OnLineDialog.this.datiInterni[5]));
                this.wheelCirc1TField.setText(String.valueOf(OnLineDialog.this.datiInterni[0]));
                this.wheelCirc2TField.setText(String.valueOf(OnLineDialog.this.datiInterni[3]));
                this.gear1TField.setText(String.valueOf(OnLineDialog.this.datiInterni[24]));
                System.out.println("marcia1=" + OnLineDialog.this.datiInterni[24]);
                this.gear2TField.setText(String.valueOf(OnLineDialog.this.datiInterni[25]));
                this.gear3TField.setText(String.valueOf(OnLineDialog.this.datiInterni[26]));
                this.gear4TField.setText(String.valueOf(OnLineDialog.this.datiInterni[27]));
                this.gear5TField.setText(String.valueOf(OnLineDialog.this.datiInterni[28]));
                this.gear6TField.setText(String.valueOf(OnLineDialog.this.datiInterni[29]));
                OnLineDialog.this.gear1Default = Float.parseFloat(this.gear1TField.getText());
                OnLineDialog.this.gear2Default = Float.parseFloat(this.gear2TField.getText());
                OnLineDialog.this.gear3Default = Float.parseFloat(this.gear3TField.getText());
                OnLineDialog.this.gear4Default = Float.parseFloat(this.gear4TField.getText());
                OnLineDialog.this.gear5Default = Float.parseFloat(this.gear5TField.getText());
                OnLineDialog.this.gear6Default = Float.parseFloat(this.gear6TField.getText());
                OnLineDialog.this.pignone1Default = Integer.parseInt(this.pignone1TField.getText());
                OnLineDialog.this.corona1Default = Integer.parseInt(this.corona1TField.getText());
                OnLineDialog.this.wheelCirc1Default = Integer.parseInt(this.wheelCirc1TField.getText());
                OnLineDialog.this.pignone2Default = Integer.parseInt(this.pignone2TField.getText());
                OnLineDialog.this.corona2Default = Integer.parseInt(this.corona2TField.getText());
                OnLineDialog.this.wheelCirc2Default = Integer.parseInt(this.wheelCirc2TField.getText());
                this.defaultButton.setEnabled(true);
            } else {
                this.connectButton.setText(Language.string("Connetti"));
                this.readButton.setEnabled(false);
                this.continuousReadButton.setEnabled(false);
                this.applyButton.setEnabled(false);
                this.defaultButton.setEnabled(false);
                this.impulseSpeed1TField.setText("");
                this.impulseSpeed2TField.setText("");
                this.impulseRpmTField.setText("");
                this.pignone1TField.setText("");
                this.pignone2TField.setText("");
                this.corona1TField.setText("");
                this.corona2TField.setText("");
                this.wheelCirc1TField.setText("");
                this.wheelCirc2TField.setText("");
                this.gear1TField.setText("");
                this.gear2TField.setText("");
                this.gear3TField.setText("");
                this.gear4TField.setText("");
                this.gear5TField.setText("");
                this.gear6TField.setText("");
                this.gear1TField.setEnabled(false);
                this.gear2TField.setEnabled(false);
                this.gear3TField.setEnabled(false);
                this.gear4TField.setEnabled(false);
                this.gear5TField.setEnabled(false);
                this.gear6TField.setEnabled(false);
                this.impulseSpeed1TField.setEnabled(false);
                this.impulseSpeed2TField.setEnabled(false);
                this.impulseRpmTField.setEnabled(false);
                this.pignone1TField.setEnabled(false);
                this.pignone2TField.setEnabled(false);
                this.corona1TField.setEnabled(false);
                this.corona2TField.setEnabled(false);
                this.wheelCirc1TField.setEnabled(false);
                this.wheelCirc2TField.setEnabled(false);
            }
        }

        private void checkRange(JTextField tField, int rangeMin, int rangeMax, int defaultValue) {
            int value;
            try {
                value = Integer.parseInt(tField.getText());
            }
            catch (NumberFormatException e) {
                tField.setText(String.valueOf(defaultValue));
                return;
            }
            if (value > rangeMax) {
                value = rangeMax;
            } else if (value < rangeMin) {
                value = rangeMin;
            }
            tField.setText(String.valueOf(value));
        }

        private void checkGear(JTextField tField, float defaultValue) {
            try {
                float value = Float.valueOf(tField.getText()).floatValue();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                tField.setText(String.valueOf(defaultValue));
                return;
            }
        }

        public String acquisisciLinea() {
            try {
                return OnLineDialog.this.conn.readOnLineData();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                OnLineDialog.this.disconnect();
                return null;
            }
        }

        public void scriviLinea(String stringa) {
            int rawHardwareDataSpeed1 = 65535;
            int rawHardwareDataSpeed2 = 65535;
            int rawHardwareDataRpm = 65535;
            try {
                String stringTempPartialData = null;
                String stringTempDataLine = stringa;
                if (stringTempDataLine.startsWith("$VALUE")) {
                    StringTokenizer st = new StringTokenizer(stringTempDataLine, ",");
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    rawHardwareDataSpeed1 = Integer.parseInt(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    rawHardwareDataSpeed2 = Integer.parseInt(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    rawHardwareDataRpm = Integer.parseInt(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                    }
                    rawHardwareDataSpeed1 = MeasuresUtil.convertiValoreSpeedCan(rawHardwareDataSpeed1, 1, OnLineDialog.this.tipoMotoCan);
                    rawHardwareDataSpeed2 = MeasuresUtil.convertiValoreSpeedCan(rawHardwareDataSpeed2, 2, OnLineDialog.this.tipoMotoCan);
                    rawHardwareDataRpm = MeasuresUtil.convertiValoreRpmCan(rawHardwareDataRpm, OnLineDialog.this.tipoMotoCan);
                    float speed1 = 1.0f / ((float)rawHardwareDataSpeed1 * 2.56E-5f) * 3.6f * (float)OnLineDialog.this.pignone1Default / (float)OnLineDialog.this.corona1Default * (float)OnLineDialog.this.wheelCirc1Default / 1000.0f;
                    float speed2 = 1.0f / ((float)rawHardwareDataSpeed2 * 2.56E-5f) * 3.6f * (float)OnLineDialog.this.pignone2Default / (float)OnLineDialog.this.corona2Default * (float)OnLineDialog.this.wheelCirc2Default / 1000.0f;
                    float rpm = 1.0f / ((float)rawHardwareDataRpm * 1.6E-6f) * 60.0f;
                    if (rawHardwareDataSpeed1 != 65535) {
                        this.rawSpeed1TField.setText(Float.toString((float)Math.round(1.0f / ((float)rawHardwareDataSpeed1 * 2.56E-5f) * (float)OnLineDialog.this.conn.getImpulseSpeed1() * 3600.0f * 10.0f) / 10.0f));
                        this.speed1TField.setText(Float.toString((float)Math.round(speed1 * 10.0f) / 10.0f));
                    } else {
                        this.rawSpeed1TField.setText("0");
                        this.speed1TField.setText("0");
                    }
                    if (rawHardwareDataSpeed2 != 65535) {
                        this.rawSpeed2TField.setText(Float.toString((float)Math.round(1.0f / ((float)rawHardwareDataSpeed2 * 2.56E-5f) * (float)OnLineDialog.this.conn.getImpulseSpeed2() * 3600.0f * 10.0f) / 10.0f));
                        this.speed2TField.setText(Float.toString((float)Math.round(speed2 * 10.0f) / 10.0f));
                    } else {
                        this.rawSpeed2TField.setText("0");
                        this.speed2TField.setText("0");
                    }
                    if (rawHardwareDataRpm != 65535) {
                        this.rawRpmTField.setText(Float.toString((float)Math.round(1.0f / ((float)rawHardwareDataRpm * 1.6E-6f) * 60.0f * (float)OnLineDialog.this.conn.getImpulseRpm() * 10.0f) / 10.0f));
                        this.rpmTField.setText(Float.toString((float)Math.round(rpm * 10.0f) / 10.0f));
                    } else {
                        this.rpmTField.setText("0");
                        this.rawRpmTField.setText("0");
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void continuosMode(boolean attiva) {
            if (attiva) {
                this.continuousReadButton.setText(Language.string("Stop Acquisizione"));
                this.readButton.setEnabled(false);
                this.connectButton.setEnabled(false);
                this.applyButton.setEnabled(false);
                this.defaultButton.setEnabled(false);
            } else {
                this.continuousReadButton.setText(Language.string("Acquisisci continuo"));
                this.readButton.setEnabled(true);
                this.connectButton.setEnabled(true);
                this.applyButton.setEnabled(true);
                this.defaultButton.setEnabled(true);
            }
        }

        public void controllaValori() {
            try {
                this.checkRange(this.impulseSpeed1TField, 1, 100, OnLineDialog.this.conn.getImpulseSpeed1());
                this.checkRange(this.impulseSpeed2TField, 1, 100, OnLineDialog.this.conn.getImpulseSpeed2());
                this.checkRange(this.impulseRpmTField, 1, 100, OnLineDialog.this.conn.getImpulseRpm());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.checkRange(this.pignone1TField, 1, 100, OnLineDialog.this.pignone1Default);
            this.checkRange(this.pignone2TField, 1, 100, OnLineDialog.this.pignone2Default);
            this.checkRange(this.corona1TField, 1, 100, OnLineDialog.this.corona1Default);
            this.checkRange(this.corona2TField, 1, 100, OnLineDialog.this.corona2Default);
            this.checkRange(this.wheelCirc1TField, 1, 3000, OnLineDialog.this.wheelCirc1Default);
            this.checkRange(this.wheelCirc2TField, 1, 3000, OnLineDialog.this.wheelCirc2Default);
            this.checkGear(this.gear1TField, OnLineDialog.this.gear1Default);
            this.checkGear(this.gear2TField, OnLineDialog.this.gear2Default);
            this.checkGear(this.gear3TField, OnLineDialog.this.gear3Default);
            this.checkGear(this.gear4TField, OnLineDialog.this.gear4Default);
            this.checkGear(this.gear5TField, OnLineDialog.this.gear5Default);
            this.checkGear(this.gear6TField, OnLineDialog.this.gear6Default);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.applyButton) {
                this.connectButton.setEnabled(false);
                this.controllaValori();
                OnLineDialog.this.datiInterni[0] = Integer.parseInt(this.wheelCirc1TField.getText());
                OnLineDialog.this.datiInterni[1] = Integer.parseInt(this.pignone1TField.getText());
                OnLineDialog.this.datiInterni[2] = Integer.parseInt(this.corona1TField.getText());
                OnLineDialog.this.datiInterni[3] = Integer.parseInt(this.wheelCirc2TField.getText());
                OnLineDialog.this.datiInterni[4] = Integer.parseInt(this.pignone2TField.getText());
                OnLineDialog.this.datiInterni[5] = Integer.parseInt(this.corona2TField.getText());
                OnLineDialog.this.datiInterni[24] = Float.valueOf(Float.parseFloat(this.gear1TField.getText()));
                OnLineDialog.this.datiInterni[25] = Float.valueOf(Float.parseFloat(this.gear2TField.getText()));
                OnLineDialog.this.datiInterni[26] = Float.valueOf(Float.parseFloat(this.gear3TField.getText()));
                OnLineDialog.this.datiInterni[27] = Float.valueOf(Float.parseFloat(this.gear4TField.getText()));
                OnLineDialog.this.datiInterni[28] = Float.valueOf(Float.parseFloat(this.gear5TField.getText()));
                OnLineDialog.this.datiInterni[29] = Float.valueOf(Float.parseFloat(this.gear6TField.getText()));
                try {
                    OnLineDialog.this.conn.setSettings(Integer.parseInt(this.impulseSpeed1TField.getText()), Integer.parseInt(this.impulseSpeed2TField.getText()), Integer.parseInt(this.impulseRpmTField.getText()));
                    OnLineDialog.this.conn.scriviInternalSettings(OnLineDialog.this.createLineSettings());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                    OnLineDialog.this.disconnect();
                    return;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                try {
                    this.impulseSpeed1TField.setText(Integer.toString(OnLineDialog.this.conn.getImpulseSpeed1()));
                    this.impulseSpeed2TField.setText(Integer.toString(OnLineDialog.this.conn.getImpulseSpeed2()));
                    this.impulseRpmTField.setText(Integer.toString(OnLineDialog.this.conn.getImpulseRpm()));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                OnLineDialog.this.pignone1Default = Integer.parseInt(this.pignone1TField.getText());
                OnLineDialog.this.corona1Default = Integer.parseInt(this.corona1TField.getText());
                OnLineDialog.this.wheelCirc1Default = Integer.parseInt(this.wheelCirc1TField.getText());
                OnLineDialog.this.pignone2Default = Integer.parseInt(this.pignone2TField.getText());
                OnLineDialog.this.corona2Default = Integer.parseInt(this.corona2TField.getText());
                OnLineDialog.this.wheelCirc2Default = Integer.parseInt(this.wheelCirc2TField.getText());
                OnLineDialog.this.gear1Default = Float.parseFloat(this.gear1TField.getText());
                OnLineDialog.this.gear2Default = Float.parseFloat(this.gear2TField.getText());
                OnLineDialog.this.gear3Default = Float.parseFloat(this.gear3TField.getText());
                OnLineDialog.this.gear4Default = Float.parseFloat(this.gear4TField.getText());
                OnLineDialog.this.gear5Default = Float.parseFloat(this.gear5TField.getText());
                OnLineDialog.this.gear6Default = Float.parseFloat(this.gear6TField.getText());
                this.applyButton.setEnabled(false);
                if (!OnLineDialog.this.continusMode) {
                    this.connectButton.setEnabled(true);
                }
            } else if (evt.getSource() == this.readButton) {
                this.connectButton.setEnabled(false);
                this.scriviLinea(this.acquisisciLinea());
                this.connectButton.setEnabled(true);
            } else if (evt.getSource() == this.defaultButton) {
                this.connectButton.setEnabled(false);
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(Language.string("Select settings file"));
                fc.setFileFilter(new FileNameExtensionFilter("Settaggi", "cfg"));
                JOptionPane.showMessageDialog(null, Language.string("I settaggi non contengono le impostazioni hardware (compresi i numeri di impulsi)."), Language.string("ATTENZIONE"), 2);
                int returnVal = fc.showOpenDialog(this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        file.setReadable(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    OnLineDialog.this.inizializzaDataDaFile(file);
                    for (int i = 0; i < 37; ++i) {
                        OnLineDialog.this.datiInterni[i] = OnLineDialog.this.dataIniziali[i];
                    }
                    OnLineDialog.this.analogPanel.usaDatiDefault();
                    OnLineDialog.this.digitalPanel.usaDatiDefault();
                    OnLineDialog.this.pignone1Default = Integer.parseInt(this.pignone1TField.getText());
                    OnLineDialog.this.corona1Default = Integer.parseInt(this.corona1TField.getText());
                    OnLineDialog.this.wheelCirc1Default = Integer.parseInt(this.wheelCirc1TField.getText());
                    OnLineDialog.this.pignone2Default = Integer.parseInt(this.pignone2TField.getText());
                    OnLineDialog.this.corona2Default = Integer.parseInt(this.corona2TField.getText());
                    OnLineDialog.this.wheelCirc2Default = Integer.parseInt(this.wheelCirc2TField.getText());
                    OnLineDialog.this.gear1Default = Float.parseFloat(this.gear1TField.getText());
                    OnLineDialog.this.gear2Default = Float.parseFloat(this.gear2TField.getText());
                    OnLineDialog.this.gear3Default = Float.parseFloat(this.gear3TField.getText());
                    OnLineDialog.this.gear4Default = Float.parseFloat(this.gear4TField.getText());
                    OnLineDialog.this.gear5Default = Float.parseFloat(this.gear5TField.getText());
                    OnLineDialog.this.gear6Default = Float.parseFloat(this.gear6TField.getText());
                }
                this.connectButton.setEnabled(true);
                OnLineDialog.this.allPan.aggiornaNomi(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (OnLineDialog.this.conn.isConnected() && this.continuousReadButton.getText() != Language.string("Stop Acquisizione")) {
                this.applyButton.setEnabled(true);
            }
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }

    private class AnalogPanel
    extends JPanel
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        private JButton readButton;
        private JButton continuousReadButton;
        private JButton connectButton;
        private JButton applyButton;
        private JButton defaultButton;
        private JButton sensoriButton;
        private JTextField analog1MinTField;
        private JTextField analog1MaxTField;
        private JTextField analog5MinTField;
        private JTextField analog5MaxTField;
        private JTextField analog1NomeTField;
        private JTextField analog2NomeTField;
        private JTextField analog3NomeTField;
        private JTextField analog4NomeTField;
        private JTextField analog5NomeTField;
        private JTextField analog6NomeTField;
        private JTextField analog2MinTField;
        private JTextField analog2MaxTField;
        private JTextField analog6MinTField;
        private JTextField analog6MaxTField;
        private JTextField analog7MinTField;
        private JTextField analog7MaxTField;
        private JTextField analog8MinTField;
        private JTextField analog8MaxTField;
        private JTextField analog7NomeTField;
        private JTextField analog8NomeTField;
        private JTextField frontMinTField;
        private JTextField frontMaxTField;
        private JTextField rearMinTField;
        private JTextField rearMaxTField;
        private JTextField rawAnalog1TField;
        private JTextField rawAnalog2TField;
        private JTextField rawFrontTField;
        private JTextField rawRearTField;
        private JTextField rawAnalog5TField;
        private JTextField rawAnalog6TField;
        private JTextField rawAnalog7TField;
        private JTextField rawAnalog8TField;
        private JTextField finalAnalog1TField;
        private JTextField finalAnalog2TField;
        private JTextField finalFrontTField;
        private JTextField finalAnalog5TField;
        private JTextField finalAnalog6TField;
        private JTextField finalRearTField;
        private JTextField finalAnalog7TField;
        private JTextField finalAnalog8TField;
        private JCheckBox analog1CBox;
        private JCheckBox analog2CBox;
        private JCheckBox frontCBox;
        private JCheckBox rearCBox;

        public AnalogPanel() {
            JPanel buttonPanel = new JPanel();
            this.readButton = new JButton(Language.string("Acquisisci"));
            this.readButton.addActionListener(this);
            this.defaultButton = new JButton(Language.string("Carica settaggi"));
            this.defaultButton.addActionListener(this);
            this.sensoriButton = new JButton(Language.string("Configura sensori"));
            this.sensoriButton.addActionListener(this);
            this.continuousReadButton = new JButton(Language.string("Acquisisci continuo"));
            this.continuousReadButton.addActionListener(OnLineDialog.this);
            this.connectButton = new JButton(Language.string("Connetti"));
            this.connectButton.addActionListener(OnLineDialog.this);
            this.applyButton = new JButton(Language.string("Applica"));
            this.applyButton.addActionListener(this);
            buttonPanel.add(this.continuousReadButton);
            buttonPanel.add(this.connectButton);
            buttonPanel.add(this.applyButton);
            buttonPanel.add(this.defaultButton);
            buttonPanel.add(this.sensoriButton);
            buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel analogDatiFinalPanel = new JPanel(new GridLayout(0, 2));
            JPanel settingsPanel = new JPanel(new GridLayout(9, 4, 4, 4));
            JPanel rawPanel = new JPanel(new GridLayout(9, 0, 0, 9));
            JPanel finalPanel = new JPanel(new GridLayout(9, 0, 0, 9));
            JPanel rawPanelBorder = new JPanel(new BorderLayout());
            JPanel finalPanelBorder = new JPanel(new BorderLayout());
            JPanel settingsPanelBorder = new JPanel(new BorderLayout());
            this.analog1NomeTField = new JTextField(5);
            this.analog2NomeTField = new JTextField(5);
            this.analog3NomeTField = new JTextField(5);
            this.analog4NomeTField = new JTextField(5);
            this.analog5NomeTField = new JTextField(5);
            this.analog6NomeTField = new JTextField(5);
            this.analog7NomeTField = new JTextField(5);
            this.analog8NomeTField = new JTextField(5);
            this.analog1MinTField = new JTextField(5);
            this.analog1MaxTField = new JTextField(5);
            this.analog2MinTField = new JTextField(5);
            this.analog2MaxTField = new JTextField(5);
            this.analog5MinTField = new JTextField(5);
            this.analog5MaxTField = new JTextField(5);
            this.analog6MinTField = new JTextField(5);
            this.analog6MaxTField = new JTextField(5);
            this.analog7MinTField = new JTextField(5);
            this.analog7MaxTField = new JTextField(5);
            this.analog8MinTField = new JTextField(5);
            this.analog8MaxTField = new JTextField(5);
            this.frontMinTField = new JTextField(5);
            this.frontMaxTField = new JTextField(5);
            this.rearMinTField = new JTextField(5);
            this.rearMaxTField = new JTextField(5);
            this.analog1NomeTField.setHorizontalAlignment(4);
            this.analog2NomeTField.setHorizontalAlignment(4);
            this.analog3NomeTField.setHorizontalAlignment(4);
            this.analog4NomeTField.setHorizontalAlignment(4);
            this.analog5NomeTField.setHorizontalAlignment(4);
            this.analog6NomeTField.setHorizontalAlignment(4);
            this.analog7NomeTField.setHorizontalAlignment(4);
            this.analog8NomeTField.setHorizontalAlignment(4);
            this.analog1MinTField.setHorizontalAlignment(4);
            this.analog1MaxTField.setHorizontalAlignment(4);
            this.analog2MinTField.setHorizontalAlignment(4);
            this.analog2MaxTField.setHorizontalAlignment(4);
            this.analog5MinTField.setHorizontalAlignment(4);
            this.analog5MaxTField.setHorizontalAlignment(4);
            this.analog6MinTField.setHorizontalAlignment(4);
            this.analog6MaxTField.setHorizontalAlignment(4);
            this.analog7MinTField.setHorizontalAlignment(4);
            this.analog7MaxTField.setHorizontalAlignment(4);
            this.analog8MinTField.setHorizontalAlignment(4);
            this.analog8MaxTField.setHorizontalAlignment(4);
            this.frontMinTField.setHorizontalAlignment(4);
            this.frontMaxTField.setHorizontalAlignment(4);
            this.rearMinTField.setHorizontalAlignment(4);
            this.rearMaxTField.setHorizontalAlignment(4);
            this.analog1NomeTField.addKeyListener(this);
            this.analog2NomeTField.addKeyListener(this);
            this.analog3NomeTField.addKeyListener(this);
            this.analog4NomeTField.addKeyListener(this);
            this.analog5NomeTField.addKeyListener(this);
            this.analog6NomeTField.addKeyListener(this);
            this.analog7NomeTField.addKeyListener(this);
            this.analog8NomeTField.addKeyListener(this);
            this.analog1MinTField.addKeyListener(this);
            this.analog1MaxTField.addKeyListener(this);
            this.analog2MinTField.addKeyListener(this);
            this.analog2MaxTField.addKeyListener(this);
            this.analog5MinTField.addKeyListener(this);
            this.analog5MaxTField.addKeyListener(this);
            this.analog6MinTField.addKeyListener(this);
            this.analog6MaxTField.addKeyListener(this);
            this.analog7MinTField.addKeyListener(this);
            this.analog7MaxTField.addKeyListener(this);
            this.analog8MinTField.addKeyListener(this);
            this.analog8MaxTField.addKeyListener(this);
            this.frontMinTField.addKeyListener(this);
            this.frontMaxTField.addKeyListener(this);
            this.rearMinTField.addKeyListener(this);
            this.rearMaxTField.addKeyListener(this);
            this.analog1CBox = new JCheckBox("");
            this.analog1CBox.setHorizontalAlignment(0);
            this.analog1CBox.addActionListener(this);
            this.analog2CBox = new JCheckBox("");
            this.analog2CBox.setHorizontalAlignment(0);
            this.analog2CBox.addActionListener(this);
            this.frontCBox = new JCheckBox("");
            this.frontCBox.setHorizontalAlignment(0);
            this.frontCBox.addActionListener(this);
            this.rearCBox = new JCheckBox("");
            this.rearCBox.setHorizontalAlignment(0);
            this.rearCBox.addActionListener(this);
            JLabel analog1Label = new JLabel(Language.string("Analog 1:"));
            Font font_etichetta = analog1Label.getFont().deriveFont(14.0f);
            analog1Label.setFont(font_etichetta);
            analog1Label.setHorizontalAlignment(0);
            JLabel analog2Label = new JLabel(Language.string("Analog 2:"));
            analog2Label.setHorizontalAlignment(0);
            analog2Label.setFont(font_etichetta);
            JLabel frontLabel = new JLabel(Language.string("Analog 3:"));
            frontLabel.setHorizontalAlignment(0);
            frontLabel.setFont(font_etichetta);
            JLabel rearLabel = new JLabel(Language.string("Analog 4:"));
            rearLabel.setHorizontalAlignment(0);
            rearLabel.setFont(font_etichetta);
            JLabel analog5Label = new JLabel(Language.string("Analog 5:"));
            analog5Label.setHorizontalAlignment(0);
            analog5Label.setFont(font_etichetta);
            JLabel analog6Label = new JLabel(Language.string("Analog 6:"));
            analog6Label.setHorizontalAlignment(0);
            analog6Label.setFont(font_etichetta);
            JLabel analog7Label = new JLabel(Language.string("Analog 7:"));
            analog7Label.setHorizontalAlignment(0);
            analog7Label.setFont(font_etichetta);
            JLabel analog8Label = new JLabel(Language.string("Analog 8:"));
            analog8Label.setHorizontalAlignment(0);
            analog8Label.setFont(font_etichetta);
            JLabel NomeLabel = new JLabel(Language.string("Nome"));
            NomeLabel.setHorizontalAlignment(0);
            JLabel MinLabel = new JLabel(Language.string("Val. Minimo"));
            MinLabel.setHorizontalAlignment(0);
            JLabel MaxLabel = new JLabel(Language.string("Val. Massimo "));
            MaxLabel.setHorizontalAlignment(0);
            JLabel InverLabel = new JLabel(Language.string("Inverti"));
            InverLabel.setHorizontalAlignment(0);
            settingsPanel.add(new JLabel("    "));
            settingsPanel.add(NomeLabel);
            settingsPanel.add(MinLabel);
            settingsPanel.add(MaxLabel);
            settingsPanel.add(analog1Label);
            settingsPanel.add(this.analog1NomeTField);
            settingsPanel.add(this.analog1MinTField);
            settingsPanel.add(this.analog1MaxTField);
            settingsPanel.add(analog2Label);
            settingsPanel.add(this.analog2NomeTField);
            settingsPanel.add(this.analog2MinTField);
            settingsPanel.add(this.analog2MaxTField);
            settingsPanel.add(frontLabel);
            settingsPanel.add(this.analog3NomeTField);
            settingsPanel.add(this.frontMinTField);
            settingsPanel.add(this.frontMaxTField);
            settingsPanel.add(rearLabel);
            settingsPanel.add(this.analog4NomeTField);
            settingsPanel.add(this.rearMinTField);
            settingsPanel.add(this.rearMaxTField);
            settingsPanel.add(analog5Label);
            settingsPanel.add(this.analog5NomeTField);
            settingsPanel.add(this.analog5MinTField);
            settingsPanel.add(this.analog5MaxTField);
            settingsPanel.add(analog6Label);
            settingsPanel.add(this.analog6NomeTField);
            settingsPanel.add(this.analog6MinTField);
            settingsPanel.add(this.analog6MaxTField);
            settingsPanel.add(analog7Label);
            settingsPanel.add(this.analog7NomeTField);
            settingsPanel.add(this.analog7MinTField);
            settingsPanel.add(this.analog7MaxTField);
            settingsPanel.add(analog8Label);
            settingsPanel.add(this.analog8NomeTField);
            settingsPanel.add(this.analog8MinTField);
            settingsPanel.add(this.analog8MaxTField);
            settingsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            settingsPanelBorder.setBorder(BorderFactory.createTitledBorder(Language.string("Settaggi")));
            settingsPanelBorder.add((Component)settingsPanel, "Center");
            this.rawAnalog1TField = new JTextField(7);
            this.rawAnalog2TField = new JTextField(5);
            this.rawFrontTField = new JTextField(5);
            this.rawRearTField = new JTextField(5);
            this.rawAnalog5TField = new JTextField(5);
            this.rawAnalog6TField = new JTextField(5);
            this.rawAnalog7TField = new JTextField(5);
            this.rawAnalog8TField = new JTextField(5);
            this.rawAnalog1TField.setEditable(false);
            this.rawAnalog2TField.setEditable(false);
            this.rawFrontTField.setEditable(false);
            this.rawRearTField.setEditable(false);
            this.rawAnalog5TField.setEditable(false);
            this.rawAnalog6TField.setEditable(false);
            this.rawAnalog7TField.setEditable(false);
            this.rawAnalog8TField.setEditable(false);
            this.rawAnalog1TField.setHorizontalAlignment(4);
            this.rawAnalog2TField.setHorizontalAlignment(4);
            this.rawFrontTField.setHorizontalAlignment(4);
            this.rawRearTField.setHorizontalAlignment(4);
            this.rawAnalog5TField.setHorizontalAlignment(4);
            this.rawAnalog6TField.setHorizontalAlignment(4);
            this.rawAnalog7TField.setHorizontalAlignment(4);
            this.rawAnalog8TField.setHorizontalAlignment(4);
            this.rawAnalog1TField.setText("0");
            this.rawAnalog2TField.setText("0");
            this.rawFrontTField.setText("0");
            this.rawRearTField.setText("0");
            this.rawAnalog5TField.setText("0");
            this.rawAnalog6TField.setText("0");
            this.rawAnalog7TField.setText("0");
            this.rawAnalog8TField.setText("0");
            rawPanel.add(new JLabel("    "));
            rawPanel.add(this.rawAnalog1TField);
            rawPanel.add(this.rawAnalog2TField);
            rawPanel.add(this.rawFrontTField);
            rawPanel.add(this.rawRearTField);
            rawPanel.add(this.rawAnalog5TField);
            rawPanel.add(this.rawAnalog6TField);
            rawPanel.add(this.rawAnalog7TField);
            rawPanel.add(this.rawAnalog8TField);
            rawPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 1, 5));
            rawPanelBorder.setBorder(BorderFactory.createTitledBorder(Language.string("Dati grezzi")));
            rawPanelBorder.add((Component)rawPanel, "Center");
            this.finalAnalog1TField = new JTextField(7);
            this.finalAnalog2TField = new JTextField(5);
            this.finalFrontTField = new JTextField(5);
            this.finalRearTField = new JTextField(5);
            this.finalAnalog5TField = new JTextField(5);
            this.finalAnalog6TField = new JTextField(5);
            this.finalAnalog7TField = new JTextField(5);
            this.finalAnalog8TField = new JTextField(5);
            this.finalAnalog1TField.setEditable(false);
            this.finalAnalog2TField.setEditable(false);
            this.finalFrontTField.setEditable(false);
            this.finalRearTField.setEditable(false);
            this.finalAnalog5TField.setEditable(false);
            this.finalAnalog6TField.setEditable(false);
            this.finalAnalog7TField.setEditable(false);
            this.finalAnalog8TField.setEditable(false);
            this.finalAnalog1TField.setHorizontalAlignment(4);
            this.finalAnalog2TField.setHorizontalAlignment(4);
            this.finalFrontTField.setHorizontalAlignment(4);
            this.finalRearTField.setHorizontalAlignment(4);
            this.finalAnalog5TField.setHorizontalAlignment(4);
            this.finalAnalog6TField.setHorizontalAlignment(4);
            this.finalAnalog7TField.setHorizontalAlignment(4);
            this.finalAnalog8TField.setHorizontalAlignment(4);
            this.finalAnalog1TField.setText("0");
            this.finalAnalog2TField.setText("0");
            this.finalFrontTField.setText("0");
            this.finalRearTField.setText("0");
            this.finalAnalog5TField.setText("0");
            this.finalAnalog6TField.setText("0");
            this.finalAnalog7TField.setText("0");
            this.finalAnalog8TField.setText("0");
            finalPanel.add(new JLabel("    "));
            finalPanel.add(this.finalAnalog1TField);
            finalPanel.add(this.finalAnalog2TField);
            finalPanel.add(this.finalFrontTField);
            finalPanel.add(this.finalRearTField);
            finalPanel.add(this.finalAnalog5TField);
            finalPanel.add(this.finalAnalog6TField);
            finalPanel.add(this.finalAnalog7TField);
            finalPanel.add(this.finalAnalog8TField);
            finalPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 1, 5));
            finalPanelBorder.setBorder(BorderFactory.createTitledBorder(Language.string("Dati elaborati")));
            finalPanelBorder.add((Component)finalPanel, "Center");
            analogDatiFinalPanel.add(rawPanelBorder);
            analogDatiFinalPanel.add(finalPanelBorder);
            mainPanel.add((Component)settingsPanelBorder, "Center");
            mainPanel.add((Component)analogDatiFinalPanel, "After");
            this.setLayout(new BorderLayout());
            this.add((Component)mainPanel, "Center");
            this.add((Component)buttonPanel, "South");
            this.setConnected(false);
        }

        public void configuraSensori() {
            SensoriDialog sensD = new SensoriDialog(OnLineDialog.this, OnLineDialog.this.conn);
            sensD.setLocationRelativeTo(null);
            sensD.setVisible(true);
            if (sensD.isSet()) {
                if (sensD.isAnalogSet(1)) {
                    this.analog1MinTField.setText(this.troncaStringa(Float.toString(sensD.getMinAnalog(1))));
                    this.analog1MaxTField.setText(this.troncaStringa(Float.toString(sensD.getMaxAnalog(1))));
                }
                if (sensD.isAnalogSet(2)) {
                    this.analog2MinTField.setText(this.troncaStringa(Float.toString(sensD.getMinAnalog(2))));
                    this.analog2MaxTField.setText(this.troncaStringa(Float.toString(sensD.getMaxAnalog(2))));
                }
                if (sensD.isAnalogSet(3)) {
                    this.frontMinTField.setText(this.troncaStringa(Float.toString(sensD.getMinAnalog(3))));
                    this.frontMaxTField.setText(this.troncaStringa(Float.toString(sensD.getMaxAnalog(3))));
                }
                if (sensD.isAnalogSet(4)) {
                    this.rearMinTField.setText(this.troncaStringa(Float.toString(sensD.getMinAnalog(4))));
                    this.rearMaxTField.setText(this.troncaStringa(Float.toString(sensD.getMaxAnalog(4))));
                }
                if (sensD.isAnalogSet(5)) {
                    this.analog5MinTField.setText(this.troncaStringa(Float.toString(sensD.getMinAnalog(5))));
                    this.analog5MaxTField.setText(this.troncaStringa(Float.toString(sensD.getMaxAnalog(5))));
                }
                if (sensD.isAnalogSet(6)) {
                    this.analog6MinTField.setText(this.troncaStringa(Float.toString(sensD.getMinAnalog(6))));
                    this.analog6MaxTField.setText(this.troncaStringa(Float.toString(sensD.getMaxAnalog(6))));
                }
                if (sensD.isAnalogSet(7)) {
                    this.analog7MinTField.setText(this.troncaStringa(Float.toString(sensD.getMinAnalog(7))));
                    this.analog7MaxTField.setText(this.troncaStringa(Float.toString(sensD.getMaxAnalog(7))));
                }
                if (sensD.isAnalogSet(8)) {
                    this.analog8MinTField.setText(this.troncaStringa(Float.toString(sensD.getMinAnalog(8))));
                    this.analog8MaxTField.setText(this.troncaStringa(Float.toString(sensD.getMaxAnalog(8))));
                }
                this.controllaAnalogici();
                this.applyButton.setEnabled(true);
            }
        }

        public String acquisisciLinea() {
            try {
                return OnLineDialog.this.conn.readOnLineData();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                OnLineDialog.this.disconnect();
                return null;
            }
        }

        public void scriviLinea(String stringa) {
            int rawAnalog5 = 0;
            int rawAnalog6 = 0;
            int rawAnalog7 = 0;
            int rawAnalog8 = 0;
            try {
                String stringTempPartialData = null;
                String stringTempDataLine = stringa;
                if (stringTempDataLine.startsWith("$VALUE")) {
                    float analog8;
                    float analog7;
                    float analog6;
                    float analog5;
                    float rear;
                    float front;
                    float analog2;
                    float analog1;
                    StringTokenizer st = new StringTokenizer(stringTempDataLine, ",");
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    int rawFront = Integer.valueOf(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    int rawRear = Integer.valueOf(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    stringTempPartialData = st.nextToken();
                    int rawAnalog1 = Integer.valueOf(stringTempPartialData);
                    stringTempPartialData = st.nextToken();
                    int rawAnalog2 = Integer.valueOf(stringTempPartialData);
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawAnalog5 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawAnalog6 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawAnalog7 = Integer.valueOf(stringTempPartialData);
                    }
                    if (st.hasMoreTokens()) {
                        stringTempPartialData = st.nextToken();
                        rawAnalog8 = Integer.valueOf(stringTempPartialData);
                    }
                    this.rawAnalog1TField.setText(Integer.toString(rawAnalog1));
                    this.rawAnalog2TField.setText(Integer.toString(rawAnalog2));
                    this.rawFrontTField.setText(Integer.toString(rawFront));
                    this.rawRearTField.setText(Integer.toString(rawRear));
                    this.rawAnalog5TField.setText(Integer.toString(rawAnalog5));
                    this.rawAnalog6TField.setText(Integer.toString(rawAnalog6));
                    this.rawAnalog7TField.setText(Integer.toString(rawAnalog7));
                    this.rawAnalog8TField.setText(Integer.toString(rawAnalog8));
                    if (OnLineDialog.this.analog1MinDefault > OnLineDialog.this.analog1MaxDefault) {
                        rawAnalog1 = 1023 - rawAnalog1;
                        analog1 = Math.abs(OnLineDialog.this.analog1MaxDefault - OnLineDialog.this.analog1MinDefault) / 1023.0f * (float)rawAnalog1 + OnLineDialog.this.analog1MaxDefault;
                    } else {
                        analog1 = Math.abs(OnLineDialog.this.analog1MaxDefault - OnLineDialog.this.analog1MinDefault) / 1023.0f * (float)rawAnalog1 + OnLineDialog.this.analog1MinDefault;
                    }
                    if (OnLineDialog.this.analog2MinDefault > OnLineDialog.this.analog2MaxDefault) {
                        rawAnalog2 = 1023 - rawAnalog2;
                        analog2 = Math.abs(OnLineDialog.this.analog2MaxDefault - OnLineDialog.this.analog2MinDefault) / 1023.0f * (float)rawAnalog2 + OnLineDialog.this.analog2MaxDefault;
                    } else {
                        analog2 = Math.abs(OnLineDialog.this.analog2MaxDefault - OnLineDialog.this.analog2MinDefault) / 1023.0f * (float)rawAnalog2 + OnLineDialog.this.analog2MinDefault;
                    }
                    if (OnLineDialog.this.frontMinDefault > OnLineDialog.this.frontMaxDefault) {
                        rawFront = 1023 - rawFront;
                        front = Math.abs(OnLineDialog.this.frontMaxDefault - OnLineDialog.this.frontMinDefault) / 1023.0f * (float)rawFront + OnLineDialog.this.frontMaxDefault;
                    } else {
                        front = Math.abs(OnLineDialog.this.frontMaxDefault - OnLineDialog.this.frontMinDefault) / 1023.0f * (float)rawFront + OnLineDialog.this.frontMinDefault;
                    }
                    if (OnLineDialog.this.rearMinDefault > OnLineDialog.this.rearMaxDefault) {
                        rawRear = 1023 - rawRear;
                        rear = Math.abs(OnLineDialog.this.rearMaxDefault - OnLineDialog.this.rearMinDefault) / 1023.0f * (float)rawRear + OnLineDialog.this.rearMaxDefault;
                    } else {
                        rear = Math.abs(OnLineDialog.this.rearMaxDefault - OnLineDialog.this.rearMinDefault) / 1023.0f * (float)rawRear + OnLineDialog.this.rearMinDefault;
                    }
                    if (OnLineDialog.this.analog5MinDefault > OnLineDialog.this.analog5MaxDefault) {
                        rawAnalog5 = 1023 - rawAnalog5;
                        analog5 = Math.abs(OnLineDialog.this.analog5MaxDefault - OnLineDialog.this.analog5MinDefault) / 1023.0f * (float)rawAnalog5 + OnLineDialog.this.analog5MaxDefault;
                    } else {
                        analog5 = Math.abs(OnLineDialog.this.analog5MaxDefault - OnLineDialog.this.analog5MinDefault) / 1023.0f * (float)rawAnalog5 + OnLineDialog.this.analog5MinDefault;
                    }
                    if (OnLineDialog.this.analog6MinDefault > OnLineDialog.this.analog6MaxDefault) {
                        rawAnalog6 = 1023 - rawAnalog6;
                        analog6 = Math.abs(OnLineDialog.this.analog6MaxDefault - OnLineDialog.this.analog6MinDefault) / 1023.0f * (float)rawAnalog6 + OnLineDialog.this.analog6MaxDefault;
                    } else {
                        analog6 = Math.abs(OnLineDialog.this.analog6MaxDefault - OnLineDialog.this.analog6MinDefault) / 1023.0f * (float)rawAnalog6 + OnLineDialog.this.analog6MinDefault;
                    }
                    if (OnLineDialog.this.analog7MinDefault > OnLineDialog.this.analog7MaxDefault) {
                        rawAnalog7 = 1023 - rawAnalog7;
                        analog7 = Math.abs(OnLineDialog.this.analog7MaxDefault - OnLineDialog.this.analog7MinDefault) / 1023.0f * (float)rawAnalog7 + OnLineDialog.this.analog7MaxDefault;
                    } else {
                        analog7 = Math.abs(OnLineDialog.this.analog7MaxDefault - OnLineDialog.this.analog7MinDefault) / 1023.0f * (float)rawAnalog7 + OnLineDialog.this.analog7MinDefault;
                    }
                    if (OnLineDialog.this.analog8MinDefault > OnLineDialog.this.analog8MaxDefault) {
                        rawAnalog8 = 1023 - rawAnalog8;
                        analog8 = Math.abs(OnLineDialog.this.analog8MaxDefault - OnLineDialog.this.analog8MinDefault) / 1023.0f * (float)rawAnalog8 + OnLineDialog.this.analog8MaxDefault;
                    } else {
                        analog8 = Math.abs(OnLineDialog.this.analog8MaxDefault - OnLineDialog.this.analog8MinDefault) / 1023.0f * (float)rawAnalog8 + OnLineDialog.this.analog8MinDefault;
                    }
                    this.finalAnalog1TField.setText(String.format("%.2f", Float.valueOf(analog1)));
                    this.finalAnalog2TField.setText(String.format("%.2f", Float.valueOf(analog2)));
                    this.finalFrontTField.setText(String.format("%.2f", Float.valueOf(front)));
                    this.finalRearTField.setText(String.format("%.2f", Float.valueOf(rear)));
                    this.finalAnalog5TField.setText(String.format("%.2f", Float.valueOf(analog5)));
                    this.finalAnalog6TField.setText(String.format("%.2f", Float.valueOf(analog6)));
                    this.finalAnalog7TField.setText(String.format("%.2f", Float.valueOf(analog7)));
                    this.finalAnalog8TField.setText(String.format("%.2f", Float.valueOf(analog8)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public String troncaStringa(String stringa) {
            if (stringa.length() >= 6) {
                try {
                    return stringa.substring(0, 6);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return stringa;
                }
            }
            return stringa;
        }

        public void usaDatiDefault() {
            this.analog1NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[6]));
            this.analog1MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[7]));
            this.analog1MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[8]));
            this.analog2NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[9]));
            this.analog2MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[10]));
            this.analog2MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[11]));
            this.analog3NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[12]));
            this.frontMinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[13]));
            this.frontMaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[14]));
            this.analog4NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[15]));
            this.rearMinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[16]));
            this.rearMaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[17]));
            this.analog5NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[18]));
            this.analog5MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[19]));
            this.analog5MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[20]));
            this.analog6NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[21]));
            this.analog6MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[22]));
            this.analog6MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[23]));
            this.analog7NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[30]));
            this.analog7MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[31]));
            this.analog7MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[32]));
            this.analog8NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[33]));
            this.analog8MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[34]));
            this.analog8MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[35]));
            OnLineDialog.this.analog1MinDefault = Float.valueOf(this.analog1MinTField.getText()).floatValue();
            OnLineDialog.this.analog1MaxDefault = Float.valueOf(this.analog1MaxTField.getText()).floatValue();
            OnLineDialog.this.analog2MinDefault = Float.valueOf(this.analog2MinTField.getText()).floatValue();
            OnLineDialog.this.analog2MaxDefault = Float.valueOf(this.analog2MaxTField.getText()).floatValue();
            OnLineDialog.this.analog5MinDefault = Float.valueOf(this.analog5MinTField.getText()).floatValue();
            OnLineDialog.this.analog5MaxDefault = Float.valueOf(this.analog5MaxTField.getText()).floatValue();
            OnLineDialog.this.analog6MinDefault = Float.valueOf(this.analog6MinTField.getText()).floatValue();
            OnLineDialog.this.analog6MaxDefault = Float.valueOf(this.analog6MaxTField.getText()).floatValue();
            OnLineDialog.this.analog7MinDefault = Float.valueOf(this.analog7MinTField.getText()).floatValue();
            OnLineDialog.this.analog7MaxDefault = Float.valueOf(this.analog7MaxTField.getText()).floatValue();
            OnLineDialog.this.analog8MinDefault = Float.valueOf(this.analog8MinTField.getText()).floatValue();
            OnLineDialog.this.analog8MaxDefault = Float.valueOf(this.analog8MaxTField.getText()).floatValue();
            OnLineDialog.this.frontMinDefault = Float.valueOf(this.frontMinTField.getText()).floatValue();
            OnLineDialog.this.frontMaxDefault = Float.valueOf(this.frontMaxTField.getText()).floatValue();
            OnLineDialog.this.rearMinDefault = Float.valueOf(this.rearMinTField.getText()).floatValue();
            OnLineDialog.this.rearMaxDefault = Float.valueOf(this.rearMaxTField.getText()).floatValue();
            OnLineDialog.this.analog1InvertDefault = this.analog1CBox.isSelected();
            OnLineDialog.this.analog2InvertDefault = this.analog2CBox.isSelected();
            OnLineDialog.this.frontInvertDefault = this.frontCBox.isSelected();
            OnLineDialog.this.rearInvertDefault = this.rearCBox.isSelected();
        }

        public void setConnected(boolean connected) {
            if (connected) {
                this.connectButton.setText(Language.string("Disconnetti"));
                this.readButton.setEnabled(true);
                this.continuousReadButton.setEnabled(true);
                this.sensoriButton.setEnabled(true);
                this.analog1NomeTField.setEnabled(true);
                this.analog2NomeTField.setEnabled(true);
                this.analog3NomeTField.setEnabled(true);
                this.analog4NomeTField.setEnabled(true);
                this.analog5NomeTField.setEnabled(true);
                this.analog6NomeTField.setEnabled(true);
                this.analog7NomeTField.setEnabled(true);
                this.analog8NomeTField.setEnabled(true);
                this.analog1MinTField.setEnabled(true);
                this.analog1MaxTField.setEnabled(true);
                this.analog2MinTField.setEnabled(true);
                this.analog2MaxTField.setEnabled(true);
                this.analog5MinTField.setEnabled(true);
                this.analog5MaxTField.setEnabled(true);
                this.analog6MinTField.setEnabled(true);
                this.analog6MaxTField.setEnabled(true);
                this.analog7MinTField.setEnabled(true);
                this.analog7MaxTField.setEnabled(true);
                this.analog8MinTField.setEnabled(true);
                this.analog8MaxTField.setEnabled(true);
                this.frontMinTField.setEnabled(true);
                this.frontMaxTField.setEnabled(true);
                this.rearMinTField.setEnabled(true);
                this.rearMaxTField.setEnabled(true);
                this.analog1CBox.setEnabled(true);
                this.analog2CBox.setEnabled(true);
                this.frontCBox.setEnabled(true);
                this.rearCBox.setEnabled(true);
                this.analog1NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[6]));
                this.analog1MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[7]));
                this.analog1MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[8]));
                this.analog2NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[9]));
                this.analog2MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[10]));
                this.analog2MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[11]));
                this.analog3NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[12]));
                this.frontMinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[13]));
                this.frontMaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[14]));
                this.analog4NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[15]));
                this.rearMinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[16]));
                this.rearMaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[17]));
                this.analog5NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[18]));
                this.analog5MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[19]));
                this.analog5MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[20]));
                this.analog6NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[21]));
                this.analog6MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[22]));
                this.analog6MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[23]));
                this.analog7NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[30]));
                this.analog7MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[31]));
                this.analog7MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[32]));
                this.analog8NomeTField.setText(String.valueOf(OnLineDialog.this.datiInterni[33]));
                this.analog8MinTField.setText(String.valueOf(OnLineDialog.this.datiInterni[34]));
                this.analog8MaxTField.setText(String.valueOf(OnLineDialog.this.datiInterni[35]));
                OnLineDialog.this.analog1MinDefault = Float.valueOf(this.analog1MinTField.getText()).floatValue();
                OnLineDialog.this.analog1MaxDefault = Float.valueOf(this.analog1MaxTField.getText()).floatValue();
                OnLineDialog.this.analog2MinDefault = Float.valueOf(this.analog2MinTField.getText()).floatValue();
                OnLineDialog.this.analog2MaxDefault = Float.valueOf(this.analog2MaxTField.getText()).floatValue();
                OnLineDialog.this.analog5MinDefault = Float.valueOf(this.analog5MinTField.getText()).floatValue();
                OnLineDialog.this.analog5MaxDefault = Float.valueOf(this.analog5MaxTField.getText()).floatValue();
                OnLineDialog.this.analog6MinDefault = Float.valueOf(this.analog6MinTField.getText()).floatValue();
                OnLineDialog.this.analog6MaxDefault = Float.valueOf(this.analog6MaxTField.getText()).floatValue();
                OnLineDialog.this.analog7MinDefault = Float.valueOf(this.analog7MinTField.getText()).floatValue();
                OnLineDialog.this.analog7MaxDefault = Float.valueOf(this.analog7MaxTField.getText()).floatValue();
                OnLineDialog.this.analog8MinDefault = Float.valueOf(this.analog8MinTField.getText()).floatValue();
                OnLineDialog.this.analog8MaxDefault = Float.valueOf(this.analog8MaxTField.getText()).floatValue();
                OnLineDialog.this.frontMinDefault = Float.valueOf(this.frontMinTField.getText()).floatValue();
                OnLineDialog.this.frontMaxDefault = Float.valueOf(this.frontMaxTField.getText()).floatValue();
                OnLineDialog.this.rearMinDefault = Float.valueOf(this.rearMinTField.getText()).floatValue();
                OnLineDialog.this.rearMaxDefault = Float.valueOf(this.rearMaxTField.getText()).floatValue();
                OnLineDialog.this.analog1InvertDefault = this.analog1CBox.isSelected();
                OnLineDialog.this.analog2InvertDefault = this.analog2CBox.isSelected();
                OnLineDialog.this.frontInvertDefault = this.frontCBox.isSelected();
                OnLineDialog.this.rearInvertDefault = this.rearCBox.isSelected();
                this.analog1CBox.setSelected(OnLineDialog.this.analog1InvertDefault);
                this.analog2CBox.setSelected(OnLineDialog.this.analog2InvertDefault);
                this.frontCBox.setSelected(OnLineDialog.this.frontInvertDefault);
                this.rearCBox.setSelected(OnLineDialog.this.rearInvertDefault);
                this.defaultButton.setEnabled(true);
            } else {
                this.continuousReadButton.setText(Language.string("Acquisisci continuo"));
                this.connectButton.setText(Language.string("Connetti"));
                this.sensoriButton.setEnabled(false);
                this.readButton.setEnabled(false);
                this.defaultButton.setEnabled(false);
                this.continuousReadButton.setEnabled(false);
                this.applyButton.setEnabled(false);
                this.analog1NomeTField.setText("");
                this.analog2NomeTField.setText("");
                this.analog3NomeTField.setText("");
                this.analog4NomeTField.setText("");
                this.analog5NomeTField.setText("");
                this.analog6NomeTField.setText("");
                this.analog7NomeTField.setText("");
                this.analog8NomeTField.setText("");
                this.analog1MinTField.setText("");
                this.analog1MaxTField.setText("");
                this.analog2MinTField.setText("");
                this.analog2MaxTField.setText("");
                this.analog5MinTField.setText("");
                this.analog5MaxTField.setText("");
                this.analog6MinTField.setText("");
                this.analog6MaxTField.setText("");
                this.analog7MinTField.setText("");
                this.analog7MaxTField.setText("");
                this.analog8MinTField.setText("");
                this.analog8MaxTField.setText("");
                this.frontMinTField.setText("");
                this.frontMaxTField.setText("");
                this.rearMinTField.setText("");
                this.rearMaxTField.setText("");
                this.analog1NomeTField.setEnabled(false);
                this.analog2NomeTField.setEnabled(false);
                this.analog3NomeTField.setEnabled(false);
                this.analog4NomeTField.setEnabled(false);
                this.analog5NomeTField.setEnabled(false);
                this.analog6NomeTField.setEnabled(false);
                this.analog7NomeTField.setEnabled(false);
                this.analog8NomeTField.setEnabled(false);
                this.analog1MinTField.setEnabled(false);
                this.analog1MaxTField.setEnabled(false);
                this.analog2MinTField.setEnabled(false);
                this.analog2MaxTField.setEnabled(false);
                this.analog5MinTField.setEnabled(false);
                this.analog5MaxTField.setEnabled(false);
                this.analog6MinTField.setEnabled(false);
                this.analog6MaxTField.setEnabled(false);
                this.analog7MinTField.setEnabled(false);
                this.analog7MaxTField.setEnabled(false);
                this.analog8MinTField.setEnabled(false);
                this.analog8MaxTField.setEnabled(false);
                this.frontMinTField.setEnabled(false);
                this.frontMaxTField.setEnabled(false);
                this.rearMinTField.setEnabled(false);
                this.rearMaxTField.setEnabled(false);
                this.analog1CBox.setSelected(false);
                this.analog2CBox.setSelected(false);
                this.frontCBox.setSelected(false);
                this.rearCBox.setSelected(false);
                this.analog1CBox.setEnabled(false);
                this.analog2CBox.setEnabled(false);
                this.frontCBox.setEnabled(false);
                this.rearCBox.setEnabled(false);
            }
        }

        private void checkRange(JTextField tField, float defaultValue) {
            try {
                float value = Float.valueOf(tField.getText()).floatValue();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                tField.setText(String.valueOf(defaultValue));
                return;
            }
        }

        public void continuosMode(boolean attiva) {
            if (attiva) {
                this.continuousReadButton.setText(Language.string("Stop Acquisizione"));
                this.readButton.setEnabled(false);
                this.connectButton.setEnabled(false);
                this.applyButton.setEnabled(false);
                this.defaultButton.setEnabled(false);
                this.sensoriButton.setEnabled(false);
            } else {
                this.continuousReadButton.setText(Language.string("Acquisisci continuo"));
                this.readButton.setEnabled(true);
                this.connectButton.setEnabled(true);
                this.applyButton.setEnabled(true);
                this.defaultButton.setEnabled(true);
                this.sensoriButton.setEnabled(true);
            }
        }

        public void controllaAnalogici() {
            this.checkRange(this.analog1MinTField, OnLineDialog.this.analog1MinDefault);
            this.checkRange(this.analog1MaxTField, OnLineDialog.this.analog1MaxDefault);
            this.checkRange(this.analog2MinTField, OnLineDialog.this.analog2MinDefault);
            this.checkRange(this.analog2MaxTField, OnLineDialog.this.analog2MaxDefault);
            this.checkRange(this.analog5MinTField, OnLineDialog.this.analog1MinDefault);
            this.checkRange(this.analog5MaxTField, OnLineDialog.this.analog1MaxDefault);
            this.checkRange(this.analog6MinTField, OnLineDialog.this.analog2MinDefault);
            this.checkRange(this.analog6MaxTField, OnLineDialog.this.analog2MaxDefault);
            this.checkRange(this.analog7MinTField, OnLineDialog.this.analog7MinDefault);
            this.checkRange(this.analog7MaxTField, OnLineDialog.this.analog7MaxDefault);
            this.checkRange(this.analog8MinTField, OnLineDialog.this.analog8MinDefault);
            this.checkRange(this.analog8MaxTField, OnLineDialog.this.analog8MaxDefault);
            this.checkRange(this.frontMinTField, OnLineDialog.this.frontMinDefault);
            this.checkRange(this.frontMaxTField, OnLineDialog.this.frontMaxDefault);
            this.checkRange(this.rearMinTField, OnLineDialog.this.rearMinDefault);
            this.checkRange(this.rearMaxTField, OnLineDialog.this.rearMaxDefault);
            if (this.analog1NomeTField.getText() == null || this.analog1NomeTField.getText().equals("")) {
                this.analog1NomeTField.setText("vuoto");
            }
            if (this.analog2NomeTField.getText() == null || this.analog2NomeTField.getText().equals("")) {
                this.analog2NomeTField.setText("vuoto");
            }
            if (this.analog3NomeTField.getText() == null || this.analog3NomeTField.getText().equals("")) {
                this.analog3NomeTField.setText("vuoto");
            }
            if (this.analog4NomeTField.getText() == null || this.analog4NomeTField.getText().equals("")) {
                this.analog4NomeTField.setText("vuoto");
            }
            if (this.analog5NomeTField.getText() == null || this.analog5NomeTField.getText().equals("")) {
                this.analog5NomeTField.setText("vuoto");
            }
            if (this.analog6NomeTField.getText() == null || this.analog6NomeTField.getText().equals("")) {
                this.analog6NomeTField.setText("vuoto");
            }
            if (this.analog7NomeTField.getText() == null || this.analog7NomeTField.getText().equals("")) {
                this.analog7NomeTField.setText("vuoto");
            }
            if (this.analog8NomeTField.getText() == null || this.analog8NomeTField.getText().equals("")) {
                this.analog8NomeTField.setText("vuoto");
            }
            OnLineDialog.this.datiInterni[6] = this.analog1NomeTField.getText();
            OnLineDialog.this.datiInterni[7] = Float.valueOf(Float.valueOf(this.analog1MinTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[8] = Float.valueOf(Float.valueOf(this.analog1MaxTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[9] = this.analog2NomeTField.getText();
            OnLineDialog.this.datiInterni[10] = Float.valueOf(Float.valueOf(this.analog2MinTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[11] = Float.valueOf(Float.valueOf(this.analog2MaxTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[12] = this.analog3NomeTField.getText();
            OnLineDialog.this.datiInterni[13] = Float.valueOf(Float.valueOf(this.frontMinTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[14] = Float.valueOf(Float.valueOf(this.frontMaxTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[15] = this.analog4NomeTField.getText();
            OnLineDialog.this.datiInterni[16] = Float.valueOf(Float.valueOf(this.rearMinTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[17] = Float.valueOf(Float.valueOf(this.rearMaxTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[18] = this.analog5NomeTField.getText();
            OnLineDialog.this.datiInterni[19] = Float.valueOf(Float.valueOf(this.analog5MinTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[20] = Float.valueOf(Float.valueOf(this.analog5MaxTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[21] = this.analog6NomeTField.getText();
            OnLineDialog.this.datiInterni[22] = Float.valueOf(Float.valueOf(this.analog6MinTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[23] = Float.valueOf(Float.valueOf(this.analog6MaxTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[30] = this.analog7NomeTField.getText();
            OnLineDialog.this.datiInterni[31] = Float.valueOf(Float.valueOf(this.analog7MinTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[32] = Float.valueOf(Float.valueOf(this.analog7MaxTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[33] = this.analog8NomeTField.getText();
            OnLineDialog.this.datiInterni[34] = Float.valueOf(Float.valueOf(this.analog8MinTField.getText()).floatValue());
            OnLineDialog.this.datiInterni[35] = Float.valueOf(Float.valueOf(this.analog8MaxTField.getText()).floatValue());
            OnLineDialog.this.analog1InvertDefault = this.analog1CBox.isSelected();
            OnLineDialog.this.analog2InvertDefault = this.analog2CBox.isSelected();
            OnLineDialog.this.frontInvertDefault = this.frontCBox.isSelected();
            OnLineDialog.this.rearInvertDefault = this.rearCBox.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.sensoriButton) {
                this.configuraSensori();
            }
            if (evt.getSource() == this.applyButton) {
                this.connectButton.setEnabled(false);
                this.controllaAnalogici();
                OnLineDialog.this.analog1MinDefault = Float.valueOf(this.analog1MinTField.getText()).floatValue();
                OnLineDialog.this.analog1MaxDefault = Float.valueOf(this.analog1MaxTField.getText()).floatValue();
                OnLineDialog.this.analog2MinDefault = Float.valueOf(this.analog2MinTField.getText()).floatValue();
                OnLineDialog.this.analog2MaxDefault = Float.valueOf(this.analog2MaxTField.getText()).floatValue();
                OnLineDialog.this.analog5MinDefault = Float.valueOf(this.analog5MinTField.getText()).floatValue();
                OnLineDialog.this.analog5MaxDefault = Float.valueOf(this.analog5MaxTField.getText()).floatValue();
                OnLineDialog.this.analog6MinDefault = Float.valueOf(this.analog6MinTField.getText()).floatValue();
                OnLineDialog.this.analog6MaxDefault = Float.valueOf(this.analog6MaxTField.getText()).floatValue();
                OnLineDialog.this.analog7MinDefault = Float.valueOf(this.analog7MinTField.getText()).floatValue();
                OnLineDialog.this.analog7MaxDefault = Float.valueOf(this.analog7MaxTField.getText()).floatValue();
                OnLineDialog.this.analog8MinDefault = Float.valueOf(this.analog8MinTField.getText()).floatValue();
                OnLineDialog.this.analog8MaxDefault = Float.valueOf(this.analog8MaxTField.getText()).floatValue();
                OnLineDialog.this.frontMinDefault = Float.valueOf(this.frontMinTField.getText()).floatValue();
                OnLineDialog.this.frontMaxDefault = Float.valueOf(this.frontMaxTField.getText()).floatValue();
                OnLineDialog.this.rearMinDefault = Float.valueOf(this.rearMinTField.getText()).floatValue();
                OnLineDialog.this.rearMaxDefault = Float.valueOf(this.rearMaxTField.getText()).floatValue();
                try {
                    OnLineDialog.this.conn.scriviInternalSettings(OnLineDialog.this.createLineSettings());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                    OnLineDialog.this.disconnect();
                    return;
                }
                this.applyButton.setEnabled(false);
                if (!OnLineDialog.this.continusMode) {
                    this.connectButton.setEnabled(true);
                }
            } else if (evt.getSource() == this.analog1CBox || evt.getSource() == this.analog2CBox || evt.getSource() == this.frontCBox || evt.getSource() == this.rearCBox) {
                if (OnLineDialog.this.conn.isConnected()) {
                    this.applyButton.setEnabled(true);
                }
            } else if (evt.getSource() == this.readButton) {
                this.connectButton.setEnabled(false);
                this.sensoriButton.setEnabled(false);
                this.scriviLinea(this.acquisisciLinea());
                this.connectButton.setEnabled(true);
                this.sensoriButton.setEnabled(true);
            } else if (evt.getSource() == this.defaultButton) {
                this.connectButton.setEnabled(false);
                this.sensoriButton.setEnabled(false);
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(Language.string("Select settings file"));
                fc.setFileFilter(new FileNameExtensionFilter("Settaggi", "cfg"));
                JOptionPane.showMessageDialog(null, Language.string("I settaggi non contengono le impostazioni hardware (compresi i numeri di impulsi)."), Language.string("ATTENZIONE"), 2);
                int returnVal = fc.showOpenDialog(this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        file.setReadable(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    OnLineDialog.this.inizializzaDataDaFile(file);
                    for (int i = 0; i < 37; ++i) {
                        OnLineDialog.this.datiInterni[i] = OnLineDialog.this.dataIniziali[i];
                    }
                    OnLineDialog.this.analogPanel.usaDatiDefault();
                    OnLineDialog.this.digitalPanel.usaDatiDefault();
                }
                this.connectButton.setEnabled(true);
                this.sensoriButton.setEnabled(true);
                OnLineDialog.this.allPan.aggiornaNomi(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (OnLineDialog.this.conn.isConnected() && this.continuousReadButton.getText() != Language.string("Stop Acquisizione")) {
                this.applyButton.setEnabled(true);
            }
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }
}

