/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.Language;
import i2m.MainFrame;
import i2m.onLine.SerialConnection;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FirmwareUpLoaderTpmsCan
extends JDialog
implements WindowListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton cancelB;
    private JButton nextB;
    private JPanel centerP;
    private CardLayout centerCL;
    private JComboBox portChooser;
    private String[] portNames = null;
    private String chosenPortName;
    private int numeroCartaAttuale;
    private long lunghezzaFile;
    private SerialConnection conn;
    private JProgressBar progressB;
    JLabel downloadL;
    private File fileHex;
    boolean scegli = true;
    MainFrame padre;
    boolean erroreFile = false;

    public FirmwareUpLoaderTpmsCan(MainFrame mainF) {
        super(mainF, Language.string(""), true);
        this.padre = mainF;
        this.setSize(400, 280);
        this.setResizable(false);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.cancelB = new JButton(" Esci ");
        this.cancelB.addActionListener(this);
        this.nextB = new JButton(" Avanti ");
        this.nextB.addActionListener(this);
        JPanel buttonP = new JPanel();
        buttonP.setLayout(new FlowLayout(2));
        buttonP.add(this.cancelB);
        buttonP.add(this.nextB);
        this.add((Component)buttonP, "South");
        this.centerP = new JPanel();
        this.centerCL = new CardLayout();
        this.centerP.setLayout(this.centerCL);
        this.add((Component)this.centerP, "Center");
        this.numeroCartaAttuale = 1;
        JPanel welcomeP = new JPanel();
        JLabel welcomeL = new JLabel(Language.string("<html><font size=5>Firmware Uploader</font><br>Questo programma permette l'aggiornamento firmware dei ricevitori TPMS/Can.<br>Premere avanti e scegliere il file del nuovo firmware.</html>"));
        welcomeL.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        welcomeP.setLayout(new BorderLayout());
        welcomeP.add((Component)welcomeL, "North");
        this.centerP.add((Component)welcomeP, "benvenuto");
        this.centerP.setBorder(BorderFactory.createRaisedBevelBorder());
        this.portChooser = new JComboBox();
        JLabel scegliL = new JLabel(Language.string("<html><br>1) Connettere il cavo usb al ricevitore.<br>2) Scegliere la porta COM a cui \u00e8 connesso il cavo</html>"));
        JPanel comP = new JPanel();
        comP.setLayout(new BorderLayout());
        JPanel com2P = new JPanel();
        com2P.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        com2P.add(scegliL);
        comP.add((Component)com2P, "North");
        JPanel com1P = new JPanel();
        com1P.setLayout(new FlowLayout(1));
        com1P.add(this.portChooser);
        comP.add((Component)com1P, "South");
        this.centerP.add((Component)comP, "sceltaCom");
        JLabel attesaL = new JLabel(Language.string("<html><font size=4 color=red>ATTENZIONE:</font><br>Non scollegare il ricevitore durante l'aggionamento.<br></html>"));
        JPanel accensioneP = new JPanel();
        accensioneP.add(attesaL);
        accensioneP.setCursor(Cursor.getPredefinedCursor(3));
        this.centerP.add((Component)accensioneP, "accensione");
        this.downloadL = new JLabel(Language.string("<html><font size=4 color=red>ATTENZIONE:</font><br>Download del nuovo firmware in corso.<br>Interrompere il download prima del termine renderebbe<br>il ricevitore inutilizzabile.<br><br></html>"));
        JPanel downloadP = new JPanel();
        JPanel download1P = new JPanel();
        JPanel download2P = new JPanel();
        download1P.add(this.downloadL);
        this.progressB = new JProgressBar(0, 100);
        this.progressB.setValue(0);
        this.progressB.setStringPainted(true);
        download2P.add(this.progressB);
        downloadP.setLayout(new BorderLayout());
        downloadP.add((Component)download1P, "North");
        downloadP.add((Component)download2P, "Center");
        this.centerP.add((Component)downloadP, "download");
        JLabel endL = new JLabel(Language.string("<html><font size=4 color=red>FIRMARE UDATED:<br></font><br> Caricamento del nuovo firmware avvenuto con successo.<br>"));
        JPanel endP = new JPanel();
        endP.add(endL);
        this.centerP.add((Component)endP, "end");
    }

    public boolean getErroreFile() {
        return this.erroreFile;
    }

    public void scegliFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("firmware", "hex"));
        if (fileChooser.showOpenDialog(this) != 0) {
            System.out.println(" chiudo.");
            this.erroreFile = true;
        }
        this.fileHex = fileChooser.getSelectedFile();
        try {
            this.fileHex.setReadable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fileHex == null) {
            this.erroreFile = true;
        }
        if (this.erroreFile) {
            JOptionPane.showMessageDialog(this, Language.string("File selezionato non corretto"), "Errore", 0);
        }
    }

    public static void main(String[] args) {
        FirmwareUpLoaderTpmsCan f = new FirmwareUpLoaderTpmsCan(null);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.cancelB) {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setVisible(false);
        }
        if (evt.getSource() == this.nextB) {
            if (this.numeroCartaAttuale == 1) {
                this.scegliFile();
                if (this.getErroreFile()) {
                    try {
                        if (this.conn != null) {
                            this.conn.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.setVisible(false);
                }
            }
            ++this.numeroCartaAttuale;
            if (this.numeroCartaAttuale == 2) {
                this.centerCL.next(this.centerP);
                this.portNames = SerialConnection.getAvailablePorts().toArray(new String[0]);
                if (this.portNames.length == 0) {
                    JOptionPane.showMessageDialog(this, Language.string("Non sono state trovate porte seriali"), "Errore", 0);
                    --this.numeroCartaAttuale;
                    this.centerCL.previous(this.centerP);
                } else {
                    for (String p : this.portNames) {
                        this.portChooser.addItem(p);
                    }
                }
            } else if (this.numeroCartaAttuale == 3) {
                this.chosenPortName = this.portNames[this.portChooser.getSelectedIndex()];
                this.nextB.setEnabled(false);
                System.out.println(this.chosenPortName);
                try {
                    this.conn = new SerialConnection(this.chosenPortName);
                    this.conn.open(5);
                    this.conn.clear(3000);
                    System.out.println("Aperta porta COM");
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("ATTENZIONE"), 2);
                    e.printStackTrace();
                    this.setVisible(false);
                }
                this.centerCL.next(this.centerP);
                new Thread(){

                    @Override
                    public void run() {
                        FirmwareUpLoaderTpmsCan.this.download();
                    }
                }.start();
            }
        }
    }

    private void download() {
        int byteLetti = 0;
        try {
            System.out.println("scrivo bbbbTPMSCAN");
            this.conn.write("bbbbTPMSCAN");
            System.out.println("scritto bbbbTPMSCAN");
            Thread.sleep(300L);
            System.out.println("Inizio traferimento");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Language.string("Errore durante la scrittura: spegnere e riprovare"), "Errore", 0);
            e.printStackTrace();
            this.setVisible(false);
        }
        this.centerCL.next(this.centerP);
        try {
            String line;
            this.conn.clear();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileHex)));
            this.lunghezzaFile = this.fileHex.length();
            while ((line = reader.readLine()) != null) {
                byteLetti += line.length();
                System.out.println("leggo dal file=" + line);
                if (!line.startsWith(":")) continue;
                System.out.println("linea letta=" + line);
                this.conn.write(':');
                for (int i = 1; i < line.length(); i += 2) {
                    int d = 0;
                    char c1 = line.charAt(i);
                    char c2 = line.charAt(i + 1);
                    if (c1 >= '0' && c1 <= '9') {
                        d = c1 - 48;
                    } else if (c1 >= 'A' && c1 <= 'F') {
                        d = c1 - 65 + 10;
                    } else {
                        throw new IOException("Error parsing file");
                    }
                    d *= 16;
                    if (c2 >= '0' && c2 <= '9') {
                        d = d + c2 - 48;
                    } else if (c2 >= 'A' && c2 <= 'F') {
                        d = d + c2 - 65 + 10;
                    } else {
                        throw new IOException("Error parsing file");
                    }
                    this.conn.write((char)d);
                }
                System.out.println("leggo status");
                char status = this.conn.readChar();
                System.out.println("letto carattere=" + status);
                if (status != 'k' && status != 'f') {
                    throw new IOException("Error writing firmware");
                }
                this.progressB.setValue((int)((long)(byteLetti * 100) / this.lunghezzaFile));
            }
            reader.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, Language.string("Errore durante la scrittura: spegnere e riprovare"), "Errore", 0);
            e.printStackTrace();
            this.setVisible(false);
        }
        this.centerCL.next(this.centerP);
    }
}

