/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Dialog.HwDasy6;
import i2m.RiassuntoSessione;
import i2m.onLine.ConvertiDasyX;
import i2m.onLine.SerialConnection;
import i2m.onLine.UnknownPortException;
import i2m.onLine.convertiChrome;
import i2m.onLine.convertiDasy6;
import i2m.traguardi.Circuit;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JProgressBar;

public class DeviceConnection {
    private volatile boolean connected;
    private volatile boolean downloading;
    private int downloadProgress;
    private int impulseSpeed1;
    private int impulseSpeed2;
    private int impulseRpm;
    private Thread downloadThread;
    private SerialConnection conn;
    public static final int DASY4 = 0;
    public static final int MINILAP = 1;
    public static final int DASY6 = 2;
    public static final int DAE = 3;
    public static final int TC = 4;
    private int tipoDevice = 0;
    private boolean conversioneFinita = true;
    private boolean registrazioneAttiva = false;
    private int DopMinima = 50;
    private boolean miniLAP2 = false;

    public DeviceConnection(String portName) {
        try {
            this.conn = new SerialConnection(portName);
        }
        catch (UnknownPortException ex1) {
            ex1.printStackTrace();
        }
        this.connected = false;
        this.downloading = false;
        this.downloadProgress = 0;
        this.impulseRpm = -1;
        this.impulseSpeed2 = -1;
        this.impulseSpeed1 = -1;
        this.downloadThread = null;
    }

    public synchronized void connect(int tipoDispositivo) throws Exception {
        String end;
        this.tipoDevice = tipoDispositivo;
        if (this.connected) {
            return;
        }
        this.conn.open(tipoDispositivo);
        System.out.println("Aperta porta");
        this.clearSerialIOBuffer();
        System.out.println("pulito buffer");
        if (tipoDispositivo == 0) {
            this.conn.write("i\r");
            String settings = this.conn.readLine();
            String end2 = this.conn.readLine();
            if (settings == null || settings.length() == 0 || end2 == null || !end2.equals("READY")) {
                this.conn.close();
                throw new IOException("Reading current settings");
            }
            String[] s = settings.split(",");
            this.impulseSpeed1 = Integer.parseInt(s[3]);
            this.impulseSpeed2 = Integer.parseInt(s[4]);
            this.impulseRpm = Integer.parseInt(s[5]);
        }
        if (tipoDispositivo == 2) {
            System.out.println("Scrivo primo R");
            this.conn.write("\r");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.conn.readLine();
            this.conn.write("\r");
            System.out.println("Connessione:Ho scritto l'invio");
            end = this.conn.readLine();
            System.out.println("Connessione:Ho letto:" + end);
            if (end == null || !end.equals("READY")) {
                this.conn.close();
                throw new IOException("Reading current settings");
            }
            this.connected = true;
            String impost = this.leggiSettaggi6();
            HwDasy6 hw = new HwDasy6();
            hw.parseImposString6(impost);
            this.impulseSpeed1 = hw.getSetting(1);
            this.impulseSpeed2 = hw.getSetting(2);
            this.impulseRpm = hw.getSetting(0);
        }
        if (tipoDispositivo == 3) {
            this.conn.write("$I2MSRLDAE\r");
            end = this.conn.readLine();
            if (end == null || !end.endsWith("READY")) {
                this.conn.close();
                throw new IOException("Reading current settings");
            }
        }
        if (tipoDispositivo == 4) {
            this.conn.clear();
            System.out.printf("scrivo $DOWNL", new Object[0]);
            this.conn.write("$DOWNL\r");
            end = this.conn.readLine();
            System.out.printf("\n\rletto=" + end, new Object[0]);
            if (end == null || !end.startsWith("READY")) {
                this.conn.close();
                throw new IOException("Reading current settings");
            }
            this.conn.close();
            this.conn.open(1);
        }
        if (tipoDispositivo == 1) {
            this.conn.write("S\r");
            System.out.println("Invio carattere per connessione a miniLAP");
            end = this.conn.readLine();
            System.out.println("miniLAP ha risposto con:" + end);
            if (end == null || !end.endsWith("READY")) {
                this.conn.close();
                throw new IOException("Reading current settings");
            }
            this.conn.write("?\r");
            System.out.println("Chiedo la versione del miniLAP");
            end = this.conn.readLine();
            if (end.startsWith("$miniLAP2")) {
                this.miniLAP2 = true;
                System.out.println("miniLAP versione2");
                end = this.conn.readLine();
            } else {
                System.out.println("miniLAP versione1");
            }
        }
        this.connected = true;
    }

    public boolean isMinilap2() {
        return this.miniLAP2;
    }

    public synchronized void disconnect() throws IOException {
        if (!this.connected) {
            return;
        }
        System.out.println("chiamata disconnect device");
        this.conn.close();
        this.connected = false;
    }

    public synchronized void disconnectTc() throws IOException {
        if (!this.connected) {
            return;
        }
        this.conn.write("e\r");
        System.out.println("Scrivo la E per cambiare baudrate");
        this.conn.close();
        this.connected = false;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void format(int tipoDispositivo) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        this.conn.write('c');
        if (tipoDispositivo == 2) {
            this.conn.write('\r');
        }
        String line = this.conn.readLine();
        if (!(tipoDispositivo != 0 || line != null && line.equals("Formattare SD? S/N"))) {
            throw new IOException("Waiting for the confirmation message");
        }
        if (!(tipoDispositivo != 2 || line != null && line.equals("Formattare Memoria? S/N"))) {
            throw new IOException("Waiting for the confirmation message");
        }
        if (!(tipoDispositivo != 1 || line != null && line.equals("Cancellare tutti i dati? S/N"))) {
            throw new IOException("Waiting for the confirmation message");
        }
        this.conn.write('s');
        if (tipoDispositivo == 1) {
            this.conn.readLine();
        }
        if (tipoDispositivo == 2) {
            this.conn.write('\r');
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.conn.readLine();
        line = this.conn.readLine();
        if (line == null || !line.equals("READY")) {
            throw new IOException("Waiting for the READY message at the end of format");
        }
    }

    public synchronized void setSettings(int impulseSpeed1, int impulseSpeed2, int impulseRpm) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        if (this.tipoDevice == 0) {
            this.conn.write("IMPOS,,," + impulseSpeed1 + "," + impulseSpeed2 + "," + impulseRpm + ",\r");
            this.conn.readLine();
            String line = this.conn.readLine();
            if (line == null || !line.equals("READY")) {
                throw new IOException("Waiting the READY msg that confirms settings have been changed");
            }
            this.impulseSpeed1 = impulseSpeed1;
            this.impulseSpeed2 = impulseSpeed2;
            this.impulseRpm = impulseRpm;
        } else {
            String impost = this.leggiSettaggi6();
            HwDasy6 hw = new HwDasy6();
            try {
                hw.parseImposString6(impost);
                DanasDataStructure.getInstance();
                DanasDataStructure.impostazioni6 = hw;
                hw.setSettingsBase(impulseSpeed1, impulseSpeed2, impulseRpm);
                String s = HwDasy6.createImposString6();
                this.impostaSettaggi6(s);
                this.impulseSpeed1 = impulseSpeed1;
                this.impulseSpeed2 = impulseSpeed2;
                this.impulseRpm = impulseRpm;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void inviaCircuito(Circuit circuito, boolean attiva, int dopMinima, JProgressBar barra) throws IOException, InterruptedException {
        String line = null;
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        this.setDownloadProgress(0);
        if (circuito != null) {
            int i;
            int numeroAttraversamenti = circuito.numeroAttraversamenti();
            for (i = 0; i < numeroAttraversamenti; ++i) {
                String s = i == 0 ? circuito.getMinilapString(-1, i) : circuito.getMinilapString(1, i);
                this.conn.write(s + "\r");
                System.out.println("Scrivo su Dasy:" + s);
                this.setDownloadProgress(Math.round((float)i * 100.0f / 30.0f));
                Thread.sleep(100L);
            }
            for (i = numeroAttraversamenti; i < 30; ++i) {
                this.conn.write("s," + i + ",NULLO   ,0000.0000,N,00000.0000,E,000,0,0,00,\r");
                System.out.println("Scrivo su Dasy:s," + i + ",NULLO   ,0000.0000,N,00000.0000,E,000,0,0,00,");
                this.setDownloadProgress(Math.round((float)i * 100.0f / 30.0f));
                Thread.sleep(100L);
            }
        } else {
            this.conn.write("t,0,NULLO   ,0000.0000,N,00000.0000,E,000,0,0,00,\r");
            System.out.println("Scrivo su Dasy:t,0,NULLO   ,0000.0000,N,00000.0000,E,000,0,0,00,");
            Thread.sleep(100L);
            for (int i = 1; i < 30; ++i) {
                this.conn.write("s," + i + ",NULLO   ,0000.0000,N,00000.0000,E,000,0,0,00,\r");
                System.out.println("Scrivo su Dasy:s," + i + ",NULLO   ,0000.0000,N,00000.0000,E,000,0,0,00,");
                this.setDownloadProgress(Math.round((float)i * 100.0f / 30.0f));
                barra.setValue(Math.round((float)i * 100.0f / 30.0f));
                Thread.sleep(100L);
            }
        }
        if (attiva) {
            this.conn.write("A");
        } else {
            this.conn.write("V");
        }
        this.conn.write(String.format("P%03d\r", dopMinima));
        System.out.println("scritta DOP=" + dopMinima);
        this.conn.write("e\r");
        line = this.conn.readLine();
        System.out.println(line);
        if (line == null || !line.equals("READY")) {
            System.out.println("Non ho ricevuto il READY,ho ricecuto:" + line);
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
    }

    public boolean isRegistrazioneAttiva() {
        return this.registrazioneAttiva;
    }

    public int getDopMinima() {
        return this.DopMinima;
    }

    public synchronized Circuit LeggiCircuito() throws IOException {
        Circuit c = new Circuit("t,01,        ,0000.0000,N,00000.0000,E,000,0,0,00,");
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        File f = null;
        PrintWriter out = null;
        try {
            String line;
            System.out.println("Creo un file temporaneo");
            f = File.createTempFile("danas_dload_Preview", ".tmp");
            out = new PrintWriter(new FileWriter(f));
            this.clearSerialIOBuffer();
            this.conn.write("l\r");
            while ((line = this.conn.readLine()) != null && !line.equals("READY")) {
                System.out.println("Linea letta=" + line);
                out.println(line);
            }
            System.out.println("Termine lettura");
            out.close();
            this.clearSerialIOBuffer();
            this.conn.write("M");
            line = this.conn.readLine();
            System.out.printf("Registrazione=" + line, new Object[0]);
            this.registrazioneAttiva = line.equals("ATTIVA");
            this.conn.clear();
            this.conn.write("O");
            line = this.conn.readLine();
            System.out.println("letto dopo la o:" + line);
            this.DopMinima = Integer.valueOf(line);
            this.conn.write("e\r");
        }
        catch (IOException ex) {
            out.close();
        }
        c = this.caricaDaFile(f);
        return c;
    }

    public Circuit caricaDaFile(File f) {
        Circuit c = new Circuit("t,01,        ,0000.0000,N,00000.0000,E,000,0,0,00,");
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    c = new Circuit(line);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                st.nextElement();
                st.nextElement();
                String s = st.nextToken();
                if (s.startsWith("NULLO")) continue;
                c.aggiungiSplit(line);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return c;
    }

    public synchronized void impostaSettaggi6(String stringaImpos) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        this.conn.write("i\r");
        this.conn.write(stringaImpos + "\r");
        System.out.println("Scrivo le impos:" + stringaImpos);
        String line = this.conn.readLine();
        System.out.println("ho ricecuto:" + line);
        line = this.conn.readLine();
        if (line == null || !line.equals("READY")) {
            System.out.println("Non ho ricevuto il READY,ho ricecuto:" + line);
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
    }

    public synchronized String leggiVersione() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        this.conn.write("v\r");
        this.conn.readLine();
        String vers = this.conn.readLine();
        System.out.println("Versione letta:" + vers);
        if (vers == null) {
            System.out.println("Non ho ricevuto nulla ");
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
        this.clearSerialIOBuffer();
        return vers;
    }

    public synchronized String leggiInternalSettings() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        this.conn.write("j\r");
        this.conn.write("\r");
        String vers = this.conn.readLine();
        if (vers == null) {
            System.out.println("Non ho ricevuto nulla ");
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
        this.clearSerialIOBuffer();
        return vers;
    }

    public synchronized void scriviInternalSettings(String stringaSett) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        System.out.println("Pulisco buffer");
        this.clearSerialIOBuffer();
        System.out.println("Preparo settings");
        this.conn.write("j\r");
        this.conn.write(stringaSett + "\r");
        System.out.println("Scrivo i settaggi:" + stringaSett);
        String line = this.conn.readLine();
        System.out.println("ho ricecuto:" + line);
        line = this.conn.readLine();
        if (line == null || !line.equals("READY")) {
            System.out.println("Non ho ricevuto il READY,ho ricecuto:" + line);
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
    }

    public synchronized void scriviTestLap() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        this.conn.write("x\r");
        System.out.println("Scrivo X per test Lap");
        String line = this.conn.readLine();
        System.out.println("ho ricecuto:" + line);
        if (line == null || !line.equals("READY")) {
            System.out.println("Non ho ricevuto il READY,ho ricecuto:" + line);
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
    }

    public synchronized String leggiSettaggi6() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        this.conn.write("i\r");
        this.conn.write("\r");
        String impostazioni = this.conn.readLine();
        System.out.println("Lette impos:" + impostazioni);
        String line = this.conn.readLine();
        if (line == null || !line.equals("READY")) {
            System.out.println("Non ho ricevuto il READY,ho ricecuto:" + line);
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
        if (!impostazioni.startsWith("$IMPOS")) {
            System.out.println("Non ho ricevuto una stringa IMPOS");
            throw new IOException("Stringa impostazioni corrotta");
        }
        return impostazioni;
    }

    public synchronized void setDaeSettings(int numeroRPM, int numeroVel, int numeroAnalog, int impulsiRpm, int impulsiVel1, int impulsiVel2) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        this.conn.write("$IMPOSDAE," + numeroRPM + "," + numeroVel + "," + numeroAnalog + "," + impulsiRpm + "," + impulsiVel1 + "," + impulsiVel2 + ",\r");
        this.conn.readLine();
        String line = this.conn.readLine();
        if (line == null || !line.equals("READY")) {
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
    }

    public synchronized void setDaeFrequency10Hz(boolean freq) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        if (freq) {
            this.conn.write("$FREQ10HZ\r");
        } else {
            this.conn.write("$FREQ05HZ\r");
        }
        String line = this.conn.readLine();
        if (line == null || !line.equals("READY")) {
            throw new IOException("Waiting the READY msg that confirms settings have been changed");
        }
    }

    public synchronized int getDaeRpm() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        this.conn.write("$IMPOSDAE\n\r");
        String settings = this.conn.readLine();
        String end = this.conn.readLine();
        if (settings == null || settings.length() == 0 || end == null || !end.equals("READY")) {
            this.conn.close();
            throw new IOException("Reading current settings");
        }
        String[] s = settings.split(",");
        return Integer.parseInt(s[1]);
    }

    public synchronized boolean isDaeFrequency5Hz() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        this.conn.write("$FREQ,\r");
        String settings = this.conn.readLine();
        String end = this.conn.readLine();
        if (settings == null || settings.length() == 0 || end == null || !end.equals("READY")) {
            this.conn.close();
            throw new IOException("Reading current settings");
        }
        return settings.equals("$FREQ05HZ");
    }

    public synchronized int getDaeVel() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        this.conn.write("$IMPOSDAE\r");
        String settings = this.conn.readLine();
        String end = this.conn.readLine();
        if (settings == null || settings.length() == 0 || end == null || !end.equals("READY")) {
            this.conn.close();
            throw new IOException("Reading current settings");
        }
        String[] s = settings.split(",");
        return Integer.parseInt(s[2]);
    }

    public synchronized int getDaeAnalog() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        this.conn.write("$IMPOSDAE\r");
        String settings = this.conn.readLine();
        String end = this.conn.readLine();
        if (settings == null || settings.length() == 0 || end == null || !end.equals("READY")) {
            this.conn.close();
            throw new IOException("Reading current settings");
        }
        String[] s = settings.split(",");
        return Integer.parseInt(s[3]);
    }

    public synchronized int getDaeImpulsiRpm() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        this.conn.write("$IMPOSDAE\r");
        String settings = this.conn.readLine();
        String end = this.conn.readLine();
        if (settings == null || settings.length() == 0 || end == null || !end.equals("READY")) {
            this.conn.close();
            throw new IOException("Reading current settings");
        }
        String[] s = settings.split(",");
        return Integer.parseInt(s[4]);
    }

    public synchronized int getDaeImpulsiVel1() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        this.conn.write("$IMPOSDAE\r");
        String settings = this.conn.readLine();
        String end = this.conn.readLine();
        if (settings == null || settings.length() == 0 || end == null || !end.equals("READY")) {
            this.conn.close();
            throw new IOException("Reading current settings");
        }
        String[] s = settings.split(",");
        return Integer.parseInt(s[5]);
    }

    public synchronized int getDaeImpulsiVel2() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        this.clearSerialIOBuffer();
        this.conn.write("$IMPOSDAE\r");
        String settings = this.conn.readLine();
        String end = this.conn.readLine();
        if (settings == null || settings.length() == 0 || end == null || !end.equals("READY")) {
            this.conn.close();
            throw new IOException("Reading current settings");
        }
        String[] s = settings.split(",");
        return Integer.parseInt(s[6]);
    }

    public synchronized int getImpulseRpm() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        return this.impulseRpm;
    }

    public synchronized int getImpulseSpeed1() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        return this.impulseSpeed1;
    }

    public synchronized int getImpulseSpeed2() throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        return this.impulseSpeed2;
    }

    public synchronized String readOnLineData() throws IOException, IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Downloading");
        }
        this.clearSerialIOBuffer();
        if (this.tipoDevice == 2) {
            this.conn.write("a\r");
        } else {
            this.conn.write('a');
        }
        String line = this.conn.readLine();
        String end = this.conn.readLine();
        if (line == null || line.length() == 0 || end == null || !end.equals("READY")) {
            this.clearSerialIOBuffer();
            this.conn.write('a');
            line = this.conn.readLine();
            end = this.conn.readLine();
            throw new IOException("No answer from Dasy");
        }
        return line;
    }

    public synchronized void startDownloadingStoredData(final String filePath) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Already downloading");
        }
        this.setDownloadProgress(0);
        this.downloading = true;
        this.downloadThread = new Thread(){

            @Override
            public void run() {
                DeviceConnection.this.download(filePath);
            }
        };
        this.downloadThread.setDaemon(true);
        this.downloadThread.start();
    }

    public synchronized void startDownloadSessioni(final String filePath, final int[] selezionate, final DefaultListModel lista, final boolean tutte) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if (this.downloading) {
            throw new IOException("Already downloading");
        }
        this.setDownloadProgress(0);
        this.downloading = true;
        this.downloadThread = new Thread(){

            @Override
            public void run() {
                DeviceConnection.this.downloadSessioni(filePath, selezionate, lista, tutte);
            }
        };
        this.downloadThread.setDaemon(true);
        this.downloadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadSessioni(String filePath, int[] selezionate, DefaultListModel lista, boolean tutte) {
        File f = null;
        OutputStream out = null;
        int byteTotali = 0;
        int byteInizio = 0;
        try {
            RiassuntoSessione sess;
            int i;
            f = new File(filePath);
            out = new BufferedOutputStream(new FileOutputStream(f));
            this.clearSerialIOBuffer();
            int numeroSessioni = tutte ? lista.size() : selezionate.length;
            System.out.println("Devo scaricare " + numeroSessioni + " Sessioni");
            for (i = 0; i < numeroSessioni; ++i) {
                sess = tutte ? (RiassuntoSessione)lista.elementAt(i) : (RiassuntoSessione)lista.elementAt(selezionate[i]);
                byteTotali = byteTotali + sess.getFineMemoriaDasy() - sess.getInizioMemoriaDasy();
            }
            System.out.println("Byte totali da leggere=" + byteTotali);
            for (i = 0; i < numeroSessioni && this.downloading; ++i) {
                sess = tutte ? (RiassuntoSessione)lista.elementAt(i) : (RiassuntoSessione)lista.elementAt(selezionate[i]);
                System.out.println("Byte letti sino ad ora=" + byteInizio);
                try {
                    System.out.println("Scarica da Inizio=" + byteInizio + " fino a=" + byteTotali);
                    if (!this.miniLAP2) {
                        this.scaricaDati(sess, out, byteInizio, byteTotali);
                    } else {
                        this.scaricaDatiMini(sess, out, byteInizio, byteTotali);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                byteInizio = byteInizio + sess.getFineMemoriaDasy() - sess.getInizioMemoriaDasy();
            }
            this.setDownloadProgress(100);
            System.out.println("Finito il download dei dati delle sessioni");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.setDownloadProgress(-1);
            try {
                out.close();
                if (this.downloading) {
                    this.conversioneFinita = false;
                    new convertiDasy6(filePath);
                    new convertiChrome(filePath);
                    new ConvertiDasyX(filePath);
                    this.conversioneFinita = true;
                }
                this.setDownloadProgress(100);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                out.close();
                if (this.downloading) {
                    this.conversioneFinita = false;
                    new convertiDasy6(filePath);
                    new convertiChrome(filePath);
                    new ConvertiDasyX(filePath);
                    this.conversioneFinita = true;
                    this.disconnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.downloading = false;
        }
    }

    public boolean isConversioneFinita() {
        return this.conversioneFinita;
    }

    private void scaricaDati(RiassuntoSessione sess, OutputStream out, int byteInizio, int byteTotali) throws IOException {
        this.conn.write("p\n\r" + sess.getInizioMemoriaDasy() + "\n\r" + sess.getFineMemoriaDasy() + "\n\r");
        String line = this.conn.readLine();
        System.out.println("Linea byte da leggere=" + line);
        if (line == null) {
            throw new IOException("Reading data");
        }
        line = line.substring(15);
        line = line.substring(0, line.indexOf(32));
        int byteDaLeggere = Integer.parseInt(line);
        int data = -1;
        int byteLetti = 0;
        while (this.isConnected() && this.downloading && byteLetti < byteDaLeggere) {
            data = this.conn.read();
            if (data == -1) {
                throw new IOException("Reading data");
            }
            if (data != 36) continue;
            out.write(data);
            byteLetti = 1;
            break;
        }
        while (this.isConnected() && this.downloading && byteLetti < byteDaLeggere) {
            data = this.conn.read();
            if (data == -1) {
                throw new IOException("Reading data");
            }
            out.write(data);
            if (Math.round((float)(++byteLetti + byteInizio) * 100.0f / (float)byteTotali) >= 100) continue;
            this.setDownloadProgress(Math.round((float)(byteLetti + byteInizio) * 100.0f / (float)byteTotali));
        }
        System.out.println("Finito di leggere i byte della sessione");
        line = this.conn.readLine();
        System.out.println("Linea READY da leggere=" + line);
    }

    private void scaricaDatiMini(RiassuntoSessione sess, OutputStream out, int byteInizio, int byteTotali) throws IOException {
        int lineeLette = 0;
        this.conn.write("p," + sess.getNumeroSessioniMini() + ",\n\r");
        System.out.println("p," + sess.getNumeroSessioniMini() + ",\n\r");
        String line = this.conn.readLine();
        System.out.println("Linea byte da leggere=" + line);
        if (line == null) {
            throw new IOException("Reading data");
        }
        line = line.substring(15);
        line = line.substring(0, line.indexOf(32));
        int byteDaLeggere = Integer.parseInt(line);
        System.out.println("Byte da leggere=" + byteDaLeggere);
        int data = -1;
        int byteLetti = 0;
        while (this.isConnected() && this.downloading && byteLetti < byteDaLeggere) {
            data = this.conn.read();
            if (data == -1) {
                throw new IOException("Reading data");
            }
            if (data != 36) continue;
            out.write(data);
            byteLetti = 1;
            break;
        }
        while (this.isConnected() && this.downloading && byteLetti < byteDaLeggere) {
            data = this.conn.read();
            if (data == -1) {
                System.out.println("Byte letti=" + byteLetti);
                throw new IOException("Reading data");
            }
            if (data == 10) {
                System.out.println("lineeLette=" + ++lineeLette);
            }
            out.write(data);
            ++byteLetti;
            if (Math.round((float)(lineeLette + byteInizio) * 100.0f / (float)byteTotali) >= 100) continue;
            this.setDownloadProgress(Math.round((float)(lineeLette + byteInizio) * 100.0f / (float)byteTotali));
        }
        System.out.println("Finito di leggere i byte della sessione");
        line = this.conn.readLine();
        System.out.println("Linea READY da leggere=" + line);
    }

    public void stopDownloading() {
        if (!this.downloading) {
            return;
        }
        this.downloading = false;
        System.out.println("downloading=false");
        try {
            this.downloadThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized int getDownloadProgress() {
        return this.downloadProgress;
    }

    public synchronized void setDownloadProgress(int downloadProgress) {
        this.downloadProgress = downloadProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertiMinilap(String fileIn) throws IOException {
        boolean minilap = false;
        boolean stampaValue = true;
        String tempo = "000";
        BufferedReader inputStream = null;
        PrintWriter outputStream = null;
        File temporaneo = new File(File.createTempFile("danas_conv_", ".tmp").getAbsolutePath());
        File lettura = new File(fileIn);
        try {
            String l;
            inputStream = new BufferedReader(new FileReader(lettura));
            outputStream = new PrintWriter(new FileWriter(temporaneo));
            while ((l = inputStream.readLine()) != null) {
                if (l.length() <= 3 || !l.substring(0, 6).equals("$VALUE")) continue;
                stampaValue = false;
                break;
            }
            inputStream.close();
            inputStream = new BufferedReader(new FileReader(lettura));
            l = inputStream.readLine();
            if (l.substring(0, 8).equals("$MINILAP")) {
                minilap = true;
                outputStream.println(l);
                while ((l = inputStream.readLine()) != null) {
                    if (l.length() > 5 && l.substring(0, 6).equals("$VALUE")) {
                        outputStream.println(l);
                    }
                    if (l.length() > 11 && l.substring(0, 12).equals("$NEW SESSION")) {
                        outputStream.println(l);
                    }
                    if (l.length() <= 3 || !l.substring(0, 4).equals("$GPS")) continue;
                    tempo = l.substring(5, 12);
                    outputStream.println(l);
                    if (!stampaValue) continue;
                    outputStream.println("$VALUE," + tempo + ",0,0,65535,65535,65535,0,0,0,0,\n\r");
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        if (minilap) {
            lettura.delete();
            this.copy(temporaneo, lettura);
        }
    }

    public File downloadRiassunto() {
        File f = null;
        PrintWriter out = null;
        try {
            String line;
            System.out.println("Creo un file temporaneo");
            f = File.createTempFile("danas_dload_Preview", ".tmp");
            out = new PrintWriter(new FileWriter(f));
            this.clearSerialIOBuffer();
            System.out.println("Ho pultito il buffer");
            if (!this.miniLAP2) {
                this.conn.write("s\n\r");
                System.out.println("Ho scritto s");
            } else {
                this.conn.write("r\n\r");
                System.out.println("Ho scritto r");
            }
            while ((line = this.conn.readLine()) != null && !line.equals("READY")) {
                System.out.println("Linea letta=" + line);
                out.println(line);
            }
            System.out.println("Termine lettura");
            out.close();
        }
        catch (IOException ex) {
            out.close();
        }
        return f;
    }

    void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String filePath) {
        File f = null;
        OutputStream out = null;
        try {
            f = new File(filePath);
            out = new BufferedOutputStream(new FileOutputStream(f));
            this.clearSerialIOBuffer();
            if (this.tipoDevice != 2) {
                this.conn.write('d');
            } else {
                this.conn.write("d\n\r");
            }
            String line = this.conn.readLine();
            if (line == null) {
                throw new IOException("Reading data");
            }
            line = line.substring(15);
            line = line.substring(0, line.indexOf(32));
            int byteDaLeggere = Integer.parseInt(line);
            int data = -1;
            int byteLetti = 0;
            while (this.isConnected() && this.downloading && byteLetti < byteDaLeggere) {
                data = this.conn.read();
                if (data == -1) {
                    out.close();
                    throw new IOException("Reading data");
                }
                if (data != 36) continue;
                out.write(data);
                byteLetti = 1;
                break;
            }
            while (this.isConnected() && this.downloading && byteLetti < byteDaLeggere) {
                data = this.conn.read();
                if (data == -1) {
                    out.close();
                    throw new IOException("Reading data");
                }
                out.write(data);
                if (Math.round((float)(++byteLetti) * 100.0f / (float)byteDaLeggere) >= 100) continue;
                this.setDownloadProgress(Math.round((float)byteLetti * 100.0f / (float)byteDaLeggere));
            }
            System.out.println("Termine lettura");
            out.close();
            if (this.downloading) {
                new convertiDasy6(filePath);
                new convertiChrome(filePath);
                new ConvertiDasyX(filePath);
                this.convertiMinilap(filePath);
            }
            this.setDownloadProgress(100);
            if (!this.isConnected() || !this.downloading) {
                System.out.println("Invio tttttttt");
                this.conn.write("\n\r");
            } else {
                line = this.conn.readLine();
                if (line == null || !line.equals("READY")) {
                    throw new IOException("Waiting the READY msg that ends the data");
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.setDownloadProgress(-1);
            try {
                out.close();
                if (this.downloading) {
                    new convertiDasy6(filePath);
                    new convertiChrome(filePath);
                    new ConvertiDasyX(filePath);
                    this.convertiMinilap(filePath);
                }
                this.setDownloadProgress(100);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.downloading = false;
        }
        System.out.println("fine");
    }

    void clearSerialIOBuffer() throws IOException {
        this.conn.clear();
    }
}

