/*
 * Decompiled with CFR 0.152.
 */
package i2m.onLine;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Language;
import i2m.onLine.SerialConnection;
import i2m.traguardi.Circuit;
import i2m.wifi.WifiDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChromeCircuitDialogUsb
extends JDialog
implements ActionListener,
ListSelectionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private JFileChooser fileChooser;
    private MyAction addA;
    private MyAction removeA;
    private MyAction upA;
    private MyAction downA;
    private MyAction receiveWifi;
    private MyAction sendWifi;
    private JList availableCircJL;
    private JList chosenCircJL;
    private DefaultListModel availableCircLM;
    private DefaultListModel chosenCircLM;
    private JButton connettiB;
    private JButton importaB;
    private JButton esportaB;
    private JButton trasmettiWifiB;
    private JButton riceviWifiB;
    private JButton importaUsbB;
    private JButton esportaUsbB;
    private JComboBox sceltaCOM;
    private JLabel comLabel;
    private SerialConnection conn;
    private String[] elencoCom = null;
    boolean connected = false;

    public ChromeCircuitDialogUsb(Frame owner, String[] lista) {
        super(owner, Language.string("Configurazione circuiti Chrome"), false);
        this.elencoCom = lista;
        this.fileChooser = new JFileChooser();
        this.addA = new MyAction(Language.string("Aggiungi"), Language.string("Aggiungi tra i circuiti selezionati"), "/pix/add.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromeCircuitDialogUsb.this.doAdd();
            }
        };
        this.addA.setEnabled(true);
        this.removeA = new MyAction(Language.string("Elimina"), Language.string("Elimina dai circuiti selezionati"), "/pix/sub.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromeCircuitDialogUsb.this.doRemove();
            }
        };
        this.removeA.setEnabled(true);
        this.upA = new MyAction(Language.string("Su"), Language.string("Sposta in su il circuito selezionato"), "/pix/su.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromeCircuitDialogUsb.this.doUp();
            }
        };
        this.upA.setEnabled(true);
        this.downA = new MyAction(Language.string("Giu'"), Language.string("Sposta in giu' il circuito selezionato"), "/pix/giu.png"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromeCircuitDialogUsb.this.doDown();
            }
        };
        this.downA.setEnabled(true);
        JPanel pannelloComandi = new JPanel(new BorderLayout());
        pannelloComandi.add((Component)this.costruisciPannelloCom(), "North");
        pannelloComandi.add((Component)this.costruisciPannelloBottoni(), "South");
        this.aggiornaPorteCom();
        this.abilitaUsb(false);
        this.availableCircLM = new DefaultListModel();
        this.chosenCircLM = new DefaultListModel();
        this.availableCircJL = new JList(this.availableCircLM);
        this.chosenCircJL = new JList(this.chosenCircLM);
        this.availableCircJL.addListSelectionListener(this);
        this.chosenCircJL.addListSelectionListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        cc.anchor = 21;
        cc.gridwidth = 3;
        cc.fill = 2;
        cc.weightx = 1.0;
        this.getContentPane().add((Component)pannelloComandi, cc);
        cc.gridx = 0;
        cc.gridy = 1;
        cc.anchor = 10;
        cc.gridwidth = 1;
        cc.fill = 0;
        cc.weightx = 0.0;
        cc.ipady = 10;
        this.getContentPane().add((Component)new JLabel(Language.string("Circuiti disponibili")), cc);
        cc.gridx = 2;
        this.getContentPane().add((Component)new JLabel(Language.string("Circuiti Chrome")), cc);
        cc.ipady = 0;
        cc.gridx = 0;
        cc.gridy = 2;
        cc.gridheight = 4;
        cc.fill = 1;
        cc.weightx = 0.5;
        cc.weighty = 0.5;
        this.getContentPane().add((Component)new JScrollPane(this.availableCircJL, 22, 30), cc);
        cc.gridx = 2;
        cc.weightx = 0.5;
        JScrollPane pannelloDx = new JScrollPane(this.chosenCircJL, 22, 30);
        pannelloDx.setPreferredSize(new Dimension(100, 200));
        this.getContentPane().add((Component)pannelloDx, cc);
        cc.gridx = 1;
        cc.gridheight = 1;
        cc.fill = 2;
        cc.weightx = 0.0;
        cc.weighty = 0.5;
        cc.ipadx = 40;
        cc.anchor = 20;
        JButton b = new JButton(this.addA);
        b.setHideActionText(true);
        this.getContentPane().add((Component)b, cc);
        cc.gridy = 3;
        cc.anchor = 19;
        b = new JButton(this.removeA);
        b.setHideActionText(true);
        this.getContentPane().add((Component)b, cc);
        cc.gridy = 4;
        cc.anchor = 20;
        b = new JButton(this.upA);
        b.setHideActionText(true);
        this.getContentPane().add((Component)b, cc);
        cc.gridy = 5;
        cc.anchor = 19;
        b = new JButton(this.downA);
        b.setHideActionText(true);
        this.getContentPane().add((Component)b, cc);
        this.pack();
        File f = new File("./defaultCircuits.cir");
        this.apriLibreria(f);
        this.setSize(new Dimension(700, 450));
    }

    public JPanel costruisciPannelloCom() {
        this.sceltaCOM = new JComboBox();
        this.sceltaCOM.setFocusable(false);
        this.connettiB = new JButton(Language.string("Connetti"));
        this.connettiB.addActionListener(this);
        this.sceltaCOM.setMinimumSize(new Dimension(120, 25));
        this.sceltaCOM.setPreferredSize(new Dimension(120, 25));
        this.sceltaCOM.setMaximumSize(new Dimension(120, 25));
        this.connettiB.setMinimumSize(new Dimension(80, 25));
        this.connettiB.setMaximumSize(new Dimension(80, 25));
        this.connettiB.setFocusable(false);
        this.comLabel = new JLabel(Language.string("Scegli la porta su cui \u00e8 connesso il Chrome/Datalog:"));
        this.comLabel.setForeground(Color.white);
        JPanel pannelloConnessione = new JPanel();
        pannelloConnessione.add(this.comLabel);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.sceltaCOM);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.connettiB);
        pannelloConnessione.setBackground(Color.gray);
        this.comLabel.setEnabled(true);
        this.connettiB.setEnabled(true);
        this.sceltaCOM.setEnabled(true);
        return pannelloConnessione;
    }

    public JPanel costruisciPannelloBottoni() {
        this.importaB = new JButton(Language.string("Importa File"));
        this.importaB.addActionListener(this);
        this.esportaB = new JButton(Language.string("Esporta File"));
        this.esportaB.addActionListener(this);
        this.esportaB.setEnabled(false);
        this.trasmettiWifiB = new JButton(Language.string("Invia WiFi"));
        this.trasmettiWifiB.addActionListener(this);
        this.trasmettiWifiB.setEnabled(false);
        this.riceviWifiB = new JButton(Language.string("Ricevi WiFi"));
        this.riceviWifiB.addActionListener(this);
        this.importaUsbB = new JButton(Language.string("Ricevi Usb"));
        this.importaUsbB.addActionListener(this);
        this.esportaUsbB = new JButton(Language.string("Invia Usb"));
        this.esportaUsbB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.importaB);
        pannelloBottoni.add(this.esportaB);
        pannelloBottoni.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloBottoni.add(this.riceviWifiB);
        pannelloBottoni.add(this.trasmettiWifiB);
        pannelloBottoni.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloBottoni.add(this.importaUsbB);
        pannelloBottoni.add(this.esportaUsbB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        return pannelloBottoni;
    }

    public void aggiornaPorteCom() {
        if (this.elencoCom != null) {
            for (int i = 0; i < this.elencoCom.length; ++i) {
                this.sceltaCOM.addItem(this.elencoCom[i]);
            }
            if (this.elencoCom.length > 0) {
                this.sceltaCOM.setSelectedIndex(0);
            }
        }
    }

    public void connetti() {
        if (this.connected) {
            return;
        }
        if (this.sceltaCOM.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(null, Language.string("Selezionare una porta"), Language.string("Attenzione"), 2);
            return;
        }
        this.sceltaCOM.setEnabled(false);
        try {
            this.conn = new SerialConnection(this.elencoCom[this.sceltaCOM.getSelectedIndex()]);
            this.conn.open(1);
            this.conn.clear();
            this.conn.setTimeOut(1000);
            this.connected = true;
            this.conn.write("Ready\r");
            System.out.println("SCritto ready");
            String end = this.conn.readLine();
            if (end == null || !end.startsWith("Ready")) {
                try {
                    this.conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sceltaCOM.setEnabled(true);
                this.connected = false;
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return;
            }
            this.connettiB.setText(Language.string("Disconnetti"));
            this.abilitaUsb(true);
            if (this.chosenCircLM.getSize() < 20) {
                this.esportaUsbB.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sceltaCOM.setEnabled(true);
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
        }
    }

    public void disconnetti() {
        if (!this.connected) {
            return;
        }
        try {
            this.connected = false;
            this.conn.clear(1000);
            while (this.conn.readLine() != null) {
            }
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sceltaCOM.setEnabled(true);
            System.out.println("DEBUG: Chiusa connessione USB");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connettiB.setText(Language.string("Connetti"));
        this.abilitaUsb(false);
    }

    public void abilitaUsb(boolean abilita) {
        this.importaUsbB.setEnabled(abilita);
        this.esportaUsbB.setEnabled(abilita);
    }

    public void doOpen() {
        this.availableCircJL.removeAll();
        int res = this.fileChooser.showOpenDialog(this);
        if (res == 0) {
            File f = this.fileChooser.getSelectedFile();
            try {
                f.setReadable(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                this.availableCircJL.clearSelection();
                this.chosenCircJL.clearSelection();
                this.availableCircLM.clear();
                Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("T,") || line.startsWith("t,")) {
                        ultimoCircuito = new Circuit(line);
                        this.availableCircLM.addElement(ultimoCircuito);
                    }
                    if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                    ultimoCircuito.aggiungiSplit(line);
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean verificaCircuiti(File f) {
        int numeroSplit = 0;
        boolean valido = true;
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    numeroSplit = 0;
                    if (!ultimoCircuito.versoValido(line)) {
                        valido = false;
                    }
                }
                if (!line.startsWith("S,") && !line.startsWith("s,") || ++numeroSplit >= 4 || ultimoCircuito.versoValido(line)) continue;
                valido = false;
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return valido;
    }

    public void apriLibreria(File f) {
        int numeroSplit = 0;
        Circuit c = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
        if (!this.verificaCircuiti(f)) {
            JOptionPane.showMessageDialog(DanasDataStructure.getInstance().getMainFrame(), Language.string("Alcuni traguardi non hanno il verso di attraversamento impostato: NON verranno quindi caricati."), Language.string("ATTENZIONE"), 0);
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            this.availableCircJL.clearSelection();
            this.chosenCircJL.clearSelection();
            this.availableCircLM.clear();
            Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
            while ((line = in.readLine()) != null) {
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    numeroSplit = 0;
                    if (c.versoValido(line)) {
                        ultimoCircuito = new Circuit(line);
                        this.availableCircLM.addElement(ultimoCircuito);
                    } else {
                        ultimoCircuito = null;
                    }
                }
                if (!line.startsWith("S,") && !line.startsWith("s,") || ultimoCircuito == null || ++numeroSplit >= 4) continue;
                if (c.versoValido(line)) {
                    ultimoCircuito.aggiungiSplit(line);
                    continue;
                }
                this.availableCircLM.removeElement(ultimoCircuito);
                ultimoCircuito = null;
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void doSaveas() {
        this.fileChooser.setFileSelectionMode(1);
        int res = this.fileChooser.showSaveDialog(this);
        if (res == 0) {
            File f = new File(this.fileChooser.getSelectedFile().toString(), "circuitiInOut.ccr");
            if (!f.isAbsolute()) {
                f = new File(f.getAbsolutePath());
            }
            if (f.exists() && f.canWrite()) {
                int resultSovrascrivo = JOptionPane.showConfirmDialog(this, Language.string("Sovrascrivere il file esistente?"), Language.string("ATTENZIONE"), 0);
                if (resultSovrascrivo == -1 || resultSovrascrivo == 1) {
                    return;
                }
            } else if (f.exists() || !f.getParentFile().exists() || !f.getParentFile().isDirectory() || !f.getParentFile().canWrite()) {
                JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
                return;
            }
            try {
                PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
                this.availableCircJL.clearSelection();
                this.chosenCircJL.clearSelection();
                for (int i = 0; i < this.chosenCircLM.size(); ++i) {
                    Circuit c = (Circuit)this.chosenCircLM.elementAt(i);
                    out.println(c.getChromeString());
                }
                out.close();
                JOptionPane.showMessageDialog(this, Language.string("Libreria circuitiInOut creata correttamente."), Language.string("INFO"), 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Percorso non valido"), Language.string("ATTENZIONE"), 0);
                ex.printStackTrace();
            }
        }
    }

    public void doReceive() {
        new Thread(){

            @Override
            public void run() {
                ChromeCircuitDialogUsb.this.receiveCircuits();
            }
        }.start();
    }

    public void doSend() {
        new Thread(){

            @Override
            public void run() {
                ChromeCircuitDialogUsb.this.sendCircuits();
            }
        }.start();
    }

    private void sendCircuits() {
        Vector<String> elenco = new Vector<String>();
        elenco.clear();
        this.availableCircJL.clearSelection();
        this.chosenCircJL.clearSelection();
        for (int i = 0; i < this.chosenCircLM.size(); ++i) {
            Circuit c = (Circuit)this.chosenCircLM.elementAt(i);
            elenco.add(c.getChromeString());
            System.out.println("invia:Circuito:" + c.getChromeString());
        }
        WifiDialog wifi = DanasDataStructure.getInstance().getMainFrame().getWifiDialog();
        boolean res = wifi.inviacircuiti(elenco);
        if (!res) {
            JOptionPane.showMessageDialog(null, Language.string("Invio non riuscito"), Language.string("ATTENZIONE"), 0);
        } else {
            this.receiveCircuits();
        }
    }

    public boolean inviacircuitiUsb(Vector<String> elenco) {
        try {
            this.conn.write("$CircuitiInizio\r");
            for (int i = 0; i < elenco.size(); ++i) {
                this.conn.writeVeloce("$Circuito:" + elenco.get(i) + "\r");
                System.out.println("circuito out:" + elenco.get(i));
            }
            this.conn.write("$CircuitiFine\r");
        }
        catch (Exception e1) {
            this.disconnetti();
            return false;
        }
        return true;
    }

    public void trasmettiUsb() {
        Vector<String> elenco = new Vector<String>();
        elenco.clear();
        this.availableCircJL.clearSelection();
        this.chosenCircJL.clearSelection();
        for (int i = 0; i < this.chosenCircLM.size(); ++i) {
            Circuit c = (Circuit)this.chosenCircLM.elementAt(i);
            elenco.add(c.getChromeString());
            System.out.println("invia:Circuito:" + c.getChromeString());
        }
        boolean res = this.inviacircuitiUsb(elenco);
        if (!res) {
            JOptionPane.showMessageDialog(null, Language.string("Invio non riuscito"), Language.string("ATTENZIONE"), 0);
        } else {
            this.riceviUsb();
        }
    }

    public Vector<String> scaricaCircuitiUsb() {
        Vector<String> circuitiRicevuti = new Vector<String>();
        try {
            String line;
            this.conn.write("$Traguardi\r");
            System.out.println("Scritto: $Traguardi");
            while ((line = this.conn.readLine()) != null && !line.startsWith("$FineTraguardi")) {
                circuitiRicevuti.add(line);
                System.out.println("linea file:" + line);
            }
            if (line == null) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile ricevere i dati. Problemi di connessione"));
            }
        }
        catch (IOException e1) {
            this.disconnetti();
            JOptionPane.showMessageDialog(this, Language.string("Impossibile ricevere i dati. Problemi di connessione"));
            return circuitiRicevuti;
        }
        return circuitiRicevuti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void riceviUsb() {
        this.availableCircJL.clearSelection();
        this.chosenCircJL.clearSelection();
        this.chosenCircLM.clear();
        this.setEnabled(false);
        this.setFocusableWindowState(true);
        try {
            Thread.sleep(200L);
            Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
            Vector<String> circuitiRicevuti = this.scaricaCircuitiUsb();
            System.out.println("Numero circuiti ricevuti:" + circuitiRicevuti.size() + " dimensione lista:" + this.chosenCircLM.size());
            for (int i = 0; i < circuitiRicevuti.size(); ++i) {
                String line = circuitiRicevuti.get(i);
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    ultimoCircuito = new Circuit(line);
                    this.chosenCircLM.addElement(ultimoCircuito);
                    Thread.sleep(20L);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ultimoCircuito.aggiungiSplit(line);
            }
            if (this.chosenCircLM.size() < 20) {
                this.esportaUsbB.setEnabled(false);
            } else {
                this.esportaB.setEnabled(true);
            }
            this.trasmettiWifiB.setEnabled(true);
            System.out.println("Dimensione lista caricata:" + this.chosenCircLM.size());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Language.string("Impossibile ricevere i dati. Problemi di connessione"));
        }
        finally {
            this.setEnabled(true);
            this.setFocusableWindowState(true);
            this.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveCircuits() {
        this.availableCircJL.clearSelection();
        this.chosenCircJL.clearSelection();
        this.chosenCircLM.clear();
        this.setEnabled(false);
        this.setFocusableWindowState(true);
        try {
            Thread.sleep(200L);
            Circuit ultimoCircuito = new Circuit("t,01,LIBERO  ,0000.0001,N,00000.0001,E,000,1,,,,");
            WifiDialog wifi = DanasDataStructure.getInstance().getMainFrame().getWifiDialog();
            Vector<String> circuitiRicevuti = wifi.scaricaCircuiti();
            System.out.println("Numero circuiti ricevuti:" + circuitiRicevuti.size() + " dimensione lista:" + this.chosenCircLM.size());
            for (int i = 0; i < circuitiRicevuti.size(); ++i) {
                String line = circuitiRicevuti.get(i);
                if (line.startsWith("T,") || line.startsWith("t,")) {
                    ultimoCircuito = new Circuit(line);
                    this.chosenCircLM.addElement(ultimoCircuito);
                    Thread.sleep(20L);
                }
                if (!line.startsWith("S,") && !line.startsWith("s,")) continue;
                ultimoCircuito.aggiungiSplit(line);
            }
            this.esportaB.setEnabled(true);
            this.trasmettiWifiB.setEnabled(true);
            if (this.connected) {
                this.esportaUsbB.setEnabled(true);
            }
            System.out.println("Dimensione lista caricata:" + this.chosenCircLM.size());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Language.string("Impossibile ricevere i dati. Problemi di connessione"));
        }
        finally {
            this.setEnabled(true);
            this.setFocusableWindowState(true);
            this.requestFocus();
        }
    }

    public void doAdd() {
        boolean salta = false;
        Object[] circs = this.availableCircJL.getSelectedValues();
        for (int i = 0; i < circs.length; ++i) {
            salta = false;
            for (int j = 0; j < this.chosenCircLM.size(); ++j) {
                if (this.chosenCircLM.get(j) != circs[i]) continue;
                salta = true;
            }
            if (this.chosenCircLM.size() >= 20) continue;
            if (!salta) {
                this.chosenCircLM.addElement(circs[i]);
            }
            if (this.chosenCircLM.size() < 20) continue;
            this.addA.setEnabled(false);
        }
        this.availableCircJL.clearSelection();
        if (this.chosenCircLM.getSize() == 20) {
            this.esportaB.setEnabled(true);
            this.trasmettiWifiB.setEnabled(true);
            if (this.connected) {
                this.esportaUsbB.setEnabled(true);
            }
        }
    }

    public void doRemove() {
        int[] selIndexes = this.chosenCircJL.getSelectedIndices();
        for (int i = selIndexes.length - 1; i >= 0; --i) {
            this.chosenCircLM.remove(selIndexes[i]);
        }
        this.chosenCircJL.clearSelection();
        if (this.chosenCircLM.getSize() < 20) {
            this.esportaB.setEnabled(false);
            this.trasmettiWifiB.setEnabled(false);
            this.esportaUsbB.setEnabled(false);
        } else {
            this.esportaB.setEnabled(true);
            this.trasmettiWifiB.setEnabled(true);
            if (this.connected) {
                this.esportaUsbB.setEnabled(true);
            }
        }
        if (this.chosenCircLM.size() < 20) {
            this.addA.setEnabled(true);
        }
    }

    public void doUp() {
        int[] selIndexes = this.chosenCircJL.getSelectedIndices();
        if (selIndexes.length != 1) {
            return;
        }
        int selIndex = selIndexes[0];
        if (selIndex == 0) {
            return;
        }
        Object selValue = this.chosenCircLM.remove(selIndex);
        this.chosenCircLM.add(selIndex - 1, selValue);
        this.chosenCircJL.setSelectedIndex(selIndex - 1);
    }

    public void doDown() {
        int[] selIndexes = this.chosenCircJL.getSelectedIndices();
        if (selIndexes.length != 1) {
            return;
        }
        int selIndex = selIndexes[0];
        if (selIndex == this.chosenCircLM.getSize() - 1) {
            return;
        }
        Object selValue = this.chosenCircLM.remove(selIndex);
        this.chosenCircLM.add(selIndex + 1, selValue);
        this.chosenCircJL.setSelectedIndex(selIndex + 1);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.chosenCircJL && this.chosenCircJL.getSelectedIndex() != -1) {
            this.availableCircJL.clearSelection();
        } else if (e.getSource() == this.availableCircJL && this.availableCircJL.getSelectedIndex() != -1) {
            this.chosenCircJL.clearSelection();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.connettiB)) {
            if (this.connected) {
                this.disconnetti();
            } else {
                this.connetti();
            }
        }
        if (e.getSource().equals(this.importaB)) {
            this.doOpen();
        }
        if (e.getSource().equals(this.esportaB)) {
            this.doSaveas();
        }
        if (e.getSource().equals(this.trasmettiWifiB)) {
            if (!DanasDataStructure.getInstance().getMainFrame().isWifiOpen()) {
                JOptionPane.showMessageDialog(null, Language.string("Impossibile trasmettere: finestra download wifi chiusa"), Language.string("ATTENZIONE"), 0);
                return;
            }
            if (!DanasDataStructure.getInstance().getMainFrame().getWifiDialog().isConnesso()) {
                JOptionPane.showMessageDialog(null, Language.string("Impossibile trasmettere: nessun Chrome attualmente connesso"), Language.string("ATTENZIONE"), 0);
                return;
            }
            this.doSend();
        }
        if (e.getSource().equals(this.riceviWifiB)) {
            if (!DanasDataStructure.getInstance().getMainFrame().isWifiOpen()) {
                JOptionPane.showMessageDialog(null, Language.string("Impossibile ricevere: finestra download wifi chiusa"), Language.string("ATTENZIONE"), 0);
                return;
            }
            if (!DanasDataStructure.getInstance().getMainFrame().getWifiDialog().isConnesso()) {
                JOptionPane.showMessageDialog(null, Language.string("Impossibile ricevere: nessun Chrome attualmente connesso"), Language.string("ATTENZIONE"), 0);
                return;
            }
            this.doReceive();
        }
        if (e.getSource().equals(this.importaUsbB)) {
            if (!this.connected) {
                return;
            }
            this.riceviUsb();
        }
        if (e.getSource().equals(this.esportaUsbB)) {
            if (!this.connected) {
                return;
            }
            this.trasmettiUsb();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.connected) {
            this.disconnetti();
        }
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] portNames = SerialConnection.getAvailablePorts().toArray(new String[0]);
        System.out.println("Numero porte=" + portNames.length);
        ChromeCircuitDialogUsb test = new ChromeCircuitDialogUsb(null, portNames);
        test.setLocationRelativeTo(null);
        test.setVisible(true);
    }

    abstract class MyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        MyAction(String name, String shortDesc, String imgFileName) {
            this.setName(name);
            this.setDescription(shortDesc);
            this.setImage(imgFileName);
        }

        void setName(String name) {
            this.putValue("Name", name);
        }

        void setDescription(String shortDesc) {
            this.putValue("ShortDescription", shortDesc);
        }

        void setImage(String imgFileName) {
            if (imgFileName != null) {
                this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource(imgFileName)));
            }
        }
    }
}

