/*
 * Decompiled with CFR 0.152.
 */
package i2m.mappa;

import java.math.BigDecimal;
import java.util.Vector;

public class TrigService {
    private Vector<BigDecimal> _cosFactors;
    private int _precision;

    public TrigService(int precision) {
        this._precision = precision;
        this._cosFactors = new Vector();
        BigDecimal one = new BigDecimal(1.0);
        BigDecimal stopWhen = one.movePointLeft(precision + 5);
        BigDecimal divWith = new BigDecimal(2.0);
        BigDecimal inc = new BigDecimal(2.0);
        BigDecimal factor = null;
        do {
            factor = one.divide(divWith, precision + 5, 4);
            this._cosFactors.add(factor);
            inc = inc.add(one);
            divWith = divWith.multiply(inc);
            inc = inc.add(one);
            divWith = divWith.multiply(inc);
        } while (factor.compareTo(stopWhen) > 0);
    }

    public BigDecimal cos(BigDecimal x) {
        BigDecimal res = new BigDecimal(1.0);
        BigDecimal xn = x.multiply(x);
        for (int i = 0; i < this._cosFactors.size(); ++i) {
            BigDecimal factor = this._cosFactors.get(i);
            factor = factor.multiply(xn);
            if (i % 2 == 0) {
                factor = factor.negate();
            }
            res = res.add(factor);
            xn = xn.multiply(x);
            xn = xn.multiply(x);
            xn = xn.setScale(this._precision + 5, 4);
        }
        return res.setScale(this._precision, 4);
    }
}

