/*
 * Decompiled with CFR 0.152.
 */
package i2m.mappa;

import i2m.mappa.Mappa2D;
import java.awt.Color;
import java.awt.Font;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;

public class TrattinoCurva
extends GObject {
    double x;
    double y;
    double inizioX;
    double inizioY;
    double fineX;
    double fineY;
    long angolo;
    int[] i;
    int[] f;
    GSegment segmento;
    Color colore;
    GScene scene;
    GText text;

    public TrattinoCurva(double x0, double y0, long angoloPista, boolean inizio, int numero) {
        this.x = x0;
        this.y = y0;
        this.colore = inizio ? Color.GREEN : Color.ORANGE;
        this.angolo = angoloPista + 90L;
        GStyle stile = new GStyle();
        stile.setBackgroundColor(null);
        stile.setForegroundColor(this.colore);
        if (inizio) {
            stile.setLineWidth(4);
        } else {
            stile.setLineWidth(2);
        }
        this.segmento = new GSegment();
        this.segmento.setStyle(stile);
        double angoloRad = this.angolo;
        angoloRad = angoloRad * Math.PI / 180.0;
        this.inizioX = this.x - 0.3 * Mappa2D.dimensioneTraguardo * Math.cos(angoloRad);
        this.inizioY = this.y - 0.3 * Mappa2D.dimensioneTraguardo * Math.sin(angoloRad);
        this.fineX = this.x + 0.3 * Mappa2D.dimensioneTraguardo * Math.cos(angoloRad);
        this.fineY = this.y + 0.3 * Mappa2D.dimensioneTraguardo * Math.sin(angoloRad);
        GStyle textStyle = new GStyle();
        textStyle.setForegroundColor(this.colore);
        textStyle.setBackgroundColor(null);
        Font fontCarattere = new Font("Dialog", 0, 10);
        textStyle.setFont(fontCarattere);
        this.text = new GText(String.format("%d", numero), 8);
        this.text.setStyle(textStyle);
        if (inizio) {
            this.segmento.setText(this.text);
        }
        this.addSegment(this.segmento);
    }

    public void setScene(GScene scena) {
        this.scene = scena;
    }

    @Override
    public void draw() {
        if (this.scene == null) {
            return;
        }
        this.i = this.scene.getTransformer().worldToDevice(this.inizioX, this.inizioY);
        this.f = this.scene.getTransformer().worldToDevice(this.fineX, this.fineY);
        int[] d = this.scene.getTransformer().worldToDevice(this.fineX + Mappa2D.dimensioneTraguardo, this.fineY + Mappa2D.dimensioneTraguardo);
        int larghezza = 1;
        larghezza = d[0] - this.f[0] != 0 ? d[0] - this.f[0] : d[1] - this.f[1];
        if (larghezza < 0) {
            larghezza = -larghezza;
        }
        if (this.angolo != -1L) {
            this.segmento.setGeometry(this.i[0], this.i[1], this.f[0], this.f[1]);
        }
    }
}

