/*
 * Decompiled with CFR 0.152.
 */
package i2m.mappa;

import i2m.DataStructure.danasDataStructure.ArrayDouble;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.mappa.Mappa2D;
import java.awt.Color;
import java.util.Arrays;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;

public class Serpentello
extends GObject {
    GSegment segmento;
    GStyle lineStyle;
    double[] x;
    double[] y;
    double[] selezioneX;
    double[] selezioneY;
    boolean vuoto = true;
    boolean mostraSelezione = false;
    int spessore;
    Color colore = Color.white;

    public Serpentello() {
        this.lineStyle = new GStyle();
        this.lineStyle.setForegroundColor(this.colore);
        this.lineStyle.setBackgroundColor(null);
        this.lineStyle.setLineWidth(Mappa2D.spessoreLinea + 10);
        this.segmento = new GSegment();
        this.segmento.setStyle(this.lineStyle);
        this.addSegment(this.segmento);
    }

    public void aggiornaDati() {
        boolean sessioni = DanasDataStructure.getInstance().getMainFrame().isGraficoSessioni();
        if (sessioni) {
            this.vuoto = true;
            DanasSession s = DanasDataStructure.getInstance().getDefaultSession();
            if (s == null) {
                return;
            }
            ArrayDouble gpsLon = s.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
            ArrayDouble gpsLat = s.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
            if (gpsLon == null || gpsLat == null) {
                return;
            }
            int dimensione = gpsLon.size();
            if (dimensione <= 0) {
                return;
            }
            this.vuoto = false;
            this.x = new double[dimensione];
            this.y = new double[dimensione];
            this.selezioneX = new double[dimensione];
            this.selezioneY = new double[dimensione];
            for (int i = 0; i < dimensione; ++i) {
                this.y[i] = gpsLat.get(i);
                this.x[i] = gpsLon.get(i);
                this.x[i] = Mappa2D.convertiX(this.x[i], this.y[i]);
                this.selezioneX[i] = this.x[i];
                this.selezioneY[i] = this.y[i];
            }
            this.lineStyle.setForegroundColor(new Color(s.getColor().getRed(), s.getColor().getGreen(), s.getColor().getBlue(), 220));
            this.lineStyle.setLineWidth(Mappa2D.spessoreLinea + 10);
            this.segmento.setStyle(this.lineStyle);
        } else {
            this.vuoto = true;
            DanasLap l = DanasDataStructure.getInstance().getDefaultLap();
            if (l == null) {
                return;
            }
            DanasSession s = l.getSession();
            ArrayDouble gpsLon = s.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
            ArrayDouble gpsLat = s.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
            int indiceStart = s.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
            int indiceStop = s.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, l.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
            int dimensione = indiceStop - indiceStart;
            if (dimensione <= 0) {
                return;
            }
            this.vuoto = false;
            this.x = new double[dimensione];
            this.y = new double[dimensione];
            this.selezioneX = new double[dimensione];
            this.selezioneY = new double[dimensione];
            for (int i = 0; i < dimensione; ++i) {
                this.y[i] = gpsLat.get(i + indiceStart);
                this.x[i] = gpsLon.get(i + indiceStart);
                this.x[i] = Mappa2D.convertiX(this.x[i], this.y[i]);
                this.selezioneX[i] = this.x[i];
                this.selezioneY[i] = this.y[i];
            }
            this.lineStyle.setForegroundColor(new Color(l.getColor().getRed(), l.getColor().getGreen(), l.getColor().getBlue(), 220));
            this.lineStyle.setLineWidth(Mappa2D.spessoreLinea + 10);
            this.segmento.setStyle(this.lineStyle);
        }
        this.addSegment(this.segmento);
    }

    public void estraiParte(double startTime, double stopTime) {
        DanasDataStructure dati;
        boolean sessioni;
        if (this.vuoto) {
            return;
        }
        this.mostraSelezione = false;
        if (startTime < 0.0) {
            startTime = 0.0;
        }
        if (stopTime < 0.0) {
            stopTime = 0.0;
        }
        if (sessioni = (dati = DanasDataStructure.getInstance()).getMainFrame().isGraficoSessioni()) {
            DanasSession sess = dati.getDefaultSession();
            if (DanasDataStructure.getInstance().getMainFrame().getModoSpazio()) {
                startTime = sess.getTimeAtSpazio(startTime, DanasDataStructureConstants.BoundLap.NEAREST) - sess.getStartTelemetryTime();
                stopTime = sess.getTimeAtSpazio(stopTime, DanasDataStructureConstants.BoundLap.NEAREST) - sess.getStartTelemetryTime();
            }
            double tempoSessione = sess.getEndTelemetryTime() - sess.getStartTelemetryTime();
            double tempoIniziale = sess.getStartTelemetryTime();
            if (startTime > tempoSessione) {
                startTime = tempoSessione;
            }
            if (stopTime > tempoSessione) {
                stopTime = tempoSessione;
            }
            if (stopTime <= startTime) {
                this.selezioneX = new double[0];
                this.selezioneY = new double[0];
                this.draw();
                return;
            }
            int indiceStart = sess.getIndiceAtTime(DanasDataStructureConstants.ValueType.LAT, startTime + tempoIniziale, DanasDataStructureConstants.BoundLap.NEAREST);
            int indiceStop = sess.getIndiceAtTime(DanasDataStructureConstants.ValueType.LAT, stopTime + tempoIniziale, DanasDataStructureConstants.BoundLap.NEAREST);
            if (indiceStart >= this.x.length) {
                indiceStart = this.x.length - 1;
            }
            if (indiceStop >= this.x.length) {
                indiceStop = this.x.length - 1;
            }
            this.selezioneX = Arrays.copyOfRange(this.x, indiceStart, indiceStop);
            this.selezioneY = Arrays.copyOfRange(this.y, indiceStart, indiceStop);
        } else {
            DanasLap l = dati.getDefaultLap();
            DanasSession sess = l.getSession();
            double tempoSessioneStart = startTime + l.getStart();
            double tempoSessioneStop = stopTime + l.getStart();
            if (DanasDataStructure.getInstance().getMainFrame().getModoSpazio()) {
                tempoSessioneStart = sess.getTimeAtSpazio(startTime + sess.getSpazioAtTime(l.getStart(), DanasDataStructureConstants.BoundLap.NEAREST), DanasDataStructureConstants.BoundLap.NEAREST);
                tempoSessioneStop = sess.getTimeAtSpazio(stopTime + sess.getSpazioAtTime(l.getStart(), DanasDataStructureConstants.BoundLap.NEAREST), DanasDataStructureConstants.BoundLap.NEAREST);
            }
            double tempoUltimoPunto = l.getTempoFineGps();
            double tempoPrimoPunto = l.getTempoInizioGps();
            if (tempoSessioneStop > tempoUltimoPunto) {
                tempoSessioneStop = tempoUltimoPunto;
            }
            if (tempoSessioneStart < tempoPrimoPunto) {
                tempoSessioneStart = tempoPrimoPunto;
            }
            if (tempoSessioneStart >= tempoSessioneStop) {
                this.selezioneX = new double[1];
                this.selezioneX[0] = this.x[0];
                this.selezioneY = new double[1];
                this.selezioneY[0] = this.y[0];
                this.draw();
                return;
            }
            int indiceInizio = sess.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, l.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
            int indiceStart = sess.getIndiceAtTime(DanasDataStructureConstants.ValueType.LAT, tempoSessioneStart, DanasDataStructureConstants.BoundLap.NEAREST);
            int indiceStop = sess.getIndiceAtTime(DanasDataStructureConstants.ValueType.LAT, tempoSessioneStop, DanasDataStructureConstants.BoundLap.NEAREST);
            this.selezioneX = Arrays.copyOfRange(this.x, indiceStart - indiceInizio, indiceStop - indiceInizio);
            this.selezioneY = Arrays.copyOfRange(this.y, indiceStart - indiceInizio, indiceStop - indiceInizio);
        }
        this.mostraSelezione = true;
    }

    @Override
    public void draw() {
        if (this.vuoto) {
            this.removeSegment(this.segmento);
        }
        if (!this.mostraSelezione) {
            this.removeSegment(this.segmento);
        } else {
            this.addSegment(this.segmento);
            this.segmento.setGeometry(this.selezioneX, this.selezioneY);
        }
    }
}

