/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;

public class Interpolatore {

    public static class Complex {
        private final double re;
        private final double im;

        public Complex(double real, double imag) {
            this.re = real;
            this.im = imag;
        }

        public String toString() {
            if (this.im == 0.0) {
                return this.re + "";
            }
            if (this.re == 0.0) {
                return this.im + "i";
            }
            if (this.im < 0.0) {
                return this.re + " - " + -this.im + "i";
            }
            return this.re + " + " + this.im + "i";
        }

        public double abs() {
            return Math.hypot(this.re, this.im);
        }

        public double phase() {
            return Math.atan2(this.im, this.re);
        }

        public Complex plus(Complex b) {
            Complex a = this;
            double real = a.re + b.re;
            double imag = a.im + b.im;
            return new Complex(real, imag);
        }

        public Complex minus(Complex b) {
            Complex a = this;
            double real = a.re - b.re;
            double imag = a.im - b.im;
            return new Complex(real, imag);
        }

        public Complex times(Complex b) {
            Complex a = this;
            double real = a.re * b.re - a.im * b.im;
            double imag = a.re * b.im + a.im * b.re;
            return new Complex(real, imag);
        }

        public Complex times(double alpha) {
            return new Complex(alpha * this.re, alpha * this.im);
        }

        public Complex conjugate() {
            return new Complex(this.re, -this.im);
        }

        public Complex reciprocal() {
            double scale = this.re * this.re + this.im * this.im;
            return new Complex(this.re / scale, -this.im / scale);
        }

        public double re() {
            return this.re;
        }

        public double im() {
            return this.im;
        }

        public Complex divides(Complex b) {
            Complex a = this;
            return a.times(b.reciprocal());
        }

        public Complex exp() {
            return new Complex(Math.exp(this.re) * Math.cos(this.im), Math.exp(this.re) * Math.sin(this.im));
        }

        public Complex sin() {
            return new Complex(Math.sin(this.re) * Math.cosh(this.im), Math.cos(this.re) * Math.sinh(this.im));
        }

        public Complex cos() {
            return new Complex(Math.cos(this.re) * Math.cosh(this.im), -Math.sin(this.re) * Math.sinh(this.im));
        }

        public Complex tan() {
            return this.sin().divides(this.cos());
        }

        public static Complex plus(Complex a, Complex b) {
            double real = a.re + b.re;
            double imag = a.im + b.im;
            Complex sum = new Complex(real, imag);
            return sum;
        }

        public static double log2(int n) {
            return Math.log(n) / Math.log(2.0);
        }

        public static double[] absFFT(double[] in) {
            int i;
            int i2;
            double[] dati;
            double[] out = new double[in.length];
            double logaritmo = Complex.log2(in.length);
            int base2 = (int)logaritmo;
            if ((double)base2 != logaritmo) {
                dati = new double[(int)Math.pow(2.0, base2 + 1)];
                for (i2 = 0; i2 < in.length; ++i2) {
                    dati[i2] = in[i2];
                }
                for (i2 = in.length; i2 < dati.length; ++i2) {
                    dati[i2] = 0.0;
                }
            } else {
                dati = in;
            }
            double[] datiFinestrati = new double[dati.length];
            block8: for (i2 = 0; i2 < dati.length; ++i2) {
                switch (DanasDataStructure.getInstance().getMainFrame().getFftFinestra()) {
                    case 0: {
                        datiFinestrati[i2] = dati[i2];
                        continue block8;
                    }
                    case 1: {
                        datiFinestrati[i2] = 0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)i2 / (double)dati.length) * dati[i2];
                        continue block8;
                    }
                    case 2: {
                        datiFinestrati[i2] = 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i2 / (double)dati.length) * dati[i2];
                        continue block8;
                    }
                    case 3: {
                        if (i2 <= dati.length / 2) {
                            datiFinestrati[i2] = Math.abs((double)i2 / ((double)dati.length / 2.0)) * dati[i2];
                            continue block8;
                        }
                        datiFinestrati[i2] = Math.abs((double)(i2 - dati.length) / ((double)dati.length / 2.0)) * dati[i2];
                        continue block8;
                    }
                    default: {
                        datiFinestrati[i2] = dati[i2];
                    }
                }
            }
            Complex[] x = new Complex[datiFinestrati.length];
            for (int i3 = 0; i3 < x.length; ++i3) {
                x[i3] = new Complex(datiFinestrati[i3], 0.0);
            }
            Complex[] y = Complex.fft(x);
            for (i = 0; i < out.length; ++i) {
                out[i] = y[i].abs() / (double)out.length;
            }
            if (!DanasDataStructure.getInstance().getMainFrame().getFftAmpiezza()) {
                for (i = 0; i < out.length; ++i) {
                    out[i] = Math.pow(out[i], 2.0);
                }
            }
            if (!DanasDataStructure.getInstance().getMainFrame().getFftLineare()) {
                for (i = 0; i < out.length; ++i) {
                    out[i] = !DanasDataStructure.getInstance().getMainFrame().getFftAmpiezza() ? 10.0 * Math.log10(out[i]) : 20.0 * Math.log10(out[i]);
                }
            }
            return out;
        }

        public static double[] interpola(double[] in, double fattoreInterpolazione, int numeroDecimali) {
            int i;
            double[] dati;
            double[] out = new double[(int)((double)in.length * fattoreInterpolazione)];
            double logaritmo = Complex.log2(in.length);
            int base2 = (int)logaritmo;
            if ((double)base2 != logaritmo) {
                int i2;
                dati = new double[(int)Math.pow(2.0, base2 + 1)];
                for (i2 = 0; i2 < in.length; ++i2) {
                    dati[i2] = in[i2];
                }
                for (i2 = in.length; i2 < dati.length; ++i2) {
                    dati[i2] = 0.0;
                }
            } else {
                dati = in;
            }
            Complex[] x = new Complex[dati.length];
            for (int i3 = 0; i3 < x.length; ++i3) {
                x[i3] = new Complex(dati[i3], 0.0);
            }
            Complex[] y = Complex.fft(x);
            int numeroZeri = (int)((double)x.length * (fattoreInterpolazione - 1.0));
            Complex[] yZeri = new Complex[(int)((double)x.length * fattoreInterpolazione)];
            for (i = 0; i < x.length / 2; ++i) {
                yZeri[i] = y[i];
            }
            for (i = 0; i < numeroZeri; ++i) {
                yZeri[i + x.length / 2] = new Complex(0.0, 0.0);
            }
            for (i = 0; i < x.length / 2; ++i) {
                yZeri[yZeri.length - x.length / 2 + i] = y[x.length / 2 + i];
            }
            Complex[] z = Complex.ifft(yZeri);
            double potenza = Math.pow(10.0, numeroDecimali);
            for (int i4 = 0; i4 < out.length; ++i4) {
                out[i4] = fattoreInterpolazione * (double)Math.round(z[i4].re * potenza) / potenza;
            }
            return out;
        }

        public static Complex[] fft(Complex[] x) {
            int N = x.length;
            if (N == 1) {
                return new Complex[]{x[0]};
            }
            if (N % 2 != 0) {
                throw new RuntimeException("N is not a power of 2");
            }
            Complex[] even = new Complex[N / 2];
            for (int k = 0; k < N / 2; ++k) {
                even[k] = x[2 * k];
            }
            Complex[] q = Complex.fft(even);
            Complex[] odd = even;
            for (int k = 0; k < N / 2; ++k) {
                odd[k] = x[2 * k + 1];
            }
            Complex[] r = Complex.fft(odd);
            Complex[] y = new Complex[N];
            for (int k = 0; k < N / 2; ++k) {
                double kth = (double)(-2 * k) * Math.PI / (double)N;
                Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
                y[k] = q[k].plus(wk.times(r[k]));
                y[k + N / 2] = q[k].minus(wk.times(r[k]));
            }
            return y;
        }

        public static Complex[] ifft(Complex[] x) {
            int i;
            int N = x.length;
            Complex[] y = new Complex[N];
            for (i = 0; i < N; ++i) {
                y[i] = x[i].conjugate();
            }
            y = Complex.fft(y);
            for (i = 0; i < N; ++i) {
                y[i] = y[i].conjugate();
            }
            for (i = 0; i < N; ++i) {
                y[i] = y[i].times(1.0 / (double)N);
            }
            return y;
        }

        public static void show(Complex[] x, String title) {
            System.out.println(title);
            for (int i = 0; i < x.length; ++i) {
                System.out.println(x[i]);
            }
            System.out.println();
        }

        public static void main(String[] args) {
            int N = 8;
            double[] dati = new double[N];
            for (int i = 0; i < N; ++i) {
                dati[i] = i;
            }
            Complex.interpola(dati, 2.0, 1);
        }
    }
}

