/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.Dialog.GraficoXYDialog;
import i2m.grafico.CurvaXY;
import i2m.mappa.Legenda;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GInteraction;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;
import no.geosoft.cc.graphics.GText;
import no.geosoft.cc.graphics.GWindow;

public class GraficoXY
implements GInteraction,
MouseWheelListener,
ChangeListener,
ComponentListener {
    public static final int larghezzaGrigliaX = 100;
    public static final int larghezzaGrigliaY = 75;
    public static final int larghezzaAsse = 55;
    public static final int ZOOM_WINDOW = 2;
    public static final int ZOOM_IN = 3;
    public static final int ZOOM_OUT = 4;
    public static final int MUOVI = 5;
    public static final int CURSORE = 7;
    public static final int TRASLA = 8;
    public static final int CURSORE_2 = 9;
    public static final int ASSE_TEMPO = 0;
    public static final int ASSE_SPAZIO = 1;
    public static final int STILE_NORMALE = 1;
    public static final int STILE_PUNTINI = 3;
    public static final int STILE_TRATTEGGIO = 2;
    public static final int STILE_ALTERNATO = 4;
    private int mode = 5;
    private int tipoAsse = 1;
    private Color coloreSfondo = new Color(0.95f, 0.95f, 0.95f, 1.0f);
    private GWindow window;
    private Component canvas;
    private GScene sceneTop;
    private GScene sceneBack;
    private GScene sceneDati;
    private Insets bordo;
    private Cornice corniceGrafico;
    private SfondoGrafico sfondo;
    private Griglia grid;
    private Assi axes;
    private GObject selezione;
    private boolean bloccaX = false;
    private boolean bloccaY = false;
    private boolean bloccaMargini = false;
    private int x0;
    private int y0;
    private boolean modoSpazio = false;
    private Vector<MarkerMassimoMinimo> elencoMassimiMinimi = new Vector();
    boolean bloccaSincro = false;
    Thread zoomThread = null;
    boolean visibile = true;
    double minZ;
    double maxZ;
    private Legenda legendaColore;
    boolean mostraLegenda = true;
    double minimoZ = 0.0;
    double massimoZ = 100.0;
    double minAsseY = 0.0;
    double maxAsseY = 100.0;
    double minAsseX = 0.0;
    double maxAsseX = 100.0;
    boolean traslazioneInCorso = false;
    boolean modificheAbilitate = true;
    GraficoXYDialog dialog;
    int Xzoom = 0;
    int Yzoom = 0;
    int notchesZoom = 0;
    boolean zoomBufferPieno = false;
    int bufferZoomValue = 0;
    int bufferZoomNotches = 0;
    double minimoRpm = 0.0;
    double massimoRpm = 14000.0;
    double minimoVel = 0.0;
    double massimoVel = 250.0;

    public GraficoXY(GraficoXYDialog diag) {
        this.dialog = diag;
        this.window = new GWindow(this.coloreSfondo);
        this.sceneBack = new GScene(this.window);
        this.sceneDati = new GScene(this.window);
        this.sceneTop = new GScene(this.window);
        this.sceneDati.setVisibility(240);
        this.canvas = this.window.getCanvas();
        this.canvas.addComponentListener(this);
        this.canvas.addMouseWheelListener(this);
        this.sceneTop.setWorldExtent(0.0, 0.0, 10.0, 10.0);
        this.sceneBack.setWorldExtent(0.0, 0.0, 10.0, 10.0);
        this.sceneDati.setWorldExtent(0.0, 0.0, 10.0, 10.0);
        this.bordo = new Insets(8, 5, 25, 5);
        this.corniceGrafico = new Cornice();
        this.corniceGrafico.toFront();
        this.sfondo = new SfondoGrafico();
        this.grid = new Griglia();
        this.axes = new Assi();
        this.selezione = new GObject();
        GStyle selezioneStyle = new GStyle();
        selezioneStyle.setLineStyle(new float[]{10.0f, 10.0f});
        selezioneStyle.setForegroundColor(Color.WHITE);
        selezioneStyle.setBackgroundColor(new Color(0.4f, 0.4f, 0.4f, 0.2f));
        this.selezione.setStyle(selezioneStyle);
        this.selezione.toFront();
        this.legendaColore = new Legenda(this.sceneTop);
        this.sceneTop.add(this.legendaColore);
        this.legendaColore.setOffsetOrizzontale(this.bordo.left + 5);
        this.sceneBack.add(this.sfondo);
        this.sceneTop.add(this.corniceGrafico);
        this.sceneTop.add(this.axes);
        this.sceneTop.add(this.selezione);
        this.sceneTop.toFront();
        this.window.startInteraction(this);
        this.setMargini(5, 25, 55, 5);
        this.setScenaVisibile(true);
        this.setGrigliaOrizzontale(true);
        this.setGriliaVerticale(true);
        this.mostraAssi(true);
    }

    public void setGraficoMarce() {
        this.setLegenda(false);
        this.setGrigliaOrizzontale(true);
        this.setGriliaVerticale(true);
    }

    public void setMargini(int top, int bottom, int left, int right) {
        this.bordo.left = left;
        this.bordo.right = right;
        this.bordo.top = top;
        this.bordo.bottom = bottom;
    }

    public void refreshAssi() {
        this.axes.redraw();
    }

    public void setEstremiMarce(double minX, double maxX, double minY, double maxY) {
        this.minimoRpm = minX;
        this.massimoRpm = maxX;
        this.minimoVel = minY;
        this.massimoVel = maxY;
        this.setAsseY(this.minimoVel, this.massimoVel, false, false);
        this.setAsseX(this.minimoRpm, this.massimoRpm, true, false);
    }

    public void mostraAssi(boolean mostra) {
        this.mostraAsse(mostra);
        if (mostra) {
            this.setMargini(5, 25, 55, 5);
        } else {
            this.setMargini(0, 0, 0, 0);
        }
        if (this.legendaColore != null) {
            this.legendaColore.setOffsetOrizzontale(this.bordo.left + 5);
        }
    }

    public void abilitaModifiche(boolean abilita) {
        this.modificheAbilitate = abilita;
    }

    public void setLegenda(boolean mostra) {
        if (this.mostraLegenda == mostra) {
            return;
        }
        this.mostraLegenda = mostra;
        if (mostra) {
            this.sceneTop.add(this.legendaColore);
        } else {
            this.sceneTop.remove(this.legendaColore);
        }
    }

    public double getMinimoRpm() {
        return this.minimoRpm;
    }

    public double getMassimoRpm() {
        return this.massimoRpm;
    }

    public void setMargineLeft(int left) {
        this.bordo.left = left;
    }

    public void setBloccaMargini(boolean blocca) {
        this.bloccaMargini = blocca;
    }

    public boolean getBloccaMargini() {
        return this.bloccaMargini;
    }

    public Component getGrafico() {
        return this.window.getCanvas();
    }

    public void setBackgroundColor(Color colore) {
        this.sfondo.setColor(colore);
        this.sceneBack.redraw();
        this.sceneBack.refresh();
    }

    public void aggiungiCurvaXY(CurvaXY curve) {
        this.sceneDati.add(curve);
    }

    public void rimuoviCurvaXY(String nome) {
        CurvaXY c;
        int i;
        int num = this.sceneDati.getNChildren();
        for (i = 0; i < num; ++i) {
            c = (CurvaXY)this.sceneDati.getChild(i);
            if (!c.getNome().equals(nome)) continue;
            this.sceneDati.remove(c);
            break;
        }
        num = this.sceneDati.getNChildren();
        for (i = 0; i < num; ++i) {
            c = (CurvaXY)this.sceneDati.getChild(i);
            if (!c.getNome().equals(nome)) continue;
            this.sceneDati.remove(c);
            System.out.println("ATTENZIONE: Tolto due volte la stessa curva!!");
            break;
        }
    }

    public void rimuoviTutto() {
        this.sceneDati.removeAll();
    }

    public void setAsseX(double min, double max, boolean refresh, boolean aggiornaEstremi) {
        double minimoDouble;
        if (max <= min) {
            return;
        }
        if (max - min < 1.0E-4) {
            return;
        }
        double[] w0 = this.sceneDati.getWorldExtent().get(0);
        double[] w1 = this.sceneDati.getWorldExtent().get(1);
        double[] w2 = this.sceneDati.getWorldExtent().get(2);
        int[] d0 = this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
        int[] d1 = this.sceneDati.getTransformer().worldToDevice(w1[0], w1[1]);
        int larghezzaIntera = d1[0] - d0[0];
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return;
        }
        double larghezzaDouble = (max - min) * (double)larghezzaIntera / (double)(larghezzaIntera - this.bordo.left - this.bordo.right);
        w0[0] = minimoDouble = min - larghezzaDouble * (double)this.bordo.left / (double)larghezzaIntera;
        w2[0] = minimoDouble;
        w1[0] = minimoDouble + larghezzaDouble;
        this.sceneDati.setWorldExtent(w0, w1, w2);
        this.sceneTop.setWorldExtent(w0, w1, w2);
        if (refresh) {
            this.refresh();
        }
        if (aggiornaEstremi) {
            this.aggiornaEstremiX();
        }
    }

    public void setAsseXY(double minX, double maxX, double minY, double maxY, boolean refresh, boolean aggiornaEstremi) {
        double minimoDoubleX;
        double minimoDoubleY;
        if (maxY <= minY) {
            return;
        }
        if (maxX <= minX) {
            return;
        }
        if (maxX - minX < 1.0E-4) {
            return;
        }
        if (maxY - minY < 1.0E-4) {
            return;
        }
        double[] w0 = this.sceneDati.getWorldExtent().get(0);
        double[] w1 = this.sceneDati.getWorldExtent().get(1);
        double[] w2 = this.sceneDati.getWorldExtent().get(2);
        int[] d0 = this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
        int[] d1 = this.sceneDati.getTransformer().worldToDevice(w1[0], w1[1]);
        int[] d2 = this.sceneDati.getTransformer().worldToDevice(w2[0], w2[1]);
        int altezzaInteraY = d0[1] - d2[1];
        if (altezzaInteraY <= this.bordo.top + this.bordo.bottom) {
            return;
        }
        double altezzaDoubleY = (maxY - minY) * (double)altezzaInteraY / ((double)altezzaInteraY - (double)this.bordo.top - (double)this.bordo.bottom);
        w0[1] = minimoDoubleY = minY - altezzaDoubleY * (double)this.bordo.bottom / (double)altezzaInteraY;
        w2[1] = minimoDoubleY + altezzaDoubleY;
        w1[1] = minimoDoubleY;
        int larghezzaInteraX = d1[0] - d0[0];
        if (larghezzaInteraX <= this.bordo.left + this.bordo.right) {
            return;
        }
        double larghezzaDoubleX = (maxX - minX) * (double)larghezzaInteraX / (double)(larghezzaInteraX - this.bordo.left - this.bordo.right);
        w0[0] = minimoDoubleX = minX - larghezzaDoubleX * (double)this.bordo.left / (double)larghezzaInteraX;
        w2[0] = minimoDoubleX;
        w1[0] = minimoDoubleX + larghezzaDoubleX;
        this.sceneDati.setWorldExtent(w0, w1, w2);
        this.sceneTop.setWorldExtent(w0, w1, w2);
        if (refresh) {
            this.refresh();
        }
        if (aggiornaEstremi) {
            this.aggiornaEstremiY();
        }
    }

    public void setAsseY(double min, double max, boolean refresh, boolean aggiornaEstremi) {
        double minimoDouble;
        int[] d2;
        if (max <= min) {
            return;
        }
        if (max - min < 1.0E-4) {
            return;
        }
        double[] w0 = this.sceneDati.getWorldExtent().get(0);
        double[] w1 = this.sceneDati.getWorldExtent().get(1);
        double[] w2 = this.sceneDati.getWorldExtent().get(2);
        int[] d0 = this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
        int altezzaIntera = d0[1] - (d2 = this.sceneDati.getTransformer().worldToDevice(w2[0], w2[1]))[1];
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return;
        }
        double altezzaDouble = (max - min) * (double)altezzaIntera / (double)(altezzaIntera - this.bordo.top - this.bordo.bottom);
        w0[1] = minimoDouble = min - altezzaDouble * (double)this.bordo.bottom / (double)altezzaIntera;
        w2[1] = minimoDouble + altezzaDouble;
        w1[1] = minimoDouble;
        this.sceneDati.setWorldExtent(w0, w1, w2);
        this.sceneTop.setWorldExtent(w0, w1, w2);
        if (refresh) {
            this.refresh();
        }
        if (aggiornaEstremi) {
            this.aggiornaEstremiY();
        }
    }

    public int getWidth() {
        return this.window.getWidth();
    }

    public int getHeight() {
        return this.window.getHeight();
    }

    public double[] getAsseX() {
        double[] asse = new double[]{0.0, 0.0};
        double[] w0 = this.sceneTop.getWorldExtent().get(0);
        double[] w1 = this.sceneTop.getWorldExtent().get(1);
        int[] d0 = this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
        int[] d1 = this.sceneTop.getTransformer().worldToDevice(w1[0], w1[1]);
        int larghezzaIntera = d1[0] - d0[0];
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return asse;
        }
        double larghezzaDouble = w1[0] - w0[0];
        double minimoDouble = larghezzaDouble * (double)this.bordo.left / (double)larghezzaIntera;
        asse[0] = w0[0] + minimoDouble;
        asse[1] = asse[0] + ((double)larghezzaIntera - (double)this.bordo.left - (double)this.bordo.right) * larghezzaDouble / (double)larghezzaIntera;
        return asse;
    }

    public double[] getAsseY() {
        int[] d2;
        double[] asse = new double[]{0.0, 0.0};
        double[] w0 = this.sceneDati.getWorldExtent().get(0);
        double[] w2 = this.sceneDati.getWorldExtent().get(2);
        int[] d0 = this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
        int altezzaIntera = d0[1] - (d2 = this.sceneDati.getTransformer().worldToDevice(w2[0], w2[1]))[1];
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return asse;
        }
        double altezzaDouble = w2[1] - w0[1];
        double minimoDouble = altezzaDouble * (double)this.bordo.bottom / (double)altezzaIntera;
        asse[0] = w0[1] + minimoDouble;
        asse[1] = asse[0] + (double)(altezzaIntera - this.bordo.top - this.bordo.bottom) * altezzaDouble / (double)altezzaIntera;
        return asse;
    }

    public double[] getAsseZ() {
        double[] asse = new double[]{0.0, 100.0};
        asse[0] = this.minimoZ;
        asse[1] = this.massimoZ;
        return asse;
    }

    public void setAsseZ(double min, double max, boolean aggiornaEstremi) {
        this.legendaColore.setValoreMinimo(Float.valueOf((float)min));
        this.legendaColore.setValoreMassimo(Float.valueOf((float)max));
        this.minimoZ = min;
        this.massimoZ = max;
        if (aggiornaEstremi) {
            this.aggiornaEstremiZ();
        }
        if (this.sceneDati.getNChildren() == 0) {
            return;
        }
        ((CurvaXY)this.sceneDati.getChild(0)).setMinZ(min);
        ((CurvaXY)this.sceneDati.getChild(0)).setMaxZ(max);
    }

    public int getNumeroDivisioniX() {
        int x0 = this.sceneTop.getViewport().getX0();
        int x1 = this.sceneTop.getViewport().getX1();
        int larghezzaIntera = x1 - x0;
        if (larghezzaIntera <= this.bordo.left + this.bordo.right) {
            return 1;
        }
        int res = (larghezzaIntera - this.bordo.left - this.bordo.right) / 100;
        if (res != 0) {
            return (larghezzaIntera - this.bordo.left - this.bordo.right) / 100;
        }
        return 1;
    }

    public int getNumeroDivisioniY(GScene scenaTemp) {
        int y0 = scenaTemp.getViewport().getY0();
        int y2 = scenaTemp.getViewport().getY2();
        int altezzaIntera = y2 - y0;
        if (altezzaIntera <= this.bordo.top + this.bordo.bottom) {
            return 1;
        }
        int res = (altezzaIntera - this.bordo.top - this.bordo.bottom) / 75;
        if (res != 0) {
            return (altezzaIntera - this.bordo.top - this.bordo.bottom) / 75;
        }
        return 1;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int modo) {
        this.mode = modo;
    }

    private void zoomPoint(int x, int y, double zoom) {
        this.myZoom(x, y, zoom, this.sceneDati);
        this.myZoom(x, y, zoom, this.sceneTop);
        this.refresh();
    }

    private void myPan(int dx, int dy, GScene scena) {
        int x0 = scena.getViewport().getX0() - dx;
        int y0 = scena.getViewport().getY0() - dy;
        int x1 = scena.getViewport().getX3() - dx;
        int y1 = scena.getViewport().getY3() - dy;
        this.myZoom(x0, y0, x1, y1, scena);
    }

    private void myZoom(int x, int y, double zoomFactor, GScene scena) {
        int x0 = scena.getViewport().getX0();
        int y0 = scena.getViewport().getY0();
        int x1 = scena.getViewport().getX3();
        int y1 = scena.getViewport().getY3();
        if (!this.bloccaX) {
            x0 = (int)((double)x0 + (1.0 - zoomFactor) * (double)(x - x0));
            x1 = (int)((double)x1 - (1.0 - zoomFactor) * (double)(x1 - x));
        }
        if (!this.bloccaY) {
            y0 = (int)((double)y0 + (1.0 - zoomFactor) * (double)(y - y0));
            y1 = (int)((double)y1 - (1.0 - zoomFactor) * (double)(y1 - y));
        }
        double[] w0 = scena.getTransformer().deviceToWorld(x0, y1);
        double[] w1 = scena.getTransformer().deviceToWorld(x1, y1);
        double[] w2 = scena.getTransformer().deviceToWorld(x0, y0);
        scena.setWorldExtent(w0, w1, w2);
    }

    private void myZoom(int x0, int y0, int x1, int y1, GScene scena) {
        int temp;
        int y1Out;
        int y0Out;
        int x1Out;
        int x0Out;
        int x0In = scena.getViewport().getX0();
        int y0In = scena.getViewport().getY0();
        int x1In = scena.getViewport().getX3();
        int y1In = scena.getViewport().getY3();
        if (this.bloccaX) {
            x0Out = x0In;
            x1Out = x1In;
        } else {
            x0Out = x0;
            x1Out = x1;
        }
        if (this.bloccaY) {
            y0Out = y0In;
            y1Out = y1In;
        } else {
            y0Out = y0;
            y1Out = y1;
        }
        if (x1 < x0) {
            temp = x0Out;
            x0Out = x1Out;
            x1Out = temp;
        }
        if (y1 < y0) {
            temp = y0Out;
            y0Out = y1Out;
            y1Out = temp;
        }
        double[] w0 = scena.getTransformer().deviceToWorld(x0Out, y1Out);
        double[] w1 = scena.getTransformer().deviceToWorld(x1Out, y1Out);
        double[] w2 = scena.getTransformer().deviceToWorld(x0Out, y0Out);
        scena.setWorldExtent(w0, w1, w2);
    }

    private void zoomWindow(int x1, int y1, int x2, int y2) {
        if (x1 != x2 && y1 != y2) {
            this.myZoom(x1, y1, x2, y2, this.sceneDati);
            this.myZoom(x1, y1, x2, y2, this.sceneTop);
            this.refresh();
        }
    }

    public void aggiornaEstremiTutti() {
        this.aggiornaEstremiX();
        this.aggiornaEstremiY();
        this.aggiornaEstremiZ();
    }

    public void aggiornaEstremiX() {
        double[] asseX = this.getAsseX();
        double min = Math.rint(asseX[0] * 100.0) / 100.0;
        double max = Math.rint(asseX[1] * 100.0) / 100.0;
        if (this.dialog != null) {
            this.dialog.aggiornaValoriX(min, max);
        }
    }

    public void aggiornaEstremiY() {
        double[] asseY = this.getAsseY();
        double min = Math.rint(asseY[0] * 100.0) / 100.0;
        double max = Math.rint(asseY[1] * 100.0) / 100.0;
        if (this.dialog != null) {
            this.dialog.aggiornaValoriY(min, max);
        }
    }

    public void aggiornaEstremiZ() {
        double[] asseZ = this.getAsseZ();
        double min = Math.rint(asseZ[0] * 100.0) / 100.0;
        double max = Math.rint(asseZ[1] * 100.0) / 100.0;
        this.legendaColore.setValoreMinimo(Float.valueOf((float)min));
        this.legendaColore.setValoreMassimo(Float.valueOf((float)max));
        if (this.dialog != null) {
            this.dialog.aggiornaValoriZ(min, max);
        }
    }

    public synchronized void refresh() {
        try {
            if (this.sceneDati.getNChildren() != 0) {
                int num = this.sceneDati.getNChildren();
                for (int i = 0; i < num; ++i) {
                    ((CurvaXY)this.sceneDati.getChild(i)).abilitaDisegno(true);
                }
            }
            this.window.redraw();
            this.window.refresh();
        }
        catch (Exception e) {
            System.out.println("Errore nel refresh iniziale XY");
        }
    }

    public void setSottocampionatura(int riduzione) {
        if (this.dialog == null) {
            return;
        }
        if (this.sceneDati.getNChildren() != 0) {
            CurvaXY c = (CurvaXY)this.sceneDati.getChild(0);
            this.sceneDati.removeAll();
            this.sceneDati.redraw();
            c.sottocampiona(riduzione);
            this.sceneDati.add(c);
        }
    }

    public void setBloccaX(boolean blocca) {
        this.bloccaX = blocca;
    }

    public void setBloccaY(boolean blocca) {
        this.bloccaY = blocca;
    }

    public static String stampaValoreAsse(Double valore) {
        String s = null;
        s = valore.toString();
        if (valore > 1000.0) {
            s = String.format("%.0f", valore);
        }
        if (valore >= 1000000.0) {
            s = String.format("%.1fM", valore / 1000000.0);
        }
        if (valore < -1000.0) {
            s = String.format("%.0f", valore);
        }
        if (valore <= -1000000.0) {
            s = String.format("%.1fM", valore / 1000000.0);
        }
        return s;
    }

    public static String stampaSpazioTempo(double valore, int tipo) {
        if (tipo == 0) {
            double positivo = Math.abs(valore);
            int ore = (int)(positivo / 360000.0);
            int minuti = (int)((positivo - (double)(ore * 360000)) / 6000.0);
            int secondi = (int)((positivo - (double)(minuti * 6000) - (double)(ore * 360000)) / 100.0);
            int centesimi = (int)(positivo - (double)(secondi * 100) - (double)(minuti * 6000) - (double)(ore * 360000));
            if (valore >= 0.0) {
                return String.format("%d:%02d:%02d.%02d", ore, minuti, secondi, centesimi);
            }
            return String.format("-%d:%02d:%02d.%02d", ore, minuti, secondi, centesimi);
        }
        return Double.valueOf(valore).toString();
    }

    private void setScenaVisibile(boolean visibile) {
        this.sceneDati.setVisibility(240);
        this.mostraAsse(false);
        if (visibile) {
            this.sceneDati.setVisibility(15);
            this.mostraAsse(true);
            double[] asse = this.getAsseX();
            this.setAsseX(asse[0], asse[1], false, true);
            this.sceneTop.add(this.grid);
        } else {
            this.sceneTop.remove(this.grid);
        }
    }

    public void mostraAsse(boolean mostra) {
        this.visibile = mostra;
        if (!this.bloccaMargini) {
            this.bordo.left = !mostra ? 0 : 55;
        }
    }

    public void ridisegnaSfondo() {
        this.sfondo.redraw();
    }

    public int getNumeroAssi() {
        return 1;
    }

    public void setAllInvisible() {
        this.sceneDati.setVisibility(240);
        this.sceneTop.remove(this.grid);
    }

    private double getDivisioneDouble(double min, double max, int numDivisioni) {
        double datoGrezzo = (max - min) / (double)numDivisioni;
        double logaritmo = Math.log10(datoGrezzo);
        int numeroZeri = logaritmo > 0.0 ? (int)logaritmo : (int)logaritmo - 1;
        double cifraSignificativa = datoGrezzo / Math.pow(10.0, numeroZeri);
        int cifraSignificativaIntera = (int)Math.round(cifraSignificativa);
        int matrice = 1;
        switch (cifraSignificativaIntera) {
            case 1: {
                matrice = 1;
                break;
            }
            case 2: 
            case 3: {
                matrice = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                matrice = 5;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                matrice = 10;
            }
        }
        double base = (double)matrice * Math.pow(10.0, numeroZeri);
        return base;
    }

    private double getNumeroPulito(double valore, double matrice) {
        int numeroZeri = Math.log10(matrice) > 0.0 ? (int)Math.abs(Math.log10(matrice)) : (int)Math.abs(Math.log10(matrice)) + 1;
        long arrotondamento = (long)(valore * Math.pow(10.0, numeroZeri));
        return (double)arrotondamento / Math.pow(10.0, numeroZeri);
    }

    public GScene getScene() {
        return this.sceneDati;
    }

    public void aggiungiMarkerMaxMin(double y, double spazio, double tempo, String scritta, Color colore, boolean mostra) {
        MarkerMassimoMinimo linea = new MarkerMassimoMinimo(y, spazio, tempo, scritta, colore, mostra);
        this.elencoMassimiMinimi.add(linea);
        this.sceneTop.add(linea);
    }

    public void rimuoviAllMarkerMaxMin() {
        if (this.elencoMassimiMinimi.size() == 0) {
            return;
        }
        for (int i = 0; i < this.elencoMassimiMinimi.size(); ++i) {
            this.sceneTop.remove(this.elencoMassimiMinimi.get(i));
            this.elencoMassimiMinimi.removeElement(this.elencoMassimiMinimi.get(i));
            --i;
        }
    }

    public void setGriliaVerticale(boolean attiva) {
        this.grid.setGrigliaVerticale(attiva);
    }

    public void setGrigliaOrizzontale(boolean attiva) {
        this.grid.setGrigliaOrizzontale(attiva);
    }

    public String getNomeAsse() {
        if (this.dialog == null) {
            return "Vel";
        }
        String s = this.dialog.getNomeY();
        if (s.length() > 4) {
            return s.substring(0, 4) + ".";
        }
        return s + ".";
    }

    public String getNomeAsseX() {
        if (this.dialog == null) {
            return "Rpm";
        }
        String s = this.dialog.getNomeX();
        if (s.length() > 4) {
            return s.substring(0, 4) + ".";
        }
        return s + ".";
    }

    public void zoomWheel() {
        if (this.notchesZoom < 0) {
            this.zoomPoint(this.Xzoom, this.Yzoom, 0.8);
        } else {
            this.zoomPoint(this.Xzoom, this.Yzoom, 1.2);
        }
        if (this.zoomBufferPieno) {
            if (this.bufferZoomNotches < 0) {
                this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(0.8, this.bufferZoomValue));
            } else {
                this.zoomPoint(this.Xzoom, this.Yzoom, Math.pow(1.2, this.bufferZoomValue));
            }
        }
        this.aggiornaEstremiTutti();
        this.zoomBufferPieno = false;
        this.bufferZoomValue = 0;
        this.bufferZoomNotches = 0;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (!this.modificheAbilitate) {
            return;
        }
        if (this.getMode() == 5 || this.getMode() == 4 || this.getMode() == 3 || this.getMode() == 2) {
            if (this.zoomThread == null || !this.zoomThread.isAlive()) {
                this.zoomBufferPieno = false;
                this.bufferZoomValue = 0;
                this.bufferZoomNotches = 0;
                this.notchesZoom = event.getWheelRotation();
                this.Xzoom = event.getX();
                this.Yzoom = event.getY();
                this.zoomThread = new Thread(){

                    @Override
                    public void run() {
                        GraficoXY.this.zoomWheel();
                    }
                };
                this.zoomThread.start();
            } else {
                this.bufferZoomNotches += event.getWheelRotation();
                ++this.bufferZoomValue;
                this.zoomBufferPieno = true;
            }
        }
    }

    @Override
    public void event(GScene scene, int event, int x, int y) {
        if (!this.modificheAbilitate) {
            return;
        }
        if (event == 13) {
            if (!this.traslazioneInCorso && this.dialog != null) {
                this.dialog.mostraPopup(x, y);
            }
            this.traslazioneInCorso = false;
        }
        block0 : switch (this.mode) {
            case 4: {
                if (event == 3) {
                    this.zoomPoint(x, y, 1.3);
                    this.aggiornaEstremiTutti();
                }
                switch (event) {
                    case 11: {
                        this.x0 = x;
                        this.y0 = y;
                        break;
                    }
                    case 12: {
                        this.traslazioneInCorso = true;
                        this.myPan(x - this.x0, y - this.y0, this.sceneDati);
                        this.myPan(x - this.x0, y - this.y0, this.sceneTop);
                        this.refresh();
                        this.aggiornaEstremiTutti();
                        this.x0 = x;
                        this.y0 = y;
                    }
                }
                break;
            }
            case 3: {
                if (event == 3) {
                    this.zoomPoint(x, y, 0.7);
                    this.aggiornaEstremiTutti();
                }
                switch (event) {
                    case 11: {
                        this.x0 = x;
                        this.y0 = y;
                        break;
                    }
                    case 12: {
                        this.traslazioneInCorso = true;
                        this.myPan(x - this.x0, y - this.y0, this.sceneDati);
                        this.myPan(x - this.x0, y - this.y0, this.sceneTop);
                        this.refresh();
                        this.aggiornaEstremiTutti();
                        this.x0 = x;
                        this.y0 = y;
                    }
                }
                break;
            }
            case 5: {
                switch (event) {
                    case 3: {
                        this.x0 = x;
                        this.y0 = y;
                        break;
                    }
                    case 4: {
                        this.myPan(x - this.x0, y - this.y0, this.sceneDati);
                        this.myPan(x - this.x0, y - this.y0, this.sceneTop);
                        this.refresh();
                        this.aggiornaEstremiTutti();
                        this.x0 = x;
                        this.y0 = y;
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        this.traslazioneInCorso = true;
                    }
                }
                break;
            }
            case 2: {
                switch (event) {
                    case 3: {
                        this.x0 = x;
                        this.y0 = y;
                        this.selezione.addSegment(new GSegment());
                        break;
                    }
                    case 5: {
                        this.selezione.removeSegments();
                        if (this.x0 < x) {
                            this.zoomWindow(this.x0 - 35, this.y0, x, y);
                        } else {
                            this.zoomWindow(this.x0, this.y0, x - 35, y);
                        }
                        this.aggiornaEstremiTutti();
                        break;
                    }
                    case 4: {
                        int[] xSelezione = new int[]{this.x0, x, x, this.x0, this.x0};
                        int[] ySelezione = new int[]{this.y0, this.y0, y, y, this.y0};
                        GSegment segmentoSelezione = this.selezione.getSegment();
                        segmentoSelezione.setGeometry(xSelezione, ySelezione);
                        scene.refresh();
                    }
                }
                switch (event) {
                    case 11: {
                        this.x0 = x;
                        this.y0 = y;
                        break block0;
                    }
                    case 12: {
                        this.traslazioneInCorso = true;
                        this.myPan(x - this.x0, y - this.y0, this.sceneDati);
                        this.myPan(x - this.x0, y - this.y0, this.sceneTop);
                        this.refresh();
                        this.aggiornaEstremiTutti();
                        this.x0 = x;
                        this.y0 = y;
                    }
                }
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.dialog == null) {
            this.setAsseY(this.minimoVel, this.massimoVel, false, false);
            this.setAsseX(this.minimoRpm, this.massimoRpm, true, false);
            return;
        }
        this.setAsseY(this.dialog.getMinY(), this.dialog.getMaxY(), false, true);
        this.setAsseX(this.dialog.getMinX(), this.dialog.getMaxX(), true, true);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public class Griglia
    extends GObject {
        GSegment segmento;
        GSegment trattino;
        double[] asseX;
        double[] asseY;
        double divisione;
        int numeroDivisioniX;
        int startX;
        int stopX;
        int numeroDivisioniY;
        int startY;
        int stopY;
        double asseXMoltiplicato;
        double asseYMoltiplicato;
        double minimo;
        double massimo;
        double numero;
        Insets margini;
        GStyle stile;
        GStyle stile2;
        GStyle stile3;
        GStyle stile4;
        GStyle textStyle;
        GStyle textStyle2;
        GText text;
        String s = "test1";
        boolean grigliaOrizzontale = true;
        boolean grigliaVerticale = true;

        public Griglia() {
            this.margini = GraficoXY.this.bordo;
            this.stile = new GStyle();
            this.stile.setBackgroundColor(null);
            this.stile.setLineWidth(1);
            this.stile.setLineStyle(3);
            this.stile.setForegroundColor(Color.GRAY);
            this.stile2 = new GStyle();
            this.stile2.setBackgroundColor(null);
            this.stile2.setLineWidth(1);
            this.stile2.setForegroundColor(Color.BLACK);
            this.stile3 = new GStyle();
            this.stile3.setBackgroundColor(null);
            this.stile3.setLineWidth(1);
            this.stile3.setForegroundColor(Color.GRAY);
            this.stile4 = new GStyle();
            this.stile4.setBackgroundColor(null);
            this.stile4.setLineWidth(1);
            this.stile4.setForegroundColor(null);
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(Color.BLACK);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.textStyle2 = new GStyle();
            this.textStyle2.setForegroundColor(Color.BLACK);
            this.textStyle2.setBackgroundColor(null);
            this.textStyle2.setFont(new Font("Dialog", 1, 12));
        }

        public void setGrigliaVerticale(boolean accesa) {
            this.grigliaVerticale = accesa;
        }

        public void setGrigliaOrizzontale(boolean accesa) {
            this.grigliaOrizzontale = accesa;
        }

        @Override
        public void draw() {
            int[] dg;
            this.asseX = GraficoXY.this.getAsseX();
            this.asseY = GraficoXY.this.getAsseY();
            this.numeroDivisioniX = GraficoXY.this.getNumeroDivisioniX();
            this.numeroDivisioniY = GraficoXY.this.getNumeroDivisioniY(GraficoXY.this.sceneDati);
            if (this.asseX[1] <= this.asseX[0] || this.asseY[1] <= this.asseY[0]) {
                return;
            }
            this.removeSegments();
            double[] w0 = GraficoXY.this.sceneDati.getWorldExtent().get(0);
            double[] w1 = GraficoXY.this.sceneDati.getWorldExtent().get(1);
            double[] w2 = GraficoXY.this.sceneDati.getWorldExtent().get(2);
            int[] d0 = GraficoXY.this.sceneDati.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d1 = GraficoXY.this.sceneDati.getTransformer().worldToDevice(w1[0], w1[1]);
            int[] d2 = GraficoXY.this.sceneDati.getTransformer().worldToDevice(w2[0], w2[1]);
            this.divisione = GraficoXY.this.getDivisioneDouble(this.asseX[0], this.asseX[1], this.numeroDivisioniX);
            this.minimo = this.asseX[0] / this.divisione;
            this.massimo = this.asseX[1] / this.divisione;
            this.startX = (int)this.minimo;
            this.stopX = (int)this.massimo;
            int i = 0;
            while ((double)(this.startX + i) < this.minimo) {
                ++i;
            }
            while ((double)(this.startX + i) <= this.massimo) {
                this.segmento = new GSegment();
                this.trattino = new GSegment();
                this.trattino.setStyle(this.stile2);
                this.segmento.setStyle(this.stile);
                if (this.grigliaVerticale) {
                    this.addSegment(this.segmento);
                }
                this.addSegment(this.trattino);
                this.numero = GraficoXY.this.getNumeroPulito((double)(this.startX + i) * this.divisione, this.divisione);
                if (this.numero == 0.0) {
                    this.segmento.setStyle(this.stile3);
                }
                dg = GraficoXY.this.sceneTop.getTransformer().worldToDevice(this.numero, w2[1]);
                this.segmento.setGeometry(dg[0], d0[1] - this.margini.bottom, dg[0], d2[1] + this.margini.top);
                this.trattino.setGeometry(dg[0], d0[1] - this.margini.bottom + 4, dg[0], d0[1] - this.margini.bottom);
                this.text = new GText(GraficoXY.stampaSpazioTempo(this.numero, GraficoXY.this.tipoAsse), 32784);
                this.text.setStyle(this.textStyle);
                this.trattino.setText(this.text);
                ++i;
            }
            this.segmento = new GSegment();
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + this.margini.left - 4, d2[1] + this.margini.top, d0[0] + this.margini.left, d2[1] + this.margini.top);
            this.segmento = new GSegment();
            this.segmento.setGeometry(d0[0] + this.margini.left - 4, d2[1] + this.margini.top + 6);
            this.segmento.setStyle(this.stile4);
            this.addSegment(this.segmento);
            this.text = new GText(GraficoXY.this.getNomeAsse(), 4104);
            this.text.setStyle(this.textStyle2);
            this.segmento.setText(this.text);
            this.divisione = GraficoXY.this.getDivisioneDouble(this.asseY[0], this.asseY[1], this.numeroDivisioniY);
            this.minimo = this.asseY[0] / this.divisione;
            this.massimo = this.asseY[1] / this.divisione;
            this.startY = (int)this.minimo;
            this.stopY = (int)this.massimo;
            i = 0;
            this.segmento = new GSegment();
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + this.margini.left, d0[1] - this.margini.bottom - 1, d1[0] - this.margini.right, d0[1] - this.margini.bottom - 1);
            while ((double)(this.startY + i) < this.minimo) {
                ++i;
            }
            while ((double)(this.startY + i) <= this.massimo) {
                this.segmento = new GSegment();
                this.trattino = new GSegment();
                this.trattino.setStyle(this.stile2);
                this.segmento.setStyle(this.stile);
                if (this.grigliaOrizzontale) {
                    this.addSegment(this.segmento);
                }
                this.addSegment(this.trattino);
                this.numero = GraficoXY.this.getNumeroPulito((double)(this.startY + i) * this.divisione, this.divisione);
                if (this.numero == 0.0) {
                    this.segmento.setStyle(this.stile3);
                }
                dg = GraficoXY.this.sceneDati.getTransformer().worldToDevice(w0[0], this.numero);
                this.segmento.setGeometry(d0[0] + this.margini.left, dg[1], d1[0] - this.margini.right, dg[1]);
                this.trattino.setGeometry(d0[0] + this.margini.left - 4, dg[1], d0[0] + this.margini.left, dg[1]);
                this.text = new GText(GraficoXY.stampaValoreAsse(this.numero), 4128);
                this.text.setStyle(this.textStyle);
                this.trattino.setText(this.text);
                ++i;
            }
        }
    }

    public class Assi
    extends GObject {
        GSegment segmento;
        GSegment trattino;
        double[] asseY;
        double divisione;
        int numeroDivisioniY;
        int startY;
        int stopY;
        double asseYMoltiplicato;
        double minimo;
        double massimo;
        double numero;
        Insets margini;
        GStyle stile2;
        GStyle stile3;
        GStyle textStyle;
        GStyle textStyle2;
        GText text;

        public Assi() {
            this.margini = GraficoXY.this.bordo;
            this.stile2 = new GStyle();
            this.stile2.setBackgroundColor(null);
            this.stile2.setLineWidth(1);
            this.stile2.setForegroundColor(Color.BLACK);
            this.stile3 = new GStyle();
            this.stile3.setBackgroundColor(null);
            this.stile3.setLineWidth(1);
            this.stile3.setForegroundColor(null);
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(Color.BLACK);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.textStyle2 = new GStyle();
            this.textStyle2.setForegroundColor(Color.BLACK);
            this.textStyle2.setBackgroundColor(null);
            this.textStyle2.setFont(new Font("Dialog", 1, 12));
        }

        @Override
        public void draw() {
            this.removeSegments();
            if (!GraficoXY.this.visibile) {
                return;
            }
            double[] w0 = GraficoXY.this.sceneTop.getWorldExtent().get(0);
            double[] w2 = GraficoXY.this.sceneTop.getWorldExtent().get(2);
            int[] d0 = GraficoXY.this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d2 = GraficoXY.this.sceneTop.getTransformer().worldToDevice(w2[0], w2[1]);
            this.asseY = GraficoXY.this.getAsseY();
            this.numeroDivisioniY = GraficoXY.this.getNumeroDivisioniY(GraficoXY.this.sceneDati);
            this.divisione = GraficoXY.this.getDivisioneDouble(this.asseY[0], this.asseY[1], this.numeroDivisioniY);
            this.minimo = 5.0 * this.asseY[0] / this.divisione;
            this.massimo = 5.0 * this.asseY[1] / this.divisione;
            this.startY = (int)this.minimo;
            this.stopY = (int)this.massimo;
            this.segmento = new GSegment();
            this.segmento.setStyle(this.stile2);
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + 55 - 4, d0[1] - this.margini.bottom, d0[0] + 55, d0[1] - this.margini.bottom);
            this.segmento = new GSegment();
            this.segmento.setStyle(this.stile2);
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + 55, d0[1] - this.margini.bottom, d0[0] + 55, d2[1] + this.margini.top);
            this.segmento = new GSegment();
            this.segmento.setStyle(this.stile2);
            this.addSegment(this.segmento);
            this.segmento.setGeometry(d0[0] + 55 - 4, d2[1] + this.margini.top, d0[0] + 55, d2[1] + this.margini.top);
            this.segmento = new GSegment();
            this.segmento.setGeometry(d0[0] + 55 - 4, d2[1] + this.margini.top + 6);
            this.addSegment(this.segmento);
            this.segmento.setStyle(this.stile3);
            this.text = new GText(GraficoXY.this.getNomeAsse(), 4352);
            this.text.setStyle(this.textStyle2);
            this.segmento.setText(this.text);
            this.segmento = new GSegment();
            if (GraficoXY.this.dialog != null) {
                this.segmento.setGeometry(d0[0] + 55 - 4, d2[1] + this.margini.top + 545);
            } else {
                this.segmento.setGeometry(d0[0] + 55 - 4, d2[1] + this.margini.top + 460);
            }
            this.addSegment(this.segmento);
            this.segmento.setStyle(this.stile3);
            this.text = new GText(GraficoXY.this.getNomeAsseX(), 4352);
            this.text.setStyle(this.textStyle2);
            this.segmento.setText(this.text);
            int i = 0;
            while ((double)(this.startY + i) < this.minimo) {
                ++i;
            }
            while ((double)(this.startY + i) <= this.massimo) {
                this.trattino = new GSegment();
                this.trattino.setStyle(this.stile2);
                this.addSegment(this.trattino);
                this.numero = GraficoXY.this.getNumeroPulito((double)(this.startY + i) * this.divisione / 5.0, this.divisione);
                int[] dg = GraficoXY.this.sceneDati.getTransformer().worldToDevice(w0[0], this.numero);
                this.text = new GText(GraficoXY.stampaValoreAsse(this.numero), 4128);
                this.text.setStyle(this.textStyle);
                if ((this.startY + i) % 5 == 0) {
                    this.trattino.setText(this.text);
                    this.trattino.setGeometry(d0[0] + 55 - 4, dg[1], d0[0] + 55, dg[1]);
                } else {
                    this.trattino.setGeometry(d0[0] + 55 - 2, dg[1], d0[0] + 55, dg[1]);
                }
                ++i;
            }
        }
    }

    public class Cornice
    extends GObject {
        GSegment segmentoSx;
        GSegment segmentoDx;
        GSegment segmentoUp;
        GSegment segmentoDn;
        Insets margini;

        public Cornice() {
            this.margini = GraficoXY.this.bordo;
            this.segmentoSx = new GSegment();
            this.segmentoDx = new GSegment();
            this.segmentoUp = new GSegment();
            this.segmentoDn = new GSegment();
            GStyle stile = new GStyle();
            stile.setBackgroundColor(new Color(0.9f, 0.9f, 0.9f, 1.0f));
            stile.setForegroundColor(new Color(0.9f, 0.9f, 0.9f, 1.0f));
            this.segmentoSx.setStyle(stile);
            this.segmentoDx.setStyle(stile);
            this.segmentoUp.setStyle(stile);
            this.segmentoDn.setStyle(stile);
            this.addSegment(this.segmentoSx);
            this.addSegment(this.segmentoDx);
            this.addSegment(this.segmentoUp);
            this.addSegment(this.segmentoDn);
        }

        @Override
        public void draw() {
            double[] w0 = GraficoXY.this.sceneTop.getWorldExtent().get(0);
            double[] w1 = GraficoXY.this.sceneTop.getWorldExtent().get(1);
            double[] w2 = GraficoXY.this.sceneTop.getWorldExtent().get(2);
            int[] d0 = GraficoXY.this.sceneTop.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d1 = GraficoXY.this.sceneTop.getTransformer().worldToDevice(w1[0], w1[1]);
            int[] d2 = GraficoXY.this.sceneTop.getTransformer().worldToDevice(w2[0], w2[1]);
            this.segmentoSx.setGeometry(Geometry.createRectangle(d0[0], d0[1], this.margini.left, d2[1] - d0[1]));
            this.segmentoDx.setGeometry(Geometry.createRectangle(d1[0] - this.margini.right, d0[1], this.margini.right, d2[1] - d0[1]));
            this.segmentoUp.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d2[1] + this.margini.top, d1[0] - d0[0] - this.margini.right - this.margini.left, -this.margini.top));
            this.segmentoDn.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d0[1], d1[0] - d0[0] - this.margini.right - this.margini.left, -this.margini.bottom));
        }
    }

    public class SfondoGrafico
    extends GObject {
        GSegment segmento;
        Insets margini;
        GStyle stile;

        public SfondoGrafico() {
            this.margini = GraficoXY.this.bordo;
            this.segmento = new GSegment();
            this.stile = new GStyle();
            this.stile.setBackgroundColor(Color.BLACK);
            this.stile.setForegroundColor(null);
            this.segmento.setStyle(this.stile);
            this.addSegment(this.segmento);
        }

        public void setColor(Color colore) {
            this.stile.setBackgroundColor(colore);
            this.draw();
        }

        @Override
        public void draw() {
            double[] w0 = GraficoXY.this.sceneBack.getWorldExtent().get(0);
            double[] w1 = GraficoXY.this.sceneBack.getWorldExtent().get(1);
            double[] w2 = GraficoXY.this.sceneBack.getWorldExtent().get(2);
            int[] d0 = GraficoXY.this.sceneBack.getTransformer().worldToDevice(w0[0], w0[1]);
            int[] d1 = GraficoXY.this.sceneBack.getTransformer().worldToDevice(w1[0], w1[1]);
            int[] d2 = GraficoXY.this.sceneBack.getTransformer().worldToDevice(w2[0], w2[1]);
            this.segmento.setStyle(this.stile);
            this.segmento.setGeometry(Geometry.createRectangle(d0[0] + this.margini.left, d0[1] - this.margini.bottom, d1[0] - d0[0] - this.margini.right - this.margini.left, d2[1] - d0[1] + this.margini.top + this.margini.bottom));
        }
    }

    public class MarkerMassimoMinimo
    extends GObject {
        GSegment segmento;
        GStyle markerStyle;
        double posizioneSpazio;
        double posizioneTempo;
        double posizioneY;
        GStyle textStyle;
        GText text;
        String Id;
        int raggio = 10;

        public MarkerMassimoMinimo(double y, double spazio, double tempo, String scritta, Color colore, boolean mostraScritta) {
            GStyle markerStyle = new GStyle();
            markerStyle.setForegroundColor(colore);
            markerStyle.setBackgroundColor(colore);
            markerStyle.setLineWidth(1);
            this.segmento = new GSegment();
            this.segmento.setStyle(markerStyle);
            this.addSegment(this.segmento);
            this.posizioneSpazio = spazio;
            this.posizioneTempo = tempo;
            this.posizioneY = y;
            this.textStyle = new GStyle();
            this.textStyle.setForegroundColor(colore);
            this.textStyle.setBackgroundColor(null);
            this.textStyle.setFont(new Font("Dialog", 0, 11));
            this.text = new GText(scritta, 32784);
            this.text.setStyle(this.textStyle);
            if (mostraScritta) {
                this.segmento.setText(this.text);
            }
        }

        @Override
        public void draw() {
            int[] w = GraficoXY.this.modoSpazio ? GraficoXY.this.sceneTop.getTransformer().worldToDevice(this.posizioneSpazio, this.posizioneY) : GraficoXY.this.sceneTop.getTransformer().worldToDevice(this.posizioneTempo, this.posizioneY);
            this.segmento.setGeometry(Geometry.createCircle(w[0], w[1], this.raggio));
        }
    }
}

