/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import java.awt.Color;
import java.util.Vector;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;

public class CurvaXY
extends GObject {
    private double[] x;
    private double[] y;
    private double[] v;
    private int raggio = 2;
    private Color coloreCurva;
    private int spessoreLinea = 1;
    private int stileLinea = 1;
    private GSegment segmento;
    private GStyle stile;
    private String nomeCurva;
    private double estremoMinZ;
    private double estremoMaxZ;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;
    private boolean usaAsseZ = true;
    boolean mostraPunti = true;
    private Vector<GSegment> elencoSegmentiPunti = new Vector();
    private Vector<GSegment> elencoSegmentiCerchi = new Vector();
    boolean drawAbilitato = false;
    int fattoreRiduzione = 10;
    boolean mostraCerchi = false;
    int cerchioSelezionato = -1;

    public CurvaXY() {
    }

    public CurvaXY(double[] asseX, double[] asseY, double[] asseZ, Color colore, String nome, int riduzione, boolean monocolore) {
        if (asseZ.length != asseX.length) {
            return;
        }
        this.fattoreRiduzione = riduzione;
        System.out.println("Creo Curva XY");
        this.x = asseX;
        this.y = asseY;
        this.v = asseZ;
        this.minX = Double.MAX_VALUE;
        this.maxX = Double.MIN_VALUE;
        this.minY = Double.MAX_VALUE;
        this.maxY = Double.MIN_VALUE;
        this.minZ = Double.MAX_VALUE;
        this.maxZ = Double.MIN_VALUE;
        for (int i = 0; i < this.v.length; ++i) {
            if (this.x[i] > this.maxX) {
                this.maxX = this.x[i];
            }
            if (this.x[i] < this.minX) {
                this.minX = this.x[i];
            }
            if (this.y[i] > this.maxY) {
                this.maxY = this.y[i];
            }
            if (this.y[i] < this.minY) {
                this.minY = this.y[i];
            }
            if (this.v[i] > this.maxZ) {
                this.maxZ = this.v[i];
            }
            if (!(this.v[i] < this.minZ)) continue;
            this.minZ = this.v[i];
        }
        this.estremoMinZ = this.minZ;
        this.estremoMaxZ = this.maxZ;
        this.coloreCurva = colore;
        this.nomeCurva = nome;
        this.segmento = new GSegment();
        this.addSegment(this.segmento);
        int j = 0;
        for (int i = 0; i < this.v.length; i += this.fattoreRiduzione) {
            this.elencoSegmentiPunti.add(new GSegment());
            this.addSegment(this.elencoSegmentiPunti.get(j));
            ++j;
        }
        this.stile = new GStyle();
        this.stile.setLineWidth(2);
        this.stile.setForegroundColor(this.coloreCurva);
        this.stile.setLineWidth(this.spessoreLinea);
        this.stile.setLineStyle(this.stileLinea);
        this.usaAsseZ = !monocolore;
        this.aggiornaColori();
    }

    public CurvaXY(double[] asseX, double[] asseY, Color colore, String nome) {
        this.fattoreRiduzione = 1;
        this.x = asseX;
        this.y = asseY;
        this.v = asseX;
        this.minX = this.x[0];
        this.maxX = this.x[1];
        this.minY = this.y[0];
        this.maxY = this.y[1];
        this.minZ = 0.0;
        this.maxZ = 1.0;
        this.estremoMinZ = this.minZ;
        this.estremoMaxZ = this.maxZ;
        this.coloreCurva = colore;
        this.nomeCurva = nome;
        this.mostraPunti = false;
        this.segmento = new GSegment();
        this.addSegment(this.segmento);
        this.stile = new GStyle();
        this.stile.setLineWidth(2);
        this.stile.setForegroundColor(this.coloreCurva);
        this.stile.setLineWidth(3);
        this.stile.setLineStyle(1);
        this.aggiornaColori();
    }

    public void mostraCerchi(boolean mostra) {
        this.mostraCerchi = mostra;
    }

    public void setCerchioSelezionato(int numero) {
        this.cerchioSelezionato = numero;
    }

    public void sottocampiona(int riduzione) {
        this.removeAll();
        this.fattoreRiduzione = riduzione;
        this.elencoSegmentiPunti.clear();
        int j = 0;
        for (int i = 0; i < this.v.length; i += riduzione) {
            this.elencoSegmentiPunti.add(new GSegment());
            this.addSegment(this.elencoSegmentiPunti.get(j));
            ++j;
        }
        this.aggiornaColori();
    }

    private void aggiornaColori() {
        float massimo = (float)this.estremoMaxZ;
        float minimo = (float)this.estremoMinZ;
        GStyle markerStyle = new GStyle();
        markerStyle.setForegroundColor(this.coloreCurva);
        markerStyle.setBackgroundColor(this.coloreCurva);
        markerStyle.setLineWidth(1);
        for (int j = 0; j < this.elencoSegmentiPunti.size(); ++j) {
            if (this.usaAsseZ) {
                GStyle stileSegmento = new GStyle();
                if (this.v[j * this.fattoreRiduzione] > (double)minimo && this.v[j * this.fattoreRiduzione] < (double)massimo) {
                    float rapporto = ((float)this.v[j * this.fattoreRiduzione] - minimo) / (massimo - minimo);
                    rapporto = 1.0f - rapporto;
                    stileSegmento.setForegroundColor(Color.getHSBColor(rapporto * 0.69f, 1.0f, 1.0f));
                    stileSegmento.setBackgroundColor(Color.getHSBColor(rapporto * 0.69f, 1.0f, 1.0f));
                }
                if (this.v[j * this.fattoreRiduzione] >= (double)massimo) {
                    stileSegmento.setForegroundColor(Color.getHSBColor(0.0f, 1.0f, 1.0f));
                    stileSegmento.setBackgroundColor(Color.getHSBColor(0.0f, 1.0f, 1.0f));
                }
                if (this.v[j * this.fattoreRiduzione] <= (double)minimo) {
                    stileSegmento.setForegroundColor(Color.getHSBColor(0.69f, 1.0f, 1.0f));
                    stileSegmento.setBackgroundColor(Color.getHSBColor(0.69f, 1.0f, 1.0f));
                }
                stileSegmento.setLineWidth(1);
                this.elencoSegmentiPunti.get(j).setStyle(stileSegmento);
                continue;
            }
            this.elencoSegmentiPunti.get(j).setStyle(markerStyle);
        }
    }

    public void setMaxZ(double massimo) {
        this.estremoMaxZ = (float)massimo;
        this.aggiornaColori();
        this.redraw();
    }

    public void setMinZ(double minimo) {
        this.estremoMinZ = (float)minimo;
        this.aggiornaColori();
        this.redraw();
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double[] getAsseX() {
        return this.x;
    }

    public double[] getAsseY() {
        return this.y;
    }

    public double[] getAsseValori() {
        return this.v;
    }

    public double getValoreY(int index) {
        if (this.y.length == 0) {
            return 0.0;
        }
        if (index < 0) {
            return this.y[0];
        }
        if (index >= this.y.length) {
            return this.y[this.y.length - 1];
        }
        return this.y[index];
    }

    public double getValoreX(int index) {
        if (this.x.length == 0) {
            return 0.0;
        }
        if (index < 0) {
            return this.x[0];
        }
        if (index >= this.x.length) {
            return this.x[this.x.length - 1];
        }
        return this.x[index];
    }

    public double getValoreZ(int index) {
        if (this.v.length == 0) {
            return 0.0;
        }
        if (index < 0) {
            return this.v[0];
        }
        if (index >= this.v.length) {
            return this.v[this.v.length - 1];
        }
        return this.v[index];
    }

    public void usaAsseZ(boolean usa) {
        this.usaAsseZ = usa;
        this.redraw();
    }

    public boolean getUsaAsseZ() {
        return this.usaAsseZ;
    }

    public void setSpessore(int spessore) {
        this.spessoreLinea = spessore;
        this.stile.setLineWidth(this.spessoreLinea);
    }

    public void setColore(Color nuovoColore) {
        this.coloreCurva = nuovoColore;
        this.stile.setForegroundColor(this.coloreCurva);
    }

    public Color getColore() {
        return this.coloreCurva;
    }

    public void setRaggio(int valoreRaggio) {
        this.raggio = valoreRaggio;
        this.redraw();
    }

    public int getRaggio() {
        return this.raggio;
    }

    public void setStile(int nuovoStile) {
        this.stileLinea = nuovoStile;
        this.stile.setLineStyle(this.stileLinea);
    }

    public String getNome() {
        return this.nomeCurva;
    }

    public int getLunghezza() {
        return this.x.length;
    }

    public void abilitaDisegno(boolean abilita) {
        this.drawAbilitato = abilita;
    }

    @Override
    public void draw() {
        block6: {
            block5: {
                int i;
                if (!this.drawAbilitato) {
                    return;
                }
                GStyle markerStyle = new GStyle();
                markerStyle.setForegroundColor(Color.blue);
                markerStyle.setBackgroundColor(Color.BLUE);
                markerStyle.setLineWidth(1);
                GStyle markerStyleSelected = new GStyle();
                markerStyleSelected.setForegroundColor(Color.blue);
                markerStyleSelected.setBackgroundColor(Color.red);
                markerStyleSelected.setLineWidth(1);
                if (this.mostraPunti) break block5;
                this.segmento.setStyle(this.stile);
                this.segmento.setGeometry(this.x, this.y);
                if (!this.mostraCerchi) break block6;
                for (i = 0; i < this.elencoSegmentiCerchi.size(); ++i) {
                    this.removeSegment(this.elencoSegmentiCerchi.get(i));
                }
                for (i = 0; i < this.x.length; ++i) {
                    int[] w = this.getScene().getTransformer().worldToDevice(this.x[i], this.y[i]);
                    GSegment cerchio = new GSegment();
                    this.addSegment(cerchio);
                    this.elencoSegmentiCerchi.add(cerchio);
                    cerchio.setGeometry(Geometry.createCircle(w[0], w[1], 7));
                    if (i != this.cerchioSelezionato) {
                        cerchio.setStyle(markerStyle);
                        continue;
                    }
                    cerchio.setStyle(markerStyleSelected);
                }
                break block6;
            }
            for (int i = 0; i < this.elencoSegmentiPunti.size(); ++i) {
                int[] w = this.getScene().getTransformer().worldToDevice(this.x[i * this.fattoreRiduzione], this.y[i * this.fattoreRiduzione]);
                this.elencoSegmentiPunti.get(i).setGeometry(Geometry.createCircle(w[0], w[1], this.raggio));
            }
        }
    }
}

