/*
 * Decompiled with CFR 0.152.
 */
package i2m.grafico;

import i2m.DanasPreferences;
import java.awt.Color;
import java.util.Vector;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GSegment;
import no.geosoft.cc.graphics.GStyle;

public class CurvaIstogramma
extends GObject {
    private double[] valori;
    private Color coloreCurva;
    private GStyle stile;
    private double minimoX;
    private double massimoX;
    private Vector<GSegment> elencoSegmentiPunti = new Vector();
    private GSegment segmentoCurva = new GSegment();
    boolean drawAbilitato = true;
    boolean graficoALinee = false;

    public CurvaIstogramma() {
    }

    public CurvaIstogramma(double minX, double maxX, double[] valori, Color colore) {
        this.valori = valori;
        this.minimoX = minX;
        this.massimoX = maxX;
        this.coloreCurva = colore;
        for (int i = 0; i < valori.length; ++i) {
            this.elencoSegmentiPunti.add(new GSegment());
            this.addSegment(this.elencoSegmentiPunti.get(i));
        }
        this.stile = new GStyle();
        this.stile.setLineWidth(2);
        this.stile.setForegroundColor(this.coloreCurva);
        if (DanasPreferences.getPrefIstogrammiPieni()) {
            this.stile.setBackgroundColor(this.coloreCurva);
        } else {
            this.stile.setBackgroundColor(null);
        }
    }

    public void setGraficoALinee(boolean aLinee) {
        this.graficoALinee = aLinee;
        this.removeAll();
        if (this.graficoALinee) {
            this.addSegment(this.segmentoCurva);
        } else {
            for (int i = 0; i < this.elencoSegmentiPunti.size(); ++i) {
                this.addSegment(this.elencoSegmentiPunti.get(i));
            }
        }
    }

    public double getMaxX() {
        return this.massimoX;
    }

    public double getMinX() {
        return this.minimoX;
    }

    public void setColore(Color nuovoColore) {
        this.coloreCurva = nuovoColore;
        this.stile.setForegroundColor(this.coloreCurva);
        if (DanasPreferences.getPrefIstogrammiPieni()) {
            this.stile.setBackgroundColor(this.coloreCurva);
        } else {
            this.stile.setBackgroundColor(null);
        }
    }

    public Color getColore() {
        return this.coloreCurva;
    }

    public double getMaxY() {
        double max = this.valori[0];
        for (int i = 0; i < this.valori.length; ++i) {
            if (!(this.valori[i] > max)) continue;
            max = this.valori[i];
        }
        return max;
    }

    public void abilitaDisegno(boolean abilita) {
        this.drawAbilitato = abilita;
    }

    @Override
    public void draw() {
        if (!this.graficoALinee) {
            for (int i = 0; i < this.elencoSegmentiPunti.size(); ++i) {
                double x0 = this.minimoX + (double)i * (this.massimoX - this.minimoX) / (double)this.elencoSegmentiPunti.size();
                double x1 = this.minimoX + (double)(i + 1) * (this.massimoX - this.minimoX) / (double)this.elencoSegmentiPunti.size();
                int[] w0 = this.getScene().getTransformer().worldToDevice(x0, 0.0);
                int[] w1 = this.getScene().getTransformer().worldToDevice(x1, this.valori[i]);
                int larghezza = DanasPreferences.getPrefIstogrammiPieni() ? (int)((double)(w1[0] - w0[0]) * 0.9) : (int)((double)(w1[0] - w0[0]));
                this.elencoSegmentiPunti.get(i).setStyle(this.stile);
                this.elencoSegmentiPunti.get(i).setGeometry(Geometry.createRectangle(w0[0], w0[1], larghezza, w1[1] - w0[1]));
            }
        } else {
            double[] x = new double[this.elencoSegmentiPunti.size()];
            double[] y = new double[this.elencoSegmentiPunti.size()];
            for (int i = 0; i < this.elencoSegmentiPunti.size(); ++i) {
                x[i] = this.minimoX + 0.5 * (this.massimoX - this.minimoX) / (double)this.elencoSegmentiPunti.size() + (double)i * (this.massimoX - this.minimoX) / (double)this.elencoSegmentiPunti.size();
                y[i] = this.valori[i];
            }
            this.segmentoCurva.setGeometry(x, y);
            this.segmentoCurva.setStyle(this.stile);
        }
    }
}

