/*
 * Decompiled with CFR 0.152.
 */
package i2m.export;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.ArrayDouble;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasLap;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.export.DanasExportDialog;
import i2m.export.DanasExportModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class KMLExport
implements DanasExportModule {
    private static JPanel panel;
    private DanasDataStructure dati = DanasDataStructure.getInstance();
    private DanasExportDialog parent;
    private BufferedWriter writer;

    private void createKMLHeader(int data_mode, boolean only_selected) throws IOException {
        String str = new String("");
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        str = str + "<!-- Danas  (I2M) -->\n";
        str = str + "<!-- Export Module " + this.getName() + " " + this.getVersion() + " -->\n";
        str = str + "<!-- Author: " + this.getAuthor() + " -->\n";
        str = str + "<kml xmlns=\"http://earth.google.com/kml/2.1\">\n";
        str = str + "<Document>\n";
        str = str + "<name>";
        str = str + (data_mode == 0 ? "Danas_Sessions" : "Danas_Laps");
        str = str + "</name>\n";
        str = str + "<description>GPS points</description>\n";
        this.writeString(str);
        if (data_mode == 0) {
            if (this.dati.getNSessions() == 0) {
                return;
            }
            for (int i = 1; i <= this.dati.getNSessions(); ++i) {
                DanasSession session = this.dati.getSession(i);
                if (only_selected && !session.isSelected()) continue;
                str = new String("");
                str = str + "<Style id=\"" + session.getSessionID() + "\">\n";
                str = str + "<LineStyle>\n";
                String red = Integer.toHexString(session.getColor().getRed());
                String green = Integer.toHexString(session.getColor().getGreen());
                String blue = Integer.toHexString(session.getColor().getBlue());
                String alpha = Integer.toHexString(session.getColor().getAlpha());
                str = str + "<color>" + alpha + blue + green + red + "</color>\n";
                str = str + "<width>2</width>\n";
                str = str + "</LineStyle>\n";
                str = str + "</Style>\n";
                this.writeString(str);
            }
        } else {
            for (int j = 1; j <= this.dati.getNSessions(); ++j) {
                DanasSession session = this.dati.getSession(j);
                if (only_selected && !session.isSelected()) continue;
                for (int i = 1; i <= session.getNumberOfLaps(); ++i) {
                    DanasLap lap = session.getLap(i);
                    if (only_selected && !lap.getSelected()) continue;
                    str = new String("");
                    str = str + "<Style id=\"" + lap.getLapID() + "\">\n";
                    str = str + "<LineStyle>\n";
                    String red = Integer.toHexString(lap.getColor().getRed());
                    String green = Integer.toHexString(lap.getColor().getGreen());
                    String blue = Integer.toHexString(lap.getColor().getBlue());
                    String alpha = Integer.toHexString(lap.getColor().getAlpha());
                    str = str + "<color>" + alpha + blue + green + red + "</color>\n";
                    str = str + "<width>2</width>\n";
                    str = str + "</LineStyle>\n";
                    str = str + "</Style>\n";
                    this.writeString(str);
                }
            }
        }
    }

    private void appendKMLFooter() throws IOException {
        String str = new String("");
        str = str + "</Document>\n";
        str = str + "</kml>\n";
        this.writeString(str);
    }

    private void writeString(String str) throws IOException {
        if (this.writer == null) {
            throw new IOException("No writer initialized");
        }
        this.writer.write(str);
    }

    private int initKMLFile() {
        int ch = 1;
        File f = null;
        while (ch == 1) {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileNameExtensionFilter("GoogleEarth file", "kml"));
            fc.setCurrentDirectory(new File("."));
            String s = DanasPreferences.getPrefDirectory("saveEsporta");
            if (s != null) {
                fc.setCurrentDirectory(new File(s));
            }
            fc.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String name = f.getName();
                    return name.toLowerCase().endsWith(".kml") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Keyhole Markup Language (*.kml)";
                }
            });
            fc.setDialogType(1);
            int res = fc.showSaveDialog(this.parent.getDialog());
            if (res != 0) {
                return -1;
            }
            f = fc.getSelectedFile();
            if (f == null) {
                return -1;
            }
            String fname = f.getName();
            DanasPreferences.setPrefDirectory("saveEsporta", fc.getCurrentDirectory().toString());
            if (!fname.endsWith(".kml")) {
                try {
                    f = new File(f.getCanonicalPath() + ".kml");
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (f.exists()) {
                ch = JOptionPane.showConfirmDialog(this.parent.getDialog(), Language.string("A file with the same name already exists: would you like to overwrite it?"), Language.string("Overwrite?"), 1);
                if (ch != 2) continue;
                return -1;
            }
            ch = 0;
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(f));
        }
        catch (IOException ioe) {
            return 1;
        }
        return 0;
    }

    private int calculateTotalProgress(int data_mode, boolean only_selected) {
        int total;
        block4: {
            block3: {
                total = 0;
                if (data_mode != 0) break block3;
                for (int j = 1; j <= this.dati.getNSessions(); ++j) {
                    DanasSession session = this.dati.getSession(j);
                    if (only_selected && !session.isSelected()) continue;
                    total += session.getDimensioneCanale(DanasDataStructureConstants.ValueType.VEL_GPS);
                }
                break block4;
            }
            if (data_mode != 1) break block4;
            for (int j = 1; j <= this.dati.getNSessions(); ++j) {
                DanasSession session = this.dati.getSession(j);
                if (only_selected && !session.isSelected()) continue;
                for (int l = 1; l <= session.getNumberOfLaps(); ++l) {
                    DanasLap lap = session.getLap(l);
                    if (only_selected && !lap.getSelected()) continue;
                    total += session.getDimensioneCanale(DanasDataStructureConstants.ValueType.VEL_GPS, lap.getStart(), lap.getEnd());
                }
            }
        }
        return total;
    }

    @Override
    public int export(DanasExportDialog parent, int data_mode, boolean only_selected_stuff) {
        this.parent = parent;
        int r = this.initKMLFile();
        if (r != 0) {
            return r;
        }
        try {
            this.createKMLHeader(data_mode, only_selected_stuff);
            int total_progress = this.calculateTotalProgress(data_mode, only_selected_stuff);
            parent.initProgress(total_progress);
            int current_progress = 0;
            StringBuffer buffer = new StringBuffer();
            if (data_mode == 0) {
                for (int j = 1; j <= this.dati.getNSessions(); ++j) {
                    DanasSession session = this.dati.getSession(j);
                    if (only_selected_stuff && !session.isSelected()) continue;
                    buffer.delete(0, buffer.length());
                    buffer.append("<Placemark>\n");
                    buffer.append("<name>Session" + session.getSessionID() + "</name>\n");
                    buffer.append("<description>DATE: " + session.getDateString() + ",DISTANCE: " + MeasuresUtil.valueToHumanReadable(session.getDistanceCovered(DanasDataStructureConstants.DataType.GPS), 2) + "m, ELAPSED_TIME:" + MeasuresUtil.timeToHumanHours((int)session.getDuration(DanasDataStructureConstants.SelectionFlag.ALL, DanasDataStructureConstants.DataType.GPS)) + "</description>\n");
                    buffer.append("<styleUrl>#" + session.getSessionID() + "</styleUrl>\n");
                    buffer.append("<LineString>\n");
                    buffer.append("<extrude>1</extrude>\n");
                    buffer.append("<tessellate>1</tessellate>\n");
                    buffer.append("<altitudeMode>clampToGround</altitudeMode>\n");
                    buffer.append("<coordinates>");
                    this.writeString(buffer.toString());
                    ArrayDouble gpsLat = session.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
                    ArrayDouble gpsLon = session.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
                    for (int i = 0; i < gpsLat.size(); ++i) {
                        this.writeString(this.converToDegree(gpsLon.get(i)) + "," + this.converToDegree(gpsLat.get(i)) + "," + 0 + "\n");
                        parent.setProgress(++current_progress);
                    }
                    this.writeString("</coordinates>\n</LineString>\n</Placemark>\n");
                }
            } else if (data_mode == 1) {
                for (int j = 1; j <= this.dati.getNSessions(); ++j) {
                    DanasSession session = this.dati.getSession(j);
                    if (only_selected_stuff && !session.isSelected()) continue;
                    for (int l = 1; l <= session.getNumberOfLaps(); ++l) {
                        DanasLap lap = session.getLap(l);
                        if (only_selected_stuff && !lap.getSelected()) continue;
                        buffer.delete(0, buffer.length());
                        buffer.append("<Placemark>\n");
                        buffer.append("<name>Lap" + session.getSessionID() + "-" + lap.getLapID() + "</name>\n");
                        buffer.append("<description>DATE: " + session.getDateString() + ",DISTANCE: " + MeasuresUtil.valueToHumanReadable(lap.getDistanceCovered(DanasDataStructureConstants.DataType.GPS), 2) + "m, ELAPSED_TIME:" + MeasuresUtil.timeToHumanReadable((int)lap.getDuration()) + "</description>\n");
                        buffer.append("<styleUrl>#" + lap.getLapID() + "</styleUrl>\n");
                        buffer.append("<LineString>\n");
                        buffer.append("<extrude>1</extrude>\n");
                        buffer.append("<tessellate>1</tessellate>\n");
                        buffer.append("<altitudeMode>clampToGround</altitudeMode>\n");
                        buffer.append("<coordinates>");
                        this.writeString(buffer.toString());
                        List<Double> gpsLat = session.getSelectionValueData(DanasDataStructureConstants.ValueType.LAT, lap.getStart(), lap.getEnd(), false);
                        List<Double> gpsLon = session.getSelectionValueData(DanasDataStructureConstants.ValueType.LONG, lap.getStart(), lap.getEnd(), false);
                        for (int i = 0; i < gpsLat.size(); ++i) {
                            this.writeString(this.converToDegree(gpsLon.get(i)) + "," + this.converToDegree(gpsLat.get(i)) + "," + 0 + "\n");
                            parent.setProgress(++current_progress);
                        }
                        this.writeString("</coordinates>\n</LineString>\n</Placemark>\n");
                    }
                }
            }
            this.appendKMLFooter();
            this.writer.close();
            parent.closeProgress();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return 1;
        }
        return 0;
    }

    public double converToDegree(Double coordinate) {
        return coordinate / 10000.0 / 60.0;
    }

    @Override
    public String getAuthor() {
        return "I2M.it";
    }

    @Override
    public String getName() {
        return "Keyhole Markup Language";
    }

    @Override
    public String getDescription() {
        return "Write GPS points in a XML-like format to be parsed by <b>GoogleEarth</b> and <b>GoogleMaps</b>.";
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public JPanel getPanel() {
        if (panel == null) {
            panel = new JPanel(new GridBagLayout());
            panel.setBackground(Color.WHITE);
            JLabel label = new JLabel();
            label.setHorizontalAlignment(0);
            ImageIcon logo = new ImageIcon(this.getClass().getResource("/pix/googleearth_icon.gif"));
            label.setIcon(logo);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)label, gc);
        }
        return panel;
    }
}

