/*
 * Decompiled with CFR 0.152.
 */
package i2m.export;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.Language;
import i2m.export.DanasExportDialog;
import i2m.export.DanasExportModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CSVExport_Filled
implements DanasExportModule {
    private JPanel panel;
    private boolean only_selected_stuff = false;
    private BufferedWriter writer = null;
    private DanasExportDialog parent = null;
    private int total_progress = 0;

    @Override
    public int export(DanasExportDialog parent, int data_mode, boolean only_selected_stuff) {
        int res;
        this.only_selected_stuff = only_selected_stuff;
        this.parent = parent;
        this.parent = parent;
        try {
            System.out.println("Export:inizializzo CSV filled");
            res = this.initCSVFile();
            if (res != 0) {
                return res;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parent.getDialog(), e.getMessage(), "Error opening file", 0);
        }
        if (this.writer == null) {
            System.out.println("writer=null");
            return -1;
        }
        System.out.println("Export:creo header");
        this.createCSVHeader();
        res = -1;
        this.total_progress = this.calculateTotalProgress();
        parent.initProgress(100);
        res = this.exportSessions();
        System.out.println("Export:esportati");
        this.parent.closeProgress();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public int calculateTotalProgress() {
        int numeroPunti = 0;
        for (int en = 1; en <= DanasDataStructure.getInstance().getNSessions(); ++en) {
            DanasSession sess = DanasDataStructure.getInstance().getSession(en);
            numeroPunti += (int)((sess.getEndTelemetryTime() - sess.getStartTelemetryTime()) / sess.getRisoluzioneTemporale());
        }
        return numeroPunti;
    }

    private int initCSVFile() {
        int res;
        int ch = 1;
        File f = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("Csv files", "csv"));
        String s = DanasPreferences.getPrefDirectory("saveEsporta");
        if (s != null) {
            fileChooser.setCurrentDirectory(new File(s));
        }
        if ((res = fileChooser.showSaveDialog(this.parent.getDialog())) == 0) {
            DanasPreferences.setPrefDirectory("saveEsporta", fileChooser.getCurrentDirectory().toString());
            f = fileChooser.getSelectedFile();
            if (f == null) {
                return -1;
            }
            String fname = f.getName();
            if (!fname.endsWith(".csv")) {
                try {
                    f = new File(f.getCanonicalPath() + ".csv");
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (f.exists() && (ch = JOptionPane.showConfirmDialog(this.parent, Language.string("Sovrascrivere il file esistente?"), Language.string("ATTENZIONE"), 1)) == 2) {
                return -1;
            }
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(f));
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.parent, ioe.getMessage(), "Error opening file to write", 0);
        }
        return 0;
    }

    private void createCSVHeader() {
        String head = "Channel name: ;Time [s];";
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            head = head + DanasDataStructure.getInstance().getNomeTipo(DanasDataStructureConstants.ValueType.values()[i]) + ";";
        }
        try {
            this.writer.write(head + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createInitSession(DanasSession sess) {
        String frequenze = "Channel frequency: ;;";
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            frequenze = frequenze + sess.getFrequenzaCanale(DanasDataStructureConstants.ValueType.values()[i]) + ";";
        }
        String tempiInizio = "Time of first data [s]: ;;";
        double primoTempo = sess.getTempoPrimoDato();
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            tempiInizio = sess.getFrequenzaCanale(DanasDataStructureConstants.ValueType.values()[i]) != 0.0 ? tempiInizio + String.format("%.2f", (sess.getTempoIniziale(DanasDataStructureConstants.ValueType.values()[i]) - primoTempo) / 100.0) + ";" : tempiInizio + ";";
        }
        try {
            this.writer.write("\n");
            this.writer.write("Sessione " + sess.getSessionID() + ":\n");
            this.writer.write(frequenze + "\n");
            this.writer.write(tempiInizio + "\n");
            this.writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double convertiCoordinate(double valore) {
        return valore / 600000.0;
    }

    private int exportSessions() {
        int percentuale = 0;
        int counter = 0;
        double primoTempoScritto = 0.0;
        boolean primoTempoTrovato = false;
        for (int en = 1; en <= DanasDataStructure.getInstance().getNSessions(); ++en) {
            DanasSession session = DanasDataStructure.getInstance().getSession(en);
            if (!session.isSelected() && this.only_selected_stuff) continue;
            this.createInitSession(session);
            int[] elencoUltimiIndici = new int[DanasDataStructureConstants.ValueType.values().length];
            double[] elencoUltimiValori = new double[DanasDataStructureConstants.ValueType.values().length];
            for (int i = 0; i < elencoUltimiIndici.length; ++i) {
                elencoUltimiIndici[i] = -1;
                DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[i];
                elencoUltimiValori[i] = 0.0;
                if (session.getFrequenzaCanale(vt) == 0.0) continue;
                elencoUltimiValori[i] = session.getDatoAtTime(vt, 0.0, DanasDataStructureConstants.BoundLap.NEAREST, false);
                if (vt != DanasDataStructureConstants.ValueType.LAT && vt != DanasDataStructureConstants.ValueType.LONG) continue;
                elencoUltimiValori[i] = this.convertiCoordinate(elencoUltimiValori[i]);
            }
            for (double time = session.getStartTelemetryTime().doubleValue(); time < session.getEndTelemetryTime(); time += session.getRisoluzioneTemporale()) {
                ++counter;
                if (!primoTempoTrovato) {
                    primoTempoScritto = time - session.getTempoPrimoDato();
                }
                String lineaTempo = ";" + String.format("%.4f", (time - session.getTempoPrimoDato() - primoTempoScritto) / 100.0) + ";";
                boolean vuota = true;
                for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
                    DanasDataStructureConstants.ValueType vt = DanasDataStructureConstants.ValueType.values()[i];
                    if (session.getFrequenzaCanale(vt) == 0.0) {
                        lineaTempo = lineaTempo + ";";
                        continue;
                    }
                    int indice = session.getIndiceAtTime(vt, time, DanasDataStructureConstants.BoundLap.PREVIOUS);
                    if (indice == elencoUltimiIndici[i]) {
                        lineaTempo = lineaTempo + String.format("%f", elencoUltimiValori[i]) + ";";
                        continue;
                    }
                    if (elencoUltimiIndici[i] == -1 && time <= session.getTempoIniziale(vt)) {
                        lineaTempo = lineaTempo + String.format("%f", elencoUltimiValori[i]) + ";";
                        continue;
                    }
                    elencoUltimiIndici[i] = indice;
                    if (time <= session.getTempoIniziale(vt)) {
                        lineaTempo = lineaTempo + String.format("%f", elencoUltimiValori[i]) + ";";
                    } else {
                        if (vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG) {
                            String s = String.format("%f", this.convertiCoordinate(session.getDatoAtTime(vt, time, DanasDataStructureConstants.BoundLap.NEAREST, false))) + ";";
                            lineaTempo = lineaTempo + s;
                            if (counter < 1500) {
                                System.out.println("s=" + s);
                                if (vt == DanasDataStructureConstants.ValueType.LONG) {
                                    System.out.println(" linea=" + lineaTempo + "\n");
                                }
                            }
                        } else {
                            lineaTempo = lineaTempo + String.format("%f", session.getDatoAtTime(vt, time, DanasDataStructureConstants.BoundLap.NEAREST, false)) + ";";
                        }
                        elencoUltimiValori[i] = session.getDatoAtTime(vt, time, DanasDataStructureConstants.BoundLap.NEAREST, false);
                        if (vt == DanasDataStructureConstants.ValueType.LAT || vt == DanasDataStructureConstants.ValueType.LONG) {
                            elencoUltimiValori[i] = this.convertiCoordinate(elencoUltimiValori[i]);
                        }
                    }
                    vuota = false;
                }
                try {
                    if (!vuota) {
                        this.writer.write(lineaTempo + "\n");
                        if (!primoTempoTrovato) {
                            primoTempoTrovato = true;
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int percentualeAttuale = (int)((float)counter / (float)this.total_progress * 100.0f);
                if (percentuale != percentualeAttuale) {
                    this.parent.setProgress(percentualeAttuale);
                }
                percentuale = percentualeAttuale;
            }
        }
        return 0;
    }

    @Override
    public String getAuthor() {
        return "I2M.it";
    }

    @Override
    public String getDescription() {
        return "Export selected values to a CSV file filling the blank cells with the previous data to simplify the import by overlay softwares.<br> At session begin data will be filled with the first available value. <b>CSV files contains values separeted by a semicolon (;).</b> Such files can be opened with Excel(c) like programs, just be careful with the data format.<br><br> -Latitude and Longitude has Degrees unit<br> -Time unit is in [s]<br> -GPS_TIME is the GMT time in 1/100s unit<br>";
    }

    @Override
    public String getName() {
        return "Comma Separated Values with filled cells";
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new GridBagLayout());
            this.panel.setBackground(Color.WHITE);
            JLabel label = new JLabel();
            label.setHorizontalAlignment(0);
            ImageIcon logo = new ImageIcon(this.getClass().getResource("/pix/csv_icon.gif"));
            label.setIcon(logo);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.insets = new Insets(5, 5, 5, 5);
            this.panel.add((Component)label, gc);
        }
        return this.panel;
    }

    @Override
    public String getVersion() {
        return "3.0";
    }
}

