/*
 * Decompiled with CFR 0.152.
 */
package i2m;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

public class Language {
    public static final String VERSION = "0.2";
    public static String LANG_HEAD_FRMT = "{0} {1} - v.{2}";
    public static String LANG_FILE_STR = "language.";
    public static String LANG_ROOT_FIL = "lang";
    private static final MessageFormat headerFormat = new MessageFormat(LANG_HEAD_FRMT);
    private static final char CODE_START_CHR = '.';
    private static final String UNKNOWN_STR = "<unknown>";
    private static LanguageManager lman;
    private String code;
    private Properties strings;
    private File file;
    private Locale locale;
    private boolean modified;

    public static void main(String[] args) {
        Language.simpleExample();
        Language.complexExample();
    }

    private static void simpleExample() {
        System.out.println(Language.getCurrentLanguage());
        String world = Language.string("world");
        String hello = Language.string("Hello");
        System.out.println(hello + " " + world + "!");
        Language.setCurrentLanguage("en");
        System.out.println(Language.getCurrentLanguage());
        world = Language.string("world");
        hello = Language.string("Hello");
        System.out.println(hello + " " + world + "!");
    }

    private static void complexExample() {
        Language.loadLanguages("lang");
        Language l = new Language("test");
        l.setFile(new File("lang/korean.test"));
        l.setLocale(Locale.KOREAN);
        l.open();
        Language.updateLanguages(l);
        System.out.println("Loaded languages:");
        for (LanguageDescriptor ld : Language.getDescriptors()) {
            System.out.println(ld);
        }
        Language.setCurrentLanguage(l);
        System.out.println("Current language: " + Language.getCurrentLanguage());
        System.out.println("Testing Custom Language:");
        String s1 = Language.string("Hello world!");
        System.out.println("> " + s1);
        String s2 = Language.string("This is number {0}! Bye {1}...", 1.0, "bye");
        System.out.println("> " + s2);
        String s3 = Language.string("A few numbers: {0} {1} {2}", 1100.0, 1100.123, Float.valueOf(0.02f));
        System.out.println("> " + s3);
    }

    private static synchronized LanguageManager getManager() {
        if (lman == null) {
            Language.loadLanguages();
        }
        return lman;
    }

    public static Language getLanguage(String code) {
        Language l = new Language(code);
        l.open();
        Language.updateLanguages(l);
        return l;
    }

    public static Language getCurrentLanguage() {
        if (Language.getManager().lcurrent == null) {
            lman.lcurrent = Language.getLanguage(Locale.getDefault().getLanguage());
        }
        return lman.lcurrent;
    }

    public static void setCurrentLanguage(Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Language cannot be null");
        }
        if (Language.getManager().lcurrent != null) {
            Language.getManager().lcurrent.close();
        }
        Language.getManager().lcurrent = language;
        Language.updateLanguages(language);
    }

    public static void updateLanguages(Language language) {
        LanguageDescriptor ldesc = new LanguageDescriptor(language.file, language.locale);
        lman.languages.put(language.code, ldesc);
    }

    public static void setCurrentLanguage(String code) {
        Language.setCurrentLanguage(Language.getLanguage(code));
    }

    public static String string(String key) {
        return Language.getCurrentLanguage().getString(key);
    }

    public static String string(String key, Object ... data) {
        return Language.getCurrentLanguage().getString(key, data);
    }

    public static void loadLanguages() {
        Language.loadLanguages(LANG_ROOT_FIL);
    }

    public static void loadLanguages(String root) {
        File[] lfiles;
        if (lman == null) {
            lman = new LanguageManager();
        }
        if (!root.equals(LANG_ROOT_FIL)) {
            lman.lroot = new File(root);
            if (lman.lroot.isFile()) {
                lman.lroot = lman.lroot.getParentFile();
            }
        }
        lman.languages.clear();
        if (!lman.lroot.exists()) {
            return;
        }
        for (File lf : lfiles = lman.lroot.listFiles(lman.lfilter)) {
            String c = Language.getCode(lf.getName());
            LanguageDescriptor ldesc = new LanguageDescriptor(lf, Language.getLocale(c));
            lman.languages.put(c, ldesc);
        }
    }

    public static String[] getCodes() {
        return Language.getManager().languages.keySet().toArray(new String[0]);
    }

    public static LanguageDescriptor[] getDescriptors() {
        return Language.getManager().languages.values().toArray(new LanguageDescriptor[0]);
    }

    public static String[] getDisplayLanguages() {
        int siz = Language.getManager().languages.size();
        String[] dls = new String[siz];
        int i = 0;
        for (LanguageDescriptor ld : lman.languages.values()) {
            if (ld == null) continue;
            if (ld.locale == null) {
                System.err.println(ld.file + ": no locale available for this file");
                continue;
            }
            dls[i++] = ld.locale.getDisplayLanguage();
        }
        return dls;
    }

    private static String getCode(String lname) {
        int cs = lname.lastIndexOf(46);
        if (cs < 0) {
            return null;
        }
        return lname.substring(cs + 1);
    }

    private static Locale getLocale(String code) {
        for (Locale l : Locale.getAvailableLocales()) {
            if (!l.getLanguage().equalsIgnoreCase(code)) continue;
            return l;
        }
        return Locale.getDefault();
    }

    public Language(String code) {
        this.code = code;
        this.strings = new Properties();
        LanguageDescriptor ld = (LanguageDescriptor)Language.getManager().languages.get(code);
        if (ld == null) {
            this.file = null;
            this.locale = Language.getLocale(code);
        } else {
            this.file = ld.file;
            this.locale = ld.locale;
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.modified = false;
    }

    public void setFile(File f) {
        if (f != this.file) {
            this.file = f;
            this.modified = true;
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getString(String key) {
        String value = this.strings.getProperty(key);
        if (value == null) {
            value = key;
            this.strings.setProperty(key, value);
            System.out.println("Aggiunta stringa linguaggio=" + key);
            this.modified = true;
        }
        return value;
    }

    public String getString(String key, Object ... data) {
        MessageFormat mformat = new MessageFormat(this.getString(key));
        mformat.setLocale(this.locale);
        return mformat.format(data, new StringBuffer(), (FieldPosition)null).toString();
    }

    public void open() {
        if (this.file == null || !this.file.exists()) {
            this.modified = true;
        } else {
            FileInputStream fis = null;
            try {
                this.strings.clear();
                fis = new FileInputStream(this.file);
                this.strings.load(fis);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.modified = false;
        }
    }

    public void close() {
        if (this.modified) {
            if (this.file == null) {
                this.file = new File(Language.getManager().lroot.getAbsolutePath() + File.separator + LANG_FILE_STR + this.code);
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.file);
                System.out.println("Storing strings to " + this.file.getName());
                this.strings.store(fos, this.getLanguageHeader());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getLanguageHeader() {
        Object[] data = new Object[]{this.locale.getDisplayLanguage(), this.locale.getLanguage(), VERSION};
        return headerFormat.format(data, new StringBuffer(), (FieldPosition)null).toString();
    }

    public String getDisplay() {
        return this.locale.getDisplayLanguage();
    }

    public String toString() {
        String fnam = this.file == null ? UNKNOWN_STR : this.file.getName();
        return "[" + this.getClass().getSimpleName() + "] " + fnam + " (" + this.locale.getDisplayLanguage() + "): " + this.strings.size() + " string" + (this.strings.size() > 1 ? "s" : "") + ".";
    }

    private static class LanguageFilenameFilter
    implements FilenameFilter {
        private LanguageFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().startsWith(LANG_FILE_STR);
        }
    }

    public static class LanguageDescriptor {
        private File file;
        private Locale locale;

        public LanguageDescriptor(File f, Locale l) {
            this.file = f;
            this.locale = l;
        }

        public String toString() {
            return this.file + " " + this.locale.getDisplayLanguage();
        }
    }

    private static class LanguageManager
    implements Runnable {
        private File lroot = new File(LANG_ROOT_FIL);
        private HashMap<String, LanguageDescriptor> languages = new HashMap();
        private LanguageFilenameFilter lfilter = new LanguageFilenameFilter();
        private Language lcurrent;

        public LanguageManager() {
            Runtime.getRuntime().addShutdownHook(new Thread(this));
        }

        @Override
        public void run() {
            if (this.lcurrent != null) {
                this.lcurrent.close();
            }
        }
    }
}

