/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Dialog.GearDialog;
import i2m.Language;
import i2m.grafico.CurvaXY;
import i2m.grafico.GraficoXY;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import no.geosoft.cc.graphics.GScene;

public class XYMarceDialog
extends JDialog
implements ActionListener,
ChangeListener,
WindowListener,
ListSelectionListener,
ComponentListener {
    private GraficoXY graphXy;
    JPanel pannelloTabella;
    boolean aggiornaGrafico = false;
    boolean aggiornaCurve = false;
    boolean visibile = true;
    private int larghezzaDialog = 650;
    private int altezzaDialog = 650;
    private int posX = 0;
    private int posY = 0;
    private static final long serialVersionUID = 1L;

    public XYMarceDialog(GearDialog mathDialog) {
        super((Dialog)mathDialog, Language.string("Grafico rapporto marce"));
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.graphXy = new GraficoXY(null);
        this.graphXy.setGraficoMarce();
        this.pannelloTabella = new JPanel(new BorderLayout());
        this.pannelloTabella.add(this.graphXy.getGrafico(), "Center");
        this.add(this.pannelloTabella);
        this.addWindowListener(this);
        this.setSize(550, 500);
        this.setResizable(false);
        this.setFocusableWindowState(false);
    }

    public void aggiungiMarciaVera(int numeroMarcia, double rapporto, double rpmMinimo, double rpmMassimo) {
        String nome;
        double minY = rpmMinimo / rapporto;
        double MaxY = rpmMassimo / rapporto;
        switch (numeroMarcia) {
            case 1: {
                nome = "prima";
                break;
            }
            case 2: {
                nome = "seconda";
                break;
            }
            case 3: {
                nome = "terza";
                break;
            }
            case 4: {
                nome = "quarta";
                break;
            }
            case 5: {
                nome = "quinta";
                break;
            }
            case 6: {
                nome = "sesta";
                break;
            }
            default: {
                nome = "folle";
            }
        }
        this.graphXy.rimuoviCurvaXY(nome);
        double[] x = new double[]{rpmMinimo, rpmMassimo};
        double[] y = new double[]{minY, MaxY};
        double[] z = new double[]{0.0, 1.0};
        CurvaXY c = new CurvaXY(x, y, Color.BLUE, nome);
        this.graphXy.aggiungiCurvaXY(c);
    }

    public void cancellaTutto() {
        this.graphXy.rimuoviTutto();
    }

    public void aggiungiMarciaSimulata(int numeroMarcia, double rapporto, double rpmMinimo, double rpmMassimo) {
        String nome;
        double minY = rpmMinimo / rapporto;
        double MaxY = rpmMassimo / rapporto;
        switch (numeroMarcia) {
            case 1: {
                nome = "primaS";
                break;
            }
            case 2: {
                nome = "secondaS";
                break;
            }
            case 3: {
                nome = "terzas";
                break;
            }
            case 4: {
                nome = "quartaS";
                break;
            }
            case 5: {
                nome = "quintaS";
                break;
            }
            case 6: {
                nome = "sestaS";
                break;
            }
            default: {
                nome = "folle";
            }
        }
        this.graphXy.rimuoviCurvaXY(nome);
        double[] x = new double[]{rpmMinimo, rpmMassimo};
        double[] y = new double[]{minY, MaxY};
        double[] z = new double[]{0.0, 1.0};
        CurvaXY c = new CurvaXY(x, y, Color.ORANGE, nome);
        this.graphXy.aggiungiCurvaXY(c);
    }

    public void setEstremi(double minX, double maxX, double minY, double maxY) {
        this.graphXy.setEstremiMarce(minX, maxX, minY, maxY);
    }

    public void fittaVerticale() {
        if (this.graphXy.getScene().getNChildren() == 0) {
            return;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        GScene s = this.graphXy.getScene();
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (((CurvaXY)s.getChild(j)).getMaxY() > max) {
                max = ((CurvaXY)s.getChild(j)).getMaxY();
            }
            if (!(((CurvaXY)s.getChild(j)).getMinY() < min)) continue;
            min = ((CurvaXY)s.getChild(j)).getMinY();
        }
        if ((max += Math.abs(max - (min -= Math.abs(max - min) * 0.05)) * 0.05) == min) {
            max += 1.0;
            min -= 1.0;
        }
        this.graphXy.setAsseY(min, max, true, true);
    }

    public void fittaOrizzontale() {
        if (this.graphXy.getScene().getNChildren() == 0) {
            return;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        GScene s = this.graphXy.getScene();
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (((CurvaXY)s.getChild(j)).getMaxX() > max) {
                max = ((CurvaXY)s.getChild(j)).getMaxX();
            }
            if (!(((CurvaXY)s.getChild(j)).getMinX() < min)) continue;
            min = ((CurvaXY)s.getChild(j)).getMinX();
        }
        if ((max += Math.abs(max - (min -= Math.abs(max - min) * 0.05)) * 0.05) == min) {
            max += 1.0;
            min -= 1.0;
        }
        this.graphXy.setAsseX(min, max, true, true);
    }

    public void refresh() {
        this.graphXy.refresh();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
    }

    public static void main(String[] args) {
        XYMarceDialog i = new XYMarceDialog(null);
        i.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }
}

