/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.Dialog.SensoreTPMS;
import i2m.Language;
import i2m.MainFrame;
import i2m.onLine.SerialConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TPMSDialog
extends JDialog
implements ActionListener,
WindowListener,
ListSelectionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private JComboBox sceltaCOM = null;
    private JButton connettiB;
    private JButton eliminaB;
    private JButton modificaB;
    private JButton applicaB;
    private JButton startB;
    private JButton upB;
    private JButton dnB;
    private JButton searchB;
    private JButton segnaleB;
    private DefaultListModel elencoSensoriLM;
    private JFormattedTextField idTF;
    private JFormattedTextField pMinTF_F;
    private JFormattedTextField pMaxTF_F;
    private JFormattedTextField tMinTF_F;
    private JFormattedTextField tMaxTF_F;
    private JFormattedTextField pMinTF_R;
    private JFormattedTextField pMaxTF_R;
    private JFormattedTextField tMinTF_R;
    private JFormattedTextField tMaxTF_R;
    private JTextField nomeTF;
    private JTextField[] pressioniTF;
    private JTextField[] temperatureTF;
    private JTextField[] tensioniTF;
    private long[] conteggioAggiornamenti;
    private Double[] valoreTemperature;
    private Double[] valorePressioni;
    private Double[] valoreTensioni;
    private Double[] valoreSegnale;
    private JPanel[] pannelliSensori;
    private double pMinAnt;
    private double pMaxAnt;
    private double tMinAnt;
    private double tMaxAnt;
    private double pMinPost;
    private double pMaxPost;
    private double tMinPost;
    private double tMaxPost;
    private MainFrame padre;
    private JList list;
    private String[] elenco = null;
    private Vector<SensoreTPMS> elencoSensori;
    private Vector<Integer> elencoId;
    JRadioButton frontB;
    JRadioButton rearB;
    private SerialConnection conn;
    private boolean connected = false;
    private Color sfondo;
    private Thread acquisitionThread;
    private PrintStream streamScrittura = null;
    private FileOutputStream fos;
    private long tempoStart = 0L;
    private boolean debug = false;
    private boolean trovaSensore = true;
    private boolean ricercaInCorso = false;
    private boolean mostraBatteria = true;
    private final int MAX_TEMPO_MS = 90000;
    private final double LOW_VOLTAGE = 10.0;
    private final double LOW_SIGNAL = -85.0;
    private final int SEGNALE_MINIMO = -45;

    public TPMSDialog(MainFrame owner, String[] lista) {
        super(owner, Language.string(Language.string("TPMS")), false);
        int i;
        this.addWindowListener(this);
        this.padre = owner;
        this.elenco = lista;
        System.out.println("DEBUG:Apertura TPMS");
        this.elencoSensoriLM = new DefaultListModel();
        this.elencoSensoriLM.clear();
        this.elencoSensori = new Vector();
        this.elencoId = new Vector();
        this.valoreTemperature = new Double[24];
        this.valorePressioni = new Double[24];
        this.valoreTensioni = new Double[24];
        this.valoreSegnale = new Double[24];
        for (int i2 = 0; i2 < 24; ++i2) {
            this.valoreTemperature[i2] = 0.0;
            this.valorePressioni[i2] = 0.0;
            this.valoreTensioni[i2] = 0.0;
            this.valoreSegnale[i2] = 0.0;
        }
        this.sceltaCOM = new JComboBox();
        this.sceltaCOM.setFocusable(false);
        this.connettiB = new JButton(Language.string("Connetti"));
        this.connettiB.addActionListener(this);
        this.sceltaCOM.setMinimumSize(new Dimension(120, 25));
        this.sceltaCOM.setPreferredSize(new Dimension(120, 25));
        this.sceltaCOM.setMaximumSize(new Dimension(120, 25));
        this.connettiB.setMinimumSize(new Dimension(80, 25));
        this.connettiB.setMaximumSize(new Dimension(80, 25));
        this.connettiB.setFocusable(false);
        this.startB = new JButton(Language.string("Start Log"));
        this.startB.addActionListener(this);
        this.startB.setMinimumSize(new Dimension(80, 25));
        this.startB.setMaximumSize(new Dimension(80, 25));
        this.startB.setFocusable(false);
        this.startB.setEnabled(false);
        this.searchB = new JButton(Language.string("Cerca"));
        this.searchB.setMaximumSize(new Dimension(80, 25));
        this.searchB.setMinimumSize(new Dimension(80, 25));
        this.searchB.addActionListener(this);
        this.searchB.setFocusable(false);
        this.searchB.setEnabled(false);
        this.segnaleB = new JButton(Language.string("Batteria"));
        this.segnaleB.setMaximumSize(new Dimension(80, 25));
        this.segnaleB.setMinimumSize(new Dimension(80, 25));
        this.segnaleB.addActionListener(this);
        this.segnaleB.setFocusable(false);
        this.segnaleB.setEnabled(false);
        JLabel l = new JLabel(Language.string("Scegli la porta su cui \u00e8 connesso il ricevitore"));
        JPanel pannelloConnessione = new JPanel();
        pannelloConnessione.add(l);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.sceltaCOM);
        pannelloConnessione.add(this.connettiB);
        pannelloConnessione.add(this.segnaleB);
        pannelloConnessione.add(this.startB);
        pannelloConnessione.add(this.searchB);
        GridLayout sottoLayout = new GridLayout(1, 2, 2, 2);
        JPanel pannellosotto = new JPanel();
        pannellosotto.setLayout(sottoLayout);
        JPanel PanelBorderLeft = new JPanel(new BorderLayout());
        PanelBorderLeft.setBorder(BorderFactory.createTitledBorder(Language.string("Gestione ID")));
        JPanel PanelBorderRight = new JPanel(new BorderLayout());
        PanelBorderRight.setBorder(BorderFactory.createTitledBorder(Language.string("Allarmi")));
        pannellosotto.add(PanelBorderLeft);
        pannellosotto.add(PanelBorderRight);
        this.upB = new JButton(Language.string("Su"));
        this.upB.addActionListener(this);
        this.upB.setFocusable(false);
        this.dnB = new JButton(Language.string("Gi\u00f9"));
        this.dnB.addActionListener(this);
        this.dnB.setFocusable(false);
        this.list = new JList(this.elencoSensoriLM);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(50, 100));
        listScroller.setVerticalScrollBarPolicy(22);
        GridLayout intLayout = new GridLayout(1, 2, 2, 2);
        JPanel internalPanelSx = new JPanel();
        internalPanelSx.setLayout(intLayout);
        GridLayout sxLayout = new GridLayout(1, 2, 2, 2);
        JPanel pannellosx = new JPanel();
        pannellosx.setLayout(sxLayout);
        JPanel pannelloLista = new JPanel(new BorderLayout());
        pannelloLista.add((Component)listScroller, "Center");
        JPanel pannelloUpDn = new JPanel(new BorderLayout());
        pannelloUpDn.add((Component)this.upB, "West");
        pannelloUpDn.add((Component)this.dnB, "East");
        pannelloLista.add((Component)pannelloUpDn, "South");
        pannellosx.add(pannelloLista);
        internalPanelSx.add(pannellosx);
        PanelBorderLeft.add(internalPanelSx);
        NumberFormat TFormat = NumberFormat.getNumberInstance(Locale.US);
        TFormat.setMaximumIntegerDigits(10);
        TFormat.setMaximumFractionDigits(0);
        TFormat.setGroupingUsed(false);
        this.idTF = new JFormattedTextField(TFormat);
        this.idTF.setValue(0);
        this.nomeTF = new JTextField(13);
        this.idTF.setHorizontalAlignment(4);
        this.nomeTF.setText("nome");
        this.nomeTF.setHorizontalAlignment(4);
        JPanel nomePanel = new JPanel();
        JLabel nomeLabel = new JLabel(Language.string("  Nome:"));
        JPanel idPanel = new JPanel();
        JLabel idLabel = new JLabel(Language.string("  ID:"));
        GridLayout nomeLayot = new GridLayout(1, 2, 2, 2);
        nomePanel.setLayout(nomeLayot);
        idPanel.setLayout(nomeLayot);
        nomePanel.add(nomeLabel);
        nomePanel.add(this.nomeTF);
        idPanel.add(idLabel);
        idPanel.add(this.idTF);
        this.eliminaB = new JButton(Language.string("Elimina"));
        this.eliminaB.addActionListener(this);
        this.eliminaB.setFocusable(false);
        this.modificaB = new JButton(Language.string("Aggiungi/Modifica"));
        this.modificaB.addActionListener(this);
        this.modificaB.setFocusable(false);
        this.applicaB = new JButton(Language.string("Applica"));
        this.applicaB.setEnabled(false);
        this.applicaB.setPreferredSize(new Dimension(150, 30));
        this.applicaB.addActionListener(this);
        this.applicaB.setFocusable(false);
        GridLayout dxLayout = new GridLayout(5, 1, 2, 2);
        JPanel pannellodx = new JPanel();
        pannellodx.setLayout(dxLayout);
        this.frontB = new JRadioButton(Language.string("Anteriore"));
        this.frontB.setFocusable(false);
        this.rearB = new JRadioButton(Language.string("Posteriore"));
        this.rearB.setFocusable(false);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.frontB);
        group1.add(this.rearB);
        this.frontB.setSelected(true);
        JPanel radioPanel = new JPanel();
        radioPanel.add(this.frontB);
        radioPanel.add(this.rearB);
        this.list.setFocusable(false);
        pannellodx.add(radioPanel);
        pannellodx.add(idPanel);
        pannellodx.add(nomePanel);
        pannellodx.add(this.modificaB);
        pannellodx.add(this.eliminaB);
        internalPanelSx.add(pannellodx);
        NumberFormat AFormat = NumberFormat.getNumberInstance(Locale.US);
        AFormat.setMaximumIntegerDigits(10);
        AFormat.setMaximumFractionDigits(2);
        AFormat.setGroupingUsed(false);
        this.pMinTF_F = new JFormattedTextField(AFormat);
        this.pMinTF_F.setValue(DanasPreferences.getMinPressAnt());
        this.pMinTF_F.setHorizontalAlignment(4);
        this.pMaxTF_F = new JFormattedTextField(AFormat);
        this.pMaxTF_F.setValue(DanasPreferences.getMaxPressAnt());
        this.pMaxTF_F.setHorizontalAlignment(4);
        this.tMinTF_F = new JFormattedTextField(AFormat);
        this.tMinTF_F.setValue(DanasPreferences.getMinTempAnt());
        this.tMinTF_F.setHorizontalAlignment(4);
        this.tMaxTF_F = new JFormattedTextField(AFormat);
        this.tMaxTF_F.setValue(DanasPreferences.getMaxTempAnt());
        this.tMaxTF_F.setHorizontalAlignment(4);
        this.pMinTF_R = new JFormattedTextField(AFormat);
        this.pMinTF_R.setValue(DanasPreferences.getMinPressPost());
        this.pMinTF_R.setHorizontalAlignment(4);
        this.pMaxTF_R = new JFormattedTextField(AFormat);
        this.pMaxTF_R.setValue(DanasPreferences.getMaxPressPost());
        this.pMaxTF_R.setHorizontalAlignment(4);
        this.tMinTF_R = new JFormattedTextField(AFormat);
        this.tMinTF_R.setValue(DanasPreferences.getMinTempPost());
        this.tMinTF_R.setHorizontalAlignment(4);
        this.tMaxTF_R = new JFormattedTextField(AFormat);
        this.tMaxTF_R.setValue(DanasPreferences.getMaxTempPost());
        this.tMaxTF_R.setHorizontalAlignment(4);
        this.pMinAnt = DanasPreferences.getMinPressAnt();
        this.pMaxAnt = DanasPreferences.getMaxPressAnt();
        this.tMinAnt = DanasPreferences.getMinTempAnt();
        this.tMaxAnt = DanasPreferences.getMaxTempAnt();
        this.pMinPost = DanasPreferences.getMinPressPost();
        this.pMaxPost = DanasPreferences.getMaxPressPost();
        this.tMinPost = DanasPreferences.getMinTempPost();
        this.tMaxPost = DanasPreferences.getMaxTempPost();
        this.pMinTF_F.addActionListener(this);
        this.pMaxTF_F.addActionListener(this);
        this.tMinTF_F.addActionListener(this);
        this.tMaxTF_F.addActionListener(this);
        this.pMinTF_R.addActionListener(this);
        this.pMaxTF_R.addActionListener(this);
        this.tMinTF_R.addActionListener(this);
        this.tMaxTF_R.addActionListener(this);
        JLabel pmF = new JLabel(Language.string(" P. min Ant."));
        JLabel pMF = new JLabel(Language.string(" P. max Ant."));
        JLabel tmF = new JLabel(Language.string(" T. min Ant."));
        JLabel tMF = new JLabel(Language.string(" T. max Ant."));
        JLabel pmR = new JLabel(Language.string(" P. min Post."));
        JLabel pMR = new JLabel(Language.string(" P. max Post."));
        JLabel tmR = new JLabel(Language.string(" T. min Post."));
        JLabel tMR = new JLabel(Language.string(" T. max Post."));
        GridLayout intLayoutDx = new GridLayout(4, 4, 2, 2);
        JPanel internalPanelDx = new JPanel();
        internalPanelDx.setLayout(intLayoutDx);
        internalPanelDx.add(this.pMinTF_F);
        internalPanelDx.add(pmF);
        internalPanelDx.add(this.pMinTF_R);
        internalPanelDx.add(pmR);
        internalPanelDx.add(this.pMaxTF_F);
        internalPanelDx.add(pMF);
        internalPanelDx.add(this.pMaxTF_R);
        internalPanelDx.add(pMR);
        internalPanelDx.add(this.tMinTF_F);
        internalPanelDx.add(tmF);
        internalPanelDx.add(this.tMinTF_R);
        internalPanelDx.add(tmR);
        internalPanelDx.add(this.tMaxTF_F);
        internalPanelDx.add(tMF);
        internalPanelDx.add(this.tMaxTF_R);
        internalPanelDx.add(tMR);
        JPanel pannelloAllarmi = new JPanel(new BorderLayout());
        pannelloAllarmi.add((Component)internalPanelDx, "Center");
        pannelloAllarmi.add((Component)this.applicaB, "South");
        PanelBorderRight.add(pannelloAllarmi);
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.pressioniTF = new JTextField[24];
        this.temperatureTF = new JTextField[24];
        this.tensioniTF = new JTextField[24];
        this.pannelliSensori = new JPanel[24];
        this.conteggioAggiornamenti = new long[24];
        for (int i3 = 0; i3 < 24; ++i3) {
            this.pannelliSensori[i3] = new JPanel();
            this.pressioniTF[i3] = new JTextField(6);
            this.temperatureTF[i3] = new JTextField(6);
            this.tensioniTF[i3] = new JTextField(6);
            this.pressioniTF[i3].setFocusable(false);
            this.temperatureTF[i3].setFocusable(false);
            this.tensioniTF[i3].setFocusable(false);
            this.pressioniTF[i3].setEditable(false);
            this.temperatureTF[i3].setEditable(false);
            this.tensioniTF[i3].setEditable(false);
            Font font_etichetta = this.pressioniTF[i3].getFont().deriveFont(18.0f);
            this.pressioniTF[i3].setFont(font_etichetta);
            this.temperatureTF[i3].setFont(font_etichetta);
            this.tensioniTF[i3].setFont(font_etichetta);
            this.pressioniTF[i3].setHorizontalAlignment(4);
            this.temperatureTF[i3].setHorizontalAlignment(4);
            this.tensioniTF[i3].setHorizontalAlignment(4);
            JPanel interno = new JPanel();
            GridLayout internoLayout = new GridLayout(3, 1, 2, 2);
            interno.setLayout(internoLayout);
            interno.add(this.pressioniTF[i3]);
            interno.add(this.temperatureTF[i3]);
            interno.add(this.tensioniTF[i3]);
            this.pannelliSensori[i3].add(interno);
        }
        this.apriFile();
        this.aggiornaNomi(true);
        JPanel pannelloCentrale = new JPanel();
        GridLayout centraleLayout = new GridLayout(4, 6, 2, 2);
        pannelloCentrale.setLayout(centraleLayout);
        for (i = 0; i < 24; ++i) {
            pannelloCentrale.add(this.pannelliSensori[i]);
        }
        if (lista != null) {
            for (i = 0; i < lista.length; ++i) {
                this.sceltaCOM.addItem(lista[i]);
            }
            if (lista.length > 0) {
                this.sceltaCOM.setSelectedIndex(0);
            }
        }
        pannelloPrincipale.add((Component)pannelloConnessione, "North");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)pannellosotto, "South");
        this.pack();
        this.setSize(new Dimension(800, 730));
        this.sfondo = this.pressioniTF[0].getBackground();
    }

    public boolean preparaFile() {
        FileDialog fd = new FileDialog((Dialog)this, Language.string("Salva log sensori"), 1);
        fd.setFile("*.csv");
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return false;
        }
        String nome = fd.getFile();
        File f = new File(fd.getDirectory(), nome);
        if (!f.isAbsolute()) {
            f = new File(f.getAbsolutePath());
        }
        if (!f.exists() && f.getParentFile().exists() && f.getParentFile().isDirectory() && f.getParentFile().canWrite()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (f.exists() && !f.canWrite()) {
            JOptionPane.showMessageDialog(this, Language.string("Nome del file o percorso non valido"), Language.string("ATTENZIONE"), 0);
            return false;
        }
        try {
            this.fos = new FileOutputStream(f);
            this.streamScrittura = new PrintStream(this.fos);
            this.stampaintestazioneSuFile();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.streamScrittura = null;
            return false;
        }
        return true;
    }

    public void acquisisciContinuo() {
        String line = null;
        boolean ricevutoNulla = false;
        boolean aggiorna = false;
        while (this.connected) {
            ricevutoNulla = false;
            try {
                line = this.conn.readLineTPMS();
                if (line != null) {
                    this.analizzaFraseTpms(line);
                } else {
                    ricevutoNulla = true;
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE"), 0);
                this.disconnetti();
                break;
            }
            long tempoAttuale = System.currentTimeMillis();
            for (int i = 0; i < 24; ++i) {
                if (tempoAttuale - this.conteggioAggiornamenti[i] < 90000L) continue;
                this.valorePressioni[i] = -1.0;
                this.valoreTemperature[i] = -1.0;
                this.valoreTensioni[i] = -1.0;
                this.valoreSegnale[i] = 0.0;
                if (this.pannelliSensori[i].isEnabled()) {
                    this.pressioniTF[i].setText("--- bar");
                    this.temperatureTF[i].setText("--- \u00b0C");
                    if (this.mostraBatteria) {
                        this.tensioniTF[i].setText("--- %");
                    } else {
                        this.tensioniTF[i].setText("--- dBm");
                    }
                } else {
                    this.pressioniTF[i].setText("---");
                    this.temperatureTF[i].setText("---");
                    if (this.mostraBatteria) {
                        this.tensioniTF[i].setText("---");
                    } else {
                        this.tensioniTF[i].setText("---");
                    }
                }
                aggiorna = true;
            }
            if (!aggiorna) continue;
            this.controllaAllarmi();
        }
    }

    public void analizzaFraseTpms(String frase) {
        int press;
        int temp;
        int volt;
        int id;
        if (frase == null) {
            return;
        }
        if (!frase.startsWith("$TPMS")) {
            return;
        }
        int segn = 0;
        boolean parseIncompleto = false;
        double segnale = 0.0;
        boolean segnalePresente = false;
        if (this.debug) {
            System.out.println("frase letta:" + frase);
        }
        StringTokenizer st = new StringTokenizer(frase, ",");
        String t = st.nextToken();
        try {
            t = st.nextToken();
            if (t == null || t == "") {
                parseIncompleto = true;
            }
            id = Integer.parseInt(t);
            t = st.nextToken();
            if (t == null || t == "") {
                parseIncompleto = true;
            }
            int status = Integer.parseInt(t);
            t = st.nextToken();
            if (t == null || t == "") {
                parseIncompleto = true;
            }
            volt = Integer.parseInt(t);
            t = st.nextToken();
            if (t == null || t == "") {
                parseIncompleto = true;
            }
            temp = Integer.parseInt(t);
            t = st.nextToken();
            if (t == null || t == "") {
                parseIncompleto = true;
            }
            press = Integer.parseInt(t);
            t = "";
            if (st.hasMoreTokens()) {
                t = st.nextToken();
                segn = Integer.parseInt(t);
                segnalePresente = true;
            }
        }
        catch (Exception ex) {
            System.err.println("Errore nel parsing della frase tpms:" + frase);
            return;
        }
        double tensione = volt;
        double temperatura = (double)temp - 55.0;
        double pressione = (1.376 * (double)press + 98.624) / 100.0;
        segnale = (double)segn / 2.0 - 130.0;
        if (!segnalePresente) {
            segnale = 0.0;
        }
        if (this.ricercaInCorso) {
            if (!segnalePresente) {
                this.ricercaInCorso = false;
                this.searchB.setText(Language.string("Cerca"));
                JOptionPane.showMessageDialog(null, Language.string("Il ricevitore utilizzato non supporta questa funzione."), Language.string("Attenzione"), 2);
            } else if (segnale > -45.0) {
                this.ricercaInCorso = false;
                this.searchB.setText(Language.string("Cerca"));
                String s1 = String.format("%.2f bar", pressione - 1.0);
                String s2 = String.format("%.2f C\u00b0", temperatura);
                String s = Language.string("Trovato sensore ID: ") + id + Language.string("  PRESSIONE: ") + s1 + Language.string("  TEMPERATURA: ") + s2;
                JOptionPane.showMessageDialog(null, s, Language.string("Info"), 1);
            }
        }
        this.mostraDati(id, pressione - 1.0, temperatura, tensione, segnale);
    }

    public void connetti() {
        if (this.connected) {
            return;
        }
        this.ricercaInCorso = false;
        this.elencoId.clear();
        if (this.sceltaCOM.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(null, Language.string("Selezionare una porta"), Language.string("Attenzione"), 2);
            return;
        }
        this.sceltaCOM.setEnabled(false);
        try {
            this.aggiornaNomi(true);
            this.reseAllarmi();
            this.conn = new SerialConnection(this.elenco[this.sceltaCOM.getSelectedIndex()]);
            this.conn.open(5);
            this.conn.write("$E\r");
            this.conn.clear();
            this.conn.setTimeOut(1000);
            this.conn.write("q\r");
            String end = this.conn.readLine();
            if (end == null || !end.startsWith("Ready")) {
                this.conn.close();
                this.sceltaCOM.setEnabled(true);
                this.connected = false;
                JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return;
            }
            this.conn.write("$A\r");
            this.conn.write("$I\r");
            this.connettiB.setText(Language.string("Disconnetti"));
            this.startB.setEnabled(true);
            this.startB.setText("Start Log");
            this.modificaB.setEnabled(false);
            this.eliminaB.setEnabled(false);
            this.upB.setEnabled(false);
            this.dnB.setEnabled(false);
            this.searchB.setEnabled(true);
            this.segnaleB.setEnabled(true);
            this.connected = true;
            this.acquisitionThread = new Thread(){

                @Override
                public void run() {
                    TPMSDialog.this.acquisisciContinuo();
                }
            };
            this.acquisitionThread.setDaemon(true);
            this.acquisitionThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sceltaCOM.setEnabled(true);
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            JOptionPane.showMessageDialog(null, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
        }
    }

    public void disconnetti() {
        if (!this.connected) {
            return;
        }
        this.ricercaInCorso = false;
        if (this.streamScrittura != null) {
            this.streamScrittura.close();
            try {
                this.fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.streamScrittura = null;
        if (this.trovaSensore) {
            System.out.println("Trovati n. sensori:" + this.elencoId.size());
            Collections.sort(this.elencoId);
            for (int i = 0; i < this.elencoId.size(); ++i) {
                System.out.println("DEBUG: Trovato sensore:" + this.elencoId.get(i));
            }
        }
        try {
            this.connected = false;
            try {
                if (Thread.currentThread() != this.acquisitionThread) {
                    this.acquisitionThread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.conn.write("$E\r");
            this.conn.setTimeOut(10);
            this.conn.clear(1000);
            while (this.conn.readLine() != null) {
            }
            this.conn.close();
            this.sceltaCOM.setEnabled(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connettiB.setText(Language.string("Connetti"));
        this.startB.setEnabled(false);
        this.searchB.setEnabled(false);
        this.segnaleB.setEnabled(false);
        this.startB.setText("Start Log");
        this.modificaB.setEnabled(true);
        this.eliminaB.setEnabled(true);
        this.upB.setEnabled(true);
        this.dnB.setEnabled(true);
    }

    public void stampaValoriSuFile() {
        if (this.streamScrittura == null) {
            return;
        }
        String s = "";
        long tempo = System.currentTimeMillis();
        double time = (double)(tempo - this.tempoStart) / 1000.0;
        s = String.format("%.2f;", time);
        for (int i = 0; i < this.elencoSensori.size(); ++i) {
            double pressione = this.valorePressioni[i] != -1.0 ? this.valorePressioni[i] : 0.0;
            double temperatura = this.valoreTemperature[i] != -1.0 ? this.valoreTemperature[i] : 0.0;
            double tensione = this.valoreTensioni[i] != -1.0 ? this.valoreTensioni[i] : 0.0;
            double segnale = this.valoreSegnale[i] != 0.0 ? this.valoreSegnale[i] : 0.0;
            s = s + this.elencoSensori.get(i).getId() + ";";
            s = String.format("%s%.2f;", s, pressione);
            s = s + temperatura + ";" + tensione + ";" + segnale + ";";
        }
        this.streamScrittura.println(s);
    }

    public void stampaintestazioneSuFile() {
        if (this.streamScrittura == null) {
            return;
        }
        String s = "Time [s];";
        for (int i = 0; i < this.elencoSensori.size(); ++i) {
            s = s + this.elencoSensori.get(i).getNome() + "[id] ;Pressure [bar];Temperature [C] ;Voltage [%];Signal[dBm];";
        }
        this.streamScrittura.println(s);
    }

    public void cambiaViauslizzazione(boolean mostraBatteria) {
        for (int i = 0; i < 24; ++i) {
            String s = mostraBatteria ? (this.valoreTensioni[i] != -1.0 ? String.format("%.0f %%", this.valoreTensioni[i]) : (this.pannelliSensori[i].isEnabled() ? "--- %" : "---")) : (this.valoreSegnale[i] < 0.0 ? String.format("%.0f dBm", this.valoreSegnale[i]) : (this.pannelliSensori[i].isEnabled() ? "--- dBm" : "---"));
            this.tensioniTF[i].setText(s);
        }
        this.controllaAllarmi();
    }

    public void mostraDati(int id, double pressione, double temperatura, double tensione, double segnale) {
        boolean inElenco = false;
        for (int i = 0; i < this.elencoSensori.size(); ++i) {
            if (this.elencoSensori.get(i).getId() != id) continue;
            inElenco = true;
            String s = String.format("%.2f bar", pressione);
            this.pressioniTF[i].setText(s);
            s = String.format("%.2f C\u00b0", temperatura);
            this.temperatureTF[i].setText(s);
            s = this.mostraBatteria ? String.format("%.0f %%", tensione) : (segnale < 0.0 ? String.format("%.0f dBm", segnale) : "--- dBm");
            this.tensioniTF[i].setText(s);
            this.valoreTemperature[i] = temperatura;
            this.valorePressioni[i] = pressione;
            this.valoreTensioni[i] = tensione;
            this.valoreSegnale[i] = segnale;
            this.conteggioAggiornamenti[i] = System.currentTimeMillis();
            this.controllaAllarmi();
        }
        if (this.trovaSensore && pressione > 0.2) {
            System.out.println("DEBUG: Trovato sensore: " + id + " Temperatura=" + temperatura + "C Pressione=" + String.format("%.2f bar", pressione) + " Batteria=" + tensione + "% Segnale=" + segnale + "dBm");
        }
        if (inElenco) {
            this.stampaValoriSuFile();
        }
        boolean trovato = false;
        for (int i = 0; i < this.elencoId.size(); ++i) {
            if (this.elencoId.get(i) != id) continue;
            trovato = true;
        }
        if (!trovato) {
            this.elencoId.add(id);
        }
    }

    public void reseAllarmi() {
        for (int i = 0; i < 24; ++i) {
            this.pressioniTF[i].setBackground(this.sfondo);
            this.temperatureTF[i].setBackground(this.sfondo);
            this.tensioniTF[i].setBackground(this.sfondo);
        }
    }

    public void controllaAllarmi() {
        int numeroSensori = this.elencoSensori.size();
        for (int i = 0; i < 24; ++i) {
            this.pressioniTF[i].setBackground(this.sfondo);
            this.temperatureTF[i].setBackground(this.sfondo);
            this.tensioniTF[i].setBackground(this.sfondo);
            if (i >= numeroSensori || this.valorePressioni[i] == -1.0 || !this.connected) continue;
            if (this.mostraBatteria) {
                if (this.valoreTensioni[i] < 10.0) {
                    this.tensioniTF[i].setBackground(Color.red);
                }
            } else if (this.valoreSegnale[i] < -85.0) {
                this.tensioniTF[i].setBackground(Color.red);
            }
            if (this.elencoSensori.get(i).getAnteriore() && this.valorePressioni[i] > this.pMaxAnt) {
                this.pressioniTF[i].setBackground(Color.red);
            }
            if (!this.elencoSensori.get(i).getAnteriore() && this.valorePressioni[i] > this.pMaxPost) {
                this.pressioniTF[i].setBackground(Color.red);
            }
            if (this.elencoSensori.get(i).getAnteriore() && this.valorePressioni[i] < this.pMinAnt) {
                this.pressioniTF[i].setBackground(new Color(104, 172, 249));
            }
            if (!this.elencoSensori.get(i).getAnteriore() && this.valorePressioni[i] < this.pMinPost) {
                this.pressioniTF[i].setBackground(new Color(104, 172, 249));
            }
            if (this.elencoSensori.get(i).getAnteriore() && this.valoreTemperature[i] > this.tMaxAnt) {
                this.temperatureTF[i].setBackground(Color.red);
            }
            if (!this.elencoSensori.get(i).getAnteriore() && this.valoreTemperature[i] > this.tMaxPost) {
                this.temperatureTF[i].setBackground(Color.red);
            }
            if (this.elencoSensori.get(i).getAnteriore() && this.valoreTemperature[i] < this.tMinAnt) {
                this.temperatureTF[i].setBackground(new Color(104, 172, 249));
            }
            if (this.elencoSensori.get(i).getAnteriore() || !(this.valoreTemperature[i] < this.tMinPost)) continue;
            this.temperatureTF[i].setBackground(new Color(104, 172, 249));
        }
    }

    public void aggiornaNomi(boolean reset) {
        int i;
        for (i = 0; i < 24; ++i) {
            this.pannelliSensori[i].setBorder(BorderFactory.createTitledBorder("----"));
            this.pannelliSensori[i].setEnabled(false);
            this.pressioniTF[i].setEnabled(false);
            this.temperatureTF[i].setEnabled(false);
            this.tensioniTF[i].setEnabled(false);
            if (!reset) continue;
            this.pressioniTF[i].setText("---");
            this.temperatureTF[i].setText("---");
            if (this.mostraBatteria) {
                this.tensioniTF[i].setText("---");
            } else {
                this.tensioniTF[i].setText("---");
            }
            this.valorePressioni[i] = -1.0;
        }
        for (i = 0; i < this.elencoSensori.size(); ++i) {
            this.pannelliSensori[i].setEnabled(true);
            this.pressioniTF[i].setEnabled(true);
            this.temperatureTF[i].setEnabled(true);
            this.tensioniTF[i].setEnabled(true);
            this.pannelliSensori[i].setBorder(BorderFactory.createTitledBorder(this.getNomeSensoreCompleto(this.elencoSensori.get(i))));
            if (!reset) continue;
            this.pressioniTF[i].setText("--- bar");
            this.temperatureTF[i].setText("--- \u00b0C");
            if (this.mostraBatteria) {
                this.tensioniTF[i].setText("--- %");
            } else {
                this.tensioniTF[i].setText("--- dBm");
            }
            this.valorePressioni[i] = -1.0;
        }
    }

    public void rimuoviSensore(int index) {
        if (index != -1) {
            this.elencoSensori.remove(index);
            this.aggiornaLista();
            this.aggiornaNomi(true);
            this.reseAllarmi();
        }
    }

    public void aggiornaLista() {
        this.elencoSensoriLM.clear();
        for (int i = 0; i < this.elencoSensori.size(); ++i) {
            this.elencoSensoriLM.addElement(this.getStringaSensore(this.elencoSensori.get(i)));
        }
    }

    public String getStringaSensore(SensoreTPMS sens) {
        String s = sens.getNome() + "(" + sens.getId() + ")";
        return s;
    }

    public String getNomeSensoreCompleto(SensoreTPMS sens) {
        String posizione = sens.getAnteriore() ? "_F" : "_R";
        String s = sens.getNome() + posizione + " (" + sens.getId() + ")";
        return s;
    }

    public void modificaSensore(int index) {
        if (index == -1) {
            return;
        }
        String s = "" + this.elencoSensori.get(index).getId();
        this.idTF.setText(s);
        this.nomeTF.setText(this.elencoSensori.get(index).getNome());
        if (this.elencoSensori.get(index).getAnteriore()) {
            this.frontB.setSelected(true);
        } else {
            this.rearB.setSelected(true);
        }
        this.aggiornaNomi(false);
        this.controllaAllarmi();
    }

    public void aggiungiSensore() {
        int id = 0;
        for (int i = 0; i < 24; ++i) {
            this.valorePressioni[i] = -1.0;
            this.valoreTemperature[i] = -1.0;
            this.valoreTensioni[i] = -1.0;
            this.valoreSegnale[i] = 0.0;
        }
        boolean anteriore = this.frontB.isSelected();
        try {
            id = Integer.valueOf(this.idTF.getText());
        }
        catch (Exception i) {
            // empty catch block
        }
        String nome = this.nomeTF.getText();
        for (int i = 0; i < this.elencoSensori.size(); ++i) {
            if (this.elencoSensori.get(i).getId() != id) continue;
            this.rimuoviSensore(i);
        }
        SensoreTPMS set = new SensoreTPMS(id, nome, anteriore);
        this.elencoSensori.add(set);
        this.aggiornaLista();
        this.aggiornaNomi(true);
        this.controllaAllarmi();
    }

    public void apriFile() {
        File f = new File("./myTPMS.sen");
        this.elencoSensoriLM.clear();
        this.elencoSensori.removeAllElements();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                this.elencoSensori.add(new SensoreTPMS(line));
            }
            in.close();
            this.aggiornaLista();
            for (int i = 0; i < 24; ++i) {
                this.valorePressioni[i] = -1.0;
                this.valoreTemperature[i] = -1.0;
                this.valoreTensioni[i] = -1.0;
                this.valoreSegnale[i] = 0.0;
            }
        }
        catch (IOException ex) {
            System.out.println("DEBUG: nessun file myTPMS.sen o erore in lettura");
            ex.printStackTrace();
        }
    }

    public void saveFile() {
        File f = new File("./myTPMS.sen");
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            for (int i = 0; i < this.elencoSensori.size(); ++i) {
                out.println(this.elencoSensori.get(i).getStringa());
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void chiudiDialog() {
        if (this.connected) {
            this.disconnetti();
        }
        this.saveFile();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SensoreTPMS sens;
        int indice;
        if (e.getSource().equals(this.modificaB)) {
            this.aggiungiSensore();
        }
        if (e.getSource().equals(this.eliminaB)) {
            this.rimuoviSensore(this.list.getSelectedIndex());
        }
        if (e.getSource().equals(this.upB)) {
            if (this.list.getSelectedIndex() == -1) {
                return;
            }
            if (this.list.getSelectedIndex() == 0) {
                return;
            }
            indice = this.list.getSelectedIndex();
            sens = this.elencoSensori.elementAt(indice);
            this.elencoSensori.remove(indice);
            this.elencoSensori.add(indice - 1, sens);
            this.aggiornaLista();
            this.aggiornaNomi(true);
            this.controllaAllarmi();
            this.list.setSelectedIndex(indice - 1);
        }
        if (e.getSource().equals(this.dnB)) {
            if (this.list.getSelectedIndex() == -1) {
                return;
            }
            if (this.list.getSelectedIndex() == this.elencoSensori.size() - 1) {
                return;
            }
            indice = this.list.getSelectedIndex();
            sens = this.elencoSensori.elementAt(indice);
            this.elencoSensori.remove(indice);
            this.elencoSensori.add(indice + 1, sens);
            this.aggiornaLista();
            this.aggiornaNomi(true);
            this.controllaAllarmi();
            this.list.setSelectedIndex(indice + 1);
        }
        if (e.getSource().equals(this.connettiB)) {
            if (this.connected) {
                this.disconnetti();
            } else {
                this.connetti();
            }
        }
        if (e.getSource().equals(this.searchB)) {
            if (this.ricercaInCorso) {
                this.ricercaInCorso = false;
                this.searchB.setText(Language.string("Cerca"));
            } else {
                this.ricercaInCorso = true;
                this.searchB.setText(Language.string("Cerca..."));
            }
        }
        if (e.getSource().equals(this.segnaleB)) {
            if (this.mostraBatteria) {
                this.mostraBatteria = false;
                this.segnaleB.setText(Language.string("Potenza"));
                this.cambiaViauslizzazione(false);
            } else {
                this.mostraBatteria = true;
                this.segnaleB.setText(Language.string("Batteria"));
                this.cambiaViauslizzazione(true);
            }
        }
        if (e.getSource().equals(this.startB)) {
            if (this.streamScrittura == null) {
                if (this.preparaFile()) {
                    this.startB.setText("Stop Log");
                    this.tempoStart = System.currentTimeMillis();
                }
            } else {
                this.streamScrittura.close();
                this.startB.setText("Start Log");
                try {
                    this.fos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.streamScrittura = null;
            }
        }
        if (e.getSource().equals(this.applicaB)) {
            try {
                Double res1 = Double.valueOf(this.pMinTF_F.getText());
                Double res2 = Double.valueOf(this.pMaxTF_F.getText());
                Double res3 = Double.valueOf(this.tMinTF_F.getText());
                Double res4 = Double.valueOf(this.tMaxTF_F.getText());
                Double res5 = Double.valueOf(this.pMinTF_R.getText());
                Double res6 = Double.valueOf(this.pMaxTF_R.getText());
                Double res7 = Double.valueOf(this.tMinTF_R.getText());
                Double res8 = Double.valueOf(this.tMaxTF_R.getText());
                this.pMinAnt = res1;
                this.pMaxAnt = res2;
                this.tMinAnt = res3;
                this.tMaxAnt = res4;
                this.pMinPost = res5;
                this.pMaxPost = res6;
                this.tMinPost = res7;
                this.tMaxPost = res8;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, Language.string("Controllare i valori immessi"), Language.string("Attenzione"), 2);
            }
            this.controllaAllarmi();
            this.applicaB.setEnabled(false);
            DanasPreferences.setMinPressAnt(this.pMinAnt);
            DanasPreferences.setMaxPressAnt(this.pMaxAnt);
            DanasPreferences.setMinTempAnt(this.tMinAnt);
            DanasPreferences.setMaxTempAnt(this.tMaxAnt);
            DanasPreferences.setMinPressPost(this.pMinPost);
            DanasPreferences.setMaxPressPost(this.pMaxPost);
            DanasPreferences.setMinTempPost(this.tMinPost);
            DanasPreferences.setMaxTempPost(this.tMaxPost);
        }
        if (e.getSource().equals(this.pMinTF_F) || e.getSource().equals(this.pMaxTF_F) || e.getSource().equals(this.tMinTF_F) || e.getSource().equals(this.tMaxTF_F) || e.getSource().equals(this.pMinTF_R) || e.getSource().equals(this.pMaxTF_R) || e.getSource().equals(this.tMinTF_R) || e.getSource().equals(this.tMaxTF_R)) {
            this.applicaB.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (this.list.getSelectedIndex() != -1) {
            this.modificaSensore(this.list.getSelectedIndex());
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.connected) {
            this.disconnetti();
        }
        this.saveFile();
        this.padre.setTPMSChiusa();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TPMSDialog t = new TPMSDialog(null, null);
        t.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        System.out.println("premuto");
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

