/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.Dialog.DefaultCellRendererTC;
import i2m.Language;
import i2m.MainFrame;
import i2m.mappa.Mappa2D;
import i2m.onLine.DeviceConnection;
import i2m.traguardi.Circuit;
import i2m.traguardi.SalvaCircuitoDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class TCDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton inviaButton;
    private JButton leggiButton;
    private JButton esciButton;
    private JButton salvaButton;
    private MainFrame padre;
    private JComboBox sensibilitaCB;
    private JComboBox DOPCB;
    private JTable tabellaSensibilita;
    private Mappa2D mappaGPS;
    private String[] listaSensibilitaRelativa = new String[]{"-5", "-4", "-3", "-2", "-1", "0", "+1", "+2", "+3", "+4", "+5"};
    private int numeroSettori = 0;
    private DeviceConnection conn;
    private Circuit circuito;
    private DefaultCellRendererTC renderer;
    private boolean letturaEffettuata = false;
    private boolean registrazioneAttiva = false;
    JProgressBar progressBarInvio;
    int DopMinima = 20;

    public TCDialog(MainFrame owner, Mappa2D mappa, boolean registrare, int dop) {
        super(owner, Language.string("Setting TC"), true);
        this.padre = owner;
        this.mappaGPS = mappa;
        this.numeroSettori = this.mappaGPS.getNSplit();
        this.DopMinima = dop;
        JPanel pannelloBottoni = new JPanel();
        this.inviaButton = new JButton(Language.string("Invia a TC"));
        this.inviaButton.addActionListener(this);
        this.leggiButton = new JButton(Language.string("Leggi da TC"));
        this.leggiButton.addActionListener(this);
        this.esciButton = new JButton(Language.string("Esci"));
        this.esciButton.addActionListener(this);
        this.salvaButton = new JButton(Language.string("Salva circuito"));
        this.salvaButton.addActionListener(this);
        pannelloBottoni.add(this.leggiButton);
        pannelloBottoni.add(this.inviaButton);
        pannelloBottoni.add(this.salvaButton);
        pannelloBottoni.add(this.esciButton);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        class TableModelTC
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private String[] columnNames = new String[]{Language.string("Settore"), Language.string("Sensibilit\u00e0 relativa")};
            private Object[][] stiliMappa1 = new Object[][]{{"Settore1:     (Traguardo-Split1)", "0"}, {"Settore2:       (Split1-Split2)", "0"}, {"Settore3:       (Split2-Split3)", "0"}, {"Settore4:       (Split3-Split4)", "0"}, {"Settore5:       (Split4-Split5)", "0"}, {"Settore6:       (Split5-Split6)", "0"}, {"Settore7:       (Split6-Split7)", "0"}, {"Settore8:       (Split7-Split8)", "0"}, {"Settore9:       (Split8-Split9)", "0"}, {"Settore10:       (Split9-Split10)", "0"}, {"Settore11:       (Split10-Split11)", "0"}, {"Settore12:       (Split11-Split12)", "0"}, {"Settore13:       (Split12-Split13)", "0"}, {"Settore14:       (Split13-Split14)", "0"}, {"Settore15:       (Split14-Split15)", "0"}, {"Settore16:       (Split15-Split16)", "0"}, {"Settore17:       (Split16-Split17)", "0"}, {"Settore18:       (Split17-Split18)", "0"}, {"Settore19:       (Split18-Split19)", "0"}, {"Settore20:       (Split19-Split20)", "0"}, {"Settore21:       (Split20-Split21)", "0"}, {"Settore22:       (Split21-Split22)", "0"}, {"Settore23:       (Split22-Split23)", "0"}, {"Settore24:       (Split23-Split24)", "0"}, {"Settore25:       (Split24-Split25)", "0"}, {"Settore26:       (Split25-Split26)", "0"}, {"Settore27:       (Split26-Split27)", "0"}, {"Settore28:       (Split27-Split28)", "0"}, {"Settore29:       (Split28-Split29)", "0"}, {"Settore30:       (Split29-Split30)", "0"}};

            TableModelTC() {
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public int getRowCount() {
                return this.stiliMappa1.length;
            }

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                return this.stiliMappa1[row][col];
            }

            public Class<? extends Object> getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 0;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                this.stiliMappa1[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
        }
        this.tabellaSensibilita = new JTable(new TableModelTC());
        this.tabellaSensibilita.getTableHeader().setReorderingAllowed(false);
        this.tabellaSensibilita.setFillsViewportHeight(true);
        this.tabellaSensibilita.setSelectionBackground(Color.WHITE);
        this.tabellaSensibilita.setRowHeight(18);
        this.renderer = new DefaultCellRendererTC(true, this.numeroSettori);
        this.tabellaSensibilita.setDefaultRenderer(Object.class, this.renderer);
        this.tabellaSensibilita.setBorder(BorderFactory.createLineBorder(Color.black));
        this.tabellaSensibilita.getTableHeader().setBorder(BorderFactory.createLineBorder(Color.black));
        this.tabellaSensibilita.setPreferredScrollableViewportSize(new Dimension(50, 50));
        this.tabellaSensibilita.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(this.tabellaSensibilita);
        scrollPane.setVerticalScrollBarPolicy(22);
        TableColumn colonna = this.tabellaSensibilita.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>(this.listaSensibilitaRelativa);
        colonna.setCellEditor(new DefaultCellEditor(comboBox));
        JPanel sceltaSensibilitaPanel = new JPanel();
        sceltaSensibilitaPanel.setLayout(new BoxLayout(sceltaSensibilitaPanel, 0));
        JLabel message1Label = new JLabel(Language.string("Reegistrazione delle traiettorie:"));
        String[] listaSensibilita = new String[]{"Registrazione Attiva", "Registrazione NON attiva"};
        this.sensibilitaCB = new JComboBox<String>(listaSensibilita);
        this.sensibilitaCB.setMinimumSize(new Dimension(190, 20));
        this.sensibilitaCB.setPreferredSize(new Dimension(190, 20));
        this.sensibilitaCB.setMaximumSize(new Dimension(190, 20));
        if (registrare) {
            this.sensibilitaCB.setSelectedIndex(0);
        } else {
            this.sensibilitaCB.setSelectedIndex(1);
        }
        sceltaSensibilitaPanel.add(Box.createRigidArea(new Dimension(10, 40)));
        sceltaSensibilitaPanel.add(message1Label);
        sceltaSensibilitaPanel.add(Box.createRigidArea(new Dimension(45, 0)));
        sceltaSensibilitaPanel.add(this.sensibilitaCB);
        sceltaSensibilitaPanel.setAlignmentX(0.5f);
        JPanel sceltaDOP = new JPanel();
        sceltaDOP.setLayout(new BoxLayout(sceltaDOP, 0));
        JLabel message2Label = new JLabel(Language.string("Potenza minima segnale GPS:"));
        String[] listaDOP = new String[]{"Ideale", "Eccellente", "Buona", "Moderata", "Debole"};
        this.DOPCB = new JComboBox<String>(listaDOP);
        this.DOPCB.setMinimumSize(new Dimension(190, 20));
        this.DOPCB.setPreferredSize(new Dimension(190, 20));
        this.DOPCB.setMaximumSize(new Dimension(190, 20));
        this.DOPCB.setSelectedIndex(1);
        sceltaDOP.add(Box.createRigidArea(new Dimension(10, 40)));
        sceltaDOP.add(message2Label);
        sceltaDOP.add(Box.createRigidArea(new Dimension(50, 0)));
        sceltaDOP.add(this.DOPCB);
        sceltaDOP.setAlignmentX(0.5f);
        switch (this.DopMinima) {
            case 10: {
                this.DOPCB.setSelectedIndex(0);
                break;
            }
            case 20: {
                this.DOPCB.setSelectedIndex(1);
                break;
            }
            case 50: {
                this.DOPCB.setSelectedIndex(2);
                break;
            }
            case 100: {
                this.DOPCB.setSelectedIndex(3);
                break;
            }
            case 200: {
                this.DOPCB.setSelectedIndex(4);
                break;
            }
            default: {
                this.DOPCB.setSelectedIndex(4);
            }
        }
        JPanel pannelloOpzioni = new JPanel();
        pannelloOpzioni.setLayout(new BoxLayout(pannelloOpzioni, 1));
        pannelloOpzioni.add(sceltaDOP);
        pannelloOpzioni.add(Box.createRigidArea(new Dimension(5, 0)));
        pannelloOpzioni.add(sceltaSensibilitaPanel);
        JPanel pannelloSotto = new JPanel(new BorderLayout());
        pannelloSotto.add((Component)pannelloOpzioni, "North");
        pannelloSotto.add(Box.createRigidArea(new Dimension(0, 0)), "Center");
        pannelloSotto.add((Component)pannelloBottoni, "South");
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloMessaggio = new JPanel();
        pannelloMessaggio.setLayout(new BoxLayout(pannelloMessaggio, 1));
        JLabel messageLabel = new JLabel(Language.string("Segliere la sensibilit\u00e0 desiderata per ciascun settore del tracciato."));
        messageLabel.setAlignmentX(0.5f);
        pannelloMessaggio.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloMessaggio.add(messageLabel);
        pannelloMessaggio.add(Box.createRigidArea(new Dimension(0, 10)));
        pannelloPrincipale.add((Component)pannelloMessaggio, "North");
        JPanel pannelloCentrale = new JPanel();
        pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
        JPanel pannelloScelte = new JPanel();
        pannelloScelte.setLayout(new BoxLayout(pannelloScelte, 1));
        pannelloCentrale.add(Box.createRigidArea(new Dimension(30, 0)));
        pannelloCentrale.add(this.tabellaSensibilita.getTableHeader());
        pannelloCentrale.add(scrollPane);
        pannelloPrincipale.add(Box.createRigidArea(new Dimension(40, 40)), "East");
        pannelloPrincipale.add(Box.createRigidArea(new Dimension(40, 40)), "West");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)pannelloSotto, "South");
        this.setContentPane(pannelloPrincipale);
        this.setSize(new Dimension(500, 380));
        this.setResizable(false);
        this.aggiornaTabella();
    }

    public void aggiornaTabella() {
        Circuit circuito = this.mappaGPS.esportaTraguardi();
        int numeroAttraversamenti = circuito != null ? circuito.numeroAttraversamenti() : -1;
        for (int i = 0; i < numeroAttraversamenti; ++i) {
            int sens = circuito.getAttraversamento(i).getSensibilita();
            this.tabellaSensibilita.setValueAt(this.listaSensibilitaRelativa[sens + 5], i, 1);
        }
        this.repaint();
    }

    public void abilitaTasti(boolean abilita) {
        this.inviaButton.setEnabled(abilita);
        this.leggiButton.setEnabled(abilita);
        this.esciButton.setEnabled(abilita);
        this.salvaButton.setEnabled(abilita);
    }

    private void scriviDaTC(Circuit c) {
        this.abilitaTasti(false);
        this.circuito = c;
        this.conn = new DeviceConnection(DanasPreferences.getPrefCom());
        System.out.println("apro connessione su porta " + DanasPreferences.getPrefCom());
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JDialog f1 = new JDialog((Dialog)TCDialog.this, Language.string("ATTENZIONE!"));
                URL ImgUrl = this.getClass().getResource("/pix/icon_warning.png");
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel("      "));
                panel.add(new JLabel(new ImageIcon(ImgUrl)));
                panel.add(new JLabel("      "));
                panel.add(new JLabel("<html>" + Language.string("Invio impostazioni in corso") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                panel.add(new JLabel("      "));
                JPanel pannelloCentrale = new JPanel();
                pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                f1.setContentPane(pannelloCentrale);
                pannelloCentrale.add(new JLabel("    "));
                pannelloCentrale.add(panel);
                pannelloCentrale.add(new JLabel("    "));
                TCDialog.this.progressBarInvio = new JProgressBar(0, 100);
                TCDialog.this.progressBarInvio.setIndeterminate(true);
                TCDialog.this.progressBarInvio.setMaximumSize(new Dimension(330, 40));
                pannelloCentrale.add(TCDialog.this.progressBarInvio);
                pannelloCentrale.add(new JLabel("    "));
                f1.pack();
                f1.setLocationRelativeTo(null);
                f1.setAlwaysOnTop(true);
                f1.setVisible(true);
                f1.setResizable(false);
                int DopMinima = 50;
                try {
                    TCDialog.this.conn.connect(4);
                    TCDialog.this.setVisible(true);
                    boolean attivaRegistrazione = TCDialog.this.sensibilitaCB.getSelectedIndex() == 0;
                    switch (TCDialog.this.DOPCB.getSelectedIndex()) {
                        case 0: {
                            DopMinima = 10;
                            break;
                        }
                        case 1: {
                            DopMinima = 20;
                            break;
                        }
                        case 2: {
                            DopMinima = 50;
                            break;
                        }
                        case 3: {
                            DopMinima = 100;
                            break;
                        }
                        case 4: {
                            DopMinima = 200;
                        }
                    }
                    TCDialog.this.progressBarInvio.setIndeterminate(false);
                    TCDialog.this.conn.inviaCircuito(TCDialog.this.circuito, attivaRegistrazione, DopMinima, TCDialog.this.progressBarInvio);
                    TCDialog.this.conn.setDownloadProgress(100);
                    f1.setVisible(false);
                    TCDialog.this.conn.disconnectTc();
                    System.out.println("disconnesso");
                }
                catch (Exception e) {
                    f1.setVisible(false);
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(TCDialog.this, Language.string("Errore di connessione: impossibile creare la connessione"), Language.string("ATTENZIONE"), 0);
                    TCDialog.this.requestFocus();
                    return;
                }
                finally {
                    f1.setVisible(false);
                    TCDialog.this.setVisible(true);
                    System.out.println("finita la connessione");
                    try {
                        TCDialog.this.conn.disconnectTc();
                    }
                    catch (IOException e) {
                        System.out.println("Doppia sconnessione...");
                        e.printStackTrace();
                    }
                    TCDialog.this.abilitaTasti(true);
                }
            }
        }.start();
        this.requestFocus();
        this.setVisible(true);
    }

    public void chiudi() {
        this.dispose();
    }

    public boolean lettoDaTC() {
        return this.letturaEffettuata;
    }

    public Circuit getCircuitoLetto() {
        return this.circuito;
    }

    public boolean isRegistrazioneAttiva() {
        return this.registrazioneAttiva;
    }

    public int getDopMinima() {
        return this.DopMinima;
    }

    private void leggiDaTC() {
        this.abilitaTasti(false);
        this.mappaGPS.mostraVersi(false);
        this.conn = new DeviceConnection(DanasPreferences.getPrefCom());
        System.out.println("apro connessione su porta " + DanasPreferences.getPrefCom());
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JDialog f1 = new JDialog((Dialog)TCDialog.this, Language.string("ATTENZIONE!"));
                URL ImgUrl = this.getClass().getResource("/pix/icon_warning.png");
                new JButton(new ImageIcon(ImgUrl));
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(new JLabel("      "));
                panel.add(new JLabel(new ImageIcon(ImgUrl)));
                panel.add(new JLabel("      "));
                panel.add(new JLabel("<html>" + Language.string("Il sistema sta verificando le porte COM disponibili") + ".<br>" + Language.string("L'operazione potrebbe richiedere qualche minuto") + "<br></html>"));
                panel.add(new JLabel("      "));
                JPanel pannelloCentrale = new JPanel();
                pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
                f1.setContentPane(pannelloCentrale);
                pannelloCentrale.add(new JLabel("    "));
                pannelloCentrale.add(panel);
                pannelloCentrale.add(new JLabel("    "));
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                progressBar.setMaximumSize(new Dimension(330, 40));
                pannelloCentrale.add(progressBar);
                pannelloCentrale.add(new JLabel("    "));
                f1.pack();
                f1.setLocationRelativeTo(null);
                f1.setAlwaysOnTop(true);
                f1.setVisible(true);
                f1.setResizable(false);
                try {
                    TCDialog.this.conn.connect(4);
                    f1.setVisible(false);
                    TCDialog.this.setVisible(true);
                    TCDialog.this.circuito = TCDialog.this.conn.LeggiCircuito();
                    if (TCDialog.this.conn.isRegistrazioneAttiva()) {
                        TCDialog.this.registrazioneAttiva = true;
                    } else {
                        TCDialog.this.registrazioneAttiva = false;
                    }
                    System.out.printf("registrazione attiva=" + TCDialog.this.conn.isRegistrazioneAttiva(), new Object[0]);
                    TCDialog.this.DopMinima = TCDialog.this.conn.getDopMinima();
                    System.out.println("letta DOP=" + TCDialog.this.DopMinima);
                    switch (TCDialog.this.DopMinima) {
                        case 10: {
                            TCDialog.this.DOPCB.setSelectedIndex(0);
                            break;
                        }
                        case 20: {
                            TCDialog.this.DOPCB.setSelectedIndex(1);
                            break;
                        }
                        case 50: {
                            TCDialog.this.DOPCB.setSelectedIndex(2);
                            break;
                        }
                        case 100: {
                            TCDialog.this.DOPCB.setSelectedIndex(3);
                            break;
                        }
                        case 200: {
                            TCDialog.this.DOPCB.setSelectedIndex(4);
                            break;
                        }
                        default: {
                            TCDialog.this.DOPCB.setSelectedIndex(4);
                        }
                    }
                    TCDialog.this.conn.disconnectTc();
                    System.out.println("disconnesso");
                }
                catch (Exception e) {
                    f1.setVisible(false);
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(TCDialog.this, Language.string("Errore di connessione: impossibile creare la connessione"), Language.string("ATTENZIONE"), 0);
                    TCDialog.this.requestFocus();
                    return;
                }
                finally {
                    f1.setVisible(false);
                    TCDialog.this.setVisible(true);
                    TCDialog.this.letturaEffettuata = true;
                    TCDialog.this.chiudi();
                    System.out.println("finita la connessione");
                    try {
                        TCDialog.this.conn.disconnectTc();
                    }
                    catch (IOException e) {
                        System.out.println("Doppia sconnessione...");
                        e.printStackTrace();
                    }
                    TCDialog.this.abilitaTasti(true);
                    TCDialog.this.renderer.setNumeroSettori(TCDialog.this.mappaGPS.getNSplit());
                    TCDialog.this.aggiornaTabella();
                }
            }
        }.start();
        this.requestFocus();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String s;
        int i;
        int numeroAttraversamenti;
        Circuit circuito;
        if (evt.getSource() == this.esciButton) {
            this.dispose();
        }
        if (evt.getSource() == this.inviaButton) {
            circuito = this.mappaGPS.esportaTraguardi();
            numeroAttraversamenti = 0;
            if (circuito != null) {
                numeroAttraversamenti = circuito.numeroAttraversamenti();
            }
            for (i = 0; i < numeroAttraversamenti; ++i) {
                s = (String)this.tabellaSensibilita.getValueAt(i, 1);
                if (s.startsWith("+")) {
                    s = s.substring(1);
                }
                circuito.getAttraversamento(i).setSensibilita(Integer.valueOf(s));
            }
            this.scriviDaTC(circuito);
        }
        if (evt.getSource() == this.leggiButton) {
            this.abilitaTasti(false);
            this.leggiDaTC();
        }
        if (evt.getSource() == this.salvaButton) {
            circuito = this.mappaGPS.esportaTraguardi();
            if (circuito == null) {
                return;
            }
            numeroAttraversamenti = circuito.numeroAttraversamenti();
            for (i = 0; i < numeroAttraversamenti; ++i) {
                s = (String)this.tabellaSensibilita.getValueAt(i, 1);
                if (s.startsWith("+")) {
                    s = s.substring(1);
                }
                circuito.getAttraversamento(i).setSensibilita(Integer.valueOf(s));
            }
            SalvaCircuitoDialog d = new SalvaCircuitoDialog((Frame)this.padre, circuito);
            d.setLocationRelativeTo(null);
            d.setVisible(true);
        }
    }

    public static void main(String[] args) {
    }
}

