/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.ColorRenderer;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.MyDefaultCellRendererStat;
import i2m.Dialog.TableRowStat;
import i2m.Language;
import i2m.MainFrame;
import i2m.SincronizzatoreMappaGraficoVideo;
import i2m.grafico.SincronizzatoreGrafico;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class StatisticheDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JTable table;
    MyTableModel model;
    JScrollPane scrollPane;
    Vector<TableRowStat> elencoRighe = new Vector();
    JPanel tablePanel;
    MainFrame padre;
    int selectedRow = 1;
    int selectedColumn = -1;
    SincronizzatoreMappaGraficoVideo multiSincro = null;
    private SincronizzatoreGrafico sincro = null;
    double valoreAsse;

    public StatisticheDialog(MainFrame owner) {
        super((Frame)owner, Language.string("Statistiche Giro/Sess default") + " [v]");
        this.padre = owner;
        this.setDefaultCloseOperation(0);
        this.model = new MyTableModel();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setFillsViewportHeight(false);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultRenderer(Object.class, new MyDefaultCellRendererStat(true));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(65);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(this.table.getTableHeader());
        this.tablePanel.add(this.table);
        this.scrollPane = new JScrollPane(this.tablePanel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean modificato = false;
                if (SwingUtilities.isLeftMouseButton(e) && StatisticheDialog.this.table.getRowCount() > 0) {
                    int row = StatisticheDialog.this.table.rowAtPoint(e.getPoint());
                    int col = StatisticheDialog.this.table.columnAtPoint(e.getPoint());
                    int indiceCampo = StatisticheDialog.this.getElencoRighe().get(row).getNumeroCanale();
                    DanasDataStructureConstants.ValueType vt = MeasuresUtil.getValueType(indiceCampo);
                    if ((row != StatisticheDialog.this.selectedRow || col != StatisticheDialog.this.selectedColumn) && StatisticheDialog.this.selectedRow != -1 && StatisticheDialog.this.selectedColumn != -1) {
                        DanasDataStructureConstants.ValueType oldVt = MeasuresUtil.getValueType(StatisticheDialog.this.getElencoRighe().get(StatisticheDialog.this.selectedRow).getNumeroCanale());
                        if (StatisticheDialog.this.selectedColumn == 2) {
                            DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().mostraMaxMinAvg(oldVt, false, 2);
                        }
                        if (StatisticheDialog.this.selectedColumn == 3) {
                            DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().mostraMaxMinAvg(oldVt, false, 1);
                        }
                        if (StatisticheDialog.this.selectedColumn == 4) {
                            DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().mostraMaxMinAvg(oldVt, false, 0);
                        }
                        StatisticheDialog.this.selectedRow = -1;
                        StatisticheDialog.this.selectedColumn = -1;
                        modificato = true;
                    }
                    if (row < StatisticheDialog.this.getElencoRighe().size() - 8 && col >= 2) {
                        StatisticheDialog.this.selectedRow = row;
                        StatisticheDialog.this.selectedColumn = col;
                        double posizione = -1.0;
                        if (col == 2) {
                            posizione = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().mostraMaxMinAvg(vt, true, 2);
                        }
                        if (col == 3) {
                            posizione = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().mostraMaxMinAvg(vt, true, 1);
                        }
                        if (col == 4) {
                            DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().mostraMaxMinAvg(vt, true, 0);
                        }
                        if (posizione != -1.0) {
                            double newMax;
                            double newMin;
                            double delta;
                            StatisticheDialog.this.valoreAsse = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getModoSpazio() ? DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().convertiTempoInSpazio(posizione) : posizione;
                            StatisticheDialog.this.multiSincro.setPosizioneCursore(posizione);
                            StatisticheDialog.this.multiSincro.setAggiornaPosizioneCursore(true);
                            if (StatisticheDialog.this.valoreAsse < StatisticheDialog.this.sincro.getMin()) {
                                delta = StatisticheDialog.this.sincro.getMax() - StatisticheDialog.this.sincro.getMin();
                                newMin = StatisticheDialog.this.valoreAsse - delta / 2.0;
                                newMax = newMin + delta;
                                StatisticheDialog.this.sincro.setMin(newMin);
                                StatisticheDialog.this.sincro.setMax(newMax);
                                StatisticheDialog.this.sincro.setAggiornaAsse(true);
                            }
                            if (StatisticheDialog.this.valoreAsse > StatisticheDialog.this.sincro.getMax()) {
                                delta = StatisticheDialog.this.sincro.getMax() - StatisticheDialog.this.sincro.getMin();
                                newMin = StatisticheDialog.this.valoreAsse - delta / 2.0;
                                newMax = newMin + delta;
                                StatisticheDialog.this.sincro.setMin(newMin);
                                StatisticheDialog.this.sincro.setMax(newMax);
                                StatisticheDialog.this.sincro.setAggiornaAsse(true);
                            }
                        }
                        modificato = false;
                        DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getGraficoCampo(indiceCampo).refresh();
                    }
                    if (modificato) {
                        DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getGraficoCampo(indiceCampo).refresh();
                    }
                }
            }
        });
        this.add(this.scrollPane);
        this.setMinimumSize(new Dimension(160, 80));
        this.pack();
        this.setFocusableWindowState(false);
    }

    public void setMultiSincro(SincronizzatoreMappaGraficoVideo multi) {
        this.multiSincro = multi;
    }

    public void setSincro(SincronizzatoreGrafico sync) {
        this.sincro = sync;
    }

    public void aggiorna() {
        this.model.fireTableDataChanged();
    }

    public void addRiga(TableRowStat riga) {
        this.model.addRow(riga);
        this.elencoRighe.add(riga);
        this.refresh();
    }

    public void svuota() {
        this.model.rimuoviTutto();
        this.elencoRighe.clear();
    }

    public void rimuoviTutto() {
        this.model.rimuoviTutto();
        this.elencoRighe.clear();
        this.setSize(new Dimension(200, 0));
    }

    public Vector<TableRowStat> getElencoRighe() {
        return this.elencoRighe;
    }

    public void setValore(int indiceRiga, String dato) {
        this.elencoRighe.get(indiceRiga).setMin(dato);
    }

    public void setValore(int indiceRiga, String min, String max, String avg) {
        this.elencoRighe.get(indiceRiga).setMin(min);
        this.elencoRighe.get(indiceRiga).setMax(max);
        this.elencoRighe.get(indiceRiga).setMedia(avg);
    }

    public void setValore(int indiceRiga, String nome, String min, String max, String avg) {
        this.elencoRighe.get(indiceRiga).setNome(nome);
        this.elencoRighe.get(indiceRiga).setMin(min);
        this.elencoRighe.get(indiceRiga).setMax(max);
        this.elencoRighe.get(indiceRiga).setMedia(avg);
    }

    public void refresh() {
        this.aggiorna();
        this.pack();
    }

    public static void main(String[] args) {
        StatisticheDialog i = new StatisticheDialog(null);
        i.setVisible(true);
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        Vector<String> columnNames = new Vector();
        private Vector<TableRowStat> datiInfo = new Vector();

        public MyTableModel() {
            this.columnNames.add("");
            this.columnNames.add(Language.string("Canale"));
            this.columnNames.add(Language.string("Min"));
            this.columnNames.add(Language.string("Max"));
            this.columnNames.add(Language.string("Media"));
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.datiInfo.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.datiInfo.get(row).getCampo(col);
        }

        public Class<? extends Object> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.datiInfo.get(row).setCampo(value, col);
            this.fireTableCellUpdated(row, col);
        }

        public void addRow(TableRowStat riga) {
            this.datiInfo.add(riga);
        }

        public TableRowStat getRow(int indice) {
            return this.datiInfo.get(indice);
        }

        public void rimuoviTutto() {
            this.datiInfo.clear();
        }
    }
}

