/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Language;
import i2m.MainFrame;
import i2m.onLine.SerialConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class QsDialog
extends JDialog
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private JComboBox sceltaCOM = null;
    private JComboBox sceltaFsr1;
    private JComboBox sceltaFsr2;
    private JComboBox sceltaVersoGlobal;
    private JComboBox sceltaVerso1;
    private JComboBox sceltaVerso2;
    private JComboBox tipoMoto;
    private JComboBox filtroCB;
    private JComboBox zeroCB;
    private JButton connettiB;
    private JButton leggiB;
    private JButton scriviB;
    private JButton continuoB;
    private JButton zeroB;
    private String[] elenco = null;
    private SerialConnection conn;
    private boolean connected = false;
    private JPanel pannelloTasti;
    private int versione = 1;
    private int versioneH = 1;
    private Thread acquisitionThread;
    private boolean acquisisciContinuo = false;
    private JLabel labelGain1;
    private JLabel labelGain2;
    private boolean debug = false;
    private final int CUSTOM = 0;
    private final int DUCATI_V4 = 1;
    private final int R1_18 = 2;
    private final int BMW_19 = 3;
    private final int RSV4_18 = 4;
    private final int ZX10R = 5;
    private final int NORMAL = 0;
    private final int SWITCH = 1;
    private final int BMW = 2;

    public QsDialog(MainFrame owner, String[] lista) {
        super(owner, Language.string("Quick Shifter sensor configurator"), false);
        this.addWindowListener(this);
        this.elenco = lista;
        this.sceltaCOM = new JComboBox();
        this.sceltaCOM.setFocusable(false);
        this.connettiB = new JButton(Language.string("Connetti   "));
        this.connettiB.addActionListener(this);
        this.sceltaCOM.setMinimumSize(new Dimension(120, 25));
        this.sceltaCOM.setPreferredSize(new Dimension(120, 25));
        this.sceltaCOM.setMaximumSize(new Dimension(120, 25));
        this.connettiB.setMinimumSize(new Dimension(80, 25));
        this.connettiB.setMaximumSize(new Dimension(80, 25));
        this.connettiB.setFocusable(false);
        JLabel l = new JLabel(Language.string("Porta cavo programmazione:"));
        JPanel pannelloConnessione = new JPanel();
        pannelloConnessione.add(l);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.sceltaCOM);
        pannelloConnessione.add(Box.createRigidArea(new Dimension(10, 30)));
        pannelloConnessione.add(this.connettiB);
        String[] elencoGain = new String[]{"200N", "250N", "300N", "400N", "500N", "800N", "1000N"};
        this.sceltaFsr1 = new JComboBox<String>(elencoGain);
        this.sceltaFsr1.addActionListener(this);
        this.sceltaFsr1.setFocusable(false);
        this.sceltaFsr1.setMinimumSize(new Dimension(800, 25));
        this.sceltaFsr1.setPreferredSize(new Dimension(80, 25));
        this.sceltaFsr1.setMaximumSize(new Dimension(80, 25));
        this.sceltaFsr1.setSelectedIndex(0);
        this.sceltaFsr2 = new JComboBox<String>(elencoGain);
        this.sceltaFsr2.addActionListener(this);
        this.sceltaFsr2.setFocusable(false);
        this.sceltaFsr2.setMinimumSize(new Dimension(800, 25));
        this.sceltaFsr2.setPreferredSize(new Dimension(80, 25));
        this.sceltaFsr2.setMaximumSize(new Dimension(80, 25));
        this.sceltaFsr2.setSelectedIndex(0);
        String[] elencoVersi = new String[]{Language.string("Positivo in compressione"), Language.string("Positivo in estensione")};
        this.sceltaVersoGlobal = new JComboBox<String>(elencoVersi);
        this.sceltaVersoGlobal.addActionListener(this);
        this.sceltaVersoGlobal.setFocusable(false);
        this.sceltaVersoGlobal.setMinimumSize(new Dimension(800, 25));
        this.sceltaVersoGlobal.setPreferredSize(new Dimension(80, 25));
        this.sceltaVersoGlobal.setMaximumSize(new Dimension(80, 25));
        this.sceltaVersoGlobal.setSelectedIndex(0);
        this.sceltaVerso1 = new JComboBox<String>(elencoVersi);
        this.sceltaVerso1.addActionListener(this);
        this.sceltaVerso1.setFocusable(false);
        this.sceltaVerso1.setMinimumSize(new Dimension(800, 25));
        this.sceltaVerso1.setPreferredSize(new Dimension(80, 25));
        this.sceltaVerso1.setMaximumSize(new Dimension(80, 25));
        this.sceltaVerso1.setSelectedIndex(0);
        this.sceltaVerso2 = new JComboBox<String>(elencoVersi);
        this.sceltaVerso2.addActionListener(this);
        this.sceltaVerso2.setFocusable(false);
        this.sceltaVerso2.setMinimumSize(new Dimension(800, 25));
        this.sceltaVerso2.setPreferredSize(new Dimension(80, 25));
        this.sceltaVerso2.setMaximumSize(new Dimension(80, 25));
        this.sceltaVerso2.setSelectedIndex(0);
        String[] elencoMoto = new String[]{"Custom", "Ducati V4", "Yamaha R1 18-24", "BMW 19-24", "RSV4 18-20", "ZX10R 16-24"};
        this.tipoMoto = new JComboBox<String>(elencoMoto);
        this.tipoMoto.addActionListener(this);
        this.tipoMoto.setFocusable(false);
        this.tipoMoto.setMinimumSize(new Dimension(150, 25));
        this.tipoMoto.setPreferredSize(new Dimension(150, 25));
        this.tipoMoto.setMaximumSize(new Dimension(150, 25));
        JLabel labelMoto = new JLabel(Language.string(" Modello moto"));
        this.labelGain1 = new JLabel(Language.string(" Fondo scala uscita 1"));
        this.labelGain2 = new JLabel(Language.string(" Fondo scala uscita 2"));
        JLabel labelVersoGlobal = new JLabel(Language.string(" Direzione globale"));
        JLabel labelVerso1 = new JLabel(Language.string(" Direzione uscita 1"));
        JLabel labelVerso2 = new JLabel(Language.string(" Direzione uscita 2"));
        String[] elencoFiltri = new String[]{"OFF", "Low", "Medium", "High"};
        this.filtroCB = new JComboBox<String>(elencoFiltri);
        this.filtroCB.addActionListener(this);
        this.filtroCB.setFocusable(false);
        this.filtroCB.setMinimumSize(new Dimension(800, 25));
        this.filtroCB.setPreferredSize(new Dimension(80, 25));
        this.filtroCB.setMaximumSize(new Dimension(80, 25));
        this.filtroCB.setSelectedIndex(0);
        JLabel labelFiltro = new JLabel(Language.string(" Filtro"));
        String[] elencoZero = new String[]{Language.string("Manuale"), Language.string("Automatico all'accensione")};
        this.zeroCB = new JComboBox<String>(elencoZero);
        this.zeroCB.addActionListener(this);
        this.zeroCB.setFocusable(false);
        this.zeroCB.setMinimumSize(new Dimension(800, 25));
        this.zeroCB.setPreferredSize(new Dimension(80, 25));
        this.zeroCB.setMaximumSize(new Dimension(80, 25));
        this.zeroCB.setSelectedIndex(0);
        JLabel labelZero = new JLabel(Language.string(" Zero"));
        JPanel pannelloMoto = new JPanel(new BorderLayout());
        GridLayout motoLayot = new GridLayout(1, 2, 2, 2);
        pannelloMoto.setLayout(motoLayot);
        pannelloMoto.setBorder(BorderFactory.createTitledBorder(Language.string("Tipo di moto")));
        pannelloMoto.add(labelMoto);
        pannelloMoto.add(this.tipoMoto);
        JPanel pannelloFiltro = new JPanel(new BorderLayout());
        pannelloFiltro.setLayout(new GridLayout(1, 2, 2, 2));
        pannelloFiltro.setBorder(BorderFactory.createTitledBorder(Language.string("Filtro uscita")));
        pannelloFiltro.add(labelFiltro);
        pannelloFiltro.add(this.filtroCB);
        JPanel pannelloZero = new JPanel(new BorderLayout());
        pannelloZero.setLayout(new GridLayout(1, 2, 2, 2));
        pannelloZero.setBorder(BorderFactory.createTitledBorder(Language.string("Valore iniziale")));
        pannelloZero.add(labelZero);
        pannelloZero.add(this.zeroCB);
        JPanel pannelloScelteGain = new JPanel();
        GridLayout scelteLayot1 = new GridLayout(2, 2, 2, 2);
        GridLayout scelteLayot2 = new GridLayout(3, 2, 2, 2);
        pannelloScelteGain.setLayout(scelteLayot1);
        pannelloScelteGain.setBorder(BorderFactory.createTitledBorder(Language.string("Sensibilit\u00e0 sensore")));
        pannelloScelteGain.add(this.labelGain1);
        pannelloScelteGain.add(this.sceltaFsr1);
        pannelloScelteGain.add(this.labelGain2);
        pannelloScelteGain.add(this.sceltaFsr2);
        JPanel pannelloScelteVerso = new JPanel();
        pannelloScelteVerso.setLayout(scelteLayot2);
        pannelloScelteVerso.setBorder(BorderFactory.createTitledBorder(Language.string("Direzione")));
        pannelloScelteVerso.add(labelVersoGlobal);
        pannelloScelteVerso.add(this.sceltaVersoGlobal);
        pannelloScelteVerso.add(labelVerso1);
        pannelloScelteVerso.add(this.sceltaVerso1);
        pannelloScelteVerso.add(labelVerso2);
        pannelloScelteVerso.add(this.sceltaVerso2);
        JPanel pannelloCentrale = new JPanel(new BorderLayout());
        JPanel pannelloInterno = new JPanel(new BorderLayout());
        pannelloInterno.add((Component)pannelloScelteVerso, "North");
        pannelloInterno.add((Component)pannelloFiltro, "Center");
        pannelloInterno.add((Component)pannelloZero, "South");
        pannelloCentrale.add((Component)pannelloMoto, "North");
        pannelloCentrale.add((Component)pannelloScelteGain, "Center");
        pannelloCentrale.add((Component)pannelloInterno, "South");
        this.leggiB = new JButton(Language.string("Leggi"));
        this.leggiB.addActionListener(this);
        this.scriviB = new JButton(Language.string("Scrivi"));
        this.scriviB.addActionListener(this);
        this.continuoB = new JButton(Language.string("Acquisisci"));
        this.continuoB.addActionListener(this);
        this.zeroB = new JButton(Language.string("Zero"));
        this.zeroB.addActionListener(this);
        this.scriviB.setEnabled(false);
        this.leggiB.setEnabled(false);
        this.zeroB.setEnabled(false);
        this.continuoB.setEnabled(false);
        this.pannelloTasti = new JPanel();
        this.pannelloTasti.setBorder(BorderFactory.createTitledBorder(Language.string("Hardware settings - Vers SW: --- Vers HW: ---")));
        this.pannelloTasti.add(this.leggiB);
        this.pannelloTasti.add(this.scriviB);
        this.pannelloTasti.add(this.zeroB);
        if (this.debug) {
            this.pannelloTasti.add(this.continuoB);
        }
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        pannelloPrincipale.add((Component)pannelloConnessione, "North");
        pannelloPrincipale.add((Component)new JLabel("  "), "East");
        pannelloPrincipale.add((Component)new JLabel("  "), "West");
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        pannelloPrincipale.add((Component)this.pannelloTasti, "South");
        if (this.elenco != null) {
            for (int i = 0; i < this.elenco.length; ++i) {
                this.sceltaCOM.addItem(lista[i]);
            }
            if (this.elenco.length > 0) {
                this.sceltaCOM.setSelectedIndex(0);
            }
        }
        this.tipoMoto.setSelectedIndex(0);
        this.impostaMotoCustom(true);
        this.pack();
    }

    public void acquisisciContinuo() {
        String line = null;
        while (this.connected) {
            block5: {
                try {
                    if (!this.acquisisciContinuo) break block5;
                    line = this.conn.readLine();
                    System.out.println("Ricevuto frase:" + line);
                    if (line != null) break block5;
                    boolean bl = true;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, Language.string("Il sistema remoto non risponde,controllare la connessione"), Language.string("ATTENZIONE -2"), 0);
                    this.disconnetti();
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean inviaZero() {
        try {
            this.conn.write("$Z\r");
            String end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto post zero:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            JOptionPane.showMessageDialog(this, Language.string("Zero effettuato"), Language.string("Info"), 1);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean inviaImpostazioni() {
        int g1 = 100;
        int g2 = 100;
        int off1 = 0;
        int off2 = 0;
        int moto = 0;
        if (this.debug) {
            System.out.println("----- Trasmissione ----");
        }
        if (this.tipoMoto.getSelectedIndex() != 0) {
            this.sceltaVerso1.setSelectedIndex(this.sceltaVersoGlobal.getSelectedIndex());
            this.sceltaVerso2.setSelectedIndex(this.sceltaVersoGlobal.getSelectedIndex());
        }
        switch (this.sceltaFsr1.getSelectedIndex()) {
            case 0: {
                g1 = 500;
                break;
            }
            case 1: {
                g1 = 400;
                break;
            }
            case 2: {
                g1 = 333;
                break;
            }
            case 3: {
                g1 = 250;
                break;
            }
            case 4: {
                g1 = 200;
                break;
            }
            case 5: {
                g1 = 125;
                break;
            }
            case 6: {
                g1 = 100;
                break;
            }
            default: {
                g1 = 100;
            }
        }
        switch (this.sceltaFsr2.getSelectedIndex()) {
            case 0: {
                g2 = 500;
                break;
            }
            case 1: {
                g2 = 400;
                break;
            }
            case 2: {
                g2 = 333;
                break;
            }
            case 3: {
                g2 = 250;
                break;
            }
            case 4: {
                g2 = 200;
                break;
            }
            case 5: {
                g2 = 125;
                break;
            }
            case 6: {
                g2 = 100;
                break;
            }
            default: {
                g2 = 100;
            }
        }
        if (this.sceltaVerso1.getSelectedIndex() == 0) {
            g1 = -g1;
        }
        if (this.sceltaVerso2.getSelectedIndex() == 0) {
            g2 = -g2;
        }
        moto = this.tipoMoto.getSelectedIndex();
        if (this.debug) {
            System.out.println("G1=" + g1 + " G2=" + g2);
        }
        try {
            this.conn.write("$WD,001," + g1 + "\r");
            String end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,001," + g1 + "\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 001:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            if (this.tipoMoto.getSelectedIndex() == 0) {
                this.conn.write("$WD,002," + g1 + "\r");
                if (this.debug) {
                    System.out.println("Scrivo:$WD,002," + g1 + "\r");
                }
            } else {
                this.conn.write("$WD,002," + g2 + "\r");
                if (this.debug) {
                    System.out.println("Scrivo:$WD,002," + g2 + "\r");
                }
            }
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto 002:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,003," + off1 + "\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,003," + off1 + "\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 002:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,004," + g2 + "\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,004," + g2 + "\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 004:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,005," + g2 + "\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,005," + g2 + "\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 005:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,006," + off2 + "\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,006," + off2 + "\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 006:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,007," + moto + "\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,007," + moto + "\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 007:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,008," + this.filtroCB.getSelectedIndex() + "\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,008," + this.filtroCB.getSelectedIndex() + "\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 008:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,014," + this.zeroCB.getSelectedIndex() + "\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,014," + this.zeroCB.getSelectedIndex() + "\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 014:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            this.conn.write("$WD,018,2276\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$WD,018,2276\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto 018:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            switch (this.tipoMoto.getSelectedIndex()) {
                case 3: {
                    this.conn.write("$WD,025,2\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,025,2\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 025:" + end);
                    }
                    if (end == null || !end.startsWith("Ready")) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                        return false;
                    }
                    this.conn.write("$WD,021,455\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,021,455\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 021:" + end);
                    }
                    if (end == null || !end.startsWith("Ready")) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                        return false;
                    }
                    this.conn.write("$WD,022,4096\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,022,4096\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 022:" + end);
                    }
                    if (end == null || !end.startsWith("Ready")) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                        return false;
                    }
                    this.conn.write("$WD,019,1138\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,019,1138\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 019:" + end);
                    }
                    if (end != null && end.startsWith("Ready")) break;
                    this.disconnetti();
                    JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    return false;
                }
                case 4: {
                    this.conn.write("$WD,025,1\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,025,1\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 025:" + end);
                    }
                    if (end == null || !end.startsWith("Ready")) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                        return false;
                    }
                    this.conn.write("$WD,021,1511\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,021,1511\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 021:" + end);
                    }
                    if (end == null || !end.startsWith("Ready")) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                        return false;
                    }
                    this.conn.write("$WD,022,3058\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,022,3058\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 022:" + end);
                    }
                    if (end == null || !end.startsWith("Ready")) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                        return false;
                    }
                    this.conn.write("$WD,019,2276\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,019,2276\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 019:" + end);
                    }
                    if (end != null && end.startsWith("Ready")) break;
                    this.disconnetti();
                    JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    return false;
                }
                default: {
                    this.conn.write("$WD,025,0\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,025,0\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 025:" + end);
                    }
                    if (end == null || !end.startsWith("Ready")) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                        return false;
                    }
                    this.conn.write("$WD,019,2276\r");
                    end = this.conn.readLine();
                    if (this.debug) {
                        System.out.println("Scrivo:$WD,019,2276\r");
                    }
                    if (this.debug) {
                        System.out.println("Ricevuto 019:" + end);
                    }
                    if (end != null && end.startsWith("Ready")) break;
                    this.disconnetti();
                    JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    return false;
                }
            }
            this.conn.write("$U\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Scrivo:$U\r");
            }
            if (this.debug) {
                System.out.println("Ricevuto dopo Update:" + end);
            }
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            JOptionPane.showMessageDialog(this, Language.string("Impostazioni inviate"), Language.string("Info"), 1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public long estraiValoreRicevuto(String line) {
        if (line == null) {
            return 1L;
        }
        if (!line.startsWith("$RD")) {
            return 2L;
        }
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        try {
            t = st.nextToken();
            t = st.nextToken();
            long res = Long.parseLong(t);
            return res;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public boolean riceviImpostazioni() {
        boolean errore = false;
        int motoLetta = 0;
        try {
            if (this.debug) {
                System.out.println("----- Ricezione ----");
            }
            double tempoInizio = System.currentTimeMillis();
            this.conn.write("$RD,007\r");
            String end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 007:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            long valore = this.estraiValoreRicevuto(end);
            if (valore < 0L) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 1");
                }
            } else {
                switch ((int)valore) {
                    case 0: {
                        this.tipoMoto.setSelectedIndex(0);
                        motoLetta = 0;
                        break;
                    }
                    case 1: {
                        this.tipoMoto.setSelectedIndex(1);
                        motoLetta = 1;
                        break;
                    }
                    case 2: {
                        this.tipoMoto.setSelectedIndex(2);
                        motoLetta = 2;
                        break;
                    }
                    case 3: {
                        this.tipoMoto.setSelectedIndex(3);
                        motoLetta = 3;
                        break;
                    }
                    case 4: {
                        this.tipoMoto.setSelectedIndex(4);
                        motoLetta = 4;
                        break;
                    }
                    case 5: {
                        this.tipoMoto.setSelectedIndex(5);
                        motoLetta = 5;
                        break;
                    }
                    default: {
                        errore = true;
                        if (!this.debug) break;
                        System.out.println("Errore 2");
                    }
                }
            }
            if (motoLetta == 0) {
                this.impostaMotoCustom(true);
            } else {
                this.impostaMotoCustom(false);
            }
            this.conn.write("$RD,001\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 001:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            this.sceltaFsr1.setSelectedIndex(0);
            if (valore < 0L) {
                this.sceltaVerso1.setSelectedIndex(0);
            } else {
                this.sceltaVerso1.setSelectedIndex(1);
            }
            if (motoLetta != 0) {
                if (valore < 0L) {
                    this.sceltaVersoGlobal.setSelectedIndex(0);
                } else {
                    this.sceltaVersoGlobal.setSelectedIndex(1);
                }
            }
            if (Math.abs(valore) == 500L) {
                this.sceltaFsr1.setSelectedIndex(0);
            }
            if (Math.abs(valore) == 400L) {
                this.sceltaFsr1.setSelectedIndex(1);
            }
            if (Math.abs(valore) == 333L) {
                this.sceltaFsr1.setSelectedIndex(2);
            }
            if (Math.abs(valore) == 250L) {
                this.sceltaFsr1.setSelectedIndex(3);
            }
            if (Math.abs(valore) == 200L) {
                this.sceltaFsr1.setSelectedIndex(4);
            }
            if (Math.abs(valore) == 125L) {
                this.sceltaFsr1.setSelectedIndex(5);
            }
            if (Math.abs(valore) == 100L) {
                this.sceltaFsr1.setSelectedIndex(6);
            }
            if (Math.abs(valore) != 500L && Math.abs(valore) != 400L && Math.abs(valore) != 333L && Math.abs(valore) != 250L && Math.abs(valore) != 200L && Math.abs(valore) != 125L && Math.abs(valore) != 100L) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 3");
                }
            }
            this.conn.write("$RD,002\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 002:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            long valore1 = this.estraiValoreRicevuto(end);
            if (valore != valore1 && motoLetta == 0) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 4");
                }
            }
            this.conn.write("$RD,003\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 003:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            if (valore != 0L) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 5");
                }
            }
            this.conn.write("$RD,004\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 004:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            if (motoLetta != 0) {
                this.conn.write("$RD,002\r");
                end = this.conn.readLine();
                if (end == null || !end.startsWith("$RD")) {
                    this.disconnetti();
                    JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    return false;
                }
            }
            valore = this.estraiValoreRicevuto(end);
            this.sceltaFsr2.setSelectedIndex(0);
            if (valore < 0L) {
                this.sceltaVerso2.setSelectedIndex(0);
            } else {
                this.sceltaVerso2.setSelectedIndex(1);
            }
            if (Math.abs(valore) == 500L) {
                this.sceltaFsr2.setSelectedIndex(0);
            }
            if (Math.abs(valore) == 400L) {
                this.sceltaFsr2.setSelectedIndex(1);
            }
            if (Math.abs(valore) == 333L) {
                this.sceltaFsr2.setSelectedIndex(2);
            }
            if (Math.abs(valore) == 250L) {
                this.sceltaFsr2.setSelectedIndex(3);
            }
            if (Math.abs(valore) == 200L) {
                this.sceltaFsr2.setSelectedIndex(4);
            }
            if (Math.abs(valore) == 125L) {
                this.sceltaFsr2.setSelectedIndex(5);
            }
            if (Math.abs(valore) == 100L) {
                this.sceltaFsr2.setSelectedIndex(6);
            }
            if (Math.abs(valore) != 500L && Math.abs(valore) != 400L && Math.abs(valore) != 333L && Math.abs(valore) != 250L && Math.abs(valore) != 200L && Math.abs(valore) != 125L && Math.abs(valore) != 100L) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 6");
                }
            }
            this.conn.write("$RD,005\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 005:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore1 = this.estraiValoreRicevuto(end);
            if (valore != valore1) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 7");
                }
            }
            this.conn.write("$RD,006\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 006:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            if (valore != 0L) {
                errore = true;
            }
            this.conn.write("$RD,008\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 008:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            if (valore < 0L) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 8");
                }
            } else {
                switch ((int)valore) {
                    case 0: {
                        this.filtroCB.setSelectedIndex(0);
                        break;
                    }
                    case 1: {
                        this.filtroCB.setSelectedIndex(1);
                        break;
                    }
                    case 2: {
                        this.filtroCB.setSelectedIndex(2);
                        break;
                    }
                    case 3: {
                        this.filtroCB.setSelectedIndex(3);
                        break;
                    }
                    default: {
                        errore = true;
                        if (!this.debug) break;
                        System.out.println("Errore 9");
                    }
                }
            }
            this.conn.write("$RD,014\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 014:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            if (valore < 0L) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 10");
                }
            } else {
                switch ((int)valore) {
                    case 0: {
                        this.zeroCB.setSelectedIndex(0);
                        break;
                    }
                    case 1: {
                        this.zeroCB.setSelectedIndex(1);
                        break;
                    }
                    default: {
                        errore = true;
                        if (!this.debug) break;
                        System.out.println("Errore 11");
                    }
                }
            }
            this.conn.write("$RD,018\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 018:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            if (valore != 2276L) {
                errore = true;
                if (this.debug) {
                    System.out.println("Errore 19");
                }
            }
            long valore0 = 0L;
            long valoreIniziale = 0L;
            this.conn.write("$RD,025\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 025:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore0 = this.estraiValoreRicevuto(end);
            this.conn.write("$RD,021\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 021:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore = this.estraiValoreRicevuto(end);
            this.conn.write("$RD,022\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 022:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valore1 = this.estraiValoreRicevuto(end);
            this.conn.write("$RD,019\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 019:" + end);
            }
            if (end == null || !end.startsWith("$RD")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return false;
            }
            valoreIniziale = this.estraiValoreRicevuto(end);
            switch (this.tipoMoto.getSelectedIndex()) {
                case 3: {
                    if (valore0 != 2L) {
                        errore = true;
                        if (this.debug) {
                            System.out.println("Errore 12");
                        }
                    }
                    if (valore != 455L) {
                        errore = true;
                        if (this.debug) {
                            System.out.println("Errore 13");
                        }
                    }
                    if (valore1 != 4096L) {
                        errore = true;
                        if (this.debug) {
                            System.out.println("Errore 14");
                        }
                    }
                    if (valoreIniziale == 1138L) break;
                    errore = true;
                    if (!this.debug) break;
                    System.out.println("Errore 20");
                    break;
                }
                case 4: {
                    if (valore0 != 1L) {
                        errore = true;
                        if (this.debug) {
                            System.out.println("Errore 15");
                        }
                    }
                    if (valore != 1511L) {
                        errore = true;
                        if (this.debug) {
                            System.out.println("Errore 16");
                        }
                    }
                    if (valore1 != 3058L) {
                        errore = true;
                        if (this.debug) {
                            System.out.println("Errore 17");
                        }
                    }
                    if (valoreIniziale == 2276L) break;
                    errore = true;
                    if (!this.debug) break;
                    System.out.println("Errore 20");
                    break;
                }
                default: {
                    if (valore0 != 0L) {
                        errore = true;
                        if (this.debug) {
                            System.out.println("Errore 18");
                        }
                    }
                    if (valoreIniziale == 2276L) break;
                    errore = true;
                    if (!this.debug) break;
                    System.out.println("Errore 20");
                }
            }
            JOptionPane.showMessageDialog(this, Language.string("Impostazioni ricevute"), Language.string("Info"), 1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (errore) {
            JOptionPane.showMessageDialog(this, Language.string("I Dati risultano corrotti, riscrivere le impostazioni"), Language.string("Attenzione"), 2);
            return false;
        }
        return true;
    }

    void impostaMotoCustom(boolean attiva) {
        if (attiva) {
            if (this.debug) {
                System.out.println("Imposto moto custom");
            }
            this.sceltaVersoGlobal.setEnabled(false);
            this.sceltaVerso1.setEnabled(true);
            this.sceltaVerso2.setEnabled(true);
        } else {
            if (this.debug) {
                System.out.println("Imposto moto standard");
            }
            this.sceltaVersoGlobal.setEnabled(true);
            this.sceltaVerso1.setEnabled(false);
            this.sceltaVerso2.setEnabled(false);
        }
    }

    public void connetti() {
        if (this.connected) {
            return;
        }
        if (this.sceltaCOM.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, Language.string("Selezionare una porta"), Language.string("Attenzione"), 2);
            return;
        }
        this.sceltaCOM.setEnabled(false);
        try {
            double tempoInizio = System.currentTimeMillis();
            this.conn = new SerialConnection(this.elenco[this.sceltaCOM.getSelectedIndex()]);
            if (this.debug) {
                System.out.println("Log:Tempo post creazione:" + ((double)System.currentTimeMillis() - tempoInizio) / 1000.0);
            }
            this.conn.open(5);
            if (this.debug) {
                System.out.println("Log:Tempo post apertura:" + ((double)System.currentTimeMillis() - tempoInizio) / 1000.0);
            }
            this.conn.clear(100);
            System.out.println("Log:Tempo post clear:" + ((double)System.currentTimeMillis() - tempoInizio) / 1000.0);
            this.conn.write("\r");
            String end = this.conn.readLine();
            this.conn.clear(100);
            this.conn.write("\r");
            end = this.conn.readLine();
            this.conn.setTimeOut(1000);
            this.conn.write("\r");
            end = this.conn.readLine();
            if (end == null || !end.startsWith("Ready")) {
                this.disconnetti();
                JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                return;
            }
            this.connettiB.setText(Language.string("Disconnetti"));
            this.scriviB.setEnabled(true);
            this.leggiB.setEnabled(true);
            this.zeroB.setEnabled(true);
            this.continuoB.setEnabled(true);
            this.connected = true;
            this.conn.write("$V\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto $V:" + end);
            }
            System.out.println("Log:Tempo post read Versione:" + ((double)System.currentTimeMillis() - tempoInizio) / 1000.0);
            this.versione = this.estraiVersione(end);
            this.conn.write("$RD,020\r");
            end = this.conn.readLine();
            if (this.debug) {
                System.out.println("Ricevuto RD 020:" + end);
            }
            this.versioneH = (int)this.estraiValoreRicevuto(end);
            this.pannelloTasti.setBorder(BorderFactory.createTitledBorder(Language.string("Hardware settings - Vers SW: ") + this.versione + " Vers HW: " + this.versioneH));
            this.riceviImpostazioni();
            this.pack();
            if (this.debug) {
                this.acquisitionThread = new Thread(){

                    @Override
                    public void run() {
                        QsDialog.this.acquisisciContinuo();
                    }
                };
                this.acquisitionThread.setDaemon(true);
                this.acquisitionThread.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sceltaCOM.setEnabled(true);
            JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
        }
    }

    public void disconnetti() {
        this.sceltaCOM.setEnabled(true);
        try {
            this.connected = false;
            this.pannelloTasti.setBorder(BorderFactory.createTitledBorder(Language.string("Hardware settings - Vers SW: --- Vers HW: ---")));
            this.versione = 1;
            this.versioneH = 1;
            this.conn.write("$E\r");
            if (this.acquisisciContinuo) {
                this.conn.write("$S\r");
            }
            this.conn.setTimeOut(10);
            this.conn.clear(1000);
            while (this.conn.readLine() != null) {
            }
            this.conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connettiB.setText(Language.string("Connetti   "));
        this.scriviB.setEnabled(false);
        this.leggiB.setEnabled(false);
        this.continuoB.setEnabled(false);
        this.zeroB.setEnabled(false);
    }

    public boolean inviaId() {
        return true;
    }

    public boolean riceviId() {
        return true;
    }

    public boolean inviaCan() {
        return true;
    }

    public int estraiVersione(String line) {
        if (line == null) {
            return 1;
        }
        if (!line.startsWith("$VER")) {
            return 1;
        }
        StringTokenizer st = new StringTokenizer(line, ",");
        String t = st.nextToken();
        try {
            t = st.nextToken();
            int res = Integer.parseInt(t);
            return res;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public void chiudiDialog() {
        if (this.connected) {
            this.disconnetti();
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.connettiB)) {
            if (this.connected) {
                this.disconnetti();
            } else {
                this.connetti();
            }
        }
        if (e.getSource().equals(this.tipoMoto)) {
            this.sceltaFsr1.removeAllItems();
            this.sceltaFsr1.addItem("200N");
            this.sceltaFsr1.addItem("250N");
            this.sceltaFsr1.addItem("300N");
            this.sceltaFsr1.addItem("400N");
            this.sceltaFsr1.addItem("500N");
            this.sceltaFsr1.addItem("800N");
            this.sceltaFsr1.addItem("1000N");
            this.sceltaFsr2.removeAllItems();
            this.sceltaFsr2.addItem("200N");
            this.sceltaFsr2.addItem("250N");
            this.sceltaFsr2.addItem("300N");
            this.sceltaFsr2.addItem("400N");
            this.sceltaFsr2.addItem("500N");
            this.sceltaFsr2.addItem("800N");
            this.sceltaFsr2.addItem("1000N");
            this.labelGain1.setText(Language.string(" Fondo scala uscita 1"));
            this.labelGain2.setText(Language.string(" Fondo scala uscita 2"));
            if (this.tipoMoto.getSelectedIndex() == 0) {
                this.impostaMotoCustom(true);
                this.sceltaFsr1.setSelectedIndex(6);
                this.sceltaFsr2.setSelectedIndex(6);
                this.sceltaVerso1.setSelectedIndex(0);
                this.sceltaVerso2.setSelectedIndex(0);
                this.filtroCB.setSelectedIndex(2);
            } else {
                this.impostaMotoCustom(false);
                this.labelGain2.setText(Language.string(" Fondo scala compressione"));
                this.labelGain1.setText(Language.string(" Fondo scala estensione"));
                switch (this.tipoMoto.getSelectedIndex()) {
                    case 1: {
                        this.sceltaVersoGlobal.removeAllItems();
                        this.sceltaVersoGlobal.addItem(Language.string("Invertito"));
                        this.sceltaVersoGlobal.addItem(Language.string("Originale"));
                        this.sceltaVersoGlobal.setSelectedIndex(1);
                        this.sceltaFsr1.setSelectedIndex(5);
                        this.sceltaFsr2.setSelectedIndex(5);
                        this.filtroCB.setSelectedIndex(2);
                        this.zeroCB.setSelectedIndex(1);
                        break;
                    }
                    case 2: {
                        this.sceltaVersoGlobal.removeAllItems();
                        this.sceltaVersoGlobal.addItem(Language.string("Originale"));
                        this.sceltaVersoGlobal.addItem(Language.string("Invertito"));
                        this.sceltaVersoGlobal.setSelectedIndex(0);
                        this.sceltaFsr1.setSelectedIndex(1);
                        this.sceltaFsr2.setSelectedIndex(1);
                        this.filtroCB.setSelectedIndex(2);
                        this.zeroCB.setSelectedIndex(1);
                        break;
                    }
                    case 3: {
                        this.labelGain2.setText(Language.string(" Soglia in compressione"));
                        this.labelGain1.setText(Language.string(" Soglia in estensione"));
                        this.sceltaFsr1.removeAllItems();
                        this.sceltaFsr1.addItem("100N");
                        this.sceltaFsr1.addItem("125N");
                        this.sceltaFsr1.addItem("150N");
                        this.sceltaFsr1.addItem("200N");
                        this.sceltaFsr1.addItem("250N");
                        this.sceltaFsr1.addItem("400N");
                        this.sceltaFsr1.addItem("500N");
                        this.sceltaFsr2.removeAllItems();
                        this.sceltaFsr2.addItem("100N");
                        this.sceltaFsr2.addItem("125N");
                        this.sceltaFsr2.addItem("150N");
                        this.sceltaFsr2.addItem("200N");
                        this.sceltaFsr2.addItem("250N");
                        this.sceltaFsr2.addItem("400N");
                        this.sceltaFsr2.addItem("500N");
                        this.sceltaVersoGlobal.removeAllItems();
                        this.sceltaVersoGlobal.addItem(Language.string("Invertito"));
                        this.sceltaVersoGlobal.addItem(Language.string("Originale"));
                        this.sceltaVersoGlobal.setSelectedIndex(1);
                        this.sceltaFsr1.setSelectedIndex(3);
                        this.sceltaFsr2.setSelectedIndex(3);
                        this.filtroCB.setSelectedIndex(2);
                        this.zeroCB.setSelectedIndex(1);
                        break;
                    }
                    case 4: {
                        this.labelGain2.setText(Language.string(" Soglia in compressione"));
                        this.labelGain1.setText(Language.string(" Soglia in estensione"));
                        this.sceltaFsr1.removeAllItems();
                        this.sceltaFsr1.addItem("100N");
                        this.sceltaFsr1.addItem("125N");
                        this.sceltaFsr1.addItem("150N");
                        this.sceltaFsr1.addItem("200N");
                        this.sceltaFsr1.addItem("250N");
                        this.sceltaFsr1.addItem("400N");
                        this.sceltaFsr1.addItem("500N");
                        this.sceltaFsr2.removeAllItems();
                        this.sceltaFsr2.addItem("100N");
                        this.sceltaFsr2.addItem("125N");
                        this.sceltaFsr2.addItem("150N");
                        this.sceltaFsr2.addItem("200N");
                        this.sceltaFsr2.addItem("250N");
                        this.sceltaFsr2.addItem("400N");
                        this.sceltaFsr2.addItem("500N");
                        this.sceltaVersoGlobal.removeAllItems();
                        this.sceltaVersoGlobal.addItem(Language.string("Invertito"));
                        this.sceltaVersoGlobal.addItem(Language.string("Originale"));
                        this.sceltaVersoGlobal.setSelectedIndex(1);
                        this.sceltaFsr1.setSelectedIndex(2);
                        this.sceltaFsr2.setSelectedIndex(2);
                        this.filtroCB.setSelectedIndex(2);
                        this.zeroCB.setSelectedIndex(1);
                        break;
                    }
                    case 5: {
                        this.sceltaVersoGlobal.removeAllItems();
                        this.sceltaVersoGlobal.addItem(Language.string("Originale"));
                        this.sceltaVersoGlobal.addItem(Language.string("Invertito"));
                        this.sceltaVersoGlobal.setSelectedIndex(0);
                        this.sceltaFsr1.setSelectedIndex(1);
                        this.sceltaFsr2.setSelectedIndex(1);
                        this.filtroCB.setSelectedIndex(2);
                        this.zeroCB.setSelectedIndex(1);
                    }
                }
            }
        }
        if (e.getSource().equals(this.scriviB)) {
            this.inviaImpostazioni();
        }
        if (e.getSource().equals(this.leggiB)) {
            this.riceviImpostazioni();
        }
        if (e.getSource().equals(this.zeroB)) {
            this.inviaZero();
        }
        if (e.getSource().equals(this.continuoB)) {
            if (!this.acquisisciContinuo) {
                if (this.connected) {
                    try {
                        this.conn.write("$L\r");
                        this.acquisisciContinuo = true;
                        this.continuoB.setText("Stop");
                    }
                    catch (IOException e1) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    }
                }
                this.scriviB.setEnabled(false);
                this.leggiB.setEnabled(false);
            } else {
                if (this.connected) {
                    try {
                        this.acquisisciContinuo = false;
                        this.continuoB.setText("Acquisisci");
                        this.conn.write("$S\r");
                        String end = this.conn.readLine();
                        while (end != null) {
                            end = this.conn.readLine();
                            if (!this.debug) continue;
                            System.out.println("In attesa ricevuto:" + end);
                        }
                    }
                    catch (IOException e1) {
                        this.disconnetti();
                        JOptionPane.showMessageDialog(this, Language.string("Impossibile connettersi"), Language.string("Attenzione"), 2);
                    }
                }
                this.scriviB.setEnabled(true);
                this.leggiB.setEnabled(true);
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.connected) {
            this.disconnetti();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        QsDialog t = new QsDialog(null, null);
        t.setVisible(true);
    }
}

