/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasParser;
import i2m.Language;
import i2m.MainFrame;
import i2m.RiassuntoSessione;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OpenSessionDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton aggiornaB;
    private JButton caricaB;
    private JButton caricaTutteB;
    private JButton esciB;
    private JButton helpB;
    private JButton openB;
    private JTextField circuitoTF;
    private JTextField dataTF;
    private JTextField inizioTF;
    private JTextField fineTF;
    private JTextField durataTF;
    private JTextField kmPercorsiTF;
    private JTextField motoTF;
    private JTextField pilotaTF;
    private JFormattedTextField distanzaTF;
    private JList listSessioni;
    private DefaultListModel sessioniLM;
    private DefaultListModel sessioniFiltrateLM;
    private JCheckBox filtroKmCB;
    private JCheckBox filtroGpsCB;
    private JComboBox directoryCB;
    private JComboBox circuitoCB;
    private JRadioButton manualB;
    private JRadioButton autoB;
    private JRadioButton noVideoB;
    private static Thread aperturaMonitorThread;
    private static int percentualeApertura;
    private Thread caricaRiassuntoSessioniThread;
    private Thread caricaSessioniThread;
    private boolean aperturaInterrotta = false;
    private JCheckBox filtroNomeCB;
    private static File fileSessioniCaricate;
    private static File fileIn;
    public static final double nauticNodesToMetersPerSeconds = 0.514444444444;
    private String directorySettaggi;
    private JPanel pannelloSinistro;
    private JScrollPane listScroller;
    private DanasParser dParser;
    private MainFrame danas;
    private String fileVideoSessione;
    private long oraFileVideo = 0L;
    private boolean aggiungiVideoManuale = false;
    private boolean aggiungiVideoAutomatico = false;

    public OpenSessionDialog(Frame owner, File f, DanasParser ds_) {
        super(owner, Language.string("Apri sessioni"), true);
        this.dParser = ds_;
        this.danas = (MainFrame)owner;
        this.setProgress(0);
        this.setVisible(false);
        if (aperturaMonitorThread != null) {
            aperturaMonitorThread.stop();
        }
        if (this.caricaRiassuntoSessioniThread != null) {
            this.caricaRiassuntoSessioniThread.stop();
        }
        fileIn = f;
        this.setResizable(false);
        this.sessioniLM = new DefaultListModel();
        this.sessioniLM.clear();
        this.sessioniFiltrateLM = new DefaultListModel();
        this.sessioniFiltrateLM.clear();
        this.costruisciInterfaccia();
        String s = DanasPreferences.getPrefDirectory("openSettaggiOpen");
        if (s != null) {
            File dir = new File(s);
            this.directorySettaggi = s;
            File[] fileList = dir.listFiles();
            this.aggiornaSettaggiComboBox(fileList);
            this.directoryCB.setSelectedIndex(0);
        } else {
            this.directoryCB.setSelectedIndex(0);
        }
        this.caricaRiassuntoSessioniThread = new Thread(){

            @Override
            public void run() {
                OpenSessionDialog.this.caricaRiassuntoSessioni(fileIn);
            }
        };
        this.caricaRiassuntoSessioniThread.start();
        aperturaMonitorThread = new Thread(){

            @Override
            public void run() {
                OpenSessionDialog.this.monitorApertura();
            }
        };
        aperturaMonitorThread.start();
    }

    public synchronized int getProgress() {
        return percentualeApertura;
    }

    private synchronized void setProgress(int progress) {
        percentualeApertura = progress;
    }

    public synchronized boolean isAperturaInterrotta() {
        return this.aperturaInterrotta;
    }

    private synchronized void setAperturaInterrotta(boolean interrotta) {
        this.aperturaInterrotta = interrotta;
    }

    private void monitorApertura() {
        this.setEnabled(false);
        this.setAperturaInterrotta(false);
        ProgressMonitor mon = new ProgressMonitor(this, Language.string("Apertura sessioni in corso"), "", 0, 100);
        while (!mon.isCanceled() && this.getProgress() < 100) {
            mon.setProgress(this.getProgress());
            mon.setNote(Language.string("Completato: ") + this.getProgress() + "%");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (mon.isCanceled()) {
            this.setAperturaInterrotta(true);
        }
        mon.setProgress(100);
        this.setEnabled(true);
        this.setVisible(true);
        aperturaMonitorThread = null;
    }

    public double calcolaDistanza(String from, String to) {
        String[] sFrom = from.split(",");
        String[] sTo = to.split(",");
        try {
            if (sFrom.length > 8 && sTo.length > 8 && sTo[8].length() > 7 && sFrom[8].length() > 7) {
                double tempoFrom = Integer.valueOf(sFrom[8].substring(0, 2)) * 3600000 + Integer.valueOf(sFrom[8].substring(2, 4)) * 60000 + Integer.valueOf(sFrom[8].substring(4, 6)) * 1000 + Integer.valueOf(sFrom[8].substring(7));
                double tempoTo = Integer.valueOf(sTo[8].substring(0, 2)) * 3600000 + Integer.valueOf(sTo[8].substring(2, 4)) * 60000 + Integer.valueOf(sTo[8].substring(4, 6)) * 1000 + Integer.valueOf(sTo[8].substring(7));
                double deltaTempo = (tempoTo - tempoFrom) / 1000.0;
                double velocita = Double.valueOf(sFrom[7]) * 0.514444444444 / 1000.0;
                double spazio = velocita * deltaTempo;
                return spazio;
            }
            System.err.println("Errore su:" + from + " oppure:" + to);
            return 0.0;
        }
        catch (Exception ex) {
            System.err.println("Errore su:" + from + " oppure:" + to);
            return 0.0;
        }
    }

    public void caricaRiassuntoSessioni(File f) {
        int numeroSessioniTrovate = 0;
        RiassuntoSessione sessione = new RiassuntoSessione(0);
        boolean sessioneIniziata = false;
        boolean inizioTrovato = false;
        String ultimaLineaGpsValida = null;
        Double distanzaTotale = 0.0;
        try {
            long rounded;
            String[] s;
            String line;
            long numeroRighe = 0L;
            BufferedReader fileIngresso = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = fileIngresso.readLine()) != null) {
                ++numeroRighe;
            }
            fileIngresso.close();
            fileIngresso = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            long posizionePointer = 0L;
            while ((line = fileIngresso.readLine()) != null && !this.isAperturaInterrotta()) {
                percentualeApertura = (int)(++posizionePointer * 100L / numeroRighe);
                if (line.startsWith("$NEW SESSION")) {
                    if (sessioneIniziata) {
                        s = ultimaLineaGpsValida.split(",");
                        sessione.setFine(s[8]);
                        rounded = Math.round(distanzaTotale * 100.0);
                        sessione.setChilometri(Double.valueOf((double)rounded / 100.0).toString());
                    }
                    sessioneIniziata = false;
                    inizioTrovato = false;
                    ultimaLineaGpsValida = null;
                    distanzaTotale = 0.0;
                    sessione = new RiassuntoSessione(++numeroSessioniTrovate);
                    sessione.setPointer(posizionePointer);
                    this.sessioniFiltrateLM.addElement(sessione);
                }
                if (line.startsWith("$DATE") && (s = line.split(",")).length > 1) {
                    sessione.setData(s[1]);
                }
                if (line.startsWith("$PATH")) {
                    // empty if block
                }
                if (line.startsWith("$PILOTA") && (s = line.split(",")).length > 1) {
                    sessione.setPilota(s[1]);
                }
                if (line.startsWith("$MOTO") && (s = line.split(",")).length > 1) {
                    sessione.setMoto(s[1]);
                }
                if (!line.startsWith("$GPS") || (s = line.split(",")).length <= 2 || !s[2].equals("A")) continue;
                if (sessioneIniziata) {
                    distanzaTotale = distanzaTotale + this.calcolaDistanza(ultimaLineaGpsValida, line);
                }
                sessioneIniziata = true;
                sessione.setGpsValido(true);
                ultimaLineaGpsValida = line;
                if (inizioTrovato || s.length <= 8) continue;
                sessione.setInizio(s[8]);
                inizioTrovato = true;
                sessione.setCircuito(this.trovaCircuito(line));
            }
            fileIngresso.close();
            percentualeApertura = 101;
            try {
                aperturaMonitorThread.join(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (inizioTrovato) {
                s = ultimaLineaGpsValida.split(",");
                sessione.setFine(s[8]);
                rounded = Math.round(distanzaTotale * 100.0);
                sessione.setChilometri(Double.valueOf((double)rounded / 100.0).toString());
            }
            for (int i = 0; i < this.sessioniFiltrateLM.size(); ++i) {
                this.sessioniLM.addElement(this.sessioniFiltrateLM.getElementAt(i));
            }
        }
        catch (IOException ex) {
            System.out.println("Non sono riuscito ad aprire il buffer di lettura sul file che mi \u00e8 stato passato");
        }
        if (this.sessioniLM.size() > 0) {
            this.listSessioni.setSelectedIndex(this.sessioniLM.size() - 1);
        }
        this.caricaRiassuntoSessioniThread = null;
    }

    private void filtra() {
        Double distanzaMinima = Double.valueOf(this.distanzaTF.getValue().toString());
        this.sessioniFiltrateLM.clear();
        String nome = null;
        String circuitoScelto = this.circuitoCB.getSelectedIndex() != -1 ? (String)this.circuitoCB.getSelectedItem() : null;
        for (int i = 0; i < this.sessioniLM.size(); ++i) {
            boolean validGps = ((RiassuntoSessione)this.sessioniLM.getElementAt(i)).isGpsValido();
            nome = ((RiassuntoSessione)this.sessioniLM.getElementAt(i)).getCircuito();
            Double distanzaSessione = ((RiassuntoSessione)this.sessioniLM.getElementAt(i)).getChilometri() != null ? Double.valueOf(((RiassuntoSessione)this.sessioniLM.getElementAt(i)).getChilometri()) : Double.valueOf(0.0);
            if ((!validGps || !this.filtroGpsCB.isSelected()) && this.filtroGpsCB.isSelected() || !(distanzaSessione > distanzaMinima && this.filtroKmCB.isSelected()) && this.filtroKmCB.isSelected() || (!nome.equals(circuitoScelto) || !this.filtroNomeCB.isSelected()) && this.filtroNomeCB.isSelected()) continue;
            this.sessioniFiltrateLM.addElement(this.sessioniLM.getElementAt(i));
        }
        this.listSessioni.setModel(this.sessioniFiltrateLM);
        if (this.sessioniFiltrateLM.size() > 0) {
            this.listSessioni.setSelectedIndex(0);
        }
    }

    private void caricaSessioni(boolean soloSelezionate) {
        fileSessioniCaricate = null;
        try {
            fileSessioniCaricate = File.createTempFile(fileIn.getName() + "-", ".tmp");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int numeroNewSession = 0;
        boolean stampatoSettaggio = false;
        boolean stampatoVideo = false;
        String nomeFile = (String)this.directoryCB.getSelectedItem();
        if (this.directoryCB.getSelectedIndex() == 0) {
            DanasDataStructure.getInstance().getMainFrame().setTipoSettaggi(0);
        } else {
            DanasDataStructure.getInstance().getMainFrame().setTipoSettaggi(3);
        }
        boolean pathPresente = true;
        int righeLette = 0;
        boolean primoVideo = false;
        long primaOraVideo = 0L;
        long primaOraSessione = 0L;
        try {
            BufferedReader fileIngresso = new BufferedReader(new InputStreamReader(new FileInputStream(fileIn)));
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fileSessioniCaricate)));
            int[] elencoSelezionate = this.listSessioni.getSelectedIndices();
            int numeroSessioni = soloSelezionate ? elencoSelezionate.length : this.sessioniFiltrateLM.size();
            for (int i = 0; i < numeroSessioni; ++i) {
                String line;
                int progresso = i * 100 / numeroSessioni;
                this.setProgress(progresso);
                if (this.isAperturaInterrotta()) break;
                stampatoSettaggio = false;
                stampatoVideo = false;
                RiassuntoSessione sess = soloSelezionate ? (RiassuntoSessione)this.sessioniFiltrateLM.elementAt(elencoSelezionate[i]) : (RiassuntoSessione)this.sessioniFiltrateLM.elementAt(i);
                if (!sess.isPathPresente()) {
                    pathPresente = false;
                }
                while ((long)righeLette < sess.getPointer() - 1L) {
                    fileIngresso.readLine();
                    ++righeLette;
                }
                numeroNewSession = 0;
                while ((line = fileIngresso.readLine()) != null && numeroNewSession < 2) {
                    ++righeLette;
                    if (line.startsWith("$NEW SESSION")) {
                        ++numeroNewSession;
                    }
                    if (numeroNewSession < 2) {
                        out.println(line);
                    }
                    if (!stampatoVideo && numeroNewSession == 1) {
                        VideoDialog d;
                        if (this.aggiungiVideoManuale) {
                            d = new VideoDialog(this, Integer.valueOf(i + 1).toString() + "/" + Integer.valueOf(numeroSessioni).toString(), sess.getInizio());
                            d.setAlwaysOnTop(true);
                            d.setLocationRelativeTo(null);
                            d.setVisible(true);
                            if (this.fileVideoSessione != null) {
                                out.println(this.fileVideoSessione);
                            }
                            stampatoVideo = true;
                        }
                        if (this.aggiungiVideoAutomatico) {
                            if (!primoVideo) {
                                d = new VideoDialog(this, Integer.valueOf(i + 1).toString() + "/" + Integer.valueOf(numeroSessioni).toString(), sess.getInizio());
                                d.setAlwaysOnTop(true);
                                d.setLocationRelativeTo(null);
                                d.setVisible(true);
                                if (this.fileVideoSessione != null) {
                                    out.println(this.fileVideoSessione);
                                    primoVideo = true;
                                    primaOraVideo = this.oraFileVideo;
                                    primaOraSessione = sess.getInizioLong();
                                }
                                stampatoVideo = true;
                            } else {
                                File[] fileList;
                                long differenzaSessioni = sess.getInizioLong() - primaOraSessione;
                                String s = DanasPreferences.getPrefDirectory("openVideo");
                                if (s != null && (fileList = new File(s).listFiles()) != null) {
                                    for (int j = 0; j < fileList.length; ++j) {
                                        long differenzaVideo;
                                        if (!fileList[j].toString().endsWith(".avi") && !fileList[j].toString().endsWith(".AVI") || Math.abs(differenzaSessioni - (differenzaVideo = fileList[j].lastModified() - primaOraVideo)) > 2000L) continue;
                                        out.println("$VIDEO," + s + File.separator + fileList[j].toString() + ",");
                                        stampatoVideo = true;
                                        break;
                                    }
                                    stampatoVideo = true;
                                }
                            }
                        }
                    }
                    if (stampatoSettaggio || numeroNewSession != 1) continue;
                    stampatoSettaggio = true;
                }
                fileIngresso.close();
                fileIngresso = new BufferedReader(new InputStreamReader(new FileInputStream(fileIn)));
                righeLette = 0;
            }
            fileIngresso.close();
            this.setProgress(101);
            try {
                aperturaMonitorThread.join(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.dParser.FillDsFromFile(fileSessioniCaricate);
        this.danas.refreshStruttura();
        this.caricaSessioniThread = null;
        this.dispose();
    }

    public File getSessioniCaricate() {
        return fileSessioniCaricate;
    }

    public String trovaCircuito(String fraseGPS) {
        String risultato = null;
        String[] s = fraseGPS.split(",");
        int indice = 0;
        boolean trovato = false;
        try {
            String line;
            int latitudine = Integer.valueOf(s[3].substring(0, 2)) * 600000 + Integer.valueOf(s[3].substring(2, 4)) * 10000 + Integer.valueOf(s[3].substring(5));
            int longitudine = Integer.valueOf(s[5].substring(0, 3)) * 600000 + Integer.valueOf(s[5].substring(3, 5)) * 10000 + Integer.valueOf(s[5].substring(6));
            File f = new File("./defaultCircuits.cir");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            this.circuitoCB.removeAllItems();
            while ((line = in.readLine()) != null) {
                String[] temp = line.split(",");
                if (!line.startsWith("t")) continue;
                this.circuitoCB.insertItemAt(temp[2], indice);
                if (this.circuitoCB.getItemCount() != 0) {
                    this.circuitoCB.setSelectedIndex(0);
                }
                ++indice;
                int latitudineTraguardo = Integer.valueOf(temp[3].substring(0, 2)) * 600000 + Integer.valueOf(temp[3].substring(2, 4)) * 10000 + Integer.valueOf(temp[3].substring(5));
                int longitudineTraguardo = Integer.valueOf(temp[5].substring(0, 3)) * 600000 + Integer.valueOf(temp[5].substring(3, 5)) * 10000 + Integer.valueOf(temp[5].substring(6));
                if (trovato || !s[4].equals(temp[4]) || !s[6].equals(temp[6]) || Math.abs(latitudine - latitudineTraguardo) >= 7000 || Math.abs(longitudine - longitudineTraguardo) >= 7000) continue;
                trovato = true;
                risultato = temp[2];
            }
            in.close();
            if (trovato) {
                return risultato;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Non sono riuscito ad aprire il buffer di lettura sul file dei circuiti");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.out.println(e.toString());
            System.out.println(fraseGPS);
            System.out.println("errore nel parsing dei dati GPS");
        }
        return Language.string("non in elenco");
    }

    private void costruisciInterfaccia() {
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.aggiornaB = new JButton(Language.string("Filtra"));
        this.aggiornaB.addActionListener(this);
        this.caricaB = new JButton(Language.string("Apri selezionate"));
        this.caricaB.addActionListener(this);
        this.caricaTutteB = new JButton(Language.string("Apri tutte"));
        this.caricaTutteB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        this.helpB = new JButton(" ? ");
        this.helpB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.aggiornaB);
        pannelloBottoni.add(this.caricaB);
        pannelloBottoni.add(this.caricaTutteB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.add(this.helpB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        JPanel panelFile = new JPanel();
        panelFile.setLayout(new BoxLayout(panelFile, 0));
        this.openB = new JButton(Language.string("Apri"));
        this.openB.addActionListener(this);
        this.openB.setMaximumSize(new Dimension(110, 30));
        JLabel fileLabel = new JLabel(Language.string(" Settaggi: "));
        String[] fileList = new String[]{Language.string("Inserito nel file"), "Default Settings"};
        this.directoryCB = new JComboBox<String>(fileList);
        this.directoryCB.setMaximumSize(new Dimension(200, 30));
        panelFile.add(Box.createRigidArea(new Dimension(20, 45)));
        panelFile.add(fileLabel);
        panelFile.add(Box.createRigidArea(new Dimension(20, 45)));
        panelFile.add(this.directoryCB);
        panelFile.add(Box.createRigidArea(new Dimension(20, 45)));
        panelFile.add(this.openB);
        panelFile.add(Box.createRigidArea(new Dimension(20, 50)));
        pannelloPrincipale.add((Component)panelFile, "North");
        JPanel pannelloDestro = new JPanel();
        pannelloDestro.setLayout(new BoxLayout(pannelloDestro, 1));
        this.pannelloSinistro = new JPanel();
        this.pannelloSinistro.setLayout(new BoxLayout(this.pannelloSinistro, 1));
        JPanel datiPanel = new JPanel();
        datiPanel.setLayout(new BoxLayout(datiPanel, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JLabel datiLabel = new JLabel(Language.string("Dati Sessione"));
        panel.add(datiLabel);
        panel.setAlignmentX(1.0f);
        panel.add(Box.createRigidArea(new Dimension(142, 30)));
        datiPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JLabel label = new JLabel(Language.string(" Circuito:           "));
        this.circuitoTF = new JTextField("", 10);
        this.circuitoTF.setHorizontalAlignment(11);
        this.circuitoTF.setEditable(false);
        label.setLabelFor(this.circuitoTF);
        this.circuitoTF.setMaximumSize(new Dimension(120, 25));
        panel.add(label);
        panel.setAlignmentX(1.0f);
        panel.add(this.circuitoTF);
        panel.add(Box.createRigidArea(new Dimension(20, 30)));
        datiPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label = new JLabel(" Data:                ");
        this.dataTF = new JTextField("", 10);
        this.dataTF.setHorizontalAlignment(11);
        this.dataTF.setEditable(false);
        this.dataTF.setMaximumSize(new Dimension(120, 25));
        label.setLabelFor(this.dataTF);
        panel.add(label);
        panel.add(this.dataTF);
        panel.add(Box.createRigidArea(new Dimension(20, 30)));
        datiPanel.add(panel);
        panel.setAlignmentX(1.0f);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label = new JLabel(Language.string(" Ora inizio:        "));
        this.inizioTF = new JTextField("", 10);
        this.inizioTF.setHorizontalAlignment(11);
        this.inizioTF.setEditable(false);
        this.inizioTF.setMaximumSize(new Dimension(120, 25));
        label.setLabelFor(this.inizioTF);
        panel.add(label);
        panel.add(this.inizioTF);
        panel.add(Box.createRigidArea(new Dimension(20, 30)));
        datiPanel.add(panel);
        panel.setAlignmentX(1.0f);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label = new JLabel(Language.string(" Ora fine:          "));
        this.fineTF = new JTextField("", 10);
        this.fineTF.setHorizontalAlignment(11);
        this.fineTF.setEditable(false);
        this.fineTF.setMaximumSize(new Dimension(120, 25));
        label.setLabelFor(this.fineTF);
        panel.add(label);
        panel.add(this.fineTF);
        panel.add(Box.createRigidArea(new Dimension(20, 30)));
        datiPanel.add(panel);
        panel.setAlignmentX(1.0f);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label = new JLabel(Language.string(" Durata:            "));
        this.durataTF = new JTextField("", 10);
        this.durataTF.setHorizontalAlignment(11);
        this.durataTF.setEditable(false);
        this.durataTF.setMaximumSize(new Dimension(120, 25));
        label.setLabelFor(this.durataTF);
        panel.add(label);
        panel.add(this.durataTF);
        panel.add(Box.createRigidArea(new Dimension(20, 30)));
        datiPanel.add(panel);
        panel.setAlignmentX(1.0f);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label = new JLabel(Language.string(" km percorsi:  "));
        this.kmPercorsiTF = new JTextField("", 10);
        this.kmPercorsiTF.setHorizontalAlignment(11);
        this.kmPercorsiTF.setEditable(false);
        this.kmPercorsiTF.setMaximumSize(new Dimension(120, 25));
        label.setLabelFor(this.kmPercorsiTF);
        panel.add(label);
        panel.add(this.kmPercorsiTF);
        panel.add(Box.createRigidArea(new Dimension(20, 30)));
        datiPanel.add(panel);
        panel.setAlignmentX(1.0f);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label = new JLabel(Language.string(" Moto:               "));
        this.motoTF = new JTextField("", 10);
        this.motoTF.setHorizontalAlignment(11);
        this.motoTF.setEditable(false);
        this.motoTF.setMaximumSize(new Dimension(120, 25));
        label.setLabelFor(this.motoTF);
        panel.add(label);
        panel.add(this.motoTF);
        panel.add(Box.createRigidArea(new Dimension(20, 30)));
        datiPanel.add(panel);
        panel.setAlignmentX(1.0f);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label = new JLabel(Language.string(" Pilota:              "));
        this.pilotaTF = new JTextField("", 10);
        this.pilotaTF.setHorizontalAlignment(11);
        this.pilotaTF.setEditable(false);
        this.pilotaTF.setMaximumSize(new Dimension(120, 25));
        label.setLabelFor(this.pilotaTF);
        panel.add(label);
        panel.setAlignmentX(1.0f);
        panel.add(this.pilotaTF);
        panel.add(Box.createRigidArea(new Dimension(20, 30)));
        datiPanel.add(panel);
        panel.setAlignmentX(1.0f);
        datiPanel.setMaximumSize(new Dimension(300, 300));
        datiPanel.setAlignmentX(1.0f);
        datiPanel.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel filtriPanel = new JPanel();
        filtriPanel.setLayout(new BoxLayout(filtriPanel, 1));
        JLabel filtroLabel = new JLabel(Language.string("  Filtri: "));
        JPanel panelDistanza = new JPanel();
        panelDistanza.setLayout(new BoxLayout(panelDistanza, 0));
        this.filtroKmCB = new JCheckBox(Language.string("Solo se km percorsi > "));
        this.filtroKmCB.addActionListener(this);
        this.filtroKmCB.setSelected(false);
        NumberFormat KmFormat = NumberFormat.getNumberInstance(Locale.US);
        KmFormat.setMaximumIntegerDigits(10);
        KmFormat.setMaximumFractionDigits(2);
        KmFormat.setGroupingUsed(false);
        this.distanzaTF = new JFormattedTextField(KmFormat);
        this.distanzaTF.setHorizontalAlignment(11);
        this.distanzaTF.setMaximumSize(new Dimension(80, 20));
        this.distanzaTF.setPreferredSize(new Dimension(80, 20));
        this.distanzaTF.setValue(0);
        this.distanzaTF.setEnabled(false);
        panelDistanza.add(this.filtroKmCB);
        panelDistanza.add(this.distanzaTF);
        panelDistanza.add(Box.createRigidArea(new Dimension(10, 20)));
        panelDistanza.setAlignmentX(0.0f);
        this.filtroGpsCB = new JCheckBox(Language.string("Solo se GPS valido"));
        this.filtroNomeCB = new JCheckBox(Language.string("Solo se circuito =      "));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        String[] listaCircuiti = new String[]{};
        this.circuitoCB = new JComboBox<String>(listaCircuiti);
        this.circuitoCB.setMaximumSize(new Dimension(90, 20));
        filtroLabel.setAlignmentX(0.0f);
        this.filtroGpsCB.setAlignmentX(0.0f);
        panel.setAlignmentX(0.0f);
        filtriPanel.setAlignmentX(1.0f);
        panel.add(this.filtroNomeCB);
        panel.add(this.circuitoCB);
        filtriPanel.add(filtroLabel);
        filtriPanel.add(panelDistanza);
        filtriPanel.add(this.filtroGpsCB);
        filtriPanel.add(panel);
        filtriPanel.setBorder(BorderFactory.createEtchedBorder(0));
        filtriPanel.setAlignmentX(1.0f);
        JPanel videoPanel = new JPanel();
        videoPanel.setLayout(new BoxLayout(videoPanel, 1));
        JLabel videoLabel = new JLabel("  Video: ");
        this.manualB = new JRadioButton(Language.string("Manuale per ogni sessione               "));
        this.manualB.addActionListener(this);
        this.autoB = new JRadioButton(Language.string("Automatico"));
        this.autoB.setEnabled(false);
        this.autoB.addActionListener(this);
        this.noVideoB = new JRadioButton("No video");
        this.noVideoB.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.manualB);
        group.add(this.autoB);
        group.add(this.noVideoB);
        videoPanel.add(videoLabel);
        videoPanel.add(this.manualB);
        videoPanel.add(this.autoB);
        videoPanel.add(this.noVideoB);
        this.noVideoB.setSelected(true);
        videoPanel.setAlignmentX(0.0f);
        videoPanel.setBorder(BorderFactory.createEtchedBorder(0));
        this.listSessioni = new JList(this.sessioniFiltrateLM);
        this.listSessioni.setSelectionMode(2);
        this.listSessioni.setLayoutOrientation(0);
        this.listSessioni.setSelectedIndex(0);
        this.listSessioni.setPreferredSize(new Dimension(90, 8000));
        this.listSessioni.addListSelectionListener(this);
        this.listScroller = new JScrollPane(this.listSessioni);
        this.listScroller.setPreferredSize(new Dimension(90, 190));
        this.listScroller.setVerticalScrollBarPolicy(22);
        this.listScroller.setAlignmentX(0.0f);
        this.pannelloSinistro.add(this.listScroller);
        this.pannelloSinistro.add(videoPanel);
        pannelloPrincipale.add((Component)this.pannelloSinistro, "West");
        pannelloDestro.add(datiPanel);
        pannelloDestro.add(filtriPanel);
        pannelloPrincipale.add((Component)pannelloDestro, "East");
        this.pack();
    }

    public void aggiornaSettaggiComboBox(File[] elencoFile) {
        this.directoryCB.removeAllItems();
        this.directoryCB.addItem(Language.string("Inserito nel file"));
        this.directoryCB.addItem("defaultSettings.dfs");
        if (elencoFile != null) {
            for (int i = 0; i < elencoFile.length; ++i) {
                if (!elencoFile[i].toString().endsWith(".dfs")) continue;
                this.directoryCB.addItem(elencoFile[i].getName());
            }
            if (this.directoryCB.getItemCount() == 2) {
                this.directoryCB.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        int index = this.listSessioni.getSelectedIndex();
        if (index != -1) {
            RiassuntoSessione riass = (RiassuntoSessione)this.sessioniFiltrateLM.getElementAt(index);
            this.circuitoTF.setText(riass.getCircuito());
            this.dataTF.setText(riass.getData());
            this.inizioTF.setText(riass.getInizio());
            this.fineTF.setText(riass.getFine());
            this.durataTF.setText(riass.getDurata());
            this.kmPercorsiTF.setText(riass.getChilometri());
            this.motoTF.setText(riass.getMoto());
            this.pilotaTF.setText(riass.getPilota());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.helpB)) {
            HelpDialog d = new HelpDialog(this);
            d.setAlwaysOnTop(true);
            d.setLocationRelativeTo(null);
            d.setVisible(true);
        }
        if (arg0.getSource().equals(this.filtroKmCB)) {
            this.distanzaTF.setEnabled(this.filtroKmCB.isSelected());
        }
        if (arg0.getSource().equals(this.esciB)) {
            this.dispose();
        }
        if (arg0.getSource().equals(this.aggiornaB)) {
            this.filtra();
        }
        if (arg0.getSource().equals(this.caricaB)) {
            this.setProgress(0);
            this.setAperturaInterrotta(false);
            aperturaMonitorThread = new Thread(){

                @Override
                public void run() {
                    OpenSessionDialog.this.monitorApertura();
                }
            };
            aperturaMonitorThread.start();
            this.caricaSessioniThread = new Thread(){

                @Override
                public void run() {
                    OpenSessionDialog.this.caricaSessioni(true);
                }
            };
            this.caricaSessioniThread.start();
        }
        if (arg0.getSource().equals(this.caricaTutteB)) {
            this.setProgress(0);
            this.setAperturaInterrotta(false);
            aperturaMonitorThread = new Thread(){

                @Override
                public void run() {
                    OpenSessionDialog.this.monitorApertura();
                }
            };
            aperturaMonitorThread.start();
            this.caricaSessioniThread = new Thread(){

                @Override
                public void run() {
                    OpenSessionDialog.this.caricaSessioni(false);
                }
            };
            this.caricaSessioniThread.start();
        }
        if (arg0.getSource().equals(this.openB)) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileNameExtensionFilter("Settaggi", "dfs"));
            String s = DanasPreferences.getPrefDirectory("openSettaggiOpen");
            if (s != null) {
                fileChooser.setCurrentDirectory(new File(s));
            }
            int res = fileChooser.showOpenDialog(this);
            DanasPreferences.setPrefDirectory("openSettaggiOpen", fileChooser.getCurrentDirectory().toString());
            this.directorySettaggi = fileChooser.getCurrentDirectory().toString();
            if (res == 0) {
                File f = fileChooser.getSelectedFile();
                try {
                    f.setReadable(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                File[] fileList = f.getParentFile().listFiles();
                this.aggiornaSettaggiComboBox(fileList);
                if (f.toString().endsWith(".dfs")) {
                    this.directoryCB.setSelectedItem(f.getName());
                }
            }
        }
        if (arg0.getSource().equals(this.noVideoB)) {
            this.aggiungiVideoManuale = false;
            this.aggiungiVideoAutomatico = false;
        }
        if (arg0.getSource().equals(this.manualB)) {
            this.aggiungiVideoManuale = true;
            this.aggiungiVideoAutomatico = false;
        }
        if (arg0.getSource().equals(this.autoB)) {
            this.aggiungiVideoManuale = false;
            this.aggiungiVideoAutomatico = true;
        }
    }

    static {
        percentualeApertura = 0;
        fileSessioniCaricate = null;
    }

    public class VideoDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JComboBox sceltaVideoCB;
        JButton scegliB;
        JButton okB;
        private String directoryVideo;

        public VideoDialog(JDialog padre, String nomeSessione, String ora) {
            super(padre, "Video", true);
            JPanel pannelloPrincipaleHelp = new JPanel(new BorderLayout());
            this.setContentPane(pannelloPrincipaleHelp);
            this.setSize(new Dimension(400, 110));
            pannelloPrincipaleHelp.add(Box.createRigidArea(new Dimension(20, 30)), "East");
            pannelloPrincipaleHelp.add(Box.createRigidArea(new Dimension(20, 30)), "West");
            JPanel pannelloCentrale = new JPanel();
            pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new BoxLayout(panel1, 0));
            JLabel l = new JLabel(Language.string("Scegliere il file Video per la sessione: ") + nomeSessione + "  " + ora);
            panel1.setAlignmentX(1.0f);
            panel1.add(l);
            panel1.add(Box.createRigidArea(new Dimension(1, 30)));
            this.sceltaVideoCB = new JComboBox();
            this.scegliB = new JButton("Sfoglia");
            this.okB = new JButton("OK");
            this.scegliB.addActionListener(this);
            this.okB.addActionListener(this);
            this.sceltaVideoCB.setMinimumSize(new Dimension(200, 25));
            this.sceltaVideoCB.setMaximumSize(new Dimension(200, 25));
            this.sceltaVideoCB.addItem(Language.string("Salta sessione"));
            this.sceltaVideoCB.addItem("Salta tutte le sessioni");
            this.scegliB.setMinimumSize(new Dimension(150, 25));
            this.scegliB.setMaximumSize(new Dimension(150, 25));
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(this.sceltaVideoCB);
            panel.add(Box.createRigidArea(new Dimension(10, 40)));
            panel.add(this.scegliB);
            panel.add(Box.createRigidArea(new Dimension(5, 40)));
            panel.add(this.okB);
            panel1.setAlignmentX(0.0f);
            panel.setAlignmentX(0.0f);
            pannelloCentrale.add(panel1);
            pannelloCentrale.add(panel);
            pannelloCentrale.setAlignmentX(0.0f);
            pannelloPrincipaleHelp.add((Component)pannelloCentrale, "Center");
            String s = DanasPreferences.getPrefDirectory("openVideo");
            if (s != null) {
                File dir = new File(s);
                this.directoryVideo = s;
                File[] fileList = dir.listFiles();
                if (fileList != null) {
                    for (int i = 0; i < fileList.length; ++i) {
                        if (!fileList[i].toString().endsWith(".avi") && !fileList[i].toString().endsWith(".AVI")) continue;
                        this.sceltaVideoCB.addItem(fileList[i].getName());
                    }
                    if (this.sceltaVideoCB.getItemCount() == 2) {
                        this.sceltaVideoCB.setSelectedIndex(0);
                    } else {
                        this.sceltaVideoCB.setSelectedIndex(0);
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource().equals(this.scegliB)) {
                FileDialog fd = new FileDialog((Dialog)this, Language.string("Apri Video"), 0);
                fd.setFile("*.au;*.wav;*.mid;*.avi;*.mpg;");
                fd.setVisible(true);
                File f = new File(fd.getDirectory(), fd.getFile());
                File[] fileList = f.getParentFile().listFiles();
                this.sceltaVideoCB.removeAllItems();
                this.sceltaVideoCB.addItem(Language.string("Salta sessione"));
                this.sceltaVideoCB.addItem("Salta tutte le sessioni");
                if (fileList != null) {
                    DanasPreferences.setPrefDirectory("openVideo", fd.getDirectory().toString());
                    for (int i = 0; i < fileList.length; ++i) {
                        if (!fileList[i].toString().endsWith(".avi") && !fileList[i].toString().endsWith(".AVI")) continue;
                        this.sceltaVideoCB.addItem(fileList[i].getName());
                    }
                    if (this.sceltaVideoCB.getItemCount() == 2) {
                        this.sceltaVideoCB.setSelectedIndex(0);
                    } else {
                        this.sceltaVideoCB.setSelectedItem(f.getName());
                    }
                }
            }
            if (arg0.getSource().equals(this.okB)) {
                if (this.sceltaVideoCB.getSelectedIndex() == 0) {
                    OpenSessionDialog.this.fileVideoSessione = null;
                }
                if (this.sceltaVideoCB.getSelectedIndex() == 1) {
                    OpenSessionDialog.this.fileVideoSessione = null;
                    OpenSessionDialog.this.aggiungiVideoManuale = false;
                    OpenSessionDialog.this.aggiungiVideoAutomatico = false;
                }
                if (this.sceltaVideoCB.getSelectedIndex() > 1) {
                    OpenSessionDialog.this.fileVideoSessione = "$VIDEO," + this.directoryVideo + File.separator + (String)this.sceltaVideoCB.getSelectedItem() + ",";
                    OpenSessionDialog.this.oraFileVideo = new File(this.directoryVideo + File.separator + (String)this.sceltaVideoCB.getSelectedItem()).lastModified();
                }
                this.dispose();
            }
        }
    }

    public class HelpDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        JButton okB;

        public HelpDialog(JDialog padre) {
            super(padre, "Help", true);
            JPanel pannelloPrincipaleHelp = new JPanel(new BorderLayout());
            this.setContentPane(pannelloPrincipaleHelp);
            this.setSize(new Dimension(600, 340));
            pannelloPrincipaleHelp.add(Box.createRigidArea(new Dimension(20, 30)), "East");
            pannelloPrincipaleHelp.add(Box.createRigidArea(new Dimension(20, 30)), "West");
            JEditorPane editorPane = new JEditorPane();
            editorPane.setEditable(false);
            editorPane.setBackground(null);
            URL testoURL = this.getClass().getResource("/res/helpApertura.html");
            try {
                editorPane.setPage(testoURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + testoURL);
            }
            JScrollPane editorScrollPane = new JScrollPane(editorPane);
            editorScrollPane.setBorder(BorderFactory.createEmptyBorder());
            pannelloPrincipaleHelp.add((Component)editorScrollPane, "Center");
        }
    }
}

