/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IPAddressDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton nextB;
    JButton esciB;
    JTextField addressTF;
    String ip = null;
    String nomeIniziale = null;

    public IPAddressDialog(JDialog owner) {
        super(owner, Language.string("Inserisci indirizzo IP del Chrome (es: 10.10.0.1) "), true);
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        this.nextB = new JButton(Language.string("Procedi"));
        this.nextB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.nextB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        pannelloPrincipale.add((Component)pannelloBottoni, "South");
        this.addressTF = new JTextField("0.0.0.0", 15);
        this.addressTF.setHorizontalAlignment(11);
        this.addressTF.setMaximumSize(new Dimension(130, 20));
        JLabel nomeLabel = new JLabel(Language.string("Indirizzo IP:"));
        nomeLabel.setLabelFor(this.addressTF);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(60, 10)));
        panel.add(nomeLabel);
        panel.add(Box.createRigidArea(new Dimension(20, 10)));
        panel.add(this.addressTF);
        panel.add(Box.createRigidArea(new Dimension(60, 10)));
        pannelloPrincipale.add((Component)panel, "Center");
        this.pack();
        this.setSize(new Dimension(350, 120));
    }

    public String getIp() {
        return this.ip;
    }

    public boolean onlyDigits(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9' || str.charAt(i) == '.') continue;
            return false;
        }
        return true;
    }

    public int verificaPunti(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source.equals(this.esciB)) {
            this.ip = null;
            this.dispose();
        }
        if (source.equals(this.nextB)) {
            if (this.addressTF.getText().length() > 15) {
                JOptionPane.showMessageDialog(this, Language.string("Formato indirizzo non corretto, togliere eventuali spazi"), Language.string("ATTENZIONE"), 0);
                return;
            }
            if (!this.onlyDigits(this.addressTF.getText())) {
                JOptionPane.showMessageDialog(this, Language.string("Formato indirizzo non corretto"), Language.string("ATTENZIONE"), 0);
                return;
            }
            if (this.verificaPunti(this.addressTF.getText()) != 3) {
                JOptionPane.showMessageDialog(this, Language.string("Formato indirizzo non corretto"), Language.string("ATTENZIONE"), 0);
                return;
            }
            this.ip = this.addressTF.getText();
            this.dispose();
        }
    }

    public static void main(String[] args) {
        IPAddressDialog test = new IPAddressDialog(null);
        test.setVisible(true);
    }
}

