/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.MainFrame;
import i2m.grafico.CurvaXY;
import i2m.grafico.GraficoXY;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import no.geosoft.cc.graphics.GScene;

public class GraficoXYDialog
extends JDialog
implements ActionListener,
ChangeListener,
WindowListener,
ListSelectionListener {
    private GraficoXY graphXy;
    private JPanel pannelloPrincipale;
    private JCheckBox grigliaX;
    private JCheckBox grigliaY;
    private JCheckBox mostraLegenda;
    private JCheckBox mostraAssi;
    JScrollPane scrollPaneXY;
    JTextField coloreGraficoXY;
    JComboBox<String> canaleXCB;
    JComboBox<String> canaleYCB;
    JComboBox<String> canaleZCB;
    JComboBox<String> sottocampionaturaCB;
    JComboBox<String> zoomCB;
    JPanel pannelloTabella;
    JCheckBox bloccaX;
    JCheckBox bloccaY;
    JCheckBox bloccaZ;
    JCheckBox autoscaling;
    JFormattedTextField minimoX;
    JFormattedTextField massimoX;
    JFormattedTextField minimoY;
    JFormattedTextField massimoY;
    JFormattedTextField minimoZ;
    JFormattedTextField massimoZ;
    boolean aggiornaGrafico = false;
    boolean aggiornaCurve = false;
    boolean visibile = true;
    private JComboBox<String> comboMode;
    int modoAttuale = 0;
    private JPopupMenu popup;
    private JMenuItem popupFittaTutto;
    private JMenuItem popupFittaVert;
    private JMenuItem popupFittaH;
    private JMenuItem popupZoomIn;
    private JMenuItem popupZoomOut;
    private JMenuItem popupZoomWindow;
    private JMenuItem popupMuovi;
    private JMenuItem popupOpzioni;
    private int larghezzaDialog = 650;
    private int altezzaDialog = 650;
    private int posX = 0;
    private int posY = 0;
    private static final long serialVersionUID = 1L;
    MainFrame padre;
    JTabbedPane contenitore;
    JButton fittaXB;
    JButton esciB;
    JButton fittaYB;
    JButton fittaAllB;
    JButton coloreSfondoXY;
    JButton salvaB;

    public GraficoXYDialog(MainFrame owner) {
        super((Frame)owner, Language.string("Grafico XY (Solo per analisi Giri)"));
        this.padre = owner;
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.costruisciInterfaccia();
        this.graphXy = new GraficoXY(this);
        this.fittaXB = new JButton(Language.string("Fitta Asse X"));
        this.fittaXB.addActionListener(this);
        this.esciB = new JButton(Language.string("Esci"));
        this.esciB.addActionListener(this);
        this.fittaYB = new JButton(Language.string("Fitta Asse Y"));
        this.fittaYB.addActionListener(this);
        this.fittaAllB = new JButton(Language.string("Fitta Tutto"));
        this.fittaAllB.addActionListener(this);
        String[] zoomList = new String[]{Language.string("Muovi"), "Zoom In", " Zoom out", " Zoom Window"};
        this.zoomCB = new JComboBox<String>(zoomList);
        this.zoomCB.addActionListener(this);
        JPanel pannelloBottoni = new JPanel();
        pannelloBottoni.add(this.fittaXB);
        pannelloBottoni.add(this.fittaYB);
        pannelloBottoni.add(this.fittaAllB);
        pannelloBottoni.add(this.zoomCB);
        pannelloBottoni.add(this.esciB);
        pannelloBottoni.setBorder(BorderFactory.createEtchedBorder(0));
        this.pannelloTabella = new JPanel(new BorderLayout());
        this.pannelloTabella.add(this.graphXy.getGrafico(), "Center");
        this.contenitore = new JTabbedPane();
        this.contenitore.addTab(Language.string("Grafico"), this.pannelloTabella);
        this.contenitore.addTab(Language.string("Opzioni"), this.scrollPaneXY);
        this.contenitore.addChangeListener(this);
        this.popup = new JPopupMenu();
        this.popupZoomIn = new JMenuItem(Language.string("Zoom In..."));
        this.popupZoomIn.addActionListener(this);
        this.popup.add(this.popupZoomIn);
        this.popupZoomOut = new JMenuItem(Language.string("Zoom Out..."));
        this.popupZoomOut.addActionListener(this);
        this.popup.add(this.popupZoomOut);
        this.popupZoomWindow = new JMenuItem(Language.string("Zoom Finestra"));
        this.popupZoomWindow.addActionListener(this);
        this.popup.add(this.popupZoomWindow);
        this.popupMuovi = new JMenuItem(Language.string("Muovi"));
        this.popupMuovi.addActionListener(this);
        this.popup.add(this.popupMuovi);
        this.popup.addSeparator();
        this.popupFittaTutto = new JMenuItem(Language.string("Fitta tutto"));
        this.popupFittaTutto.addActionListener(this);
        this.popup.add(this.popupFittaTutto);
        this.popupFittaVert = new JMenuItem(Language.string("Fitta verticale"));
        this.popupFittaVert.addActionListener(this);
        this.popup.add(this.popupFittaVert);
        this.popupFittaH = new JMenuItem(Language.string("Fitta orizzontale"));
        this.popupFittaH.addActionListener(this);
        this.popup.add(this.popupFittaH);
        this.popup.addSeparator();
        this.popupOpzioni = new JMenuItem(Language.string("Opzioni"));
        this.popupOpzioni.addActionListener(this);
        this.popup.add(this.popupOpzioni);
        this.add(this.contenitore);
        this.addWindowListener(this);
        this.setSize(650, 650);
        DanasDataStructure.getInstance().addChangeListener(this);
        this.padre.richiediFuoco();
    }

    public void mostraPopup(int x, int y) {
        this.getMousePosition().getY();
        this.popup.show(this, x, (int)this.getMousePosition().getY());
    }

    public void setMode(int mode) {
        this.graphXy.setMode(mode);
    }

    public int getModoVisibile() {
        return this.comboMode.getSelectedIndex();
    }

    public void setModoVisibile(int modo) {
        if (modo < 0) {
            return;
        }
        this.modoAttuale = modo;
        this.comboMode.setSelectedIndex(modo);
        this.caricaPreferenze(this.modoAttuale);
        System.out.println("Aggiorna CurvaXY setModo");
        this.aggiornaCurve();
        this.graphXy.setAsseXY(Double.valueOf(this.minimoX.getValue().toString()), Double.valueOf(this.massimoX.getValue().toString()), Double.valueOf(this.minimoY.getValue().toString()), Double.valueOf(this.massimoY.getValue().toString()), true, true);
    }

    public void aggiornaComboModo() {
        this.comboMode.removeAllItems();
        for (int i = 0; i < 20; ++i) {
            this.comboMode.addItem(DanasPreferences.getOpzioniNomeXY(i));
        }
        this.comboMode.setSelectedIndex(this.modoAttuale);
    }

    public String getNomeY() {
        return (String)this.canaleYCB.getSelectedItem();
    }

    public String getNomeX() {
        return (String)this.canaleXCB.getSelectedItem();
    }

    public void setSincronizzazione(boolean attiva) {
        this.visibile = attiva;
    }

    public double getMinX() {
        return Double.valueOf(this.minimoX.getValue().toString());
    }

    public double getMinY() {
        return Double.valueOf(this.minimoY.getValue().toString());
    }

    public double getMaxX() {
        return Double.valueOf(this.massimoX.getValue().toString());
    }

    public double getMaxY() {
        return Double.valueOf(this.massimoY.getValue().toString());
    }

    public void aggiornaValoriX(double min, double max) {
        this.minimoX.setValue(min);
        this.massimoX.setValue(max);
    }

    public void aggiornaValoriY(double min, double max) {
        this.minimoY.setValue(min);
        this.massimoY.setValue(max);
    }

    public void aggiornaValoriZ(double min, double max) {
        this.minimoZ.setValue(min);
        this.massimoZ.setValue(max);
    }

    public void salvaPreferenze() {
        DanasPreferences.setOpzioniNomeXY(this.modoAttuale, (String)this.comboMode.getSelectedItem());
        DanasPreferences.setOpzioniCheckXY(1, this.modoAttuale, this.grigliaX.isSelected());
        DanasPreferences.setOpzioniCheckXY(2, this.modoAttuale, this.grigliaY.isSelected());
        DanasPreferences.setOpzioniCheckXY(3, this.modoAttuale, this.bloccaX.isSelected());
        DanasPreferences.setOpzioniCheckXY(4, this.modoAttuale, this.bloccaY.isSelected());
        DanasPreferences.setOpzioniCheckXY(5, this.modoAttuale, this.bloccaZ.isSelected());
        DanasPreferences.setOpzioniCheckXY(6, this.modoAttuale, this.autoscaling.isSelected());
        DanasPreferences.setOpzioniCheckXY(7, this.modoAttuale, this.mostraLegenda.isSelected());
        DanasPreferences.setOpzioniCheckXY(8, this.modoAttuale, this.mostraAssi.isSelected());
        DanasPreferences.setPrefColoreSfonfdoXY(this.modoAttuale, this.coloreGraficoXY.getBackground().getRGB());
        DanasPreferences.setOpzioniCanaleXY(1, this.modoAttuale, this.canaleXCB.getSelectedIndex());
        DanasPreferences.setOpzioniCanaleXY(2, this.modoAttuale, this.canaleYCB.getSelectedIndex());
        DanasPreferences.setOpzioniCanaleXY(3, this.modoAttuale, this.canaleZCB.getSelectedIndex());
        DanasPreferences.setOpzioniCanaleXY(4, this.modoAttuale, this.sottocampionaturaCB.getSelectedIndex());
        DanasPreferences.setOpzioniMinimiXY(1, this.modoAttuale, this.minimoX.getText());
        DanasPreferences.setOpzioniMinimiXY(2, this.modoAttuale, this.minimoY.getText());
        DanasPreferences.setOpzioniMinimiXY(3, this.modoAttuale, this.minimoZ.getText());
        DanasPreferences.setOpzioniMassimiXY(1, this.modoAttuale, this.massimoX.getText());
        DanasPreferences.setOpzioniMassimiXY(2, this.modoAttuale, this.massimoY.getText());
        DanasPreferences.setOpzioniMassimiXY(3, this.modoAttuale, this.massimoZ.getText());
        this.comboMode.removeActionListener(this);
        this.aggiornaComboModo();
        this.comboMode.addActionListener(this);
    }

    public void caricaPreferenze(int modo) {
        this.grigliaX.setSelected(DanasPreferences.getOpzioniCheckXY(1, modo));
        this.grigliaY.setSelected(DanasPreferences.getOpzioniCheckXY(2, modo));
        this.bloccaX.setSelected(DanasPreferences.getOpzioniCheckXY(3, modo));
        this.bloccaY.setSelected(DanasPreferences.getOpzioniCheckXY(4, modo));
        this.bloccaZ.setSelected(DanasPreferences.getOpzioniCheckXY(5, modo));
        this.autoscaling.setSelected(DanasPreferences.getOpzioniCheckXY(6, modo));
        this.mostraAssi.setSelected(DanasPreferences.getOpzioniCheckXY(8, modo));
        this.graphXy.mostraAssi(this.mostraAssi.isSelected());
        this.coloreGraficoXY.setBackground(new Color(DanasPreferences.getPrefColoreSfonfdoXY(modo)));
        this.canaleXCB.setSelectedIndex(DanasPreferences.getOpzioniCanaleXY(1, modo));
        this.canaleYCB.setSelectedIndex(DanasPreferences.getOpzioniCanaleXY(2, modo));
        this.canaleZCB.setSelectedIndex(DanasPreferences.getOpzioniCanaleXY(3, modo));
        if (this.canaleZCB.getSelectedIndex() == 0) {
            this.mostraLegenda.setSelected(false);
        } else {
            this.mostraLegenda.setSelected(DanasPreferences.getOpzioniCheckXY(7, modo));
        }
        this.graphXy.setLegenda(this.mostraLegenda.isSelected());
        this.sottocampionaturaCB.setSelectedIndex(DanasPreferences.getOpzioniCanaleXY(4, modo));
        this.minimoX.setText(DanasPreferences.getOpzioniMinimiXY(1, modo));
        this.minimoY.setText(DanasPreferences.getOpzioniMinimiXY(2, modo));
        this.minimoZ.setText(DanasPreferences.getOpzioniMinimiXY(3, modo));
        this.massimoX.setText(DanasPreferences.getOpzioniMassimiXY(1, modo));
        this.massimoY.setText(DanasPreferences.getOpzioniMassimiXY(2, modo));
        this.massimoZ.setText(DanasPreferences.getOpzioniMassimiXY(3, modo));
        this.graphXy.setAsseX(Double.valueOf(DanasPreferences.getOpzioniMinimiXY(1, modo)), Double.valueOf(DanasPreferences.getOpzioniMassimiXY(1, modo)), true, true);
        this.graphXy.setAsseY(Double.valueOf(DanasPreferences.getOpzioniMinimiXY(2, modo)), Double.valueOf(DanasPreferences.getOpzioniMassimiXY(2, modo)), false, true);
        this.graphXy.setAsseZ(Double.valueOf(DanasPreferences.getOpzioniMinimiXY(3, modo)), Double.valueOf(DanasPreferences.getOpzioniMassimiXY(3, modo)), true);
        this.aggiornaGrafico = true;
    }

    public void costruisciInterfaccia() {
        this.pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloCentrale = new JPanel();
        GridLayout griglia = new GridLayout(0, 4, 10, 10);
        pannelloCentrale.setLayout(griglia);
        String[] CanaliList = new String[]{"Gps speed", "Rpm", "Speed1", "Speed2", "Analog1", "Analog2", "Analog3", "Analog4", "Analog5", "Analog6", "Analog7", "Analog8", "Ext-1", "Ext-2", "d(Gps speed)", "d(Rpm)", "d(Speed1)", "d(Speed2)", "d(Analog1)", "d(Analog2)", "d(Analog3)", "d(Analog4)", "d(Analog5)", "d(Analog6)", "d(Analog7)", "d(Analog8)", "d(Ext-1)", "d(Ext-2)", "Gears", "Gears ratio", "Math1", "Math2", "Multi1", "Multi2", "Multi3", "Multi4", "Multi5", "Multi6", "Multi7", "Multi8", "Multi9", "Multi10", "Gps angle", "Acc. lat.", "Altitud.", "Delay", "Slip"};
        String[] CanaliList2 = new String[]{"Nessuno", "Gps speed", "Rpm", "Speed1", "Speed2", "Analog1", "Analog2", "Analog3", "Analog4", "Analog5", "Analog6", "Analog7", "Analog8", "Ext-1", "Ext-2", "d(Gps speed)", "d(Rpm)", "d(Speed1)", "d(Speed2)", "d(Analog1)", "d(Analog2)", "d(Analog3)", "d(Analog4)", "d(Analog5)", "d(Analog6)", "d(Analog7)", "d(Analog8)", "d(Ext-1)", "d(Ext-2)", "Gears", "Gears ratio", "Math1", "Math2", "Multi1", "Multi2", "Multi3", "Multi4", "Multi5", "Multi6", "Multi7", "Multi8", "Multi9", "Multi10", "Gps angle", "Acc. lat.", "Altitud.", "Delay", "Slip"};
        String[] SottocampionaList = new String[]{"Nessuna", "2", "5", "10", "20", "50", "100"};
        this.canaleXCB = new JComboBox<String>(CanaliList);
        this.canaleYCB = new JComboBox<String>(CanaliList);
        this.canaleZCB = new JComboBox<String>(CanaliList2);
        this.canaleXCB.addActionListener(this);
        this.canaleYCB.addActionListener(this);
        this.canaleZCB.addActionListener(this);
        this.sottocampionaturaCB = new JComboBox<String>(SottocampionaList);
        this.sottocampionaturaCB.setSelectedIndex(3);
        this.sottocampionaturaCB.addActionListener(this);
        NumberFormat assiFormat = NumberFormat.getNumberInstance(Locale.US);
        assiFormat.setMaximumIntegerDigits(10);
        assiFormat.setMaximumFractionDigits(2);
        assiFormat.setGroupingUsed(false);
        this.minimoX = new JFormattedTextField(assiFormat);
        this.minimoX.setHorizontalAlignment(11);
        this.minimoX.setValue(0.0);
        this.minimoX.addActionListener(this);
        this.massimoX = new JFormattedTextField(assiFormat);
        this.massimoX.setHorizontalAlignment(11);
        this.massimoX.setValue(100.0);
        this.massimoX.addActionListener(this);
        this.minimoY = new JFormattedTextField(assiFormat);
        this.minimoY.setHorizontalAlignment(11);
        this.minimoY.setValue(0.0);
        this.minimoY.addActionListener(this);
        this.massimoY = new JFormattedTextField(assiFormat);
        this.massimoY.setHorizontalAlignment(11);
        this.massimoY.setValue(100.0);
        this.massimoY.addActionListener(this);
        this.minimoZ = new JFormattedTextField(assiFormat);
        this.minimoZ.setHorizontalAlignment(11);
        this.minimoZ.setValue(0.0);
        this.minimoZ.addActionListener(this);
        this.massimoZ = new JFormattedTextField(assiFormat);
        this.massimoZ.setHorizontalAlignment(11);
        this.massimoZ.setValue(100.0);
        this.massimoZ.addActionListener(this);
        this.bloccaX = new JCheckBox(Language.string("Blocca X"));
        this.bloccaY = new JCheckBox(Language.string("Blocca Y"));
        this.bloccaZ = new JCheckBox(Language.string("Blocca Z"));
        this.grigliaX = new JCheckBox(Language.string("Griglia X"));
        this.grigliaY = new JCheckBox(Language.string("Griglia Y"));
        this.mostraLegenda = new JCheckBox(Language.string("Mostra legenda"));
        this.mostraAssi = new JCheckBox(Language.string("Mostra Assi"));
        this.grigliaX.setSelected(true);
        this.grigliaY.setSelected(true);
        this.grigliaX.addActionListener(this);
        this.grigliaY.addActionListener(this);
        this.mostraLegenda.setSelected(false);
        this.mostraLegenda.addActionListener(this);
        this.mostraAssi.setSelected(true);
        this.mostraAssi.addActionListener(this);
        this.autoscaling = new JCheckBox(Language.string("Autoscaling"));
        this.autoscaling.setSelected(true);
        this.comboMode = new JComboBox();
        this.aggiornaComboModo();
        this.comboMode.setEditable(true);
        this.comboMode.addActionListener(this);
        this.salvaB = new JButton(Language.string("Salva"));
        this.salvaB.addActionListener(this);
        JLabel canaleXLabel = new JLabel(Language.string("Canale asse X:"));
        JLabel canaleYLabel = new JLabel(Language.string("Canale asse Y:"));
        JLabel canaleZLabel = new JLabel(Language.string("Canale asse :"));
        JLabel minimoYLabel = new JLabel(Language.string("Minimo Asse Y:"));
        JLabel massimoYLabel = new JLabel(Language.string("Massimo Asse Y:"));
        JLabel minimoXLabel = new JLabel(Language.string("Minimo Asse X:"));
        JLabel massimoXLabel = new JLabel(Language.string("Massimo Asse X:"));
        JLabel minimoZLabel = new JLabel(Language.string("Minimo Asse Z:"));
        JLabel massimoZLabel = new JLabel(Language.string("Massimo Asse Z:"));
        JLabel campionaLabel = new JLabel(Language.string("Sottocampionatura:"));
        JLabel modoLabel = new JLabel(Language.string("Configurazioni:"));
        JLabel attenzione = new JLabel(Language.string("      Attenzione: battere invio per confermare OGNI valore immesso."));
        this.coloreGraficoXY = new JTextField(10);
        this.coloreGraficoXY.setBackground(Color.BLACK);
        this.coloreGraficoXY.setEditable(false);
        JLabel coloreLabel = new JLabel("      ");
        coloreLabel.setLabelFor(this.coloreGraficoXY);
        this.coloreSfondoXY = new JButton(Language.string("Colore sfondo"));
        this.coloreSfondoXY.addActionListener(this);
        pannelloCentrale.add(canaleXLabel);
        pannelloCentrale.add(this.canaleXCB);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(minimoXLabel);
        pannelloCentrale.add(this.minimoX);
        pannelloCentrale.add(massimoXLabel);
        pannelloCentrale.add(this.massimoX);
        pannelloCentrale.add(canaleYLabel);
        pannelloCentrale.add(this.canaleYCB);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(minimoYLabel);
        pannelloCentrale.add(this.minimoY);
        pannelloCentrale.add(massimoYLabel);
        pannelloCentrale.add(this.massimoY);
        pannelloCentrale.add(canaleZLabel);
        pannelloCentrale.add(this.canaleZCB);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(minimoZLabel);
        pannelloCentrale.add(this.minimoZ);
        pannelloCentrale.add(massimoZLabel);
        pannelloCentrale.add(this.massimoZ);
        pannelloCentrale.add(this.bloccaX);
        pannelloCentrale.add(this.bloccaY);
        pannelloCentrale.add(this.bloccaZ);
        pannelloCentrale.add(this.autoscaling);
        pannelloCentrale.add(this.grigliaX);
        pannelloCentrale.add(this.grigliaY);
        pannelloCentrale.add(this.mostraLegenda);
        pannelloCentrale.add(this.mostraAssi);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(this.coloreSfondoXY);
        pannelloCentrale.add(this.coloreGraficoXY);
        pannelloCentrale.add(campionaLabel);
        pannelloCentrale.add(this.sottocampionaturaCB);
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(new JPanel());
        pannelloCentrale.add(modoLabel);
        pannelloCentrale.add(this.comboMode);
        pannelloCentrale.add(this.salvaB);
        pannelloCentrale.add(new JPanel());
        JPanel pannellosotto = new JPanel();
        GridLayout grigliaSotto = new GridLayout(2, 0, 10, 10);
        pannellosotto.setLayout(grigliaSotto);
        pannellosotto.add(attenzione);
        pannellosotto.add(Box.createRigidArea(new Dimension(10, 50)));
        this.pannelloPrincipale.add(Box.createRigidArea(new Dimension(30, 0)), "East");
        this.pannelloPrincipale.add((Component)pannelloCentrale, "Center");
        this.pannelloPrincipale.add(Box.createRigidArea(new Dimension(30, 0)), "West");
        this.pannelloPrincipale.add((Component)pannellosotto, "South");
        this.pannelloPrincipale.add(Box.createRigidArea(new Dimension(30, 20)), "North");
        this.pannelloPrincipale.setPreferredSize(new Dimension(450, 350));
        this.scrollPaneXY = new JScrollPane(this.pannelloPrincipale);
        this.pannelloPrincipale.setPreferredSize(new Dimension(580, 580));
    }

    public void aggiornaNomi() {
        int i;
        int selX = this.canaleXCB.getSelectedIndex();
        int selY = this.canaleYCB.getSelectedIndex();
        int selZ = this.canaleZCB.getSelectedIndex();
        if (DanasDataStructure.getInstance().getDefaultSession() == null) {
            return;
        }
        this.canaleXCB.removeAllItems();
        for (i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            this.canaleXCB.addItem(MeasuresUtil.getNomeCanale(i));
        }
        this.canaleYCB.removeAllItems();
        for (i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            this.canaleYCB.addItem(MeasuresUtil.getNomeCanale(i));
        }
        this.canaleZCB.removeAllItems();
        this.canaleZCB.addItem(Language.string("Nessuno"));
        for (i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            this.canaleZCB.addItem(MeasuresUtil.getNomeCanale(i));
        }
        this.canaleXCB.setSelectedIndex(selX);
        this.canaleYCB.setSelectedIndex(selY);
        this.canaleZCB.setSelectedIndex(selZ);
    }

    public void fittaAsseZ() {
        if (this.graphXy.getScene().getNChildren() == 0) {
            return;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        GScene s = this.graphXy.getScene();
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (((CurvaXY)s.getChild(j)).getMaxZ() > max) {
                max = ((CurvaXY)s.getChild(j)).getMaxZ();
            }
            if (!(((CurvaXY)s.getChild(j)).getMinZ() < min)) continue;
            min = ((CurvaXY)s.getChild(j)).getMinZ();
        }
        if (max == min) {
            max += 1.0;
            min -= 1.0;
        }
        this.graphXy.setAsseZ(min, max, true);
    }

    public void aggiornaLabelAssi() {
        this.graphXy.refreshAssi();
    }

    public void fittaVerticale() {
        if (this.graphXy.getScene().getNChildren() == 0) {
            return;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        GScene s = this.graphXy.getScene();
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (((CurvaXY)s.getChild(j)).getMaxY() > max) {
                max = ((CurvaXY)s.getChild(j)).getMaxY();
            }
            if (!(((CurvaXY)s.getChild(j)).getMinY() < min)) continue;
            min = ((CurvaXY)s.getChild(j)).getMinY();
        }
        if ((max += Math.abs(max - (min -= Math.abs(max - min) * 0.05)) * 0.05) == min) {
            max += 1.0;
            min -= 1.0;
        }
        this.graphXy.setAsseY(min, max, true, true);
    }

    public void fittaOrizzontale() {
        if (this.graphXy.getScene().getNChildren() == 0) {
            return;
        }
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        GScene s = this.graphXy.getScene();
        for (int j = 0; j < s.getNChildren(); ++j) {
            if (((CurvaXY)s.getChild(j)).getMaxX() > max) {
                max = ((CurvaXY)s.getChild(j)).getMaxX();
            }
            if (!(((CurvaXY)s.getChild(j)).getMinX() < min)) continue;
            min = ((CurvaXY)s.getChild(j)).getMinX();
        }
        if ((max += Math.abs(max - (min -= Math.abs(max - min) * 0.05)) * 0.05) == min) {
            max += 1.0;
            min -= 1.0;
        }
        this.graphXy.setAsseX(min, max, true, true);
    }

    private void aggiornaCurve() {
        boolean monoColore = false;
        this.graphXy.rimuoviTutto();
        int r = this.sottocampionaturaCB.getSelectedIndex() == 0 ? 1 : Integer.valueOf((String)this.sottocampionaturaCB.getSelectedItem());
        int canaleX = this.canaleXCB.getSelectedIndex();
        int canaleY = this.canaleYCB.getSelectedIndex();
        int canaleZ = this.canaleZCB.getSelectedIndex() - 1;
        if (canaleZ == -1) {
            monoColore = true;
            canaleZ = 1;
        }
        DanasDataStructureConstants.ValueType vtX = MeasuresUtil.getValueType(canaleX);
        DanasDataStructureConstants.ValueType vtY = MeasuresUtil.getValueType(canaleY);
        DanasDataStructureConstants.ValueType vtZ = MeasuresUtil.getValueType(canaleZ);
        Vector<CurvaXY> elencoCurve = DanasDataStructure.getInstance().getCurvaSelectedLapXY(vtX, vtY, vtZ, r, monoColore);
        if (elencoCurve.size() != 0) {
            CurvaXY c = elencoCurve.elementAt(0);
            c.setSpessore(0);
            c.setStile(0);
            this.graphXy.aggiungiCurvaXY(c);
            if (elencoCurve.size() > 1) {
                c = elencoCurve.elementAt(1);
                c.setSpessore(0);
                c.setStile(0);
                this.graphXy.aggiungiCurvaXY(c);
            }
        }
        if (elencoCurve.size() > 2) {
            this.requestFocus();
            JOptionPane.showMessageDialog(this, Language.string("Ci sono pi\u00f9 di due giri selezionati: verranno analizzati solo i primi due"), Language.string("ATTENZIONE"), 2);
            DanasDataStructure.getInstance().getMainFrame().richiediFuoco();
        }
        if (this.autoscaling.isSelected()) {
            this.fittaVerticale();
            this.fittaOrizzontale();
            this.fittaAsseZ();
        } else {
            this.graphXy.setAsseX(Double.valueOf(this.minimoX.getValue().toString()), Double.valueOf(this.massimoX.getValue().toString()), true, true);
            this.graphXy.setAsseY(Double.valueOf(this.minimoY.getValue().toString()), Double.valueOf(this.massimoY.getValue().toString()), true, true);
            this.graphXy.setAsseZ(Double.valueOf(this.minimoZ.getValue().toString()), Double.valueOf(this.massimoZ.getValue().toString()), true);
        }
        this.graphXy.ridisegnaSfondo();
        this.graphXy.refresh();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        DanasPreferences.setPosizioneXXY(this.getLocationOnScreen().x);
        DanasPreferences.setPosizioneYXY(this.getLocationOnScreen().y);
        DanasPreferences.setLarghezzaXY(this.getWidth());
        DanasPreferences.setAltezzaXY(this.getHeight());
        this.padre.setXYChiusa();
        this.visibile = false;
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Color color;
        if (arg0.getSource().equals(this.popupZoomIn)) {
            Objects.requireNonNull(this.padre);
            this.padre.selezionaTastoGrafico(2);
        }
        if (arg0.getSource().equals(this.popupZoomOut)) {
            Objects.requireNonNull(this.padre);
            this.padre.selezionaTastoGrafico(3);
        }
        if (arg0.getSource().equals(this.popupZoomWindow)) {
            Objects.requireNonNull(this.padre);
            this.padre.selezionaTastoGrafico(4);
        }
        if (arg0.getSource().equals(this.popupMuovi)) {
            Objects.requireNonNull(this.padre);
            this.padre.selezionaTastoGrafico(5);
        }
        if (arg0.getSource().equals(this.popupFittaTutto)) {
            this.fittaOrizzontale();
            this.fittaVerticale();
        }
        if (arg0.getSource().equals(this.popupFittaVert)) {
            this.fittaVerticale();
        }
        if (arg0.getSource().equals(this.popupOpzioni)) {
            this.contenitore.setSelectedIndex(1);
        }
        if (arg0.getSource().equals(this.popupFittaH)) {
            this.fittaOrizzontale();
        }
        if (arg0.getSource().equals(this.comboMode)) {
            if (this.comboMode.getSelectedIndex() != -1) {
                this.modoAttuale = this.comboMode.getSelectedIndex();
                this.caricaPreferenze(this.modoAttuale);
            } else {
                return;
            }
        }
        if (arg0.getSource().equals(this.esciB)) {
            this.padre.setXYChiusa();
            this.visibile = false;
            this.dispose();
        }
        if (arg0.getSource().equals(this.fittaAllB)) {
            this.fittaVerticale();
            this.fittaOrizzontale();
            this.graphXy.refresh();
        }
        if (arg0.getSource().equals(this.salvaB)) {
            this.salvaPreferenze();
        }
        if (arg0.getSource().equals(this.fittaXB)) {
            this.fittaOrizzontale();
            this.graphXy.refresh();
        }
        if (arg0.getSource().equals(this.fittaYB)) {
            this.fittaVerticale();
            this.graphXy.refresh();
        }
        if (arg0.getSource().equals(this.coloreSfondoXY) && (color = JColorChooser.showDialog(this, Language.string("Colore sfondo del grafico"), this.coloreGraficoXY.getBackground())) != null) {
            this.graphXy.setBackgroundColor(color);
            this.coloreGraficoXY.setBackground(color);
        }
        if (arg0.getSource().equals(this.grigliaX)) {
            this.graphXy.setGrigliaOrizzontale(this.grigliaX.isSelected());
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.mostraLegenda)) {
            this.graphXy.setLegenda(this.mostraLegenda.isSelected());
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.mostraAssi)) {
            this.graphXy.mostraAssi(this.mostraAssi.isSelected());
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.grigliaY)) {
            this.graphXy.setGriliaVerticale(this.grigliaY.isSelected());
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.bloccaX)) {
            this.graphXy.setBloccaX(this.bloccaX.isSelected());
        }
        if (arg0.getSource().equals(this.bloccaY)) {
            this.graphXy.setBloccaY(this.bloccaY.isSelected());
        }
        if (arg0.getSource().equals(this.minimoY) || arg0.getSource().equals(this.massimoY)) {
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.minimoX) || arg0.getSource().equals(this.massimoX)) {
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.minimoZ) || arg0.getSource().equals(this.massimoZ)) {
            this.graphXy.setAsseZ(Double.valueOf(this.minimoZ.getValue().toString()), Double.valueOf(this.massimoZ.getValue().toString()), true);
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.sottocampionaturaCB)) {
            this.aggiornaCurve = true;
            this.aggiornaGrafico = true;
        }
        if (arg0.getSource().equals(this.canaleXCB) || arg0.getSource().equals(this.canaleYCB) || arg0.getSource().equals(this.canaleZCB)) {
            this.aggiornaCurve = true;
            this.aggiornaGrafico = true;
            if (arg0.getSource().equals(this.canaleZCB) && this.canaleZCB.getSelectedIndex() != 0) {
                this.mostraLegenda.setSelected(true);
                this.graphXy.setLegenda(this.mostraLegenda.isSelected());
            }
        }
        if (arg0.getSource().equals(this.zoomCB)) {
            int modo;
            switch (this.zoomCB.getSelectedIndex()) {
                case 0: {
                    modo = 5;
                    break;
                }
                case 1: {
                    modo = 3;
                    break;
                }
                case 2: {
                    modo = 4;
                    break;
                }
                case 3: {
                    modo = 2;
                    break;
                }
                default: {
                    modo = 5;
                }
            }
            this.graphXy.setMode(modo);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource().equals(this.contenitore)) {
            if (this.contenitore.getSelectedIndex() == 1) {
                this.graphXy.aggiornaEstremiTutti();
                this.contenitore.setComponentAt(0, null);
                this.altezzaDialog = this.getHeight();
                this.larghezzaDialog = this.getWidth();
                this.posX = this.getLocationOnScreen().x;
                this.posY = this.getLocationOnScreen().y;
                this.setSize(650, 650);
                this.setLocationRelativeTo(null);
            }
            if (this.contenitore.getSelectedIndex() == 0) {
                this.setSize(this.larghezzaDialog, this.altezzaDialog);
                this.setLocation(this.posX, this.posY);
                this.contenitore.setComponentAt(0, this.pannelloTabella);
                if (this.aggiornaCurve) {
                    this.aggiornaCurve = false;
                    this.aggiornaCurve();
                }
                if (this.canaleZCB.getSelectedIndex() == 0) {
                    this.mostraLegenda.setSelected(false);
                    this.graphXy.setLegenda(this.mostraLegenda.isSelected());
                }
                if (this.aggiornaGrafico) {
                    this.aggiornaGrafico = false;
                    this.graphXy.setAsseXY(Double.valueOf(this.minimoX.getValue().toString()), Double.valueOf(this.massimoX.getValue().toString()), Double.valueOf(this.minimoY.getValue().toString()), Double.valueOf(this.massimoY.getValue().toString()), true, true);
                }
            }
        }
        if (arg0.getSource().equals(DanasDataStructure.getInstance())) {
            if (!this.visibile) {
                return;
            }
            DanasDataStructure dati = DanasDataStructure.getInstance();
            System.out.println("Grafico XY: change listener=" + (Object)((Object)dati.getChange()));
            switch (dati.getChange()) {
                case REFRESH_ALL: 
                case REMOVE_DATA: 
                case NEW_DATA: 
                case SEL_SESSION: 
                case DESEL_SESSION: 
                case SEL_ALL_SESSION: 
                case DESEL_ALL_SESSION: 
                case SET_REF_SESSION: 
                case SEL_LAP: 
                case DESEL_LAP: 
                case SEL_ALL_LAP: 
                case DESEL_ALL_LAP: 
                case SET_REF_LAP: 
                case SET_GOAL: 
                case LAP_COLOR: 
                case NEW_SETTINGS: {
                    this.aggiornaCurve();
                    this.aggiornaNomi();
                    this.graphXy.setAsseXY(Double.valueOf(this.minimoX.getValue().toString()), Double.valueOf(this.massimoX.getValue().toString()), Double.valueOf(this.minimoY.getValue().toString()), Double.valueOf(this.massimoY.getValue().toString()), true, true);
                    break;
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        GraficoXYDialog i = new GraficoXYDialog(null);
        i.setVisible(true);
    }
}

