/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Language;
import i2m.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class FftOptionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JComboBox windowCB;
    JRadioButton linear;
    JRadioButton log;
    JRadioButton ampiezza;
    JRadioButton potenza;

    public FftOptionDialog(MainFrame owner) {
        super(owner, Language.string("Opzioni FFT"), false);
        this.costruisciInterfaccia();
        this.pack();
        this.setResizable(false);
        this.setAlwaysOnTop(true);
    }

    public void costruisciInterfaccia() {
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        this.setContentPane(pannelloPrincipale);
        JPanel pannelloCentrale = new JPanel();
        pannelloCentrale.setLayout(new BoxLayout(pannelloCentrale, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        panel.add(new JLabel("Window:"));
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        String[] list = new String[]{"rectangular", "Hanning", "Hamming", "Triangular"};
        this.windowCB = new JComboBox<String>(list);
        this.windowCB.setSelectedIndex(0);
        this.windowCB.addActionListener(this);
        panel.add(this.windowCB);
        panel.add(Box.createRigidArea(new Dimension(20, 0)));
        pannelloCentrale.add(Box.createRigidArea(new Dimension(20, 10)));
        pannelloCentrale.add(panel);
        this.linear = new JRadioButton(Language.string("Scala lineare"));
        this.log = new JRadioButton(Language.string("Scala logaritmica"));
        this.linear.addActionListener(this);
        this.log.addActionListener(this);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.linear);
        group1.add(this.log);
        this.linear.setSelected(true);
        panel = new JPanel();
        panel.add(Box.createRigidArea(new Dimension(15, 0)));
        panel.add(this.linear);
        panel.add(this.log);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(20, 5)));
        pannelloCentrale.add(panel);
        this.ampiezza = new JRadioButton(Language.string("Ampiezza"));
        this.potenza = new JRadioButton(Language.string("Potenza"));
        this.ampiezza.addActionListener(this);
        this.potenza.addActionListener(this);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.ampiezza);
        group2.add(this.potenza);
        this.ampiezza.setSelected(true);
        panel = new JPanel();
        panel.add(Box.createRigidArea(new Dimension(15, 0)));
        panel.add(this.ampiezza);
        panel.add(this.potenza);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(20, 5)));
        pannelloCentrale.add(panel);
        pannelloCentrale.add(Box.createRigidArea(new Dimension(20, 10)));
        pannelloPrincipale.add((Component)pannelloCentrale, "Center");
    }

    public void aggiornaValori() {
        if (DanasDataStructure.getInstance().getMainFrame().getFftLineare()) {
            this.linear.setSelected(true);
        } else {
            this.log.setSelected(true);
        }
        if (DanasDataStructure.getInstance().getMainFrame().getFftAmpiezza()) {
            this.ampiezza.setSelected(true);
        } else {
            this.potenza.setSelected(true);
        }
        this.windowCB.setSelectedIndex(DanasDataStructure.getInstance().getMainFrame().getFftFinestra());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DanasDataStructure.getInstance().getMainFrame().setFftLineare(this.linear.isSelected());
        DanasDataStructure.getInstance().getMainFrame().setFftAmpiezza(this.ampiezza.isSelected());
        DanasDataStructure.getInstance().getMainFrame().setFftFinestra(this.windowCB.getSelectedIndex());
        DanasPreferences.setPrefFFTAmpiezza(this.ampiezza.isSelected());
        DanasPreferences.setPrefFFTLineare(this.linear.isSelected());
        DanasPreferences.setPrefFFTFinestra(this.windowCB.getSelectedIndex());
        DanasDataStructure.getInstance().getMainFrame().ricalcolaGraficiFft();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FftOptionDialog d = new FftOptionDialog(null);
                d.setLocationRelativeTo(null);
                d.setVisible(true);
            }
        });
    }
}

