/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Dialog.FileLoader;
import i2m.Dialog.HwDasy4;
import i2m.Dialog.HwDasy6;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class DanasSD {
    public static boolean impos_locked = false;
    public static HwDasy4 impostazioni = null;
    private static boolean dasy6 = false;

    public static void saveSD(String filename, boolean isDasy6) throws Exception {
        dasy6 = isDasy6;
        if (!DanasSD.checkSD(filename)) {
            throw new Exception(filename + " does_not_seem_to_be_a_valid_SD_file!");
        }
        String impos_str = "<not_created>";
        try {
            RandomAccessFile f = new RandomAccessFile(new File(filename), "rwd");
            if (!dasy6) {
                impos_str = DanasSD.createImposString(DanasSD.isFormatted(f));
            } else {
                DanasDataStructure.getInstance();
                impos_str = HwDasy6.createImposString6();
            }
            f.seek(0L);
            f.write(impos_str.getBytes());
            f.close();
        }
        catch (Exception ex) {
            throw new Exception("Unable_to_save_hardware_settings_on " + filename + ":\n" + ex.getMessage());
        }
    }

    private static boolean checkSD(String filename) {
        RandomAccessFile f = null;
        try {
            File file = new File(filename);
            f = new RandomAccessFile(file, "r");
            f.seek(0L);
            f.readLine();
            f.close();
            if (!file.getName().equalsIgnoreCase("dati.txt")) {
                throw new Exception("Wrong file name (should be dati.txt)");
            }
        }
        catch (Exception ex) {
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static void loadSD(String filename, boolean isDasy6) throws Exception {
        dasy6 = isDasy6;
        try (FileLoader loader = null;){
            String str;
            loader = new FileLoader(filename);
            while ((str = loader.getNextLine()) != null) {
                if (!str.startsWith("$IMPOS")) continue;
                if (dasy6) {
                    DanasDataStructure.getInstance();
                    DanasDataStructure.impostazioni6.parseImposString6(str);
                } else {
                    DanasSD.parseImposString(str);
                }
                break;
            }
        }
    }

    public static void parseImposString(String str) throws Exception {
        StringTokenizer st = new StringTokenizer(str, ",");
        int rpm = 1;
        int vel1 = 1;
        int vel2 = 1;
        int tempo = 1;
        int sGps = 1;
        int sRpm = 1;
        int sRemoto = 1;
        int sVel1 = 1;
        int sVel2 = 1;
        try {
            int val;
            st.nextElement();
            st.nextToken();
            tempo = Integer.parseInt(st.nextToken());
            vel1 = Integer.parseInt(st.nextToken());
            vel2 = Integer.parseInt(st.nextToken());
            rpm = Integer.parseInt(st.nextToken());
            st.nextToken();
            int rest = val = Integer.parseInt(st.nextToken());
            if (rest / 32 > 0) {
                rest -= 32;
            }
            if (rest / 16 > 0) {
                rest -= 16;
                sGps = 1;
            } else {
                sGps = 0;
            }
            if (rest / 8 > 0) {
                rest -= 8;
                sRpm = 1;
            } else {
                sRpm = 0;
            }
            if (rest / 4 > 0) {
                rest -= 4;
                sVel2 = 1;
            } else {
                sVel2 = 0;
            }
            if (rest / 2 > 0) {
                rest -= 2;
                sVel1 = 1;
            } else {
                sVel1 = 0;
            }
            if (rest / 1 > 0) {
                --rest;
                sRemoto = 1;
            } else {
                sRemoto = 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Parser error: " + ex);
        }
        DanasDataStructure.getInstance();
        DanasDataStructure.impostazioni = new HwDasy4(rpm, vel1, vel2, tempo, sGps, sVel1, sVel2, sRemoto, sRpm);
    }

    public static HwDasy4 getImpos() {
        return impostazioni;
    }

    public static String createImposString(boolean format) {
        DanasDataStructure.getInstance();
        if (DanasDataStructure.impostazioni == null) {
            return "$IMPOS,1000,10,29,5,2,1,49,0,0,";
        }
        DanasDataStructure.getInstance();
        HwDasy4 impos = DanasDataStructure.impostazioni;
        String impos_str = new String("$IMPOS");
        impos_str = impos_str + ",1000";
        impos_str = impos_str + "," + impos.getSetting(3);
        impos_str = impos_str + "," + impos.getSetting(1);
        impos_str = impos_str + "," + impos.getSetting(2);
        impos_str = impos_str + "," + impos.getSetting(0);
        int auto_start_val = 0;
        if (impos.getSetting(6) == 1) {
            ++auto_start_val;
        }
        if (impos.getSetting(7) == 1) {
            auto_start_val += 2;
        }
        if (impos.getSetting(8) == 1) {
            auto_start_val += 4;
        }
        if (impos.getSetting(5) == 1) {
            auto_start_val += 8;
        }
        if (impos.getSetting(4) == 1) {
            auto_start_val += 16;
        }
        impos_str = impos_str + ",1," + auto_start_val;
        impos_str = format ? impos_str + ",0,1," : impos_str + ",0,0,";
        return impos_str;
    }

    public static boolean isFormatted(RandomAccessFile f) {
        try {
            f.seek(0L);
            String s = f.readLine();
            int pos = 0;
            int c = 0;
            while ((pos = s.indexOf(",", pos)) > -1) {
                ++pos;
                if (++c != 9) continue;
                String check = s.substring(pos, pos + 1);
                return check.equals("1");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

