/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.Dialog.FileLoader;
import i2m.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DanasCalibration {
    private JDialog dialog = null;
    private Frame parent = null;
    public static final int NONE = -1;
    public static final int OVERVIEW = 0;
    public static final int SD_SETUP = 1;
    public static final int INSTRUCTIONS = 2;
    public static final int SD_ASK = 3;
    public static final int ADDITIONAL_DATA_ASK = 4;
    public static final int RESULT = 5;
    private int status = 0;
    private double calibration_value = 0.0;
    private int result_value = 0;
    private JTextField fileTextField = null;
    private JButton selectFileButton = null;
    private JTextField pinionField = null;
    private JTextField ringGearField = null;
    private JTextField turnsField = null;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        frame.setVisible(true);
        DanasCalibration calib = new DanasCalibration(frame);
        calib.showDialog();
    }

    public DanasCalibration(Frame _parent) {
        this.parent = _parent;
    }

    public void showDialog() {
        this.dialog = new JDialog(this.parent, "Danas Auto Calibration Tool");
        this.dialog.setResizable(false);
        this.dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (DanasCalibration.this.status == -1) {
                    if (DanasCalibration.this.parent == null) {
                        System.exit(0);
                    }
                    DanasCalibration.this.dialog.setEnabled(false);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DanasCalibration.this.status = -1;
                DanasCalibration.this.dialog.dispose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.dialog.getContentPane().add(this.getContent());
        this.dialog.setSize(new Dimension(500, 350));
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
    }

    private JPanel getContent() {
        System.out.println("Creating calibration dialog content...");
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(0, 0, 0, 0);
        int pos = 0;
        gc.gridx = 0;
        gc.gridy = pos++;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        panel.add((Component)this.getStepPanel(this.status), gc);
        gc.gridx = 0;
        gc.gridy = pos++;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        panel.add((Component)this.getButtonsPanel(), gc);
        System.out.println("Ok, calibration dialog completed...");
        return panel;
    }

    private JPanel getButtonsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        int pos = 0;
        JSeparator line = new JSeparator();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 4;
        gc.weighty = 0.0;
        gc.insets = new Insets(2, 2, 2, 2);
        gc.fill = 2;
        panel.add((Component)line, gc);
        JButton cancel = new JButton(Language.string("Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DanasCalibration.this.status = -1;
                DanasCalibration.this.dialog.dispose();
            }
        });
        gc.gridx = pos++;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        gc.insets = new Insets(10, 10, 10, 10);
        gc.fill = 2;
        panel.add((Component)cancel, gc);
        JPanel spacer = new JPanel();
        gc.gridx = pos++;
        gc.weightx = 1.0;
        gc.fill = 2;
        panel.add((Component)spacer, gc);
        JButton previous = new JButton("< " + Language.string("Previous"));
        previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DanasCalibration.this.status--;
                DanasCalibration.this.dialog.dispose();
                DanasCalibration.this.dialog.getContentPane().removeAll();
                DanasCalibration.this.dialog.getContentPane().add(DanasCalibration.this.getContent());
                DanasCalibration.this.dialog.setVisible(true);
            }
        });
        if (this.status == 0) {
            previous.setEnabled(false);
        }
        gc.gridx = pos++;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        panel.add((Component)previous, gc);
        JButton next = new JButton(Language.string("Next") + " >");
        if (this.status == 5) {
            next.setText(Language.string("Finish"));
        } else if (this.status == 3) {
            next.setText(Language.string("Load"));
        } else if (this.status == 1) {
            next.setText(Language.string("Write"));
        }
        next.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (DanasCalibration.this.status == 1) {
                    String msg = Language.string("All data in the SD file will be lost! Are you sure you want to write ");
                    int ch = JOptionPane.showConfirmDialog(DanasCalibration.this.dialog, msg + DanasCalibration.this.fileTextField.getText() + "?", "Setup SD", 0, 2);
                    if (ch != 0) return;
                    try {
                        DanasCalibration.this.writeCalib();
                    }
                    catch (Exception ex) {
                        return;
                    }
                } else if (DanasCalibration.this.status == 3) {
                    try {
                        DanasCalibration.this.calibration_value = DanasCalibration.this.readCalib();
                        System.out.println("Calibration value is " + DanasCalibration.this.calibration_value);
                    }
                    catch (Exception ex) {
                        return;
                    }
                } else if (DanasCalibration.this.status == 4) {
                    try {
                        DanasCalibration.this.result_value = DanasCalibration.this.calculateResult();
                    }
                    catch (Exception ex) {
                        return;
                    }
                } else if (DanasCalibration.this.status == 2) {
                    try {
                        DanasCalibration.this.checkTurnsValue();
                    }
                    catch (Exception ex) {
                        String msg1 = Language.string("Turns value is incorrect");
                        String msg2 = Language.string("It should be an integer greater then 0");
                        JOptionPane.showMessageDialog(DanasCalibration.this.dialog, msg1 + " (" + DanasCalibration.this.turnsField.getText() + ")\n " + msg2 + ".", Language.string("Wrong_number"), 0);
                    }
                } else if (DanasCalibration.this.status == 5) {
                    DanasCalibration.this.status = -1;
                    DanasCalibration.this.dialog.dispose();
                    return;
                }
                DanasCalibration.this.status++;
                DanasCalibration.this.dialog.dispose();
                DanasCalibration.this.dialog.getContentPane().removeAll();
                DanasCalibration.this.dialog.getContentPane().add(DanasCalibration.this.getContent());
                DanasCalibration.this.dialog.setVisible(true);
            }
        });
        gc.gridx = pos++;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        panel.add((Component)next, gc);
        return panel;
    }

    private JPanel getStepPanel(int step) {
        System.out.println("Calibration dialog showing step " + step);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        JTextArea text = new JTextArea();
        text.setEditable(false);
        text.setOpaque(false);
        text.setFont(new Font("Helvetica", 0, 14));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        switch (step) {
            case 0: {
                String msg1 = Language.string("Welcome to Danas Auto Calibration Tool:");
                String msg2 = Language.string("The following wizard will guide you into your Dasy4 speed calibration");
                String msg3 = Language.string("The_calibration_requires a motorbike with a Dasy4 telemetry installed on");
                String msg4 = Language.string("Click") + " " + Language.string("Next") + " " + Language.string("to begin the calibration process");
                gc.gridx = 0;
                gc.gridy = 0;
                gc.weightx = 1.0;
                gc.weighty = 1.0;
                gc.insets = new Insets(20, 20, 20, 20);
                gc.fill = 1;
                panel.add((Component)new JLabel("<html>" + msg1 + "<br><br>" + msg2 + ". " + msg3 + ".<br>" + msg4 + ".</html>"), gc);
                break;
            }
            case 1: {
                String msg5 = Language.string("SDSetup:");
                String msg6 = Language.string("Now, insert your SD and specify the path to your SD data file in the form below");
                gc.gridx = 0;
                gc.gridy = 0;
                gc.weightx = 1.0;
                gc.weighty = 1.0;
                gc.gridwidth = 3;
                gc.insets = new Insets(20, 20, 20, 20);
                gc.fill = 1;
                panel.add((Component)new JLabel("<html>" + msg5 + "<br>" + msg6 + ".</html>"), gc);
                gc.gridx = 0;
                gc.gridy = 1;
                gc.weighty = 0.0;
                gc.weightx = 0.0;
                gc.gridwidth = 1;
                gc.fill = 2;
                gc.insets = new Insets(5, 5, 5, 5);
                JLabel saveFileLabel = new JLabel("    SD File:");
                panel.add((Component)saveFileLabel, gc);
                gc.gridx = 1;
                gc.weightx = 1.0;
                this.fileTextField = this.fileTextField != null ? new JTextField(this.fileTextField.getText().toString()) : new JTextField(new File("").getAbsolutePath());
                this.fileTextField.setEditable(true);
                this.fileTextField.setColumns(20);
                panel.add((Component)this.fileTextField, gc);
                gc.gridx = 2;
                this.selectFileButton = new JButton(Language.string("Browse"));
                this.selectFileButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JFileChooser fc = new JFileChooser();
                        fc.setCurrentDirectory(new File("."));
                        fc.setFileSelectionMode(0);
                        fc.setMultiSelectionEnabled(false);
                        fc.showOpenDialog(DanasCalibration.this.dialog);
                        File f = fc.getSelectedFile();
                        try {
                            f.setReadable(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (f != null) {
                            DanasCalibration.this.fileTextField.setText(f.getPath());
                        }
                    }
                });
                panel.add((Component)this.selectFileButton, gc);
                JButton skip = new JButton(Language.string("If you already have a SD with the calibration value you can skip this step"));
                skip.setMinimumSize(new Dimension(480, 25));
                skip.setPreferredSize(new Dimension(480, 25));
                skip.setToolTipText(Language.string("If you already have a SD with the calibration value you can skip this step"));
                skip.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DanasCalibration.this.status++;
                        DanasCalibration.this.dialog.dispose();
                        DanasCalibration.this.dialog.getContentPane().removeAll();
                        DanasCalibration.this.dialog.getContentPane().add(DanasCalibration.this.getContent());
                        DanasCalibration.this.dialog.setVisible(true);
                    }
                });
                gc.gridx = 0;
                gc.gridy = 2;
                gc.gridwidth = 3;
                gc.weighty = 0.0;
                gc.weightx = 0.0;
                gc.fill = 0;
                panel.add((Component)skip, gc);
                gc.gridx = 0;
                gc.gridy = 3;
                gc.weighty = 1.0;
                gc.gridwidth = 3;
                gc.fill = 1;
                JPanel setup_spacer = new JPanel();
                setup_spacer.setOpaque(false);
                panel.add((Component)setup_spacer, gc);
                break;
            }
            case 2: {
                String msg7 = Language.string("Insert the SD into the Dasy4 telemetry and turn it on:");
                String msg8 = Language.string("Then make the rear wheel perform a number of complete turns, the more the better (a good number starts from 10).");
                String msg9 = Language.string("You could chalk the starting position to help yourself take note of the exact number of turns.");
                String msg10 = Language.string("When you have finished, wait for the telemetry to write on the SD and then turn it off.");
                String msg11 = Language.string("Write in the field below the exact number of turns you performed.");
                String msg12 = Language.string("Then click") + " " + Language.string("Next") + " " + Language.string("to continue");
                text.append(msg7 + ".\n" + msg8 + ".\n" + msg9 + ".\n" + msg10 + ".\n" + msg11 + ".\n" + msg12 + ".");
                gc.gridx = 0;
                gc.gridy = 0;
                gc.weightx = 1.0;
                gc.weighty = 1.0;
                gc.gridwidth = 3;
                gc.insets = new Insets(20, 20, 20, 20);
                gc.fill = 1;
                panel.add((Component)new JLabel("<html>" + msg7 + "<br>" + msg8 + "<br>" + msg9 + "<br>" + msg10 + "<br>" + msg11 + "<br>" + msg12 + ".</html>"), gc);
                gc.gridx = 0;
                gc.gridy = 1;
                gc.weighty = 0.0;
                gc.weightx = 1.0;
                gc.gridwidth = 1;
                gc.anchor = 13;
                gc.fill = 2;
                gc.insets = new Insets(5, 5, 5, 5);
                JLabel turnsLabel = new JLabel(Language.string("     Turns") + ": ");
                panel.add((Component)turnsLabel, gc);
                gc.gridx = 1;
                gc.anchor = 17;
                gc.fill = 0;
                this.turnsField = this.turnsField != null ? new JTextField(this.turnsField.getText().toString()) : new JTextField("10", 15);
                this.turnsField.setEditable(true);
                this.turnsField.setColumns(3);
                this.turnsField.setMinimumSize(new Dimension(50, 20));
                panel.add((Component)this.turnsField, gc);
                gc.gridx = 0;
                gc.gridy = 2;
                gc.weighty = 1.0;
                gc.gridwidth = 3;
                gc.fill = 1;
                JPanel instructions_spacer = new JPanel();
                instructions_spacer.setOpaque(false);
                panel.add((Component)instructions_spacer, gc);
                break;
            }
            case 3: {
                String msg13 = Language.string("SD Reading");
                String msg14 = Language.string("Now we are going to read the data recorded by your telemetry");
                String msg15 = Language.string("Insert your SD again and specify the path to your SD data file in the form below");
                text.append(msg13 + "\n\n" + msg14 + ".\n" + msg15 + ":");
                gc.gridx = 0;
                gc.gridy = 0;
                gc.gridwidth = 3;
                gc.weightx = 1.0;
                gc.weighty = 1.0;
                gc.insets = new Insets(20, 20, 20, 20);
                gc.fill = 1;
                panel.add((Component)new JLabel("<html>" + msg13 + "<br><br>" + msg14 + "<br>" + msg15 + ".</html>"), gc);
                gc.gridx = 0;
                gc.gridy = 1;
                gc.weighty = 0.0;
                gc.weightx = 0.0;
                gc.gridwidth = 1;
                gc.fill = 2;
                gc.insets = new Insets(5, 5, 5, 5);
                JLabel loadFileLabel = new JLabel("     SD File:");
                panel.add((Component)loadFileLabel, gc);
                gc.gridx = 1;
                gc.weightx = 1.0;
                this.fileTextField = this.fileTextField != null ? new JTextField(this.fileTextField.getText().toString()) : new JTextField(new File(".").getAbsolutePath());
                this.fileTextField.setEditable(true);
                this.fileTextField.setColumns(20);
                panel.add((Component)this.fileTextField, gc);
                gc.gridx = 2;
                this.selectFileButton = new JButton(Language.string("Browse"));
                this.selectFileButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JFileChooser fc = new JFileChooser();
                        fc.setCurrentDirectory(new File("."));
                        fc.setFileSelectionMode(0);
                        fc.setMultiSelectionEnabled(false);
                        fc.showOpenDialog(DanasCalibration.this.dialog);
                        File f = fc.getSelectedFile();
                        try {
                            f.setReadable(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (f != null) {
                            DanasCalibration.this.fileTextField.setText(f.getPath());
                        }
                    }
                });
                panel.add((Component)this.selectFileButton, gc);
                gc.gridx = 0;
                gc.gridy = 2;
                gc.weighty = 1.0;
                gc.gridwidth = 3;
                gc.fill = 1;
                JPanel ask_spacer = new JPanel();
                ask_spacer.setOpaque(false);
                panel.add((Component)ask_spacer, gc);
                break;
            }
            case 4: {
                String msg16 = Language.string("Additional data are required to calculate how many pinion impulses are given by your motorbike:");
                text.append(msg16 + ".");
                gc.gridx = 0;
                gc.gridy = 0;
                gc.weightx = 1.0;
                gc.weighty = 1.0;
                gc.gridwidth = 2;
                gc.insets = new Insets(20, 20, 20, 20);
                gc.fill = 1;
                panel.add((Component)new JLabel("<html>" + msg16 + ".</html>"), gc);
                gc.gridy = 1;
                gc.gridx = 0;
                gc.gridwidth = 1;
                gc.anchor = 17;
                gc.fill = 2;
                gc.weighty = 0.0;
                JLabel vel1PinionLabel = new JLabel(Language.string("Pinion Teeth") + ": ");
                panel.add((Component)vel1PinionLabel, gc);
                gc.gridx = 1;
                gc.anchor = 10;
                this.pinionField = this.pinionField != null ? new JTextField(this.pinionField.getText()) : new JTextField("1");
                this.pinionField.setColumns(5);
                panel.add((Component)this.pinionField, gc);
                gc.gridy = 2;
                gc.gridx = 0;
                gc.anchor = 17;
                JLabel vel1RingGearLabel = new JLabel(Language.string("Ring Gear Teeth") + ": ");
                panel.add((Component)vel1RingGearLabel, gc);
                gc.gridx = 1;
                gc.anchor = 10;
                this.ringGearField = this.ringGearField != null ? new JTextField(this.ringGearField.getText()) : new JTextField("1");
                this.ringGearField.setColumns(5);
                panel.add((Component)this.ringGearField, gc);
                gc.gridx = 0;
                gc.gridy = 3;
                gc.weighty = 1.0;
                gc.gridwidth = 3;
                gc.fill = 1;
                JPanel additional_spacer = new JPanel();
                additional_spacer.setOpaque(false);
                panel.add((Component)additional_spacer, gc);
                break;
            }
            case 5: {
                String msg17 = Language.string("Result:");
                String msg18 = Language.string("The pinion impulses for your motorbike are");
                text.append(msg17 + "\n\n" + msg18 + " " + this.result_value);
                gc.gridx = 0;
                gc.gridy = 0;
                gc.weightx = 1.0;
                gc.weighty = 1.0;
                gc.insets = new Insets(20, 20, 20, 20);
                gc.fill = 1;
                panel.add((Component)new JLabel("<html>" + msg17 + "<br><br>" + msg18 + " " + this.result_value + "</html>"), gc);
                break;
            }
            default: {
                new JTextArea();
            }
        }
        return panel;
    }

    public boolean checkCalib() {
        String str = "";
        try {
            File file = new File(this.fileTextField.getText());
            RandomAccessFile f = new RandomAccessFile(file, "r");
            f.seek(0L);
            str = f.readLine();
            f.close();
            if (!file.getName().equalsIgnoreCase("dati.txt")) {
                throw new Exception("Invalid file name (should be dati.txt)");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return false;
        }
        return str.startsWith("$CALIB");
    }

    public double readCalib() throws Exception {
        if (!this.checkCalib()) {
            JOptionPane.showMessageDialog(this.dialog, Language.string("This is not a valid calibration file") + "! (" + this.fileTextField.getText() + ")", Language.string("Wrong file"), 0);
            throw new Exception("Wrong calib file format!");
        }
        double val = -1.0;
        FileLoader loader = null;
        try {
            String str;
            loader = new FileLoader(this.fileTextField.getText());
            while ((str = loader.getNextLine()) != null) {
                if (!str.startsWith("$IMPULSI")) continue;
                int start = str.indexOf(",") + 1;
                String val_str = str.substring(start, str.indexOf(",", start));
                val = Double.parseDouble(val_str);
                break;
            }
            loader.close();
            if (val == -1.0) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            if (loader != null) {
                loader.close();
            }
            String msg = Language.string("Unable to load the calibration value from the selected SD file");
            JOptionPane.showMessageDialog(this.dialog, msg + ": " + this.fileTextField.getText(), Language.string("Error"), 0);
            throw ex;
        }
        return val;
    }

    public void writeCalib() throws Exception {
        String impos_str = "<not_created>";
        RandomAccessFile f = null;
        try {
            impos_str = "$CALIB";
            f = new RandomAccessFile(new File(this.fileTextField.getText()), "rws");
            f.seek(0L);
            f.write(impos_str.getBytes());
            f.setLength(impos_str.getBytes().length);
            f.close();
        }
        catch (Exception ex) {
            if (f != null) {
                f.close();
            }
            JOptionPane.showMessageDialog(this.dialog, Language.string("Unable to write calib") + " (" + impos_str + ") " + Language.string("on_the_selected_SD") + ": " + this.fileTextField.getText(), Language.string("Error"), 0);
            throw ex;
        }
    }

    public boolean checkTurnsValue() throws Exception {
        try {
            int turns = Integer.parseInt(this.turnsField.getText());
            if (turns <= 0) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public int calculateResult() throws Exception {
        int pinionteeth;
        int ringgearteeth;
        int turns;
        try {
            turns = Integer.parseInt(this.turnsField.getText());
            if (turns <= 0) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            throw new Exception("Invalid Turns number (" + this.turnsField.getText() + ").\nShould be an integer value greater then 0.");
        }
        try {
            ringgearteeth = Integer.parseInt(this.ringGearField.getText());
            if (ringgearteeth <= 0) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            throw new Exception("Invalid Ring Gear Teeth number (" + this.ringGearField.getText() + ").\nShould be an integer value greater then 0.");
        }
        try {
            pinionteeth = Integer.parseInt(this.pinionField.getText());
            if (pinionteeth <= 0) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            throw new Exception("Invalid Pinion Teeth number (" + this.pinionField.getText() + ").\nShould be an integer value greater then 0.");
        }
        return (int)(this.calibration_value / ((double)turns * (double)ringgearteeth / (double)pinionteeth));
    }
}

