/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.ColorEditor;
import i2m.ColorRenderer;
import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Dialog.TableRowChannels;
import i2m.Language;
import i2m.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ChannelsDialog
extends JDialog
implements KeyListener,
WindowListener,
TableModelListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    JTable table;
    MyTableModel model;
    JScrollPane scrollPane;
    Vector<TableRowChannels> elencoRighe = new Vector();
    Vector<TableRowChannels> elencoRigheSelezionate = new Vector();
    JPanel tablePanel;
    MainFrame padre;
    JCheckBox auto;
    JCheckBox grigliaV;
    JCheckBox grigliaH;
    private ImageIcon iconaUp = new ImageIcon(this.getClass().getResource("/pix/go-up.png"));
    private ImageIcon iconaDn = new ImageIcon(this.getClass().getResource("/pix/go-down.png"));
    private ImageIcon iconaSottile = new ImageIcon(this.getClass().getResource("/pix/line_normal.gif"));
    private ImageIcon iconaMedia = new ImageIcon(this.getClass().getResource("/pix/line_medium.gif"));
    private ImageIcon iconaGrossa = new ImageIcon(this.getClass().getResource("/pix/line_heavy.gif"));
    private ImageIcon iconaPuntini = new ImageIcon(this.getClass().getResource("/pix/line_dotted.gif"));
    private ImageIcon iconaTratteggio = new ImageIcon(this.getClass().getResource("/pix/line_hatched.gif"));
    private ImageIcon iconaPuntoLinea = new ImageIcon(this.getClass().getResource("/pix/line_alternate.gif"));
    private JTextField ricercaTF;
    private JButton searchB;
    private JButton optionsB;
    private JButton sfondoB;
    private JButton spuntaB;
    private boolean visioneCompatta = true;
    private JPanel panelSearch;
    private JPanel panelExtra;
    private boolean filtrata = false;
    private boolean soloSelezionati = false;

    public ChannelsDialog(MainFrame owner) {
        super((Frame)owner, Language.string("Canali [m]"));
        this.padre = owner;
        this.setDefaultCloseOperation(2);
        this.model = new MyTableModel();
        this.table = new JTable(this.model);
        this.table.setFillsViewportHeight(false);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.aggiornaAspetto();
        this.table.setDefaultEditor(Color.class, new ColorEditor());
        this.table.getModel().addTableModelListener(this);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BoxLayout(this.tablePanel, 1));
        this.tablePanel.add(this.table);
        class MyTableCellRenderer2
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            MyTableCellRenderer2() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value.getClass().equals(Boolean.class)) {
                    Boolean f1 = (Boolean)value;
                    JCheckBox jc = new JCheckBox();
                    jc.setSelected(f1);
                    jc.setHorizontalAlignment(0);
                    return jc;
                }
                this.setHorizontalAlignment(0);
                if ((column == 8 || column == 9) && ChannelsDialog.this.auto.isSelected()) {
                    this.setForeground(Color.LIGHT_GRAY);
                } else {
                    this.setForeground(Color.DARK_GRAY);
                }
                if (!DanasDataStructure.getInstance().getCanalePresente(MeasuresUtil.getValueType(row)) && MeasuresUtil.getValueType(row).ordinal() >= DanasDataStructureConstants.ValueType.CAN1.ordinal() && MeasuresUtil.getValueType(row).ordinal() <= DanasDataStructureConstants.ValueType.CAN128.ordinal()) {
                    this.setForeground(Color.LIGHT_GRAY);
                } else {
                    this.setForeground(Color.DARK_GRAY);
                }
                return this;
            }
        }
        MyTableCellRenderer2 renderer = new MyTableCellRenderer2();
        this.table.setDefaultRenderer(String.class, renderer);
        this.table.setDefaultRenderer(Double.class, renderer);
        this.table.setDefaultRenderer(Integer.class, renderer);
        this.table.setDefaultRenderer(Boolean.class, renderer);
        this.scrollPane = new JScrollPane(this.tablePanel);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        JPanel pannelloPrincipale = new JPanel(new BorderLayout());
        JPanel pannelloTabella = new JPanel(new BorderLayout());
        this.panelSearch = new JPanel();
        this.panelSearch.setLayout(new BoxLayout(this.panelSearch, 0));
        this.ricercaTF = new JTextField(2);
        this.ricercaTF.setEditable(true);
        this.ricercaTF.setEnabled(true);
        this.ricercaTF.setMaximumSize(new Dimension(180, 25));
        this.ricercaTF.setMinimumSize(new Dimension(80, 25));
        this.ricercaTF.addKeyListener(this);
        URL ImgUrl = this.getClass().getResource("/pix/search.png");
        this.searchB = new JButton(new ImageIcon(ImgUrl));
        this.searchB.setPreferredSize(new Dimension(25, 25));
        this.searchB.setMaximumSize(new Dimension(25, 25));
        this.searchB.setMinimumSize(new Dimension(25, 25));
        this.searchB.addActionListener(this);
        ImgUrl = this.getClass().getResource("/pix/spunta.png");
        this.spuntaB = new JButton(new ImageIcon(ImgUrl));
        this.spuntaB.setPreferredSize(new Dimension(25, 25));
        this.spuntaB.setMaximumSize(new Dimension(25, 25));
        this.spuntaB.setMinimumSize(new Dimension(25, 25));
        this.spuntaB.addActionListener(this);
        this.optionsB = new JButton(Language.string("More"));
        this.optionsB.setPreferredSize(new Dimension(75, 25));
        this.optionsB.setMaximumSize(new Dimension(75, 25));
        this.optionsB.addActionListener(this);
        this.sfondoB = new JButton();
        this.sfondoB.setPreferredSize(new Dimension(75, 25));
        this.sfondoB.setMaximumSize(new Dimension(75, 25));
        this.sfondoB.addActionListener(this);
        this.sfondoB.setBackground(this.padre.getContenitoreGrafico().getColoreSfondo());
        this.auto = new JCheckBox(Language.string("Autoscaling"));
        this.auto.setSelected(DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().autoIsSelected());
        this.auto.addActionListener(this);
        this.grigliaV = new JCheckBox(Language.string("Griglia V."));
        this.grigliaV.setSelected(DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().grigliaVIsSelected());
        this.grigliaV.addActionListener(this);
        this.grigliaH = new JCheckBox(Language.string("Griglia H."));
        this.grigliaH.setSelected(DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().grigliaHIsSelected());
        this.grigliaH.addActionListener(this);
        this.panelExtra = new JPanel();
        this.panelExtra.setLayout(new BoxLayout(this.panelExtra, 0));
        this.panelExtra.add(Box.createRigidArea(new Dimension(15, 40)));
        this.panelExtra.add(this.auto);
        this.panelExtra.add(Box.createRigidArea(new Dimension(15, 40)));
        this.panelExtra.add(this.grigliaV);
        this.panelExtra.add(Box.createRigidArea(new Dimension(15, 40)));
        this.panelExtra.add(this.grigliaH);
        this.panelExtra.add(Box.createRigidArea(new Dimension(15, 40)));
        this.panelExtra.add(this.sfondoB);
        this.panelSearch.add(Box.createRigidArea(new Dimension(5, 40)));
        this.panelSearch.add(this.ricercaTF);
        this.panelSearch.add(Box.createRigidArea(new Dimension(5, 40)));
        this.panelSearch.add(this.searchB);
        this.panelSearch.add(Box.createRigidArea(new Dimension(5, 40)));
        this.panelSearch.add(this.spuntaB);
        this.panelSearch.add(Box.createRigidArea(new Dimension(5, 40)));
        this.panelSearch.add(this.optionsB);
        this.panelSearch.add(Box.createRigidArea(new Dimension(5, 40)));
        pannelloTabella.add((Component)this.table.getTableHeader(), "North");
        pannelloTabella.add((Component)this.scrollPane, "Center");
        pannelloPrincipale.add((Component)this.panelSearch, "North");
        pannelloPrincipale.add((Component)pannelloTabella, "Center");
        this.setContentPane(pannelloPrincipale);
        this.addWindowListener(this);
        this.pack();
        this.refresh();
    }

    public void aggiorna() {
        this.model.fireTableDataChanged();
    }

    public Container getContenuto() {
        return this.getContentPane();
    }

    public void addRiga(TableRowChannels riga, boolean refresh) {
        this.table.getModel().removeTableModelListener(this);
        this.model.addRow(riga);
        this.elencoRighe.add(riga);
        if (refresh) {
            this.refresh();
        }
        this.table.getModel().addTableModelListener(this);
    }

    public TableRowChannels getRiga(int indice) {
        return this.model.getRow(indice);
    }

    public void rimuoviTutto() {
        this.table.getModel().removeTableModelListener(this);
        this.model.rimuoviTutto();
        this.elencoRighe.clear();
        this.elencoRigheSelezionate.clear();
        this.setSize(new Dimension(200, 0));
        this.table.getModel().addTableModelListener(this);
    }

    public Vector<TableRowChannels> getElencoRighe() {
        return this.elencoRighe;
    }

    public boolean isCompatta() {
        return this.visioneCompatta;
    }

    public void refresh() {
        this.table.getModel().removeTableModelListener(this);
        this.aggiorna();
        this.table.getModel().addTableModelListener(this);
    }

    public void setColoreSfondo(Color color) {
        this.sfondoB.setBackground(color);
    }

    public void eseguiRicerca(String testo) {
        int i;
        this.table.getModel().removeTableModelListener(this);
        this.elencoRigheSelezionate.clear();
        for (i = 0; i < this.elencoRighe.size(); ++i) {
            if (!this.elencoRighe.get(i).getNome().toLowerCase().contains(testo.toLowerCase()) && !this.elencoRighe.get(i).getCanale().toLowerCase().contains(testo.toLowerCase())) continue;
            if (this.soloSelezionati) {
                if (!this.elencoRighe.get(i).getMostra() && !this.elencoRighe.get(i).getInfo()) continue;
                this.elencoRigheSelezionate.add(this.elencoRighe.get(i));
                continue;
            }
            this.elencoRigheSelezionate.add(this.elencoRighe.get(i));
        }
        this.model.rimuoviTutto();
        for (i = 0; i < this.elencoRigheSelezionate.size(); ++i) {
            this.model.addRow(this.elencoRigheSelezionate.get(i));
        }
        this.refresh();
        this.table.getModel().addTableModelListener(this);
    }

    public boolean isCompleta() {
        return !this.filtrata;
    }

    public void pulisciricerca() {
        this.filtrata = false;
        this.ricercaTF.setText("");
    }

    public void mostraSelezionati() {
        if (this.soloSelezionati) {
            this.eseguiRicerca(this.ricercaTF.getText());
            this.filtrata = true;
            this.pack();
        }
    }

    public void ricaricaTutto() {
        this.table.getModel().removeTableModelListener(this);
        this.model.rimuoviTutto();
        for (int i = 0; i < this.elencoRighe.size(); ++i) {
            if (this.soloSelezionati) {
                if (!this.elencoRighe.get(i).getMostra() && !this.elencoRighe.get(i).getInfo()) continue;
                this.model.addRow(this.elencoRighe.get(i));
                continue;
            }
            this.model.addRow(this.elencoRighe.get(i));
        }
        this.refresh();
        this.table.getModel().addTableModelListener(this);
    }

    public void setEditable(boolean editable) {
        this.table.setEnabled(editable);
    }

    public void setAutoscale(boolean autoscale) {
        this.auto.setSelected(autoscale);
        this.table.repaint();
    }

    public void setGrigliaV(boolean attiva) {
        this.grigliaV.setSelected(attiva);
        this.table.repaint();
    }

    public void setGrigliaH(boolean attiva) {
        this.grigliaH.setSelected(attiva);
        this.table.repaint();
    }

    public void setValoriAsse(int riga, double min, double max) {
        for (int i = 0; i < this.elencoRighe.size(); ++i) {
            if (this.elencoRighe.get(i).getNumeroRiga() != riga) continue;
            this.elencoRighe.get(i).setMin(min);
            this.elencoRighe.get(i).setMax(max);
        }
    }

    public void aggiornaAspetto() {
        if (this.visioneCompatta) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(22);
            this.table.getColumnModel().getColumn(0).setMaxWidth(22);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(22);
            this.table.getColumnModel().getColumn(1).setMaxWidth(22);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(22);
            this.table.getColumnModel().getColumn(2).setMaxWidth(22);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(22);
            this.table.getColumnModel().getColumn(3).setMaxWidth(22);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(25);
            this.table.getColumnModel().getColumn(4).setMaxWidth(25);
            this.table.getColumnModel().getColumn(5).setPreferredWidth(80);
            JComboBox<ImageIcon> comboBox = new JComboBox<ImageIcon>();
            comboBox.addItem(this.iconaUp);
            comboBox.addItem(this.iconaDn);
            TableColumn colonna = this.table.getColumnModel().getColumn(0);
            colonna.setCellEditor(new DefaultCellEditor(comboBox));
            try {
                this.panelSearch.remove(this.panelExtra);
            }
            catch (Exception exception) {}
        } else {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(22);
            this.table.getColumnModel().getColumn(0).setMaxWidth(22);
            this.table.getColumnModel().getColumn(1).setPreferredWidth(22);
            this.table.getColumnModel().getColumn(1).setMaxWidth(22);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(22);
            this.table.getColumnModel().getColumn(2).setMaxWidth(22);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(22);
            this.table.getColumnModel().getColumn(3).setMaxWidth(22);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(25);
            this.table.getColumnModel().getColumn(4).setMaxWidth(25);
            this.table.getColumnModel().getColumn(5).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(6).setPreferredWidth(70);
            this.table.getColumnModel().getColumn(6).setMaxWidth(70);
            this.table.getColumnModel().getColumn(7).setPreferredWidth(70);
            this.table.getColumnModel().getColumn(7).setMaxWidth(70);
            this.table.getColumnModel().getColumn(8).setPreferredWidth(65);
            this.table.getColumnModel().getColumn(8).setMaxWidth(65);
            this.table.getColumnModel().getColumn(9).setPreferredWidth(65);
            this.table.getColumnModel().getColumn(9).setMaxWidth(65);
            this.table.getColumnModel().getColumn(10).setPreferredWidth(45);
            this.table.getColumnModel().getColumn(10).setMaxWidth(45);
            this.table.getColumnModel().getColumn(11).setPreferredWidth(45);
            this.table.getColumnModel().getColumn(11).setMaxWidth(45);
            this.table.getColumnModel().getColumn(12).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(12).setMaxWidth(60);
            this.table.getColumnModel().getColumn(13).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(13).setMaxWidth(60);
            this.table.getColumnModel().getColumn(14).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(14).setMaxWidth(60);
            this.table.getColumnModel().getColumn(15).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(15).setMaxWidth(60);
            this.table.getColumnModel().getColumn(16).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(16).setMaxWidth(60);
            this.table.getColumnModel().getColumn(17).setPreferredWidth(70);
            this.table.getColumnModel().getColumn(17).setMaxWidth(70);
            JComboBox<Object> comboBox = new JComboBox<Object>();
            comboBox.addItem(this.iconaSottile);
            comboBox.addItem(this.iconaMedia);
            comboBox.addItem(this.iconaGrossa);
            TableColumn colonna = this.table.getColumnModel().getColumn(6);
            colonna.setCellEditor(new DefaultCellEditor(comboBox));
            comboBox = new JComboBox();
            comboBox.addItem(this.iconaMedia);
            comboBox.addItem(this.iconaPuntini);
            comboBox.addItem(this.iconaTratteggio);
            comboBox.addItem(this.iconaPuntoLinea);
            colonna = this.table.getColumnModel().getColumn(7);
            colonna.setCellEditor(new DefaultCellEditor(comboBox));
            comboBox = new JComboBox();
            comboBox.addItem("No Ref.");
            comboBox.addItem("Max");
            comboBox.addItem("Min");
            comboBox.addItem("Avg.");
            comboBox.addItem(Language.string("Valore"));
            colonna = this.table.getColumnModel().getColumn(12);
            colonna.setCellEditor(new DefaultCellEditor(comboBox));
            comboBox = new JComboBox();
            comboBox.addItem(this.iconaUp);
            comboBox.addItem(this.iconaDn);
            colonna = this.table.getColumnModel().getColumn(0);
            colonna.setCellEditor(new DefaultCellEditor(comboBox));
            comboBox = new JComboBox();
            comboBox.addItem("--");
            comboBox.addItem("20Hz");
            comboBox.addItem("10Hz");
            comboBox.addItem("7Hz");
            comboBox.addItem("5Hz");
            comboBox.addItem("2Hz");
            comboBox.addItem("1Hz");
            colonna = this.table.getColumnModel().getColumn(14);
            colonna.setCellEditor(new DefaultCellEditor(comboBox));
            comboBox = new JComboBox();
            comboBox.addItem(0);
            comboBox.addItem(1);
            comboBox.addItem(2);
            comboBox.addItem(3);
            colonna = this.table.getColumnModel().getColumn(15);
            colonna.setCellEditor(new DefaultCellEditor(comboBox));
            this.panelSearch.add(this.panelExtra);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ChannelsDialog i = new ChannelsDialog(null);
        i.setVisible(true);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        DanasPreferences.setPosizioneChannelsX(this.getLocationOnScreen().x);
        DanasPreferences.setPosizioneChannelsY(this.getLocationOnScreen().y);
        DanasPreferences.setLarghezzaChannels(this.getWidth());
        if (this.isCompleta()) {
            DanasPreferences.setLunghezzaChannels(this.getHeight());
        }
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.ricercaTF.getText().length() == 0) {
            int w = this.getWidth();
            this.filtrata = false;
            this.ricaricaTutto();
            if (!this.soloSelezionati) {
                this.setSize(new Dimension(w, DanasPreferences.getLunghezzaChannels()));
            } else {
                this.pack();
            }
        }
        if (this.ricercaTF.getText().length() >= 1) {
            this.filtrata = true;
            this.eseguiRicerca(this.ricercaTF.getText());
            this.pack();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        DanasDataStructure.getInstance().getMainFrame().setVisibileConFuocoNoInfo();
        int col = e.getColumn();
        int row = e.getFirstRow();
        if (row >= this.table.getModel().getRowCount()) {
            return;
        }
        if (row == -1) {
            return;
        }
        int rigaGrafico = this.getRiga(row).getNumeroRiga();
        if (!this.table.isEnabled()) {
            return;
        }
        switch (col) {
            case 0: {
                ImageIcon im = (ImageIcon)this.table.getValueAt(row, col);
                if (im.equals(this.iconaUp)) {
                    this.padre.getContenitoreGrafico().aggiornaIconaTabella(rigaGrafico, col, true);
                    break;
                }
                this.padre.getContenitoreGrafico().aggiornaIconaTabella(rigaGrafico, col, false);
                break;
            }
            case 2: {
                boolean val = (Boolean)this.table.getValueAt(row, col);
                this.padre.getContenitoreGrafico().aggiornaBooleanTabella(rigaGrafico, col, val);
                val = (Boolean)this.table.getValueAt(row, col);
                this.padre.getContenitoreGrafico().abilitaListenerTabella(false);
                this.padre.getContenitoreGrafico().aggiornaBooleanTabella(rigaGrafico, col + 1, val);
                this.padre.getContenitoreGrafico().abilitaListenerTabella(true);
                break;
            }
            case 1: 
            case 3: {
                boolean val = (Boolean)this.table.getValueAt(row, col);
                this.padre.getContenitoreGrafico().aggiornaBooleanTabella(rigaGrafico, col, val);
                break;
            }
            case 4: {
                Color colore = (Color)this.table.getValueAt(row, col);
                this.padre.getContenitoreGrafico().aggiornaColoreTabella(rigaGrafico, col + 2, colore);
                break;
            }
            case 6: {
                ImageIcon icona = (ImageIcon)this.table.getValueAt(row, col);
                int indice = 0;
                if (icona.equals(this.iconaSottile)) {
                    indice = 0;
                }
                if (icona.equals(this.iconaMedia)) {
                    indice = 1;
                }
                if (icona.equals(this.iconaGrossa)) {
                    indice = 2;
                }
                this.padre.getContenitoreGrafico().aggiornaSpessoreTabella(rigaGrafico, col + 1, indice);
                break;
            }
            case 7: {
                ImageIcon icona2 = (ImageIcon)this.table.getValueAt(row, col);
                int indice2 = 0;
                if (icona2.equals(this.iconaMedia)) {
                    boolean bl = false;
                }
                if (icona2.equals(this.iconaPuntini)) {
                    indice2 = 1;
                }
                if (icona2.equals(this.iconaTratteggio)) {
                    indice2 = 2;
                }
                if (icona2.equals(this.iconaPuntoLinea)) {
                    indice2 = 3;
                }
                this.padre.getContenitoreGrafico().aggiornaStileTabella(rigaGrafico, col + 1, indice2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                double valore = (Double)this.table.getValueAt(row, col);
                this.padre.getContenitoreGrafico().aggiornaDoubleTabella(rigaGrafico, col + 1, valore);
                break;
            }
            case 12: {
                String tipo = (String)this.table.getValueAt(row, col);
                this.padre.getContenitoreGrafico().aggiornaTipoRefTabella(rigaGrafico, col + 1, tipo);
                break;
            }
            case 14: {
                int modo = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
                DanasPreferences.setLunghezzaFiltro(MeasuresUtil.getValueType(rigaGrafico), MeasuresUtil.getIndiceFiltro((String)this.table.getValueAt(row, col)), modo);
                DanasDataStructure.getInstance().setChange(DanasDataStructureConstants.ChangeType.REFRESH_ALL);
                break;
            }
            case 15: {
                int modo1 = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
                DanasPreferences.setDecimali(MeasuresUtil.getValueType(rigaGrafico), (Integer)this.table.getValueAt(row, col), modo1);
                DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().aggiornaInfoNew();
                DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().aggiornaInfo();
                DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().aggiornaStat();
                break;
            }
            case 16: {
                int modo2 = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
                DanasPreferences.setAlarmHi(MeasuresUtil.getValueType(rigaGrafico), modo2, (Double)this.table.getValueAt(row, col));
                DanasDataStructure.getInstance().setChange(DanasDataStructureConstants.ChangeType.REFRESH_ALL);
                break;
            }
            case 17: {
                int modo3 = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
                DanasPreferences.setAlarmLow(MeasuresUtil.getValueType(rigaGrafico), modo3, (Double)this.table.getValueAt(row, col));
                DanasDataStructure.getInstance().setChange(DanasDataStructureConstants.ChangeType.REFRESH_ALL);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color color;
        if (e.getSource().equals(this.searchB)) {
            if (this.ricercaTF.getText().length() == 0) {
                this.filtrata = false;
                this.ricaricaTutto();
            } else {
                this.filtrata = true;
                this.eseguiRicerca(this.ricercaTF.getText());
            }
        }
        if (e.getSource().equals(this.spuntaB)) {
            if (!this.soloSelezionati) {
                this.soloSelezionati = true;
                this.filtrata = true;
                this.spuntaB.setBackground(new Color(0.72f, 0.81f, 0.89f, 1.0f));
            } else {
                this.spuntaB.setBackground(null);
                this.soloSelezionati = false;
            }
            if (this.ricercaTF.getText().length() == 0) {
                this.ricaricaTutto();
                int w = this.getWidth();
                if (!this.soloSelezionati) {
                    this.setSize(new Dimension(w, DanasPreferences.getLunghezzaChannels()));
                } else {
                    this.pack();
                }
            } else {
                this.eseguiRicerca(this.ricercaTF.getText());
                this.pack();
            }
        }
        if (e.getSource().equals(this.auto)) {
            this.padre.getContenitoreGrafico().setAutoScale(this.auto.isSelected());
            this.table.repaint();
        }
        if (e.getSource().equals(this.grigliaV)) {
            this.padre.getContenitoreGrafico().setGrigliaV(this.grigliaV.isSelected());
            this.table.repaint();
        }
        if (e.getSource().equals(this.grigliaH)) {
            this.padre.getContenitoreGrafico().setGrigliaH(this.grigliaH.isSelected());
            this.table.repaint();
        }
        if (e.getSource().equals(this.sfondoB) && (color = JColorChooser.showDialog(this, Language.string("Colore sfondo del grafico"), this.sfondoB.getBackground())) != null) {
            this.padre.getContenitoreGrafico().setColoreSfondo(color);
            this.sfondoB.setBackground(color);
        }
        if (e.getSource().equals(this.optionsB)) {
            if (this.visioneCompatta) {
                this.visioneCompatta = false;
                this.optionsB.setText(Language.string("Less"));
            } else {
                this.visioneCompatta = true;
                this.optionsB.setText(Language.string("More"));
            }
            int x = this.getLocationOnScreen().x;
            int y = this.getLocationOnScreen().y;
            int h = this.getHeight();
            this.model.fireTableStructureChanged();
            this.aggiornaAspetto();
            if (this.visioneCompatta) {
                this.setSize(new Dimension(220, h));
            } else {
                this.setSize(new Dimension(960, h));
            }
            this.setLocation(x, y);
        }
    }

    public class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        Vector<String> columnNames = new Vector();
        private Vector<TableRowChannels> datiInfo = new Vector();

        public MyTableModel() {
            this.columnNames.add("");
            this.columnNames.add("A");
            this.columnNames.add("V");
            this.columnNames.add("I");
            this.columnNames.add("C");
            this.columnNames.add(Language.string("Nome"));
            this.columnNames.add(Language.string("Spess."));
            this.columnNames.add(Language.string("Stile"));
            this.columnNames.add("Min");
            this.columnNames.add("Max");
            this.columnNames.add("Dn %");
            this.columnNames.add("Up %");
            this.columnNames.add(Language.string("Tipo"));
            this.columnNames.add("Ref");
            this.columnNames.add(Language.string("Filtro"));
            this.columnNames.add(Language.string("Decimal."));
            this.columnNames.add(Language.string("Alarm Hi"));
            this.columnNames.add(Language.string("Alarm Low"));
        }

        @Override
        public int getColumnCount() {
            if (ChannelsDialog.this.visioneCompatta) {
                return 6;
            }
            return 18;
        }

        @Override
        public int getRowCount() {
            return this.datiInfo.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.datiInfo.get(row).getCampo(col);
        }

        public Class<? extends Object> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!DanasDataStructure.getInstance().getCanalePresente(MeasuresUtil.getValueType(row)) && MeasuresUtil.getValueType(row).ordinal() >= DanasDataStructureConstants.ValueType.CAN1.ordinal() && MeasuresUtil.getValueType(row).ordinal() <= DanasDataStructureConstants.ValueType.CAN128.ordinal() && !((Boolean)this.datiInfo.get(row).getCampo(col)).booleanValue()) {
                return false;
            }
            if (col == 1 && !this.datiInfo.get(row).getMostra()) {
                return false;
            }
            if ((col == 8 || col == 9) && ChannelsDialog.this.auto.isSelected()) {
                return false;
            }
            return col != 5;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 1: {
                    if (((Boolean)value).booleanValue() && DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getGraficoCampo(row).getNumeroAssi() < 4) {
                        this.datiInfo.get(row).setCampo(true, col);
                    }
                    if (!((Boolean)value).booleanValue()) {
                        this.datiInfo.get(row).setCampo(false, col);
                    }
                    this.fireTableCellUpdated(row, col);
                    return;
                }
                case 2: {
                    if (((Boolean)value).booleanValue() && DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getGraficoCampo(row).getNumeroAssi() < 4) {
                        this.datiInfo.get(row).setCampo(true, col - 1);
                    }
                    if (!((Boolean)value).booleanValue()) {
                        this.datiInfo.get(row).setCampo(false, col - 1);
                        this.datiInfo.get(row).setCampo(false, col + 1);
                    } else {
                        this.datiInfo.get(row).setCampo(true, col + 1);
                    }
                    this.datiInfo.get(row).setCampo(value, col);
                    this.fireTableCellUpdated(row, col);
                    this.fireTableCellUpdated(row, col - 1);
                    this.fireTableCellUpdated(row, col + 1);
                    return;
                }
            }
            this.datiInfo.get(row).setCampo(value, col);
            this.fireTableCellUpdated(row, col);
        }

        public void addRow(TableRowChannels riga) {
            this.datiInfo.add(riga);
        }

        public TableRowChannels getRow(int indice) {
            return this.datiInfo.get(indice);
        }

        public void rimuoviTutto() {
            this.datiInfo.clear();
        }
    }
}

