/*
 * Decompiled with CFR 0.152.
 */
package i2m.Dialog;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.Language;
import i2m.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AllarmiDialog
extends JDialog
implements WindowListener,
ActionListener {
    private MainFrame padre;
    private JButton applyButton;
    private JButton esciButton;
    private JFormattedTextField sogliaWater;
    private JFormattedTextField sogliaBatteria;
    private JFormattedTextField sogliaAllarme1ch1;
    private JFormattedTextField sogliaAllarme1ch2;
    private JFormattedTextField sogliaAllarme2ch1;
    private JFormattedTextField sogliaAllarme2ch2;
    private JFormattedTextField sogliaTempo;
    private JTextField allarme1;
    private JTextField allarme2;
    private JComboBox verso1;
    private JComboBox verso2;
    private JComboBox verso3;
    private JComboBox verso4;
    private JComboBox canale1;
    private JComboBox canale2;
    private JComboBox canale3;
    private JComboBox canale4;
    private JCheckBox testEntrambi;

    public AllarmiDialog(MainFrame owner) {
        super(owner, Language.string("Configurazione allarmi"), true);
        this.padre = owner;
        this.setDefaultCloseOperation(2);
        JPanel buttonPanel = new JPanel();
        this.applyButton = new JButton(Language.string("Applica"));
        this.applyButton.addActionListener(this);
        this.esciButton = new JButton(Language.string("Esci"));
        this.esciButton.addActionListener(this);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.esciButton);
        buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        JLabel waterLabel = new JLabel(Language.string("Allarme acqua:"));
        JLabel tempoLabel = new JLabel(Language.string("Tempo minimo:"));
        Font font_etichetta = waterLabel.getFont().deriveFont(14.0f);
        waterLabel.setFont(font_etichetta);
        tempoLabel.setFont(font_etichetta);
        JLabel BatteryLabel = new JLabel(Language.string("Allarme batteria:"));
        BatteryLabel.setFont(font_etichetta);
        NumberFormat TFormatIntero = NumberFormat.getNumberInstance(Locale.US);
        TFormatIntero.setMaximumIntegerDigits(10);
        TFormatIntero.setMaximumFractionDigits(0);
        TFormatIntero.setGroupingUsed(false);
        NumberFormat TFormat = NumberFormat.getNumberInstance(Locale.US);
        TFormat.setMaximumIntegerDigits(10);
        TFormat.setMaximumFractionDigits(2);
        TFormat.setGroupingUsed(false);
        this.sogliaWater = new JFormattedTextField(TFormatIntero);
        this.sogliaWater.setValue(110);
        this.sogliaWater.setHorizontalAlignment(11);
        this.sogliaWater.setAlignmentX(0.0f);
        this.sogliaWater.setMinimumSize(new Dimension(80, 20));
        this.sogliaTempo = new JFormattedTextField(TFormatIntero);
        this.sogliaTempo.setValue(110);
        this.sogliaTempo.setHorizontalAlignment(11);
        this.sogliaTempo.setAlignmentX(0.0f);
        this.sogliaTempo.setMinimumSize(new Dimension(80, 20));
        this.sogliaBatteria = new JFormattedTextField(TFormat);
        this.sogliaBatteria.setValue(13.0);
        this.sogliaBatteria.setHorizontalAlignment(11);
        this.sogliaBatteria.setAlignmentX(0.0f);
        this.sogliaBatteria.setMinimumSize(new Dimension(80, 20));
        this.sogliaAllarme1ch1 = new JFormattedTextField(TFormat);
        this.sogliaAllarme1ch1.setValue(0);
        this.sogliaAllarme1ch1.setHorizontalAlignment(11);
        this.sogliaAllarme1ch1.setAlignmentX(0.0f);
        this.sogliaAllarme1ch1.setMinimumSize(new Dimension(80, 20));
        this.sogliaAllarme1ch2 = new JFormattedTextField(TFormat);
        this.sogliaAllarme1ch2.setValue(0);
        this.sogliaAllarme1ch2.setHorizontalAlignment(11);
        this.sogliaAllarme1ch2.setAlignmentX(0.0f);
        this.sogliaAllarme1ch2.setMinimumSize(new Dimension(80, 20));
        this.sogliaAllarme2ch1 = new JFormattedTextField(TFormat);
        this.sogliaAllarme2ch1.setValue(0);
        this.sogliaAllarme2ch1.setHorizontalAlignment(11);
        this.sogliaAllarme2ch1.setAlignmentX(0.0f);
        this.sogliaAllarme2ch1.setMinimumSize(new Dimension(80, 20));
        this.sogliaAllarme2ch2 = new JFormattedTextField(TFormat);
        this.sogliaAllarme2ch2.setValue(0);
        this.sogliaAllarme2ch2.setHorizontalAlignment(11);
        this.sogliaAllarme2ch2.setAlignmentX(0.0f);
        this.sogliaAllarme2ch2.setMinimumSize(new Dimension(80, 20));
        this.allarme1 = new JTextField(10);
        this.allarme1.setHorizontalAlignment(11);
        this.allarme1.setText("Allarme1");
        this.allarme2 = new JTextField(10);
        this.allarme2.setHorizontalAlignment(11);
        this.allarme2.setText("Allarme2");
        this.testEntrambi = new JCheckBox(Language.string("AND: Verifica gli allarmi Alarm1 e Alarm2 contemporaneamente"));
        String[] lista = new String[]{">", "<"};
        this.verso1 = new JComboBox<String>(lista);
        this.verso2 = new JComboBox<String>(lista);
        this.verso3 = new JComboBox<String>(lista);
        this.verso4 = new JComboBox<String>(lista);
        String[] CanaliList = new String[]{"Nessuno", "Rpm", "Speed1", "Speed2", "Analog1", "Analog2", "Analog3", "Analog4", "Analog5", "Analog6", "Analog7", "Analog8", "Ext-1", "Ext-2", "d(Rpm)", "d(Speed1)", "d(Speed2)", "d(Analog1)", "d(Analog2)", "d(Analog3)", "d(Analog4)", "d(Analog5)", "d(Analog6)", "d(Analog7)", "d(Analog8)", "d(Ext-1)", "d(Ext-2)", "Gears", "Gears ratio", "Math1", "Math2", "Multi1", "Multi2", "Multi3", "Multi4", "Multi5", "Multi6", "Multi7", "Multi8", "Multi9", "Multi10"};
        this.canale1 = new JComboBox<String>(CanaliList);
        this.canale2 = new JComboBox<String>(CanaliList);
        this.canale3 = new JComboBox<String>(CanaliList);
        this.canale4 = new JComboBox<String>(CanaliList);
        JPanel waterPanel = new JPanel(new GridLayout(0, 7, 10, 0));
        waterPanel.add(new JLabel(""));
        waterPanel.add(new JLabel(Language.string("Soglia gradi")));
        waterPanel.add(new JLabel(""));
        waterPanel.add(new JLabel(""));
        waterPanel.add(new JLabel(""));
        waterPanel.add(new JLabel(""));
        waterPanel.add(new JLabel(""));
        waterPanel.add(waterLabel);
        waterPanel.add(this.sogliaWater);
        waterPanel.add(new JLabel(""));
        JPanel batteryPanel = new JPanel(new GridLayout(0, 7, 10, 0));
        batteryPanel.add(new JLabel(""));
        batteryPanel.add(new JLabel(Language.string("Soglia Volts")));
        batteryPanel.add(new JLabel(""));
        batteryPanel.add(new JLabel(""));
        batteryPanel.add(new JLabel(""));
        batteryPanel.add(new JLabel(""));
        batteryPanel.add(new JLabel(""));
        batteryPanel.add(BatteryLabel);
        batteryPanel.add(this.sogliaBatteria);
        batteryPanel.add(new JLabel(""));
        JPanel alarm1Panel = new JPanel(new GridLayout(0, 7, 10, 0));
        JLabel nomeLabel3 = new JLabel(Language.string("Nome Alarm1"));
        alarm1Panel.add(nomeLabel3);
        alarm1Panel.add(new JLabel(Language.string("Canale")));
        alarm1Panel.add(new JLabel(Language.string("Maggiore/minore")));
        alarm1Panel.add(new JLabel(Language.string("Soglia")));
        alarm1Panel.add(new JLabel(Language.string("Canale")));
        alarm1Panel.add(new JLabel(Language.string("Maggiore/minore")));
        alarm1Panel.add(new JLabel(Language.string("Soglia")));
        alarm1Panel.add(this.allarme1);
        alarm1Panel.add(this.canale1);
        alarm1Panel.add(this.verso1);
        alarm1Panel.add(this.sogliaAllarme1ch1);
        alarm1Panel.add(this.canale2);
        alarm1Panel.add(this.verso2);
        alarm1Panel.add(this.sogliaAllarme1ch2);
        JPanel alarm2Panel = new JPanel(new GridLayout(0, 7, 10, 0));
        JLabel nomeLabel4 = new JLabel(Language.string("Nome Alarm2"));
        alarm2Panel.add(nomeLabel4);
        alarm2Panel.add(new JLabel(Language.string("Canale")));
        alarm2Panel.add(new JLabel(Language.string("Maggiore/minore")));
        alarm2Panel.add(new JLabel(Language.string("Soglia")));
        alarm2Panel.add(new JLabel(Language.string("Canale")));
        alarm2Panel.add(new JLabel(Language.string("Maggiore/minore")));
        alarm2Panel.add(new JLabel(Language.string("Soglia")));
        alarm2Panel.add(this.allarme2);
        alarm2Panel.add(this.canale3);
        alarm2Panel.add(this.verso3);
        alarm2Panel.add(this.sogliaAllarme2ch1);
        alarm2Panel.add(this.canale4);
        alarm2Panel.add(this.verso4);
        alarm2Panel.add(this.sogliaAllarme2ch2);
        JPanel tempoPanel = new JPanel(new GridLayout(0, 7, 10, 0));
        tempoPanel.add(new JLabel(""));
        tempoPanel.add(new JLabel(Language.string("Centesimi di sec.")));
        tempoPanel.add(new JLabel(""));
        tempoPanel.add(new JLabel(""));
        tempoPanel.add(new JLabel(""));
        tempoPanel.add(new JLabel(""));
        tempoPanel.add(new JLabel(""));
        tempoPanel.add(tempoLabel);
        tempoPanel.add(this.sogliaTempo);
        tempoPanel.add(new JLabel(""));
        JPanel settingsPanel = new JPanel(new GridLayout(6, 0, 0, 7));
        settingsPanel.add(waterPanel);
        settingsPanel.add(batteryPanel);
        settingsPanel.add(waterPanel);
        settingsPanel.add(alarm1Panel);
        settingsPanel.add(alarm2Panel);
        settingsPanel.add(tempoPanel);
        settingsPanel.add(this.testEntrambi);
        this.ripristinaPreferenze();
        this.setLayout(new BorderLayout());
        this.add(Box.createRigidArea(new Dimension(30, 10)), "West");
        this.add(Box.createRigidArea(new Dimension(30, 10)), "East");
        this.add((Component)settingsPanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.setSize(1000, 400);
        this.setResizable(false);
        this.addWindowListener(this);
    }

    public String getNomeCanale(int numCanale) {
        switch (numCanale) {
            case 0: {
                return Language.string("Nessuno");
            }
            case 1: {
                return "Rpm";
            }
            case 2: {
                return "Vel1";
            }
            case 3: {
                return "Vel2";
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNomeAnalogici(numCanale - 3);
            }
            case 16: {
                return "d(Rpm)";
            }
            case 17: {
                return "d(Vel1)";
            }
            case 18: {
                return "d(Vel2)";
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return "d(" + DanasDataStructure.getInstance().getDefaultSession().getSessionSettings().getNomeAnalogici(numCanale - 18) + ")";
            }
            case 31: {
                return Language.string("Marce calcolate");
            }
            case 32: {
                return Language.string("Rapporto Marce");
            }
            case 33: {
                return DanasDataStructure.getInstance().getMath1Name();
            }
            case 34: {
                return DanasDataStructure.getInstance().getMath2Name();
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return DanasDataStructure.getInstance().getNomeMulti(numCanale - 35);
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return DanasPreferences.getNomeMath(numCanale - 45, false);
            }
            case 55: {
                return Language.string("Cuore");
            }
            case 56: {
                return Language.string("P.Ant.");
            }
            case 57: {
                return Language.string("T.Ant.");
            }
            case 58: {
                return Language.string("P.Post.");
            }
            case 59: {
                return Language.string("T.Post.");
            }
        }
        return "Errore";
    }

    public void ripristinaPreferenze() {
        this.canale1.removeAllItems();
        this.canale2.removeAllItems();
        this.canale3.removeAllItems();
        this.canale4.removeAllItems();
        for (int i = 0; i < MeasuresUtil.getNumeroCurve() - 6; ++i) {
            if (i == 0) {
                this.canale1.addItem(Language.string("Nessuno"));
                this.canale2.addItem(Language.string("Nessuno"));
                this.canale3.addItem(Language.string("Nessuno"));
                this.canale4.addItem(Language.string("Nessuno"));
                continue;
            }
            this.canale1.addItem(MeasuresUtil.getNomeCanale(this.getCanaledaCombo(i)));
            this.canale2.addItem(MeasuresUtil.getNomeCanale(this.getCanaledaCombo(i)));
            this.canale3.addItem(MeasuresUtil.getNomeCanale(this.getCanaledaCombo(i)));
            this.canale4.addItem(MeasuresUtil.getNomeCanale(this.getCanaledaCombo(i)));
        }
        this.sogliaWater.setValue(DanasPreferences.getPrefAllarmeAcqua());
        this.sogliaTempo.setValue(DanasPreferences.getTempoAllarme());
        this.sogliaBatteria.setValue(Float.valueOf(DanasPreferences.getPrefAllarmeBatteria()));
        this.sogliaAllarme1ch1.setValue(Float.valueOf(DanasPreferences.getPrefValoreAllarme(0)));
        this.sogliaAllarme1ch2.setValue(Float.valueOf(DanasPreferences.getPrefValoreAllarme(1)));
        this.sogliaAllarme2ch1.setValue(Float.valueOf(DanasPreferences.getPrefValoreAllarme(2)));
        this.sogliaAllarme2ch2.setValue(Float.valueOf(DanasPreferences.getPrefValoreAllarme(3)));
        this.allarme1.setText(DanasPreferences.getPrefNomeAllarme(0));
        this.allarme2.setText(DanasPreferences.getPrefNomeAllarme(1));
        this.verso1.setSelectedIndex(DanasPreferences.getPrefVersoAllarme(0));
        this.verso2.setSelectedIndex(DanasPreferences.getPrefVersoAllarme(1));
        this.verso3.setSelectedIndex(DanasPreferences.getPrefVersoAllarme(2));
        this.verso4.setSelectedIndex(DanasPreferences.getPrefVersoAllarme(3));
        this.canale1.setSelectedIndex(this.getIndexdaCanale(DanasPreferences.getPrefCanaleAllarme(0)));
        this.canale2.setSelectedIndex(this.getIndexdaCanale(DanasPreferences.getPrefCanaleAllarme(1)));
        this.canale3.setSelectedIndex(this.getIndexdaCanale(DanasPreferences.getPrefCanaleAllarme(2)));
        this.canale4.setSelectedIndex(this.getIndexdaCanale(DanasPreferences.getPrefCanaleAllarme(3)));
        this.testEntrambi.setSelected(DanasPreferences.getPrefAndAllarmi());
    }

    private int getCanaledaCombo(int index) {
        int indice = index;
        if (index >= 46) {
            return indice += 5;
        }
        if (index >= 16 && index < 45) {
            return ++indice;
        }
        return indice;
    }

    private int getIndexdaCanale(int canale) {
        int indice = canale;
        if (indice >= 51) {
            return indice -= 5;
        }
        if (indice >= 17 && indice < 46) {
            return --indice;
        }
        return indice;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.esciButton) {
            this.padre.aggiornaNomiAllarmi();
            this.dispose();
        }
        if (e.getSource() == this.applyButton) {
            DanasPreferences.setPrefAllarmeAcqua(Integer.valueOf(this.sogliaWater.getValue().toString()));
            DanasPreferences.setTempoAllarme(Integer.valueOf(this.sogliaTempo.getValue().toString()));
            DanasPreferences.setPrefAllarmeBatteria(Float.valueOf(this.sogliaBatteria.getValue().toString()).floatValue());
            DanasPreferences.setPrefValoreAllarme(0, Float.valueOf(this.sogliaAllarme1ch1.getValue().toString()).floatValue());
            DanasPreferences.setPrefValoreAllarme(1, Float.valueOf(this.sogliaAllarme1ch2.getValue().toString()).floatValue());
            DanasPreferences.setPrefValoreAllarme(2, Float.valueOf(this.sogliaAllarme2ch1.getValue().toString()).floatValue());
            DanasPreferences.setPrefValoreAllarme(3, Float.valueOf(this.sogliaAllarme2ch2.getValue().toString()).floatValue());
            DanasPreferences.setPrefNomeAllarme(0, this.allarme1.getText());
            DanasPreferences.setPrefNomeAllarme(1, this.allarme2.getText());
            DanasPreferences.setPrefversoAllarme(0, this.verso1.getSelectedIndex());
            DanasPreferences.setPrefversoAllarme(1, this.verso2.getSelectedIndex());
            DanasPreferences.setPrefversoAllarme(2, this.verso3.getSelectedIndex());
            DanasPreferences.setPrefversoAllarme(3, this.verso4.getSelectedIndex());
            DanasPreferences.setPrefCanaleAllarme(0, this.getCanaledaCombo(this.canale1.getSelectedIndex()));
            DanasPreferences.setPrefCanaleAllarme(1, this.getCanaledaCombo(this.canale2.getSelectedIndex()));
            DanasPreferences.setPrefCanaleAllarme(2, this.getCanaledaCombo(this.canale3.getSelectedIndex()));
            DanasPreferences.setPrefCanaleAllarme(3, this.getCanaledaCombo(this.canale4.getSelectedIndex()));
            DanasPreferences.setPrefAndAllarmi(this.testEntrambi.isSelected());
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.padre.aggiornaNomiAllarmi();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        AllarmiDialog test = new AllarmiDialog(null);
        test.setVisible(true);
    }
}

