/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.sessionViewer;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.DataStructure.sessionViewer.MyDefaultCellRendererSess;
import i2m.DataStructure.sessionViewer.MyTableModelSess;
import i2m.Language;
import i2m.grafico.ContenitoreGrafico;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SessionViewer
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static DanasDataStructure ds;
    private static JScrollPane viewerScrollPaneMinimo;
    private static JScrollPane viewerScrollPaneMassimo;
    private static JScrollPane viewerScrollPaneAvg;
    private static JTable tableMinimo;
    private static JTable tableMassimo;
    private static JTable tableAvg;
    private static MyTableModelSess modelloMinimo;
    private static MyTableModelSess modelloMassimo;
    private static MyTableModelSess modelloAvg;
    static int NUM_CURVE;
    static boolean[] canali;
    static int canaliAttivi;

    public SessionViewer() {
        modelloMinimo = new MyTableModelSess();
        modelloMassimo = new MyTableModelSess();
        modelloAvg = new MyTableModelSess();
        tableMinimo = new JTable(modelloMinimo);
        tableMinimo.getTableHeader().setReorderingAllowed(false);
        tableMinimo.setDefaultRenderer(Object.class, new MyDefaultCellRendererSess(true));
        tableMinimo.setFillsViewportHeight(true);
        tableMassimo = new JTable(modelloMassimo);
        tableMassimo.getTableHeader().setReorderingAllowed(false);
        tableMassimo.setDefaultRenderer(Object.class, new MyDefaultCellRendererSess(true));
        tableMassimo.setFillsViewportHeight(true);
        tableAvg = new JTable(modelloAvg);
        tableAvg.getTableHeader().setReorderingAllowed(false);
        tableAvg.setDefaultRenderer(Object.class, new MyDefaultCellRendererSess(true));
        tableAvg.setFillsViewportHeight(true);
        DanasDataStructure.getInstance().addChangeListener(this);
        this.setLayout(new GridLayout(3, 1));
        JPanel pannelloMinimo = new JPanel();
        JPanel pannelloMassimo = new JPanel();
        JPanel pannelloAvg = new JPanel();
        viewerScrollPaneMinimo = new JScrollPane(tableMinimo);
        viewerScrollPaneMassimo = new JScrollPane(tableMassimo);
        viewerScrollPaneAvg = new JScrollPane(tableAvg);
        Font font = new Font("sansserif", 1, 24);
        JLabel labelMinimo = new JLabel(Language.string("Valori minimi"));
        labelMinimo.setFont(font);
        JLabel labelMassimo = new JLabel(Language.string("Valori Massimi"));
        labelMassimo.setFont(font);
        JLabel labelAvg = new JLabel(Language.string("Valori medi"));
        labelAvg.setFont(font);
        pannelloMinimo.setLayout(new BorderLayout());
        pannelloMinimo.add((Component)labelMinimo, "First");
        pannelloMinimo.add((Component)viewerScrollPaneMinimo, "Center");
        pannelloMassimo.setLayout(new BorderLayout());
        pannelloMassimo.add((Component)labelMassimo, "First");
        pannelloMassimo.add((Component)viewerScrollPaneMassimo, "Center");
        pannelloAvg.setLayout(new BorderLayout());
        pannelloAvg.add((Component)labelAvg, "First");
        pannelloAvg.add((Component)viewerScrollPaneAvg, "Center");
        this.add(pannelloMinimo);
        this.add(pannelloMassimo);
        this.add(pannelloAvg);
    }

    public static void updateView() {
        boolean refresh = false;
        for (int i = 0; i < NUM_CURVE; ++i) {
            if (canali[i] == DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().isChannelOnInfo(i)) continue;
            refresh = true;
            break;
        }
        if (refresh) {
            SessionViewer.refreshAll();
        }
    }

    public static void refreshAll() {
        int i;
        if (modelloMinimo == null) {
            return;
        }
        if (modelloMassimo == null) {
            return;
        }
        if (modelloAvg == null) {
            return;
        }
        modelloMinimo.svuotaTabella();
        modelloMassimo.svuotaTabella();
        modelloAvg.svuotaTabella();
        if (ds.getDefaultSession() == null) {
            return;
        }
        System.out.println("Aggiorno sessionViewer");
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        for (i = 0; i < NUM_CURVE; ++i) {
            SessionViewer.canali[i] = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().isChannelOnInfo(i);
            if (MeasuresUtil.getValueType(i) != DanasDataStructureConstants.ValueType.SIM1 && MeasuresUtil.getValueType(i) != DanasDataStructureConstants.ValueType.SIM2) continue;
            SessionViewer.canali[i] = false;
        }
        canaliAttivi = 0;
        modelloMinimo.addColunmName("Laps");
        modelloMassimo.addColunmName("Laps");
        modelloAvg.addColunmName("Laps");
        for (i = 0; i < NUM_CURVE; ++i) {
            if (!canali[i]) continue;
            ++canaliAttivi;
            modelloMinimo.addColunmName(grafico.getNomeAsse(i));
            modelloMassimo.addColunmName(grafico.getNomeAsse(i));
            modelloAvg.addColunmName(grafico.getNomeAsse(i));
        }
        String[] valoriMin = new String[canaliAttivi + 1];
        String[] valoriMax = new String[canaliAttivi + 1];
        String[] valoriAvg = new String[canaliAttivi + 1];
        int colonna = 0;
        for (DanasSession s : ds.getSessions()) {
            valoriMin = new String[canaliAttivi + 1];
            valoriMax = new String[canaliAttivi + 1];
            valoriAvg = new String[canaliAttivi + 1];
            valoriMin[0] = s.getSessionName() + " ( " + MeasuresUtil.timeToHumanHours(s.getSessionStartHour()) + " )";
            valoriMax[0] = s.getSessionName() + " ( " + MeasuresUtil.timeToHumanHours(s.getSessionStartHour()) + " )";
            valoriAvg[0] = s.getSessionName() + " ( " + MeasuresUtil.timeToHumanHours(s.getSessionStartHour()) + " )";
            colonna = 1;
            for (int i2 = 0; i2 < NUM_CURVE; ++i2) {
                if (!canali[i2]) continue;
                valoriMin[colonna] = MeasuresUtil.getValorePulito(MeasuresUtil.getValueType(i2), s.getMinGenericData(MeasuresUtil.getValueType(i2)));
                valoriMax[colonna] = MeasuresUtil.getValorePulito(MeasuresUtil.getValueType(i2), s.getMaxGenericData(MeasuresUtil.getValueType(i2)));
                valoriAvg[colonna] = MeasuresUtil.valueToHumanReadable(s.getAvgGenericData(MeasuresUtil.getValueType(i2)), 2);
                ++colonna;
            }
            modelloMinimo.addRow(valoriMin);
            modelloMassimo.addRow(valoriMax);
            modelloAvg.addRow(valoriAvg);
        }
        modelloMinimo.calcolaEstremi();
        modelloMassimo.calcolaEstremi();
        modelloAvg.calcolaEstremi();
    }

    public void setDataStructure(DanasDataStructure dds) {
        ds = dds;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        DanasDataStructureConstants.ChangeType ct = DanasDataStructureConstants.ChangeType.valueOf(ds.getChange().name());
        switch (ct) {
            case SEL_SESSION: {
                break;
            }
            case DESEL_SESSION: {
                break;
            }
            case SEL_LAP: {
                break;
            }
            case DESEL_LAP: {
                break;
            }
            case SEL_ALL_SESSION: {
                break;
            }
            case DESEL_ALL_SESSION: {
                break;
            }
            case SEL_ALL_LAP: {
                break;
            }
            case DESEL_ALL_LAP: {
                break;
            }
            case SESSION_COLOR: {
                break;
            }
            case LAP_COLOR: {
                break;
            }
            case REFRESH_ALL: {
                break;
            }
            case NEW_SETTINGS: {
                break;
            }
            case NEW_DATA: {
                break;
            }
            case REMOVE_DATA: {
                SessionViewer.refreshAll();
                break;
            }
            case NOTES: {
                break;
            }
            default: {
                System.err.println("SessionViewer: Unknown ChangeType");
            }
        }
    }

    static {
        NUM_CURVE = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getNumCurve();
        canali = new boolean[DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico().getNumCurve()];
        canaliAttivi = 0;
    }
}

