/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasTable;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasParser;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.Dialog.RitardoVideo;
import i2m.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Instant;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;

public class VideoEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = 1L;
    private int sid = 0;
    private int column1 = 0;
    private boolean settaggio = false;
    JFileChooser fc = new JFileChooser();
    Color currentColor;
    JButton button;
    ImageIcon img;
    JDialog dialog;
    protected static final String EDIT = "edit";

    public VideoEditor() {
        this.fc.setDialogTitle(Language.string("Select video"));
        this.fc.setFileFilter(new FileNameExtensionFilter("Video mp4", "mp4"));
        this.button = new JButton();
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.button.setBackground(this.currentColor);
            if (!this.settaggio) {
                if (!DanasDataStructure.getInstance().getSession(this.sid).hasVideo()) {
                    this.fc.setDialogTitle(Language.string("Select video"));
                    this.fc.resetChoosableFileFilters();
                    this.fc.setFileFilter(new FileNameExtensionFilter("Video mp4", "mp4"));
                    int returnVal = this.fc.showOpenDialog(this.button);
                    if (returnVal == 0) {
                        File file = this.fc.getSelectedFile();
                        try {
                            file.setReadable(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        DanasDataStructure.getInstance().getSession(this.sid).setVideoFilename(file.getPath());
                        this.img = new ImageIcon(this.getClass().getResource("/pix/video1.png"));
                        System.out.println(file.getPath());
                    }
                    if (DanasDataStructure.getInstance().getDefaultSession().getSessionID() == this.sid) {
                        DanasDataStructure.getInstance().getMainFrame().aggiornaFileVideo();
                    }
                    this.fireEditingStopped();
                } else {
                    String nome = DanasDataStructure.getInstance().getSession(this.sid).getVideoFilename();
                    Object[] options = new Object[]{Language.string("Change video"), Language.string("Remove video"), Language.string("Cambia offset"), Language.string("Calcola offset GoPro")};
                    int n = JOptionPane.showOptionDialog(this.button, Language.string("Video Action:") + nome, Language.string("Session's video"), 1, 3, null, options, options[1]);
                    switch (n) {
                        case 0: {
                            int returnVal = this.fc.showOpenDialog(this.button);
                            if (returnVal != 0) break;
                            File file = this.fc.getSelectedFile();
                            try {
                                file.setReadable(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            DanasDataStructure.getInstance().getSession(this.sid).setVideoFilename(file.getPath());
                            this.img = new ImageIcon(this.getClass().getResource("/pix/video1.png"));
                            DanasDataStructure.getInstance().getSession(this.sid).setOffsetVideoSessione(0);
                            System.out.println(file.getPath());
                            break;
                        }
                        case 1: {
                            DanasDataStructure.getInstance().getSession(this.sid).setVideoFilename(null);
                            this.img = new ImageIcon(this.getClass().getResource("/pix/no_video1.png"));
                            DanasDataStructure.getInstance().getSession(this.sid).setOffsetVideoSessione(0);
                            break;
                        }
                        case 2: {
                            RitardoVideo d = new RitardoVideo(DanasDataStructure.getInstance().getMainFrame());
                            d.setRitardoSessione(DanasDataStructure.getInstance().getSession(this.sid).getOffsetVideoSessione());
                            d.setLocationRelativeTo(null);
                            d.setVisible(true);
                            DanasDataStructure.getInstance().getSession(this.sid).setOffsetVideoSessione(d.getValoreRitardo());
                            DanasDataStructure.getInstance().getMainFrame().aggiornaPosizioneVideo();
                            break;
                        }
                        case 3: {
                            this.getOffsetGopro(DanasDataStructure.getInstance().getSession(this.sid).getVideoFilename());
                            break;
                        }
                        default: {
                            System.out.println("Video action error: " + n);
                        }
                    }
                    boolean aggiornaSessioneDefault = false;
                    boolean aggiornaGiroDefault = false;
                    boolean aggiornaGiroCompare = false;
                    if (DanasDataStructure.getInstance().getDefaultSession() != null && DanasDataStructure.getInstance().getDefaultSession().getSessionID() == this.sid) {
                        aggiornaSessioneDefault = true;
                    }
                    if (DanasDataStructure.getInstance().getDefaultLap() != null && DanasDataStructure.getInstance().getDefaultLap().getSession().getSessionID() == this.sid) {
                        aggiornaGiroDefault = true;
                    }
                    if (DanasDataStructure.getInstance().getVideoCompareLap() != null && DanasDataStructure.getInstance().getVideoCompareLap().getSession().getSessionID() == this.sid) {
                        aggiornaGiroCompare = true;
                    }
                    if (aggiornaSessioneDefault || aggiornaGiroDefault || aggiornaGiroCompare) {
                        DanasDataStructure.getInstance().getMainFrame().aggiornaFileVideo();
                        DanasDataStructure.getInstance().getMainFrame().aggiornaFileVideoCompare();
                    }
                    this.fireEditingStopped();
                }
            } else {
                String nome = DanasDataStructure.getInstance().getSession(this.sid).getSessionSettings().getSettingsFileName();
                if (nome.endsWith("tmp")) {
                    nome = Language.string("Interno");
                }
                Object[] options = new Object[]{Language.string("Apri settaggio"), Language.string("Cambia settaggio"), Language.string("Annulla")};
                int n = JOptionPane.showOptionDialog(this.button, Language.string("Settaggio:") + nome, Language.string("Settings"), 1, 3, null, options, options[0]);
                switch (n) {
                    case 0: {
                        File f = new File(DanasDataStructure.getInstance().getSession(this.sid).getSessionSettings().getSettingsFileName());
                        System.out.println("apro modifica settaggio su:" + f.getName());
                        DanasDataStructure.getInstance().getMainFrame().apriModificaSettaggi(f, this.sid);
                        break;
                    }
                    case 1: {
                        this.fc.setDialogTitle(Language.string("Select settings file"));
                        this.fc.resetChoosableFileFilters();
                        this.fc.setFileFilter(new FileNameExtensionFilter("Settaggi", "dfs"));
                        int returnVal = this.fc.showOpenDialog(this.button);
                        if (returnVal != 0) break;
                        File file = this.fc.getSelectedFile();
                        try {
                            file.setReadable(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        DanasParser.parseImposFile(file.getPath(), this.sid);
                        DanasDataStructure.getInstance().getSession(this.sid).getSessionSettings().setSettingsFileName(file.getPath());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        System.out.println("Setting action error: " + n);
                    }
                }
                this.fireEditingStopped();
            }
        }
    }

    public static boolean isMacintoshArm() {
        return System.getProperty("os.name", "none").toLowerCase().indexOf("mac") != -1 && System.getProperty("os.arch", "none").toLowerCase().indexOf("aarch64") != -1;
    }

    public static boolean isMacintoshIntel() {
        return System.getProperty("os.name", "none").toLowerCase().indexOf("mac") != -1 && System.getProperty("os.arch", "none").toLowerCase().indexOf("x86_64") != -1;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name", "none").toLowerCase().indexOf("window") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name", "none").toLowerCase().indexOf("linux") != -1;
    }

    public void getOffsetGopro(String fileName) {
        if (DanasDataStructure.getInstance().getSession(this.sid).getFrequenzaCanale(DanasDataStructureConstants.ValueType.GPS_TIME) == 0.0) {
            JOptionPane.showMessageDialog(DanasDataStructure.getInstance().getMainFrame().getTableWindow(), Language.string("Il file dei dati non contiene dati GPS. Impossibile proseguire."), Language.string("Attenzione"), 2);
            return;
        }
        File f = null;
        if (VideoEditor.isMacintoshIntel()) {
            f = new File("./GOPRO_EX/gps_time.mac_intel");
        } else if (VideoEditor.isMacintoshArm()) {
            f = new File("./GOPRO_EX/gps_time.mac_arm");
        } else if (VideoEditor.isWindows()) {
            f = new File("./GOPRO_EX/gps_time.win.exe");
        } else if (VideoEditor.isLinux()) {
            f = new File("./GOPRO_EX/gps_time.linux");
        }
        String programPath = "";
        try {
            programPath = f.getCanonicalPath();
            System.out.println("DEBUG: absolute path=" + programPath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(DanasDataStructure.getInstance().getMainFrame().getTableWindow(), Language.string("ERRORE: controllare la presenza cartella GOPRO_EX nella cartella DanasPro"), Language.string("Attenzione"), 2);
            return;
        }
        String[] a = new String[]{programPath, fileName};
        try {
            String line;
            DanasDataStructure.getInstance().getMainFrame().chiudiVideo();
            Process p = Runtime.getRuntime().exec(a);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("Fix found after")) {
                    double timeOfFix = Double.valueOf(line.split(" ")[3]);
                    String utcOfFix = line.split(" ")[6];
                    System.out.println("DEBUG: Found: " + utcOfFix + " after " + timeOfFix);
                    String year = "20" + utcOfFix.substring(0, 2);
                    String month = utcOfFix.substring(2, 4);
                    String day = utcOfFix.substring(4, 6);
                    String hour = utcOfFix.substring(6, 8);
                    String min = utcOfFix.substring(8, 10);
                    String sec = utcOfFix.substring(10, 16);
                    Instant utcOfFirstFrame = Instant.parse(year + "-" + month + "-" + day + "T" + hour + ":" + min + ":" + sec + "Z").minusMillis(Math.round(timeOfFix * 1000.0));
                    System.out.println("DEBUG: UTC of first Frame: " + utcOfFirstFrame);
                    DanasSession sess = DanasDataStructure.getInstance().getSession(this.sid);
                    Date d = sess.getDate();
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(d);
                    int yearGPS = calendar.get(1);
                    int monthGPS = calendar.get(2) + 1;
                    int dayGPS = calendar.get(5);
                    String dataFormattata = String.format("%d-%02d-%02dT00:00:00.000Z", yearGPS, monthGPS, dayGPS);
                    Long centesimiPrimaOraGps = sess.getSessionStartHour();
                    Instant utcOfSession = Instant.parse(dataFormattata).plusMillis(centesimiPrimaOraGps);
                    utcOfSession = utcOfSession.minusMillis(DanasDataStructure.getInstance().getSession(this.sid).getFusoSessione() * 3600000);
                    System.out.println("DEBUG: UTC of first gps  : " + utcOfSession);
                    double tempoPrimoGps = sess.getTempoIniziale(DanasDataStructureConstants.ValueType.GPS_TIME) - sess.getTempoPrimoDato();
                    utcOfSession = utcOfSession.minusMillis((long)(tempoPrimoGps * 10.0));
                    System.out.println("UTC of session: " + utcOfSession + " offset primo segnale GPS [ms]=" + tempoPrimoGps * 10.0);
                    long offset = utcOfFirstFrame.toEpochMilli() - utcOfSession.toEpochMilli();
                    System.out.println("DEBUG: offset video=" + offset);
                    if (offset < 3600000L && offset > -36000000L) {
                        DanasDataStructure.getInstance().getSession(this.sid).setOffsetVideoSessione(-((int)offset) / 10);
                        DanasDataStructure.getInstance().getMainFrame().aggiornaPosizioneVideo();
                        JOptionPane.showMessageDialog(DanasDataStructure.getInstance().getMainFrame().getTableWindow(), Language.string("Offset video impostato per questa sessione"), Language.string("Info"), 1);
                        continue;
                    }
                    JOptionPane.showMessageDialog(DanasDataStructure.getInstance().getMainFrame().getTableWindow(), Language.string("L'offeset tra video e dati \u00e8 maggiore di 1 ora ed \u00e8 stato scartato"), Language.string("Attenzione"), 2);
                    continue;
                }
                System.out.println("DEBUG: offset GoPro Not found");
                JOptionPane.showMessageDialog(DanasDataStructure.getInstance().getMainFrame().getTableWindow(), Language.string("L'informazione relativa al GPS non \u00e8 presente nel file video"), Language.string("Attenzione"), 2);
                System.out.println("DEBUG: GPS_TIME:" + line);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(DanasDataStructure.getInstance().getMainFrame().getTableWindow(), Language.string("ERRORE: controllare la presenza cartella GOPRO_EX nella cartella DanasPro"), Language.string("Attenzione"), 2);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.img;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.settaggio = column == 13;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).equalsIgnoreCase(Language.string("Session"))) continue;
            this.column1 = i;
        }
        this.sid = (Integer)table.getValueAt(row, this.column1);
        System.out.println("riga: " + row + " sessione: " + this.sid);
        this.img = (ImageIcon)value;
        return this.button;
    }
}

