/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasTable;

import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.Language;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

class ColorRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;

    public ColorRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        Color newColor = (Color)color;
        this.setBackground(newColor);
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, Color.white);
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        this.setToolTipText("RGB value: " + newColor.getRed() + ", " + newColor.getGreen() + ", " + newColor.getBlue());
        int sid2 = 0;
        if (table.getColumnName(2).equals(Language.string("Session"))) {
            sid2 = (Integer)table.getValueAt(row, 2);
            if (DanasDataStructure.getInstance().getSession(sid2).equals(DanasDataStructure.getInstance().getDefaultSession())) {
                this.setBorder(BorderFactory.createMatteBorder(2, 5, 2, 5, Color.LIGHT_GRAY));
            }
        }
        int sid1 = 0;
        int lid1 = 0;
        if (table.getColumnName(2).equals(Language.string("Session-Lap"))) {
            String val1 = (String)table.getValueAt(row, 2);
            sid1 = Integer.parseInt((String)val1.subSequence(0, val1.lastIndexOf("-")));
            lid1 = Integer.parseInt((String)val1.subSequence(val1.lastIndexOf("-") + 1, val1.length()));
            if (DanasDataStructure.getInstance().getDefaultLap() != null && DanasDataStructure.getInstance().getDefaultLap().equals(DanasDataStructure.getInstance().getSession(sid1).getLap(lid1))) {
                this.setBorder(BorderFactory.createMatteBorder(2, 5, 2, 5, Color.LIGHT_GRAY));
            }
            if (DanasDataStructure.getInstance().getVideoCompareLap() != null && DanasDataStructure.getInstance().getVideoCompareLap().equals(DanasDataStructure.getInstance().getSession(sid1).getLap(lid1))) {
                this.setBorder(BorderFactory.createMatteBorder(2, 5, 2, 5, Color.magenta));
            }
        }
        return this;
    }
}

