/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasDataStructure;

import i2m.DanasPreferences;
import i2m.DataStructure.danasDataStructure.ArrayDouble;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasDataStructure.DanasSession;
import i2m.DataStructure.danasDataStructure.DanasSplit;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import i2m.grafico.ContenitoreGrafico;
import i2m.mappa.Mappa2D;
import i2m.mappa.TrattinoCurva;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DanasLap {
    private DanasSession session;
    private double startTime = 0.0;
    private double endTime = 0.0;
    private boolean selected = false;
    private Color color;
    private int lapID;
    private double[][] GenericValueAnalisys = new double[DanasDataStructureConstants.ValueType.values().length][3];
    private Vector<DanasSplit> elencoSplit = new Vector();
    private double offsetTempo = 0.0;
    private boolean traslabile = false;
    private List<Integer> elencoIindiciInizioCurva = new ArrayList<Integer>();
    private List<Integer> elencoIindiciFineCurva = new ArrayList<Integer>();
    private double[] elencoRaggi;
    private final double INFINITO = 2000.0;
    boolean raggiCalcolati = false;
    int raggioMassimo = 200;
    int numeroPuntiMinimo = 5;
    double percentualeGasAperto = 0.0;
    double percentualeM1 = 0.0;
    double percentualeM2 = 0.0;
    double percentualeM3 = 0.0;
    double percentualeM4 = 0.0;
    boolean[] canaliAnalizzati = new boolean[DanasDataStructureConstants.ValueType.values().length];
    List<Double> canaleSpazio = new ArrayList<Double>();
    List<Double> canaleSpazioOriginale = new ArrayList<Double>();
    double tempoPrimoDato;
    private int indexGpsStart;
    private int indexGpsEnd;

    public DanasLap(DanasSession s, double start, double end, Color c, int lapid, boolean selected) {
        this.setSession(s);
        this.setStart(start);
        this.setEnd(end);
        this.color = c;
        this.setLapID(lapid);
        this.selected = selected;
        this.azzeraCanaliAnalizzati();
        this.indexGpsStart = this.session.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, this.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        this.indexGpsEnd = this.session.getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, this.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
    }

    public double getTempoIniziale(DanasDataStructureConstants.ValueType vt) {
        double frequenza = this.getSession().getFrequenzaCanale(vt);
        if (frequenza == 0.0) {
            return Double.MAX_VALUE;
        }
        int indice = this.getSession().getIndiceAtTime(vt, this.startTime, DanasDataStructureConstants.BoundLap.NEXT);
        double tempoInizio = this.getSession().getTempoIniziale(vt);
        if (indice == 0) {
            return tempoInizio;
        }
        return tempoInizio + (double)(indice * 100) / frequenza;
    }

    public List<Double> getValoriSpazio() {
        return this.canaleSpazio;
    }

    public void calcolaTempiDistanze() {
        this.tempoPrimoDato = Double.MAX_VALUE;
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            double tempo = this.getTempoIniziale(DanasDataStructureConstants.ValueType.values()[i]);
            if (!(tempo < this.tempoPrimoDato)) continue;
            this.tempoPrimoDato = tempo;
        }
        if (this.tempoPrimoDato == Double.MAX_VALUE) {
            return;
        }
        double tempoFinale = 0.0;
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            if (this.session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.values()[i]) == 0.0 || this.session.getValori(DanasDataStructureConstants.ValueType.values()[i]).size() <= 0) continue;
            int indiceStop = this.getSession().getIndiceAtTime(DanasDataStructureConstants.ValueType.values()[i], this.endTime, DanasDataStructureConstants.BoundLap.PREVIOUS);
            double tempoFinaleCanale = this.session.getTempoIniziale(DanasDataStructureConstants.ValueType.values()[i]) + 100.0 / this.session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.values()[i]) * (double)indiceStop;
            if (!(tempoFinaleCanale > tempoFinale)) continue;
            tempoFinale = tempoFinaleCanale;
        }
        this.canaleSpazio.clear();
        this.canaleSpazioOriginale.clear();
        List<Double> valori = this.session.getValoriSpazio();
        int numeroPunti = (int)((tempoFinale - this.tempoPrimoDato) / this.session.getRisoluzioneTemporale()) + 1;
        int indiceIniziale = (int)((this.tempoPrimoDato - this.session.getTempoPrimoDato()) / this.session.getRisoluzioneTemporale());
        double distanzaInizio = this.getDistanzaInizio();
        for (int i = 0; i < numeroPunti; ++i) {
            this.canaleSpazio.add(valori.get(indiceIniziale + i) - distanzaInizio);
            this.canaleSpazioOriginale.add(this.canaleSpazio.get(i));
        }
    }

    public double getTempoPrimoDato() {
        return this.tempoPrimoDato;
    }

    public double getTimeSessionAtSpazio(double spazio, DanasDataStructureConstants.BoundLap t) {
        if (spazio < 0.0) {
            return 0.0;
        }
        List<Double> valori = this.getValoriSpazio();
        double primoDato = valori.get(0);
        double ultimoDato = valori.get(valori.size() - 1);
        if (spazio < primoDato) {
            return this.getTempoPrimoDato();
        }
        if (spazio > ultimoDato) {
            return this.getTempoPrimoDato() + (double)(valori.size() - 1) * this.session.getRisoluzioneTemporale();
        }
        for (int i = 1; i < valori.size(); ++i) {
            double distanza = valori.get(i);
            if (distanza > spazio) {
                double dt1 = distanza - spazio;
                double dt2 = spazio - primoDato;
                if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
                    if (dt1 < dt2) {
                        return this.getTempoPrimoDato() + (double)i * this.session.getRisoluzioneTemporale();
                    }
                    return this.getTempoPrimoDato() + (double)(i - 1) * this.session.getRisoluzioneTemporale();
                }
                if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
                    return this.getTempoPrimoDato() + (double)(i - 1) * this.session.getRisoluzioneTemporale();
                }
                if (t == DanasDataStructureConstants.BoundLap.NEXT) {
                    return this.getTempoPrimoDato() + (double)i * this.session.getRisoluzioneTemporale();
                }
            }
            primoDato = distanza;
        }
        return this.getTempoPrimoDato() + (double)(valori.size() - 1) * this.session.getRisoluzioneTemporale();
    }

    public double getSpazioAtTime(double time, DanasDataStructureConstants.BoundLap t) {
        if (this.canaleSpazio.size() == 0) {
            return 0.0;
        }
        double inizio = this.getTempoPrimoDato();
        if (time <= inizio) {
            return this.canaleSpazio.get(0);
        }
        double indiceDouble = (time - inizio) / this.session.getRisoluzioneTemporale();
        int indice = 0;
        if (t == DanasDataStructureConstants.BoundLap.NEXT) {
            indice = (int)Math.ceil(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
            indice = (int)Math.floor(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
            indice = (int)Math.round(indiceDouble);
        }
        if (indice >= this.canaleSpazio.size()) {
            return this.canaleSpazio.get(this.canaleSpazio.size() - 1);
        }
        return this.canaleSpazio.get(indice);
    }

    public int getIndiceSpazioAtTime(double time, DanasDataStructureConstants.BoundLap t) {
        if (this.canaleSpazio.size() == 0) {
            return 0;
        }
        double inizio = this.getTempoPrimoDato();
        if (time <= inizio) {
            return 0;
        }
        double indiceDouble = (time - inizio) / this.session.getRisoluzioneTemporale();
        int indice = 0;
        if (t == DanasDataStructureConstants.BoundLap.NEXT) {
            indice = (int)Math.ceil(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.PREVIOUS) {
            indice = (int)Math.floor(indiceDouble);
        }
        if (t == DanasDataStructureConstants.BoundLap.NEAREST) {
            indice = (int)Math.round(indiceDouble);
        }
        if (indice >= this.canaleSpazio.size()) {
            return this.canaleSpazio.size() - 1;
        }
        return indice;
    }

    public void calcolaRitardi() {
        int i;
        int index = 0;
        DanasLap def = DanasDataStructure.getInstance().getDefaultLap();
        if (def == null) {
            return;
        }
        int indiceFineGps = this.indexGpsEnd;
        int indiceInizioGps = this.indexGpsStart;
        int dimensione = indiceFineGps - indiceInizioGps + 1;
        if (dimensione <= 1) {
            return;
        }
        int indiceInizioGpsDef = def.getSession().getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, def.getStart(), DanasDataStructureConstants.BoundLap.NEXT);
        int indiceFineGpsDef = def.getSession().getIndiceAtTime(DanasDataStructureConstants.ValueType.VEL_GPS, def.getEnd(), DanasDataStructureConstants.BoundLap.PREVIOUS);
        int dimensioneDef = indiceFineGpsDef - indiceInizioGpsDef + 1;
        if (dimensioneDef <= 1) {
            return;
        }
        double[] lapDistanze = new double[dimensione];
        double[] lapTempi = new double[dimensione];
        double[] defDistanze = new double[dimensioneDef];
        double[] defTempi = new double[dimensioneDef];
        double tempoInizio = this.session.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS) + (double)(indiceInizioGps * 100) / this.session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) - this.getStart();
        double distanzaInizioDef = def.getDistanzaInizio();
        double tempoInizioDef = def.getSession().getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS) + (double)(indiceInizioGpsDef * 100) / def.getSession().getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) - def.getStart();
        for (i = 0; i < dimensione; ++i) {
            lapTempi[i] = (double)(i * 100) / this.session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) + tempoInizio;
            lapDistanze[i] = this.getSpazioAtTime(lapTempi[i] + this.getStart(), DanasDataStructureConstants.BoundLap.NEAREST);
        }
        for (i = 0; i < dimensioneDef; ++i) {
            defTempi[i] = (double)(i * 100) / def.getSession().getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) + tempoInizioDef;
            defDistanze[i] = def.getSession().getSpazioAtTime(defTempi[i] + def.getStart(), DanasDataStructureConstants.BoundLap.NEAREST) - distanzaInizioDef;
        }
        double ritardo = 0.0;
        for (int i2 = 0; i2 < dimensione; ++i2) {
            double percentuale;
            while (lapDistanze[i2] > defDistanze[index] && index < dimensioneDef - 1) {
                ++index;
            }
            if (index > 0 && index < dimensioneDef - 1) {
                percentuale = (lapDistanze[i2] - defDistanze[index - 1]) / (defDistanze[index] - defDistanze[index - 1]);
                ritardo = (lapTempi[i2] - (defTempi[index - 1] + percentuale * (defTempi[index] - defTempi[index - 1]))) / 100.0;
            } else {
                if (index == 0) {
                    ritardo = 0.0;
                }
                if (index == dimensioneDef - 1) {
                    if (lapDistanze[i2] <= defDistanze[index]) {
                        percentuale = (lapDistanze[i2] - defDistanze[index - 1]) / (defDistanze[index] - defDistanze[index - 1]);
                        ritardo = (lapTempi[i2] - (defTempi[index - 1] + percentuale * (defTempi[index] - defTempi[index - 1]))) / 100.0;
                    } else {
                        ritardo = (lapTempi[i2] - defTempi[index]) / 100.0;
                    }
                }
            }
            this.session.scriviRitardo(ritardo, indiceInizioGps + i2);
        }
    }

    public List<Integer> getElencoIndiciInizioCurva() {
        return this.elencoIindiciInizioCurva;
    }

    public List<Integer> getElencoIndiciFineCurva() {
        return this.elencoIindiciFineCurva;
    }

    public void calcolaInizioFineCurve() {
        if (!this.raggiCalcolati) {
            this.calcolaRaggi();
        }
        boolean inCurva = false;
        boolean inizioInCorso = false;
        boolean fineInCorso = false;
        int numeroPuntiEsaminati = 0;
        int indiceTemporaneo = 0;
        boolean positivo = false;
        this.elencoIindiciInizioCurva.clear();
        this.elencoIindiciFineCurva.clear();
        for (int i = 0; i < this.elencoRaggi.length; ++i) {
            if (inCurva) {
                if (fineInCorso) {
                    if (!(Math.abs(this.elencoRaggi[i]) < (double)this.raggioMassimo && (this.elencoRaggi[i] >= 0.0 && positivo || this.elencoRaggi[i] < 0.0 && !positivo))) {
                        if (++numeroPuntiEsaminati < this.numeroPuntiMinimo) continue;
                        fineInCorso = false;
                        inCurva = false;
                        this.elencoIindiciFineCurva.add(indiceTemporaneo);
                        continue;
                    }
                    fineInCorso = false;
                    numeroPuntiEsaminati = 0;
                    continue;
                }
                if (Math.abs(this.elencoRaggi[i]) < (double)this.raggioMassimo && (this.elencoRaggi[i] >= 0.0 && positivo || this.elencoRaggi[i] < 0.0 && !positivo)) continue;
                fineInCorso = true;
                indiceTemporaneo = i;
                numeroPuntiEsaminati = 1;
                continue;
            }
            if (inizioInCorso) {
                if (Math.abs(this.elencoRaggi[i]) < (double)this.raggioMassimo && (this.elencoRaggi[i] >= 0.0 && positivo || this.elencoRaggi[i] < 0.0 && !positivo)) {
                    if (++numeroPuntiEsaminati < this.numeroPuntiMinimo) continue;
                    inizioInCorso = false;
                    inCurva = true;
                    this.elencoIindiciInizioCurva.add(indiceTemporaneo);
                    continue;
                }
                inizioInCorso = false;
                numeroPuntiEsaminati = 0;
                continue;
            }
            if (!(Math.abs(this.elencoRaggi[i]) < (double)this.raggioMassimo)) continue;
            positivo = this.elencoRaggi[i] >= 0.0;
            inizioInCorso = true;
            indiceTemporaneo = i;
            numeroPuntiEsaminati = 1;
        }
    }

    public TrattinoCurva getTrattino(int index, boolean inizio, int numero) {
        if (index < 0) {
            index = 0;
        }
        if (index > this.indexGpsEnd - this.indexGpsStart) {
            index = this.indexGpsEnd - this.indexGpsStart;
        }
        ArrayDouble gpsLon = this.session.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
        ArrayDouble gpsLat = this.session.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
        double y = gpsLat.get(index + this.indexGpsStart);
        double x = gpsLon.get(index + this.indexGpsStart);
        x = Mappa2D.convertiX(x, y);
        double verso = 0.0;
        verso = index > 0 ? this.calcolaVerso(index - 1, index) : this.calcolaVerso(index, index + 1);
        return new TrattinoCurva(x, y, (long)verso, inizio, numero);
    }

    public double calcolaVerso(int start, int stop) {
        ArrayDouble gpsLon = this.session.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
        ArrayDouble gpsLat = this.session.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
        double y = gpsLat.get(stop + this.indexGpsStart) - gpsLat.get(start + this.indexGpsStart);
        double x = Mappa2D.convertiX(gpsLon.get(stop + this.indexGpsStart), gpsLat.get(stop + this.indexGpsStart)) - Mappa2D.convertiX(gpsLon.get(start + this.indexGpsStart), gpsLat.get(start + this.indexGpsStart));
        double angolo = 360.0 + 57.324840764331206 * Math.atan2(y, x);
        return angolo %= 360.0;
    }

    public void calcolaRaggi() {
        int i;
        double segno = 1.0;
        int filtro = 6;
        ArrayDouble gpsLon = this.session.getAllValueData(DanasDataStructureConstants.ValueType.LONG, false);
        ArrayDouble gpsLat = this.session.getAllValueData(DanasDataStructureConstants.ValueType.LAT, false);
        int dimensione = this.indexGpsEnd - this.indexGpsStart;
        this.elencoRaggi = new double[dimensione];
        if (dimensione < 2 * filtro + 1) {
            this.elencoIindiciInizioCurva.clear();
            this.elencoIindiciFineCurva.clear();
            this.elencoRaggi = null;
            return;
        }
        for (i = 0; i < filtro; ++i) {
            this.elencoRaggi[i] = 2000.0;
        }
        for (i = filtro; i < dimensione - filtro; ++i) {
            double r;
            double angoloTemp;
            double ya = gpsLat.get(i - filtro + this.indexGpsStart);
            double yb = gpsLat.get(i + this.indexGpsStart);
            double yc = gpsLat.get(i + filtro + this.indexGpsStart);
            double xa = Mappa2D.convertiX(gpsLon.get(i - filtro + this.indexGpsStart), ya);
            double xb = Mappa2D.convertiX(gpsLon.get(i + this.indexGpsStart), yb);
            double xc = Mappa2D.convertiX(gpsLon.get(i + filtro + this.indexGpsStart), yc);
            double a = Mappa2D.distanzaGeograficaDouble(xa, ya, xb, yb);
            double b = Mappa2D.distanzaGeograficaDouble(xb, yb, xc, yc);
            double c = Mappa2D.distanzaGeograficaDouble(xa, ya, xc, yc);
            double x0 = xb - xa;
            double y0 = yb - ya;
            double x1 = xc - xb;
            double y1 = yc - yb;
            double angolo1 = (360.0 + 57.324840764331206 * Math.atan2(y0, x0)) % 360.0;
            double angolo2 = (360.0 + 57.324840764331206 * Math.atan2(y1, x1)) % 360.0;
            if (angolo1 >= 180.0) {
                angoloTemp = angolo1 - 180.0;
                segno = angolo2 > angoloTemp && angolo2 < angolo1 ? 1.0 : -1.0;
            } else {
                angoloTemp = angolo1 + 180.0;
                segno = angolo2 > angolo1 && angolo2 < angoloTemp ? -1.0 : 1.0;
            }
            double fattore1 = 0.5 * (a + b + c) - a;
            double fattore2 = 0.5 * (a + b + c) - b;
            double fattore3 = 0.5 * (a + b + c) - c;
            if (fattore1 < 0.0) {
                fattore1 = 0.0;
            }
            if (fattore2 < 0.0) {
                fattore2 = 0.0;
            }
            if (fattore3 < 0.0) {
                fattore3 = 0.0;
            }
            this.elencoRaggi[i] = (r = a * b * c / (4.0 * Math.sqrt(0.5 * (a + b + c) * fattore1 * fattore2 * fattore3))) < 2000.0 ? segno * r : segno * 2000.0;
        }
        for (i = dimensione - filtro; i < dimensione; ++i) {
            this.elencoRaggi[i] = 2000.0;
        }
        this.raggiCalcolati = true;
    }

    public double getPercentualeM(int numero) {
        switch (numero) {
            case 1: {
                return this.percentualeM1;
            }
            case 2: {
                return this.percentualeM2;
            }
            case 3: {
                return this.percentualeM3;
            }
            case 4: {
                return this.percentualeM4;
            }
        }
        return 0.0;
    }

    public double getPercentualeGasAperto() {
        return this.percentualeGasAperto;
    }

    public void setPercentualeGasAperto(double percentuale) {
        this.percentualeGasAperto = percentuale;
    }

    public boolean isDefaultLap() {
        DanasLap def = DanasDataStructure.getInstance().getDefaultLap();
        if (def == null) {
            return false;
        }
        return def.getLapID() == this.getLapID();
    }

    public void addSplit(Double time) {
        if (time == null) {
            if (this.elencoSplit.size() == 0) {
                DanasSplit split = new DanasSplit(this.startTime, this.startTime);
                this.elencoSplit.add(split);
                DanasSplit split2 = new DanasSplit(this.startTime, this.getEnd());
                this.elencoSplit.add(split2);
                return;
            }
            int n = this.getNSplit();
            DanasSplit ultimoSplit = this.getSplit(n);
            DanasSplit split = new DanasSplit(ultimoSplit.getEndTime(), ultimoSplit.getEndTime());
            this.elencoSplit.add(split);
            return;
        }
        if (this.elencoSplit.size() == 0) {
            DanasSplit split = new DanasSplit(this.startTime, time);
            this.elencoSplit.add(split);
            split = new DanasSplit(time, this.getEnd());
            this.elencoSplit.add(split);
        } else {
            DanasSplit split;
            int n = this.getNSplit();
            DanasSplit ultimoSplit = this.getPreviousSplit(n + 1);
            if (time > ultimoSplit.getStartTime()) {
                ultimoSplit.setEndTime(time);
                split = new DanasSplit(time, this.getEnd());
            } else {
                split = new DanasSplit(this.getEnd(), this.getEnd());
            }
            this.elencoSplit.add(split);
        }
    }

    public Vector<String> getTempiSplit() {
        Vector<String> elencoTempi = new Vector<String>();
        for (int i = 0; i < this.elencoSplit.size(); ++i) {
            elencoTempi.add(this.elencoSplit.get(i).toString());
        }
        return elencoTempi;
    }

    public DanasSplit getSplit(int ID) {
        if (ID < 1 || ID > this.getNSplit()) {
            return null;
        }
        return this.elencoSplit.get(ID - 1);
    }

    public DanasSplit getPreviousSplit(int ID) {
        if (ID < 2 || ID > this.getNSplit() + 1) {
            return null;
        }
        for (int i = ID - 1; i > 0; --i) {
            if (this.elencoSplit.get(i - 1).getDuration() == 0.0) continue;
            return this.elencoSplit.get(i - 1);
        }
        return null;
    }

    public Double getSplitTime(int ID) {
        if (ID < 1 || ID > this.getNSplit()) {
            return 0.0;
        }
        return this.elencoSplit.get(ID - 1).getDuration();
    }

    public int getNSplit() {
        return this.elencoSplit.size();
    }

    public void removeAllSplit() {
        this.elencoSplit.clear();
    }

    public void removeSplit(int index) {
    }

    public double getDistanceSplit(int indexSplit) {
        if (indexSplit <= 0 || indexSplit > this.getNSplit()) {
            return 0.0;
        }
        DanasSplit split = this.getSplit(indexSplit);
        if (split.getStartTime() == split.getEndTime()) {
            return 0.0;
        }
        double distanzaStart = this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, split.getStartTime());
        double distanzaStop = this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, split.getEndTime());
        return distanzaStop - distanzaStart;
    }

    public double getDistanzaInizio() {
        return this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, this.startTime);
    }

    public void normalizzaDistanze(Vector<Double> distanze) {
        boolean indiceSineSplit2 = false;
        if (distanze.size() == 0) {
            return;
        }
        if (distanze.size() != this.getNSplit() && distanze.size() != 1) {
            return;
        }
        if (this.canaleSpazio.size() == 0) {
            this.calcolaTempiDistanze();
        }
        ArrayList<Double> nuoviSpazi = new ArrayList<Double>();
        if (distanze.size() == 1) {
            double distanzaAttuale = this.isGpsPresent() ? this.getDistanceCovered(DanasDataStructureConstants.DataType.GPS) : this.getDistanceCovered(DanasDataStructureConstants.DataType.VALUE);
            double distanzaDefault = distanze.get(0);
            double fattoreZoom = distanzaDefault / distanzaAttuale;
            this.canaleSpazio.clear();
            for (int i = 0; i < this.canaleSpazioOriginale.size(); ++i) {
                this.canaleSpazio.add(this.canaleSpazioOriginale.get(i) * fattoreZoom);
            }
        } else {
            int i;
            double spazioIniziale = 0.0;
            double offSetSpazioSplit = 0.0;
            double distanzaStart = this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, this.startTime);
            for (i = 1; i <= this.getNSplit(); ++i) {
                if (this.getSplit(i).getStartTime() == this.getSplit(i).getEndTime()) continue;
                double distanzaAttuale = this.getDistanceSplit(i);
                double distanzaDefault = distanze.get(i - 1);
                double fattoreZoom = distanzaDefault / distanzaAttuale;
                int primoIndice = this.getIndiceSpazioAtTime(this.getSplit(i).getStartTime(), DanasDataStructureConstants.BoundLap.NEXT);
                int secondoIndice = this.getIndiceSpazioAtTime(this.getSplit(i).getEndTime(), DanasDataStructureConstants.BoundLap.PREVIOUS);
                for (int j = primoIndice; j <= secondoIndice; ++j) {
                    if (j >= this.canaleSpazioOriginale.size()) continue;
                    nuoviSpazi.add((this.canaleSpazioOriginale.get(j) - spazioIniziale) * fattoreZoom + offSetSpazioSplit);
                }
                offSetSpazioSplit += distanze.get(i - 1).doubleValue();
                spazioIniziale = this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, this.getSplit(i).getEndTime()) - distanzaStart;
            }
            this.canaleSpazio.clear();
            for (i = 0; i < nuoviSpazi.size(); ++i) {
                this.canaleSpazio.add((Double)nuoviSpazi.get(i));
            }
        }
    }

    public double getDistanzaInizioLap(double time) {
        double distTot = this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, this.startTime + time);
        return distTot - this.getDistanzaInizio();
    }

    public double getDistanceCovered(DanasDataStructureConstants.DataType t) {
        switch (t) {
            case GPS: {
                return this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, this.endTime) - this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.VEL_GPS, this.startTime);
            }
            case VALUE: {
                return this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.SPEED1, this.endTime) - this.session.calcolaDistanzaInizioSessione(DanasDataStructureConstants.ValueType.SPEED1, this.startTime);
            }
        }
        System.err.println("Error: GPS or VALUE");
        return -1.0;
    }

    public boolean getTraslabile() {
        return this.traslabile;
    }

    public void setTraslabile(boolean sblocca) {
        this.traslabile = sblocca;
    }

    public void azzeraCanaliAnalizzati() {
        for (int i = 0; i < DanasDataStructureConstants.ValueType.values().length; ++i) {
            this.canaliAnalizzati[i] = false;
        }
    }

    public boolean isCanaleAnalizzato(DanasDataStructureConstants.ValueType val) {
        return this.canaliAnalizzati[val.ordinal()];
    }

    public void setCanaleAnalizzato(DanasDataStructureConstants.ValueType val) {
        this.canaliAnalizzati[val.ordinal()] = true;
    }

    public void setStart(double start) {
        this.startTime = start;
    }

    public void setEnd(double end) {
        this.endTime = end;
    }

    public double getStart() {
        return this.startTime;
    }

    public double getEnd() {
        return this.endTime;
    }

    public void setSelected(boolean selected) {
        boolean giroSingolo = false;
        boolean giroSingoloAltro = false;
        boolean settatoDefault = false;
        if (DanasPreferences.getOpzioneColoreConfronto() && selected) {
            for (int i = 1; i < 6; ++i) {
                if (DanasDataStructure.getInstance().isColorSelected(new Color(DanasPreferences.getPrefColoreConfronto(i)))) continue;
                this.setColor(new Color(DanasPreferences.getPrefColoreConfronto(i)));
                break;
            }
        }
        if (selected && DanasDataStructure.getInstance().getNumberSelectedLaps() == 0) {
            giroSingolo = true;
        }
        if (!selected && DanasDataStructure.getInstance().getNumberSelectedLaps() == 2) {
            giroSingoloAltro = true;
        }
        this.selected = selected;
        if (!selected) {
            this.traslabile = false;
            this.offsetTempo = 0.0;
        }
        if (giroSingolo && DanasDataStructure.getInstance().getSingoloDefault() && !DanasDataStructure.getInstance().getConfrontaDefault()) {
            settatoDefault = true;
            DanasDataStructure.getInstance().setDefaultLap(this);
        }
        if (giroSingoloAltro && DanasDataStructure.getInstance().getSingoloDefault() && !DanasDataStructure.getInstance().getConfrontaDefault()) {
            DanasDataStructure.getInstance().setDefaultLap(DanasDataStructure.getInstance().getfirstLapSelected());
        }
        DanasDataStructureConstants.ChangeType c = selected ? DanasDataStructureConstants.ChangeType.SEL_LAP : DanasDataStructureConstants.ChangeType.DESEL_LAP;
        if (!settatoDefault) {
            DanasDataStructure.getInstance().setChange(c, String.valueOf(this.session.getSessionID()) + "-" + String.valueOf(this.lapID));
        }
    }

    public void setSelected2(boolean selected) {
        boolean giroSingolo = false;
        boolean giroSingoloAltro = false;
        if (selected && DanasDataStructure.getInstance().getNumberSelectedLaps() == 0) {
            giroSingolo = true;
        }
        if (!selected && DanasDataStructure.getInstance().getNumberSelectedLaps() == 2) {
            giroSingoloAltro = true;
        }
        this.selected = selected;
        if (!selected) {
            this.traslabile = false;
            this.offsetTempo = 0.0;
        }
        if (giroSingolo && DanasDataStructure.getInstance().getSingoloDefault() && !DanasDataStructure.getInstance().getConfrontaDefault()) {
            DanasDataStructure.getInstance().setDefaultLap(this);
        }
        if (giroSingoloAltro && DanasDataStructure.getInstance().getSingoloDefault() && !DanasDataStructure.getInstance().getConfrontaDefault()) {
            DanasDataStructure.getInstance().setDefaultLap(DanasDataStructure.getInstance().getfirstLapSelected());
        }
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setColor(Color color) {
        this.color = color;
        DanasDataStructure.getInstance().setChange(DanasDataStructureConstants.ChangeType.LAP_COLOR, this.getSession().getSessionID() + "-" + this.lapID);
    }

    public Color getColor() {
        return this.color;
    }

    public void setLapID(int lapID) {
        this.lapID = lapID;
    }

    public int getLapID() {
        return this.lapID;
    }

    public double getDuration() {
        return (this.endTime - this.startTime) * 10.0;
    }

    public void setSession(DanasSession session) {
        this.session = session;
    }

    public DanasSession getSession() {
        return this.session;
    }

    public void setOffsetTempo(double offset) {
        this.offsetTempo = offset;
    }

    public double getOffsetTempo() {
        return this.offsetTempo;
    }

    public boolean isAggiornamentoAnalisiRichiesto(boolean analizzaAn1) {
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        for (DanasDataStructureConstants.ValueType t : DanasDataStructureConstants.ValueType.values()) {
            if (t == DanasDataStructureConstants.ValueType.SIM1 || t == DanasDataStructureConstants.ValueType.SIM2 || !grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t)) && !this.isCanaleAnalizzato(t) || this.isCanaleAnalizzato(t) && grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t))) continue;
            return true;
        }
        return false;
    }

    public void aggiornaAnalisi() {
        ContenitoreGrafico grafico = DanasDataStructure.getInstance().getMainFrame().getContenitoreGrafico();
        double[][] gva = new double[DanasDataStructureConstants.ValueType.values().length][3];
        if (!grafico.isChannelOnInfo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_1))) {
            this.percentualeM1 = -1.0;
        }
        if (!grafico.isChannelOnInfo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_2))) {
            this.percentualeM2 = -1.0;
        }
        if (!grafico.isChannelOnInfo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_3))) {
            this.percentualeM3 = -1.0;
        }
        if (!grafico.isChannelOnInfo(MeasuresUtil.getPositionType(DanasDataStructureConstants.ValueType.MATH_4))) {
            this.percentualeM4 = -1.0;
        }
        for (DanasDataStructureConstants.ValueType t : DanasDataStructureConstants.ValueType.values()) {
            if (t == DanasDataStructureConstants.ValueType.SIM1 || t == DanasDataStructureConstants.ValueType.SIM2 || !grafico.isChannelOnInfo(MeasuresUtil.getPositionType(t)) && t != DanasDataStructureConstants.ValueType.ANALOG1) continue;
            double max = Double.NaN;
            double min = Double.NaN;
            int gasAperto = 0;
            int m1 = 0;
            int m2 = 0;
            int m3 = 0;
            int m4 = 0;
            int numeroValoriMedia = 0;
            double valoreSomma = 0.0;
            int dimensione = 0;
            List<Double> out = this.session.getSelectionValueDataFiltrati(t, this.startTime, this.endTime, true);
            if (out != null) {
                dimensione = out.size();
            }
            for (int i = 0; i < dimensione; ++i) {
                if (Double.isNaN(max) && !Double.isNaN(out.get(i)) || out.get(i) > max) {
                    max = out.get(i);
                }
                if (Double.isNaN(min) && !Double.isNaN(out.get(i)) || out.get(i) < min) {
                    min = out.get(i);
                }
                if (!Double.isNaN(out.get(i))) {
                    ++numeroValoriMedia;
                    valoreSomma += out.get(i).doubleValue();
                }
                if (t == DanasDataStructureConstants.ValueType.ANALOG1 && out.get(i) > 95.0) {
                    ++gasAperto;
                }
                if (t == DanasDataStructureConstants.ValueType.MATH_1 && out.get(i) > 0.0) {
                    ++m1;
                }
                if (t == DanasDataStructureConstants.ValueType.MATH_2 && out.get(i) > 0.0) {
                    ++m2;
                }
                if (t == DanasDataStructureConstants.ValueType.MATH_3 && out.get(i) > 0.0) {
                    ++m3;
                }
                if (t != DanasDataStructureConstants.ValueType.MATH_4 || !(out.get(i) > 0.0)) continue;
                ++m4;
            }
            gva[t.ordinal()][0] = max;
            gva[t.ordinal()][1] = min;
            gva[t.ordinal()][2] = numeroValoriMedia != 0 ? valoreSomma / (double)numeroValoriMedia : 0.0;
            if (t == DanasDataStructureConstants.ValueType.ANALOG1 && dimensione != 0) {
                this.percentualeGasAperto = (double)gasAperto / (double)out.size();
            }
            if (t == DanasDataStructureConstants.ValueType.MATH_1 && dimensione != 0) {
                this.percentualeM1 = (double)m1 / (double)out.size();
            }
            if (t == DanasDataStructureConstants.ValueType.MATH_2 && dimensione != 0) {
                this.percentualeM2 = (double)m2 / (double)out.size();
            }
            if (t == DanasDataStructureConstants.ValueType.MATH_3 && dimensione != 0) {
                this.percentualeM3 = (double)m3 / (double)out.size();
            }
            if (t != DanasDataStructureConstants.ValueType.MATH_4 || dimensione == 0) continue;
            this.percentualeM4 = (double)m4 / (double)out.size();
        }
        this.setGenericValueAnalisys(gva);
    }

    public double getMaxGenericData(DanasDataStructureConstants.ValueType t) {
        return this.GenericValueAnalisys[t.ordinal()][0];
    }

    public double getMinGenericData(DanasDataStructureConstants.ValueType t) {
        return this.GenericValueAnalisys[t.ordinal()][1];
    }

    public double getAvgGenericData(DanasDataStructureConstants.ValueType t) {
        return this.GenericValueAnalisys[t.ordinal()][2];
    }

    public double[][] getGenericValueAnalisys() {
        return this.GenericValueAnalisys;
    }

    public void setGenericValueAnalisys(double[][] GenericValueAnalisys) {
        this.GenericValueAnalisys = GenericValueAnalisys;
    }

    public boolean isGpsPresent() {
        if (this.session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS) == 0.0) {
            return false;
        }
        int indiceFine = this.indexGpsEnd;
        int indiceInizio = this.indexGpsStart;
        return indiceFine > indiceInizio;
    }

    public int getNumPuntiGps() {
        return this.indexGpsEnd - this.indexGpsStart;
    }

    public double getTempoInizioGps() {
        return this.session.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS) + (double)(this.indexGpsStart * 100) / this.session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS);
    }

    public double getTempoFineGps() {
        return this.session.getTempoIniziale(DanasDataStructureConstants.ValueType.VEL_GPS) + (double)(this.indexGpsEnd * 100) / this.session.getFrequenzaCanale(DanasDataStructureConstants.ValueType.VEL_GPS);
    }

    public int getStartIndexGPS() {
        return this.indexGpsStart;
    }

    public int getEndIndexGPS() {
        return this.indexGpsEnd;
    }
}

