/*
 * Decompiled with CFR 0.152.
 */
package i2m.DataStructure.danasDataStructure;

import java.util.Arrays;

public class ArrayDouble
implements Cloneable {
    private final int CHUNK_SIZE = 13107;
    private int size;
    private double[] data;

    public ArrayDouble(int maxSize) {
        if (maxSize <= 0) {
            maxSize = 13107;
        }
        this.data = new double[maxSize];
        this.size = 0;
    }

    public ArrayDouble() {
        this(0);
    }

    public ArrayDouble(ArrayDouble other) {
        this.data = (double[])other.data.clone();
        this.size = other.size;
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void consolidate() {
        if (this.size == this.data.length) {
            return;
        }
        double[] old = this.data;
        this.data = new double[this.size];
        System.arraycopy(old, 0, this.data, 0, this.size);
    }

    public double[] getData() {
        this.consolidate();
        return this.data;
    }

    public void add(double d) {
        if (this.size == this.data.length) {
            double[] old = this.data;
            this.data = new double[old.length + 13107];
            System.arraycopy(old, 0, this.data, 0, old.length);
        }
        this.data[this.size] = d;
        ++this.size;
    }

    public void add(int index, double d) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size == this.data.length) {
            double[] old = this.data;
            this.data = new double[old.length + 13107];
            System.arraycopy(old, 0, this.data, 0, index);
            this.data[index] = d;
            System.arraycopy(old, index, this.data, index + 1, this.size - index);
        } else {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
            this.data[index] = d;
        }
        ++this.size;
    }

    public void remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        double[] old = this.data;
        System.arraycopy(old, index + 1, this.data, index, this.size - index - 1);
        --this.size;
    }

    public double get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public void set(int index, double d) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[index] = d;
    }

    public String toString() {
        double[] tmp = Arrays.copyOf(this.data, this.size);
        return "size=" + this.size + "\n" + Arrays.toString(tmp);
    }
}

