/*
 * Decompiled with CFR 0.152.
 */
package i2m;

import i2m.DanasProperties;
import i2m.DataStructure.danasDataStructure.DanasDataStructure;
import i2m.DataStructure.danasDataStructure.DanasDataStructureConstants;
import i2m.DataStructure.danasUtils.MeasuresUtil;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DanasPreferences {
    private static DanasProperties prefs = new DanasProperties();
    private static DanasProperties prefsTemp = new DanasProperties();
    public static final String OPEN_SETTAGGI = "openSettaggi";
    public static final String SAVE_SETTAGGI = "saveSettaggi";
    public static final String SAVE_ESPORTA = "saveEsporta";
    public static final String OPEN_SESSIONI = "openSessioni";
    public static final String OPEN_VIDEO = "openVideo";
    public static final String OPEN_SETTAGGI_APRI = "openSettaggiOpen";
    public static final String OPEN_DATABASE_APRI = "openDatabaseOpen";
    public static final String OPEN_DAILY_APRI = "openDailyOpen";
    public static final String LIBRERIA_CIRCUITI_IN = "libreriaCircuitiIn";
    public static final String LIBRERIA_CIRCUITI_OUT = "libreriaCircuitiOut";
    public static final String GOAL_DIRECTORY = "stechiodirectory";
    public static final String MAP_DIRECTORY = "mappadirectory";
    public static final String SAVE_MAP_DIRECTORY = "salvamappadirectory";
    public static final String SETTINGS_DIRECTORY = "settingsdirectory";
    public static final String SAVE_MAP_CORRECTION_DIRECTORY = "salvamappacorrezionidirectory";
    public static final String DOWNLOAD_DIRECTORY = "downloaddirectory";
    public static final String DOWNLOADED_FILE_DIRECTORY = "downloadedfiledirectory";
    public static final String IMPORTDDS = "importaFileDds";
    public static final String EXPORTDDS = "esportaFileDds";
    public static int[] valoriFiltri = new int[183];
    public static int[] valoriFiltriAggiuntivi = new int[10];
    public static int[] valoriFiltriTemp = new int[183];
    public static int[] valoriFiltriAggiuntiviTemp = new int[10];
    public static boolean abilitaSalvataggio = true;

    public DanasPreferences() {
        DanasPreferences.cacheValori(1);
    }

    public static void setPrefCanaleBox(int posizione, int canale) {
        String chiave = "CanaleBox" + posizione;
        prefs.putInt(chiave, canale);
    }

    public static int getPrefCanaleBox(int posizione) {
        String chiave = "CanaleBox" + posizione;
        return prefs.getInt(chiave, 0);
    }

    public static void setPosizioneScambioAnalogico(int originale, int nuovo) {
        String chiave = "PosizioneAnalogico" + originale;
        prefs.putInt(chiave, nuovo);
    }

    public static int getPosizioneScambioAnalogico(int originale) {
        String chiave = "PosizioneAnalogico" + originale;
        return prefs.getInt(chiave, originale);
    }

    public static void abilitaSalvataggio(boolean abilita) {
        prefs.abilitaSalvataggio(abilita);
    }

    public static void abilitaSalvataggioTemporaneo(boolean abilita) {
        prefsTemp.abilitaSalvataggio(abilita);
    }

    public static void setPrefTipoChrome(int tipo) {
        prefs.putInt("tipoChrome", tipo);
    }

    public static int getPrefTipoChrome() {
        return prefs.getInt("tipoChrome", 0);
    }

    public static void aggiornaFiltri(int modo) {
        DanasPreferences.cacheValori(modo);
    }

    public static void setPreferenzaTipoDati(int preferenza) {
        prefs.putInt("preferenzaTipoDati", preferenza);
    }

    public static int getPreferenzaTipoDati() {
        return prefs.getInt("preferenzaTipoDati", 0);
    }

    public static void setPuntiCursore(boolean attiva) {
        prefs.putBoolean("puntiSuCursore", attiva);
    }

    public static boolean getPuntiCursore() {
        return prefs.getBoolean("puntiSuCursore", true);
    }

    public static void setScambiaChrome(boolean scambia) {
        prefs.putBoolean("scambiaCanaliChrome", scambia);
    }

    public static boolean getScambiaChrome() {
        return prefs.getBoolean("scambiaCanaliChrome", false);
    }

    public static void setScambiaDatalog(boolean scambia) {
        prefs.putBoolean("scambiaCanaliDatalog", scambia);
    }

    public static boolean getScambiaDatalog() {
        return prefs.getBoolean("scambiaCanaliDatalog", false);
    }

    public static void setTemperaturaCelsius(boolean celsius) {
        prefs.putBoolean("temperaturaCelsius", celsius);
    }

    public static boolean getVelocitakmh() {
        return prefs.getBoolean("velocitakmh", true);
    }

    public static void setVelocitakmh(boolean iskmh) {
        prefs.putBoolean("velocitakmh", iskmh);
    }

    public static boolean getPressioneBar() {
        return prefs.getBoolean("pressionebar", true);
    }

    public static void setPressioneBar(boolean isBar) {
        prefs.putBoolean("pressionebar", isBar);
    }

    public static boolean getTemperaturaCelsius() {
        return prefs.getBoolean("temperaturaCelsius", true);
    }

    public static void setPrefOpacitaAttiva(boolean attiva) {
        prefs.putBoolean("opacitaAttiva", attiva);
    }

    public static boolean getPrefOpacitaAttiva() {
        return prefs.getBoolean("opacitaAttiva", false);
    }

    public static void setPrefSerpentello(boolean attiva) {
        prefs.putBoolean("serpentello", attiva);
    }

    public static boolean getPrefSerpentello() {
        return prefs.getBoolean("serpentello", false);
    }

    public static void setPrefDisabilitaSplitAuto(boolean abilita) {
        prefs.putBoolean("disabilitaSplitAuto", abilita);
    }

    public static boolean getPrefDisabilitaSplitAuto() {
        return prefs.getBoolean("disabilitaSplitAuto", false);
    }

    public static void setPrefFFTLineare(boolean lineare) {
        prefs.putBoolean("fftLineare", lineare);
    }

    public static boolean getPrefFFTLineare() {
        return prefs.getBoolean("fftLineare", true);
    }

    public static void setPrefFFTAmpiezza(boolean ampiezza) {
        prefs.putBoolean("fftAmpiezza", ampiezza);
    }

    public static boolean getPrefFFTAmpiezza() {
        return prefs.getBoolean("fftAmpiezza", true);
    }

    public static int getPrefFFTFinestra() {
        return prefs.getInt("fftFinestra", 0);
    }

    public static void setPrefFFTFinestra(int finestra) {
        prefs.putInt("fftFinestra", finestra);
    }

    public static void setPrefScroll(boolean trasla) {
        prefs.putBoolean("modSCroll", trasla);
    }

    public static boolean getPrefScroll() {
        return prefs.getBoolean("modSCroll", false);
    }

    public static void setPrefInvertiScroll0(boolean trasla) {
        prefs.putBoolean("modInvertiSCroll0", trasla);
    }

    public static boolean getPrefInvertiScroll0() {
        return prefs.getBoolean("modInvertiSCroll0", false);
    }

    public static void setPrefInvertiScroll1(boolean trasla) {
        prefs.putBoolean("modInvertiSCroll1", trasla);
    }

    public static boolean getPrefInvertiScroll1() {
        return prefs.getBoolean("modInvertiSCroll1", false);
    }

    public static void setPrefInterpolazione(boolean abilita) {
        prefs.putBoolean("interpolazioneAttiva", abilita);
    }

    public static boolean getPrefInterpolazione() {
        return prefs.getBoolean("interpolazioneAttiva", false);
    }

    public static void setPrefIstogrammiPieni(boolean pieno) {
        prefs.putBoolean("istogrammiPieni", pieno);
    }

    public static boolean getPrefIstogrammiPieni() {
        return prefs.getBoolean("istogrammiPieni", true);
    }

    public static void setPrefIstogrammiLinee(boolean aLinee) {
        prefs.putBoolean("istogrammiALinee", aLinee);
    }

    public static boolean getPrefIstogrammiLinee() {
        return prefs.getBoolean("istogrammiALinee", false);
    }

    public static void setPrefAutoInfo(boolean auto) {
        prefs.putBoolean("comparasaInfo", auto);
    }

    public static boolean getPrefAutoInfo() {
        return prefs.getBoolean("comparasaInfo", false);
    }

    public static void setStopDialog2Giri(boolean abilita) {
        prefs.putBoolean("dialog2giri", abilita);
    }

    public static boolean getStopDialog2Giri() {
        return prefs.getBoolean("dialog2giri", false);
    }

    public static boolean getTabPrincipaleVisibile() {
        return prefs.getBoolean("tabPrincipale", true);
    }

    public static void setTabPrincipaleVisibile(boolean visibile) {
        prefs.putBoolean("tabPrincipale", visibile);
    }

    public static boolean getTabGraficoVisibile() {
        return prefs.getBoolean("tabGrafico", true);
    }

    public static void setTabGraficoVisibile(boolean visibile) {
        prefs.putBoolean("tabGrafico", visibile);
    }

    public static void setTabMappaVisibile(boolean visibile) {
        prefs.putBoolean("tabMappa", visibile);
    }

    public static boolean getTabMappaVisibile() {
        return prefs.getBoolean("tabMappa", true);
    }

    public static void setPrefConfronto(boolean confronto) {
        prefs.putBoolean("coloriConfronto", confronto);
    }

    public static boolean getPrefConfronto() {
        return prefs.getBoolean("coloriConfronto", true);
    }

    public static void setPrefTestApertura(boolean esegui) {
        prefs.putBoolean("testApertura", esegui);
    }

    public static boolean getPrefTestApertura() {
        return prefs.getBoolean("testApertura", false);
    }

    public static boolean getPrefMostraAllarme() {
        return prefs.getBoolean("mostraAllarme", false);
    }

    public static void setPrefMostraAllarme(boolean esegui) {
        prefs.putBoolean("mostraAllarme", esegui);
    }

    public static void setPrefDebug(boolean debug) {
        prefs.putBoolean("scriviDebug", debug);
    }

    public static boolean getPrefDebug() {
        return prefs.getBoolean("scriviDebug", false);
    }

    public static void setPrefAndAllarmi(boolean and) {
        prefs.putBoolean("andAllarmi", and);
    }

    public static boolean getPrefAndAllarmi() {
        return prefs.getBoolean("andAllarmi", false);
    }

    public static void setPrefSaveDownload(boolean save) {
        prefs.putBoolean("saveDownload", save);
    }

    public static boolean getPrefSaveDownload() {
        return prefs.getBoolean("saveDownload", false);
    }

    public static void setPrefAllarmeAcqua(int valore) {
        prefs.putInt("valoreAllarmeAcqua", valore);
    }

    public static int getPrefAllarmeAcqua() {
        return prefs.getInt("valoreAllarmeAcqua", 110);
    }

    public static void setPrefAllarmeBatteria(float valore) {
        prefs.putFloat("valoreAllarmeBatteria", valore);
    }

    public static float getPrefAllarmeBatteria() {
        return prefs.getFloat("valoreAllarmeBatteria", 13.0f);
    }

    public static void setPrefversoAllarme(int allarme, int verso) {
        if (verso > 1 || verso < 0) {
            verso = 0;
        }
        String chiave = "versoAllarme" + allarme;
        prefs.putInt(chiave, verso);
    }

    public static int getTempoAllarme() {
        return prefs.getInt("tempoAllarme", 0);
    }

    public static void setTempoAllarme(int tempo) {
        if (tempo < 0) {
            tempo = 0;
        }
        prefs.putInt("tempoAllarme", tempo);
    }

    public static int getPrefVersoAllarme(int allarme) {
        String chiave = "versoAllarme" + allarme;
        return prefs.getInt(chiave, 0);
    }

    public static int getPrefRuotaMappa() {
        return prefs.getInt("ruotamapppa", 0);
    }

    public static void setRuotaMappa(int angolo) {
        prefs.putInt("ruotamapppa", angolo);
    }

    public static void setOpacitaMappa(int opacita) {
        prefs.putInt("opacitaMappa", opacita);
    }

    public static int getOpacitaMappa() {
        return prefs.getInt("opacitaMappa", 100);
    }

    public static void setPrefCanaleAllarme(int allarme, int canale) {
        String chiave = "canaleAllarme" + allarme;
        prefs.putInt(chiave, canale);
    }

    public static int getPrefCanaleAllarme(int allarme) {
        String chiave = "canaleAllarme" + allarme;
        return prefs.getInt(chiave, 0);
    }

    public static void setPrefValoreAllarme(int allarme, float valore) {
        String chiave = "valoreAllarme" + allarme;
        prefs.putFloat(chiave, valore);
    }

    public static int getPrefShortcut(int parametro, int canale) {
        String chiave = "valoreShortCut" + parametro + "-" + canale;
        return prefs.getInt(chiave, 0);
    }

    public static void setPrefShortcut(int parametro, int canale, int valore) {
        String chiave = "valoreShortCut" + parametro + "-" + canale;
        prefs.putInt(chiave, valore);
    }

    public static void setPrefShortCutDefault(boolean def) {
        prefs.putBoolean("shortCutDefault0", def);
    }

    public static boolean getPrefShortCutDefault() {
        return prefs.getBoolean("shortCutDefault0", true);
    }

    public static void setPrefNomeSimOld(int indice, String nome) {
        String chiave = "nomeSimOld" + indice;
        prefs.put(chiave, nome);
    }

    public static String getPrefNomeSimOld(int indice) {
        String chiave = "nomeSimOld" + indice;
        String key = prefs.get(chiave, "Moto-" + indice);
        return key;
    }

    public static void setPrefNomeSimNew(int indice, String nome) {
        String chiave = "nomeSimNew" + indice;
        prefs.put(chiave, nome);
    }

    public static String getPrefNomeSimNew(int indice) {
        String chiave = "nomeSimNew" + indice;
        String key = prefs.get(chiave, "New-" + indice);
        return key;
    }

    public static void setPrefShortKey(int canale, String nome) {
        String chiave = "nomeShortKey" + canale;
        prefs.put(chiave, nome);
    }

    public static String getApiKey() {
        String key = prefs.get("googleAPIKey", "");
        return key;
    }

    public static void setApiKey(String nome) {
        prefs.put("googleAPIKey", nome);
    }

    public static String getPrefShortKey(int canaale) {
        String chiave = "nomeShortKey" + canaale;
        return prefs.get(chiave, "");
    }

    public static float getPrefValoreAllarme(int allarme) {
        String chiave = "valoreAllarme" + allarme;
        return prefs.getFloat(chiave, 0.0f);
    }

    public static void setPrefNomeAllarme(int allarme, String nome) {
        String chiave = "nomeAllarme" + allarme;
        prefs.put(chiave, nome);
    }

    public static String getPrefNomeAllarme(int allarme) {
        String chiave = "nomeAllarme" + allarme;
        return prefs.get(chiave, "alarm" + allarme);
    }

    public static void setPrefPosizioneCanale(int indice, int valore, int modo) {
        String chiave = "posizioneCanale" + indice + "-" + modo;
        prefs.putInt(chiave, valore);
    }

    public static void setPrefPosizioneCanale(int indice, int valore, int modo, DanasProperties prefMode) {
        String chiave = "posizioneCanale" + indice + "-" + modo;
        prefMode.putInt(chiave, valore);
    }

    public static int getPrefPosizioneCanale(int indice, int modo, DanasProperties prefMode) {
        String chiave = "posizioneCanale" + indice + "-" + modo;
        return prefMode.getInt(chiave, indice);
    }

    public static String getFormulaMath(int index, boolean defaultValue) {
        int modo = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
        if (DanasPreferences.getConfigurazioneMathCorrente(modo) == 0 || defaultValue) {
            String chiave = "formulaMath" + index;
            return prefs.get(chiave, "0");
        }
        return DanasPreferences.getFunzioneMath(DanasPreferences.getConfigurazioneMathCorrente(modo), index);
    }

    public static void setFormulaMath(int index, String s) {
        int modo = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
        if (DanasPreferences.getConfigurazioneMathCorrente(modo) == 0) {
            String chiave = "formulaMath" + index;
            prefs.put(chiave, s);
        } else {
            DanasPreferences.setFunzioneMath(DanasPreferences.getConfigurazioneMathCorrente(modo), s, index);
        }
    }

    public static void setFunzioneMath(int elenco, String s, int indice) {
        String chiave = "funzioneMath" + elenco + "-" + indice;
        prefs.put(chiave, s);
    }

    public static String getFunzioneMath(int elenco, int indice) {
        String chiave = "funzioneMath" + elenco + "-" + indice;
        return prefs.get(chiave, "0");
    }

    public static String getNomeMath(int index, boolean defaultValue) {
        int modo = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
        String chiave = DanasPreferences.getConfigurazioneMathCorrente(modo) == 0 || defaultValue ? "NomeMath" + index : "NomeMath" + index + "-" + DanasPreferences.getConfigurazioneMathCorrente(modo);
        return prefs.get(chiave, "Math" + (index + 1));
    }

    public static void setNomeMath(int index, String s) {
        int modo = DanasDataStructure.getInstance().getMainFrame().getModoAttuale();
        String chiave = DanasPreferences.getConfigurazioneMathCorrente(modo) == 0 ? "NomeMath" + index : "NomeMath" + index + "-" + DanasPreferences.getConfigurazioneMathCorrente(modo);
        prefs.put(chiave, s);
    }

    public static String getOpzioniNomeXY(int modo) {
        String chiave = "opzioneNomeXY" + modo;
        return prefs.get(chiave, "modo" + (modo + 1));
    }

    public static void setOpzioniNomeXY(int modo, String s) {
        String chiave = "opzioneNomeXY" + modo;
        prefs.put(chiave, s);
    }

    public static boolean getOpzioniCheckXY(int numeroBox, int modo) {
        String chiave = modo < 10 ? "opzioneCheckXY" + modo + numeroBox : "opzioneCheckXY" + modo + "-" + numeroBox;
        if (numeroBox == 1 || numeroBox == 2 || numeroBox == 6 || numeroBox == 7 || numeroBox == 8) {
            return prefs.getBoolean(chiave, true);
        }
        return prefs.getBoolean(chiave, false);
    }

    public static String getOpzioniNomeIstogramma(int modo) {
        String chiave = "opzioneNomeIstogramma" + modo;
        return prefs.get(chiave, "modo" + (modo + 1));
    }

    public static void setOpzioniNomeIstogramma(int modo, String s) {
        String chiave = "opzioneNomeIstogramma" + modo;
        prefs.put(chiave, s);
    }

    public static boolean getOpzioniCheckIstogramma(int numeroBox, int modo) {
        String chiave = modo < 10 ? "opzioneCheckIstogramma" + modo + numeroBox : "opzioneCheckIstogramma" + modo + "-" + numeroBox;
        if (numeroBox == 1 || numeroBox == 2 || numeroBox == 6 || numeroBox == 7 || numeroBox == 8) {
            return prefs.getBoolean(chiave, true);
        }
        return prefs.getBoolean(chiave, false);
    }

    public static int getOpzioniCanaleXY(int numeroCanale, int modo) {
        String chiave = modo < 10 ? "opzioneCanaleXY" + modo + numeroCanale : "opzioneCanaleXY" + modo + "-" + numeroCanale;
        if (numeroCanale == 4) {
            return prefs.getInt(chiave, 3);
        }
        return prefs.getInt(chiave, 0);
    }

    public static int getOpzioniCanaleIstogramma(int numeroCanale, int modo) {
        String chiave = modo < 10 ? "opzioneCanaleIstogramma" + modo + numeroCanale : "opzioneCanaleIstogramma" + modo + "-" + numeroCanale;
        if (numeroCanale == 4) {
            return prefs.getInt(chiave, 3);
        }
        return prefs.getInt(chiave, 0);
    }

    public static String getOpzioniMinimiXY(int numeroCanale, int modo) {
        String chiave = modo < 10 ? "opzioneMinimiXY" + modo + numeroCanale : "opzioneMinimiXY" + modo + "-" + numeroCanale;
        return prefs.get(chiave, "0");
    }

    public static String getOpzioniMassimiXY(int numeroCanale, int modo) {
        String chiave = modo < 10 ? "opzioneMassimiXY" + modo + numeroCanale : "opzioneMassimiXY" + modo + "-" + numeroCanale;
        return prefs.get(chiave, "100");
    }

    public static String getOpzioniMinimiIstogramma(int numeroCanale, int modo) {
        String chiave = modo < 10 ? "opzioneMinimiIstogramma" + modo + numeroCanale : "opzioneMinimiIstogramma" + modo + "-" + numeroCanale;
        return prefs.get(chiave, "0");
    }

    public static String getOpzioniMassimiIstogramma(int numeroCanale, int modo) {
        String chiave = modo < 10 ? "opzioneMassimiIstogramma" + modo + numeroCanale : "opzioneMassimiIstogramma" + modo + "-" + numeroCanale;
        return prefs.get(chiave, "100");
    }

    public static String getOpzioniStepIstogramma(int modo) {
        String chiave = "opzioneStepIstogramma" + modo;
        return prefs.get(chiave, "40");
    }

    public static void setPrefColoreSfonfdoXY(int modo, int rgb) {
        String chiave = "coloreSfondoXY" + modo;
        prefs.putInt(chiave, rgb);
    }

    public static void setPrefColoreConfronto(int giro, int rgb) {
        String chiave = "coloreConfronto" + giro;
        prefs.putInt(chiave, rgb);
    }

    public static void setPrefColoreSfonfdoIstogramma(int modo, int rgb) {
        String chiave = "coloreSfondoIstogramma" + modo;
        prefs.putInt(chiave, rgb);
    }

    public static void setPrefColoreIstogramma(int modo, int rgb) {
        String chiave = "coloreIstogramma" + modo;
        prefs.putInt(chiave, rgb);
    }

    public static void setOpzioniCheckXY(int numeroBox, int modo, boolean selected) {
        String chiave = modo < 10 ? "opzioneCheckXY" + modo + numeroBox : "opzioneCheckXY" + modo + "-" + numeroBox;
        prefs.putBoolean(chiave, selected);
    }

    public static void setOpzioniCheckIstogramma(int numeroBox, int modo, boolean selected) {
        String chiave = modo < 10 ? "opzioneCheckIstogramma" + modo + numeroBox : "opzioneCheckIstogramma" + modo + "-" + numeroBox;
        prefs.putBoolean(chiave, selected);
    }

    public static void setOpzioniCanaleXY(int numeroCanale, int modo, int index) {
        String chiave = modo < 10 ? "opzioneCanaleXY" + modo + numeroCanale : "opzioneCanaleXY" + modo + "-" + numeroCanale;
        prefs.putInt(chiave, index);
    }

    public static void setOpzioniCanaleIstogramma(int numeroCanale, int modo, int index) {
        String chiave = modo < 10 ? "opzioneCanaleIstogramma" + modo + numeroCanale : "opzioneCanaleIstogramma" + modo + "-" + numeroCanale;
        prefs.putInt(chiave, index);
    }

    public static void setOpzioniMinimiXY(int numeroCanale, int modo, String min) {
        String chiave = modo < 10 ? "opzioneMinimiXY" + modo + numeroCanale : "opzioneMinimiXY" + modo + "-" + numeroCanale;
        prefs.put(chiave, min);
    }

    public static void setOpzioniMassimiXY(int numeroCanale, int modo, String s) {
        String chiave = modo < 10 ? "opzioneMassimiXY" + modo + numeroCanale : "opzioneMassimiXY" + modo + "-" + numeroCanale;
        prefs.put(chiave, s);
    }

    public static void setOpzioniMinimiIstogramma(int numeroCanale, int modo, String min) {
        String chiave = modo < 10 ? "opzioneMinimiIstogramma" + modo + numeroCanale : "opzioneMinimiIstogramma" + modo + "-" + numeroCanale;
        prefs.put(chiave, min);
    }

    public static void setOpzioniMassimiIstogramma(int numeroCanale, int modo, String s) {
        String chiave = modo < 10 ? "opzioneMassimiIstogramma" + modo + numeroCanale : "opzioneMassimiIstogramma" + modo + "-" + numeroCanale;
        prefs.put(chiave, s);
    }

    public static void setOpzioniStepIstogramma(int modo, String s) {
        String chiave = "opzioneStepIstogramma" + modo;
        prefs.put(chiave, s);
    }

    public static void setRiassuntoIstogrammi(int modo, String s) {
        String chiave = "riassuntoIstogrammi" + modo;
        prefs.put(chiave, s);
    }

    public static void setRiassuntoIstogrammi(int modo, String s, DanasProperties prefMode) {
        String chiave = "riassuntoIstogrammi" + modo;
        prefMode.put(chiave, s);
    }

    public static String getRiassuntoIstogrammi(int modo) {
        String chiave = "riassuntoIstogrammi" + modo;
        return prefs.get(chiave, null);
    }

    public static String getRiassuntoIstogrammi(int modo, DanasProperties prefMode) {
        String chiave = "riassuntoIstogrammi" + modo;
        return prefMode.get(chiave, null);
    }

    public static void setIstogrammiPreconfigurati(int indice, String s) {
        String chiave = "istogrammiPreconfigurati" + indice;
        prefs.put(chiave, s);
    }

    public static String getIstogrammiPreconfigurati(int indice) {
        String chiave = "istogrammiPreconfigurati" + indice;
        return prefs.get(chiave, null);
    }

    public static void setConfigurazioneMathCorrente(int configurazione, int modo) {
        prefs.putInt("configurazioneCorrente" + modo, configurazione);
    }

    public static int getConfigurazioneMathCorrente(int modo) {
        return prefs.getInt("configurazioneCorrente" + modo, 0);
    }

    public static void setNomeSetIstogrammi(int modo, String s) {
        String chiave = "nomeSetIstogrammi" + modo;
        prefs.put(chiave, s);
    }

    public static String getNomeSetIstogrammi(int modo) {
        String chiave = "nomeSetIstogrammi" + modo;
        return prefs.get(chiave, "-----");
    }

    public static void setNomeSetMath(int indice, String s) {
        String chiave = "nomeSetMath" + indice;
        prefs.put(chiave, s);
    }

    public static String getNomeSetMath(int indice) {
        String chiave = "nomeSetMath" + indice;
        return prefs.get(chiave, "-----");
    }

    public static int getPrefColoreConfronto(int giro) {
        String chiave = "coloreConfronto" + giro;
        switch (giro) {
            case 1: {
                return prefs.getInt(chiave, Color.white.getRGB());
            }
            case 2: {
                return prefs.getInt(chiave, Color.green.getRGB());
            }
            case 3: {
                return prefs.getInt(chiave, Color.yellow.getRGB());
            }
            case 4: {
                return prefs.getInt(chiave, Color.red.getRGB());
            }
            case 5: {
                return prefs.getInt(chiave, Color.blue.getRGB());
            }
        }
        return prefs.getInt(chiave, Color.white.getRGB());
    }

    public static int getPrefColoreSfonfdoXY(int modo) {
        String chiave = "coloreSfondoXY" + modo;
        return prefs.getInt(chiave, Color.BLACK.getRGB());
    }

    public static int getPrefColoreSfonfdoIstogramma(int modo) {
        String chiave = "coloreSfondoIstogramma" + modo;
        return prefs.getInt(chiave, Color.BLACK.getRGB());
    }

    public static int getPrefColoreIstogramma(int modo) {
        String chiave = "coloreIstogramma" + modo;
        return prefs.getInt(chiave, Color.red.getRGB());
    }

    public static void setPrefCaratteremappaSize(int size) {
        prefs.putInt("dimensioneCarattereMappa", size);
    }

    public static int getCanaleTpsSimulazione() {
        return prefs.getInt("tpsSimulato", 0);
    }

    public static void setCanateTpsSimulato(int numero) {
        int valore = numero;
        if (valore < 0) {
            valore = 0;
        }
        if (valore > 7) {
            valore = 7;
        }
        prefs.putInt("tpsSimulato", valore);
    }

    public static int getCanaleMarceSimulazione() {
        return prefs.getInt("marceSimulato", 0);
    }

    public static void setCanateMarceSimulato(int numero) {
        int valore = numero;
        if (valore < 0) {
            valore = 0;
        }
        if (valore > 1) {
            valore = 1;
        }
        prefs.putInt("marceSimulato", valore);
    }

    public static int getPrefCaratteremappaSize() {
        return prefs.getInt("dimensioneCarattereMappa", 14);
    }

    public static void setPrefSpessoreLineaMappa(int size) {
        prefs.putInt("dimensioneLineaMappa", size);
    }

    public static int getRitardoVideo() {
        return prefs.getInt("ritardoVideo", 0);
    }

    public static void setRitardoVideo(int ritardo) {
        prefs.putInt("ritardoVideo", ritardo);
    }

    public static int getRitardoVideoCompare() {
        return prefs.getInt("ritardoVideoCompare", 0);
    }

    public static void setRitardoVideoCompare(int ritardo) {
        prefs.putInt("ritardoVideoCompare", ritardo);
    }

    public static int getPosizioneChannelsY() {
        return prefs.getInt("ChannelsY", 0);
    }

    public static int getPosizioneChannelsX() {
        return prefs.getInt("ChannelsX", 0);
    }

    public static void setPosizioneChannelsY(int posizione) {
        prefs.putInt("ChannelsY", posizione);
    }

    public static void setPosizioneChannelsX(int posizione) {
        prefs.putInt("ChannelsX", posizione);
    }

    public static int getLarghezzaChannels() {
        return prefs.getInt("ChannelsLarghezza", 0);
    }

    public static int getLunghezzaChannels() {
        return prefs.getInt("ChannelsLunghezza", 0);
    }

    public static void setLarghezzaChannels(int larghezza) {
        prefs.putInt("ChannelsLarghezza", larghezza);
    }

    public static void setLunghezzaChannels(int lunghezza) {
        prefs.putInt("ChannelsLunghezza", lunghezza);
    }

    public static int getPosizioneXXY() {
        return prefs.getInt("XXY", 0);
    }

    public static void setPosizioneXXY(int posizione) {
        prefs.putInt("XXY", posizione);
    }

    public static int getPosizioneWifiY() {
        return prefs.getInt("wifiY", 0);
    }

    public static void setPosizioneWifiY(int posizione) {
        prefs.putInt("wifiY", posizione);
    }

    public static int getPosizioneWifiX() {
        return prefs.getInt("wifiX", 0);
    }

    public static void setPosizioneWifiX(int posizione) {
        prefs.putInt("wifiX", posizione);
    }

    public static boolean getWifiVisibile() {
        return prefs.getBoolean("wifiVisibile", false);
    }

    public static void setWifiVisibile(boolean visibile) {
        prefs.putBoolean("wifiVisibile", visibile);
    }

    public static int getPosizioneYXY() {
        return prefs.getInt("YXY", 0);
    }

    public static void setPosizioneYXY(int posizione) {
        prefs.putInt("YXY", posizione);
    }

    public static int getlLarghezzaXY() {
        return prefs.getInt("larghezzaXY", 650);
    }

    public static void setLarghezzaXY(int larghezza) {
        prefs.putInt("larghezzaXY", larghezza);
    }

    public static int getAltezzaXY() {
        return prefs.getInt("altezzaXY", 650);
    }

    public static void setAltezzaXY(int altezza) {
        prefs.putInt("altezzaXY", altezza);
    }

    public static int getlLarghezzaWifi() {
        return prefs.getInt("larghezzaWifi", 650);
    }

    public static void setLarghezzaWifi(int larghezza) {
        prefs.putInt("larghezzaWifi", larghezza);
    }

    public static int getAltezzaWifi() {
        return prefs.getInt("altezzaWifi", 350);
    }

    public static void setAltezzaWifi(int altezza) {
        prefs.putInt("altezzaWifi", altezza);
    }

    public static void setPrefXyVisibile(boolean visibile, int modo, DanasProperties prefMode) {
        String chiave = "graficoXyVisibile" + modo;
        prefMode.putBoolean(chiave, visibile);
    }

    public static void setPrefXyVisibile(boolean visibile, int modo) {
        String chiave = "graficoXyVisibile" + modo;
        prefs.putBoolean(chiave, visibile);
    }

    public static boolean getPrefXyVisibile(int modo) {
        String chiave = "graficoXyVisibile" + modo;
        return prefs.getBoolean(chiave, false);
    }

    public static boolean getPrefXyVisibile(int modo, DanasProperties prefMode) {
        String chiave = "graficoXyVisibile" + modo;
        return prefMode.getBoolean(chiave, false);
    }

    public static void setPrefModoXy(int modoXy, int modo) {
        String chiave = "modoGraficoXy" + modo;
        prefs.putInt(chiave, modoXy);
    }

    public static void setPrefModoXy(int modoXy, int modo, DanasProperties prefMode) {
        String chiave = "modoGraficoXy" + modo;
        prefMode.putInt(chiave, modoXy);
    }

    public static int getPrefModoXy(int modo) {
        String chiave = "modoGraficoXy" + modo;
        return prefs.getInt(chiave, 1);
    }

    public static int getPrefModoXy(int modo, DanasProperties prefMode) {
        String chiave = "modoGraficoXy" + modo;
        return prefMode.getInt(chiave, 1);
    }

    public static int getPosizioneMappaX() {
        return prefs.getInt("mappaX", 500);
    }

    public static void setPosizioneMappaX(int posizione) {
        prefs.putInt("mappaX", posizione);
    }

    public static int getUltimoDevice() {
        return prefs.getInt("ultimoDevice", 0);
    }

    public static void setUltimoDevice(int index) {
        prefs.putInt("ultimoDevice", index);
    }

    public static int getPosizioneMappaY() {
        return prefs.getInt("mappaY", 520);
    }

    public static void setPosizioneMappaY(int posizione) {
        prefs.putInt("mappaY", posizione);
    }

    public static int getlLarghezzaMappa() {
        return prefs.getInt("mappaW", 300);
    }

    public static void setLarghezzaMappa(int larghezza) {
        prefs.putInt("mappaW", larghezza);
    }

    public static int getAltezzaMappa() {
        return prefs.getInt("mappaH", 300);
    }

    public static void setAltezzaMappa(int altezza) {
        prefs.putInt("mappaH", altezza);
    }

    public static int getPosizioneTabellaX() {
        return prefs.getInt("tabellaX", 0);
    }

    public static void setPosizioneTabellaX(int posizione) {
        prefs.putInt("tabellaX", posizione);
    }

    public static int getPosizioneTabellaY() {
        return prefs.getInt("tabellaY", 200);
    }

    public static void setPosizioneTabellaY(int posizione) {
        prefs.putInt("tabellaY", posizione);
    }

    public static int getlLarghezzaTabella() {
        return prefs.getInt("tabellaW", 1280);
    }

    public static void setLarghezzaTabella(int larghezza) {
        prefs.putInt("tabellaW", larghezza);
    }

    public static int getAltezzaTabella() {
        return prefs.getInt("tabellaH", 300);
    }

    public static void setAltezzaTabella(int altezza) {
        prefs.putInt("tabellaH", altezza);
    }

    public static int getPosizioneDettagliX() {
        return prefs.getInt("dettagliX", 0);
    }

    public static void setPosizioneDettagliX(int posizione) {
        prefs.putInt("dettagliX", posizione);
    }

    public static int getPosizioneDettagliY() {
        return prefs.getInt("DettagliY", 0);
    }

    public static void setPosizioneDettagliY(int posizione) {
        prefs.putInt("DettagliY", posizione);
    }

    public static int getPosizioneStechioX() {
        return prefs.getInt("stechioX", 0);
    }

    public static void setPosizioneStechioX(int posizione) {
        prefs.putInt("stechioX", posizione);
    }

    public static int getPosizioneStechioY() {
        return prefs.getInt("stechioY", 0);
    }

    public static void setPosizioneStechioY(int posizione) {
        prefs.putInt("stechioY", posizione);
    }

    public static int getPosizioneInfoX() {
        return prefs.getInt("infoX", 0);
    }

    public static void setPosizioneInfoX(int posizione) {
        prefs.putInt("infoX", posizione);
    }

    public static int getPosizioneInfoY() {
        return prefs.getInt("infoY", 0);
    }

    public static void setPosizioneInfoY(int posizione) {
        prefs.putInt("infoY", posizione);
    }

    public static int getPosizioneInfoSX() {
        return prefs.getInt("infoSX", 0);
    }

    public static void setPosizioneInfoSX(int posizione) {
        prefs.putInt("infoSX", posizione);
    }

    public static int getPosizioneInfoSY() {
        return prefs.getInt("infoSY", 0);
    }

    public static void setPosizioneInfoSY(int posizione) {
        prefs.putInt("infoSY", posizione);
    }

    public static int getPosizioneStatX() {
        return prefs.getInt("statX", 0);
    }

    public static void setPosizioneStatX(int posizione) {
        prefs.putInt("statX", posizione);
    }

    public static int getPosizioneStatY() {
        return prefs.getInt("statY", 0);
    }

    public static void setPosizioneStatY(int posizione) {
        prefs.putInt("statY", posizione);
    }

    public static void setOpzioneStechio(int numeroCombo, int selezionato) {
        String chiave = "stechio" + numeroCombo;
        prefs.putInt(chiave, selezionato);
    }

    public static int getOpzioneStechio(int numeroCombo) {
        String chiave = "stechio" + numeroCombo;
        return prefs.getInt(chiave, 0);
    }

    public static void setOpzioneSfondo(int modo, int rgb) {
        String chiave = "sfondo" + modo;
        prefs.putInt(chiave, rgb);
    }

    public static void setOpzioneSfondo(int modo, int rgb, DanasProperties prefMode) {
        String chiave = "sfondo" + modo;
        prefMode.putInt(chiave, rgb);
    }

    public static boolean getOpzioneCampionatura(int modo, DanasProperties prefMode) {
        String chiave = "decima" + modo;
        return prefMode.getBoolean(chiave, true);
    }

    public static boolean getOpzioneCampionatura(int modo) {
        String chiave = "decima" + modo;
        return prefs.getBoolean(chiave, true);
    }

    public static boolean getOpzioneColoreConfronto() {
        return prefs.getBoolean("confrontoAttivo", false);
    }

    public static void setOpzioneColoreConfronto(boolean attiva) {
        prefs.putBoolean("confrontoAttivo", attiva);
    }

    public static void setOpzioneCampionatura(int modo, boolean decima) {
        String chiave = "decima" + modo;
        prefs.putBoolean(chiave, decima);
    }

    public static void setOpzioneCampionatura(int modo, boolean decima, DanasProperties prefMode) {
        String chiave = "decima" + modo;
        prefMode.putBoolean(chiave, decima);
    }

    public static void setOpzioneApriPrima(boolean aggiorna) {
        prefs.putBoolean("opzioneApriPrima", aggiorna);
    }

    public static boolean getOpzioneApriPrima() {
        return prefs.getBoolean("opzioneApriPrima", true);
    }

    public static void setOpzioneApriUltima(boolean aggiorna) {
        prefs.putBoolean("opzioneApriUltima", aggiorna);
    }

    public static boolean getOpzioneApriUltima() {
        return prefs.getBoolean("opzioneApriUltima", false);
    }

    public static void setOpzioneApriBest(boolean aggiorna) {
        prefs.putBoolean("opzioneApriBest", aggiorna);
    }

    public static boolean getOpzioneApriBest() {
        return prefs.getBoolean("opzioneApriBest", false);
    }

    public static void setOpzioneAggiornaViewer(boolean aggiorna) {
        prefs.putBoolean("aggiornaViewerSempre", aggiorna);
    }

    public static boolean getOpzioneAggiornaViewer() {
        return prefs.getBoolean("aggiornaViewerSempre", false);
    }

    public static int getOpzioneSfondo(int modo) {
        String chiave = "sfondo" + modo;
        return prefs.getInt(chiave, 0);
    }

    public static int getOpzioneSfondo(int modo, DanasProperties prefMode) {
        String chiave = "sfondo" + modo;
        return prefMode.getInt(chiave, 0);
    }

    public static void setOpzioniGrafico(int colonna, int canale, int modo, boolean selezionato) {
        String chiave = modo < 10 ? "opzione" + modo + canale + colonna : "opzione" + modo + "-" + canale + "-" + colonna;
        prefs.putBoolean(chiave, selezionato);
    }

    public static void setOpzioniGraficoTemporaneo(int colonna, int canale, int modo, boolean selezionato) {
        String chiave = modo < 10 ? "opzione" + modo + canale + colonna : "opzione" + modo + "-" + canale + "-" + colonna;
        prefsTemp.putBoolean(chiave, selezionato);
    }

    public static boolean getPreferenzaSimulazione(int modo) {
        String chiave = "preferenzaSimulazione" + modo;
        return prefs.getBoolean(chiave, false);
    }

    public static boolean getPreferenzaSimulazione(int modo, DanasProperties prefMode) {
        String chiave = "preferenzaSimulazione" + modo;
        return prefMode.getBoolean(chiave, false);
    }

    public static void setPreferenzaSimulazione(boolean attiva, int modo) {
        String chiave = "preferenzaSimulazione" + modo;
        prefs.putBoolean(chiave, attiva);
    }

    public static void setPreferenzaSimulazione(boolean attiva, int modo, DanasProperties prefMode) {
        String chiave = "preferenzaSimulazione" + modo;
        prefMode.putBoolean(chiave, attiva);
    }

    public static int getOpzioneTipoSettaggi() {
        return prefs.getInt("opzione_tipo_settaggi", 0);
    }

    public static boolean getOpzioneSettaggi() {
        return prefs.getBoolean("opzione_apertura_settaggi", false);
    }

    public static boolean getInfoFuori() {
        return prefs.getBoolean("finestraInfoFuori", false);
    }

    public static boolean getStatFuori() {
        return prefs.getBoolean("finestraStatFuori", false);
    }

    public static boolean getInfoVisibile() {
        return prefs.getBoolean("finestraInfoVisibile", true);
    }

    public static void setInfoVisibile(boolean visibile) {
        prefs.putBoolean("finestraInfoVisibile", visibile);
    }

    public static void setInfoFuori(boolean fuori) {
        prefs.putBoolean("finestraInfoFuori", fuori);
    }

    public static void setStatFuori(boolean fuori) {
        prefs.putBoolean("finestraStatFuori", fuori);
    }

    public static boolean getInfoSVisibile() {
        return prefs.getBoolean("finestraInfoSVisibile", false);
    }

    public static void setInfoSVisibile(boolean visibile) {
        prefs.putBoolean("finestraInfoSVisibile", visibile);
    }

    public static boolean getPrecalcola() {
        return prefs.getBoolean("precalcolaMatematici", false);
    }

    public static void setPrecalcola(boolean precalcola) {
        prefs.putBoolean("precalcolaMatematici", precalcola);
    }

    public static void setVerificaAutomatica(boolean auto) {
        prefs.putBoolean("verificaAutomatica", auto);
    }

    public static boolean getVerificaAutomatica() {
        return prefs.getBoolean("verificaAutomatica", false);
    }

    public static boolean getStatVisibile() {
        return prefs.getBoolean("finestraStatSVisibile", true);
    }

    public static void setStatVisibile(boolean visibile) {
        prefs.putBoolean("finestraStatSVisibile", visibile);
    }

    public static void setOpzioneSettaggi(boolean selezionato) {
        prefs.putBoolean("opzione_apertura_settaggi", selezionato);
    }

    public static void setOpzioneTipoSettaggi(int tipo) {
        prefs.putInt("opzione_tipo_settaggi", tipo);
    }

    public static boolean getOpzioniGrafico(int colonna, int canale, int modo) {
        String chiave = modo < 10 ? "opzione" + modo + canale + colonna : "opzione" + modo + "-" + canale + "-" + colonna;
        return prefs.getBoolean(chiave, false);
    }

    public static boolean getOpzioniGraficoTemporaneo(int colonna, int canale, int modo) {
        String chiave = modo < 10 ? "opzione" + modo + canale + colonna : "opzione" + modo + "-" + canale + "-" + colonna;
        return prefsTemp.getBoolean(chiave, false);
    }

    public static void setOpzioniComboGrafico(int colonna, int canale, int modo, int valore) {
        String chiave = modo < 10 ? "2opzione" + modo + canale + colonna : "2opzione" + modo + "-" + canale + "-" + colonna;
        prefs.putInt(chiave, valore);
    }

    public static void setOpzioniComboGraficoTemporaneo(int colonna, int canale, int modo, int valore) {
        String chiave = modo < 10 ? "2opzione" + modo + canale + colonna : "2opzione" + modo + "-" + canale + "-" + colonna;
        prefsTemp.putInt(chiave, valore);
    }

    public static int getOpzioniComboGrafico(int colonna, int canale, int modo) {
        String chiave = modo < 10 ? "2opzione" + modo + canale + colonna : "2opzione" + modo + "-" + canale + "-" + colonna;
        if (colonna == 7) {
            return prefs.getInt(chiave, -1);
        }
        return prefs.getInt(chiave, 0);
    }

    public static int getOpzioniComboGraficoTemporaneo(int colonna, int canale, int modo) {
        String chiave = modo < 10 ? "2opzione" + modo + canale + colonna : "2opzione" + modo + "-" + canale + "-" + colonna;
        if (colonna == 7) {
            return prefsTemp.getInt(chiave, -1);
        }
        return prefsTemp.getInt(chiave, 0);
    }

    public static void setOpzioniAssiGrafico(int colonna, int canale, int modo, double valore) {
        String chiave = modo < 10 ? "AssiOpzione" + modo + canale + colonna : "AssiOpzione" + modo + "-" + canale + "-" + colonna;
        prefs.putDouble(chiave, valore);
    }

    public static void setOpzioniAssiGraficoTemporaneo(int colonna, int canale, int modo, double valore) {
        String chiave = modo < 10 ? "AssiOpzione" + modo + canale + colonna : "AssiOpzione" + modo + "-" + canale + "-" + colonna;
        prefsTemp.putDouble(chiave, valore);
    }

    public static void setMathModo(int modo, int numero, String formula) {
        String chiave = "MathModo" + modo + "-" + numero;
        prefs.put(chiave, formula);
    }

    public static String getModoName(int modo) {
        String chiave = "ModoName" + modo;
        return prefs.get(chiave, "Modo" + modo);
    }

    public static void setModoName(int modo, String nome) {
        String chiave = "ModoName" + modo;
        prefs.put(chiave, nome);
    }

    public static String getMathName(int modo, int numero, DanasProperties prefMode) {
        String chiave = "MathName" + modo + "-" + numero;
        if (numero == 1) {
            return prefMode.get(chiave, "Math1");
        }
        return prefMode.get(chiave, "Math2");
    }

    public static String getMathName(int modo, int numero) {
        String chiave = "MathName" + modo + "-" + numero;
        if (numero == 1) {
            return prefs.get(chiave, "Math1");
        }
        return prefs.get(chiave, "Math2");
    }

    public static void setMathName(int modo, int numero, String nome) {
        String chiave = "MathName" + modo + "-" + numero;
        prefs.put(chiave, nome);
    }

    public static void setMathName(int modo, int numero, String nome, DanasProperties prefMode) {
        String chiave = "MathName" + modo + "-" + numero;
        prefMode.put(chiave, nome);
    }

    public static double getMinTempAnt() {
        return prefs.getDouble("minTempAnt", 50.0);
    }

    public static double getMinTempPost() {
        return prefs.getDouble("minTempPost", 40.0);
    }

    public static double getMaxTempAnt() {
        return prefs.getDouble("maxTempAnt", 100.0);
    }

    public static double getMaxTempPost() {
        return prefs.getDouble("maxTempPost", 110.0);
    }

    public static double getMinPressAnt() {
        return prefs.getDouble("minPressAnt", 1.7);
    }

    public static double getMinPressPost() {
        return prefs.getDouble("minPressPost", 1.6);
    }

    public static double getMaxPressAnt() {
        return prefs.getDouble("maxPressAnt", 2.5);
    }

    public static double getMaxPressPost() {
        return prefs.getDouble("maxPressPost", 2.1);
    }

    public static void setMinTempAnt(double valore) {
        prefs.putDouble("minTempAnt", valore);
    }

    public static void setMaxTempAnt(double valore) {
        prefs.putDouble("maxTempAnt", valore);
    }

    public static void setMinTempPost(double valore) {
        prefs.putDouble("minTempPost", valore);
    }

    public static void setMaxTempPost(double valore) {
        prefs.putDouble("maxTempPost", valore);
    }

    public static void setMinPressAnt(double valore) {
        prefs.putDouble("minPressAnt", valore);
    }

    public static void setMaxPressAnt(double valore) {
        prefs.putDouble("maxPressAnt", valore);
    }

    public static void setMinPressPost(double valore) {
        prefs.putDouble("minPressPost", valore);
    }

    public static void setMaxPressPost(double valore) {
        prefs.putDouble("maxPressPost", valore);
    }

    public static double getPreferenzeSimulazioni(int opzione) {
        String chiave = "simulazioni" + opzione;
        if (opzione == 0) {
            return prefs.getDouble(chiave, 0.0);
        }
        if (opzione == 35) {
            return prefs.getDouble(chiave, 0.0);
        }
        if (opzione == 36) {
            return prefs.getDouble(chiave, 0.0);
        }
        if (opzione == 37) {
            return prefs.getDouble(chiave, 0.0);
        }
        return prefs.getDouble(chiave, 1.0);
    }

    public static void setPreferenzeSimulazioni(int opzione, double valore) {
        String chiave = "simulazioni" + opzione;
        prefs.putDouble(chiave, valore);
    }

    public static double getPreferenzeSimulazioniMemoria(int opzione, int memoria) {
        String chiave = "simulazioniOld" + memoria + "-" + opzione;
        if (opzione == 0) {
            return prefs.getDouble(chiave, 0.0);
        }
        if (opzione == 19 || opzione == 21 || opzione == 23 || opzione == 25 || opzione == 27 || opzione == 29) {
            return prefs.getDouble(chiave, 12000.0);
        }
        if (opzione == 20 || opzione == 22 || opzione == 24 || opzione == 26 || opzione == 28) {
            return prefs.getDouble(chiave, 5000.0);
        }
        return prefs.getDouble(chiave, 1.0);
    }

    public static void setPreferenzeSimulazioniMemoria(int opzione, double valore, int memoria) {
        String chiave = "simulazioniOld" + memoria + "-" + opzione;
        prefs.putDouble(chiave, valore);
    }

    public static double getPreferenzeSimulazioniMemoriaNew(int opzione, int memoria) {
        String chiave = "simulazioniNew" + memoria + "-" + opzione;
        if (opzione == 0) {
            return prefs.getDouble(chiave, 0.0);
        }
        return prefs.getDouble(chiave, 1.0);
    }

    public static void setPreferenzeSimulazioniMemoriaNew(int opzione, double valore, int memoria) {
        String chiave = "simulazioniNew" + memoria + "-" + opzione;
        prefs.putDouble(chiave, valore);
    }

    public static double getOpzioniAssiGrafico(int colonna, int canale, int modo) {
        String chiave = modo < 10 ? "AssiOpzione" + modo + canale + colonna : "AssiOpzione" + modo + "-" + canale + "-" + colonna;
        if (colonna == 9) {
            return prefs.getDouble(chiave, 0.0);
        }
        if (colonna == 10) {
            return prefs.getDouble(chiave, 1000.0);
        }
        if (colonna == 11) {
            return prefs.getDouble(chiave, 0.0);
        }
        if (colonna == 12) {
            return prefs.getDouble(chiave, 100.0);
        }
        return prefs.getDouble(chiave, 0.0);
    }

    public static double getOpzioniAssiGraficoTemporaneo(int colonna, int canale, int modo) {
        String chiave = modo < 10 ? "AssiOpzione" + modo + canale + colonna : "AssiOpzione" + modo + "-" + canale + "-" + colonna;
        if (colonna == 9) {
            return prefsTemp.getDouble(chiave, 0.0);
        }
        if (colonna == 10) {
            return prefsTemp.getDouble(chiave, 1000.0);
        }
        if (colonna == 11) {
            return prefsTemp.getDouble(chiave, 0.0);
        }
        if (colonna == 12) {
            return prefsTemp.getDouble(chiave, 100.0);
        }
        return prefsTemp.getDouble(chiave, 0.0);
    }

    public static void setMultiCanale(int index, int modo) {
        prefs.putInt("MultiSelezionato" + modo, index);
    }

    public static int getMultiCanale(int modo) {
        return prefs.getInt("MultiSelezionato" + modo, 0);
    }

    public static void setOpzioniGenerali(OpzioniGenerali opz, int modo, boolean selezionato, DanasProperties prefMode) {
        String chiave;
        switch (opz) {
            case SINGLE: {
                chiave = "single" + modo;
                break;
            }
            case DOUBLLE: {
                chiave = "double" + modo;
                break;
            }
            case MULTI: {
                chiave = "multi" + modo;
                break;
            }
            case TEMPO_SPAZIO: {
                chiave = "tempo" + modo;
                break;
            }
            case ASSE_X: {
                chiave = "asseX" + modo;
                break;
            }
            case ASSE_Y: {
                chiave = "asseY" + modo;
                break;
            }
            case AUTOSCALING: {
                chiave = "autoS" + modo;
                break;
            }
            case GRIGLIA_H: {
                chiave = "grigliaH" + modo;
                break;
            }
            case GRIGLIA_V: {
                chiave = "grigliaV" + modo;
                break;
            }
            case DIVISI: {
                chiave = "divisi" + modo;
                break;
            }
            case FFT: {
                chiave = "fft" + modo;
                break;
            }
            default: {
                chiave = "vuoto";
            }
        }
        prefMode.putBoolean(chiave, selezionato);
    }

    public static void setOpzioniGenerali(OpzioniGenerali opz, int modo, boolean selezionato) {
        String chiave;
        switch (opz) {
            case SINGLE: {
                chiave = "single" + modo;
                break;
            }
            case DOUBLLE: {
                chiave = "double" + modo;
                break;
            }
            case MULTI: {
                chiave = "multi" + modo;
                break;
            }
            case TEMPO_SPAZIO: {
                chiave = "tempo" + modo;
                break;
            }
            case ASSE_X: {
                chiave = "asseX" + modo;
                break;
            }
            case ASSE_Y: {
                chiave = "asseY" + modo;
                break;
            }
            case AUTOSCALING: {
                chiave = "autoS" + modo;
                break;
            }
            case GRIGLIA_H: {
                chiave = "grigliaH" + modo;
                break;
            }
            case GRIGLIA_V: {
                chiave = "grigliaV" + modo;
                break;
            }
            case DIVISI: {
                chiave = "divisi" + modo;
                break;
            }
            case FFT: {
                chiave = "fft" + modo;
                break;
            }
            default: {
                chiave = "vuoto";
            }
        }
        prefs.putBoolean(chiave, selezionato);
    }

    public static boolean getOpzioniGenerali(OpzioniGenerali opz, int modo) {
        switch (opz) {
            case SINGLE: {
                String chiave = "single" + modo;
                return prefs.getBoolean(chiave, true);
            }
            case DOUBLLE: {
                String chiave = "double" + modo;
                return prefs.getBoolean(chiave, false);
            }
            case MULTI: {
                String chiave = "multi" + modo;
                return prefs.getBoolean(chiave, false);
            }
            case TEMPO_SPAZIO: {
                String chiave = "tempo" + modo;
                return prefs.getBoolean(chiave, false);
            }
            case ASSE_X: {
                String chiave = "asseX" + modo;
                return prefs.getBoolean(chiave, false);
            }
            case ASSE_Y: {
                String chiave = "asseY" + modo;
                return prefs.getBoolean(chiave, false);
            }
            case AUTOSCALING: {
                String chiave = "autoS" + modo;
                return prefs.getBoolean(chiave, true);
            }
            case GRIGLIA_H: {
                String chiave = "grigliaH" + modo;
                return prefs.getBoolean(chiave, true);
            }
            case GRIGLIA_V: {
                String chiave = "grigliaV" + modo;
                return prefs.getBoolean(chiave, true);
            }
            case DIVISI: {
                String chiave = "divisi" + modo;
                return prefs.getBoolean(chiave, false);
            }
            case FFT: {
                String chiave = "fft" + modo;
                return prefs.getBoolean(chiave, false);
            }
        }
        String chiave = "vuoto";
        return prefs.getBoolean(chiave, false);
    }

    public static boolean getOpzioniGeneraliTemporaneo(OpzioniGenerali opz, int modo) {
        switch (opz) {
            case SINGLE: {
                String chiave = "single" + modo;
                return prefsTemp.getBoolean(chiave, true);
            }
            case DOUBLLE: {
                String chiave = "double" + modo;
                return prefsTemp.getBoolean(chiave, false);
            }
            case MULTI: {
                String chiave = "multi" + modo;
                return prefsTemp.getBoolean(chiave, false);
            }
            case TEMPO_SPAZIO: {
                String chiave = "tempo" + modo;
                return prefsTemp.getBoolean(chiave, false);
            }
            case ASSE_X: {
                String chiave = "asseX" + modo;
                return prefsTemp.getBoolean(chiave, false);
            }
            case ASSE_Y: {
                String chiave = "asseY" + modo;
                return prefsTemp.getBoolean(chiave, false);
            }
            case AUTOSCALING: {
                String chiave = "autoS" + modo;
                return prefsTemp.getBoolean(chiave, true);
            }
            case GRIGLIA_H: {
                String chiave = "grigliaH" + modo;
                return prefsTemp.getBoolean(chiave, true);
            }
            case GRIGLIA_V: {
                String chiave = "grigliaV" + modo;
                return prefsTemp.getBoolean(chiave, true);
            }
            case DIVISI: {
                String chiave = "divisi" + modo;
                return prefsTemp.getBoolean(chiave, false);
            }
            case FFT: {
                String chiave = "fft" + modo;
                return prefsTemp.getBoolean(chiave, false);
            }
        }
        String chiave = "vuoto";
        return prefsTemp.getBoolean(chiave, false);
    }

    public static void setDecimali(DanasDataStructureConstants.ValueType vt, int decimali, int modo) {
        prefs.putInt("numeroDecimali_" + modo + "_" + vt.ordinal(), decimali);
    }

    public static int getDecimali(DanasDataStructureConstants.ValueType vt, int modo) {
        return prefs.getInt("numeroDecimali_" + modo + "_" + vt.ordinal(), 2);
    }

    public static void setDecimaliTemporaneo(DanasDataStructureConstants.ValueType vt, int decimali, int modo) {
        prefsTemp.putInt("numeroDecimali_" + modo + "_" + vt.ordinal(), decimali);
    }

    public static int getDecimaliTemporaneo(DanasDataStructureConstants.ValueType vt, int modo) {
        return prefsTemp.getInt("numeroDecimali_" + modo + "_" + vt.ordinal(), 2);
    }

    public static double getAlarmHi(DanasDataStructureConstants.ValueType vt, int modo) {
        return prefs.getDouble("alarmHi_" + modo + "_" + vt.ordinal(), 99000.0);
    }

    public static double getAlarmLow(DanasDataStructureConstants.ValueType vt, int modo) {
        return prefs.getDouble("alarmLow_" + modo + "_" + vt.ordinal(), -99000.0);
    }

    public static void setAlarmHi(DanasDataStructureConstants.ValueType vt, int modo, double alarm) {
        prefs.putDouble("alarmHi_" + modo + "_" + vt.ordinal(), alarm);
    }

    public static void setAlarmLow(DanasDataStructureConstants.ValueType vt, int modo, double alarm) {
        prefs.putDouble("alarmLow_" + modo + "_" + vt.ordinal(), alarm);
    }

    public static double getAlarmHiTemporaneo(DanasDataStructureConstants.ValueType vt, int modo) {
        return prefsTemp.getDouble("alarmHi_" + modo + "_" + vt.ordinal(), 99000.0);
    }

    public static double getAlarmLowTemporaneo(DanasDataStructureConstants.ValueType vt, int modo) {
        return prefsTemp.getDouble("alarmLow_" + modo + "_" + vt.ordinal(), -99000.0);
    }

    public static void setAlarmHiTemporaneo(DanasDataStructureConstants.ValueType vt, int modo, double alarm) {
        prefsTemp.putDouble("alarmHi_" + modo + "_" + vt.ordinal(), alarm);
    }

    public static void setAlarmLowTemporaneo(DanasDataStructureConstants.ValueType vt, int modo, double alarm) {
        prefsTemp.putDouble("alarmLow_" + modo + "_" + vt.ordinal(), alarm);
    }

    public static void setLunghezzaFiltro(DanasDataStructureConstants.ValueType vt, int numeroPunti, int modo) {
        switch (vt) {
            case SPEED1: {
                prefs.putInt("filtroSpeed1" + modo, numeroPunti);
                break;
            }
            case SPEED2: {
                prefs.putInt("filtroSpeed2" + modo, numeroPunti);
                break;
            }
            case RPM: {
                prefs.putInt("filtroRpm" + modo, numeroPunti);
                break;
            }
            case ANALOG1: {
                prefs.putInt("filtroAnalog1" + modo, numeroPunti);
                break;
            }
            case ANALOG2: {
                prefs.putInt("filtroAnalog2" + modo, numeroPunti);
                break;
            }
            case ANALOG3: {
                prefs.putInt("filtroAnalog3" + modo, numeroPunti);
                break;
            }
            case ANALOG4: {
                prefs.putInt("filtroAnalog4" + modo, numeroPunti);
                break;
            }
            case ANALOG5: {
                prefs.putInt("filtroAnalog5" + modo, numeroPunti);
                break;
            }
            case ANALOG6: {
                prefs.putInt("filtroAnalog6" + modo, numeroPunti);
                break;
            }
            case ANALOG7: {
                prefs.putInt("filtroAnalog7" + modo, numeroPunti);
                break;
            }
            case ANALOG8: {
                prefs.putInt("filtroAnalog8" + modo, numeroPunti);
                break;
            }
            case dSPEED1: {
                prefs.putInt("filtrodSpeed1" + modo, numeroPunti);
                break;
            }
            case dSPEED2: {
                prefs.putInt("filtrodSpeed2" + modo, numeroPunti);
                break;
            }
            case dRPM: {
                prefs.putInt("filtrodRpm" + modo, numeroPunti);
                break;
            }
            case dANALOG1: {
                prefs.putInt("filtrodAnalog1" + modo, numeroPunti);
                break;
            }
            case dANALOG2: {
                prefs.putInt("filtrodAnalog2" + modo, numeroPunti);
                break;
            }
            case dANALOG3: {
                prefs.putInt("filtrodAnalog3" + modo, numeroPunti);
                break;
            }
            case dANALOG4: {
                prefs.putInt("filtrodAnalog4" + modo, numeroPunti);
                break;
            }
            case dANALOG5: {
                prefs.putInt("filtrodAnalog5" + modo, numeroPunti);
                break;
            }
            case dANALOG6: {
                prefs.putInt("filtrodAnalog6" + modo, numeroPunti);
                break;
            }
            case dANALOG7: {
                prefs.putInt("filtrodAnalog7" + modo, numeroPunti);
                break;
            }
            case dANALOG8: {
                prefs.putInt("filtrodAnalog8" + modo, numeroPunti);
                break;
            }
            case GEARS: {
                prefs.putInt("filtroGears" + modo, numeroPunti);
                break;
            }
            case R_GEARS: {
                prefs.putInt("filtroRGearsa" + modo, numeroPunti);
                break;
            }
            case SIM1: {
                prefs.putInt("filtroMath1" + modo, numeroPunti);
                break;
            }
            case SIM2: {
                prefs.putInt("filtroMath2" + modo, numeroPunti);
                break;
            }
            case MULTI: {
                prefs.putInt("filtroMulti" + modo, numeroPunti);
                break;
            }
            case MULTI2: {
                prefs.putInt("filtroMulti2" + modo, numeroPunti);
                break;
            }
            case MULTI3: {
                prefs.putInt("filtroMulti3" + modo, numeroPunti);
                break;
            }
            case MULTI4: {
                prefs.putInt("filtroMulti4" + modo, numeroPunti);
                break;
            }
            case MULTI5: {
                prefs.putInt("filtroMulti5" + modo, numeroPunti);
                break;
            }
            case MULTI6: {
                prefs.putInt("filtroMulti6" + modo, numeroPunti);
                break;
            }
            case MULTI7: {
                prefs.putInt("filtroMulti7" + modo, numeroPunti);
                break;
            }
            case MULTI8: {
                prefs.putInt("filtroMulti8" + modo, numeroPunti);
                break;
            }
            case MULTI9: {
                prefs.putInt("filtroMulti9" + modo, numeroPunti);
                break;
            }
            case MULTI10: {
                prefs.putInt("filtroMulti10" + modo, numeroPunti);
                break;
            }
            case EXT1: {
                prefs.putInt("filtroExt1" + modo, numeroPunti);
                break;
            }
            case EXT2: {
                prefs.putInt("filtroExt2" + modo, numeroPunti);
                break;
            }
            case dEXT1: {
                prefs.putInt("filtrodExt1" + modo, numeroPunti);
                break;
            }
            case dEXT2: {
                prefs.putInt("filtrodExt2" + modo, numeroPunti);
                break;
            }
            case EXT3: {
                prefs.putInt("filtroExt3" + modo, numeroPunti);
                break;
            }
            case EXT4: {
                prefs.putInt("filtroExt4" + modo, numeroPunti);
                break;
            }
            case dEXT3: {
                prefs.putInt("filtrodExt3" + modo, numeroPunti);
                break;
            }
            case dEXT4: {
                prefs.putInt("filtrodExt4" + modo, numeroPunti);
                break;
            }
            case MATH_1: {
                prefs.putInt("filtroMath-1-" + modo, numeroPunti);
                break;
            }
            case MATH_2: {
                prefs.putInt("filtroMath-2-" + modo, numeroPunti);
                break;
            }
            case MATH_3: {
                prefs.putInt("filtroMath-3-" + modo, numeroPunti);
                break;
            }
            case MATH_4: {
                prefs.putInt("filtroMath-4-" + modo, numeroPunti);
                break;
            }
            case MATH_5: {
                prefs.putInt("filtroMath-5-" + modo, numeroPunti);
                break;
            }
            case MATH_6: {
                prefs.putInt("filtroMath-6-" + modo, numeroPunti);
                break;
            }
            case MATH_7: {
                prefs.putInt("filtroMath-7-" + modo, numeroPunti);
                break;
            }
            case MATH_8: {
                prefs.putInt("filtroMath-8-" + modo, numeroPunti);
                break;
            }
            case MATH_9: {
                prefs.putInt("filtroMath-9-" + modo, numeroPunti);
                break;
            }
            case MATH_10: {
                prefs.putInt("filtroMath-10-" + modo, numeroPunti);
                break;
            }
            case HEART: {
                prefs.putInt("filtroHeart-" + modo, numeroPunti);
                break;
            }
            case VEL_GPS: {
                prefs.putInt("filtroVelGps-" + modo, numeroPunti);
                break;
            }
            case dVEL_GPS: {
                prefs.putInt("filtrodVelGps-" + modo, numeroPunti);
                break;
            }
            case ANGLE_GPS: {
                prefs.putInt("filtroAngle-" + modo, numeroPunti);
                break;
            }
            case ACC_LAT: {
                prefs.putInt("filtroAccLat-" + modo, numeroPunti);
                break;
            }
            case ALTITUDE: {
                prefs.putInt("filtroAltitude-" + modo, numeroPunti);
                break;
            }
            case DELAY: {
                prefs.putInt("filtroDelay-" + modo, numeroPunti);
                break;
            }
            case SLIP: {
                prefs.putInt("filtroSlip-" + modo, numeroPunti);
                break;
            }
            default: {
                if (vt.ordinal() < DanasDataStructureConstants.ValueType.CAN1.ordinal() || vt.ordinal() > DanasDataStructureConstants.ValueType.CAN128.ordinal()) break;
                prefs.putInt("filtro" + vt.toString() + "-" + modo, numeroPunti);
            }
        }
        DanasPreferences.cacheValori(modo);
    }

    public static void setLunghezzaFiltroTemporaneo(DanasDataStructureConstants.ValueType vt, int numeroPunti, int modo) {
        switch (vt) {
            case SPEED1: {
                prefsTemp.putInt("filtroSpeed1" + modo, numeroPunti);
                break;
            }
            case SPEED2: {
                prefsTemp.putInt("filtroSpeed2" + modo, numeroPunti);
                break;
            }
            case RPM: {
                prefsTemp.putInt("filtroRpm" + modo, numeroPunti);
                break;
            }
            case ANALOG1: {
                prefsTemp.putInt("filtroAnalog1" + modo, numeroPunti);
                break;
            }
            case ANALOG2: {
                prefsTemp.putInt("filtroAnalog2" + modo, numeroPunti);
                break;
            }
            case ANALOG3: {
                prefsTemp.putInt("filtroAnalog3" + modo, numeroPunti);
                break;
            }
            case ANALOG4: {
                prefsTemp.putInt("filtroAnalog4" + modo, numeroPunti);
                break;
            }
            case ANALOG5: {
                prefsTemp.putInt("filtroAnalog5" + modo, numeroPunti);
                break;
            }
            case ANALOG6: {
                prefsTemp.putInt("filtroAnalog6" + modo, numeroPunti);
                break;
            }
            case ANALOG7: {
                prefsTemp.putInt("filtroAnalog7" + modo, numeroPunti);
                break;
            }
            case ANALOG8: {
                prefsTemp.putInt("filtroAnalog8" + modo, numeroPunti);
                break;
            }
            case dSPEED1: {
                prefsTemp.putInt("filtrodSpeed1" + modo, numeroPunti);
                break;
            }
            case dSPEED2: {
                prefsTemp.putInt("filtrodSpeed2" + modo, numeroPunti);
                break;
            }
            case dRPM: {
                prefsTemp.putInt("filtrodRpm" + modo, numeroPunti);
                break;
            }
            case dANALOG1: {
                prefsTemp.putInt("filtrodAnalog1" + modo, numeroPunti);
                break;
            }
            case dANALOG2: {
                prefsTemp.putInt("filtrodAnalog2" + modo, numeroPunti);
                break;
            }
            case dANALOG3: {
                prefsTemp.putInt("filtrodAnalog3" + modo, numeroPunti);
                break;
            }
            case dANALOG4: {
                prefsTemp.putInt("filtrodAnalog4" + modo, numeroPunti);
                break;
            }
            case dANALOG5: {
                prefsTemp.putInt("filtrodAnalog5" + modo, numeroPunti);
                break;
            }
            case dANALOG6: {
                prefsTemp.putInt("filtrodAnalog6" + modo, numeroPunti);
                break;
            }
            case dANALOG7: {
                prefsTemp.putInt("filtrodAnalog7" + modo, numeroPunti);
                break;
            }
            case dANALOG8: {
                prefsTemp.putInt("filtrodAnalog8" + modo, numeroPunti);
                break;
            }
            case GEARS: {
                prefsTemp.putInt("filtroGears" + modo, numeroPunti);
                break;
            }
            case R_GEARS: {
                prefsTemp.putInt("filtroRGearsa" + modo, numeroPunti);
                break;
            }
            case SIM1: {
                prefsTemp.putInt("filtroMath1" + modo, numeroPunti);
                break;
            }
            case SIM2: {
                prefsTemp.putInt("filtroMath2" + modo, numeroPunti);
                break;
            }
            case MULTI: {
                prefsTemp.putInt("filtroMulti" + modo, numeroPunti);
                break;
            }
            case MULTI2: {
                prefsTemp.putInt("filtroMulti2" + modo, numeroPunti);
                break;
            }
            case MULTI3: {
                prefsTemp.putInt("filtroMulti3" + modo, numeroPunti);
                break;
            }
            case MULTI4: {
                prefsTemp.putInt("filtroMulti4" + modo, numeroPunti);
                break;
            }
            case MULTI5: {
                prefsTemp.putInt("filtroMulti5" + modo, numeroPunti);
                break;
            }
            case MULTI6: {
                prefsTemp.putInt("filtroMulti6" + modo, numeroPunti);
                break;
            }
            case MULTI7: {
                prefsTemp.putInt("filtroMulti7" + modo, numeroPunti);
                break;
            }
            case MULTI8: {
                prefsTemp.putInt("filtroMulti8" + modo, numeroPunti);
                break;
            }
            case MULTI9: {
                prefsTemp.putInt("filtroMulti9" + modo, numeroPunti);
                break;
            }
            case MULTI10: {
                prefsTemp.putInt("filtroMulti10" + modo, numeroPunti);
                break;
            }
            case EXT1: {
                prefsTemp.putInt("filtroExt1" + modo, numeroPunti);
                break;
            }
            case EXT2: {
                prefsTemp.putInt("filtroExt2" + modo, numeroPunti);
                break;
            }
            case dEXT1: {
                prefsTemp.putInt("filtrodExt1" + modo, numeroPunti);
                break;
            }
            case dEXT2: {
                prefsTemp.putInt("filtrodExt2" + modo, numeroPunti);
                break;
            }
            case EXT3: {
                prefsTemp.putInt("filtroExt3" + modo, numeroPunti);
                break;
            }
            case EXT4: {
                prefsTemp.putInt("filtroExt4" + modo, numeroPunti);
                break;
            }
            case dEXT3: {
                prefsTemp.putInt("filtrodExt3" + modo, numeroPunti);
                break;
            }
            case dEXT4: {
                prefsTemp.putInt("filtrodExt4" + modo, numeroPunti);
                break;
            }
            case MATH_1: {
                prefsTemp.putInt("filtroMath-1-" + modo, numeroPunti);
                break;
            }
            case MATH_2: {
                prefsTemp.putInt("filtroMath-2-" + modo, numeroPunti);
                break;
            }
            case MATH_3: {
                prefsTemp.putInt("filtroMath-3-" + modo, numeroPunti);
                break;
            }
            case MATH_4: {
                prefsTemp.putInt("filtroMath-4-" + modo, numeroPunti);
                break;
            }
            case MATH_5: {
                prefsTemp.putInt("filtroMath-5-" + modo, numeroPunti);
                break;
            }
            case MATH_6: {
                prefsTemp.putInt("filtroMath-6-" + modo, numeroPunti);
                break;
            }
            case MATH_7: {
                prefsTemp.putInt("filtroMath-7-" + modo, numeroPunti);
                break;
            }
            case MATH_8: {
                prefsTemp.putInt("filtroMath-8-" + modo, numeroPunti);
                break;
            }
            case MATH_9: {
                prefsTemp.putInt("filtroMath-9-" + modo, numeroPunti);
                break;
            }
            case MATH_10: {
                prefsTemp.putInt("filtroMath-10-" + modo, numeroPunti);
                break;
            }
            case HEART: {
                prefsTemp.putInt("filtroHeart-" + modo, numeroPunti);
                break;
            }
            case VEL_GPS: {
                prefsTemp.putInt("filtroVelGps-" + modo, numeroPunti);
                break;
            }
            case dVEL_GPS: {
                prefsTemp.putInt("filtrodVelGps-" + modo, numeroPunti);
                break;
            }
            case ANGLE_GPS: {
                prefsTemp.putInt("filtroAngle-" + modo, numeroPunti);
                break;
            }
            case ACC_LAT: {
                prefsTemp.putInt("filtroAccLat-" + modo, numeroPunti);
                break;
            }
            case ALTITUDE: {
                prefsTemp.putInt("filtroAltitude-" + modo, numeroPunti);
                break;
            }
            case DELAY: {
                prefsTemp.putInt("filtroDelay-" + modo, numeroPunti);
                break;
            }
            case SLIP: {
                prefsTemp.putInt("filtroSlip-" + modo, numeroPunti);
                break;
            }
            default: {
                if (vt.ordinal() < DanasDataStructureConstants.ValueType.CAN1.ordinal() || vt.ordinal() > DanasDataStructureConstants.ValueType.CAN128.ordinal()) break;
                prefsTemp.putInt("filtro" + vt.toString() + "-" + modo, numeroPunti);
            }
        }
        DanasPreferences.cacheValoriTemp(1);
    }

    public static void cacheValori(int modo) {
        DanasPreferences.valoriFiltri[0] = prefs.getInt("filtroSpeed1" + modo, 0);
        DanasPreferences.valoriFiltri[1] = prefs.getInt("filtroSpeed2" + modo, 0);
        DanasPreferences.valoriFiltri[2] = prefs.getInt("filtroRpm" + modo, 0);
        DanasPreferences.valoriFiltri[3] = prefs.getInt("filtroAnalog1" + modo, 0);
        DanasPreferences.valoriFiltri[4] = prefs.getInt("filtroAnalog2" + modo, 0);
        DanasPreferences.valoriFiltri[5] = prefs.getInt("filtroAnalog3" + modo, 0);
        DanasPreferences.valoriFiltri[6] = prefs.getInt("filtroAnalog4" + modo, 0);
        DanasPreferences.valoriFiltri[7] = prefs.getInt("filtroAnalog5" + modo, 0);
        DanasPreferences.valoriFiltri[8] = prefs.getInt("filtroAnalog6" + modo, 0);
        DanasPreferences.valoriFiltri[9] = prefs.getInt("filtroAnalog7" + modo, 0);
        DanasPreferences.valoriFiltri[10] = prefs.getInt("filtroAnalog8" + modo, 0);
        DanasPreferences.valoriFiltri[11] = prefs.getInt("filtrodSpeed1" + modo, 0);
        DanasPreferences.valoriFiltri[12] = prefs.getInt("filtrodSpeed2" + modo, 0);
        DanasPreferences.valoriFiltri[13] = prefs.getInt("filtrodRpm" + modo, 0);
        DanasPreferences.valoriFiltri[14] = prefs.getInt("filtrodAnalog1" + modo, 0);
        DanasPreferences.valoriFiltri[15] = prefs.getInt("filtrodAnalog2" + modo, 0);
        DanasPreferences.valoriFiltri[16] = prefs.getInt("filtrodAnalog3" + modo, 0);
        DanasPreferences.valoriFiltri[17] = prefs.getInt("filtrodAnalog4" + modo, 0);
        DanasPreferences.valoriFiltri[18] = prefs.getInt("filtrodAnalog5" + modo, 0);
        DanasPreferences.valoriFiltri[19] = prefs.getInt("filtrodAnalog6" + modo, 0);
        DanasPreferences.valoriFiltri[20] = prefs.getInt("filtrodAnalog7" + modo, 0);
        DanasPreferences.valoriFiltri[21] = prefs.getInt("filtrodAnalog8" + modo, 0);
        DanasPreferences.valoriFiltri[22] = prefs.getInt("filtroGears" + modo, 0);
        DanasPreferences.valoriFiltri[23] = prefs.getInt("filtroRGearsa" + modo, 0);
        DanasPreferences.valoriFiltri[24] = prefs.getInt("filtroMath1" + modo, 0);
        DanasPreferences.valoriFiltri[25] = prefs.getInt("filtroMath2" + modo, 0);
        DanasPreferences.valoriFiltri[26] = prefs.getInt("filtroMulti" + modo, 0);
        DanasPreferences.valoriFiltri[27] = prefs.getInt("filtroMulti2" + modo, 0);
        DanasPreferences.valoriFiltri[28] = prefs.getInt("filtroMulti3" + modo, 0);
        DanasPreferences.valoriFiltri[29] = prefs.getInt("filtroMulti4" + modo, 0);
        DanasPreferences.valoriFiltri[30] = prefs.getInt("filtroMulti5" + modo, 0);
        DanasPreferences.valoriFiltri[31] = prefs.getInt("filtroMulti6" + modo, 0);
        DanasPreferences.valoriFiltri[32] = prefs.getInt("filtroMulti7" + modo, 0);
        DanasPreferences.valoriFiltri[33] = prefs.getInt("filtroMulti8" + modo, 0);
        DanasPreferences.valoriFiltri[34] = prefs.getInt("filtroMulti9" + modo, 0);
        DanasPreferences.valoriFiltri[35] = prefs.getInt("filtroMulti10" + modo, 0);
        DanasPreferences.valoriFiltri[36] = prefs.getInt("filtroExt1" + modo, 0);
        DanasPreferences.valoriFiltri[37] = prefs.getInt("filtroExt2" + modo, 0);
        DanasPreferences.valoriFiltri[38] = prefs.getInt("filtrodExt1" + modo, 0);
        DanasPreferences.valoriFiltri[39] = prefs.getInt("filtrodExt2" + modo, 0);
        DanasPreferences.valoriFiltri[40] = prefs.getInt("filtroMath-1-" + modo, 0);
        DanasPreferences.valoriFiltri[41] = prefs.getInt("filtroMath-2-" + modo, 0);
        DanasPreferences.valoriFiltri[42] = prefs.getInt("filtroMath-3-" + modo, 0);
        DanasPreferences.valoriFiltri[43] = prefs.getInt("filtroMath-4-" + modo, 0);
        DanasPreferences.valoriFiltri[44] = prefs.getInt("filtroMath-5-" + modo, 0);
        DanasPreferences.valoriFiltri[45] = prefs.getInt("filtroMath-6-" + modo, 0);
        DanasPreferences.valoriFiltri[46] = prefs.getInt("filtroMath-7-" + modo, 0);
        DanasPreferences.valoriFiltri[47] = prefs.getInt("filtroMath-8-" + modo, 0);
        DanasPreferences.valoriFiltri[48] = prefs.getInt("filtroMath-9-" + modo, 0);
        DanasPreferences.valoriFiltri[49] = prefs.getInt("filtroMath-10-" + modo, 0);
        DanasPreferences.valoriFiltri[50] = prefs.getInt("filtroHeart-" + modo, 0);
        DanasPreferences.valoriFiltri[51] = prefs.getInt("filtroExt3" + modo, 0);
        DanasPreferences.valoriFiltri[52] = prefs.getInt("filtroExt4" + modo, 0);
        DanasPreferences.valoriFiltri[53] = prefs.getInt("filtrodExt3" + modo, 0);
        DanasPreferences.valoriFiltri[54] = prefs.getInt("filtrodExt4" + modo, 0);
        for (int i = 0; i < 128; ++i) {
            DanasPreferences.valoriFiltri[55 + i] = prefs.getInt("filtro" + DanasDataStructureConstants.ValueType.values()[DanasDataStructureConstants.ValueType.CAN1.ordinal() + i].toString() + "-" + modo, 0);
        }
        DanasPreferences.valoriFiltriAggiuntivi[0] = prefs.getInt("filtroVelGps-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntivi[1] = prefs.getInt("filtrodVelGps-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntivi[2] = prefs.getInt("filtroAngle-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntivi[3] = prefs.getInt("filtroAccLat-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntivi[4] = prefs.getInt("filtroAltitude-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntivi[5] = prefs.getInt("filtroDelay-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntivi[6] = prefs.getInt("filtroSlip-" + modo, 0);
    }

    public static void cacheValoriTemp(int modo) {
        DanasPreferences.valoriFiltriTemp[0] = prefsTemp.getInt("filtroSpeed1" + modo, 0);
        DanasPreferences.valoriFiltriTemp[1] = prefsTemp.getInt("filtroSpeed2" + modo, 0);
        DanasPreferences.valoriFiltriTemp[2] = prefsTemp.getInt("filtroRpm" + modo, 0);
        DanasPreferences.valoriFiltriTemp[3] = prefsTemp.getInt("filtroAnalog1" + modo, 0);
        DanasPreferences.valoriFiltriTemp[4] = prefsTemp.getInt("filtroAnalog2" + modo, 0);
        DanasPreferences.valoriFiltriTemp[5] = prefsTemp.getInt("filtroAnalog3" + modo, 0);
        DanasPreferences.valoriFiltriTemp[6] = prefsTemp.getInt("filtroAnalog4" + modo, 0);
        DanasPreferences.valoriFiltriTemp[7] = prefsTemp.getInt("filtroAnalog5" + modo, 0);
        DanasPreferences.valoriFiltriTemp[8] = prefsTemp.getInt("filtroAnalog6" + modo, 0);
        DanasPreferences.valoriFiltriTemp[9] = prefsTemp.getInt("filtroAnalog7" + modo, 0);
        DanasPreferences.valoriFiltriTemp[10] = prefsTemp.getInt("filtroAnalog8" + modo, 0);
        DanasPreferences.valoriFiltriTemp[11] = prefsTemp.getInt("filtrodSpeed1" + modo, 0);
        DanasPreferences.valoriFiltriTemp[12] = prefsTemp.getInt("filtrodSpeed2" + modo, 0);
        DanasPreferences.valoriFiltriTemp[13] = prefsTemp.getInt("filtrodRpm" + modo, 0);
        DanasPreferences.valoriFiltriTemp[14] = prefsTemp.getInt("filtrodAnalog1" + modo, 0);
        DanasPreferences.valoriFiltriTemp[15] = prefsTemp.getInt("filtrodAnalog2" + modo, 0);
        DanasPreferences.valoriFiltriTemp[16] = prefsTemp.getInt("filtrodAnalog3" + modo, 0);
        DanasPreferences.valoriFiltriTemp[17] = prefsTemp.getInt("filtrodAnalog4" + modo, 0);
        DanasPreferences.valoriFiltriTemp[18] = prefsTemp.getInt("filtrodAnalog5" + modo, 0);
        DanasPreferences.valoriFiltriTemp[19] = prefsTemp.getInt("filtrodAnalog6" + modo, 0);
        DanasPreferences.valoriFiltriTemp[20] = prefsTemp.getInt("filtrodAnalog7" + modo, 0);
        DanasPreferences.valoriFiltriTemp[21] = prefsTemp.getInt("filtrodAnalog8" + modo, 0);
        DanasPreferences.valoriFiltriTemp[22] = prefsTemp.getInt("filtroGears" + modo, 0);
        DanasPreferences.valoriFiltriTemp[23] = prefsTemp.getInt("filtroRGearsa" + modo, 0);
        DanasPreferences.valoriFiltriTemp[24] = prefsTemp.getInt("filtroMath1" + modo, 0);
        DanasPreferences.valoriFiltriTemp[25] = prefsTemp.getInt("filtroMath2" + modo, 0);
        DanasPreferences.valoriFiltriTemp[26] = prefsTemp.getInt("filtroMulti" + modo, 0);
        DanasPreferences.valoriFiltriTemp[27] = prefsTemp.getInt("filtroMulti2" + modo, 0);
        DanasPreferences.valoriFiltriTemp[28] = prefsTemp.getInt("filtroMulti3" + modo, 0);
        DanasPreferences.valoriFiltriTemp[29] = prefsTemp.getInt("filtroMulti4" + modo, 0);
        DanasPreferences.valoriFiltriTemp[30] = prefsTemp.getInt("filtroMulti5" + modo, 0);
        DanasPreferences.valoriFiltriTemp[31] = prefsTemp.getInt("filtroMulti6" + modo, 0);
        DanasPreferences.valoriFiltriTemp[32] = prefsTemp.getInt("filtroMulti7" + modo, 0);
        DanasPreferences.valoriFiltriTemp[33] = prefsTemp.getInt("filtroMulti8" + modo, 0);
        DanasPreferences.valoriFiltriTemp[34] = prefsTemp.getInt("filtroMulti9" + modo, 0);
        DanasPreferences.valoriFiltriTemp[35] = prefsTemp.getInt("filtroMulti10" + modo, 0);
        DanasPreferences.valoriFiltriTemp[36] = prefsTemp.getInt("filtroExt1" + modo, 0);
        DanasPreferences.valoriFiltriTemp[37] = prefsTemp.getInt("filtroExt2" + modo, 0);
        DanasPreferences.valoriFiltriTemp[38] = prefsTemp.getInt("filtrodExt1" + modo, 0);
        DanasPreferences.valoriFiltriTemp[39] = prefsTemp.getInt("filtrodExt2" + modo, 0);
        DanasPreferences.valoriFiltriTemp[40] = prefsTemp.getInt("filtroMath-1-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[41] = prefsTemp.getInt("filtroMath-2-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[42] = prefsTemp.getInt("filtroMath-3-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[43] = prefsTemp.getInt("filtroMath-4-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[44] = prefsTemp.getInt("filtroMath-5-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[45] = prefsTemp.getInt("filtroMath-6-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[46] = prefsTemp.getInt("filtroMath-7-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[47] = prefsTemp.getInt("filtroMath-8-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[48] = prefsTemp.getInt("filtroMath-9-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[49] = prefsTemp.getInt("filtroMath-10-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[50] = prefsTemp.getInt("filtroHeart-" + modo, 0);
        DanasPreferences.valoriFiltriTemp[51] = prefsTemp.getInt("filtroExt3" + modo, 0);
        DanasPreferences.valoriFiltriTemp[52] = prefsTemp.getInt("filtroExt4" + modo, 0);
        DanasPreferences.valoriFiltriTemp[53] = prefsTemp.getInt("filtrodExt3" + modo, 0);
        DanasPreferences.valoriFiltriTemp[54] = prefsTemp.getInt("filtrodExt4" + modo, 0);
        for (int i = 0; i < 128; ++i) {
            DanasPreferences.valoriFiltri[55 + i] = prefsTemp.getInt("filtro" + DanasDataStructureConstants.ValueType.values()[DanasDataStructureConstants.ValueType.CAN1.ordinal() + i].toString() + "-" + modo, 0);
        }
        DanasPreferences.valoriFiltriAggiuntiviTemp[0] = prefsTemp.getInt("filtroVelGps-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntiviTemp[1] = prefsTemp.getInt("filtrodVelGps-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntiviTemp[2] = prefsTemp.getInt("filtroAngle-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntiviTemp[3] = prefsTemp.getInt("filtroAccLat-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntiviTemp[4] = prefsTemp.getInt("filtroAltitude-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntiviTemp[5] = prefsTemp.getInt("filtroDelay-" + modo, 0);
        DanasPreferences.valoriFiltriAggiuntiviTemp[6] = prefsTemp.getInt("filtroSlip-" + modo, 0);
    }

    public static int getLunghezzaFiltroTemporaneo(DanasDataStructureConstants.ValueType vt) {
        switch (vt) {
            case SPEED1: {
                return valoriFiltriTemp[0];
            }
            case SPEED2: {
                return valoriFiltriTemp[1];
            }
            case RPM: {
                return valoriFiltriTemp[2];
            }
            case ANALOG1: {
                return valoriFiltriTemp[3];
            }
            case ANALOG2: {
                return valoriFiltriTemp[4];
            }
            case ANALOG3: {
                return valoriFiltriTemp[5];
            }
            case ANALOG4: {
                return valoriFiltriTemp[6];
            }
            case ANALOG5: {
                return valoriFiltriTemp[7];
            }
            case ANALOG6: {
                return valoriFiltriTemp[8];
            }
            case ANALOG7: {
                return valoriFiltriTemp[9];
            }
            case ANALOG8: {
                return valoriFiltriTemp[10];
            }
            case dSPEED1: {
                return valoriFiltriTemp[11];
            }
            case dSPEED2: {
                return valoriFiltriTemp[12];
            }
            case dRPM: {
                return valoriFiltriTemp[13];
            }
            case dANALOG1: {
                return valoriFiltriTemp[14];
            }
            case dANALOG2: {
                return valoriFiltriTemp[15];
            }
            case dANALOG3: {
                return valoriFiltriTemp[16];
            }
            case dANALOG4: {
                return valoriFiltriTemp[17];
            }
            case dANALOG5: {
                return valoriFiltriTemp[18];
            }
            case dANALOG6: {
                return valoriFiltriTemp[19];
            }
            case dANALOG7: {
                return valoriFiltriTemp[20];
            }
            case dANALOG8: {
                return valoriFiltriTemp[21];
            }
            case GEARS: {
                return valoriFiltriTemp[22];
            }
            case R_GEARS: {
                return valoriFiltriTemp[23];
            }
            case SIM1: {
                return valoriFiltriTemp[24];
            }
            case SIM2: {
                return valoriFiltriTemp[25];
            }
            case MULTI: {
                return valoriFiltriTemp[26];
            }
            case MULTI2: {
                return valoriFiltriTemp[27];
            }
            case MULTI3: {
                return valoriFiltriTemp[28];
            }
            case MULTI4: {
                return valoriFiltriTemp[29];
            }
            case MULTI5: {
                return valoriFiltriTemp[30];
            }
            case MULTI6: {
                return valoriFiltriTemp[31];
            }
            case MULTI7: {
                return valoriFiltriTemp[32];
            }
            case MULTI8: {
                return valoriFiltriTemp[33];
            }
            case MULTI9: {
                return valoriFiltriTemp[34];
            }
            case MULTI10: {
                return valoriFiltriTemp[35];
            }
            case EXT1: {
                return valoriFiltriTemp[36];
            }
            case EXT2: {
                return valoriFiltriTemp[37];
            }
            case dEXT1: {
                return valoriFiltriTemp[38];
            }
            case dEXT2: {
                return valoriFiltriTemp[39];
            }
            case MATH_1: {
                return valoriFiltriTemp[40];
            }
            case MATH_2: {
                return valoriFiltriTemp[41];
            }
            case MATH_3: {
                return valoriFiltriTemp[42];
            }
            case MATH_4: {
                return valoriFiltriTemp[43];
            }
            case MATH_5: {
                return valoriFiltriTemp[44];
            }
            case MATH_6: {
                return valoriFiltriTemp[45];
            }
            case MATH_7: {
                return valoriFiltriTemp[46];
            }
            case MATH_8: {
                return valoriFiltriTemp[47];
            }
            case MATH_9: {
                return valoriFiltriTemp[48];
            }
            case MATH_10: {
                return valoriFiltriTemp[49];
            }
            case HEART: {
                return valoriFiltriTemp[50];
            }
            case EXT3: {
                return valoriFiltriTemp[51];
            }
            case EXT4: {
                return valoriFiltriTemp[52];
            }
            case dEXT3: {
                return valoriFiltriTemp[53];
            }
            case dEXT4: {
                return valoriFiltriTemp[54];
            }
            case VEL_GPS: {
                return valoriFiltriAggiuntiviTemp[0];
            }
            case dVEL_GPS: {
                return valoriFiltriAggiuntiviTemp[1];
            }
            case ANGLE_GPS: {
                return valoriFiltriAggiuntiviTemp[2];
            }
            case ACC_LAT: {
                return valoriFiltriAggiuntiviTemp[3];
            }
            case ALTITUDE: {
                return valoriFiltriAggiuntiviTemp[4];
            }
            case DELAY: {
                return valoriFiltriAggiuntiviTemp[5];
            }
            case SLIP: {
                return valoriFiltriAggiuntiviTemp[6];
            }
        }
        if (vt.ordinal() >= DanasDataStructureConstants.ValueType.CAN1.ordinal() && vt.ordinal() <= DanasDataStructureConstants.ValueType.CAN128.ordinal()) {
            return valoriFiltri[55 + vt.ordinal() - DanasDataStructureConstants.ValueType.CAN1.ordinal()];
        }
        return 0;
    }

    public static int getLunghezzaFiltro(DanasDataStructureConstants.ValueType vt) {
        switch (vt) {
            case SPEED1: {
                return valoriFiltri[0];
            }
            case SPEED2: {
                return valoriFiltri[1];
            }
            case RPM: {
                return valoriFiltri[2];
            }
            case ANALOG1: {
                return valoriFiltri[3];
            }
            case ANALOG2: {
                return valoriFiltri[4];
            }
            case ANALOG3: {
                return valoriFiltri[5];
            }
            case ANALOG4: {
                return valoriFiltri[6];
            }
            case ANALOG5: {
                return valoriFiltri[7];
            }
            case ANALOG6: {
                return valoriFiltri[8];
            }
            case ANALOG7: {
                return valoriFiltri[9];
            }
            case ANALOG8: {
                return valoriFiltri[10];
            }
            case dSPEED1: {
                return valoriFiltri[11];
            }
            case dSPEED2: {
                return valoriFiltri[12];
            }
            case dRPM: {
                return valoriFiltri[13];
            }
            case dANALOG1: {
                return valoriFiltri[14];
            }
            case dANALOG2: {
                return valoriFiltri[15];
            }
            case dANALOG3: {
                return valoriFiltri[16];
            }
            case dANALOG4: {
                return valoriFiltri[17];
            }
            case dANALOG5: {
                return valoriFiltri[18];
            }
            case dANALOG6: {
                return valoriFiltri[19];
            }
            case dANALOG7: {
                return valoriFiltri[20];
            }
            case dANALOG8: {
                return valoriFiltri[21];
            }
            case GEARS: {
                return valoriFiltri[22];
            }
            case R_GEARS: {
                return valoriFiltri[23];
            }
            case SIM1: {
                return valoriFiltri[24];
            }
            case SIM2: {
                return valoriFiltri[25];
            }
            case MULTI: {
                return valoriFiltri[26];
            }
            case MULTI2: {
                return valoriFiltri[27];
            }
            case MULTI3: {
                return valoriFiltri[28];
            }
            case MULTI4: {
                return valoriFiltri[29];
            }
            case MULTI5: {
                return valoriFiltri[30];
            }
            case MULTI6: {
                return valoriFiltri[31];
            }
            case MULTI7: {
                return valoriFiltri[32];
            }
            case MULTI8: {
                return valoriFiltri[33];
            }
            case MULTI9: {
                return valoriFiltri[34];
            }
            case MULTI10: {
                return valoriFiltri[35];
            }
            case EXT1: {
                return valoriFiltri[36];
            }
            case EXT2: {
                return valoriFiltri[37];
            }
            case dEXT1: {
                return valoriFiltri[38];
            }
            case dEXT2: {
                return valoriFiltri[39];
            }
            case MATH_1: {
                return valoriFiltri[40];
            }
            case MATH_2: {
                return valoriFiltri[41];
            }
            case MATH_3: {
                return valoriFiltri[42];
            }
            case MATH_4: {
                return valoriFiltri[43];
            }
            case MATH_5: {
                return valoriFiltri[44];
            }
            case MATH_6: {
                return valoriFiltri[45];
            }
            case MATH_7: {
                return valoriFiltri[46];
            }
            case MATH_8: {
                return valoriFiltri[47];
            }
            case MATH_9: {
                return valoriFiltri[48];
            }
            case MATH_10: {
                return valoriFiltri[49];
            }
            case HEART: {
                return valoriFiltri[50];
            }
            case EXT3: {
                return valoriFiltri[51];
            }
            case EXT4: {
                return valoriFiltri[52];
            }
            case dEXT3: {
                return valoriFiltri[53];
            }
            case dEXT4: {
                return valoriFiltri[54];
            }
            case VEL_GPS: {
                return valoriFiltriAggiuntivi[0];
            }
            case dVEL_GPS: {
                return valoriFiltriAggiuntivi[1];
            }
            case ANGLE_GPS: {
                return valoriFiltriAggiuntivi[2];
            }
            case ACC_LAT: {
                return valoriFiltriAggiuntivi[3];
            }
            case ALTITUDE: {
                return valoriFiltriAggiuntivi[4];
            }
            case DELAY: {
                return valoriFiltriAggiuntivi[5];
            }
            case SLIP: {
                return valoriFiltriAggiuntivi[6];
            }
        }
        if (vt.ordinal() >= DanasDataStructureConstants.ValueType.CAN1.ordinal() && vt.ordinal() <= DanasDataStructureConstants.ValueType.CAN128.ordinal()) {
            return valoriFiltri[55 + vt.ordinal() - DanasDataStructureConstants.ValueType.CAN1.ordinal()];
        }
        return 0;
    }

    public static int getLunghezzaFiltroPro(double centesimi, DanasDataStructureConstants.ValueType vt) {
        int frequenza = 50;
        int dato = 0;
        dato = DanasPreferences.getLunghezzaFiltro(vt);
        switch (dato) {
            case 0: {
                frequenza = 100;
                break;
            }
            case 1: {
                frequenza = 20;
                break;
            }
            case 2: {
                frequenza = 10;
                break;
            }
            case 3: {
                frequenza = 7;
                break;
            }
            case 4: {
                frequenza = 5;
                break;
            }
            case 5: {
                frequenza = 2;
                break;
            }
            case 6: {
                frequenza = 1;
            }
        }
        if (centesimi == 0.0) {
            centesimi = 1.0;
        }
        int numeroPunti = 1;
        if (frequenza != 100) {
            numeroPunti = (int)(1.0 / (double)frequenza * 100.0 / (2.0 * centesimi));
        }
        if (numeroPunti % 2 == 0) {
            ++numeroPunti;
        }
        return numeroPunti;
    }

    public static int getPrefSpessoreLineaMappa() {
        return prefs.getInt("dimensioneLineaMappa", 2);
    }

    public static void setPrefColoreSfonfdoMappa(int rgb) {
        prefs.putInt("coloreSfondoMappa", rgb);
    }

    public static int getPrefColoreSfonfdoMappa() {
        return prefs.getInt("coloreSfondoMappa", Color.BLACK.getRGB());
    }

    public static void setPrefColoreTestoMappa(int rgb) {
        prefs.putInt("coloreTestoMappa", rgb);
    }

    public static int getPrefColoreTestoMappa() {
        return prefs.getInt("coloreTestoMappa", Color.WHITE.getRGB());
    }

    public static void setPrefDimensioneTraguardo(int size) {
        prefs.putInt("dimensioneTraguardo", size);
    }

    public static int getPrefOffsetGPS() {
        return prefs.getInt("offset GPS", -20);
    }

    public static void setPrefOffsetGPS(int offset) {
        prefs.putInt("offset GPS", offset);
    }

    public static int getPrefsetPrefDimensioneTraguardo() {
        return prefs.getInt("dimensioneTraguardo", 70);
    }

    public static void setPrefMinimoLegenda(float min) {
        prefs.putFloat("minimoLegendaMappa", min);
    }

    public static float getPrefMinimoLegenda() {
        return prefs.getFloat("minimoLegendaMappa", 0.0f);
    }

    public static void setPrefMassimoLegenda(float max) {
        prefs.putFloat("massimoLegendaMappa", max);
    }

    public static float getPrefMassimoLegenda() {
        return prefs.getFloat("massimoLegendaMappa", 1023.0f);
    }

    public static void setPrefVisibleLegenda(boolean visible) {
        prefs.putBoolean("legendaMappaVisibile", visible);
    }

    public static boolean getPrefVisibleLegenda() {
        return prefs.getBoolean("legendaMappaVisibile", true);
    }

    public static void setPrefVisibleMappa(boolean visible) {
        prefs.putBoolean("mappaVisibile", visible);
    }

    public static boolean getPrefVisibleMappa() {
        return prefs.getBoolean("mappaVisibile", true);
    }

    public static void setPrefVisibleIcone(boolean visible) {
        prefs.putBoolean("IconeVisibili", visible);
    }

    public static boolean getPrefWaterAlarm() {
        return prefs.getBoolean("waterAlarm", true);
    }

    public static void setPrefWaterAlarm(boolean selezionata) {
        prefs.putBoolean("waterAlarm", selezionata);
    }

    public static boolean getPrefAlarm1() {
        return prefs.getBoolean("attivoAlarm1", true);
    }

    public static void setPrefAlarm1(boolean selezionata) {
        prefs.putBoolean("attivoAlarm1", selezionata);
    }

    public static boolean getPrefAlarm2() {
        return prefs.getBoolean("attivoAlarm2", true);
    }

    public static void setPrefAlarm2(boolean selezionata) {
        prefs.putBoolean("attivoAlarm2", selezionata);
    }

    public static boolean getPrefBatteryAlarm() {
        return prefs.getBoolean("batteryAlarm", true);
    }

    public static void setPrefBatteryAlarm(boolean selezionata) {
        prefs.putBoolean("batteryAlarm", selezionata);
    }

    public static boolean getPrefVisibleIcone() {
        return prefs.getBoolean("IconeVisibili", true);
    }

    public static void setPrefVisibleBarraStato(boolean visible) {
        prefs.putBoolean("barraStato", visible);
    }

    public static boolean getPrefVisibleBarraStato() {
        return prefs.getBoolean("barraStato", true);
    }

    public static void setPrefTastiGiriUniti(boolean visible) {
        prefs.putBoolean("tastiGiriUniti", visible);
    }

    public static boolean getPrefTastiGiriUniti() {
        return prefs.getBoolean("tastiGiriUniti", false);
    }

    public static void setPrefMappaFuori(boolean visible) {
        prefs.putBoolean("mappaFuori", visible);
    }

    public static boolean getPrefMappaFuori() {
        return prefs.getBoolean("mappaFuori", false);
    }

    public static void setPrefVisibleTabella(boolean visible) {
        prefs.putBoolean("TabellaVisibile", visible);
    }

    public static boolean getPrefVisibleTabella() {
        return prefs.getBoolean("TabellaVisibile", true);
    }

    public static void setPrefTabellaFuori(boolean visible) {
        prefs.putBoolean("tabellaFuori", visible);
    }

    public static boolean getPrefTabellaFuori() {
        return prefs.getBoolean("tabellaFuori", true);
    }

    public static void setPrefVisibleVideo(boolean visible) {
        prefs.putBoolean("videoVisibile", visible);
    }

    public static boolean getPrefVisibleVideo() {
        return prefs.getBoolean("videoVisibile", false);
    }

    public static void setPrefTrovaTraguardi(boolean visible) {
        prefs.putBoolean("trovaTraguardi", visible);
    }

    public static boolean getPrefTrovaTraguardi() {
        return prefs.getBoolean("trovaTraguardi", true);
    }

    public static void setPrefSxDxSize(int size) {
        prefs.putInt("posizioneSplitOrizzontale", size);
    }

    public static int getPrefSxDxSize() {
        return prefs.getInt("posizioneSplitOrizzontale", 3000);
    }

    public static void setPrefSuGiuSize(int size) {
        prefs.putInt("posizioneSplitVerticale", size);
    }

    public static int getPrefSuGiuSize() {
        return prefs.getInt("posizioneSplitVerticale", 400);
    }

    public static void setPrefWidth(int size) {
        prefs.putInt("larghezzaMain", size);
    }

    public static int getPrefWidth() {
        return prefs.getInt("larghezzaMain", 1280);
    }

    public static void setPrefHeight(int size) {
        prefs.putInt("altezzaMain", size);
    }

    public static int getPrefHeight() {
        return prefs.getInt("altezzaMain", 768);
    }

    public static void setPrefDirectory(String tipo, String path) {
        prefs.put(tipo, path);
    }

    public static String getPrefDirectory(String tipo) {
        return prefs.get(tipo, null);
    }

    public static void setPrefLanguage(String lang) {
        prefs.put("language", lang);
    }

    public static String getPrefLanguage() {
        return prefs.get("language", "en");
    }

    public static void setPrefCom(String porta) {
        prefs.put("portaCom", porta);
    }

    public static String getPrefCom() {
        return prefs.get("portaCom", null);
    }

    public static void setVideoPositionX(double x) {
        prefs.putDouble("videoPositionX", x);
    }

    public static double getVideoPositionX() {
        return prefs.getDouble("videoPositionX", 100.0);
    }

    public static void setVideoPositionY(double y) {
        prefs.putDouble("videoPositionY", y);
    }

    public static double getVideoPositionY() {
        return prefs.getDouble("videoPositionY", 100.0);
    }

    public static void setVideoWidth(double width) {
        prefs.putDouble("videoWidth", width);
    }

    public static double getVideoWidth() {
        return prefs.getDouble("videoWidth", 400.0);
    }

    public static void setVideoHeight(double height) {
        prefs.putDouble("videoHeight", height);
    }

    public static double getVideoHeight() {
        return prefs.getDouble("videoHeight", 300.0);
    }

    public static void setVideoRate(float rate) {
        prefs.putFloat("videoRate", rate);
    }

    public static float getVideoRate() {
        return prefs.getFloat("videoRate", 1.0f);
    }

    public static void setVideoLoop(boolean loop) {
        prefs.putBoolean("videoLoop", loop);
    }

    public static boolean getVideoLoop() {
        return prefs.getBoolean("videoLoop", true);
    }

    public static void setVideoOriginal(boolean dimOriginale) {
        prefs.putBoolean("videoOriginal", dimOriginale);
    }

    public static boolean getVideoOriginal() {
        return prefs.getBoolean("videoOriginal", true);
    }

    public static void esporta(File f) {
        try {
            FileOutputStream osTree = new FileOutputStream(f);
            prefs.exportSubtree(osTree);
            ((OutputStream)osTree).close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public static void importa(File f) {
        System.out.println("importa da file" + f.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(f);
            prefs.importPreferences(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void importaModo(int modo, File f) {
        int i;
        try {
            FileInputStream fis = new FileInputStream(f);
            prefsTemp.importPreferences(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DanasPreferences.abilitaSalvataggio(false);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.TEMPO_SPAZIO, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.TEMPO_SPAZIO, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.FFT, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.FFT, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.SINGLE, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.SINGLE, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.DOUBLLE, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.DOUBLLE, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.MULTI, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.MULTI, 1));
        DanasPreferences.setMathName(modo, 1, DanasPreferences.getMathName(1, 1, prefsTemp));
        System.out.println("Nome math:" + DanasPreferences.getMathName(1, 1, prefsTemp));
        DanasPreferences.setMathName(modo, 2, DanasPreferences.getMathName(1, 2, prefsTemp));
        DanasPreferences.setPreferenzaSimulazione(DanasPreferences.getPreferenzaSimulazione(1, prefsTemp), modo);
        DanasPreferences.setPrefXyVisibile(DanasPreferences.getPrefXyVisibile(1, prefsTemp), modo);
        DanasPreferences.setPrefModoXy(DanasPreferences.getPrefModoXy(1, prefsTemp), modo);
        for (i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            DanasPreferences.setPrefPosizioneCanale(i, DanasPreferences.getPrefPosizioneCanale(i, 1, prefsTemp), modo);
        }
        DanasPreferences.setRiassuntoIstogrammi(modo, DanasPreferences.getRiassuntoIstogrammi(1, prefsTemp));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.ASSE_X, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.ASSE_X, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.ASSE_Y, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.ASSE_Y, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.AUTOSCALING, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.AUTOSCALING, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.GRIGLIA_H, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.GRIGLIA_H, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.GRIGLIA_V, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.GRIGLIA_V, 1));
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.DIVISI, modo, DanasPreferences.getOpzioniGeneraliTemporaneo(OpzioniGenerali.DIVISI, 1));
        DanasPreferences.setOpzioneSfondo(modo, DanasPreferences.getOpzioneSfondo(1, prefsTemp));
        DanasPreferences.setOpzioneCampionatura(modo, DanasPreferences.getOpzioneCampionatura(1, prefsTemp));
        for (i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            DanasPreferences.setOpzioniComboGrafico(0, i, modo, DanasPreferences.getOpzioniComboGraficoTemporaneo(0, i, 1));
            DanasPreferences.setOpzioniGrafico(1, i, modo, DanasPreferences.getOpzioniGraficoTemporaneo(1, i, 1));
            DanasPreferences.setOpzioniGrafico(2, i, modo, DanasPreferences.getOpzioniGraficoTemporaneo(2, i, 1));
            DanasPreferences.setOpzioniGrafico(3, i, modo, DanasPreferences.getOpzioniGraficoTemporaneo(3, i, 1));
            DanasPreferences.setOpzioniComboGrafico(6, i, modo, DanasPreferences.getOpzioniComboGraficoTemporaneo(6, i, 1));
            DanasPreferences.setOpzioniComboGrafico(7, i, modo, DanasPreferences.getOpzioniComboGraficoTemporaneo(7, i, 1));
            DanasPreferences.setOpzioniComboGrafico(8, i, modo, DanasPreferences.getOpzioniComboGraficoTemporaneo(8, i, 1));
            DanasPreferences.setOpzioniAssiGrafico(9, i, modo, DanasPreferences.getOpzioniAssiGraficoTemporaneo(9, i, 1));
            DanasPreferences.setOpzioniAssiGrafico(10, i, modo, DanasPreferences.getOpzioniAssiGraficoTemporaneo(10, i, 1));
            DanasPreferences.setOpzioniAssiGrafico(11, i, modo, DanasPreferences.getOpzioniAssiGraficoTemporaneo(11, i, 1));
            DanasPreferences.setOpzioniAssiGrafico(12, i, modo, DanasPreferences.getOpzioniAssiGraficoTemporaneo(12, i, 1));
            DanasPreferences.setOpzioniComboGrafico(13, i, modo, DanasPreferences.getOpzioniComboGraficoTemporaneo(13, i, 1));
            DanasPreferences.setOpzioniAssiGrafico(14, i, modo, DanasPreferences.getOpzioniAssiGraficoTemporaneo(14, i, 1));
            DanasPreferences.setLunghezzaFiltro(MeasuresUtil.getValueType(i), DanasPreferences.getLunghezzaFiltroTemporaneo(MeasuresUtil.getValueType(i)), modo);
            DanasPreferences.setDecimali(MeasuresUtil.getValueType(i), DanasPreferences.getDecimaliTemporaneo(MeasuresUtil.getValueType(i), 1), modo);
            DanasPreferences.setAlarmLow(MeasuresUtil.getValueType(i), modo, DanasPreferences.getAlarmLowTemporaneo(MeasuresUtil.getValueType(i), 1));
            DanasPreferences.setAlarmHi(MeasuresUtil.getValueType(i), modo, DanasPreferences.getAlarmHiTemporaneo(MeasuresUtil.getValueType(i), 1));
        }
        DanasPreferences.abilitaSalvataggio(true);
    }

    public static void esportaModo(int modo, File f) {
        DanasPreferences.abilitaSalvataggioTemporaneo(false);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.TEMPO_SPAZIO, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.TEMPO_SPAZIO, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.FFT, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.FFT, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.SINGLE, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.SINGLE, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.DOUBLLE, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.DOUBLLE, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.MULTI, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.MULTI, modo), prefsTemp);
        DanasPreferences.setMathName(1, 1, DanasPreferences.getMathName(modo, 1), prefsTemp);
        DanasPreferences.setMathName(1, 2, DanasPreferences.getMathName(modo, 2), prefsTemp);
        DanasPreferences.setPreferenzaSimulazione(DanasDataStructure.getInstance().getSimulazioneMarcieAttiva(), 1, prefsTemp);
        DanasPreferences.setPrefXyVisibile(DanasPreferences.getPrefXyVisibile(modo), 1, prefsTemp);
        DanasPreferences.setPrefModoXy(DanasPreferences.getPrefModoXy(modo), 1, prefsTemp);
        DanasPreferences.setRiassuntoIstogrammi(1, DanasPreferences.getRiassuntoIstogrammi(modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.ASSE_X, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.ASSE_X, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.ASSE_Y, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.ASSE_Y, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.AUTOSCALING, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.AUTOSCALING, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.GRIGLIA_H, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.GRIGLIA_H, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.GRIGLIA_V, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.GRIGLIA_V, modo), prefsTemp);
        DanasPreferences.setOpzioniGenerali(OpzioniGenerali.DIVISI, 1, DanasPreferences.getOpzioniGenerali(OpzioniGenerali.DIVISI, modo), prefsTemp);
        DanasPreferences.setOpzioneSfondo(1, DanasPreferences.getOpzioneSfondo(modo), prefsTemp);
        DanasPreferences.setOpzioneCampionatura(1, DanasPreferences.getOpzioneCampionatura(modo), prefsTemp);
        for (int i = 0; i < MeasuresUtil.getNumeroCurve(); ++i) {
            DanasPreferences.setOpzioniComboGraficoTemporaneo(0, i, 1, DanasPreferences.getOpzioniComboGrafico(0, i, modo));
            DanasPreferences.setOpzioniGraficoTemporaneo(1, i, 1, DanasPreferences.getOpzioniGrafico(1, i, modo));
            DanasPreferences.setOpzioniGraficoTemporaneo(2, i, 1, DanasPreferences.getOpzioniGrafico(2, i, modo));
            DanasPreferences.setOpzioniGraficoTemporaneo(3, i, 1, DanasPreferences.getOpzioniGrafico(3, i, modo));
            DanasPreferences.setOpzioniComboGraficoTemporaneo(6, i, 1, DanasPreferences.getOpzioniComboGrafico(6, i, modo));
            DanasPreferences.setOpzioniComboGraficoTemporaneo(7, i, 1, DanasPreferences.getOpzioniComboGrafico(7, i, modo));
            DanasPreferences.setOpzioniComboGraficoTemporaneo(8, i, 1, DanasPreferences.getOpzioniComboGrafico(8, i, modo));
            DanasPreferences.setOpzioniAssiGraficoTemporaneo(9, i, 1, DanasPreferences.getOpzioniAssiGrafico(9, i, modo));
            DanasPreferences.setOpzioniAssiGraficoTemporaneo(10, i, 1, DanasPreferences.getOpzioniAssiGrafico(10, i, modo));
            DanasPreferences.setOpzioniAssiGraficoTemporaneo(11, i, 1, DanasPreferences.getOpzioniAssiGrafico(11, i, modo));
            DanasPreferences.setOpzioniAssiGraficoTemporaneo(12, i, 1, DanasPreferences.getOpzioniAssiGrafico(12, i, modo));
            DanasPreferences.setOpzioniComboGraficoTemporaneo(13, i, 1, DanasPreferences.getOpzioniComboGrafico(13, i, modo));
            DanasPreferences.setOpzioniAssiGraficoTemporaneo(14, i, 1, DanasPreferences.getOpzioniAssiGrafico(14, i, modo));
            DanasPreferences.setLunghezzaFiltroTemporaneo(MeasuresUtil.getValueType(i), DanasPreferences.getLunghezzaFiltro(MeasuresUtil.getValueType(i)), 1);
            DanasPreferences.setDecimaliTemporaneo(MeasuresUtil.getValueType(i), DanasPreferences.getDecimali(MeasuresUtil.getValueType(i), modo), 1);
            DanasPreferences.setAlarmLowTemporaneo(MeasuresUtil.getValueType(i), 1, DanasPreferences.getAlarmLow(MeasuresUtil.getValueType(i), modo));
            DanasPreferences.setAlarmHiTemporaneo(MeasuresUtil.getValueType(i), 1, DanasPreferences.getAlarmHiTemporaneo(MeasuresUtil.getValueType(i), modo));
        }
        DanasPreferences.abilitaSalvataggioTemporaneo(true);
        try {
            FileOutputStream osTree = new FileOutputStream(f);
            prefsTemp.exportSubtree(osTree);
            ((OutputStream)osTree).close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public static void resetAll() {
        prefs.clear();
    }

    public static enum OpzioniGenerali {
        SINGLE,
        DOUBLLE,
        MULTI,
        TEMPO_SPAZIO,
        DIVISI,
        ASSE_X,
        ASSE_Y,
        AUTOSCALING,
        SFONDO,
        GRIGLIA_H,
        GRIGLIA_V,
        MULTI_CH,
        FFT;

    }
}

