/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import no.geosoft.cc.geometry.Geometry;

public class GWorldExtent {
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    double[] w0_ = new double[3];
    double[] w1_ = new double[3];
    double[] w2_ = new double[3];

    GWorldExtent(double[] w0, double[] w1, double[] w2) {
        this.set(w0, w1, w2);
    }

    GWorldExtent() {
        this(new double[]{0.0, 0.0, 0.0}, new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 1.0, 0.0});
    }

    GWorldExtent(GWorldExtent worldExtent) {
        this(worldExtent.get(0), worldExtent.get(1), worldExtent.get(2));
    }

    void set(double[] w0, double[] w1, double[] w2) {
        for (int i = 0; i < 3; ++i) {
            this.w0_[i] = w0[i];
            this.w1_[i] = w1[i];
            this.w2_[i] = w2[i];
        }
    }

    public double[] get(int index) {
        switch (index) {
            case 0: {
                return this.w0_;
            }
            case 1: {
                return this.w1_;
            }
            case 2: {
                return this.w2_;
            }
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    void resize(double dx, double dy) {
        double newWidth = this.getWidth() * dx;
        double newHeight = this.getHeight() * dy;
        this.extendWidth(newWidth);
        this.extendHeight(newHeight);
    }

    boolean isXyPlane() {
        return this.w0_[2] == this.w1_[2] && this.w0_[2] == this.w2_[2];
    }

    boolean isXzPlane() {
        return this.w0_[1] == this.w1_[1] && this.w0_[1] == this.w2_[1];
    }

    boolean isYzPlane() {
        return this.w0_[0] == this.w1_[0] && this.w0_[0] == this.w2_[0];
    }

    public double getWidth() {
        return Geometry.length(this.w0_, this.w1_);
    }

    public double getHeight() {
        return Geometry.length(this.w0_, this.w2_);
    }

    void extendWidth(double newWidth) {
        double[] oldW0 = new double[]{this.w0_[0], this.w0_[1], this.w0_[2]};
        Geometry.extendLine(this.w0_, this.w1_, newWidth, 0.5);
        double dx = this.w0_[0] - oldW0[0];
        double dy = this.w0_[1] - oldW0[1];
        double dz = this.w0_[2] - oldW0[2];
        this.w2_[0] = this.w2_[0] + dx;
        this.w2_[1] = this.w2_[1] + dy;
        this.w2_[2] = this.w2_[2] + dz;
    }

    void extendHeight(double newHeight) {
        double[] oldW0 = new double[]{this.w0_[0], this.w0_[1], this.w0_[2]};
        Geometry.extendLine(this.w0_, this.w2_, newHeight, 0.5);
        double dx = this.w0_[0] - oldW0[0];
        double dy = this.w0_[1] - oldW0[1];
        double dz = this.w0_[2] - oldW0[2];
        this.w1_[0] = this.w1_[0] + dx;
        this.w1_[1] = this.w1_[1] + dy;
        this.w1_[2] = this.w1_[2] + dz;
    }
}

