/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import no.geosoft.cc.geometry.Geometry;
import no.geosoft.cc.geometry.Rect;
import no.geosoft.cc.geometry.Region;
import no.geosoft.cc.graphics.GCanvas;
import no.geosoft.cc.graphics.GInteraction;
import no.geosoft.cc.graphics.GObject;
import no.geosoft.cc.graphics.GScene;
import no.geosoft.cc.graphics.GViewport;

public class GWindow {
    public static final int ABORT = 1;
    public static final int MOTION = 2;
    public static final int BUTTON1_DOWN = 3;
    public static final int BUTTON1_DRAG = 4;
    public static final int BUTTON1_UP = 5;
    public static final int BUTTON1_DOUBLE_CLICK = 6;
    public static final int BUTTON2_DOWN = 7;
    public static final int BUTTON2_DRAG = 8;
    public static final int BUTTON2_UP = 9;
    public static final int BUTTON2_DOUBLE_CLICK = 10;
    public static final int BUTTON3_DOWN = 11;
    public static final int BUTTON3_DRAG = 12;
    public static final int BUTTON3_UP = 13;
    public static final int BUTTON3_DOUBLE_CLICK = 14;
    public static final int FOCUS_IN = 15;
    public static final int FOCUS_OUT = 16;
    private final GCanvas canvas_ = new GCanvas(this);
    private int width_;
    private int height_;
    private GInteraction interaction_;
    private List scenes_;
    private GScene interactionScene_;
    private Region damageRegion_;

    public GWindow(Color backgroundColor) {
        if (backgroundColor != null) {
            this.canvas_.setBackground(backgroundColor);
        }
        this.interaction_ = null;
        this.scenes_ = new ArrayList();
        this.damageRegion_ = new Region();
        this.width_ = 100;
        this.height_ = 100;
    }

    public GWindow() {
        this(null);
    }

    public Component getCanvas() {
        return this.canvas_;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    GInteraction getInteraction() {
        return this.interaction_;
    }

    void addScene(GScene scene) {
        this.scenes_.add(scene);
    }

    public List getScenes() {
        return this.scenes_;
    }

    public GScene getScene() {
        return this.scenes_.size() > 0 ? (GScene)this.scenes_.get(0) : null;
    }

    private GScene getScene(int x, int y) {
        for (int i = this.scenes_.size() - 1; i >= 0; --i) {
            GScene scene = (GScene)this.scenes_.get(i);
            GViewport viewport = scene.getViewport();
            if (!Geometry.isPointInsidePolygon(new int[]{viewport.getX0(), viewport.getX1(), viewport.getX3(), viewport.getX2()}, new int[]{viewport.getY0(), viewport.getY1(), viewport.getY3(), viewport.getY2()}, x, y)) continue;
            return scene;
        }
        return null;
    }

    public GObject find(String name) {
        for (GScene scene : this.scenes_) {
            GObject object = scene.find(name);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public GObject find(Object userData) {
        for (GScene scene : this.scenes_) {
            GObject object = scene.find(userData);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    Region getDamageRegion() {
        return this.damageRegion_;
    }

    void updateDamageArea(Region region) {
        this.damageRegion_.union(region);
        if (this.damageRegion_.getNRectangles() > 100) {
            this.damageRegion_.collapse();
        }
    }

    void updateDamageArea(Rect rectangle) {
        this.updateDamageArea(new Region(rectangle));
    }

    public void startInteraction(GInteraction interaction) {
        if (this.interaction_ != null) {
            this.stopInteraction();
        }
        this.interaction_ = interaction;
        this.interactionScene_ = null;
    }

    public void stopInteraction() {
        if (this.interaction_ == null) {
            return;
        }
        this.interaction_.event(null, 1, 0, 0);
        this.interaction_ = null;
        this.interactionScene_ = null;
    }

    void computeRegion() {
        int visibilityMask = 7;
        for (GScene scene : this.scenes_) {
            scene.computeRegion(visibilityMask);
        }
    }

    public void redraw() {
        int visibilityMask = 15;
        for (GScene scene : this.scenes_) {
            scene.redraw(visibilityMask);
        }
    }

    public void refresh() {
        int visibilityMask = 15;
        boolean isAnnotationUpdated = false;
        for (GScene scene : this.scenes_) {
            if (scene.isAnnotationValid()) continue;
            isAnnotationUpdated = true;
            break;
        }
        if (!isAnnotationUpdated && this.damageRegion_.isEmpty()) {
            return;
        }
        this.computeTextPositions();
        this.computeComponentPositions();
        this.computeRegion();
        Region viewportRegion = new Region();
        for (GScene scene : this.scenes_) {
            viewportRegion.union(scene.getRegion());
        }
        this.damageRegion_.intersect(viewportRegion);
        this.canvas_.setClipArea(this.damageRegion_);
        this.canvas_.clear(this.damageRegion_.getExtent());
        Region allDamage = new Region(this.damageRegion_);
        for (GScene scene : this.scenes_) {
            this.damageRegion_ = Region.intersect(allDamage, scene.getRegion());
            this.canvas_.setClipArea(this.damageRegion_);
            scene.refreshData(visibilityMask);
        }
        for (GScene scene : this.scenes_) {
            this.damageRegion_ = Region.intersect(allDamage, scene.getRegion());
            this.canvas_.setClipArea(this.damageRegion_);
            scene.refreshAnnotation(visibilityMask);
        }
        for (GScene scene : this.scenes_) {
            this.damageRegion_ = Region.intersect(allDamage, scene.getRegion());
            this.canvas_.setClipArea(this.damageRegion_);
            scene.refreshComponents(visibilityMask);
        }
        this.canvas_.refresh();
        this.damageRegion_.clear();
    }

    void computeTextPositions() {
        for (GScene scene : this.scenes_) {
            if (scene.isAnnotationValid()) continue;
            scene.computeTextPositions();
        }
    }

    void computeComponentPositions() {
        for (GScene scene : this.scenes_) {
            scene.computeComponentPositions();
        }
    }

    void mouseEntered(int x, int y) {
        if (this.interaction_ == null) {
            return;
        }
        this.interaction_.event(this.getScene(x, y), 15, x, y);
    }

    void mouseExited(int x, int y) {
        if (this.interaction_ == null) {
            return;
        }
        this.interaction_.event(this.getScene(x, y), 16, x, y);
    }

    void mousePressed(int buttonEvent, int x, int y) {
        if (this.interaction_ == null) {
            return;
        }
        this.interactionScene_ = this.getScene(x, y);
        this.interaction_.event(this.interactionScene_, buttonEvent, x, y);
    }

    void mouseReleased(int buttonEvent, int x, int y) {
        if (this.interaction_ == null) {
            return;
        }
        this.interaction_.event(this.interactionScene_, buttonEvent, x, y);
    }

    void mouseDragged(int buttonEvent, int x, int y) {
        if (this.interaction_ == null) {
            return;
        }
        this.interaction_.event(this.interactionScene_, buttonEvent, x, y);
    }

    void mouseMoved(int x, int y) {
        if (this.interaction_ == null) {
            return;
        }
        this.interaction_.event(this.getScene(x, y), 2, x, y);
    }

    void resize() {
        int width = this.canvas_.getWidth();
        int height = this.canvas_.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        double dx = (double)width / (double)this.width_;
        double dy = (double)height / (double)this.height_;
        this.width_ = width;
        this.height_ = height;
        this.damageRegion_.clear();
        Rect allWindow = new Rect(0, 0, this.width_, this.height_);
        this.damageRegion_.union(allWindow);
        for (GScene scene : this.scenes_) {
            scene.resize(dx, dy);
        }
        this.redraw();
        this.refresh();
    }

    public boolean print() {
        boolean isOk = this.canvas_.print();
        return isOk;
    }

    public void saveAsGif(File file) throws IOException {
        this.canvas_.saveAsGif(file);
    }

    public void saveAsJpg(File file) throws IOException {
        this.canvas_.save(file, "jpg");
    }

    public void saveAsPng(File file) throws IOException {
        this.canvas_.save(file, "png");
    }
}

