/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.graphics;

import no.geosoft.cc.geometry.Geometry;

public class GViewport {
    private static final int X = 0;
    private static final int Y = 1;
    private final int[] p0_ = new int[2];
    private final int[] p1_ = new int[2];
    private final int[] p2_ = new int[2];

    GViewport() {
        this.set(0, 0, 0, 0, 0, 0);
    }

    GViewport(int x0, int y0, int width, int height) {
        this.set(x0, y0, x0 + width, y0, x0, y0 + height);
    }

    GViewport(int x0, int y0, int x1, int y1, int x2, int y2) {
        this.set(x0, y0, x1, y1, x2, y2);
    }

    void set(int x0, int y0, int x1, int y1, int x2, int y2) {
        this.p0_[0] = x0;
        this.p0_[1] = y0;
        this.p1_[0] = x1;
        this.p1_[1] = y1;
        this.p2_[0] = x2;
        this.p2_[1] = y2;
    }

    int[] get(int index) {
        switch (index) {
            case 0: {
                return this.p0_;
            }
            case 1: {
                return this.p1_;
            }
            case 2: {
                return this.p2_;
            }
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    void resize(double dx, double dy) {
        this.p0_[0] = (int)Math.round((double)this.p0_[0] * dx);
        this.p0_[1] = (int)Math.round((double)this.p0_[1] * dy);
        this.p1_[0] = (int)Math.round((double)this.p1_[0] * dx);
        this.p1_[1] = (int)Math.round((double)this.p1_[1] * dy);
        this.p2_[0] = (int)Math.round((double)this.p2_[0] * dx);
        this.p2_[1] = (int)Math.round((double)this.p2_[1] * dy);
    }

    public int getX0() {
        return this.p0_[0];
    }

    public int getY0() {
        return this.p0_[1];
    }

    public int getX1() {
        return this.p1_[0];
    }

    public int getY1() {
        return this.p1_[1];
    }

    public int getX2() {
        return this.p2_[0];
    }

    public int getY2() {
        return this.p2_[1];
    }

    public int getX3() {
        return this.p2_[0] + this.p1_[0] - this.p0_[0];
    }

    public int getY3() {
        return this.p1_[1] + this.p2_[1] - this.p0_[1];
    }

    int[] getP0() {
        return this.p0_;
    }

    int[] getP1() {
        return this.p1_;
    }

    int[] getP2() {
        return this.p2_;
    }

    public double getWidth() {
        return Geometry.length(this.p0_[0], this.p0_[1], this.p1_[0], this.p1_[1]);
    }

    public double getHeight() {
        return Geometry.length(this.p0_[0], this.p0_[1], this.p2_[0], this.p2_[1]);
    }

    boolean isSkewed() {
        return this.p0_[0] != this.p2_[0] || this.p0_[1] != this.p1_[1];
    }

    double getShearFactorX() {
        return (double)(this.p2_[0] - this.p0_[0]) / (double)(this.p2_[1] - this.p0_[1]);
    }

    double getShearFactorY() {
        return (double)(this.p1_[1] - this.p0_[1]) / (double)(this.p1_[0] - this.p0_[0]);
    }

    public double getCenterX() {
        return (double)this.p2_[0] + (double)(this.p1_[0] - this.p0_[0]) / 2.0;
    }

    public double getCenterY() {
        return (double)this.p1_[1] + (double)(this.p2_[1] - this.p0_[1]) / 2.0;
    }
}

